// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IPROFILE1D_H
#define AIDA_IPROFILE1D_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include "AIDA/IProfile.h"

namespace AIDA {

class IAxis;

/**
 * User level interface to a 1-dimensional profile histogram
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
class IProfile1D : virtual public IProfile {

public: 
    /// Destructor.
    virtual ~IProfile1D() { /* nop */; }

    /**
     * Fill the IProfile1D.
     *
     */
    virtual bool fill(double x, double y, double weight = 1) = 0;

    /**
     * The weighted mean of the corresponding bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The mean of the corresponding bin along the x axis.
     *
     */
    virtual double binMean(int index) const = 0;

    /**
     * Number of entries in the corresponding bin (ie the number of times fill was called for this bin).
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    virtual int binEntries(int index) const = 0;

    /**
     * Total height of the corresponding bin (ie the sum of the weights in this bin).
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    virtual double binHeight(int index) const = 0;

    /**
     * The error on this bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    virtual double binError(int index) const = 0;

    /**
     * The spread (RMS) of a bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     *
     */
    virtual double binRms(int index) const = 0;

    /**
     * Returns the mean of the whole profile as calculated on filling-time.
     */
    virtual double mean() const = 0;

    /**
     * Returns the rms of the whole profile as calculated on filling-time.
     */
    virtual double rms() const = 0;

    /**
     * Returns the X axis.
     */
    virtual const IAxis & axis() const = 0;

    /**
     * Convenience method, equivalent to <tt>axis().coordToIndex(coord)</tt>.
     * @see IAxis#coordToIndex(double)
     */
    virtual int coordToIndex(double coord) const = 0;

    /**
     * Modifies this IProfile1D by adding the contents of profile to it.
     *
     * @param profile The IProfile1D to be added to this IProfile1D
     * @return false if profile binnings are incompatible
     */
    virtual bool add(const IProfile1D & profile) = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IPROFILE1D_H */
