// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_ICLOUD2D_H
#define AIDA_ICLOUD2D_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <vector>

#include "AIDA/ICloud.h"

namespace AIDA {

class IHistogram2D;

/**
 * User level interface to a 2D Cloud.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
class ICloud2D : virtual public ICloud {

public: 
    /// Destructor.
    virtual ~ICloud2D() { /* nop */; }

    /**
     * Fill the ICloud2D with a couple of values and a corresponding weight.
     * @param x      The x value.
     * @param y      The y value.
     * @param weight The corresponding weight. By default it is 1.
     * @return false If the ICloud2D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    virtual bool fill(double x, double y, double weight = 1.) = 0;

    /**
     * Get the lower edge of the ICloud2D along the x axis.
     * @return The lower edge along the x axis.
     *
     */
    virtual double lowerEdgeX() const = 0;

    /**
     * Get the lower edge of the ICloud2D along the y axis.
     * @return The lower edge along the y axis.
     *
     */
    virtual double lowerEdgeY() const = 0;

    /**
     * Get the upper edge of the ICloud2D along the x axis.
     * @return The upper edge along the x axis.
     *
     */
    virtual double upperEdgeX() const = 0;

    /**
     * Get the upper edge of the ICloud2D along the y axis.
     * @return The upper edge along the y axis.
     *
     */
    virtual double upperEdgeY() const = 0;

    /**
     * Get the x value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The x value of the index-th entry.
     *              If the ICloud2D has already been converted, 0 is returned. 
     *
     */
      
           
       
                                                      
                                      
                                                      
                                                                                         
      
       
      
    virtual double valueX(int index) const = 0;

    /**
     * Get the y value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The y value of the index-th entry.
     *              If the ICloud2D has already been converted, 0 is returned. 
     *
     */
      
           
       
                                                      
                                      
                                                      
                                                                                         
      
       
      
    virtual double valueY(int index) const = 0;

    /**
     * Get the weight corresponding to a given entry.
     * @param index The entry's index.
     * @return      The weight of the index-th entry.
     *              If the ICloud2D has already been converted, 0 is returned. 
     *
     */
      
           
       
                                                     
                                      
                                                     
                                                                                       
      
       
      
    virtual double weight(int index) const = 0;

    /**
     * Get the mean of the ICloud2D along the x axis.
     * @return The mean along the x axis.
     *
     */
    virtual double meanX() const = 0;

    /**
     * Get the mean of the ICloud2D along the y axis.
     * @return The mean along the y axis.
     *
     */
    virtual double meanY() const = 0;

    /**
     * Get the RMS of the ICloud2D along the x axis.
     * @return The RMS along the x axis.
     *
     */
    virtual double rmsX() const = 0;

    /**
     * Get the RMS of the ICloud2D along the y axis.
     * @return The RMS along the y axis.
     *
     */
    virtual double rmsY() const = 0;

    /**
     * Convert internally the ICloud2D to an IHistogram2D 
     * with given number of bins, upper edge and lower edge.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of bins of the x axis.
     * @param upperEdgeX The upper edge of bins of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of bins of the y axis.
     * @param upperEdgeY The upper edge of bins of the y axis.
     * @return false If the ICloud2D has already been converted.
     *
     */
    virtual bool convert(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) = 0;

    /**
     * Convert internally the ICloud2D to an IHistogram2D 
     * with given bin edges.
     * @param binEdgesX The bins edges of the x axis.
     * @param binEdgesY The bins edges of the y axis.
     * @return false If the ICloud2D has already been converted.
     *
     */
    virtual bool convert(const std::vector<double>  & binEdgesX, const std::vector<double>  & binEdgesY) = 0;

    /**     
     * Get the internal IHistogram2D in which the ICloud2D converted to.
     * @return The histogram.
     *                          or because of a convert() method invocation.
     *
     */
    virtual const IHistogram2D & histogram() const = 0;

    /**
     * Project the ICloud2D on an IHistogram2D.
     * @param hist The IHistogram2D to be filled.
     * @return false If the ICloud2D is already converted.
     *
     */
    virtual bool fillHistogram(IHistogram2D & hist) const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_ICLOUD2D_H */
