/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;
import junit.framework.Assert;

public class TestFunctions
extends AidaTestCase {
    IAnalysisFactory analysisFactory = null;
    ITreeFactory treeFactory = null;
    ITree tree = null;
    IHistogramFactory histogramFactory = null;
    IFunctionFactory functionFactory = null;
    String newName = null;
    IHistogram1D h = null;
    IModelFunction f1 = null;
    IModelFunction f2 = null;
    boolean debug = true;
    int nEntries = 0;
    int xBins = 0;
    int nRep = 0;
    double xmin = 0.0;
    double xmax = 0.0;
    double ymin = 0.0;
    double ymax = 0.0;
    double[] var = null;
    double[] par = null;
    Random r = null;

    public TestFunctions(String testName) {
        super(testName);
    }

    public void testTestFunctions1D() {
        String type = null;
        this.r = this.getRandomNumberGenerator();
        this.init();
        this.par = new double[2];
        this.par[0] = 1.2;
        this.par[1] = -0.5;
        this.nRep = 1000;
        type = "E";
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-1", type);
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-2", type.toLowerCase());
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[1];
        this.par[0] = -0.5;
        this.f1.normalize(true);
        this.f2.normalize(true);
        this.f1.excludeNormalizationAll();
        this.f1.normalizationRange(0).include(this.xmin, this.xmax);
        this.f2.excludeNormalizationAll();
        this.f2.normalizationRange(0).include(this.xmin, this.xmax);
        this.newName = "Exponential: exponent=" + this.par[0];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, true);
        this.par = new double[2];
        this.par[0] = 1.2;
        this.par[1] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Exponential: amplitude=" + this.par[0] + ",  exponent=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.nRep = 1000;
        type = "P2";
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-2", "P2");
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("P-function-1", "p2");
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[2];
        this.par[0] = 5.5;
        this.par[1] = -0.5;
        this.f1.normalize(true);
        this.f2.normalize(true);
        this.f1.excludeNormalizationAll();
        this.f1.normalizationRange(0).include(this.xmin, this.xmax);
        this.f2.excludeNormalizationAll();
        this.f2.normalizationRange(0).include(this.xmin, this.xmax);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, true);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Polynomial: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.75;
        this.par[1] = -0.71;
        this.par[2] = 0.987;
        this.nRep = 1000;
        type = "G";
        this.f1 = (IModelFunction)this.functionFactory.createFunctionByName("G-function-1", type);
        this.f2 = (IModelFunction)this.functionFactory.createFunctionByName("G-function-2", type.toLowerCase());
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
        this.par = new double[3];
        this.par[0] = 1.2;
        this.par[1] = 5.5;
        this.par[2] = -0.5;
        this.f1.normalize(false);
        this.f2.normalize(false);
        this.newName = "Gaussian: p0=" + this.par[0] + ",  p1=" + this.par[1] + ",  p2=" + this.par[2];
        this.checkPredefinedFunctions1D(this.newName, type, this.f1, this.f2, false);
    }

    public void init() {
        this.debug = false;
        this.xBins = 10;
        this.xmin = -10.0;
        this.xmax = 10.0;
        this.analysisFactory = IAnalysisFactory.create();
        this.treeFactory = this.analysisFactory.createTreeFactory();
        this.tree = this.analysisFactory.createTreeFactory().create();
        this.histogramFactory = this.analysisFactory.createHistogramFactory(this.tree);
        this.functionFactory = this.analysisFactory.createFunctionFactory(this.tree);
    }

    public void checkPredefinedFunctions1D(String name, String type, IModelFunction f1, IModelFunction f2, boolean norm) {
        if (this.debug) {
            System.out.println("\n\n\t ***** " + name + ",  Normalization = " + norm);
        }
        Assert.assertEquals((boolean)norm, (boolean)f1.isNormalized());
        Assert.assertEquals((boolean)norm, (boolean)f2.isNormalized());
        Assert.assertEquals((int)1, (int)f1.dimension());
        Assert.assertEquals((int)1, (int)f2.dimension());
        int i = 0;
        while (i < f1.dimension()) {
            Assert.assertEquals((String)new String("x" + i), (String)f1.variableName(i));
            Assert.assertEquals((String)new String("x" + i), (String)f2.variableName(i));
            Assert.assertEquals((String)new String("x" + i), (String)f1.variableNames()[i]);
            Assert.assertEquals((String)new String("x" + i), (String)f2.variableNames()[i]);
            ++i;
        }
        Assert.assertEquals((int)this.par.length, (int)f1.numberOfParameters());
        Assert.assertEquals((int)this.par.length, (int)f2.numberOfParameters());
        Assert.assertEquals((int)this.par.length, (int)f1.parameterNames().length);
        Assert.assertEquals((int)this.par.length, (int)f2.parameterNames().length);
        int i2 = 0;
        while (i2 < this.par.length) {
            if (this.debug) {
                System.out.println("Parameter names: ref=" + this.names(norm, type)[i2] + ", \tf1: " + f1.parameterNames()[i2] + ", \tf2: " + f2.parameterNames()[i2]);
            }
            Assert.assertEquals((String)this.names(norm, type)[i2], (String)f1.parameterNames()[i2]);
            Assert.assertEquals((String)this.names(norm, type)[i2], (String)f2.parameterNames()[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.par.length) {
            Assert.assertEquals((int)i3, (int)f1.indexOfParameter(this.names(norm, type)[i3]));
            Assert.assertEquals((int)i3, (int)f2.indexOfParameter(this.names(norm, type)[i3]));
            ++i3;
        }
        f1.setParameters(this.par);
        f2.setParameters(this.par);
        this.checkParameters(type, (IFunction)f1, (IFunction)f2, norm);
        double scale = 1.7651;
        int i4 = 0;
        while (i4 < this.par.length) {
            this.par[i4] = this.par[i4] * scale;
            f1.setParameter(this.names(norm, type)[i4], this.par[i4]);
            f2.setParameter(this.names(norm, type)[i4], this.par[i4]);
            ++i4;
        }
        this.checkParameters(type, (IFunction)f1, (IFunction)f2, norm);
        f1.setParameters(this.par);
        f2.setParameters(this.par);
        int i5 = 0;
        while (i5 < this.xBins) {
            double x = this.xmin + ((double)i5 + 0.5) * (this.xmax - this.xmin) / (double)this.xBins;
            if (this.debug) {
                System.out.println("Values for x=" + x + "\tExpected=" + this.value(x, type, norm) + "\tf1=" + f1.value(new double[]{x}) + "\tf2=" + f2.value(new double[]{x}));
            }
            AidaTestCase.assertEqualsDouble(this.value(x, type, norm), f1.value(new double[]{x}), 1.0E-10);
            AidaTestCase.assertEqualsDouble(this.value(x, type, norm), f2.value(new double[]{x}), 1.0E-10);
            ++i5;
        }
    }

    private void checkParameters(String type, IFunction f1, IFunction f2, boolean norm) {
        Assert.assertEquals((int)this.par.length, (int)f1.parameters().length);
        Assert.assertEquals((int)this.par.length, (int)f2.parameters().length);
        int i = 0;
        while (i < this.par.length) {
            if (this.debug) {
                System.out.println("Parameter values (array): ref=" + this.par[i] + ", \tf1: " + f1.parameters()[i] + ", \tf2: " + f2.parameters()[i]);
            }
            AidaTestCase.assertEqualsDouble(this.par[i], f1.parameters()[i], 1.0E-10);
            AidaTestCase.assertEqualsDouble(this.par[i], f2.parameters()[i], 1.0E-10);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.par.length) {
            if (this.debug) {
                System.out.println("Parameter values (indiv): ref=" + this.par[i2] + ", \tf1: " + f1.parameter(this.names(norm, type)[i2]) + ", \tf2: " + f2.parameter(this.names(norm, type)[i2]));
            }
            AidaTestCase.assertEqualsDouble(this.par[i2], f1.parameter(this.names(norm, type)[i2]), 1.0E-10);
            AidaTestCase.assertEqualsDouble(this.par[i2], f2.parameter(this.names(norm, type)[i2]), 1.0E-10);
            ++i2;
        }
    }

    private double value(double x, String type, boolean norm) {
        double v = Double.NaN;
        if (!norm) {
            if (type == "G") {
                v = this.par[0] * Math.exp(-Math.pow((x - this.par[1]) / this.par[2], 2.0) / 2.0);
            } else if (type == "E") {
                v = this.par[0] * Math.exp(x * this.par[1]);
            } else if (type == "BW") {
                double gamma2 = this.par[2] * this.par[2] / 4.0;
                v = this.par[0] * gamma2 / ((x - this.par[1]) * (x - this.par[1]) + gamma2);
            } else if (type.startsWith("P")) {
                int order = this.par.length;
                v = 0.0;
                int i = 0;
                while (i < order) {
                    v += this.par[i] * Math.pow(x, i);
                    ++i;
                }
            }
        } else {
            if (type == "G") {
                v = 0.5 * this.par[1] * Math.pow(Math.PI * 2, 0.5) * Math.exp(-Math.pow((x - this.par[0]) / this.par[1], 2.0) / 2.0);
            } else if (type == "E") {
                double n = (Math.exp(this.xmax * this.par[0]) - Math.exp(this.xmin * this.par[0])) / this.par[0];
                v = Math.exp(x * this.par[0]);
                v /= n;
            } else if (type == "BW") {
                double gamma2 = this.par[2] * this.par[2] / 4.0;
                v = this.par[0] * gamma2 / ((x - this.par[1]) * (x - this.par[1]) + gamma2);
            } else if (type.startsWith("P")) {
                int order = this.par.length;
                v = 1.0;
                double n = this.xmax - this.xmin;
                int i = 0;
                while (i < order) {
                    n += this.par[i] * (Math.pow(this.xmax, i + 2) - Math.pow(this.xmin, i + 2)) / (double)(i + 2);
                    ++i;
                }
                int i2 = 0;
                while (i2 < order) {
                    v += this.par[i2] * Math.pow(x, i2 + 1);
                    ++i2;
                }
                v /= n;
            }
            if (v < 0.0) {
                v = 0.0;
            }
        }
        return v;
    }

    private String[] names(boolean norm, String type) {
        String[] str;
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            str = null;
                            if (norm) break block9;
                            if (type != "G") break block10;
                            str = new String[]{"amplitude", "mean", "sigma"};
                            break block11;
                        }
                        if (type != "E") break block12;
                        str = new String[]{"amplitude", "exponent"};
                        break block11;
                    }
                    if (type != "BW") break block13;
                    str = new String[]{"amplitude", "origin", "width"};
                    break block11;
                }
                if (!type.startsWith("P")) break block11;
                int order = this.par.length;
                str = new String[order];
                int i = 0;
                while (i < order) {
                    str[i] = new String("p" + i);
                    ++i;
                }
                break block11;
            }
            if (type == "G") {
                str = new String[]{"mean", "sigma"};
            } else if (type == "E") {
                str = new String[]{"exponent"};
            } else if (type == "BW") {
                str = new String[]{"origin", "width"};
            } else if (type.startsWith("P")) {
                int order = this.par.length;
                str = new String[order];
                int i = 0;
                while (i < order) {
                    str[i] = new String("p" + (i + 1));
                    ++i;
                }
            }
        }
        return str;
    }
}

