// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;

import java.io.IOException;
import java.io.OutputStream;

/**
 * User level interface to a Tree.
 *
 * All paths follow unix convention .., ., /, 
 * backslash is the escape character.
 * Relative paths are allowed.
 *
 * NOTE: - this tree keeps a current position(pwd) within the tree.
 * This may be implemented on a per-thread basis.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface ITree {

  /**
   * Get the name of the store.
   * @return The store's name.
   *
   */
    public String storeName();

  /**
   * Get the IManagedObject at a given path in the ITree. The path can either be
   * absolute or relative to the current working directory.
   * @param path The path.
   * @return     The corresponding IManagedObject.
   * @throws     IllegalArgumentException If the path does not correspond to an IManagedObject.
   *
   */
    public IManagedObject find(String path) throws IllegalArgumentException;

  /**
   * Get a mounted ITree at a given path in the current ITree. The path can either be
   * absolute or relative to the current working directory.
   * @param path The path.
   * @return     The corresponding ITree.
   * @throws     IllegalArgumentException If the path does not correspond to an ITree.
   *
   */
    public ITree findTree(String path) throws IllegalArgumentException;

  /**
   * Change to a given directory.
   * @param path The absolute or relative path of the directory we are changing to.
   * @throws     IllegalArgumentException If the path does not exist.
   *
   */
    public void cd(String path) throws IllegalArgumentException;

  /**
   * Get the path of the current working directory.
   * @return The path of the current working directory.
   *
   */
    public String pwd();

  /** 
   * List, into a given output stream, all the IManagedObjects, including directories
   * (but not "." and ".."), in a given path. Directories end with "/". The list can be recursive.
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public void ls() throws IllegalArgumentException;
  /** 
   * List, into a given output stream, all the IManagedObjects, including directories
   * (but not "." and ".."), in a given path. Directories end with "/". The list can be recursive.
   * @param path      The path where the list has to be performed (by default the current directory ".").
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public void ls(String path) throws IllegalArgumentException;
  /** 
   * List, into a given output stream, all the IManagedObjects, including directories
   * (but not "." and ".."), in a given path. Directories end with "/". The list can be recursive.
   * @param path      The path where the list has to be performed (by default the current directory ".").
   * @param recursive If <code>true</code> the list is extended recursively
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public void ls(String path, boolean recursive) throws IllegalArgumentException;
  /** 
   * List, into a given output stream, all the IManagedObjects, including directories
   * (but not "." and ".."), in a given path. Directories end with "/". The list can be recursive.
   * @param path      The path where the list has to be performed (by default the current directory ".").
   * @param recursive If <code>true</code> the list is extended recursively
   *                  in all the directories under path (the default is <code>false</code>.
   * @param os        The output stream into which the list is dumped (by default the standard output).
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public void ls(String path, boolean recursive, OutputStream os) throws IllegalArgumentException;

  /**
   * Get the list of names of the IManagedObjects under a given path, including directories
   * (but not "." and ".."). Directories end with "/".
   * The returned names are appended to the given path unless the latter is ".".
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectNames() throws IllegalArgumentException;
  /**
   * Get the list of names of the IManagedObjects under a given path, including directories
   * (but not "." and ".."). Directories end with "/".
   * The returned names are appended to the given path unless the latter is ".".
   * @param path      The path where the list has to be performed (by default the current directory ".").
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectNames(String path) throws IllegalArgumentException;
  /**
   * Get the list of names of the IManagedObjects under a given path, including directories
   * (but not "." and ".."). Directories end with "/".
   * The returned names are appended to the given path unless the latter is ".".
   * @param path      The path where the list has to be performed (by default the current directory ".").
   * @param recursive If <code>true</code> the list is extended recursively
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectNames(String path, boolean recursive) throws IllegalArgumentException;

  /**
   * Get the list of types of the IManagedObjects under a given path.
   * The types are the leaf class of the Interface, e.g. "IHistogram1D", "ITuple", etc.
   * Directories are marked with "dir".
   * The order of the types is the same as the order for the listObjectNames() method
   * to achieve a one-to-one correspondance between object names and types.
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectTypes() throws IllegalArgumentException;
  /**
   * Get the list of types of the IManagedObjects under a given path.
   * The types are the leaf class of the Interface, e.g. "IHistogram1D", "ITuple", etc.
   * Directories are marked with "dir".
   * The order of the types is the same as the order for the listObjectNames() method
   * to achieve a one-to-one correspondance between object names and types.
   * @param path      The path where the list has to be performed (by default the current directory ".").
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectTypes(String path) throws IllegalArgumentException;
  /**
   * Get the list of types of the IManagedObjects under a given path.
   * The types are the leaf class of the Interface, e.g. "IHistogram1D", "ITuple", etc.
   * Directories are marked with "dir".
   * The order of the types is the same as the order for the listObjectNames() method
   * to achieve a one-to-one correspondance between object names and types.
   * @param path      The path where the list has to be performed (by default the current directory ".").
   * @param recursive If <code>true</code> the list is extended recursively
   *                  in all the directories under path (the default is <code>false</code>.
   * @throws          IllegalArgumentException If the path does not exist.
   *
   */
    public String[] listObjectTypes(String path, boolean recursive) throws IllegalArgumentException;

  /**
   * Create a new directory. Given a path only the last directory
   * in it is created if all the intermediate subdirectories already exist.
   * @param path The absolute or relative path of the new directory.
   * @throws     IllegalArgumentException If a subdirectory within the path does
   *             not exist or it is not a directory. Also if the directory already exists.
   *
   */   
    public void mkdir(String path) throws IllegalArgumentException;

  /**
   * Create a directory recursively. Given a path the last directory
   * and all the intermediate non-existing subdirectories are created.
   * @param path The absolute or relative path of the new directory.
   * @throws     IllegalArgumentException If an intermediate subdirectory
   *             is not a directory, or if the directory already exists.
   *
   */
    public void mkdirs(String path) throws IllegalArgumentException;

  /**
   * Remove a directory and all the contents underneeth.
   * @param path The absolute or relative path of the directory to be removed.
   * @throws     IllegalArgumentException If path does not exist or if it is not
   *             a directory.
   *
   */
    public void rmdir(String path) throws IllegalArgumentException;

  /**
   * Remove an IManagedObject by specifying its path.
   * If the path points to a mount point, the mount point should first commit, then 
   * close and delete the tree object.
   * @param path The absolute or relative path of the IManagedObject to be removed.
   * @throws     IllegalArgumentException If path does not exist.
   *
   */
    public void rm(String path) throws IllegalArgumentException;

  /**
   * Get the full path of an IManagedObject.
   * @param object The IManagedObject whose path is to be returned.
   * @return       The object's absolute path.
   *               In C++ if the object does not exist, an empty string is returned.
   * @throws       IllegalArgumentException If the IManagedObject does not exist.
   *
   */
    public String findPath(IManagedObject object) throws IllegalArgumentException;

  /**
   * Move an IManagedObject or a directory from one directory to another.
   * @param oldPath The path of the IManagedObject or direcoty to be moved.
   * @param newPath The path of the diretory in which the object has to be moved to.
   * @throws        IllegalArgumentException If either path does not exist.
   *
   */
    public void mv(String oldPath, String newPath) throws IllegalArgumentException;

  /**
   * Commit any open transaction to the underlying store(s).
   * It flushes objects into the disk for non-memory-mapped stores.
   * @throws IOException If the underlying store cannot be written out.
   *
   */
    public void commit() throws IOException;

  /**
   * Set the strategy of what should happen if two objects have the same path.
   * Default is overwrite.
   *
   */
    public void setOverwrite();
  /**
   * Set the strategy of what should happen if two objects have the same path.
   * Default is overwrite.
   * @param overwrite <code>true</code> to enable overwriting.
   *
   */
    public void setOverwrite(boolean overwrite);

  /**
   * Copy an object from a path to another.
   * @param oldPath   The path of the object to be copied.
   * @param newPath   The path where the object is to be copied.
   * @throws          IllegalArgumentException If either path does not exist.
   *
   */
    public void cp(String oldPath, String newPath) throws IllegalArgumentException;
  /**
   * Copy an object from a path to another.
   * @param oldPath   The path of the object to be copied.
   * @param newPath   The path where the object is to be copied.
   * @param recursive <code>true</code> if a recursive copy has to be performed.
   * @throws          IllegalArgumentException If either path does not exist.
   *
   */
    public void cp(String oldPath, String newPath, boolean recursive) throws IllegalArgumentException;

  /**
   * Create a symbolic link to an object in the ITree.
   * @param path  The absolute or relative path of the object to be linked.
   * @param alias The absolute or relative name of the link.
   * @throws      IllegalArgumentException If path or any
   *              subidrectory within path does not exist.
   *
   */
    public void symlink(String path, String alias) throws IllegalArgumentException;

  /**
   * Mounts a tree within another (target) tree. A tree can only be mounted once.
   * Example:
   * <pre>
   *     target.mount("/home/tonyj",tree,"/");
   * </pre>
   * @param path     The path in the target tree
   * @param tree     The tree to mount within the target tree
   * @param treePath The mount point within the tree to be mounted.
   * @throws         IllegalArtumentException If something does not exist.
   *
   */
    public void mount(String path, ITree tree, String treePath) throws IllegalArgumentException;

  /**
   * Unmount a subtree at a given path (mount point).
   * Whenever a tree is destroyed it first unmounts all dependent trees.
   * @param path The path of the subtree to be unmounted.
   * @throws     IllegalArgumentException If path does not exist.
   *
   */
    public void unmount(String path) throws IllegalArgumentException;

  /**
   * Closes the underlying store.
   * Changes will be saved only if commit() has been called before.
   * The call is propagated to the dependent mounted trees.
   * @throws IOException If there are problems writing out
   *         the underlying store.
   *
   */
    public void close() throws IOException;
} // class or interface

