// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * Basic user-level interface class for holding a single "measurement"
 * with positive and negative errors (to allow for asymmetric errors).
 * "IMeasurement" = "value" + "errorPlus" - "errorMinus"
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IMeasurement {

    /**
     * Get the value of the IMeasurement.
     * @return The value of the IMeasurement.
     *
     */
    public double value();

    /**
     * Get the plus error of the IMeasurement.
     * @return The plus error.
     *
     */
    public double errorPlus();

    /**
     * Get the minus error of the IMeasurement.
     * @return The minus error.
     *
     */
    public double errorMinus();

    /**
     * Set the value of the IMeasurement.
     * @param value The new value of the IMeasurement.
     * @throws      IllegalArgumentException If the value cannot be set.
     *
     */
    public void setValue(double value) throws IllegalArgumentException;

    /**
     * Set the plus error of the IMeasurement.
     * @param value The new plus error of the IMeasurement.
     * @throws      IllegalArgumentException If the error cannot be set or it is negative.
     *
     */
    public void setErrorPlus(double errorPlus) throws IllegalArgumentException;

    /**
     * Set the minus error of the IMeasurement.
     * @param value The new minus error of the IMeasurement.
     * @throws      IllegalArgumentException If the error cannot be set or it is negative.
     *
     */
    public void setErrorMinus(double errorMinus) throws IllegalArgumentException;
} // class or interface

