// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;

import java.io.IOException;

/**
 *
 * Function catalog.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IFunctionCatalog {

    /**
     * Remember persistently definition (code!) of a function under a name.
     * Scripted function created by the user may be automatically available
     * in the subsequent analysis sessions. This is also a way to create
     * new names for combinations of exisiting model functions ("G+G+E+P5").
     * Last but not least, system may be easily extended with model functions
     * developed in the programming language directly.
     * Predefined functions: "G","E","Pn".
     */
    public boolean add(String nameId, IFunction f);

    public boolean add(String nameId, String codelet);

    /*
     * Get a list of all available functions.
     */
    public String[] list();

    /*
     * Remove function from the catalog.
     */
    public void remove(String nameId);

    /*
     * Write contents of the catalog to disk.
     * We have to agree on the format here, or define and XML 
     * entry for IFunctionCatalog!
     */
    public void storeAll(String nameOnDisk) throws IOException;

    /* 
     * Load contents of the catalog from disk
     * We have to agree on the format here, or define and XML 
     * entry for IFunctionCatalog!
     */
    public void loadAll(String nameOnDisk) throws IOException;
} // class or interface

