// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IINFO_H
#define AIDA_IINFO_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class IFillStyle;
class ILineStyle;
class IMarkerStyle;

/**
 * The info class permits to access the info area of a region.
 * Through it legends, statistics, text could be displayed.
 * A legend is an association of a graphical marker and a text.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IInfo {

public: 
    /// Destructor.
    virtual ~IInfo() { /* nop */; }

  /**
   * Clear the info area.
   */
    virtual void clear() = 0;

  /**
   * Add a text. The text is appended to existing info elements.
   */
    virtual void addText(const std::string & text) = 0;

  /**
   * Add a marker, line or fill area legend.
   * The legend is appended to existing elements.
   */
    virtual void addLegend(const IMarkerStyle & style, const std::string & description) = 0;

    virtual void addLegend(const ILineStyle & style, const std::string & description) = 0;

    virtual void addLegend(const IFillStyle & style, const std::string & description) = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IINFO_H */
