/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;

public class TestProfile
extends AidaTestCase {
    public TestProfile(String testName) {
        super(testName);
    }

    public void testProfileSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        String outputName = "testProfile.aida";
        String options = "compress=no";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(outputName, null, false, true, options);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IProfile1D p1 = hf.createProfile1D("p1", "Test Profile 1d", 36, -4.3, 5.0);
        IProfile2D p2 = hf.createProfile2D("p2", "Test Profile 2d", 36, -4.3, 5.0, 3, -1.0, 1.0);
        int entries = 100;
        int i = 0;
        while (i < entries) {
            double xval = r.nextGaussian();
            double yval = r.nextDouble();
            double zval = r.nextGaussian();
            p1.fill(xval, zval);
            p2.fill(xval, yval, zval);
            ++i;
        }
        tree.commit();
        ITree newTree = tf.create(outputName);
        AidaTestCase.assertEquals(p1, (IProfile1D)newTree.find("p1"));
        AidaTestCase.assertEquals(p2, (IProfile2D)newTree.find("p2"));
    }

    public void testProfileCopy() throws IOException {
        String outputName = "testProfile.aida";
        String options = "compress=no";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITree newTree = tf.create(outputName);
        IProfile1D p1 = (IProfile1D)newTree.find("p1");
        IProfile2D p2 = (IProfile2D)newTree.find("p2");
        hf.createCopy("p1", p1);
        hf.createCopy("p2", p2);
        IProfile1D p1New = (IProfile1D)tree.find("p1");
        IProfile2D p2New = (IProfile2D)tree.find("p2");
        AidaTestCase.assertEquals(p1, p1New);
        AidaTestCase.assertEquals(p2, p2New);
    }
}

