/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestHistogram
extends AidaTestCase {
    private int nEntries = 1234;
    private int xbins = 40;
    private int ybins = 20;
    private int zbins = 10;
    private double xLowerEdge = -2.3;
    private double xUpperEdge = 4.2;
    private double yLowerEdge = -6.1;
    private double yUpperEdge = 1.2;
    private double zLowerEdge = -0.6;
    private double zUpperEdge = 7.5;
    private String outputName = "testHistogram.aida";
    private String options = "compress=no";
    private String hist1DTitle = "Aida 1D Histogram";
    private String hist2DTitle = "Aida 2D Histogram";
    private String hist3DTitle = "Aida 3D Histogram";

    public TestHistogram(String testName) {
        super(testName);
    }

    public void testHistogramCreation() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        Assert.assertEquals((String)this.hist1DTitle, (String)h1.title());
        Assert.assertEquals((String)this.hist2DTitle, (String)h2.title());
        Assert.assertEquals((String)this.hist3DTitle, (String)h3.title());
        Assert.assertEquals((int)this.xbins, (int)h1.axis().bins());
        Assert.assertEquals((int)this.xbins, (int)h2.xAxis().bins());
        Assert.assertEquals((int)this.xbins, (int)h3.xAxis().bins());
        Assert.assertEquals((int)this.ybins, (int)h2.yAxis().bins());
        Assert.assertEquals((int)this.ybins, (int)h3.yAxis().bins());
        Assert.assertEquals((int)this.zbins, (int)h3.zAxis().bins());
        Assert.assertEquals((double)this.xLowerEdge, (double)h1.axis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.xUpperEdge, (double)h1.axis().upperEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.xLowerEdge, (double)h2.xAxis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.xUpperEdge, (double)h2.xAxis().upperEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.xLowerEdge, (double)h3.xAxis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.xUpperEdge, (double)h3.xAxis().upperEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.yLowerEdge, (double)h2.yAxis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.yUpperEdge, (double)h2.yAxis().upperEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.yLowerEdge, (double)h3.yAxis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.yUpperEdge, (double)h3.yAxis().upperEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.zLowerEdge, (double)h3.zAxis().lowerEdge(), (double)1.0E-9);
        Assert.assertEquals((double)this.zUpperEdge, (double)h3.zAxis().upperEdge(), (double)1.0E-9);
        IAxis xAxis = h1.axis();
        IAxis yAxis = h2.yAxis();
        IAxis zAxis = h3.zAxis();
        int xbins = xAxis.bins();
        int ybins = yAxis.bins();
        int zbins = zAxis.bins();
        double[] xVarAxis = new double[xbins + 1];
        double[] yVarAxis = new double[ybins + 1];
        double[] zVarAxis = new double[zbins + 1];
        int i = 0;
        while (i < xbins) {
            xVarAxis[i] = xAxis.binLowerEdge(i);
            ++i;
        }
        xVarAxis[xbins] = xAxis.upperEdge();
        int i2 = 0;
        while (i2 < ybins) {
            yVarAxis[i2] = yAxis.binLowerEdge(i2);
            ++i2;
        }
        yVarAxis[ybins] = yAxis.upperEdge();
        int i3 = 0;
        while (i3 < zbins) {
            zVarAxis[i3] = zAxis.binLowerEdge(i3);
            ++i3;
        }
        zVarAxis[zbins] = zAxis.upperEdge();
        IHistogram1D h1Var = histogramFactory.createHistogram1D(this.hist1DTitle, this.hist1DTitle, xVarAxis, "");
        IHistogram2D h2Var = histogramFactory.createHistogram2D(this.hist2DTitle, this.hist2DTitle, xVarAxis, yVarAxis, "");
        IHistogram3D h3Var = histogramFactory.createHistogram3D(this.hist3DTitle, this.hist3DTitle, xVarAxis, yVarAxis, zVarAxis, "");
        AidaTestCase.assertEquals(h1, h1Var);
        AidaTestCase.assertEquals(h2, h2Var);
        AidaTestCase.assertEquals(h3, h3Var);
    }

    public void testHistogramFill() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        IAxis xAxis = h1.axis();
        IAxis yAxis = h2.yAxis();
        IAxis zAxis = h3.zAxis();
        int xbins = xAxis.bins();
        int ybins = yAxis.bins();
        int zbins = zAxis.bins();
        double[] xVarAxis = new double[xbins + 1];
        double[] yVarAxis = new double[ybins + 1];
        double[] zVarAxis = new double[zbins + 1];
        int i = 0;
        while (i < xbins) {
            xVarAxis[i] = xAxis.binLowerEdge(i);
            ++i;
        }
        xVarAxis[xbins] = xAxis.upperEdge();
        int i2 = 0;
        while (i2 < ybins) {
            yVarAxis[i2] = yAxis.binLowerEdge(i2);
            ++i2;
        }
        yVarAxis[ybins] = yAxis.upperEdge();
        int i3 = 0;
        while (i3 < zbins) {
            zVarAxis[i3] = zAxis.binLowerEdge(i3);
            ++i3;
        }
        zVarAxis[zbins] = zAxis.upperEdge();
        IHistogram1D h1Var = histogramFactory.createHistogram1D(this.hist1DTitle, this.hist1DTitle, xVarAxis, "");
        IHistogram2D h2Var = histogramFactory.createHistogram2D(this.hist2DTitle, this.hist2DTitle, xVarAxis, yVarAxis, "");
        IHistogram3D h3Var = histogramFactory.createHistogram3D(this.hist3DTitle, this.hist3DTitle, xVarAxis, yVarAxis, zVarAxis, "");
        int i4 = 0;
        while (i4 < 10 * this.nEntries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                h1.fill(xval, w);
                h2.fill(xval, yval, w);
                h3.fill(xval, yval, zval, w);
                h1Var.fill(xval, w);
                h2Var.fill(xval, yval, w);
                h3Var.fill(xval, yval, zval, w);
            } else {
                h1.fill(xval);
                h2.fill(xval, yval);
                h3.fill(xval, yval, zval);
                h1Var.fill(xval);
                h2Var.fill(xval, yval);
                h3Var.fill(xval, yval, zval);
            }
            ++i4;
        }
        AidaTestCase.assertEquals(h1, h1Var);
        AidaTestCase.assertEquals(h2, h2Var);
        AidaTestCase.assertEquals(h3, h3Var);
    }

    public void testHistogramSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create(this.outputName, null, false, true, this.options);
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        double[] xVarAxis = new double[]{-12.0, -3.0, -1.0, 0.0, 0.23, 2.67, 8.0};
        double[] yVarAxis = new double[]{-34.0, 0.0, 12.0, 78.0};
        double[] zVarAxis = new double[]{-0.345, 0.89, 1.123, 4.3432, 7.234};
        IHistogram1D h1Var = histogramFactory.createHistogram1D("h1Var", "h1VarAxis", xVarAxis, "");
        IHistogram2D h2Var = histogramFactory.createHistogram2D("h2Var", "h2VarAxis", xVarAxis, yVarAxis, "");
        IHistogram3D h3Var = histogramFactory.createHistogram3D("h3Var", "h3VarAxis", xVarAxis, yVarAxis, zVarAxis, "");
        int i = 0;
        while (i < this.nEntries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                h1.fill(xval, w);
                h2.fill(xval, yval, w);
                h3.fill(xval, yval, zval, w);
                h1Var.fill(xval, w);
                h2Var.fill(xval, yval, w);
                h3Var.fill(xval, yval, zval, w);
            } else {
                h1.fill(xval);
                h2.fill(xval, yval);
                h3.fill(xval, yval, zval);
                h1Var.fill(xval, w);
                h2Var.fill(xval, yval, w);
                h3Var.fill(xval, yval, zval, w);
            }
            ++i;
        }
        Assert.assertEquals((int)this.nEntries, (int)h1.allEntries());
        Assert.assertEquals((int)this.nEntries, (int)h2.allEntries());
        Assert.assertEquals((int)this.nEntries, (int)h3.allEntries());
        tree.commit();
        ITree newTree = treeFactory.create(this.outputName);
        newTree.cd("/");
        IHistogram1D h1New = (IHistogram1D)newTree.find(((IManagedObject)h1).name());
        IHistogram2D h2New = (IHistogram2D)newTree.find(((IManagedObject)h2).name());
        IHistogram3D h3New = (IHistogram3D)newTree.find(((IManagedObject)h3).name());
        IHistogram1D h1VarNew = (IHistogram1D)newTree.find(((IManagedObject)h1Var).name());
        IHistogram2D h2VarNew = (IHistogram2D)newTree.find(((IManagedObject)h2Var).name());
        IHistogram3D h3VarNew = (IHistogram3D)newTree.find(((IManagedObject)h3Var).name());
        AidaTestCase.assertEquals(h1, h1New);
        AidaTestCase.assertEquals(h2, h2New);
        AidaTestCase.assertEquals(h3, h3New);
        AidaTestCase.assertEquals(h1Var, h1VarNew);
        AidaTestCase.assertEquals(h2Var, h2VarNew);
        AidaTestCase.assertEquals(h3Var, h3VarNew);
    }

    public void testHistogramZipSaveRestore1D() throws IOException {
        this.outputName = "testHistogramZipped.aida";
        this.options = "compress=yes";
        this.testHistogramSaveRestore();
    }

    public void testHistogramStatistics() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        double[] error1d = new double[this.xbins + 2];
        double[][] error2d = new double[this.xbins + 2][this.ybins + 2];
        double[][][] error3d = new double[this.xbins + 2][this.ybins + 2][this.zbins + 2];
        double xmean = 0.0;
        double xrms = 0.0;
        double ymean = 0.0;
        double yrms = 0.0;
        double zmean = 0.0;
        double zrms = 0.0;
        int entries = 0;
        double sumOfWeight = 0.0;
        double sumOfWeightSquared = 0.0;
        int i = 0;
        while (i < 10 * this.nEntries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            xmean += xval * w;
            xrms += xval * xval * w;
            ymean += yval * w;
            yrms += yval * yval * w;
            zmean += zval * w;
            zrms += zval * zval * w;
            ++entries;
            sumOfWeight += w;
            sumOfWeightSquared += w * w;
            int xbin = h1.coordToIndex(xval) + 2;
            int ybin = h2.coordToIndexY(yval) + 2;
            int zbin = h3.coordToIndexZ(zval) + 2;
            int n = xbin;
            error1d[n] = error1d[n] + w * w;
            double[] dArray = error2d[xbin];
            int n2 = ybin;
            dArray[n2] = dArray[n2] + w * w;
            double[] dArray2 = error3d[xbin][ybin];
            int n3 = zbin;
            dArray2[n3] = dArray2[n3] + w * w;
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            ++i;
        }
        double meanX = xmean / sumOfWeight;
        double rmsX = Math.sqrt(xrms / sumOfWeight - xmean * xmean / sumOfWeight / sumOfWeight);
        double meanY = ymean / sumOfWeight;
        double rmsY = Math.sqrt(yrms / sumOfWeight - ymean * ymean / sumOfWeight / sumOfWeight);
        double meanZ = zmean / sumOfWeight;
        double rmsZ = Math.sqrt(zrms / sumOfWeight - zmean * zmean / sumOfWeight / sumOfWeight);
        double equivEnt = sumOfWeight * sumOfWeight / sumOfWeightSquared;
        Assert.assertEquals((double)h1.mean(), (double)meanX, (double)1.0E-10);
        Assert.assertEquals((double)h1.mean(), (double)h2.meanX(), (double)1.0E-10);
        Assert.assertEquals((double)h1.mean(), (double)h3.meanX(), (double)1.0E-10);
        Assert.assertEquals((double)h2.meanY(), (double)meanY, (double)1.0E-10);
        Assert.assertEquals((double)h2.meanY(), (double)h3.meanY(), (double)1.0E-10);
        Assert.assertEquals((double)h3.meanZ(), (double)meanZ, (double)1.0E-10);
        Assert.assertEquals((double)h1.rms(), (double)rmsX, (double)1.0E-10);
        Assert.assertEquals((double)h1.rms(), (double)h2.rmsX(), (double)1.0E-10);
        Assert.assertEquals((double)h1.rms(), (double)h3.rmsX(), (double)1.0E-10);
        Assert.assertEquals((double)h2.rmsY(), (double)rmsY, (double)1.0E-10);
        Assert.assertEquals((double)h2.rmsY(), (double)h3.rmsY(), (double)1.0E-10);
        Assert.assertEquals((double)h3.rmsZ(), (double)rmsZ, (double)1.0E-10);
        int i2 = -2;
        while (i2 < this.xbins) {
            Assert.assertEquals((double)h1.binError(i2), (double)Math.sqrt(error1d[i2 + 2]), (double)1.0E-10);
            int j = -2;
            while (j < this.ybins) {
                Assert.assertEquals((double)h2.binError(i2, j), (double)Math.sqrt(error2d[i2 + 2][j + 2]), (double)1.0E-10);
                int k = -2;
                while (k < this.zbins) {
                    Assert.assertEquals((double)h3.binError(i2, j, k), (double)Math.sqrt(error3d[i2 + 2][j + 2][k + 2]), (double)1.0E-10);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        Assert.assertEquals((int)h1.allEntries(), (int)entries);
        Assert.assertEquals((int)h2.allEntries(), (int)entries);
        Assert.assertEquals((int)h3.allEntries(), (int)entries);
        Assert.assertEquals((double)h1.equivalentBinEntries(), (double)equivEnt, (double)1.0E-10);
        Assert.assertEquals((double)h2.equivalentBinEntries(), (double)equivEnt, (double)1.0E-10);
        Assert.assertEquals((double)h3.equivalentBinEntries(), (double)equivEnt, (double)1.0E-10);
    }

    public void testHistogramScale() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        IHistogram1D h1S = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2S = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3S = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        double scale1D = 0.002;
        double scale2D = 4.2;
        double scale3D = 1123.0;
        int i = 0;
        while (i < 343) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1S.fill(xval, scale1D * w);
            h2S.fill(xval, yval, scale2D * w);
            h3S.fill(xval, yval, zval, scale3D * w);
            ++i;
        }
        h1.scale(scale1D);
        h2.scale(scale2D);
        h3.scale(scale3D);
        AidaTestCase.assertEquals(h1, h1S);
        AidaTestCase.assertEquals(h2, h2S);
        AidaTestCase.assertEquals(h3, h3S);
        int i2 = 0;
        while (i2 < 32) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1S.fill(xval, w);
            h2S.fill(xval, yval, w);
            h3S.fill(xval, yval, zval, w);
            ++i2;
        }
        AidaTestCase.assertEquals(h1, h1S);
        AidaTestCase.assertEquals(h2, h2S);
        AidaTestCase.assertEquals(h3, h3S);
    }

    public void testHistogramAdd() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        IHistogram1D h1A = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2A = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3A = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        IHistogram1D h1B = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2B = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3B = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        int i = 0;
        while (i < 343) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1A.fill(xval, w);
            h2A.fill(xval, yval, w);
            h3A.fill(xval, yval, zval, w);
            ++i;
        }
        int i2 = 0;
        while (i2 < 894) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1B.fill(xval, w);
            h2B.fill(xval, yval, w);
            h3B.fill(xval, yval, zval, w);
            ++i2;
        }
        h1A.add(h1B);
        h2A.add(h2B);
        h3A.add(h3B);
        AidaTestCase.assertEquals(h1, h1A);
        AidaTestCase.assertEquals(h2, h2A);
        AidaTestCase.assertEquals(h3, h3A);
        int i3 = 0;
        while (i3 < 32) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1A.fill(xval, w);
            h2A.fill(xval, yval, w);
            h3A.fill(xval, yval, zval, w);
            ++i3;
        }
        AidaTestCase.assertEquals(h1, h1A);
        AidaTestCase.assertEquals(h2, h2A);
        AidaTestCase.assertEquals(h3, h3A);
    }

    public void testHistogramCopy() throws IOException {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        ITree newTree = treeFactory.create(this.outputName);
        IHistogram1D h1 = (IHistogram1D)newTree.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)newTree.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)newTree.find(this.hist3DTitle);
        IHistogram1D h1Var = (IHistogram1D)newTree.find("h1Var");
        IHistogram2D h2Var = (IHistogram2D)newTree.find("h2Var");
        IHistogram3D h3Var = (IHistogram3D)newTree.find("h3Var");
        histogramFactory.createCopy(this.hist1DTitle, h1);
        histogramFactory.createCopy(this.hist2DTitle, h2);
        histogramFactory.createCopy(this.hist3DTitle, h3);
        histogramFactory.createCopy("h1Var", h1Var);
        histogramFactory.createCopy("h2Var", h2Var);
        histogramFactory.createCopy("h3Var", h3Var);
        IHistogram1D h1New = (IHistogram1D)tree.find(this.hist1DTitle);
        IHistogram2D h2New = (IHistogram2D)tree.find(this.hist2DTitle);
        IHistogram3D h3New = (IHistogram3D)tree.find(this.hist3DTitle);
        IHistogram1D h1VarNew = (IHistogram1D)tree.find("h1Var");
        IHistogram2D h2VarNew = (IHistogram2D)tree.find("h2Var");
        IHistogram3D h3VarNew = (IHistogram3D)tree.find("h3Var");
        AidaTestCase.assertEquals(h1, h1New);
        AidaTestCase.assertEquals(h2, h2New);
        AidaTestCase.assertEquals(h3, h3New);
        AidaTestCase.assertEquals(h1Var, h1VarNew);
        AidaTestCase.assertEquals(h2Var, h2VarNew);
        AidaTestCase.assertEquals(h3Var, h3VarNew);
    }
}

