/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.test.AidaTestCase;
import junit.framework.Assert;

public class TestAnnotation
extends AidaTestCase {
    private int numberOfItems = 4;
    private String[] keys = new String[]{"key0", "key1", "key2", "key3"};
    private String[] vals = new String[]{"val0", "val1", "val2", "val3"};
    private boolean[] sticky = new boolean[]{true, true, false, false};

    public TestAnnotation(String testName) {
        super(testName);
    }

    public void testAnnotation() {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = null;
        histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h2 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h3 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IAnnotation an1 = h1.annotation();
        IAnnotation an2 = h2.annotation();
        IAnnotation an3 = h3.annotation();
        int i = 0;
        while (i < this.numberOfItems) {
            an1.addItem(this.keys[i], this.vals[i], this.sticky[i]);
            if (!this.sticky[i]) {
                an2.addItem(this.keys[i], this.vals[i]);
                an3.addItem(this.keys[i], this.vals[i]);
            } else {
                an2.addItem(this.keys[i], this.vals[i], this.sticky[i]);
            }
            ++i;
        }
        Assert.assertEquals((int)an1.size(), (int)(this.numberOfItems + 1));
        int i2 = 0;
        while (i2 < this.numberOfItems) {
            Assert.assertEquals((String)an1.key(i2 + 1), (String)this.keys[i2]);
            Assert.assertEquals((String)an1.value(i2 + 1), (String)this.vals[i2]);
            Assert.assertEquals((String)an1.value(i2 + 1), (String)an1.value(this.keys[i2]));
            ++i2;
        }
        an3.reset();
        int i3 = 0;
        while (i3 < this.numberOfItems) {
            an3.addItem(this.keys[i3], this.vals[i3], this.sticky[i3]);
            ++i3;
        }
        AidaTestCase.assertEquals(an1, an2);
        AidaTestCase.assertEquals(an1, an3);
        try {
            an1.addItem(this.keys[0], this.vals[2]);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException iae) {}
    }
}

