/*
SDRplay Limited
END USER LICENCE AGREEMENT
 
The SDRplay software (“Product”) you are about to install, run and/or use is licensed by SDRplay Limited, a company registered in England (No. 09035244), whose registered office is 21 Lenten Street, ALTON, Hampshire, GU34 1HG, UK(“SDRplay”), and is subject to the following licence terms (“Licence”). 
"You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

By proceeding to install, run and/or use the Product, you confirm that you accept and agree to be bound by the terms of this Licence. If you do not agree to any of the terms of this Licence, SDRplay is unwilling to provide access to the Product to you and you should not proceed further and may not use the Product.
 
1.  Licence To Use The Product.
 
1.1          Grant of Licence.  
Subject to the terms and conditions of this License, SDRplay hereby grants to you a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable license to reproduce, publicly display, publicly perform, create Derivative works, incorporate in other products sublicense, and distribute the Product in Object form.

 
1.2          Restrictions.  You may not:  modify, disassemble, decompile or reverse engineer the Product, except to the extent specifically authorised under applicable law notwithstanding contractual prohibition
1.3. Redistribution. You may reproduce and distribute copies of the Product in any medium, without modifications, in Object form, provided that you meet the following conditions:
1.  You must give any other recipients of the Product or Derivative Works a copy of this License; and
2.  You must cause any modified files to carry prominent notices stating that You changed the files; and
3.  Any Derivative Works that You distribute must include a readable statement that the Copyright in the Product is owned by and licensed by SDRplay. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the statement, provided that such additional attribution notices cannot be construed as modifying the License. 

You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.

 
1.3          Open Source Software.  The Product may contain code, commonly referred to as open source software, which is distributed under any of the many known variations of open source licence terms, including terms which allow the free distribution and modification of the relevant software’s source code and/or which require all distributors to make such source code freely available upon request, including any contributions or modifications made by such distributor (collectively, “Open Source Software”). To the extent that the Product contains any Open Source Software, that element only is licensed to you pursuant to the relevant licence terms of the applicable third party licensor (“Open Source Licence Terms”) and not pursuant to this Licence, and you accept and agree to be bound by such terms. A copy of the Open Source Licence Terms will be made available upon request.
 
2.            Confidentiality Obligations.  You acknowledge that the Product contains confidential, proprietary and trade secret information belonging to SDRplay and you agree to hold such information, and any other confidential or proprietary information of SDRplay (collectively, "Confidential Information") in strict confidence and agree not to disclose any Confidential Information to any third party. You will have no obligation to maintain the confidentiality of any information which: (a) is or becomes publicly available without breach of this Licence; (b) is rightfully received by you from a third party without an obligation of confidentiality and without breach of this Licence; (c) is required to be disclosed by law or regulation or by court order; or (d) has been approved for release by written permission of SDRplay. 
 
3.            Ownership.  You acknowledge and agree that SDRplay or its third party licensors (including in particular Mirics Limited) own all rights, title and interest in and to the Product and all modifications, enhancements and derivative works SDRplay may develop to or from the Product and any and all intellectual property rights in all of the foregoing. You agree not to use any of SDRplay’s or Mirics’ trademarks or other business names included in the Product for any purpose. You acknowledge that, except as expressly set out in this Licence, nothing in this Licence will give you rights in respect of any intellectual property rights owned by SDRplay or its licensors. All intellectual property rights and other rights of SDRplay and its licensors which are not expressly granted to you by this Licence are reserved. 
 
4.            Limited Warranty.  SDRplay warrants that the Product will, under normal operating conditions, operate substantially in accordance with SDRplay’ published specification for the Product. SDRplay does not represent or warrant that: (a) the use of the Product will be secure, timely, uninterrupted or error-free or compatible in combination with any other hardware, software, system or data; (b) the Product will meet your expectations; (c) errors or defects in the Product will be corrected; or that (d) the Product is free of viruses or other harmful components. SDRplay makes no representation and gives no warranty in respect of any Open Source Software component of the Product.
 
Except as expressly set out in this Licence, no implied conditions, warranties or other terms, including any implied terms relating to satisfactory quality or fitness for any purpose, will apply to the Product and, to the maximum extent permitted by applicable law, are excluded by SDRplay.
 
5.            SDRplay’ Liability.  Nothing in this Licence will limit or exclude SDRplay’ liability to you: (a) for death or personal injury caused by SDRplay’ negligence; (b) for fraud; (c) for breach of any obligations implied by section 12 of the Sale of Goods Act 1979 or section 2 of the Supply of Goods and Services Act 1982; or (d) for any other liability that may not, under applicable law, be limited or excluded. Subject to this, in no event will SDRplay be liable to you for any indirect or consequential losses, or for any loss of profit, revenue, contracts, data, goodwill or other similar losses, and any liability SDRplay does have for losses you suffer arising under or in connection with this Licence and/or the Product is strictly limited to losses that were reasonably foreseeable.

6.            Data.    The Product may, without further notification, transmit the serial number of an SDRplay device using the Product to an SDRplay server. No personal information, including but not limited to information about the computer running the Product or its location will be gathered or transmitted as part of this process.
                
7.            General.    You may not transfer or assign any or all of your rights and/or obligations under this Licence. All notices given by you to SDRplay must be given in writing to SDRplay’ registered office address. If SDRplay fails to enforce any of our rights, that does not result in a waiver of that right. If any provision of these terms and conditions is found to be unenforceable, all other provisions shall remain unaffected. The terms of this Licence may not be varied except with SDRplay’ express written consent. The terms of this Licence represent the entire agreement between you and SDRplay in relation to the subject matter of this Licence. The terms of this Licence shall be governed by English law and you agree that any claim you may have against SDRplay arising under or in connection with this Licence and/or the Product may only be dealt with by the English courts, provided that, if you are a consumer: (a) and you live in a part of the United Kingdom other than England, the applicable law of that part of the United Kingdom will govern and any claim may be brought by you before the courts there; or (b) you live in another member state of the European Union, any claim may be brought by you before the courts there.
*/

#ifndef SDRPLAY_API_H
#define SDRPLAY_API_H

#include "sdrplay_api_dev.h"
#include "sdrplay_api_rx_channel.h"
#include "sdrplay_api_callback.h"

#if defined(_M_X64) || defined(_M_IX86)
#include "windows.h"
#elif defined (__GNUC__)
typedef void *HANDLE;
#endif

#ifndef _SDRPLAY_DLL_QUALIFIER
#if !defined(STATIC_LIB) && (defined(_M_X64) || defined(_M_IX86)) 
#define _SDRPLAY_DLL_QUALIFIER __declspec(dllimport)
#elif defined(STATIC_LIB) || defined(__GNUC__) 
#define _SDRPLAY_DLL_QUALIFIER
#endif
#endif  // _SDRPLAY_DLL_QUALIFIER

// Application code should check that it is compiled against the same API version
// sdrplay_api_ApiVersion() returns the API version 
#define SDRPLAY_API_VERSION                   (float)(3.07)

// API Constants
#define SDRPLAY_MAX_DEVICES                   (16)
#define SDRPLAY_MAX_TUNERS_PER_DEVICE         (2)

#define SDRPLAY_MAX_SER_NO_LEN                (64)
#define SDRPLAY_MAX_ROOT_NM_LEN               (32)

#define SDRPLAY_RSP1_ID                       (1)
#define SDRPLAY_RSP1A_ID                      (255)
#define SDRPLAY_RSP2_ID                       (2)
#define SDRPLAY_RSPduo_ID                     (3)
#define SDRPLAY_RSPdx_ID                      (4)

// Enum types
typedef enum
{
    sdrplay_api_Success               = 0,
    sdrplay_api_Fail                  = 1,
    sdrplay_api_InvalidParam          = 2,
    sdrplay_api_OutOfRange            = 3,
    sdrplay_api_GainUpdateError       = 4,
    sdrplay_api_RfUpdateError         = 5,
    sdrplay_api_FsUpdateError         = 6,
    sdrplay_api_HwError               = 7,
    sdrplay_api_AliasingError         = 8,
    sdrplay_api_AlreadyInitialised    = 9,
    sdrplay_api_NotInitialised        = 10,
    sdrplay_api_NotEnabled            = 11,
    sdrplay_api_HwVerError            = 12,
    sdrplay_api_OutOfMemError         = 13,
    sdrplay_api_ServiceNotResponding  = 14,
    sdrplay_api_StartPending          = 15,
    sdrplay_api_StopPending           = 16,
    sdrplay_api_InvalidMode           = 17,
    sdrplay_api_FailedVerification1   = 18,
    sdrplay_api_FailedVerification2   = 19,
    sdrplay_api_FailedVerification3   = 20,
    sdrplay_api_FailedVerification4   = 21,
    sdrplay_api_FailedVerification5   = 22,
    sdrplay_api_FailedVerification6   = 23,
    sdrplay_api_InvalidServiceVersion = 24
} sdrplay_api_ErrT;

typedef enum
{
    sdrplay_api_Update_None                        = 0x00000000,

    // Reasons for master only mode 
    sdrplay_api_Update_Dev_Fs                      = 0x00000001,
    sdrplay_api_Update_Dev_Ppm                     = 0x00000002,
    sdrplay_api_Update_Dev_SyncUpdate              = 0x00000004,
    sdrplay_api_Update_Dev_ResetFlags              = 0x00000008,

    sdrplay_api_Update_Rsp1a_BiasTControl          = 0x00000010,
    sdrplay_api_Update_Rsp1a_RfNotchControl        = 0x00000020,
    sdrplay_api_Update_Rsp1a_RfDabNotchControl     = 0x00000040,

    sdrplay_api_Update_Rsp2_BiasTControl           = 0x00000080,
    sdrplay_api_Update_Rsp2_AmPortSelect           = 0x00000100,
    sdrplay_api_Update_Rsp2_AntennaControl         = 0x00000200,
    sdrplay_api_Update_Rsp2_RfNotchControl         = 0x00000400,
    sdrplay_api_Update_Rsp2_ExtRefControl          = 0x00000800,

    sdrplay_api_Update_RspDuo_ExtRefControl        = 0x00001000,

    sdrplay_api_Update_Master_Spare_1              = 0x00002000,
    sdrplay_api_Update_Master_Spare_2              = 0x00004000,

    // Reasons for master and slave mode
    // Note: sdrplay_api_Update_Tuner_Gr MUST be the first value defined in this section!
    sdrplay_api_Update_Tuner_Gr                    = 0x00008000,
    sdrplay_api_Update_Tuner_GrLimits              = 0x00010000,
    sdrplay_api_Update_Tuner_Frf                   = 0x00020000,
    sdrplay_api_Update_Tuner_BwType                = 0x00040000,
    sdrplay_api_Update_Tuner_IfType                = 0x00080000,
    sdrplay_api_Update_Tuner_DcOffset              = 0x00100000,
    sdrplay_api_Update_Tuner_LoMode                = 0x00200000,

    sdrplay_api_Update_Ctrl_DCoffsetIQimbalance    = 0x00400000,
    sdrplay_api_Update_Ctrl_Decimation             = 0x00800000,
    sdrplay_api_Update_Ctrl_Agc                    = 0x01000000,
    sdrplay_api_Update_Ctrl_AdsbMode               = 0x02000000,
    sdrplay_api_Update_Ctrl_OverloadMsgAck         = 0x04000000,

    sdrplay_api_Update_RspDuo_BiasTControl         = 0x08000000,
    sdrplay_api_Update_RspDuo_AmPortSelect         = 0x10000000,
    sdrplay_api_Update_RspDuo_Tuner1AmNotchControl = 0x20000000,
    sdrplay_api_Update_RspDuo_RfNotchControl       = 0x40000000,
    sdrplay_api_Update_RspDuo_RfDabNotchControl    = 0x80000000,
} sdrplay_api_ReasonForUpdateT;

typedef enum
{
    sdrplay_api_Update_Ext1_None                   = 0x00000000,

    // Reasons for master only mode 
    sdrplay_api_Update_RspDx_HdrEnable             = 0x00000001,
    sdrplay_api_Update_RspDx_BiasTControl          = 0x00000002,
    sdrplay_api_Update_RspDx_AntennaControl        = 0x00000004,
    sdrplay_api_Update_RspDx_RfNotchControl        = 0x00000008,
    sdrplay_api_Update_RspDx_RfDabNotchControl     = 0x00000010,
    sdrplay_api_Update_RspDx_HdrBw                 = 0x00000020,

    // Reasons for master and slave mode
} sdrplay_api_ReasonForUpdateExtension1T;

typedef enum
{
    sdrplay_api_DbgLvl_Disable       = 0,
    sdrplay_api_DbgLvl_Verbose       = 1,
    sdrplay_api_DbgLvl_Warning       = 2,
    sdrplay_api_DbgLvl_Error         = 3,
    sdrplay_api_DbgLvl_Message       = 4,
} sdrplay_api_DbgLvl_t;

// Device structure 
typedef struct 
{
    char SerNo[SDRPLAY_MAX_SER_NO_LEN];
    unsigned char hwVer;
    sdrplay_api_TunerSelectT tuner;
    sdrplay_api_RspDuoModeT rspDuoMode;
    double rspDuoSampleFreq;
    HANDLE dev;
} sdrplay_api_DeviceT;

// Device parameter structure
typedef struct 
{
    sdrplay_api_DevParamsT       *devParams;
    sdrplay_api_RxChannelParamsT *rxChannelA;
    sdrplay_api_RxChannelParamsT *rxChannelB;
} sdrplay_api_DeviceParamsT;

// Extended error message structure
typedef struct 
{
    char file[256];
    char function[256];
    int  line;
    char message[1024];
} sdrplay_api_ErrorInfoT;

// Comman API function types
typedef sdrplay_api_ErrT        (*sdrplay_api_Open_t)(void);    
typedef sdrplay_api_ErrT        (*sdrplay_api_Close_t)(void);    
typedef sdrplay_api_ErrT        (*sdrplay_api_ApiVersion_t)(float *apiVer);    
typedef sdrplay_api_ErrT        (*sdrplay_api_LockDeviceApi_t)(void);    
typedef sdrplay_api_ErrT        (*sdrplay_api_UnlockDeviceApi_t)(void);    
typedef sdrplay_api_ErrT        (*sdrplay_api_GetDevices_t)(sdrplay_api_DeviceT *devices, unsigned int *numDevs, unsigned int maxDevs);    
typedef sdrplay_api_ErrT        (*sdrplay_api_SelectDevice_t)(sdrplay_api_DeviceT *device);    
typedef sdrplay_api_ErrT        (*sdrplay_api_ReleaseDevice_t)(sdrplay_api_DeviceT *device);    
typedef const char*             (*sdrplay_api_GetErrorString_t)(sdrplay_api_ErrT err);
typedef sdrplay_api_ErrorInfoT* (*sdrplay_api_GetLastError_t)(sdrplay_api_DeviceT *device);
typedef sdrplay_api_ErrT        (*sdrplay_api_DisableHeartbeat_t)(void);

// Device API function types
typedef sdrplay_api_ErrT        (*sdrplay_api_DebugEnable_t)(HANDLE dev, sdrplay_api_DbgLvl_t dbgLvl); 
typedef sdrplay_api_ErrT        (*sdrplay_api_GetDeviceParams_t)(HANDLE dev, sdrplay_api_DeviceParamsT **deviceParams); 
typedef sdrplay_api_ErrT        (*sdrplay_api_Init_t)(HANDLE dev, sdrplay_api_CallbackFnsT *callbackFns, void *cbContext); 
typedef sdrplay_api_ErrT        (*sdrplay_api_Uninit_t)(HANDLE dev);
typedef sdrplay_api_ErrT        (*sdrplay_api_Update_t)(HANDLE dev, sdrplay_api_TunerSelectT tuner, sdrplay_api_ReasonForUpdateT reasonForUpdate, sdrplay_api_ReasonForUpdateExtension1T reasonForUpdateExt1);
typedef sdrplay_api_ErrT        (*sdrplay_api_SwapRspDuoActiveTuner_t)(HANDLE dev, sdrplay_api_TunerSelectT *tuner, sdrplay_api_RspDuo_AmPortSelectT tuner1AmPortSel);
typedef sdrplay_api_ErrT        (*sdrplay_api_SwapRspDuoDualTunerModeSampleRate_t)(double *currentSampleRate);
typedef sdrplay_api_ErrT        (*sdrplay_api_SwapRspDuoMode_t)(sdrplay_api_DeviceT *currDevice, sdrplay_api_DeviceParamsT **deviceParams,
                                                                sdrplay_api_RspDuoModeT rspDuoMode, double sampleRate, sdrplay_api_TunerSelectT tuner,
                                                                sdrplay_api_Bw_MHzT bwType, sdrplay_api_If_kHzT ifType, sdrplay_api_RspDuo_AmPortSelectT tuner1AmPortSel);

// API function definitions
#ifdef __cplusplus
extern "C"
{
#endif

    // Comman API function definitions
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_Open(void);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_Close(void);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_ApiVersion(float *apiVer);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_LockDeviceApi(void);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_UnlockDeviceApi(void);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_GetDevices(sdrplay_api_DeviceT *devices, unsigned int *numDevs, unsigned int maxDevs);    
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_SelectDevice(sdrplay_api_DeviceT *device);   
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_ReleaseDevice(sdrplay_api_DeviceT *device);   
    _SDRPLAY_DLL_QUALIFIER const char*             sdrplay_api_GetErrorString(sdrplay_api_ErrT err);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrorInfoT* sdrplay_api_GetLastError(sdrplay_api_DeviceT *device);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_DisableHeartbeat(void); // Must be called before sdrplay_api_SelectDevice()

    // Device API function definitions
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_DebugEnable(HANDLE dev, sdrplay_api_DbgLvl_t enable); 
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_GetDeviceParams(HANDLE dev, sdrplay_api_DeviceParamsT **deviceParams); 
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_Init(HANDLE dev, sdrplay_api_CallbackFnsT *callbackFns, void *cbContext); 
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_Uninit(HANDLE dev);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_Update(HANDLE dev, sdrplay_api_TunerSelectT tuner, sdrplay_api_ReasonForUpdateT reasonForUpdate, sdrplay_api_ReasonForUpdateExtension1T reasonForUpdateExt1);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_SwapRspDuoActiveTuner(HANDLE dev, sdrplay_api_TunerSelectT *currentTuner, sdrplay_api_RspDuo_AmPortSelectT tuner1AmPortSel);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_SwapRspDuoDualTunerModeSampleRate(HANDLE dev, double *currentSampleRate);
    _SDRPLAY_DLL_QUALIFIER sdrplay_api_ErrT        sdrplay_api_SwapRspDuoMode(sdrplay_api_DeviceT *currDevice, sdrplay_api_DeviceParamsT **deviceParams,
                                                                              sdrplay_api_RspDuoModeT rspDuoMode, double sampleRate, sdrplay_api_TunerSelectT tuner,
                                                                              sdrplay_api_Bw_MHzT bwType, sdrplay_api_If_kHzT ifType, sdrplay_api_RspDuo_AmPortSelectT tuner1AmPortSel);

#ifdef __cplusplus
}
#endif

#endif //SDRPLAY_API_H
