list(APPEND B2_OPTIONS cxxstd=20)

set(unsupported_compiler FALSE)

if(VCPKG_DETECTED_CMAKE_CXX_COMPILER_ID STREQUAL "Clang" OR VCPKG_DETECTED_CMAKE_CXX_COMPILER_ID STREQUAL "AppleClang")
  if(VCPKG_DETECTED_CMAKE_CXX_COMPILER_VERSION VERSION_LESS "14")
    set(unsupported_compiler TRUE)
  endif()
  if(VCPKG_DETECTED_CMAKE_CXX_COMPILER_VERSION VERSION_LESS "16")
    list(APPEND B2_OPTIONS "boost.cobalt.pmr=boost-container")
  endif()
elseif(VCPKG_DETECTED_CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
  if(VCPKG_DETECTED_CMAKE_CXX_COMPILER_VERSION VERSION_LESS "10")
    set(unsupported_compiler TRUE)
  endif()
elseif(VCPKG_DETECTED_CMAKE_CXX_COMPILER_ID STREQUAL "MSVC")
  if (VCPKG_DETECTED_MSVC_VERSION LESS "1930")
    set(unsupported_compiler TRUE)
  endif()
endif()

if(unsupported_compiler)
  message(FATAL_ERROR "Boost.Cobalt is supported since Clang 14, GCC 10 and MSVC 19.30 (Visual Studio 2022). Detected compiler is ${VCPKG_DETECTED_CMAKE_CXX_COMPILER_ID} ${VCPKG_DETECTED_MSVC_VERSION}.")
endif()
