# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 12)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-3d               fe66aebdfda50c75f588d5dfc1c48c4d39c1e7aa29ee342178016a10ca24dfa00284f89839810121d15aac40d47fcd471f7a3573892210a0abf14e247102a66d)
set(QT_HASH_qt5-activeqt         4afd89ccfb142dd72841d0d5129ef2175106c31b7a710ebd6f630cca18da2009b1fcd3b094e769f2ea24d4f67e9302441b8fdd80174823328fa3d22ad5957e7c)
set(QT_HASH_qt5-androidextras    b181b8e42c19ca2946245cbcdbe19ba8c1fd1f9ab6988a6d1b920bb1895019372b529626789953722ccf28805f9171146d3bc38c3f0c72ed5511a1753ec38e00)
set(QT_HASH_qt5-base             55ed3d73c2486a5f7cc62c0669b6344d1e4566be442bdac5849609f5ecd4fec7b74405952215e4dc018bc48a9dc2305ef50e31b61f3ace20408b5b64a2d5e888)
set(QT_HASH_qt5-charts           543c9fe0dfd04f19407d3c11c2a1ed93da34b493cfb758b4b2a9e86a7325476e1f754de3281e366eff52e96d8f12fb44c9ff8f3e047069c409cb171687d11df4)
set(QT_HASH_qt5-connectivity     36cbdaf63e7f478a5bb1b51d14b8671a24251614fc99d07cab195a596a9b60f28dd013c5f2a3af914f655a12725b1e6e2318324393ee0f0586c746a1a670f224)
set(QT_HASH_qt5-datavis3d        6a734bd1e3296aaae94358e2315a7c4b033b113b27b9e1e75f0d888231c11c2fdf1caa17c40c4ed545ad8e4a735766368c1bf04e6b36e53ba3164f0f8d66a1c6)
set(QT_HASH_qt5-declarative      3ebe195dac22efa2e71a4520e4816592204431bc724d94a38d9f426424624990199f7e99b72c7d96f6ae324bb18b7eec89ea2b5db63ff2f1d24a997be25a0589)
set(QT_HASH_qt5-doc              46133676da2584c533bbe78d8eef12f2b1baa95e91168f7fa3400e58046c36a31064f6198f40e1679224da8824e642c6f610fba125b71e91399069019eaf68e6)
set(QT_HASH_qt5-gamepad          8a5f6c8fac4e7977b1c93efda698e27c6bc1e66b844f86642ae05ba104d8f14f30e6cb95ba4b3923e2e43d117af52354cfb5a6d35ffd159e29a336710fc63f93)
set(QT_HASH_qt5-graphicaleffects c0993082e96c5d8e26cc4e2e45320542d21fb7c716dfb6b087b385a985fff358cdff7e3d5d4ca3fc8fc9813e7c110165aa034d5e8d32e8082ad007b7bf929531)
set(QT_HASH_qt5-imageformats     c56e70e17ed29ff126257ce41e2b9fd03807f0325ac60bd307779406dcea39ff929e49d2ea99ab17f07f19a6dda5f5103d4def6bb70a52f761141fc4b2c46e7c)
set(QT_HASH_qt5-location         c480762cea2cd1a00e6061bab05c402d5aab2d12e7decebcd606c930d2029a93f2a46f8edbb188b73c7cdcad473b03c15037ea10e0b3538de0a99b1d7d7fb333)
set(QT_HASH_qt5-macextras        205fc0747dff5a7e8b199ccf82675484064e71c4267741fb1ae7ab4961436d8e645126dd548b9236f27f29379a297a1efce82a1f8589f081aadd752a9875034e)
set(QT_HASH_qt5-mqtt             eaad1a8b8ad3f18181e5840dca725a9ac445ef0cdacb3eaffc682e145f6db2f4ffd1742329b2ea57653ba3d1a7168c3e9e531b9f48784ca2fef726197b4b50a4)
set(QT_HASH_qt5-multimedia       2cef917df20da1381ea64834e4110e25ea0d5e12249176ddbe2e0314c25490926ccbf2f7cc3f89b2969d113a645ec88244fabe691aff851ffb4b2be9766bcf76)
set(QT_HASH_qt5-networkauth      f0c48453e21ad14a4fbac25d35e6257c4d8bbb5f2ac87dad0deee44ca86aec8def618f102cd1d9af05e1611f37ea722e1630165f15a238d3d8c38d161771bc3d)
set(QT_HASH_qt5-purchasing       5a5e8ca1de6155b20164e5f3e28daaed424afa05b1ddae3c07207e056183fb6dfce71a9de9c9c8ca1bb1e10ecb02139db79b0e5e701e8c11c6514274e21e5069)
set(QT_HASH_qt5-quickcontrols    980b233f83991d12029bac90b0875b3a001399d4358c58185a21bbb30911f0d6fec5dfc5f157e9c3c4d17e82c3ff5302e55c62b4cd63731f23a655bd55d300bb)
set(QT_HASH_qt5-quickcontrols2   725fb03907973fdca4479017b8f792110a4620a6e4d39f97c81c3be16280b81135394f6ce5be507fd734926307d33a249e790234139e01f387d2362cd7027128)
set(QT_HASH_qt5-remoteobjects    fef775ccbc187064ef3e2cb73f9bc784c002bf74d89032a33767cb234ff40ea07eb5294eb919a50cede2afbf539e32c6c78df52817bc22a10617585e417c3690)
set(QT_HASH_qt5-script           48a00763686a5455d0429d1ecd6b32e3e96a13f05faa6625361c49b91275b8a8b3a1de3627cc3db5c69d346686c07b9466022cf37abf394a6f097933b9dbed4a)
set(QT_HASH_qt5-scxml            c451fa8fc5999aa7e3b3a336503bcf1ccc8992ef27645d003c938166384508d2cc9b35fbd21e9da641ea98a2aaa58834ac85e8713bce25b96e4aef79c3cda976)
set(QT_HASH_qt5-sensors          25d4eb1ea43c5d7819a7b9cee22604b774007f84bdc86433f673766b1943134c5880be14ab06fac7f05fb2708491cb8b7e03f8656aae0d74538d732e31ffd917)
set(QT_HASH_qt5-serialbus        d6571b6d54fe91ff945c0bd51bcecb97ae3d001ee3e1f30deb042a52bab17ad7e059ae943c0a3f2a4d6e7a952cb3f68b71275cef0fda1875fd233c8dc17d0d3c)
set(QT_HASH_qt5-serialport       f27adbc07a3c3e946761e033105377ae26ac48d2c796f281947e950de1b7b9fb5a25627fd1a2c30cccd2de19181867cfd7d4a740a3318348e57885b5d96c7192)
set(QT_HASH_qt5-speech           960eb661cfeb8a4fc01337ac998bc8ce101da73782155e75a7b128987d9809fa1e4cc6fee30cfa3cbd39f7fff9bbe7e49e55430681ac6582e7c8110242d7183a)
set(QT_HASH_qt5-svg              c68fa1bc8e3dc782a70049aeddca62731b48ff7de972d6e1a245b06d23c0795fd6a3e3538aa39a92016d5c15a068f7b8ae1d3b6bd950fb7857a7aa2ed556f857)
set(QT_HASH_qt5-tools            d830129777c481e1a66e32911af82a09e2858b678fdd2b802433fc1009856d9f0b8ea39b6ed1d7e93b6e9db1dda848c3a4077f6d804400f1427f33a3c7ccb40e)
set(QT_HASH_qt5-translations     675e0902bbd6a1f910ffc0473e1e865239cf820886fff9ccc3c5cf69f6a9af862fa1e44d86538f2884f1a34ab433dc2615707487b426d56742bd26f8f0d9924a)
set(QT_HASH_qt5-virtualkeyboard  17c63ea6287f7dbc84c82762ea43da9fbb4d1c7281a4e81971c10eacfbfe7293a855dde35a37ed9c8cf5ccc289a0e1d0a0c970e6908cea5cae15f149b9f5e3c4)
set(QT_HASH_qt5-wayland          acd78018665db3d0d77a84bb80ce7dbb65a33e0e813c3308e09a27195df204029b5e580f353eae2536e6fdde249aa34411e37f4f1663f7645448d96c9df67a66)
set(QT_HASH_qt5-webchannel       8b4f3c787e88a68a9b850c7c700e37b491ff17435871223fd70373a532e4d8c6d809d4b8ca0036b68f99852dbd80e21e45aa2ee2d89efffab1182fdf792d0d59)
set(QT_HASH_qt5-webengine        84ebdab10ea3138671c0612cc558dd3257264410d2776719c34d41b8f846424183742abc7185fa61c7bb3d35d471ab2341d064eec57b92c34e30325dbc3eff63)
set(QT_HASH_qt5-webglplugin      97670f47e582ec921c409b346f08bc70040a982811d9df967635900e4654b7069ca22ba5a6504b0f8a6b0022c317ffa71a3b60043212078d2b29cb1d2daf69ae)
set(QT_HASH_qt5-websockets       01195f4b2f11baa66e1b3d08148c234ac979d1a80be28d72b2bb8cd57f053102f432f59b7b89daa66d0e27c6e5ee792da12772d70c76aa88fa1bbe114b6f675a)
set(QT_HASH_qt5-webview          eaabc534a116617dee0394afdb4d35525aa367d01d974c4759c02781a7e4af2fa2d096c638109b421d2b061df4476348d8471a9a02f6f05b97170366c973ef61)
set(QT_HASH_qt5-winextras        da230ee9c9afccad83573a678c641f22f85ab45d7063406ef1b1922097b4b41fca9f1ca81256bba835e71a3f59f6280601f9fad3f7d5be74e436a242e3ef45eb)
set(QT_HASH_qt5-x11extras        f346f399a79aece2635e3871d86302042834d17be143adbfa130ea91a6cd692211804c50e74cecb072a5d7c388f3fbf774b2b40b0fc86498b84552da7b213fe7)
set(QT_HASH_qt5-xmlpatterns      762c1c64e8ab269bf74de86f08afd50822859716024f3b13a70b719aeedfd35fd705fa03e32220f5cfab579361e754823d8bd584b30bde5965b026aa54b97142)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
