vcpkg_from_git(
    OUT_SOURCE_PATH SOURCE_PATH
    URL https://github.com/Ipotrick/Daxa
    REF 61b699ac12de475cf4a79bc99106b865acddaf18
)

vcpkg_check_features(OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
    utils-imgui WITH_UTILS_IMGUI
    utils-mem WITH_UTILS_MEM
    utils-pipeline-manager-glslang WITH_UTILS_PIPELINE_MANAGER_GLSLANG
    utils-pipeline-manager-spirv-validation WITH_UTILS_PIPELINE_MANAGER_SPIRV_VALIDATION
    utils-task-graph WITH_UTILS_TASK_GRAPH
)
set(DAXA_DEFINES)

if(WITH_UTILS_IMGUI)
    list(APPEND DAXA_DEFINES "-DDAXA_ENABLE_UTILS_IMGUI=true")
endif()
if(WITH_UTILS_MEM)
    list(APPEND DAXA_DEFINES "-DDAXA_ENABLE_UTILS_MEM=true")
endif()
if(WITH_UTILS_PIPELINE_MANAGER_GLSLANG)
    list(APPEND DAXA_DEFINES "-DDAXA_ENABLE_UTILS_PIPELINE_MANAGER_GLSLANG=true")
endif()
if(WITH_UTILS_PIPELINE_MANAGER_SPIRV_VALIDATION)
    list(APPEND DAXA_DEFINES "-DDAXA_ENABLE_UTILS_PIPELINE_MANAGER_SPIRV_VALIDATION=true")
endif()
if(WITH_UTILS_TASK_GRAPH)
    list(APPEND DAXA_DEFINES "-DDAXA_ENABLE_UTILS_TASK_GRAPH=true")
endif()

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        ${DAXA_DEFINES}
        -DCMAKE_REQUIRE_FIND_PACKAGE_X11=ON
        -DCMAKE_REQUIRE_FIND_PACKAGE_WAYLAND=ON
    MAYBE_UNUSED_VARIABLES
        CMAKE_REQUIRE_FIND_PACKAGE_X11
        CMAKE_REQUIRE_FIND_PACKAGE_WAYLAND
)

vcpkg_cmake_install()
vcpkg_cmake_config_fixup()
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(INSTALL "${SOURCE_PATH}/LICENSE"
    DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}"
    RENAME copyright
)
