/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.SimpleResolver;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestSubsetCombination
extends BaseVStreamTest {
    public void testValidSubsets() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'dummy-url' [\n<!ELEMENT root (leaf+)>\n<!ATTLIST root attrInt CDATA #IMPLIED>\n<!ENTITY ent1 '&ent2;'>\n]><root attrInt='value' attrExt='someValue'>  <leaf>Test entities: &ent1;, &ent2;</leaf><leaf>...</leaf><leaf /></root>";
        String EXT_DTD = "<!ELEMENT leaf (#PCDATA)>\n<!ENTITY ent2 'some text'>\n<!ATTLIST root attrExt CDATA #IMPLIED>\n";
        this.streamThrough(this.getReader(XML, true, EXT_DTD));
        this.streamThrough(this.getReader(XML, false, EXT_DTD));
    }

    public void testAttributePrecedence() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'dummy-url' [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr1 CDATA #IMPLIED>\n<!ATTLIST root attr2 CDATA 'intValue'>\n]><root />";
        String EXT_DTD = "<!ATTLIST root attr1 CDATA 'extValue'>\n<!ATTLIST root attr2 CDATA #IMPLIED>\n";
        XMLStreamReader sr = this.getReader(XML, true, EXT_DTD);
        TestSubsetCombination.assertTokenType(11, sr.next());
        TestSubsetCombination.assertTokenType(1, sr.next());
        TestSubsetCombination.assertEquals((int)1, (int)sr.getAttributeCount());
        TestSubsetCombination.assertEquals((String)"attr2", (String)sr.getAttributeLocalName(0));
        TestSubsetCombination.assertEquals((String)"intValue", (String)sr.getAttributeValue(0));
        TestSubsetCombination.assertFalse((boolean)sr.isAttributeSpecified(0));
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, String extSubset) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestSubsetCombination.setNamespaceAware(f, nsAware);
        TestSubsetCombination.setSupportDTD(f, true);
        TestSubsetCombination.setCoalescing(f, false);
        TestSubsetCombination.setReplaceEntities(f, true);
        TestSubsetCombination.setValidating(f, true);
        if (extSubset != null) {
            TestSubsetCombination.setResolver(f, new SimpleResolver(extSubset));
        } else {
            TestSubsetCombination.setResolver(f, null);
        }
        return TestSubsetCombination.constructStreamReader(f, contents);
    }
}

