/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestNotationAttrRead
extends BaseVStreamTest {
    public TestNotationAttrRead(String name) {
        super(name);
    }

    public void testValidAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'some-public-id'>\n<!NOTATION not2 PUBLIC 'other-public-id'>\n<!ATTLIST root notation NOTATION (not1 | not2) #IMPLIED>]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'some-public-id'>\n<!NOTATION not2 PUBLIC 'other-public-id'>\n<!ATTLIST root notation NOTATION (not1 | not2) 'not1'>]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root notation NOTATION (not1) #IMPLIED>]>\n<root />";
        XMLStreamReader sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "undeclared notation");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'some-public-id'>\n<!ATTLIST root notation NOTATION (not1) #IMPLIED   notation2 NOTATION (not1) #IMPLIED>\n]>\n<root />";
        sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "more than one notation attribute per element");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'some-public-id'>\n<!NOTATION not2 PUBLIC 'some-other-public-id'>\n<!ATTLIST root notation NOTATION (not1 | not2 | not1) #IMPLIED>\n]>\n<root />";
        sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "duplicate notation values enumerated for attribute");
    }

    public void testValidAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!NOTATION notVal PUBLIC 'foobar'>\n<!NOTATION notVal2 PUBLIC 'whatever'>\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem not NOTATION (notVal | notVal2) #IMPLIED>\n]>\n<elem not='notVal2' />";
        this.streamThrough(this.getReader(XML));
    }

    public void testInvalidAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!NOTATION notVal PUBLIC 'foobar'>\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem not NOTATION (notVal) #IMPLIED>\n]>\n<elem not='undefdNotValue' />";
        XMLStreamReader sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "reference to notation that is not enumerated");
        XML = "<!DOCTYPE elem [\n<!NOTATION notVal PUBLIC 'foobar'>\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem not NOTATION (notVal) 'not'>\n]>\n<elem />";
        sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "reference to notation (via default value) that is not enumerated");
    }

    private XMLStreamReader getReader(String contents) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestNotationAttrRead.setCoalescing(f, false);
        TestNotationAttrRead.setSupportDTD(f, true);
        TestNotationAttrRead.setValidating(f, true);
        return TestNotationAttrRead.constructStreamReader(f, contents);
    }
}

