/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestEnumAttrRead
extends BaseVStreamTest {
    public TestEnumAttrRead(String name) {
        super(name);
    }

    public void testValidAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr (enum) #IMPLIED\n attr2 (enum|enum2) #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML, true));
    }

    public void testValidAttrDecl2() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr (- | on | -- | off-white) #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getReader(XML));
    }

    public void testInvalidAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr (enum | enum2 | enum) #IMPLIED>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML, true), "duplicate enumeration in attribute declaration");
    }

    public void testValidAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr (  enum) #IMPLIED\n attr2 (enum | enum2  ) #IMPLIED>\n]><root attr2='enum2' />";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestEnumAttrRead.assertTokenType(11, sr.next());
        TestEnumAttrRead.assertTokenType(1, sr.next());
        TestEnumAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEnumAttrRead.assertEquals((String)"attr2", (String)sr.getAttributeLocalName(0));
        TestEnumAttrRead.assertEquals((String)"enum2", (String)sr.getAttributeValue(0));
    }

    public void testEnumAttrNormalization() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem enumAttr (enum | enum2|last  ) #IMPLIED>\n]><elem enumAttr='enum2  '><elem enumAttr='   enum' /><elem enumAttr='\tlast' /></elem>";
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestEnumAttrRead.assertTokenType(11, sr.next());
        TestEnumAttrRead.assertTokenType(1, sr.next());
        TestEnumAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEnumAttrRead.assertEquals((String)"enum2", (String)sr.getAttributeValue(0));
        TestEnumAttrRead.assertTokenType(1, sr.next());
        TestEnumAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEnumAttrRead.assertEquals((String)"enum", (String)sr.getAttributeValue(0));
        TestEnumAttrRead.assertTokenType(2, sr.next());
        TestEnumAttrRead.assertTokenType(1, sr.next());
        TestEnumAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEnumAttrRead.assertEquals((String)"last", (String)sr.getAttributeValue(0));
        TestEnumAttrRead.assertTokenType(2, sr.next());
        TestEnumAttrRead.assertTokenType(2, sr.next());
    }

    private XMLStreamReader getReader(String contents) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEnumAttrRead.setCoalescing(f, false);
        TestEnumAttrRead.setSupportDTD(f, true);
        TestEnumAttrRead.setValidating(f, true);
        return TestEnumAttrRead.constructStreamReader(f, contents);
    }
}

