/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestAttrRead
extends BaseVStreamTest {
    public TestAttrRead(String name) {
        super(name);
    }

    public void testValidAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST element attr CDATA #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML, true));
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ATTLIST root attr CDATA #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML, true));
    }

    public void testAttributeTypes() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root cdata CDATA #IMPLIED>\n<!ATTLIST root id ID #IMPLIED>\n<!ATTLIST root nmtoken NMTOKEN #IMPLIED>\n<!ATTLIST root nmtokens NMTOKENS #IMPLIED>\n]><root cdata='content' id='node1' nmtoken='token' nmtokens='token1 token2'/>";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)4, (int)sr.getAttributeCount());
        for (int i = 0; i < 4; ++i) {
            String ln = sr.getAttributeLocalName(i);
            String type = sr.getAttributeType(i);
            String expType = ln.toUpperCase();
            TestAttrRead.assertNotNull((Object)"Attribute type should never be null; CDATA should be returned if information not known/available");
            TestAttrRead.assertEquals((String)("Incorrect attribute type for attribute '" + ln + "'"), (String)expType, (String)type);
        }
        TestAttrRead.assertTokenType(2, sr.next());
    }

    public void testValidRequiredAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #REQUIRED>\n]><root attr='value' />";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"value", (String)sr.getAttributeValue(0));
    }

    public void testInvalidRequiredAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #REQUIRED>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML, true), "Missing required attribute value");
    }

    public void testOkFixedAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem EMPTY>\n<!ATTLIST elem attr CDATA #FIXED 'fixed'>\n]><elem/>";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((String)"Should have 1 attribute; 'elem' had #FIXED default value", (int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"fixed", (String)sr.getAttributeValue(0));
        TestAttrRead.assertTokenType(2, sr.next());
        sr.close();
        XML = "<!DOCTYPE elem [\n<!ELEMENT elem EMPTY>\n<!ATTLIST elem attr CDATA #FIXED 'fixed'>\n]><elem attr='fixed'/>";
        sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"fixed", (String)sr.getAttributeValue(0));
        TestAttrRead.assertTokenType(2, sr.next());
    }

    public void testInvalidFixedAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #FIXED 'fixed'>\n]>\n<root attr='wrong'/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "fixed attribute value not matching declaration");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #FIXED 'fixed'>\n]>\n<root attr=' fixed '/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "fixed attribute value not matching declaration");
    }

    public void testDefaultAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA 'default'>\n]><root/>";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"default", (String)sr.getAttributeValue(0));
    }

    public void testMultipleDeclForSingleAttr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA 'val1'>\n<!ATTLIST root attr CDATA 'val2'>\n]><root/>";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"val1", (String)sr.getAttributeValue(0));
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root attr NMTOKEN #IMPLIED>\n<!ATTLIST root attr CDATA #IMPLIED>\n]><root attr='valX'/>";
        sr = this.getValidatingReader(XML, true);
        TestAttrRead.assertTokenType(11, sr.next());
        TestAttrRead.assertTokenType(1, sr.next());
        TestAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttrRead.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestAttrRead.assertEquals((String)"valX", (String)sr.getAttributeValue(0));
        TestAttrRead.assertEquals((String)"NMTOKEN", (String)sr.getAttributeType(0));
    }
}

