/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestXmlDecl
extends BaseStreamTest {
    final String VALID_XML1 = "<?xml version='1.0'?><root />";
    final String VALID_XML_UTF8 = "<?xml version='1.0' encoding='UTF-8' ?><root />";

    public TestXmlDecl(String name) {
        super(name);
    }

    public void testProperties() throws XMLStreamException {
        this.doTestProperties(false);
        this.doTestProperties(true);
    }

    public void testValidDecl() throws XMLStreamException, IOException {
        this.doTestValid(false);
        this.doTestValid(true);
    }

    public void testValidStandaloneDecls() throws XMLStreamException, IOException {
        String XML = "<?xml version='1.0' standalone='yes' ?><root />";
        XMLStreamReader sr = this.getReader(XML, true);
        TestXmlDecl.assertEquals((String)"1.0", (String)sr.getVersion());
        TestXmlDecl.assertTrue((String)"XMLStreamReader.standalonSet() should be true", (boolean)sr.standaloneSet());
        TestXmlDecl.assertTrue((String)"XMLStreamReader.isStandalone() should be true", (boolean)sr.isStandalone());
        XML = "<?xml version='1.0' standalone='no' ?><root />";
        sr = this.getReader(XML, true);
        TestXmlDecl.assertEquals((String)"1.0", (String)sr.getVersion());
        TestXmlDecl.assertTrue((String)"XMLStreamReader.standalonSet() should be true", (boolean)sr.standaloneSet());
        TestXmlDecl.assertFalse((String)"XMLStreamReader.isStandalone() should be false", (boolean)sr.isStandalone());
        XML = "<?xml version='1.0' encoding='US-ASCII' standalone='yes' ?><root />";
        sr = this.getReader(XML, true);
        TestXmlDecl.assertEquals((String)"1.0", (String)sr.getVersion());
        TestXmlDecl.assertTrue((String)"XMLStreamReader.standalonSet() should be true", (boolean)sr.standaloneSet());
        TestXmlDecl.assertTrue((String)"XMLStreamReader.isStandalone() should be true", (boolean)sr.isStandalone());
        TestXmlDecl.assertEquals((String)"US-ASCII", (String)sr.getCharacterEncodingScheme());
    }

    public void testInvalidDecl() throws XMLStreamException {
        this.doTestInvalid(false);
        this.doTestInvalid(true);
    }

    private void doTestProperties(boolean nsAware) throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<?xml version='1.0'?><root />", nsAware);
        TestXmlDecl.assertEquals((int)7, (int)sr.getEventType());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.isStartElement());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.isEndElement());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.hasName());
        TestXmlDecl.assertEquals((boolean)false, (boolean)sr.hasText());
        TestXmlDecl.assertNotNull((Object)sr.getLocation());
        if (nsAware) {
            TestXmlDecl.assertNotNull((Object)sr.getNamespaceContext());
        }
        for (int i = 0; i < 8; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getName";
                        result = sr.getName();
                        break;
                    }
                    case 1: {
                        method = "getPrefix";
                        result = sr.getPrefix();
                        break;
                    }
                    case 2: {
                        method = "getLocalName";
                        result = sr.getLocalName();
                        break;
                    }
                    case 3: {
                        method = "getNamespaceURI";
                        result = sr.getNamespaceURI();
                        break;
                    }
                    case 4: {
                        method = "getNamespaceCount";
                        result = new Integer(sr.getNamespaceCount());
                        break;
                    }
                    case 5: {
                        method = "getAttributeCount";
                        result = new Integer(sr.getAttributeCount());
                        break;
                    }
                    case 6: {
                        method = "getPITarget";
                        result = sr.getPITarget();
                        break;
                    }
                    case 7: {
                        method = "getPIData";
                        result = sr.getPIData();
                    }
                }
                TestXmlDecl.fail((String)("Expected IllegalStateException, when calling " + method + "() for XML declaration (START_DOCUMENT)"));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
    }

    private void doTestValid(boolean nsAware) throws XMLStreamException, IOException {
        XMLStreamReader sr = this.getReader("<?xml version='1.0'?><root />", nsAware);
        TestXmlDecl.assertEquals((String)"1.0", (String)sr.getVersion());
        TestXmlDecl.assertFalse((boolean)sr.standaloneSet());
        sr = this.getUTF8StreamReader("<?xml version='1.0'?><root />", nsAware);
        TestXmlDecl.assertEquals((String)"UTF-8", (String)sr.getEncoding());
        sr = this.getReader("<?xml version='1.0' encoding='UTF-8' ?><root />", nsAware);
        TestXmlDecl.assertEquals((String)"1.0", (String)sr.getVersion());
        TestXmlDecl.assertEquals((String)"UTF-8", (String)sr.getCharacterEncodingScheme());
    }

    private void doTestInvalid(boolean nsAware) throws XMLStreamException {
        String XML = "<?xml ?><root />";
        this.streamThroughFailing(this.getFactory(nsAware), XML, "invalid XML declaration (missing version)");
        XML = "<?xml version='1.0\" ?><root />";
        this.streamThroughFailing(this.getFactory(nsAware), XML, "invalid XML declaration (mismatch of quotes)");
    }

    private XMLInputFactory getFactory(boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestXmlDecl.setCoalescing(f, false);
        TestXmlDecl.setNamespaceAware(f, nsAware);
        TestXmlDecl.setValidating(f, false);
        return f;
    }

    private XMLStreamReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        return TestXmlDecl.constructStreamReader(this.getFactory(nsAware), contents);
    }

    private XMLStreamReader getUTF8StreamReader(String contents, boolean nsAware) throws XMLStreamException, UnsupportedEncodingException {
        XMLInputFactory f = this.getInputFactory();
        TestXmlDecl.setCoalescing(f, false);
        TestXmlDecl.setNamespaceAware(f, nsAware);
        TestXmlDecl.setValidating(f, false);
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        return f.createXMLStreamReader(in, "UTF-8");
    }
}

