/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestTextCoalescing
extends BaseStreamTest {
    static final String VALID_XML = "<root>Text <![CDATA[cdata\nin two lines]]><![CDATA[!]]>/that's all!</root>";

    public TestTextCoalescing(String name) {
        super(name);
    }

    public void testCoalescing() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(VALID_XML, true, true);
        TestTextCoalescing.assertTokenType(1, sr.next());
        TestTextCoalescing.assertTokenType(4, sr.next());
        String act = TestTextCoalescing.getAndVerifyText(sr);
        String exp = "Text cdata\nin two lines!/that's all!";
        if (!exp.equals(act)) {
            TestTextCoalescing.failStrings("Coalescing failed", exp, act);
        }
        TestTextCoalescing.assertTokenType(2, sr.next());
        TestTextCoalescing.assertTokenType(8, sr.next());
    }

    public void testCoalescingSkipping() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(VALID_XML, true, true);
        TestTextCoalescing.assertTokenType(1, sr.next());
        TestTextCoalescing.assertTokenType(4, sr.next());
        TestTextCoalescing.assertTokenType(2, sr.next());
        TestTextCoalescing.assertTokenType(8, sr.next());
    }

    public void testNonCoalescing() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(VALID_XML, true, false);
        TestTextCoalescing.assertTokenType(1, sr.next());
        sr.next();
        this.checkText(sr, 4, "Text ");
        int count = this.checkText(sr, 12, "cdata\nin two lines!");
        if (count < 2) {
            TestTextCoalescing.fail((String)"Expected at least two CDATA events; parser coalesced them");
        }
        this.checkText(sr, 4, "/that's all!");
        TestTextCoalescing.assertTokenType(2, sr.getEventType());
        TestTextCoalescing.assertTokenType(8, sr.next());
    }

    public void testNonCoalescingSkipping() throws XMLStreamException {
        int type;
        XMLStreamReader sr = this.getReader(VALID_XML, true, false);
        TestTextCoalescing.assertTokenType(1, sr.next());
        TestTextCoalescing.assertTokenType(4, sr.next());
        int count = 1;
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(sr.getText());
        sb.append(']');
        while ((type = sr.next()) == 4 || type == 12) {
            ++count;
            sb.append('[');
            sb.append(sr.getText());
            sb.append(']');
        }
        if (count < 4) {
            TestTextCoalescing.fail((String)("Expected at least 4 separate segments (CDATA/CHARACTERS), in non-coalescing mode, got " + count + " (text: " + sb + ")"));
        }
        TestTextCoalescing.assertTokenType(2, type);
        TestTextCoalescing.assertTokenType(8, sr.next());
    }

    public void testInvalidTextWithCDataEndMarker() throws XMLStreamException {
        String XML = "<root>   ]]>   </root>";
        this.streamThroughFailing(this.getReader(XML, true, true), "text content that has ']]>' in it.");
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean coalescing) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestTextCoalescing.setNamespaceAware(f, nsAware);
        TestTextCoalescing.setSupportDTD(f, true);
        TestTextCoalescing.setCoalescing(f, coalescing);
        TestTextCoalescing.setReplaceEntities(f, true);
        TestTextCoalescing.setValidating(f, false);
        TestTextCoalescing.setReportCData(f, true);
        return TestTextCoalescing.constructStreamReader(f, contents);
    }

    private int checkText(XMLStreamReader sr, int expType, String exp) throws XMLStreamException {
        TestTextCoalescing.assertTokenType(expType, sr.getEventType());
        StringBuffer sb = new StringBuffer(TestTextCoalescing.getAndVerifyText(sr));
        int count = 1;
        while (sr.next() == expType) {
            ++count;
            sb.append(TestTextCoalescing.getAndVerifyText(sr));
        }
        String act = sb.toString();
        if (!exp.equals(act)) {
            TestTextCoalescing.failStrings("Incorrect text contents", act, exp);
        }
        return count;
    }
}

