/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestEpilog
extends BaseStreamTest {
    public TestEpilog(String name) {
        super(name);
    }

    public void testValidEpilog() throws XMLStreamException {
        int type;
        String XML = "<!-- test comment -->     <root attr='whatever' />  <?some processing instruction?>   <!-- another comment! -->   ";
        XMLStreamReader sr = this.getReader(XML, true);
        TestEpilog.assertTokenType(5, sr.next());
        TestEpilog.assertEquals((String)" test comment ", (String)TestEpilog.getAndVerifyText(sr));
        while ((type = sr.next()) == 6) {
        }
        TestEpilog.assertTokenType(1, type);
        TestEpilog.assertTokenType(2, sr.next());
        while ((type = sr.next()) == 6) {
        }
        TestEpilog.assertTokenType(3, type);
        TestEpilog.assertEquals((String)"some", (String)sr.getPITarget());
        TestEpilog.assertEquals((String)"processing instruction", (String)sr.getPIData().trim());
        while ((type = sr.next()) == 6) {
        }
        TestEpilog.assertTokenType(5, type);
        TestEpilog.assertEquals((String)" another comment! ", (String)TestEpilog.getAndVerifyText(sr));
        while ((type = sr.next()) == 6) {
        }
        TestEpilog.assertTokenType(8, type);
    }

    public void testInvalidEpilog() throws XMLStreamException {
        this.doTestInvalid(false);
        this.doTestInvalid(true);
    }

    private void doTestInvalid(boolean nsAware) throws XMLStreamException {
        String XML = "  yeehaw! <root />";
        try {
            this.streamThrough(this.getReader(XML, nsAware));
            TestEpilog.fail((String)"Expected an exception for text in prolog");
        }
        catch (Exception e) {
            // empty catch block
        }
        XML = " <root /> foobar";
        try {
            this.streamThrough(this.getReader(XML, nsAware));
            TestEpilog.fail((String)"Expected an exception for text in epilog");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLStreamReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEpilog.setCoalescing(f, true);
        TestEpilog.setNamespaceAware(f, nsAware);
        TestEpilog.setValidating(f, false);
        return TestEpilog.constructStreamReader(f, contents);
    }
}

