/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventTypes
extends BaseEventTest {
    public void testTypes() throws XMLStreamException {
        this.doTestTypes(false);
        this.doTestTypes(true);
    }

    private void doTestTypes(boolean useNs) throws XMLStreamException {
        String INPUT = "<?xml version='1.0'?><?proc instr?><!--comment - - contents--><!DOCTYPE root><root attr='value'>some text</root>";
        XMLEventReader er = this.getReader(INPUT, useNs);
        XMLEvent evt = er.nextEvent();
        TestEventTypes.assertEquals((int)7, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isStartDocument());
        StartDocument doc = (StartDocument)evt;
        TestEventTypes.assertFalse((boolean)doc.encodingSet());
        if (doc.standaloneSet()) {
            TestEventTypes.fail((String)"Reporting stand-alone as set, even though xml declaration has no value (should assume 'false')");
        }
        TestEventTypes.assertFalse((String)"Should assume 'no' as stand-alone value if no extra information", (boolean)doc.isStandalone());
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)3, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isProcessingInstruction());
        ProcessingInstruction pi = (ProcessingInstruction)evt;
        TestEventTypes.assertEquals((String)"proc", (String)pi.getTarget());
        String data = pi.getData().trim();
        TestEventTypes.assertEquals((String)"instr", (String)data);
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)5, (int)evt.getEventType());
        Comment c = (Comment)evt;
        TestEventTypes.assertEquals((String)"comment - - contents", (String)c.getText());
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)11, (int)evt.getEventType());
        DTD dtd = (DTD)evt;
        TestEventTypes.checkEventIsMethods(11, dtd);
        this.testEventWritability(dtd);
        TestEventTypes.assertNotNull((Object)dtd.getDocumentTypeDeclaration());
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)1, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isStartElement());
        XMLEvent elem = evt.asStartElement();
        QName elemName = elem.getName();
        TestEventTypes.assertEquals((String)"root", (String)elemName.getLocalPart());
        TestEventTypes.assertEquals((int)1, (int)this.calcAttrCount((StartElement)elem));
        Attribute noSuchAttr = elem.getAttributeByName(new QName("foobar"));
        TestEventTypes.assertNull((String)"Should not have found attribute 'foobar' from the element", (Object)noSuchAttr);
        Attribute attr = elem.getAttributeByName(new QName("attr"));
        TestEventTypes.assertNotNull((String)"Should have found attribute 'attr' from the element", (Object)attr);
        TestEventTypes.assertTrue((boolean)attr.isAttribute());
        TestEventTypes.assertEquals((String)"value", (String)attr.getValue());
        TestEventTypes.assertEquals((String)"CDATA", (String)attr.getDTDType());
        TestEventTypes.assertTrue((boolean)attr.isSpecified());
        QName an = attr.getName();
        TestEventTypes.assertEquals((String)"attr", (String)an.getLocalPart());
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)4, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isCharacters());
        Characters ch = evt.asCharacters();
        TestEventTypes.assertFalse((boolean)ch.isCData());
        TestEventTypes.assertFalse((boolean)ch.isIgnorableWhiteSpace());
        TestEventTypes.assertFalse((boolean)ch.isWhiteSpace());
        TestEventTypes.assertEquals((String)"some text", (String)ch.getData());
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)2, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isEndElement());
        elem = evt.asEndElement();
        QName endName = elem.getName();
        TestEventTypes.assertEquals((String)"root", (String)endName.getLocalPart());
        TestEventTypes.assertEquals((Object)elemName, (Object)endName);
        evt = er.nextEvent();
        TestEventTypes.assertEquals((int)8, (int)evt.getEventType());
        TestEventTypes.assertTrue((boolean)evt.isEndDocument());
        EndDocument doc2 = (EndDocument)evt;
    }

    private XMLEventReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEventTypes.setCoalescing(f, true);
        TestEventTypes.setNamespaceAware(f, nsAware);
        TestEventTypes.setValidating(f, false);
        TestEventTypes.setSupportDTD(f, true);
        return TestEventTypes.constructEventReader(f, contents);
    }
}

