/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventFactory
extends BaseEventTest {
    public void testAttribute() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        String URI2 = "http://foo.com";
        QName attrName = new QName("http://foo.com", "attr", "ns");
        Attribute attr = f.createAttribute(attrName, "value");
        TestEventFactory.checkEventIsMethods(10, attr);
        this.testEventWritability(attr);
        Attribute attr2 = f.createAttribute("ns", "http://foo.com", "attr", "value'2'");
        Attribute attr3 = f.createAttribute("attr", "this&more");
        TestEventFactory.assertEquals((String)"CDATA", (String)attr.getDTDType());
        TestEventFactory.assertEquals((String)"CDATA", (String)attr2.getDTDType());
        TestEventFactory.assertEquals((String)"CDATA", (String)attr3.getDTDType());
        TestEventFactory.assertTrue((String)"Attribute 'ns:attr' should be created as 'defined'", (boolean)attr.isSpecified());
        TestEventFactory.assertTrue((String)"Attribute 'ns:attr' should be created as 'defined'", (boolean)attr2.isSpecified());
        TestEventFactory.assertTrue((String)"Attribute 'attr' should be created as 'defined'", (boolean)attr3.isSpecified());
        TestEventFactory.assertEquals((String)"value", (String)attr.getValue());
        TestEventFactory.assertEquals((String)"value'2'", (String)attr2.getValue());
        TestEventFactory.assertEquals((String)"this&more", (String)attr3.getValue());
        TestEventFactory.assertEquals((Object)attrName, (Object)attr.getName());
        TestEventFactory.assertEquals((Object)attrName, (Object)attr2.getName());
        QName name3 = attr3.getName();
        TestEventFactory.assertEquals((String)"attr", (String)name3.getLocalPart());
        String str = name3.getPrefix();
        TestEventFactory.assertTrue((str == null || str.length() == 0 ? 1 : 0) != 0);
        str = name3.getNamespaceURI();
        TestEventFactory.assertTrue((str == null || str.length() == 0 ? 1 : 0) != 0);
    }

    public void testCData() throws XMLStreamException {
        String contents = "test <some> text & more! [[]] --";
        XMLEventFactory f = this.getEventFactory();
        Characters c = f.createCData("test <some> text & more! [[]] --");
        TestEventFactory.checkEventIsMethods(4, c);
        this.testEventWritability(c);
        TestEventFactory.assertEquals((String)"test <some> text & more! [[]] --", (String)c.getData());
        TestEventFactory.assertTrue((boolean)c.isCData());
        TestEventFactory.assertFalse((boolean)c.isIgnorableWhiteSpace());
        TestEventFactory.assertFalse((boolean)c.isWhiteSpace());
    }

    public void testCharacters() throws XMLStreamException {
        String contents = "test <some> text & more! [[]] --";
        XMLEventFactory f = this.getEventFactory();
        Characters c = f.createCharacters("test <some> text & more! [[]] --");
        TestEventFactory.checkEventIsMethods(4, c);
        this.testEventWritability(c);
        TestEventFactory.assertEquals((String)"test <some> text & more! [[]] --", (String)c.getData());
        TestEventFactory.assertFalse((boolean)c.isCData());
        TestEventFactory.assertFalse((boolean)c.isIgnorableWhiteSpace());
        TestEventFactory.assertFalse((boolean)c.isWhiteSpace());
    }

    public void testComment() throws XMLStreamException {
        String content = "Comment - how interesting!";
        XMLEventFactory f = this.getEventFactory();
        Comment c = f.createComment("Comment - how interesting!");
        TestEventFactory.checkEventIsMethods(5, c);
        this.testEventWritability(c);
        TestEventFactory.assertEquals((String)"Comment - how interesting!", (String)c.getText());
    }

    public void testDTD() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        DTD d = f.createDTD("<!DOCTYPE root SYSTEM 'http://foo' [ ]>");
        TestEventFactory.checkEventIsMethods(11, d);
        this.testEventWritability(d);
    }

    public void testEndDocument() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        EndDocument ed = f.createEndDocument();
        TestEventFactory.checkEventIsMethods(8, ed);
        this.testEventWritability(ed);
    }

    public void testEndElement() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        String LOCALNAME = "elem";
        EndElement ee = f.createEndElement("", "", "elem");
        TestEventFactory.checkEventIsMethods(2, ee);
        this.testEventWritability(ee);
        QName n = ee.getName();
        TestEventFactory.assertNotNull((Object)n);
        TestEventFactory.assertEquals((String)"elem", (String)n.getLocalPart());
    }

    public void testEntityReference() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
    }

    public void testIgnorableSpace() throws XMLStreamException {
        String contents = "  \t  \n  ";
        XMLEventFactory f = this.getEventFactory();
        Characters c = f.createIgnorableSpace("  \t  \n  ");
        TestEventFactory.checkEventIsMethods(4, c);
        this.testEventWritability(c);
        TestEventFactory.assertEquals((String)"  \t  \n  ", (String)c.getData());
        TestEventFactory.assertFalse((boolean)c.isCData());
        TestEventFactory.assertTrue((boolean)c.isIgnorableWhiteSpace());
        TestEventFactory.assertTrue((boolean)c.isWhiteSpace());
    }

    public void testNamespace() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        String PREFIX = "prefix";
        String URI2 = "http://foo";
        Namespace ns = f.createNamespace("http://foo");
        TestEventFactory.checkEventIsMethods(13, ns);
        this.testEventWritability(ns);
        String prefix = ns.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            TestEventFactory.fail((String)"Expected prefix to be null or empty for default namespace event object");
        }
        TestEventFactory.assertEquals((String)"http://foo", (String)ns.getNamespaceURI());
        TestEventFactory.assertTrue((boolean)ns.isDefaultNamespaceDeclaration());
        ns = f.createNamespace("prefix", "http://foo");
        TestEventFactory.checkEventIsMethods(13, ns);
        TestEventFactory.assertEquals((String)"prefix", (String)ns.getPrefix());
        TestEventFactory.assertEquals((String)"http://foo", (String)ns.getNamespaceURI());
        TestEventFactory.assertFalse((boolean)ns.isDefaultNamespaceDeclaration());
    }

    public void testProcInstr() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        ProcessingInstruction pi = f.createProcessingInstruction("target", "data");
        TestEventFactory.checkEventIsMethods(3, pi);
        this.testEventWritability(pi);
        TestEventFactory.assertEquals((String)"target", (String)pi.getTarget());
        TestEventFactory.assertEquals((String)"data", (String)pi.getData());
    }

    public void testSpace() throws XMLStreamException {
        String contents = "  \t  \n  ";
        XMLEventFactory f = this.getEventFactory();
        Characters c = f.createSpace("  \t  \n  ");
        TestEventFactory.assertEquals((String)"  \t  \n  ", (String)c.getData());
        TestEventFactory.checkEventIsMethods(4, c);
        this.testEventWritability(c);
        TestEventFactory.assertFalse((boolean)c.isCData());
        TestEventFactory.assertFalse((boolean)c.isIgnorableWhiteSpace());
        TestEventFactory.assertTrue((boolean)c.isWhiteSpace());
    }

    public void testStartDocument() throws XMLStreamException {
        XMLEventFactory f = this.getEventFactory();
        StartDocument sd = f.createStartDocument();
        TestEventFactory.checkEventIsMethods(7, sd);
        this.testEventWritability(sd);
        TestEventFactory.assertFalse((boolean)sd.encodingSet());
        TestEventFactory.assertFalse((boolean)sd.standaloneSet());
        String ENCODING = "ISO-8859-1";
        String VERSION = "1.0";
        sd = f.createStartDocument("ISO-8859-1", "1.0", true);
        TestEventFactory.checkEventIsMethods(7, sd);
        TestEventFactory.assertTrue((boolean)sd.encodingSet());
        TestEventFactory.assertTrue((boolean)sd.standaloneSet());
        TestEventFactory.assertEquals((String)"ISO-8859-1", (String)sd.getCharacterEncodingScheme());
        TestEventFactory.assertEquals((String)"1.0", (String)sd.getVersion());
    }

    public void testStartElement() throws XMLStreamException {
        String LOCALNAME = "root";
        String PREFIX = "ns";
        String URI2 = "urn:whatever";
        XMLEventFactory f = this.getEventFactory();
        StartElement se = f.createStartElement("", "", "root");
        this.testEventWritability(se);
        TestEventFactory.checkEventIsMethods(1, se);
        QName n = se.getName();
        TestEventFactory.assertNotNull((Object)n);
        TestEventFactory.assertEquals((String)"root", (String)n.getLocalPart());
        se = f.createStartElement("ns", "urn:whatever", "root");
        TestEventFactory.checkEventIsMethods(1, se);
        n = se.getName();
        TestEventFactory.assertNotNull((Object)n);
        TestEventFactory.assertEquals((String)"root", (String)n.getLocalPart());
        TestEventFactory.assertEquals((String)"ns", (String)n.getPrefix());
        TestEventFactory.assertEquals((String)"urn:whatever", (String)n.getNamespaceURI());
    }

    public void testStartElementWithAttrs() throws XMLStreamException {
        String NS_URI = "http://foo";
        XMLEventFactory f = this.getEventFactory();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Attribute attr1 = f.createAttribute(new QName("attr1"), "value");
        this.testEventWritability(attr1);
        attrs.add(attr1);
        TestEventFactory.checkEventIsMethods(10, attr1);
        attrs.add(f.createAttribute(new QName("http://foo", "attr2"), "value2"));
        StartElement se = f.createStartElement(new QName("root"), attrs.iterator(), null);
        this.testEventWritability(se);
        TestEventFactory.checkEventIsMethods(1, se);
        QName n = se.getName();
        TestEventFactory.assertNotNull((Object)n);
        TestEventFactory.assertEquals((String)"root", (String)n.getLocalPart());
        Attribute resultAttr = se.getAttributeByName(new QName("attr1"));
        TestEventFactory.assertNotNull((Object)resultAttr);
        n = resultAttr.getName();
        TestEventFactory.assertEquals((String)"attr1", (String)n.getLocalPart());
        TestEventFactory.assertEquals((String)"value", (String)resultAttr.getValue());
        resultAttr = se.getAttributeByName(new QName("http://foo", "attr2"));
        TestEventFactory.assertNotNull((Object)resultAttr);
        n = resultAttr.getName();
        TestEventFactory.assertEquals((String)"attr2", (String)n.getLocalPart());
        TestEventFactory.assertEquals((String)"value2", (String)resultAttr.getValue());
        TestEventFactory.assertNull((Object)se.getAttributeByName(new QName("http://foo", "attr1")));
        TestEventFactory.assertNull((Object)se.getAttributeByName(new QName("attr2")));
        Iterator<Attribute> it = se.getAttributes();
        TestEventFactory.assertNotNull(it);
        int count = 0;
        while (it.hasNext()) {
            Attribute a = it.next();
            ++count;
        }
        TestEventFactory.assertEquals((int)2, (int)count);
    }
}

