/*******************************************************************************
 *
 *	Font metric data for Bookman-LightItalic
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[228] =
{
    { 0x0020,  300 },
    { 0x0021,  320 },
    { 0x0022,  360 },
    { 0x0023,  620 },
    { 0x0024,  620 },
    { 0x0025,  800 },
    { 0x0026,  820 },
    { 0x0027,  200 },
    { 0x0028,  280 },
    { 0x0029,  280 },
    { 0x002a,  440 },
    { 0x002b,  600 },
    { 0x002c,  300 },
    { 0x002d,  320 },
    { 0x002e,  300 },
    { 0x002f,  600 },
    { 0x0030,  620 },
    { 0x0031,  620 },
    { 0x0032,  620 },
    { 0x0033,  620 },
    { 0x0034,  620 },
    { 0x0035,  620 },
    { 0x0036,  620 },
    { 0x0037,  620 },
    { 0x0038,  620 },
    { 0x0039,  620 },
    { 0x003a,  300 },
    { 0x003b,  300 },
    { 0x003c,  600 },
    { 0x003d,  600 },
    { 0x003e,  600 },
    { 0x003f,  540 },
    { 0x0040,  780 },
    { 0x0041,  700 },
    { 0x0042,  720 },
    { 0x0043,  720 },
    { 0x0044,  740 },
    { 0x0045,  680 },
    { 0x0046,  620 },
    { 0x0047,  760 },
    { 0x0048,  800 },
    { 0x0049,  320 },
    { 0x004a,  560 },
    { 0x004b,  720 },
    { 0x004c,  580 },
    { 0x004d,  860 },
    { 0x004e,  720 },
    { 0x004f,  760 },
    { 0x0050,  600 },
    { 0x0051,  780 },
    { 0x0052,  700 },
    { 0x0053,  640 },
    { 0x0054,  600 },
    { 0x0055,  720 },
    { 0x0056,  680 },
    { 0x0057,  960 },
    { 0x0058,  700 },
    { 0x0059,  660 },
    { 0x005a,  580 },
    { 0x005b,  260 },
    { 0x005c,  600 },
    { 0x005d,  260 },
    { 0x005e,  600 },
    { 0x005f,  500 },
    { 0x0060,  340 },
    { 0x0061,  620 },
    { 0x0062,  600 },
    { 0x0063,  480 },
    { 0x0064,  640 },
    { 0x0065,  540 },
    { 0x0066,  340 },
    { 0x0067,  560 },
    { 0x0068,  620 },
    { 0x0069,  280 },
    { 0x006a,  280 },
    { 0x006b,  600 },
    { 0x006c,  280 },
    { 0x006d,  880 },
    { 0x006e,  620 },
    { 0x006f,  540 },
    { 0x0070,  600 },
    { 0x0071,  560 },
    { 0x0072,  400 },
    { 0x0073,  540 },
    { 0x0074,  340 },
    { 0x0075,  620 },
    { 0x0076,  540 },
    { 0x0077,  880 },
    { 0x0078,  540 },
    { 0x0079,  600 },
    { 0x007a,  520 },
    { 0x007b,  360 },
    { 0x007c,  600 },
    { 0x007d,  380 },
    { 0x007e,  600 },
    { 0x00a1,  320 },
    { 0x00a2,  620 },
    { 0x00a3,  620 },
    { 0x00a4,  620 },
    { 0x00a5,  620 },
    { 0x00a6,  600 },
    { 0x00a7,  620 },
    { 0x00a8,  420 },
    { 0x00a9,  740 },
    { 0x00aa,  440 },
    { 0x00ab,  300 },
    { 0x00ac,  600 },
    { 0x00ae,  740 },
    { 0x00b0,  400 },
    { 0x00b1,  600 },
    { 0x00b2,  372 },
    { 0x00b3,  372 },
    { 0x00b4,  320 },
    { 0x00b6,  620 },
    { 0x00b7,  300 },
    { 0x00b8,  320 },
    { 0x00b9,  372 },
    { 0x00ba,  400 },
    { 0x00bb,  300 },
    { 0x00bc,  930 },
    { 0x00bd,  930 },
    { 0x00be,  930 },
    { 0x00bf,  540 },
    { 0x00c0,  700 },
    { 0x00c1,  700 },
    { 0x00c2,  700 },
    { 0x00c3,  700 },
    { 0x00c4,  700 },
    { 0x00c5,  700 },
    { 0x00c6, 1220 },
    { 0x00c7,  720 },
    { 0x00c8,  680 },
    { 0x00c9,  680 },
    { 0x00ca,  680 },
    { 0x00cb,  680 },
    { 0x00cc,  320 },
    { 0x00cd,  320 },
    { 0x00ce,  320 },
    { 0x00cf,  320 },
    { 0x00d0,  740 },
    { 0x00d1,  720 },
    { 0x00d2,  760 },
    { 0x00d3,  760 },
    { 0x00d4,  760 },
    { 0x00d5,  760 },
    { 0x00d6,  760 },
    { 0x00d7,  600 },
    { 0x00d8,  760 },
    { 0x00d9,  720 },
    { 0x00da,  720 },
    { 0x00db,  720 },
    { 0x00dc,  720 },
    { 0x00dd,  660 },
    { 0x00de,  600 },
    { 0x00df,  620 },
    { 0x00e0,  620 },
    { 0x00e1,  620 },
    { 0x00e2,  620 },
    { 0x00e3,  620 },
    { 0x00e4,  620 },
    { 0x00e5,  620 },
    { 0x00e6,  880 },
    { 0x00e7,  480 },
    { 0x00e8,  540 },
    { 0x00e9,  540 },
    { 0x00ea,  540 },
    { 0x00eb,  540 },
    { 0x00ec,  280 },
    { 0x00ed,  280 },
    { 0x00ee,  280 },
    { 0x00ef,  280 },
    { 0x00f0,  540 },
    { 0x00f1,  620 },
    { 0x00f2,  540 },
    { 0x00f3,  540 },
    { 0x00f4,  540 },
    { 0x00f5,  540 },
    { 0x00f6,  540 },
    { 0x00f7,  600 },
    { 0x00f8,  540 },
    { 0x00f9,  620 },
    { 0x00fa,  620 },
    { 0x00fb,  620 },
    { 0x00fc,  620 },
    { 0x00fd,  600 },
    { 0x00fe,  600 },
    { 0x00ff,  600 },
    { 0x0131,  280 },
    { 0x0141,  580 },
    { 0x0142,  340 },
    { 0x0152, 1180 },
    { 0x0153,  900 },
    { 0x0160,  640 },
    { 0x0161,  540 },
    { 0x0178,  660 },
    { 0x017d,  580 },
    { 0x017e,  520 },
    { 0x0192,  620 },
    { 0x02c6,  440 },
    { 0x02c7,  440 },
    { 0x02c9,  440 },
    { 0x02d8,  440 },
    { 0x02d9,  260 },
    { 0x02da,  300 },
    { 0x02db,  260 },
    { 0x02dc,  440 },
    { 0x02dd,  340 },
    { 0x03bc,  620 },
    { 0x2013,  500 },
    { 0x2014, 1000 },
    { 0x2018,  280 },
    { 0x2019,  280 },
    { 0x201a,  320 },
    { 0x201c,  440 },
    { 0x201d,  440 },
    { 0x201e,  480 },
    { 0x2020,  620 },
    { 0x2021,  620 },
    { 0x2022,  460 },
    { 0x2026, 1000 },
    { 0x2030, 1180 },
    { 0x2039,  180 },
    { 0x203a,  180 },
    { 0x2122,  980 },
    { 0x2212,  600 },
    { 0x2215,   20 },
    { 0xfb01,  640 },
    { 0xfb02,  660 },
};


/*
 *  Font metrics
 */

const AFM PSDRV_Bookman_LightItalic =
{
    "Bookman-LightItalic",		    /* FontName */
    L"ITC Bookman",			    /* FamilyName */
    L"AdobeStandardEncoding",		    /* EncodingScheme */
    FW_NORMAL,				    /* Weight */
    -10,				    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    { -228, -250, 1269, 883 },		    /* FontBBox */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	942,				    /* WinMetrics.sAscender */
	-232,				    /* WinMetrics.sDescender */
	0,				    /* WinMetrics.sLineGap */
	482,				    /* WinMetrics.sAvgCharWidth */
	875,				    /* WinMetrics.usWinAscent */
	232				    /* WinMetrics.usWinDescent */
    },
    228,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
