; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -enable-tail-merge=0 -mtriple=x86_64-linux-wine32 | FileCheck %s --check-prefix=LINUX
; RUN: llc -verify-machineinstrs < %s -enable-tail-merge=0 -mtriple=x86_64-linux-wine32sp64 | FileCheck %s --check-prefix=LINUX
; RUN: llc -verify-machineinstrs < %s -enable-tail-merge=0 -mtriple=x86_64-windows-wine32 | FileCheck %s --check-prefix=WINDOWS
; RUN: llc -verify-machineinstrs < %s -enable-tail-merge=0 -mtriple=x86_64-windows-wine32sp64 | FileCheck %s --check-prefix=WINDOWS
; REQUIRES: disabled

; Test that we actually spill and reload all arguments in the variadic argument
; pack. Doing a normal call will clobber all argument registers, and we will
; spill around it. A simple adjustment should not require any XMM spills.

declare void @llvm.va_start.p0i8(i8*) nounwind

declare void(i8 addrspace(32)*, ...) addrspace(32)* @get_f(i8 addrspace(32)* %this)

define void @f_thunk(i8 addrspace(32)* %this, ...) {
  ; Use va_start so that we exercise the combination.
; LINUX-LABEL: f_thunk:
; LINUX:       # %bb.0:
; LINUX-NEXT:    pushq %rbp
; LINUX-NEXT:    .cfi_def_cfa_offset 16
; LINUX-NEXT:    pushq %r15
; LINUX-NEXT:    .cfi_def_cfa_offset 24
; LINUX-NEXT:    pushq %r14
; LINUX-NEXT:    .cfi_def_cfa_offset 32
; LINUX-NEXT:    pushq %r13
; LINUX-NEXT:    .cfi_def_cfa_offset 40
; LINUX-NEXT:    pushq %r12
; LINUX-NEXT:    .cfi_def_cfa_offset 48
; LINUX-NEXT:    pushq %rbx
; LINUX-NEXT:    .cfi_def_cfa_offset 56
; LINUX-NEXT:    subq $344, %rsp # imm = 0x158
; LINUX-NEXT:    .cfi_def_cfa_offset 400
; LINUX-NEXT:    .cfi_offset %rbx, -56
; LINUX-NEXT:    .cfi_offset %r12, -48
; LINUX-NEXT:    .cfi_offset %r13, -40
; LINUX-NEXT:    .cfi_offset %r14, -32
; LINUX-NEXT:    .cfi_offset %r15, -24
; LINUX-NEXT:    .cfi_offset %rbp, -16
; LINUX-NEXT:    movq %r9, %r15
; LINUX-NEXT:    movq %r8, %r12
; LINUX-NEXT:    movq %rcx, %r13
; LINUX-NEXT:    movq %rdx, %rbp
; LINUX-NEXT:    movq %rsi, %rbx
; LINUX-NEXT:    movl %edi, %r14d
; LINUX-NEXT:    movb %al, {{[0-9]+\(%[er]sp\)}} # 1-byte Spill
; LINUX-NEXT:    testb %al, %al
; LINUX-NEXT:    je .LBB0_2
; LINUX-NEXT:  # %bb.1:
; LINUX-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm2, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm3, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm4, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm5, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp)
; LINUX-NEXT:  .LBB0_2:
; LINUX-NEXT:    movq %r15, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movq %r12, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movq %r13, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movq %rbp, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movq %rbx, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    leal {{[0-9]+}}(%rsp), %eax
; LINUX-NEXT:    movl %eax, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    leal {{[0-9]+}}(%rsp), %eax
; LINUX-NEXT:    movl %eax, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movabsq $206158430216, %rax # imm = 0x3000000008
; LINUX-NEXT:    movq %rax, {{[0-9]+}}(%rsp)
; LINUX-NEXT:    movl %r14d, %edi
; LINUX-NEXT:    movaps %xmm7, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm6, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm5, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm4, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm3, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm2, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; LINUX-NEXT:    callq get_f
; LINUX-NEXT:    movl %eax, %r11d
; LINUX-NEXT:    movl %r14d, %edi
; LINUX-NEXT:    movq %rbx, %rsi
; LINUX-NEXT:    movq %rbp, %rdx
; LINUX-NEXT:    movq %r13, %rcx
; LINUX-NEXT:    movq %r12, %r8
; LINUX-NEXT:    movq %r15, %r9
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm1 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm2 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm4 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm5 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm6 # 16-byte Reload
; LINUX-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm7 # 16-byte Reload
; LINUX-NEXT:    movb {{[0-9]+}}(%rsp), %al # 1-byte Reload
; LINUX-NEXT:    addq $344, %rsp # imm = 0x158
; LINUX-NEXT:    .cfi_def_cfa_offset 56
; LINUX-NEXT:    popq %rbx
; LINUX-NEXT:    .cfi_def_cfa_offset 48
; LINUX-NEXT:    popq %r12
; LINUX-NEXT:    .cfi_def_cfa_offset 40
; LINUX-NEXT:    popq %r13
; LINUX-NEXT:    .cfi_def_cfa_offset 32
; LINUX-NEXT:    popq %r14
; LINUX-NEXT:    .cfi_def_cfa_offset 24
; LINUX-NEXT:    popq %r15
; LINUX-NEXT:    .cfi_def_cfa_offset 16
; LINUX-NEXT:    popq %rbp
; LINUX-NEXT:    .cfi_def_cfa_offset 8
; LINUX-NEXT:    jmpq *%r11 # TAILCALL
  %ap = alloca [4 x i8 addrspace(32)*], align 16
  %ap_i8 = bitcast [4 x i8 addrspace(32)*]* %ap to i8*
  call void @llvm.va_start(i8* %ap_i8)

  %fptr = call void(i8 addrspace(32)*, ...) addrspace(32)*(i8 addrspace(32)*) @get_f(i8 addrspace(32)* %this)
  musttail call void (i8*, ...) %fptr(i8 addrspace(32)* %this, ...)
  ret void
}

; Save and restore 6 GPRs, 8 XMMs, and AL around the call.

; No regparms on normal x86 conventions.

; This thunk shouldn't require any spills and reloads, assuming the register
; allocator knows what it's doing.

define void @g_thunk(i8 addrspace(32)* %fptr_i8, ...) {
; LINUX-LABEL: g_thunk:
; LINUX:       # %bb.0:
; LINUX-NEXT:    pushq %rax
; LINUX-NEXT:    .cfi_def_cfa_offset 16
; LINUX-NEXT:    movl %edi, %r11d
; LINUX-NEXT:    add{{[lq]}} $8, %{{[er]}}sp
; LINUX-NEXT:    .cfi_def_cfa_offset 8
; LINUX-NEXT:    jmpq *%r11 # TAILCALL
  %fptr = bitcast i8* %fptr_i8 to void (i8 addrspace(32)*, ...) addrspace(32)*
  musttail call void (i8 addrspace(32)*, ...) %fptr(i8 addrspace(32)* %fptr_i8, ...)
  ret void
}

; Do a simple multi-exit multi-bb test.

%struct.Foo = type { i1, i8 addrspace(32)*, i8* }

@g = external global i32

define void @h_thunk(%struct.Foo addrspace(32)* %this, ...) {
; LINUX-LABEL: h_thunk:
; LINUX:       # %bb.0:
; LINUX-NEXT:    pushq %rax
; LINUX-NEXT:    .cfi_def_cfa_offset 16
; LINUX-NEXT:    cmpb $1, (%edi)
; LINUX-NEXT:    jne .LBB2_2
; LINUX-NEXT:  # %bb.1: # %then
; LINUX-NEXT:    movl 4(%edi), %r11d
; LINUX-NEXT:    addq $8, %rsp
; LINUX-NEXT:    .cfi_def_cfa_offset 8
; LINUX-NEXT:    jmpq *%r11 # TAILCALL
; LINUX-NEXT:  .LBB2_2: # %else
; LINUX-NEXT:    .cfi_def_cfa_offset 16
; LINUX-NEXT:    movq 8(%edi), %r11
; LINUX-NEXT:    movl $42, {{.*}}(%rip)
; LINUX-NEXT:    addq $8, %rsp
; LINUX-NEXT:    .cfi_def_cfa_offset 8
; LINUX-NEXT:    jmpq *%r11 # TAILCALL
  %cond_p = getelementptr %struct.Foo, %struct.Foo addrspace(32)* %this, i32 0, i32 0
  %cond = load i1, i1 addrspace(32)* %cond_p
  br i1 %cond, label %then, label %else

then:
  %a_p = getelementptr %struct.Foo, %struct.Foo addrspace(32)* %this, i32 0, i32 1
  %a_i8 = load i8 addrspace(32)*, i8 addrspace(32)* addrspace(32)* %a_p
  %a = bitcast i8 addrspace(32)* %a_i8 to void (%struct.Foo addrspace(32)*, ...) addrspace(32)*
  musttail call void (%struct.Foo addrspace(32)*, ...) %a(%struct.Foo addrspace(32)* %this, ...)
  ret void

else:
  %b_p = getelementptr %struct.Foo, %struct.Foo addrspace(32)* %this, i32 0, i32 2
  %b_i8 = load i8*, i8* addrspace(32)* %b_p
  %b = bitcast i8* %b_i8 to void (%struct.Foo addrspace(32)*, ...)* 
  store i32 42, i32* @g
  musttail call void (%struct.Foo addrspace(32)*, ...) %b(%struct.Foo addrspace(32)* %this, ...)
  ret void
}
