; RUN: llc -mtriple=aarch64-none-eabi < %s | FileCheck %s

; CHECK-LABEL: @leaf
; CHECK-NOT: paci{{[a,b]}}sp
; CHECK-NOT: auti{{[a,b]}}sp
define i32 @leaf(i32 %x) {
  ret i32 %x
}

; CHECK-LABEL: @leaf_sign_none
; CHECK-NOT: paci{{[a,b]}}sp
; CHECK-NOT: auti{{[a,b]}}sp
define i32 @leaf_sign_none(i32 %x) "sign-return-address"="none"  {
  ret i32 %x
}

; CHECK-LABEL: @leaf_sign_non_leaf
; CHECK-NOT: paci{{[a,b]}}sp
; CHECK-NOT: auti{{[a,b]}}sp
define i32 @leaf_sign_non_leaf(i32 %x) "sign-return-address"="non-leaf"  {
  ret i32 %x
}

; CHECK-LABEL: @leaf_sign_all
; CHECK: paciasp
; CHECK: autiasp
; CHECK-NEXT: ret
define i32 @leaf_sign_all(i32 %x) "sign-return-address"="all" {
  ret i32 %x
}

; CHECK: @leaf_clobbers_lr
; CHECK: paciasp
; CHECK-NEXT: str x30, [sp, #-16]!
; CHECK: ldr  x30, [sp], #16
; CHECK-NEXT: autiasp
; CHECK-NEXT: ret
define i64 @leaf_clobbers_lr(i64 %x) "sign-return-address"="non-leaf"  {
  call void asm sideeffect "mov x30, $0", "r,~{lr}"(i64 %x) #1
  ret i64 %x
}

declare i32 @foo(i32)

; CHECK: @non_leaf_sign_all
; CHECK: paciasp
; CHECK: autiasp
; CHECK-NEXT: ret
define i32 @non_leaf_sign_all(i32 %x) "sign-return-address"="all" {
  %call = call i32 @foo(i32 %x)
  ret i32 %call
}

; CHECK: @non_leaf_sign_non_leaf
; CHECK: paciasp
; CHECK-NEXT: str x30, [sp, #-16]!
; CHECK: ldr  x30, [sp], #16
; CHECK-NEXT: autiasp
; CHECK-NEXT: ret
define i32 @non_leaf_sign_non_leaf(i32 %x) "sign-return-address"="non-leaf"  {
  %call = call i32 @foo(i32 %x)
  ret i32 %call
}

; CHECK-LABEL: @leaf_sign_all_v83
; CHECK: paciasp
; CHECK-NOT: ret
; CHECK-NEXT: retaa
; CHECK-NOT: ret
define i32 @leaf_sign_all_v83(i32 %x) "sign-return-address"="all" "target-features"="+v8.3a" {
  ret i32 %x
}

declare fastcc i64 @bar(i64)

; CHECK-LABEL: @spill_lr_and_tail_call
; CHECK: paciasp
; CHECK-NEXT: str x30, [sp, #-16]!
; CHECK: ldr  x30, [sp], #16
; CHECK-NEXT: autiasp
; CHECK-NEXT: b  bar
define fastcc void @spill_lr_and_tail_call(i64 %x) "sign-return-address"="all" {
  call void asm sideeffect "mov x30, $0", "r,~{lr}"(i64 %x) #1
  tail call fastcc i64 @bar(i64 %x)
  ret void
}
