# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005  Bastian Kleineidam
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
Proxy start function.
"""

import os

import wc
import wc.configuration
import wc.url
import wc.log
import wc.proxy
import wc.proxy.dns_lookups
import wc.filter
import wc.filter.VirusFilter


def wstartfunc (handle=None, abort=None, confdir=wc.ConfigDir, filelogs=True):
    """
    Initalize configuration, start psyco compiling and the proxy loop.
    This function does not return until Ctrl-C is pressed.
    """
    # init logging
    wc.initlog(os.path.join(confdir, "logging.conf"),
               wc.Name, filelogs=filelogs)
    # read configuration
    config = wc.configuration.init(confdir)
    if abort is not None:
        abort(False)
    config.init_filter_modules()
    wc.filter.VirusFilter.init_clamav_conf(config['clamavconf'])
    wc.proxy.dns_lookups.init_resolver()
    # psyco library for speedup
    try:
        import psyco
        # psyco >= 1.4.0 final is needed
        if psyco.__version__ >= 0x10400f0:
            psyco.profile(memory=10000)
        else:
            # warn about old psyco version
            wc.log.warn(wc.LOG_PROXY,
         _("Psyco is installed but not used since the version is too old.\n"
           "Psyco >= 1.4 is needed."))
    except ImportError:
        # no psyco available, just ignore
        pass
    # start the proxy
    wc.proxy.mainloop(handle=handle, abort=abort)


def restart ():
    """
    Restart the runit service. Assumes a standard installation, ie.
    it will not work if installed in custom directory.
    """
    service = "/var/service/webcleaner"
    stop_cmd = "svwaitdown -k -t 5 %s" % service
    start_cmd = "runsvctrl up %s" % service
    status = os.system(stop_cmd)
    if status != 0:
        wc.log.error(wc.LOG_PROXY,
                     "Stop command %r failed: %s", stop_cmd, str(status))
    status = os.system(start_cmd)
    if status != 0:
        wc.log.error(wc.LOG_PROXY,
                     "Start command %r failed: %s", start_cmd, str(status))
