/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* uddi.sql */

static const char *tbl0 = 
"create table UDDI..BUSINESS_ENTITY (\n"
"BE_BUSINESS_KEY		varchar,\n"
"BE_AUTHORIZED_NAME 	varchar,\n"
"BE_OPERATOR		varchar,\n"
"BE_NAME			varchar not null,\n"
"BE_CREATED		datetime,\n"
"BE_CHANGED		timestamp,\n"
"BE_OWNER		integer,\n"
"PRIMARY KEY (BE_BUSINESS_KEY)\n"
")\n";

static const char *tbl1 = 
"create table UDDI..BUSINESS_SERVICE (\n"
"BS_BUSINESS_KEY		varchar,\n"
"BS_SERVICE_KEY		varchar not null,\n"
"BS_NAME			varchar not null,\n"
"BS_CREATED		datetime,\n"
"BS_CHANGED		timestamp,\n"
"BS_OWNER		integer,\n"
"PRIMARY KEY (BS_SERVICE_KEY)\n"
")\n";

static const char *tbl2 = 
"create table UDDI..BINDING_TEMPLATE (\n"
"BT_BINDING_KEY		varchar,\n"
"BT_SERVICE_KEY		varchar,\n"
"BT_ACCESS_POINT		varchar,\n"
"BT_HOSTING_REDIRECTOR	varchar,\n"
"BT_URL_TYPE		varchar,\n"
"BT_CREATED		datetime,\n"
"BT_CHANGED		timestamp,\n"
"BT_OWNER		integer,\n"
"PRIMARY KEY (BT_BINDING_KEY)\n"
")\n";

static const char *tbl3 = 
"create table UDDI..TMODEL (\n"
"TM_TMODEL_KEY		varchar,\n"
"TM_AUTHORIZED_NAME      varchar,\n"
"TM_OPERATOR             varchar,\n"
"TM_NAME                 varchar,\n"
"TM_CREATED		datetime,\n"
"TM_CHANGED		timestamp,\n"
"TM_OWNER		integer,\n"
"primary key (TM_TMODEL_KEY)\n"
")\n";

static const char *tbl4 = 
"create table UDDI..DESCRIPTION (\n"
"UD_DESCRIPTION_KEY	varchar not null,\n"
"UD_DESC			varchar,\n"
"UD_LANG			varchar,\n"
"UD_PARENT_ID		varchar,\n"
"UD_TYPE			varchar\n"
")\n"
"create index DESC_PARENT on DESCRIPTION (UD_TYPE, UD_PARENT_ID)\n";

static const char *tbl5 = 
"create table UDDI..DISCOVERY_URL (\n"
"DU_DISCOVERY_KEY	varchar not null,\n"
"DU_PARENT_ID		varchar not null,\n"
"DU_PARENT_TYPE		varchar not null,\n"
"DU_URL			varchar,\n"
"DU_USE_TYPE		varchar\n"
")\n"
"create index DISCOVERY_URLS_PARENT on DISCOVERY_URL (DU_PARENT_TYPE, DU_PARENT_ID)\n";

static const char *tbl6 = 
"create table UDDI..ADDRESS_LINE (\n"
"AL_ADDRESS_KEY		varchar not null,\n"
"AL_PARENT_ID		varchar not null,\n"
"AL_PARENT_TYPE		varchar not null,\n"
"AL_USE_TYPE		varchar,\n"
"AL_SORT_CODE		varchar,\n"
"AL_LINE			varchar\n"
")\n"
"create index ADDR_LINE_PARENT on ADDRESS_LINE (AL_PARENT_TYPE, AL_PARENT_ID)\n";

static const char *tbl7 = 
"create table UDDI..CONTACTS (\n"
"CO_CONTACT_KEY		varchar,\n"
"CO_BUSINESS_ID		varchar not null,\n"
"CO_USE_TYPE		varchar,\n"
"CO_PERSONAL_NAME	varchar not NULL,\n"
"PRIMARY KEY (CO_CONTACT_KEY)\n"
")\n"
"create index IN_BUSINESS on CONTACTS (CO_BUSINESS_ID)\n";

static const char *tbl8 = 
"create table UDDI..EMAIL (\n"
"EM_EMAIL_KEY	varchar not null,\n"
"EM_CONTACT_KEY     varchar not null,\n"
"EM_ADDR            varchar,\n"
"EM_USE_TYPE        varchar\n"
")\n"
"create index IN_EMPARENT on EMAIL (EM_CONTACT_KEY)\n";

static const char *tbl9 = 
"create table UDDI..PHONE (\n"
"PH_PHONE_KEY	varchar not null,\n"
"PH_CONTACT_KEY     varchar not null,\n"
"PH_PHONE           varchar,\n"
"PH_USE_TYPE        varchar\n"
")\n"
"create index IN_PHPARENT on PHONE (PH_CONTACT_KEY)\n";

static const char *tbl10 = 
"create table UDDI..IDENTIFIER_BAG (\n"
"IB_IDENTIFIER_KEY	varchar not null,\n"
"IB_PARENT_ID		varchar not null,\n"
"IB_PARENT_TYPE		varchar not null,\n"
"IB_TMODEL_KEY_ID	varchar,\n"
"IB_KEY_NAME		varchar,\n"
"IB_KEY_VALUE		varchar\n"
")\n"
"create index IB_PARENT on IDENTIFIER_BAG (IB_PARENT_ID,IB_PARENT_TYPE)\n";

static const char *tbl11 = 
"create table UDDI..CATEGORY_BAG (\n"
"CB_CATEGORY_KEY		varchar not null,\n"
"CB_PARENT_ID		varchar not null,\n"
"CB_PARENT_TYPE		varchar not null,\n"
"CB_TMODEL_KEY_ID		varchar,\n"
"CB_KEY_NAME			varchar,\n"
"CB_KEY_VALUE		varchar\n"
")\n"
"create index CB_PARENT on CATEGORY_BAG (CB_PARENT_ID, CB_PARENT_TYPE)\n";

static const char *tbl12 = 
"create table UDDI..OVERVIEW_DOC (\n"
"OV_KEY				varchar,\n"
"OV_PARENT_ID			varchar not null,\n"
"OV_PARENT_TYPE			varchar not null,\n"
"OV_URL				varchar,\n"
"PRIMARY KEY (OV_KEY)\n"
")\n"
"create unique index PARENT_OVERVIEW_DOC on OVERVIEW_DOC (OV_PARENT_ID, OV_PARENT_TYPE)\n";

static const char *tbl13 = 
"create table UDDI..INSTANCE_DETAIL  (\n"
"ID_KEY  		varchar not null,\n"
"ID_BINDING_KEY   	varchar,\n"
"ID_TMODEL_KEY    	varchar,\n"
"ID_PARMS  		varchar,\n"
"primary key (ID_KEY)\n"
")\n"
"create index IN_IDPARENT on INSTANCE_DETAIL (ID_BINDING_KEY, ID_TMODEL_KEY)\n";

static const char *proc0 = 
"#line 241 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"LOAD_UDDI_TAXONOMY ()\n"
"{\n"
"\n"
"if (isstring (registry_get (\'UDDI_operator\')))\n"
"return;\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\', \'uddi-org:types\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid (), \'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\', \'tModel\', \'en\', \'UDDI Type Taxonomy\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'1\', \'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'1\', \'overviewDoc\', \'en\', \'Taxonomy used to categorize Service Descriptions.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'categorization\') ;\n"
"\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\', \'uddi-org:inquiry\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid (), \'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\', \'tModel\', \'en\', \'UDDI Inquiry API - Core Specification\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'2\', \'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'2\', \'overviewDoc\', \'en\', \'This tModel defines the inquiry API calls for interacting with the UDDI registry.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'specification\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'xmlSpec\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:4CD7E4BC-648B-426D-9936-443EAAC8AE23\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'soapSpec\') ;\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\', \'uddi-org:publication\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\', \'tModel\', \'en\', \'UDDI Publication API - Core Specification\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'3\', \'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'3\', \'overviewDoc\', \'en\', \'This tModel defines the publication API calls for interacting with the UDDI registry.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'specification\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'xmlSpec\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'soapSpec\') ;\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\', \'uddi-org:taxonomy\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\', \'tModel\', \'en\', \'UDDI Taxonomy API\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'4\', \'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'4\', \'overviewDoc\', \'en\', \'This tModel defines the taxonomy maintenance API calls for interacting with the UDDI registry.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'specification\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'xmlSpec\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:3FB66FB7-5FC3-462F-A351-C140D9BD8304\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'soapSpec\') ;\n"
"\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384\', \'unspsc-org:unspsc:3-1\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384\', \'tModel\', \'en\', \'Product Taxonomy: UNSPSC (Version 3.1)\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'5\',\'UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'5\', \'overviewDoc\', \'en\', \'This tModel defines the UNSPSC product taxonomy.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'categorization\') ;\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2\', \'ntis-gov:naics:1997\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2\', \'tModel\', \'en\', \'Business Taxonomy: NAICS (1997 Release)\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'6\',\'UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'6\', \'overviewDoc\', \'en\', \'This tModel defines the NAICS industry taxonomy.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'categorization\') ;\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:A035A07C-F362-44DD-8F95-E2B134BF43B4\', \'uddi-org:misc-taxonomy\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(),\'UUID:A035A07C-F362-44DD-8F95-E2B134BF43B4\', \'tModel\', \'en\', \'Other Taxonomy\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'7\',\'UUID:A035A07C-F362-44DD-8F95-E2B134BF43B4\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'7\', \'overviewDoc\', \'en\', \'This tModel defines an unidentified taxonomy.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:A035A07C-F362-44DD-8F95-E2B134BF43B4\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'categorization\') ;\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823\', \'dnb-com:D-U-N-S\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823\', \'tModel\', \'en\', \'Dun & Bradstreet D-U-N-S Number\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'8\', \'UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid (), \'8\', \'overviewDoc\', \'en\', \'This tModel is used for the Dun & Bradstreet  D-U-N-S Number identifier.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'identifier\') ;\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:B1B1BAF5-2329-43E6-AE13-BA8E97195039\', \'thomasregister-com:supplierID\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:B1B1BAF5-2329-43E6-AE13-BA8E97195039\', \'tModel\', \'en\', \'Thomas Registry Suppliers\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'9\',\'UUID:B1B1BAF5-2329-43E6-AE13-BA8E97195039\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'9\', \'overviewDoc\', \'en\', \'This tModel is used for the Thomas Register supplier identifier codes.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:B1B1BAF5-2329-43E6-AE13-BA8E97195039\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'types\',\'identifier\') ;\n"
"\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:68DE9E80-AD09-469D-8A37-088422BFBC36\', \'uddi-org:http\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(),\'UUID:68DE9E80-AD09-469D-8A37-088422BFBC36\', \'tModel\', \'en\', \'An http or web browser based web service\') ;\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'10\', \'UUID:68DE9E80-AD09-469D-8A37-088422BFBC36\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY,UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'10\', \'overviewDoc\', \'en\', \'This tModel is used to describe a web service that is invoked through a web browser and/or the http protocol.\') ;\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:68DE9E80-AD09-469D-8A37-088422BFBC36\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModelType\',\'transport\') ;\n"
"\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:93335D49-3EFB-48A0-ACEA-EA102B60DDC6\', \'uddi-org:smtp\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(),\'UUID:93335D49-3EFB-48A0-ACEA-EA102B60DDC6\', \'tModel\', \'en\', \'E-mail based web service\') ;\n"
"\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'11\', \'UUID:93335D49-3EFB-48A0-ACEA-EA102B60DDC6\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid (), \'11\', \'overviewDoc\', \'en\', \'This tModel is used to describe a web service that is invoked through SMTP email transmissions. These transmissions may be either between people or applications.\') ;\n"
"\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:93335D49-3EFB-48A0-ACEA-EA102B60DDC6\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModelType\',\'transport\') ;\n"
"\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:1A2B00BE-6E2C-42F5-875B-56F32686E0E7\', \'uddi-org:fax\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:1A2B00BE-6E2C-42F5-875B-56F32686E0E7\', \'tModel\', \'en\', \'Fax based web service\') ;\n"
"\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'12\',\'UUID:1A2B00BE-6E2C-42F5-875B-56F32686E0E7\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'12\', \'overviewDoc\', \'en\', \'This tModel is used to describe a web service that is invoked through fax transmissions.  These transmissions may be either between people or applications.\') ;\n"
"\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:1A2B00BE-6E2C-42F5-875B-56F32686E0E7\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModelType\',\'protocol\') ;\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674\', \'uddi-org:ftp\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674\', \'tModel\', \'en\', \'File transfer protocol (ftp) based web service\') ;\n"
"\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'13\',\'UUID:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'13\', \'overviewDoc\', \'en\', \'This tModel is used to describe a web service that is invoked through file transfers via the ftp protocol.\') ;\n"
"\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModelType\',\'transport\') ;\n"
"\n"
"\n"
"\n"
"insert soft TMODEL (TM_TMODEL_KEY,TM_NAME,TM_AUTHORIZED_NAME,TM_OPERATOR) values (\'UUID:38E12427-5536-4260-A6F9-B5B530E63A07\', \'uddi-org:telephone\', \'UDDI Admin\', \'www.openlinksw.com/services/uddi\') ;\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'UUID:38E12427-5536-4260-A6F9-B5B530E63A07\', \'tModel\', \'en\', \'Telephone based web service\') ;\n"
"\n"
"\n"
"insert soft OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL) values (\'14\',\'UUID:38E12427-5536-4260-A6F9-B5B530E63A07\', \'tModel\', \'http://www.uddi.org/specification.html\') ;\n"
"\n"
"\n"
"insert soft DESCRIPTION (UD_DESCRIPTION_KEY, UD_PARENT_ID, UD_TYPE, UD_LANG, UD_DESC) values (uuid(), \'14\', \'overviewDoc\', \'en\', \'This tModel is used to describe a web service that is invoked through a telephone call and interaction by voice and/or touch-tone.\') ;\n"
"\n"
"\n"
"insert soft CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE, CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE) values (uuid(), \'UUID:38E12427-5536-4260-A6F9-B5B530E63A07\',\'tModel\',\'UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4\',\'tModelType\',\'specification\') ;\n"
"\n"
"registry_set (\'UDDI_operator\', \'OpenLink Software\');\n"
"\n"
"}\n"
"--src uddi.sql:239\n"
;


static const char *other0 = 
" LOAD_UDDI_TAXONOMY ()\n";
static const char *proc1 = 
"#line 454 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BUSINESS_ENTITY (inout req any)\n"
"{\n"
"declare bk varchar;\n"
"declare operator varchar;\n"
"declare name varchar;\n"
"declare a_name varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare next any;\n"
"\n"
"\n"
"\n"
"\n"
"name := cast (xpath_eval (\'/businessEntity/name\', req, 1) as varchar);\n"
"bk := ucase (cast (xpath_eval (\'/businessEntity/@businessKey\', req, 1) as varchar));\n"
"operator := cast (xpath_eval (\'/businessEntity/@operator\', req, 1) as varchar);\n"
"a_name := cast (xpath_eval (\'/businessEntity/@authorizedName\', req, 1) as varchar);\n"
"\n"
"\n"
"if (name is NULL)\n"
"signal (\'10050\', \'The name element is empty\');\n"
"\n"
"if (bk is null)\n"
"bk := uuid ();\n"
"\n"
"if (exists (select 1 from UDDI.DBA.BUSINESS_ENTITY where BE_BUSINESS_KEY = bk))\n"
"{\n"
"\n"
"\n"
"\n"
"DELETE_BUSINESS_BK (bk);\n"
"\n"
"}\n"
"\n"
"\n"
"insert into UDDI.DBA.BUSINESS_ENTITY (BE_BUSINESS_KEY, BE_AUTHORIZED_NAME,\n"
"BE_OPERATOR, BE_NAME, BE_CREATED, BE_OWNER)\n"
"values (bk, a_name, operator, name, now(), owner);\n"
"\n"
"\n"
"next := xpath_eval (\'/businessEntity/discoveryURLs\', req, 1);\n"
"if (not next is NULL)\n"
"SAVE_DISCOVERY_URLS (bk, \'businessEntity\', next);\n"
"\n"
"next := xpath_eval (\'/businessEntity/description\', req, 0);\n"
"if (not next is NULL)\n"
"SAVE_DESCRIPRIONS (bk, \'businessEntity\', next);\n"
"\n"
"next := xpath_eval (\'/businessEntity/businessServices\', req, 1);\n"
"if (not next is NULL)\n"
"SAVE_BUSINESS_SERVICES (bk, \'businessEntity\', next, owner);\n"
"\n"
"next := xpath_eval (\'/businessEntity/contacts\', req, 1);\n"
"if (not next is NULL)\n"
"SAVE_CONTACTS (bk, \'businessEntity\', next);\n"
"\n"
"next := xpath_eval (\'/businessEntity/identifierBag\', req, 1);\n"
"if (not next is NULL)\n"
"SAVE_IDENTIFIER_BAG (bk, \'businessEntity\', next);\n"
"\n"
"next := xpath_eval (\'/businessEntity/categoryBag\', req, 1);\n"
"if (not next is NULL)\n"
"SAVE_CATEGORY_BAG (bk, \'businessEntity\', next);\n"
"\n"
"\n"
"\n"
"return bk;\n"
"\n"
"}\n"
"--src uddi.sql:452\n"
;

static const char *proc2 = 
"#line 527 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_SAVE_BUSINESS (in uddi_req any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare req any;\n"
"declare ses any;\n"
"declare ans any;\n"
"declare ress any;\n"
"declare token, owner varchar;\n"
"\n"
"if (__tag (uddi_req) <> __tag of XML)\n"
"req := xml_tree_doc (uddi_req);\n"
"else\n"
"req := uddi_req;\n"
"\n"
"token := cast (xpath_eval (\'/save_business/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"idx := 0;\n"
"ans := vector ();\n"
"\n"
"_all := xpath_eval (\'/save_business/businessEntity\', req, 0);\n"
"len := length (_all);\n"
"\n"
"if (_all is NULL)\n"
"_all := GET_FROM_UPLOAD_REGISTER (uddi_req);\n"
"\n"
"while (idx < len)\n"
"{\n"
"ress := kluc (aref (_all, idx));\n"
"ress := SAVE_BUSINESS_ENTITY (ress);\n"
"ans := vector_concat (ans, vector (ress));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"ses := string_output ();\n"
"BUSINESS_DETAIL (ans, ses);\n"
"\n"
"return (string_output_string(ses));\n"
"\n"
"}\n"
"--src uddi.sql:525\n"
;

static const char *proc3 = 
"#line 575 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_DESCRIPRIONS (in id any, in type varchar, inout desc_s any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare line any;\n"
"\n"
"idx := 0;\n"
"len := length (desc_s);\n"
"\n"
"delete from UDDI.DBA.DESCRIPTION where UD_PARENT_ID = id and UD_TYPE = type;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (desc_s, idx);\n"
"insert into UDDI.DBA.DESCRIPTION (UD_DESCRIPTION_KEY, UD_DESC, UD_LANG, UD_PARENT_ID, UD_TYPE)\n"
"values (uuid (), coalesce (cast (line as varchar), \'\'),\n"
"coalesce (cast (xpath_eval (\'@lang\', line, 1) as varchar), \'\'), id, type);\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src uddi.sql:573\n"
;

static const char *proc4 = 
"#line 601 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BUSINESS_SERVICES (in id varchar, in type varchar, inout services any, in owner integer)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"idx := 0;\n"
"_all := xpath_eval (\'businessService\', services, 0);\n"
"len := length (_all);\n"
"\n"
"for (select BS_SERVICE_KEY from BUSINESS_SERVICE where BS_BUSINESS_KEY = id) do\n"
"DELETE_SERVICE_SK (BS_SERVICE_KEY);\n"
"\n"
"while (idx < len)\n"
"{\n"
"SAVE_BUSINESS_SERVICE (id, type, aref (_all, idx), owner);\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src uddi.sql:599\n"
;

static const char *proc5 = 
"#line 626 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BUSINESS_SERVICE (in id varchar, in type varchar, inout service any, in owner integer)\n"
"{\n"
"\n"
"declare sk varchar;\n"
"declare bk varchar;\n"
"declare name varchar;\n"
"declare next any;\n"
"\n"
"name := cast (xpath_eval (\'name\', service, 1) as varchar);\n"
"\n"
"bk := ucase (cast (xpath_eval (\'@businessKey\', service, 1) as varchar));\n"
"sk := cast (xpath_eval (\'@serviceKey\', service, 1) as varchar);\n"
"\n"
"if (id is NULL)\n"
"{\n"
"id := ((select BE_BUSINESS_KEY from UDDI.DBA.BUSINESS_ENTITY where BE_BUSINESS_KEY = bk));\n"
"\n"
"if (id is NULL)\n"
"signal (\'10050\', sprintf (\'No Business Entity with Business key %s\', bk));\n"
"}\n"
"\n"
"if (isstring (sk))\n"
"sk := ucase (sk);\n"
"else\n"
"sk := uuid ();\n"
"\n"
"if (bk <> id)\n"
"signal (\'10050\', sprintf (\'Invalid Business Key Passed %s in Business Service %s\', bk, name));\n"
"else if (bk is NULL)\n"
"bk := id;\n"
"\n"
"if (exists (select DELETE_SERVICE_SK (BS_SERVICE_KEY) from UDDI.DBA.BUSINESS_SERVICE\n"
"where BS_BUSINESS_KEY = bk and BS_SERVICE_KEY = sk))\n"
"{\n"
"DELETE_SERVICE_SK (sk);\n"
"}\n"
"\n"
"insert into UDDI.DBA.BUSINESS_SERVICE (BS_BUSINESS_KEY, BS_SERVICE_KEY, BS_NAME, BS_CREATED, BS_OWNER)\n"
"values (bk, sk, name, now(), owner);\n"
"\n"
"next := xpath_eval (\'description\', service, 0);\n"
"SAVE_DESCRIPRIONS (sk, \'businessService\', next);\n"
"\n"
"next := xpath_eval (\'bindingTemplates\', service, 1);\n"
"if (next is not null)\n"
"SAVE_BINDING_TEMPLATES (sk, \'businessService\', next, owner);\n"
"\n"
"next := xpath_eval (\'categoryBag\', service, 1);\n"
"\n"
"if (not next is null)\n"
"SAVE_CATEGORY_BAG (sk, \'businessService\', next);\n"
"\n"
"return sk;\n"
"}\n"
"--src uddi.sql:624\n"
;

static const char *proc6 = 
"#line 685 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BINDING_TEMPLATES (in id varchar, in type varchar, inout templates any, in owner integer)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare res any;\n"
"\n"
"idx := 0;\n"
"res := vector ();\n"
"\n"
"_all := xpath_eval (\'bindingTemplate\', templates, 0);\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"res := vector_concat (res, vector (SAVE_BINDING_TEMPLATE (id, type, aref (_all, idx), owner)));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return res;\n"
"\n"
"}\n"
"--src uddi.sql:683\n"
;

static const char *proc7 = 
"#line 713 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BINDING_TEMPLATE (in id varchar, in type varchar, inout template any, in owner integer)\n"
"{\n"
"\n"
"declare sk varchar;\n"
"declare bin_k varchar;\n"
"declare acc_p varchar;\n"
"declare host_red varchar;\n"
"declare url_t varchar;\n"
"declare next any;\n"
"\n"
"bin_k := ucase (cast (xpath_eval (\'@bindingKey\', template, 1) as varchar));\n"
"sk := ucase (cast (xpath_eval (\'@serviceKey\', template, 1) as varchar));\n"
"acc_p := cast (xpath_eval (\'accessPoint\', template, 1) as varchar);\n"
"host_red := coalesce (cast (xpath_eval (\'hostingRedirector\', template, 1) as varchar), \'\');\n"
"url_t := coalesce (cast (xpath_eval (\'@URLType\', template, 1) as varchar), \'\');\n"
"\n"
"if (bin_k is null)\n"
"bin_k := uuid ();\n"
"\n"
"if (exists (select 1 from UDDI.DBA.BINDING_TEMPLATE where BT_BINDING_KEY = bin_k and BT_SERVICE_KEY = sk))\n"
"{\n"
"update UDDI.DBA.BINDING_TEMPLATE set BT_ACCESS_POINT = acc_p,\n"
"BT_HOSTING_REDIRECTOR = host_red, BT_URL_TYPE = url_t, BT_OWNER = owner\n"
"where BT_BINDING_KEY = bin_k and BT_SERVICE_KEY = sk;\n"
"}\n"
"else\n"
"{\n"
"insert into UDDI.DBA.BINDING_TEMPLATE (BT_BINDING_KEY, BT_SERVICE_KEY,\n"
"BT_ACCESS_POINT, BT_HOSTING_REDIRECTOR, BT_URL_TYPE, BT_CREATED, BT_OWNER)\n"
"values (bin_k, sk, acc_p, host_red, url_t, now(), owner);\n"
"}\n"
"\n"
"next := xpath_eval (\'description\', template, 0);\n"
"SAVE_DESCRIPRIONS (bin_k, \'bindingTemplate\', next);\n"
"\n"
"next := xpath_eval (\'tModelInstanceDetails\', template, 1);\n"
"if (next is not null)\n"
"SAVE_TMODEL_INSTANCE_DETAILS (id, bin_k, \'businessService\', next);\n"
"\n"
"return bin_k;\n"
"}\n"
"--src uddi.sql:711\n"
;

static const char *proc8 = 
"#line 759 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_TMODEL_INSTANCE_DETAILS (in id varchar, in bin_k varchar, in type varchar, inout i_det any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"idx := 0;\n"
"\n"
"_all := xpath_eval (\'tModelInstanceInfo\', i_det, 0);\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"SAVE_TMODEL_INSTANCE_INFOS_1 (id, bin_k, type, aref (_all, idx));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:757\n"
;

static const char *proc9 = 
"#line 782 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_TMODEL_INSTANCE_INFOS_1 (in id varchar, in bin_k varchar, in type varchar, inout i_det any)\n"
"{\n"
"\n"
"declare t_k any;\n"
"declare in_k varchar;\n"
"declare inst_param any;\n"
"\n"
"t_k := cast (xpath_eval (\'@tModelKey\', i_det, 1) as varchar);\n"
"inst_param := coalesce (cast (xpath_eval (\'instanceDetails/instanceParms\', i_det, 1) as varchar), \'\');\n"
"in_k := sequence_next (\'instance_id\');\n"
"\n"
"if (t_k is null or t_k = 0)\n"
"t_k := concat (\'UDDI:\', uuid ());\n"
"else\n"
"{\n"
"t_k := ucase (t_k);\n"
"delete from INSTANCE_DETAIL where ID_BINDING_KEY = bin_k and ID_TMODEL_KEY = t_k;\n"
"}\n"
"\n"
"insert into INSTANCE_DETAIL (ID_KEY, ID_BINDING_KEY, ID_TMODEL_KEY, ID_PARMS)\n"
"values (in_k, bin_k, t_k, inst_param);\n"
"\n"
"SAVE_DESCRIPRIONS (in_k, \'instanceDetails\', xpath_eval (\'instanceDetails/description\', i_det, 0));\n"
"SAVE_DESCRIPRIONS (in_k, \'tModelInstanceInfo\', xpath_eval (\'description\', i_det, 0));\n"
"SAVE_OVERVIEW_DOC (in_k, \'tModelInstanceInfo\', xpath_eval (\'instanceDetails/overviewDoc\', i_det, 1));\n"
"\n"
"}\n"
"--src uddi.sql:780\n"
;

static const char *proc10 = 
"#line 814 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_IDENTIFIER_BAG (in id varchar, in type varchar, inout i_bag any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare line any;\n"
"declare k_name varchar;\n"
"declare k_val varchar;\n"
"declare t_key varchar;\n"
"\n"
"idx := 0;\n"
"_all := xpath_eval (\'keyedReference\', i_bag, 0);\n"
"\n"
"len := length (_all);\n"
"delete from UDDI.DBA.IDENTIFIER_BAG where IB_PARENT_ID = id and IB_PARENT_TYPE = type;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (_all, idx);\n"
"k_name := cast (xpath_eval (\'@keyName\', line, 1) as varchar);\n"
"k_val := cast (xpath_eval (\'@keyValue\', line, 1) as varchar);\n"
"t_key := ucase (cast (xpath_eval (\'@tModelKey\', line, 1) as varchar));\n"
"\n"
"\n"
"insert into UDDI.DBA.IDENTIFIER_BAG (IB_IDENTIFIER_KEY, IB_PARENT_ID, IB_PARENT_TYPE,\n"
"IB_TMODEL_KEY_ID, IB_KEY_NAME, IB_KEY_VALUE)\n"
"values (uuid(), id, type, coalesce (t_key, \'\'), k_name, k_val);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src uddi.sql:812\n"
;

static const char *proc11 = 
"#line 851 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_CATEGORY_BAG (in id varchar, in type varchar, inout c_bag any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare line any;\n"
"declare k_name varchar;\n"
"declare k_val varchar;\n"
"declare t_key varchar;\n"
"\n"
"if (c_bag is null)\n"
"return;\n"
"\n"
"idx := 0;\n"
"_all := xpath_eval (\'keyedReference\', c_bag, 0);\n"
"len := length (_all);\n"
"\n"
"delete from UDDI.DBA.CATEGORY_BAG where CB_PARENT_ID = id and CB_PARENT_TYPE = type;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (_all, idx);\n"
"k_name := cast (xpath_eval (\'@keyName\', line, 1) as varchar);\n"
"k_val := cast (xpath_eval (\'@keyValue\', line, 1) as varchar);\n"
"t_key := ucase (cast (xpath_eval (\'@tModelKey\', line, 1) as varchar));\n"
"\n"
"insert into UDDI.DBA.CATEGORY_BAG (CB_CATEGORY_KEY, CB_PARENT_ID, CB_PARENT_TYPE,\n"
"CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE)\n"
"values (uuid(), id, type, t_key, k_name, k_val);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:849\n"
;

static const char *proc12 = 
"#line 891 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_OVERVIEW_DOC (in id varchar, in type varchar, inout ov_doc any)\n"
"{\n"
"\n"
"declare o_url varchar;\n"
"declare ov_key any;\n"
"\n"
"if (ov_doc is NULL)\n"
"return;\n"
"\n"
"o_url := cast (xpath_eval (\'overviewURL\', ov_doc, 1) as varchar);\n"
"ov_key := sequence_next (\'overviewDoc_key\');\n"
"ov_key := ov_key + 17;\n"
"\n"
"delete from UDDI.DBA.OVERVIEW_DOC where OV_PARENT_ID = id and OV_PARENT_TYPE = type;\n"
"\n"
"insert into UDDI.DBA.OVERVIEW_DOC (OV_KEY, OV_PARENT_ID, OV_PARENT_TYPE, OV_URL)\n"
"values (ov_key, id, type, o_url);\n"
"\n"
"SAVE_DESCRIPRIONS (ov_key, \'overviewDoc\', xpath_eval (\'description\', ov_doc, 0));\n"
"\n"
"}\n"
"--src uddi.sql:889\n"
;

static const char *proc13 = 
"#line 917 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_SAVE_TMODEL (in uddi_req any)\n"
"{\n"
"declare req any;\n"
"declare tm_key varchar;\n"
"declare name varchar;\n"
"declare operator varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare line any;\n"
"declare a_name any;\n"
"declare tm_keys any;\n"
"declare ses any;\n"
"\n"
"ses := string_output ();\n"
"tm_keys := vector ();\n"
"\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/save_tModel/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"\n"
"\n"
"_all := xpath_eval (\'/save_tModel/tModel\', req, 0);\n"
"\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (_all, idx);\n"
"name := cast (xpath_eval (\'name\', line, 1) as varchar);\n"
"operator := cast (xpath_eval (\'@operator\', line, 1) as varchar);\n"
"a_name := cast (xpath_eval (\'@authorizedName\', line, 1) as varchar);\n"
"tm_key := ucase (cast (xpath_eval (\'@tModelKey\', line, 1) as varchar));\n"
"\n"
"if (tm_key is null)\n"
"tm_key := uuid ();\n"
"\n"
"if (exists (select 1 from UDDI.DBA.TMODEL where TM_TMODEL_KEY = tm_key))\n"
"{\n"
"update UDDI.DBA.TMODEL set TM_AUTHORIZED_NAME = a_name, TM_OPERATOR = operator,\n"
"TM_NAME = name, TM_OWNER = owner where TM_TMODEL_KEY = tm_key;\n"
"}\n"
"else\n"
"{\n"
"insert into TMODEL (TM_TMODEL_KEY, TM_AUTHORIZED_NAME, TM_OPERATOR, TM_NAME, TM_CREATED, TM_OWNER)\n"
"values (tm_key, a_name, operator, name, now(), owner);\n"
"}\n"
"\n"
"SAVE_DESCRIPRIONS (tm_key, \'tModel\', xpath_eval (\'description\', line, 0));\n"
"SAVE_CATEGORY_BAG (tm_key, \'tModel\', xpath_eval (\'categoryBag\', line, 1));\n"
"SAVE_OVERVIEW_DOC (tm_key, \'tModel\', xpath_eval (\'overviewDoc\', line, 1));\n"
"\n"
"tm_keys := vector_concat (tm_keys, vector (tm_key));\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"\n"
"TMODEL_DETAIL (tm_keys, ses);\n"
"return (string_output_string(ses));\n"
"}\n"
"--src uddi.sql:915\n"
;

static const char *proc14 = 
"#line 988 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_DISCOVERY_URLS (in id varchar, in type varchar, inout urls any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare pos integer;\n"
"declare _all any;\n"
"declare line any;\n"
"declare url varchar;\n"
"declare url_t any;\n"
"\n"
"idx := 0;\n"
"_all := xpath_eval (\'discoveryURL\', urls, 0);\n"
"len := length (_all);\n"
"\n"
"delete from UDDI.DBA.DISCOVERY_URL where DU_PARENT_ID = id and DU_PARENT_TYPE = type;\n"
"\n"
"if (len = 0)\n"
"{\n"
"insert into UDDI.DBA.DISCOVERY_URL (DU_DISCOVERY_KEY, DU_PARENT_ID, DU_PARENT_TYPE, DU_URL, DU_USE_TYPE)\n"
"values (uuid(), id, type, \'http://. . . .\', \'http\');\n"
"}\n"
"else\n"
"{\n"
"while (idx < len)\n"
"{\n"
"line := aref (_all, idx);\n"
"\n"
"url := cast (line as varchar);\n"
"url_t := cast (xpath_eval (\'@useType\', line, 1) as varchar);\n"
"\n"
"if (url_t = 0)\n"
"{\n"
"pos := strstr (url, \':\');\n"
"\n"
"if (pos is NULL)\n"
"url_t := \'\';\n"
"else\n"
"url_t := \"LEFT\" (url, pos);\n"
"}\n"
"\n"
"insert into UDDI.DBA.DISCOVERY_URL (DU_DISCOVERY_KEY, DU_PARENT_ID, DU_PARENT_TYPE, DU_URL, DU_USE_TYPE)\n"
"values (uuid (), id, type, url, url_t);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src uddi.sql:986\n"
;

static const char *proc15 = 
"#line 1041 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_CONTACTS (in id varchar, in type varchar, inout contacts any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"declare line any;\n"
"declare per_name varchar;\n"
"declare con_t varchar;\n"
"declare con_k varchar;\n"
"\n"
"idx := 0;\n"
"_all := xpath_eval (\'contact\', contacts, 0);\n"
"len := length (_all);\n"
"\n"
"delete from UDDI.DBA.CONTACTS where CO_BUSINESS_ID = id;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (_all, idx);\n"
"per_name := cast (xpath_eval (\'personName\', line, 1) as varchar);\n"
"con_t := cast (xpath_eval (\'@useType\', line, 1) as varchar);\n"
"con_k := concat (\'c\', uuid());\n"
"SAVE_DESCRIPRIONS (con_k, \'contacts\', xpath_eval (\'description\', line, 0));\n"
"SAVE_PHONES (id, con_k, xpath_eval (\'phone\', line, 0));\n"
"SAVE_EMAILS (id, con_k, xpath_eval (\'email\', line, 0));\n"
"SAVE_ADDRESS (id, con_k, xpath_eval (\'address\', line, 0));\n"
"\n"
"insert into UDDI.DBA.CONTACTS (CO_BUSINESS_ID, CO_USE_TYPE, CO_PERSONAL_NAME, CO_CONTACT_KEY)\n"
"values (id, con_t, per_name, con_k);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:1039\n"
;

static const char *proc16 = 
"#line 1080 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_EMAILS (in id varchar, in c_k varchar, inout email_s any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare line any;\n"
"\n"
"idx := 0;\n"
"len := length (email_s);\n"
"\n"
"delete from UDDI.DBA.EMAIL where EM_CONTACT_KEY= c_k;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (email_s, idx);\n"
"insert into UDDI.DBA.EMAIL (EM_EMAIL_KEY, EM_CONTACT_KEY, EM_ADDR, EM_USE_TYPE)\n"
"values (uuid(), c_k, coalesce (cast (line as varchar), \'\'),\n"
"coalesce (cast (xpath_eval (\'@useType\', line, 1) as varchar), \'\'));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:1078\n"
;

static const char *proc17 = 
"#line 1106 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_PHONES (in id varchar, in c_k varchar, inout phones_s any)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare line any;\n"
"\n"
"idx := 0;\n"
"len := length (phones_s);\n"
"\n"
"delete from UDDI.DBA.PHONE where PH_CONTACT_KEY = c_k;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (phones_s, idx);\n"
"insert into UDDI.DBA.PHONE (PH_PHONE_KEY, PH_CONTACT_KEY, PH_PHONE, PH_USE_TYPE)\n"
"values (uuid(), c_k, coalesce (cast (line as varchar), \'\'),\n"
"coalesce (cast (xpath_eval (\'@useType\', line, 1) as varchar), \'\'));\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:1104\n"
;

static const char *proc18 = 
"#line 1133 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_ADDRESS (in id varchar, in c_k varchar, inout address_s any)\n"
"{\n"
"\n"
"declare idx_1, idx_2 integer;\n"
"declare len_1, len_2 integer;\n"
"declare sort_code, use_type varchar;\n"
"declare lines any;\n"
"declare line any;\n"
"\n"
"idx_1 := 0;\n"
"len_1 := length (address_s);\n"
"\n"
"delete from UDDI.DBA.ADDRESS_LINE where AL_PARENT_ID = c_k;\n"
"\n"
"while (idx_1 < len_1)\n"
"{\n"
"line := aref (address_s, idx_1);\n"
"lines := xpath_eval (\'addressLine\', line, 0);\n"
"idx_2 := 0;\n"
"len_2 := length (lines);\n"
"sort_code := cast (xpath_eval (\'@sortCode\', line, 1) as varchar);\n"
"use_type := cast (xpath_eval (\'@useType\', line, 1) as varchar);\n"
"while (idx_2 < len_2)\n"
"{\n"
"insert into UDDI.DBA.ADDRESS_LINE (AL_ADDRESS_KEY, AL_PARENT_ID, AL_PARENT_TYPE, AL_USE_TYPE, AL_SORT_CODE, AL_LINE)\n"
"values (uuid(), c_k, \'contacts\', use_type, sort_code,\n"
"coalesce (cast (aref (lines, idx_2) as varchar), \'\'));\n"
"\n"
"idx_2 := idx_2 + 1;\n"
"}\n"
"idx_1 := idx_1 + 1;\n"
"}\n"
"}\n"
"--src uddi.sql:1131\n"
;

static const char *proc19 = 
"#line 1170 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DELETE_BUSINESS_BK (in bk varchar)\n"
"{\n"
"\n"
"if (exists (select 1 from UDDI.DBA.BUSINESS_ENTITY where BE_BUSINESS_KEY = bk))\n"
"{\n"
"delete from IDENTIFIER_BAG where IB_PARENT_ID = bk;\n"
"delete from CATEGORY_BAG where CB_PARENT_ID = bk and CB_PARENT_TYPE = \'businessEntity\';\n"
"delete from DESCRIPTION where UD_PARENT_ID = bk and UD_TYPE = \'businessEntity\';\n"
"\n"
"for (select CO_CONTACT_KEY from CONTACTS where CO_BUSINESS_ID = bk) do\n"
"{\n"
"delete from EMAIL where EM_CONTACT_KEY = CO_CONTACT_KEY;\n"
"delete from PHONE where PH_CONTACT_KEY = CO_CONTACT_KEY;\n"
"delete from DESCRIPTION where UD_PARENT_ID = CO_CONTACT_KEY and UD_TYPE = \'contacts\';\n"
"delete from ADDRESS_LINE where AL_PARENT_ID = CO_CONTACT_KEY;\n"
"}\n"
"\n"
"delete from CONTACTS where CO_BUSINESS_ID = bk;\n"
"delete from ADDRESS_LINE where AL_PARENT_ID = bk;\n"
"\n"
"for (select BS_SERVICE_KEY from BUSINESS_SERVICE where BS_BUSINESS_KEY = bk) do\n"
"DELETE_SERVICE_SK (BS_SERVICE_KEY);\n"
"\n"
"delete from BUSINESS_SERVICE where BS_BUSINESS_KEY = bk;\n"
"delete from DISCOVERY_URL where DU_PARENT_ID = bk;\n"
"delete from BUSINESS_ENTITY where BE_BUSINESS_KEY = bk;\n"
"}\n"
"else\n"
"{\n"
"signal (\'10050\', sprintf (\'Invalid Business KeyPassed %s\', bk));\n"
"}\n"
"}\n"
"--src uddi.sql:1168\n"
;

static const char *proc20 = 
"#line 1205 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_SAVE_SERVICE (in uddi_req any)\n"
"{\n"
"\n"
"declare req varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare ser_key varchar;\n"
"declare ses any;\n"
"\n"
"ses := string_output ();\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/save_service/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"req := xpath_eval (\'/save_service/businessService\', req, 0);\n"
"\n"
"if (req is NULL)\n"
"signal (\'10050\', \'Bad request save service\');\n"
"\n"
"ser_key := SAVE_BUSINESS_SERVICE (NULL, NULL, aref (req, 0), owner);\n"
"\n"
"SERVICE_DETAIL (vector (ser_key), ses);\n"
"return (string_output_string(ses));\n"
"\n"
"}\n"
"--src uddi.sql:1203\n"
;

static const char *proc21 = 
"#line 1235 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DELETE_SERVICE_SK (in sk varchar)\n"
"{\n"
"\n"
"declare temp varchar;\n"
"\n"
"if (exists (select 1 from UDDI.DBA.BUSINESS_SERVICE where BS_SERVICE_KEY = sk))\n"
"{\n"
"for (select BT_BINDING_KEY from BINDING_TEMPLATE where BT_SERVICE_KEY = sk) do\n"
"DELETE_BINDING_BK (BT_BINDING_KEY);\n"
"\n"
"delete from DESCRIPTION where UD_PARENT_ID = sk and UD_TYPE = \'businessService\';\n"
"delete from BINDING_TEMPLATE where BT_SERVICE_KEY = sk;\n"
"delete from CATEGORY_BAG where CB_PARENT_ID = sk and CB_PARENT_TYPE = \'businessService\';\n"
"\n"
"delete from BUSINESS_SERVICE where BS_SERVICE_KEY = sk;\n"
"}\n"
"else\n"
"{\n"
"signal (\'10050\', sprintf (\'Invalid Service Key Passed %s\', sk));\n"
"}\n"
"}\n"
"--src uddi.sql:1233\n"
;

static const char *proc22 = 
"#line 1260 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DELETE_BINDING_BK (in bin_k varchar)\n"
"{\n"
"if (exists (select 1 from UDDI.DBA.BINDING_TEMPLATE where BT_BINDING_KEY = bin_k))\n"
"{\n"
"for (select ID_KEY from INSTANCE_DETAIL where ID_BINDING_KEY = bin_k) do\n"
"{\n"
"delete from DESCRIPTION where UD_PARENT_ID = ID_KEY and UD_TYPE = \'tModelInstanceInfo\';\n"
"delete from DESCRIPTION where UD_PARENT_ID = ID_KEY and UD_TYPE = \'instanceDetails\';\n"
"delete from OVERVIEW_DOC where OV_PARENT_ID = ID_KEY and OV_PARENT_TYPE = \'tModelInstanceInfo\';\n"
"}\n"
"delete from DESCRIPTION where UD_PARENT_ID = bin_k and UD_TYPE = \'bindingTemplate\';\n"
"delete from INSTANCE_DETAIL where ID_BINDING_KEY = bin_k;\n"
"}\n"
"else\n"
"{\n"
"signal (\'10050\', sprintf (\'Invalid Binding Key Passed %s\', bin_k));\n"
"}\n"
"}\n"
"--src uddi.sql:1258\n"
;

static const char *proc23 = 
"#line 1282 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DELETE_TMODEL_TK (in tm_key varchar)\n"
"{\n"
"\n"
"if (exists (select 1 from UDDI.DBA.TMODEL where TM_TMODEL_KEY = tm_key))\n"
"{\n"
"delete from TMODEL where TM_TMODEL_KEY = tm_key;\n"
"delete from CATEGORY_BAG where CB_PARENT_ID = tm_key and CB_PARENT_TYPE = \'tModel\';\n"
"for (select OV_KEY from OVERVIEW_DOC where OV_PARENT_ID = tm_key and OV_PARENT_TYPE = \'tModel\') do\n"
"delete from DESCRIPTION where UD_PARENT_ID = OV_KEY and UD_TYPE = \'overviewDoc\';\n"
"delete from DESCRIPTION where UD_PARENT_ID = tm_key and UD_TYPE = \'tModel\';\n"
"delete from OVERVIEW_DOC where OV_PARENT_ID = tm_key and OV_PARENT_TYPE = \'tModel\';\n"
"}\n"
"else\n"
"{\n"
"signal (\'10050\', sprintf (\'Invalid tModel Key Passed %s\', tm_key));\n"
"}\n"
"\n"
"}\n"
"--src uddi.sql:1280\n"
;

static const char *proc24 = 
"#line 1304 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_SAVE_BINDING (in uddi_req any)\n"
"{\n"
"\n"
"declare req any;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare ses any;\n"
"declare resp any;\n"
"\n"
"ses := string_output ();\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/save_binding/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"req := xpath_eval (\'/save_binding\', req, 0);\n"
"\n"
"if (length (req) = 0)\n"
"{\n"
"signal (\'10050\', \'Bad request Save Binding \');\n"
"}\n"
"\n"
"resp := SAVE_BINDING_TEMPLATES (NULL, NULL, aref (req, 0), owner);\n"
"\n"
"BINDING_DETAIL (resp, ses);\n"
"return (string_output_string(ses));\n"
"\n"
"}\n"
"--src uddi.sql:1302\n"
;

static const char *proc25 = 
"#line 1335 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_DELETE_BUSINESS (in uddi_req any)\n"
"{\n"
"declare req any;\n"
"declare bk varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/delete_business/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"_all := xpath_eval (\'/delete_business/businessKey\', req, 0);\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"if (_all is NULL)\n"
"{\n"
"signal (\'10050\', \'Delete Business No business key \');\n"
"}\n"
"\n"
"while (idx < len)\n"
"{\n"
"bk := cast (aref (_all, idx) as varchar);\n"
"DELETE_BUSINESS_BK (bk);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return OK_DISPOSITION_REPORT ();\n"
"\n"
"}\n"
"--src uddi.sql:1333\n"
;

static const char *proc26 = 
"#line 1373 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_DELETE_SERVICE (in uddi_req any)\n"
"{\n"
"declare req any;\n"
"declare sk varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/delete_service/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"_all := xpath_eval (\'/delete_service/serviceKey\', req, 0);\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"if (_all is NULL)\n"
"{\n"
"signal (\'10050\', \'Delete Service No service key \');\n"
"}\n"
"\n"
"while (idx < len)\n"
"{\n"
"sk := cast (aref (_all, idx) as varchar);\n"
"DELETE_SERVICE_SK (sk);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return OK_DISPOSITION_REPORT ();\n"
"\n"
"}\n"
"--src uddi.sql:1371\n"
;

static const char *proc27 = 
"#line 1411 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_DELETE_BINDING (in uddi_req any)\n"
"{\n"
"declare req any;\n"
"declare bin_k varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/delete_binding/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"_all := xpath_eval (\'/delete_binding/bindingKey\', req, 0);\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"if (len = 0)\n"
"{\n"
"signal (\'10050\', \'Bad request Delete Binding \');\n"
"}\n"
"\n"
"while (idx < len)\n"
"{\n"
"bin_k := cast (aref (_all, idx) as varchar);\n"
"DELETE_BINDING_BK (bin_k);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return OK_DISPOSITION_REPORT ();\n"
"\n"
"}\n"
"--src uddi.sql:1409\n"
;

static const char *proc28 = 
"#line 1449 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_DELETE_TMODEL (in uddi_req any)\n"
"{\n"
"declare req any;\n"
"declare tm_key varchar;\n"
"declare token varchar;\n"
"declare owner integer;\n"
"declare idx integer;\n"
"declare len integer;\n"
"declare _all any;\n"
"\n"
"req := xml_tree_doc (uddi_req);\n"
"\n"
"token := cast (xpath_eval (\'/delete_tModel/authInfo\', req, 1) as varchar);\n"
"owner := VERIFY_AUTH_INFO (token);\n"
"\n"
"_all := xpath_eval (\'/delete_tModel/tModelKey\', req, 0);\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"tm_key := cast (aref (_all, idx) as varchar);\n"
"DELETE_TMODEL_TK (tm_key);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return OK_DISPOSITION_REPORT ();\n"
"\n"
"}\n"
"--src uddi.sql:1447\n"
;

static const char *proc29 = 
"#line 1482 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"GET_FROM_UPLOAD_REGISTER (in req any)\n"
"{\n"
"\n"
"declare idx, len integer;\n"
"declare _all any;\n"
"declare temp any;\n"
"declare temp1 any;\n"
"declare line any;\n"
"declare list any;\n"
"declare ses any;\n"
"\n"
"ses := string_output ();\n"
"\n"
"_all := xpath_eval (\'/uploadRegister\', req, 0);\n"
"\n"
"idx := 0;\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := cast (aref (list, idx) as varchar);\n"
"temp := http_get(line, \'GET\');\n"
"temp := xml_tree_doc (temp);\n"
"\n"
"temp1 := xpath_eval (\'/Envelope/Body/businessDetail/businessEntity\', temp, 1);\n"
"\n"
"http_value (temp1, NULL, ses);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return string_output_string (ses);\n"
"}\n"
"--src uddi.sql:1480\n"
;

static const char *proc30 = 
"#line 1519 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SAVE_BUSINESS_FROM_FILE (in file_name varchar)\n"
"{\n"
"declare read, req any;\n"
"\n"
"read := file_to_string (file_name);\n"
"read := concat (\'<save_business>\', read ,\'</save_business>\');\n"
"\n"
"\n"
"save_business (read);\n"
"\n"
"return;\n"
"}\n"
"--src uddi.sql:1517\n"
;

static const char *proc31 = 
"#line 1536 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_AUTHTOKEN (in uddi_req any)\n"
"{\n"
"declare ent any;\n"
"declare userID, cred varchar;\n"
"declare ses any;\n"
"declare own integer;\n"
"ses := string_output ();\n"
"ent := xml_tree_doc (uddi_req);\n"
"userID := cast (xpath_eval (\'/get_authToken/@userID\', ent, 1) as varchar);\n"
"cred := cast (xpath_eval (\'/get_authToken/@cred\', ent, 1) as varchar);\n"
"\n"
"\n"
"own := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = userID and U_PWD = cred), NULL);\n"
"if (own is not null)\n"
"signal (\'10150\', sprintf (\'The user \"%s\" is not valid, or password is incorrect\', userID));\n"
"\n"
"declare ses_id varchar;\n"
"\n"
"ses_id := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"\n"
"insert into WS.WS.SESSION (S_ID, S_EXPIRE,S_DOMAIN, S_OPAQUE, S_VARS, S_REALM)\n"
"values (ses_id, dateadd (\'minute\', 10, now ()), \'UDDI\', ses_id, own, \'UDDI service\');\n"
"\n"
"http (sprintf (\'<authToken generic=\"1.0\" operator=\"%s\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"http (sprintf (\'<authInfo>%s</authInfo>\', ses_id), ses);\n"
"\n"
"http (\'</authToken>\', ses);\n"
"\n"
"\n"
"return (string_output_string(ses));\n"
"}\n"
"--src uddi.sql:1534\n"
;

static const char *proc32 = 
"#line 1570 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_DISCARD_AUTHTOKEN (in uddi_req any)\n"
"{\n"
"declare ent any;\n"
"declare token varchar;\n"
"ent := xml_tree_doc (uddi_req);\n"
"token := cast (xpath_eval (\'/discard_authToken/authInfo\', ent, 1) as varchar);\n"
"if (not length (token))\n"
"signal (\'10120\', \'Authentication token required upon discard_authToken call\');\n"
"delete from  WS.WS.SESSION where S_OPAQUE = token;\n"
"return OK_DISPOSITION_REPORT ();\n"
"}\n"
"--src uddi.sql:1568\n"
;

static const char *proc33 = 
"#line 1584 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"OK_DISPOSITION_REPORT ()\n"
"{\n"
"return (sprintf (\'<dispositionReport generic=\"1.0\" operator=\"%s\"  xmlns=\"urn:uddi-org:api\" ><result errno=\"0\" ><errInfo errCode=\"E_success\" /></result></dispositionReport>\', registry_get (\'UDDI_operator\')));\n"
"}\n"
"--src uddi.sql:1582\n"
;

static const char *proc34 = 
"#line 1591 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_REGISTEREDINFO (in uddi_req any)\n"
"{\n"
"declare ent any;\n"
"declare token varchar;\n"
"declare ses any;\n"
"declare own integer;\n"
"ses := string_output ();\n"
"ent := xml_tree_doc (uddi_req);\n"
"token := cast (xpath_eval (\'/discard_authToken/authInfo\', ent, 1) as varchar);\n"
"if (not length (token))\n"
"signal (\'10120\', \'Authentication token required upon get_registeredInfo call\');\n"
"own := coalesce ((select S_VARS from WS.WS.SESSION where S_OPAQUE = token), NULL);\n"
"if (own is not null)\n"
"signal (\'10110\', \'The passed authentication token has been expired\');\n"
"\n"
"http (sprintf (\'<registeredInfo generic=\"1.0\" operator=\"%s\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"\n"
"declare fnd integer;\n"
"fnd := 0;\n"
"\n"
"for select BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from UDDI..BUSINESS_ENTITY where BE_OWNER = own do\n"
"{\n"
"if (not fnd)\n"
"{\n"
"http (\'<businessInfos>\', ses);\n"
"fnd := 1;\n"
"}\n"
"http (sprintf (\'<businessInfo businessKey=\"%s\">\', BE_BUSINESS_KEY), ses);\n"
"http_value (BE_NAME, \'name\', ses);\n"
"DESCRIPTIONS (BE_BUSINESS_KEY, \'businessEntity\', ses);\n"
"SERVICE_INFOS (BE_BUSINESS_KEY, \'businessEntity\', ses);\n"
"http (\'</businessInfo>\', ses);\n"
"}\n"
"\n"
"if (fnd)\n"
"http (\'</businessInfos>\', ses);\n"
"else\n"
"http (\'<businessInfos/>\', ses);\n"
"\n"
"fnd := 0;\n"
"for select TM_TMODEL_KEY, TM_NAME from\n"
"TMODEL where TM_OWNER = own do\n"
"{\n"
"if (not fnd)\n"
"{\n"
"http (\'<tModelInfos>\', ses);\n"
"fnd := 1;\n"
"}\n"
"http (sprintf (\'<tModelInfo tModelKey=\"%s\">\', TM_TMODEL_KEY), ses);\n"
"http_value (TM_NAME, \'name\', ses);\n"
"http (\'</tModelInfo>\', ses);\n"
"}\n"
"if (fnd)\n"
"http (\'</tModelInfos>\', ses);\n"
"else\n"
"http (\'<tModelInfos/>\', ses);\n"
"\n"
"http (\'</registeredInfo>\', ses);\n"
"return (string_output_string(ses));\n"
"}\n"
"--src uddi.sql:1589\n"
;

static const char *proc35 = 
"#line 1656 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"VERIFY_AUTH_INFO (in token varchar)\n"
"{\n"
"\n"
"return 1;\n"
"declare own integer;\n"
"if (not length (token))\n"
"signal (\'10120\', \'Authentication token required in the call\');\n"
"own := coalesce ((select S_VARS from WS.WS.SESSION where S_OPAQUE = token), NULL);\n"
"if (own is not null)\n"
"signal (\'10110\', \'The passed authentication token has been expired\');\n"
"return own;\n"
"}\n"
"--src uddi.sql:1654\n"
;

static const char *proc36 = 
"#line 1673 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_BUSINESSDETAILEXT (in uddi_req any)\n"
"{\n"
"return get_businessDetail (uddi_req);\n"
"}\n"
"--src uddi.sql:1671\n"
;

static const char *proc37 = 
"#line 1680 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_BUSINESSDETAIL (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr any;\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"bk_arr := xpath_eval (\'/get_businessDetail/businessKey\', ent, 0);\n"
"\n"
"if (not isarray(bk_arr))\n"
"bk_arr := vector ();\n"
"\n"
"BUSINESS_DETAIL (bk_arr, ses);\n"
"\n"
"ses :=  string_output_string (ses);\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:1678\n"
;

static const char *proc38 = 
"#line 1698 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"BUSINESS_DETAIL (in bk_arr any, inout ses any)\n"
"{\n"
"declare ix, len, fnd integer;\n"
"declare bk varchar;\n"
"ix := 0; len := length (bk_arr);\n"
"\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"\n"
"if (bk is not null)\n"
"bk := cast (bk as varchar);\n"
"else\n"
"signal (\'10500\', \'The businessKey passed is not a string value\');\n"
"\n"
"fnd := 0;\n"
"for select BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME from BUSINESS_ENTITY where BE_BUSINESS_KEY = bk do\n"
"{\n"
"if (ix = 1)\n"
"http (sprintf (\'<businessDetail generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"\n"
"http (sprintf (\'<businessEntity businessKey=\"%s\" operator=\"%s\" authorizedName=\"%s\">\', bk, BE_OPERATOR, BE_AUTHORIZED_NAME), ses);\n"
"http_value (BE_NAME, \'name\', ses);\n"
"DISCOVERY_URLS (bk, \'businessEntity\', ses);\n"
"DESCRIPTIONS (bk, \'businessEntity\', ses);\n"
"CONTACTS (bk, \'businessEntity\', ses);\n"
"BUSINESS_SERVICES (bk, \'businessEntity\', ses);\n"
"IDENTIFIER_BAG (bk, \'businessEntity\', ses);\n"
"CATEGORY_BAG (bk,\'businessEntity\',ses);\n"
"\n"
"http (\'</businessEntity>\', ses);\n"
"fnd := 1;\n"
"}\n"
"if (not fnd)\n"
"signal (\'10210\', sprintf (\'The passed businessKey (%s) value do match any record\', bk));\n"
"}\n"
"if (ix)\n"
"http (\'</businessDetail>\', ses);\n"
"}\n"
"--src uddi.sql:1696\n"
;

static const char *proc39 = 
"#line 1742 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_BINDINGDETAIL (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr any;\n"
"declare bk varchar;\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"bk_arr := xpath_eval (\'/get_bindingDetail/bindingKey\', ent, 0);\n"
"if (not isarray(bk_arr))\n"
"bk_arr := vector ();\n"
"\n"
"BINDING_DETAIL (bk_arr, ses);\n"
"\n"
"ses :=  string_output_string (ses);\n"
"\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:1740\n"
;

static const char *proc40 = 
"#line 1762 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"BINDING_DETAIL (in bk_arr any, inout ses any)\n"
"{\n"
"declare ix, len, fnd integer;\n"
"declare bk varchar;\n"
"ix := 0; len := length (bk_arr);\n"
"\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"if (bk is not null)\n"
"bk := cast (bk as varchar);\n"
"else\n"
"signal (\'10500\', \'The bindingKey passed is not a string value\');\n"
"\n"
"fnd := 0;\n"
"for select BT_SERVICE_KEY, BT_ACCESS_POINT, BT_HOSTING_REDIRECTOR, BT_URL_TYPE, BT_BINDING_KEY\n"
"from BINDING_TEMPLATE where BT_BINDING_KEY = bk do\n"
"{\n"
"if (ix = 1)\n"
"http (sprintf (\'<bindingDetail generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"http (sprintf (\'<bindingTemplate bindingKey=\"%s\" serviceKey=\"%s\">\', BT_BINDING_KEY, BT_SERVICE_KEY), ses);\n"
"DESCRIPTIONS (BT_BINDING_KEY, \'bindingTemplate\', ses);\n"
"\n"
"if (BT_ACCESS_POINT is not null)\n"
"{\n"
"\n"
"http (sprintf (\'<accessPoint URLType=\"%s\">\', BT_URL_TYPE), ses);\n"
"http_value (BT_ACCESS_POINT, NULL , ses);\n"
"http (\'</accessPoint>\', ses);\n"
"}\n"
"else\n"
"http (sprintf (\'<hostingRedirector bindingKey=\"%s\"/>\', BT_BINDING_KEY), ses);\n"
"\n"
"TMODEL_INSTANCE_DETAILS (BT_BINDING_KEY, \'bindingTemplate\', ses);\n"
"\n"
"http (\'</bindingTemplate>\', ses);\n"
"fnd := 1;\n"
"}\n"
"if (not fnd)\n"
"signal (\'10210\', sprintf (\'The passed bindingKey (%s) value do match any record\', bk));\n"
"}\n"
"if (ix)\n"
"http (\'</bindingDetail>\', ses);\n"
"}\n"
"--src uddi.sql:1760\n"
;

static const char *proc41 = 
"#line 1811 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_TMODELDETAIL (in uddi_req any)\n"
"{\n"
"\n"
"declare ret, ent, ses, bk_arr any;\n"
"declare bk varchar;\n"
"declare ix, len, fnd integer;\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"bk_arr := xpath_eval (\'/get_tModelDetail/tModelKey\', ent, 0);\n"
"if (not isarray(bk_arr))\n"
"bk_arr := vector ();\n"
"\n"
"TMODEL_DETAIL (bk_arr, ses);\n"
"ses :=  string_output_string (ses);\n"
"return (ses);\n"
"\n"
"}\n"
"--src uddi.sql:1809\n"
;

static const char *proc42 = 
"#line 1831 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"TMODEL_DETAIL (in bk_arr any, inout ses any)\n"
"{\n"
"declare ix, len, fnd integer;\n"
"declare bk varchar;\n"
"ix := 0; len := length (bk_arr);\n"
"\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"if (bk is not null)\n"
"bk := cast (bk as varchar);\n"
"else\n"
"signal (\'10500\', \'The tModelKey passed is not a string value\');\n"
"\n"
"fnd := 0;\n"
"for select TM_TMODEL_KEY, TM_AUTHORIZED_NAME, TM_OPERATOR, TM_NAME\n"
"from TMODEL where TM_TMODEL_KEY = bk do\n"
"{\n"
"if (ix = 1)\n"
"http (sprintf (\'<tModelDetail generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"\n"
"http (sprintf (\'<tModel tModelKey=\"%s\" operator=\"%s\" authorizedName=\"%s\">\', TM_TMODEL_KEY, TM_OPERATOR, TM_AUTHORIZED_NAME), ses);\n"
"http_value (TM_NAME, \'name\', ses);\n"
"\n"
"OVERVIEW_DOC (TM_TMODEL_KEY, \'tModel\', ses);\n"
"IDENTIFIER_BAG (TM_TMODEL_KEY, \'tModel\', ses);\n"
"CATEGORY_BAG (TM_TMODEL_KEY, \'tModel\', ses);\n"
"http (\'</tModel>\', ses);\n"
"fnd := 1;\n"
"}\n"
"if (not fnd)\n"
"signal (\'10210\', sprintf (\'The passed tModelKey (%s) value do match any record\', bk));\n"
"}\n"
"if (ix)\n"
"http (\'</tModelDetail>\', ses);\n"
"}\n"
"--src uddi.sql:1829\n"
;

static const char *proc43 = 
"#line 1872 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET_SERVICEDETAIL (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr any;\n"
"declare bk varchar;\n"
"declare ix, len, fnd integer;\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"bk_arr := xpath_eval (\'/get_serviceDetail/serviceKey\', ent, 0);\n"
"if (not isarray(bk_arr))\n"
"bk_arr := vector ();\n"
"\n"
"SERVICE_DETAIL (bk_arr, ses);\n"
"ses :=  string_output_string (ses);\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:1870\n"
;

static const char *proc44 = 
"#line 1890 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SERVICE_DETAIL (in bk_arr any, inout ses any)\n"
"{\n"
"declare ix, len, fnd integer;\n"
"declare bk varchar;\n"
"ix := 0; len := length (bk_arr);\n"
"\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"if (bk is not null)\n"
"bk := cast (bk as varchar);\n"
"else\n"
"signal (\'10500\', \'The serviceKey passed is not a string value\');\n"
"\n"
"fnd := 0;\n"
"for select BS_BUSINESS_KEY, BS_NAME, BS_SERVICE_KEY\n"
"from BUSINESS_SERVICE where BS_SERVICE_KEY = bk do\n"
"{\n"
"if (ix = 1)\n"
"http (sprintf (\'<serviceDetail generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"http (sprintf (\'<businessService serviceKey=\"%s\" businessKey=\"%s\">\', BS_SERVICE_KEY, BS_BUSINESS_KEY), ses);\n"
"DESCRIPTIONS (BS_SERVICE_KEY,\'businessService\',ses);\n"
"http_value (BS_NAME, \'name\', ses);\n"
"BINDING_TEMPLATES (BS_SERVICE_KEY,\'businessService\',ses);\n"
"CATEGORY_BAG (BS_SERVICE_KEY,\'businessService\',ses);\n"
"http (\'</businessService>\', ses);\n"
"fnd := 1;\n"
"}\n"
"if (not fnd)\n"
"signal (\'10210\', sprintf (\'The passed serviceKey (%s) value do match any record\', bk));\n"
"}\n"
"if (ix)\n"
"http (\'</serviceDetail>\', ses);\n"
"}\n"
"--src uddi.sql:1888\n"
;

static const char *proc45 = 
"#line 1930 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"TMODEL_INSTANCE_DETAILS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select ID_KEY, ID_BINDING_KEY, ID_TMODEL_KEY, ID_PARMS from INSTANCE_DETAIL\n"
"where ID_BINDING_KEY = id do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<tModelInstanceDetails>\', ses);\n"
"http ( sprintf (\'<tModelInstanceInfo tModelKey=\"%s\">\', ID_TMODEL_KEY), ses);\n"
"DESCRIPTIONS (ID_KEY, \'tModelInstanceInfo\', ses);\n"
"http (\'<instanceDetails>\', ses);\n"
"DESCRIPTIONS (ID_KEY, \'instanceDetails\', ses);\n"
"OVERVIEW_DOC (ID_KEY, \'tModelInstanceInfo\', ses);\n"
"if (ID_PARMS <> \'\')\n"
"http (sprintf (\'<instanceParms>%s</instanceParms>\', ID_PARMS), ses);\n"
"http (\'</instanceDetails>\', ses);\n"
"http (\'</tModelInstanceInfo>\', ses);\n"
"}\n"
"if (ix)\n"
"http (\'</tModelInstanceDetails>\', ses);\n"
"else\n"
"http (\'<tModelInstanceDetails/>\', ses);\n"
"}\n"
"--src uddi.sql:1928\n"
;

static const char *proc46 = 
"#line 1959 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"OVERVIEW_DOC (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"\n"
"for select OV_KEY, OV_URL from OVERVIEW_DOC\n"
"where OV_PARENT_ID  = id and OV_PARENT_TYPE = elm do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<overviewDoc>\', ses);\n"
"DESCRIPTIONS (OV_KEY, \'overviewDoc\', ses);\n"
"http (sprintf (\'<overviewURL>%s</overviewURL>\', OV_URL), ses);\n"
"}\n"
"\n"
"if (ix)\n"
"http (\'</overviewDoc>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:1957\n"
;

static const char *proc47 = 
"#line 1983 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DISCOVERY_URLS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select DU_URL, DU_USE_TYPE from DISCOVERY_URL\n"
"where DU_PARENT_ID = id and DU_PARENT_TYPE = elm do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<discoveryURLs>\', ses);\n"
"http (sprintf (\'<discoveryURL useType=\"%s\">%s</discoveryURL>\', DU_USE_TYPE, DU_URL), ses);\n"
"}\n"
"if (ix)\n"
"http (\'</discoveryURLs>\', ses);\n"
"}\n"
"--src uddi.sql:1981\n"
;

static const char *proc48 = 
"#line 2002 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"BUSINESS_SERVICES (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select BS_SERVICE_KEY, BS_NAME from BUSINESS_SERVICE where BS_BUSINESS_KEY = id do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<businessServices>\', ses);\n"
"http (sprintf (\'<businessService serviceKey=\"%s\" businessKey=\"%s\">\', BS_SERVICE_KEY, id), ses);\n"
"DESCRIPTIONS (BS_SERVICE_KEY,\'businessService\',ses);\n"
"http_value (BS_NAME, \'name\', ses);\n"
"BINDING_TEMPLATES (BS_SERVICE_KEY,\'businessService\',ses);\n"
"CATEGORY_BAG (BS_SERVICE_KEY,\'businessService\',ses);\n"
"http (\'</businessService>\', ses);\n"
"}\n"
"if (ix)\n"
"http (\'</businessServices>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:2000\n"
;

static const char *proc49 = 
"#line 2026 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"BINDING_TEMPLATES (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"\n"
"for select BT_BINDING_KEY, BT_ACCESS_POINT, BT_HOSTING_REDIRECTOR, BT_URL_TYPE from BINDING_TEMPLATE\n"
"where BT_SERVICE_KEY = id do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<bindingTemplates>\', ses);\n"
"http (sprintf (\'<bindingTemplate bindingKey=\"%s\" serviceKey=\"%s\">\', BT_BINDING_KEY, id), ses);\n"
"DESCRIPTIONS (BT_BINDING_KEY, \'bindingTemplate\', ses);\n"
"\n"
"if (BT_ACCESS_POINT is not null)\n"
"{\n"
"\n"
"http (sprintf (\'<accessPoint URLType=\"%s\">\', BT_URL_TYPE), ses);\n"
"http_value (BT_ACCESS_POINT, NULL, ses);\n"
"http (\'</accessPoint>\', ses);\n"
"}\n"
"else\n"
"http (sprintf (\'<hostingRedirector bindingKey=\"%s\"/>\', BT_BINDING_KEY), ses);\n"
"\n"
"TMODEL_INSTANCE_DETAILS (BT_BINDING_KEY, \'bindingTemplate\', ses);\n"
"\n"
"http (\'</bindingTemplate>\', ses);\n"
"}\n"
"if (ix)\n"
"http (\'</bindingTemplates>\', ses);\n"
"else\n"
"http (\'<bindingTemplates/>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:2024\n"
;

static const char *proc50 = 
"#line 2064 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"CATEGORY_BAG (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select CB_TMODEL_KEY_ID, CB_KEY_NAME, CB_KEY_VALUE from CATEGORY_BAG\n"
"where CB_PARENT_ID = id and CB_PARENT_TYPE = elm do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<categoryBag>\', ses);\n"
"http (sprintf (\'<keyedReference tModelKey=\"%s\" keyName=\"%s\" keyValue=\"%s\"/>\',CB_TMODEL_KEY_ID,CB_KEY_NAME,CB_KEY_VALUE), ses);\n"
"}\n"
"if (ix)\n"
"http (\'</categoryBag>\', ses);\n"
"}\n"
"--src uddi.sql:2062\n"
;

static const char *proc51 = 
"#line 2083 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"IDENTIFIER_BAG (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select IB_TMODEL_KEY_ID, IB_KEY_NAME, IB_KEY_VALUE from IDENTIFIER_BAG\n"
"where IB_PARENT_ID = id and IB_PARENT_TYPE = elm do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<identifierBag>\', ses);\n"
"if (IB_TMODEL_KEY_ID = \'\')\n"
"http (sprintf (\'<keyedReference keyName=\"%s\" keyValue=\"%s\"/>\', IB_KEY_NAME, IB_KEY_VALUE), ses);\n"
"else\n"
"http (sprintf (\'<keyedReference tModelKey=\"%s\" keyName=\"%s\" keyValue=\"%s\"/>\',IB_TMODEL_KEY_ID,IB_KEY_NAME,IB_KEY_VALUE), ses);\n"
"}\n"
"if (ix)\n"
"http (\'</identifierBag>\', ses);\n"
"}\n"
"--src uddi.sql:2081\n"
;

static const char *proc52 = 
"#line 2106 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"DESCRIPTIONS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"for select UD_DESC, UD_LANG from DESCRIPTION where UD_PARENT_ID = id and UD_TYPE = elm do\n"
"{\n"
"http_value (UD_DESC, \'description\',  ses);\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"}\n"
"--src uddi.sql:2104\n"
;

static const char *proc53 = 
"#line 2122 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"CONTACTS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"\n"
"for select CO_CONTACT_KEY, CO_USE_TYPE, CO_PERSONAL_NAME from CONTACTS where CO_BUSINESS_ID = id do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<contacts>\', ses);\n"
"if (CO_USE_TYPE is not null)\n"
"http (sprintf (\'<contact useType=\"%s\">\', CO_USE_TYPE), ses);\n"
"else\n"
"http (sprintf (\'<contact>\'), ses);\n"
"DESCRIPTIONS (CO_CONTACT_KEY, \'contacts\', ses);\n"
"PHONE (CO_CONTACT_KEY, \'contacts\', ses);\n"
"EMAIL (CO_CONTACT_KEY, \'contacts\', ses);\n"
"ADDRESS (CO_CONTACT_KEY, \'contacts\', ses);\n"
"http_value (CO_PERSONAL_NAME, \'personName\', ses);\n"
"http (\'</contact>\', ses);\n"
"}\n"
"\n"
"if (ix)\n"
"http (\'</contacts>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:2120\n"
;

static const char *proc54 = 
"#line 2152 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"PHONE (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"for select PH_PHONE, PH_USE_TYPE from PHONE where PH_CONTACT_KEY = id do\n"
"{\n"
"http (sprintf (\'<phone useType=\"%s\">%s</phone>\', PH_USE_TYPE, PH_PHONE), ses);\n"
"}\n"
"}\n"
"--src uddi.sql:2150\n"
;

static const char *proc55 = 
"#line 2163 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"EMAIL (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"for select EM_ADDR, EM_USE_TYPE from EMAIL where EM_CONTACT_KEY = id do\n"
"{\n"
"http (sprintf (\'<email useType=\"%s\">%s</email>\', EM_USE_TYPE, EM_ADDR), ses);\n"
"}\n"
"}\n"
"--src uddi.sql:2161\n"
;

static const char *proc56 = 
"#line 2175 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"ADDRESS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select distinct AL_USE_TYPE from ADDRESS_LINE\n"
"where AL_PARENT_ID = id and AL_PARENT_TYPE = elm do\n"
"{\n"
"ADDRESS_2 (id, elm, ses, AL_USE_TYPE);\n"
"}\n"
"}\n"
"--src uddi.sql:2173\n"
;

static const char *proc57 = 
"#line 2189 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"ADDRESS_2 (in id varchar, in elm varchar, inout ses any, in _use varchar)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select AL_USE_TYPE, AL_SORT_CODE, AL_LINE from ADDRESS_LINE\n"
"where AL_PARENT_ID = id and AL_PARENT_TYPE = elm and (AL_USE_TYPE = _use or AL_USE_TYPE is NULL) do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"{\n"
"http (\'<address\', ses);\n"
"if (AL_USE_TYPE is not null)\n"
"http (sprintf (\' useType=\"%s\"\', AL_USE_TYPE), ses);\n"
"if (AL_SORT_CODE is not null)\n"
"http (sprintf (\' sortCode=\"%s\"\', AL_SORT_CODE), ses);\n"
"http (\'>\', ses);\n"
"}\n"
"http_value (AL_LINE, \'addressLine\' , ses);\n"
"}\n"
"\n"
"if (ix)\n"
"http (\'</address>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:2187\n"
;

static const char *proc58 = 
"#line 2217 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"QUAL_MATCH (in s1 varchar, in s2 varchar, in ex integer, in ca integer)\n"
"{\n"
"if (length (s2) > 128)\n"
"signal (\'10020\', sprintf (\'The search name is too long (%d)\', length (s2)));\n"
"if (ca)\n"
"{\n"
"s1 := upper (cast (s1 as varchar));\n"
"s2 := upper (cast (s2 as varchar));\n"
"}\n"
"\n"
"if (ex and s1 = s2)\n"
"return 1;\n"
"else if (not ex and s1 like concat (s2, \'%\'))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src uddi.sql:2215\n"
;

static const char *proc59 = 
"#line 2237 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_FIND_BUSINESS (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr, names, cat, idn, url, tmd any;\n"
"declare bk, saved_bs varchar;\n"
"declare ix, len, fnd, st integer;\n"
"declare max_rows integer;\n"
"declare ordering varchar;\n"
"declare exact, nocase, sn_asc, sn_desc, sd_asc, sd_desc integer;\n"
"declare criteria integer;\n"
"declare dta, elm any;\n"
"declare qry varchar;\n"
"declare rx, rlen integer;\n"
"declare sorts varchar;\n"
"\n"
"\n"
"\n"
"\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"\n"
"st := 1; saved_bs := \'\'; criteria := 0;\n"
"\n"
"\n"
"\n"
"names := xpath_eval (\'/find_business/name\', ent, 0);\n"
"cat := xpath_eval (\'/find_business/categoryBag/keyedReference\', ent, 0);\n"
"idn := xpath_eval (\'/find_business/identifierBag/keyedReference\', ent, 0);\n"
"tmd := xpath_eval (\'/find_business/tModelBag/tModelKey\', ent, 0);\n"
"url := xpath_eval (\'/find_business/discoveryURLs/discoveryURL\', ent, 0);\n"
"max_rows := coalesce (atoi (cast (xpath_eval (\'/find_business/@maxRows\', ent, 1) as varchar)), 100);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ordering := xpath_eval (\'/find_business/findQualifiers/findQualifier\', ent, 0);\n"
"exact := 0; nocase := 1; sn_asc := 0; sn_desc := 0; sd_asc := 0; sd_desc := 0;\n"
"if (isarray (ordering))\n"
"{\n"
"declare sq varchar;\n"
"len := length (ordering); ix := 0;\n"
"while (ix < len)\n"
"{\n"
"sq := cast (aref (ordering, ix) as varchar);\n"
"if (sq = \'exactNameMatch\')\n"
"exact := 1;\n"
"else if (sq = \'caseSensitiveMatch\')\n"
"nocase := 0;\n"
"else if (sq = \'sortByNameAsc\')\n"
"sn_asc := 1;\n"
"else if (sq = \'sortByNameDesc\')\n"
"sn_desc := 1;\n"
"else if (sq = \'sortByDateAsc\')\n"
"sd_asc := 1;\n"
"else if (sq = \'sortByDateDesc\')\n"
"sd_desc := 1;\n"
"ix := ix + 1;\n"
"}\n"
"}\n"
"\n"
"if ((sn_asc and sn_desc) or (sd_asc and sd_desc))\n"
"signal (\'10030\', \'Mutual exclusive sort options supplied\');\n"
"\n"
"sorts := sprintf (\' %s %s \',\n"
"case sn_asc + (sn_desc * 2)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY BE_NAME\'\n"
"else \'ORDER BY BE_NAME DESC\' end,\n"
"case sd_asc + (sd_desc * 2) + ((sn_asc + sn_desc) * 3)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY BE_CHANGED\'\n"
"when 2 then \'ORDER BY BE_CHANGED DESC\'\n"
"when 3 then \'\'\n"
"when 4 then  \', BE_CHANGED\'\n"
"else \', BE_CHANGED DESC\'\n"
"end);\n"
"\n"
"if (length(names))\n"
"{\n"
"\n"
"bk_arr := names;\n"
"st := 1;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (length(idn))\n"
"{\n"
"\n"
"bk_arr := idn;\n"
"st := 2;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (length(cat))\n"
"{\n"
"\n"
"bk_arr := cat;\n"
"st := 3;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (length(tmd))\n"
"{\n"
"\n"
"bk_arr := tmd;\n"
"st := 4;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (length(url))\n"
"{\n"
"\n"
"bk_arr := url;\n"
"st := 5;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (criteria <> 1)\n"
"signal (\'10030\', \'Too many options for find_business request\');\n"
"\n"
"if (not isarray(bk_arr))\n"
"signal (\'10050\', \'The search criteria not passed\');\n"
"\n"
"ix := 0; len := length (bk_arr); fnd := 0;\n"
"http (sprintf (\'<businessList generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"if (bk is null)\n"
"signal (\'10500\', \'Passed an un-recognizable value\');\n"
"\n"
"if (st = 1)\n"
"{\n"
"bk := cast (bk as varchar);\n"
"qry := sprintf (\'select BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from UDDI..BUSINESS_ENTITY where 1 = UDDI..QUAL_MATCH (BE_NAME, ?, ?, ?) %s \', sorts);\n"
"\n"
"exec (qry, null, null, vector (bk, exact, nocase), 100, null, dta);\n"
"}\n"
"else if (st = 2)\n"
"{\n"
"\n"
"declare ikey, ival, tkid varchar;\n"
"ikey := upper (cast (xpath_eval (\'@keyName\',  bk, 1) as varchar));\n"
"ival := upper (cast (xpath_eval (\'@keyValue\', bk, 1) as varchar));\n"
"tkid := upper (cast (xpath_eval (\'@tModelKey\', bk, 1) as varchar));\n"
"qry := sprintf (\'select distinct  BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from UDDI..IDENTIFIER_BAG, UDDI..BUSINESS_ENTITY\n"
"where IB_KEY_NAME = ? and IB_KEY_VALUE = ? and IB_TMODEL_KEY_ID = ?\n"
"and IB_PARENT_TYPE = \\\'businessEntity\\\' and IB_PARENT_ID = BE_BUSINESS_KEY %s\', sorts);\n"
"exec (qry, null, null, vector (ikey, ival, tkid), 100, null, dta);\n"
"}\n"
"else if (st = 3)\n"
"{\n"
"\n"
"\n"
"declare ckey, cval varchar;\n"
"ckey := cast (xpath_eval (\'@keyName\',  bk, 1) as varchar);\n"
"cval := cast (xpath_eval (\'@keyValue\', bk, 1) as varchar);\n"
"\n"
"qry := sprintf (\'select distinct BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from UDDI..CATEGORY_BAG, UDDI..BUSINESS_ENTITY\n"
"where CB_KEY_NAME = ? and CB_KEY_VALUE = ?\n"
"and CB_PARENT_TYPE = \\\'businessEntity\\\' and CB_PARENT_ID = BE_BUSINESS_KEY %s\', sorts);\n"
"exec (qry, null, null, vector (ckey, cval), 100, null, dta);\n"
"}\n"
"else if (st = 4)\n"
"{\n"
"\n"
"bk := cast (bk as varchar);\n"
"if (not exists (select 1 from TMODEL where TM_TMODEL_KEY = bk))\n"
"signal (\'10210\', \'The specified binding key cannot be found in any tModel\');\n"
"qry := sprintf (\'select distinct  BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from  UDDI..INSTANCE_DETAIL, UDDI..BINDING_TEMPLATE, UDDI..BUSINESS_SERVICE, UDDI..BUSINESS_ENTITY\n"
"where ID_TMODEL_KEY = ?\n"
"and ID_BINDING_KEY = BT_BINDING_KEY\n"
"and BT_SERVICE_KEY = BS_SERVICE_KEY\n"
"and BS_BUSINESS_KEY = BE_BUSINESS_KEY %s \', sorts);\n"
"exec (qry, null, null, vector (bk), 100, null, dta);\n"
"}\n"
"else if (st = 5)\n"
"{\n"
"\n"
"bk := cast (bk as varchar);\n"
"qry := sprintf (\'select distinct BE_NAME, BE_OPERATOR, BE_AUTHORIZED_NAME, BE_BUSINESS_KEY\n"
"from  UDDI..DISCOVERY_URL, UDDI..BUSINESS_ENTITY\n"
"where DU_URL = ? and DU_PARENT_TYPE = \\\'businessEntity\\\' and DU_PARENT_ID = BE_BUSINESS_KEY %s\',sorts);\n"
"exec (qry, null, null, vector (bk), 100, null, dta);\n"
"}\n"
"else\n"
"signal (\'10050\', \'The search condition is not supported\');\n"
"\n"
"\n"
"rx := 0; rlen := length (dta);\n"
"while (rx < rlen)\n"
"{\n"
"elm := aref (dta, rx);\n"
"if (not fnd)\n"
"{\n"
"saved_bs := aref (elm ,3);\n"
"\n"
"http (\'<businessInfos>\', ses);\n"
"fnd := 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"http (sprintf (\'<businessInfo businessKey=\"%s\">\', aref (elm ,3)), ses);\n"
"http_value (aref (elm, 0), \'name\', ses);\n"
"DESCRIPTIONS (aref (elm, 3), \'businessEntity\', ses);\n"
"SERVICE_INFOS (aref (elm, 3), \'businessEntity\', ses);\n"
"\n"
"http (\'</businessInfo>\', ses);\n"
"\n"
"rx := rx + 1;\n"
"}\n"
"\n"
"\n"
"}\n"
"not_match:\n"
"if (fnd)\n"
"http (\'</businessInfos>\', ses);\n"
"else\n"
"http (\'<businessInfos/>\', ses);\n"
"http (\'</businessList>\', ses);\n"
"ses :=  string_output_string (ses);\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:2235\n"
;

static const char *proc60 = 
"#line 2477 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"SERVICE_INFOS (in id varchar, in elm varchar, inout ses any)\n"
"{\n"
"declare ix integer;\n"
"ix := 0;\n"
"for select BS_SERVICE_KEY, BS_NAME from BUSINESS_SERVICE where BS_BUSINESS_KEY = id do\n"
"{\n"
"ix := ix + 1;\n"
"if (ix = 1)\n"
"http (\'<serviceInfos>\', ses);\n"
"http (sprintf (\'<serviceInfo serviceKey=\"%s\" businessKey=\"%s\">\', BS_SERVICE_KEY, id), ses);\n"
"http_value (BS_NAME, \'name\', ses);\n"
"http (\'</serviceInfo>\', ses);\n"
"}\n"
"if (ix)\n"
"http (\'</serviceInfos>\', ses);\n"
"else\n"
"http (\'<serviceInfos/>\', ses);\n"
"\n"
"}\n"
"--src uddi.sql:2475\n"
;

static const char *proc61 = 
"#line 2501 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_FIND_BINDING (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr any;\n"
"declare bk, saved_bs, serv_key varchar;\n"
"declare ix, len, fnd, st integer;\n"
"declare max_rows integer;\n"
"declare ordering varchar;\n"
"declare exact, mcase, sn_asc, sn_desc, sd_asc, sd_desc integer;\n"
"declare criteria integer;\n"
"declare dta, elm any;\n"
"declare qry varchar;\n"
"declare rx, rlen integer;\n"
"\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"\n"
"st := 1; saved_bs := \'\';\n"
"\n"
"\n"
"\n"
"bk_arr := xpath_eval (\'/find_binding/tModelBag/tModelKey\', ent, 0);\n"
"\n"
"serv_key := cast (xpath_eval (\'/find_binding/@serviceKey\', ent, 1) as varchar);\n"
"\n"
"max_rows := coalesce (atoi (cast (xpath_eval (\'/find_binding/@maxRows\', ent, 1) as varchar)), 100);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ordering := xpath_eval (\'/find_binding/findQualifiers/findQualifier\', ent, 0);\n"
"exact := 0; mcase := 0; sn_asc := 0; sn_desc := 0; sd_asc := 0; sd_desc := 0;\n"
"if (isarray (ordering))\n"
"{\n"
"declare sq varchar;\n"
"len := length (ordering); ix := 0;\n"
"while (ix < len)\n"
"{\n"
"sq := cast (aref (ordering, ix) as varchar);\n"
"if (sq = \'exactNameMatch\')\n"
"exact := 1;\n"
"else if (sq = \'caseSensitiveMatch\')\n"
"mcase := 1;\n"
"else if (sq = \'sortByNameAsc\')\n"
"sn_asc := 1;\n"
"else if (sq = \'sortByNameDesc\')\n"
"sn_desc := 1;\n"
"else if (sq = \'sortByDateAsc\')\n"
"sd_asc := 1;\n"
"else if (sq = \'sortByDateDesc\')\n"
"sd_desc := 1;\n"
"ix := ix + 1;\n"
"}\n"
"}\n"
"\n"
"if (sd_asc and sd_desc)\n"
"signal (\'10030\', \'Mutual exclusive sort options supplied\');\n"
"if (exact or mcase or sn_asc or sn_desc)\n"
"signal (\'10050\', \'Search options caseSensitiveMatch, exactNameMatch , sortByNameAsc and  sortByNameDesc is not supported in this request\');\n"
"\n"
"if (not isarray(bk_arr))\n"
"signal (\'10050\', \'The search criteria not passed\');\n"
"\n"
"ix := 0; len := length (bk_arr); fnd := 0;\n"
"\n"
"http (sprintf (\'<bindingDetail generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"while (ix < len)\n"
"{\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"bk := cast (bk as varchar);\n"
"\n"
"\n"
"if (not exists (select 1 from BUSINESS_SERVICE where BS_SERVICE_KEY = serv_key))\n"
"signal (\'10210\', \'The specified service key cannot be found in any service\');\n"
"if (not exists (select 1 from TMODEL where TM_TMODEL_KEY = bk))\n"
"signal (\'10210\', \'The specified binding key cannot be found in any tModel\');\n"
"\n"
"qry := sprintf (\n"
"\'select distinct BT_SERVICE_KEY, BT_ACCESS_POINT, BT_HOSTING_REDIRECTOR, BT_URL_TYPE, BT_BINDING_KEY\n"
"from UDDI..INSTANCE_DETAIL, UDDI..BINDING_TEMPLATE where\n"
"ID_TMODEL_KEY = ?\n"
"and ID_BINDING_KEY = BT_BINDING_KEY\n"
"and BT_SERVICE_KEY = ? %s\',\n"
"case sd_asc + (sd_desc * 2)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY BT_CHANGED\'\n"
"else \'ORDER BY BT_CHANGED DESC\' end\n"
");\n"
"exec (qry, null, null, vector (bk, serv_key), 100, null, dta);\n"
"\n"
"rx := 0; rlen := length (dta);\n"
"while (rx < rlen)\n"
"{\n"
"elm := aref (dta, rx);\n"
"fnd := 1;\n"
"http (sprintf (\'<bindingTemplate bindingKey=\"%s\" serviceKey=\"%s\">\',\n"
"aref (elm, 4), aref (elm, 0)), ses);\n"
"DESCRIPTIONS (aref (elm, 4), \'bindingTemplate\', ses);\n"
"\n"
"if (aref (elm, 1) is not null)\n"
"http (sprintf (\'<accessPoint URLType=\"%s\">%s</accessPoint>\', aref (elm, 3), aref (elm, 1)), ses);\n"
"else\n"
"http (sprintf (\'<hostingRedirector bindingKey=\"%s\"/>\', aref (elm, 4)), ses);\n"
"\n"
"TMODEL_INSTANCE_DETAILS (aref (elm, 4), \'bindingTemplate\', ses);\n"
"http (\'</bindingTemplate>\', ses);\n"
"rx := rx + 1;\n"
"}\n"
"}\n"
"not_match:\n"
"if (not fnd)\n"
"http (\'<bindingTemplate/>\', ses);\n"
"http (\'</bindingDetail>\', ses);\n"
"ses :=  string_output_string (ses);\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:2499\n"
;

static const char *proc62 = 
"#line 2622 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_FIND_SERVICE (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr, names, cbag, tbag any;\n"
"declare bk, saved_bs, bs_key varchar;\n"
"declare ix, len, fnd, st integer;\n"
"declare max_rows integer;\n"
"declare ordering varchar;\n"
"declare exact, nocase, sn_asc, sn_desc, sd_asc, sd_desc integer;\n"
"declare criteria integer;\n"
"declare dta, elm any;\n"
"declare qry varchar;\n"
"declare rx, rlen integer;\n"
"declare sorts varchar;\n"
"\n"
"\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"\n"
"st := 1; saved_bs := \'\';  criteria := 0;\n"
"\n"
"\n"
"\n"
"names := xpath_eval (\'/find_service/name\', ent, 0);\n"
"cbag  := xpath_eval (\'/find_service/categoryBag/keyedReference\', ent, 0);\n"
"tbag  := xpath_eval (\'/find_service/tModelBag/tModelKey\', ent, 0);\n"
"bs_key := cast (xpath_eval (\'/find_service/@businessKey\', ent, 1) as varchar);\n"
"\n"
"if (not exists (select 1 from BUSINESS_ENTITY where BE_BUSINESS_KEY  = bs_key))\n"
"signal (\'10210\', \'The specified businessKey cannot be found in any businessEntity\');\n"
"\n"
"max_rows := coalesce (atoi (cast (xpath_eval (\'/find_service/@maxRows\', ent, 1) as varchar)), 100);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ordering := xpath_eval (\'/find_service/findQualifiers/findQualifier\', ent, 0);\n"
"exact := 0; nocase := 1; sn_asc := 0; sn_desc := 0; sd_asc := 0; sd_desc := 0;\n"
"if (isarray (ordering))\n"
"{\n"
"declare sq varchar;\n"
"len := length (ordering); ix := 0;\n"
"while (ix < len)\n"
"{\n"
"sq := cast (aref (ordering, ix) as varchar);\n"
"if (sq = \'exactNameMatch\')\n"
"exact := 1;\n"
"else if (sq = \'caseSensitiveMatch\')\n"
"nocase := 0;\n"
"else if (sq = \'sortByNameAsc\')\n"
"sn_asc := 1;\n"
"else if (sq = \'sortByNameDesc\')\n"
"sn_desc := 1;\n"
"else if (sq = \'sortByDateAsc\')\n"
"sd_asc := 1;\n"
"else if (sq = \'sortByDateDesc\')\n"
"sd_desc := 1;\n"
"ix := ix + 1;\n"
"}\n"
"}\n"
"\n"
"if ((sd_asc and sd_desc) or (sn_desc and sn_asc))\n"
"signal (\'10030\', \'Mutual exclusive sort options supplied\');\n"
"sorts := sprintf (\' %s %s \',\n"
"case sn_asc + (sn_desc * 2)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY BS_NAME\'\n"
"else \'ORDER BY BS_NAME DESC\' end,\n"
"case sd_asc + (sd_desc * 2) + ((sn_asc + sn_desc) * 3)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY BS_CHANGED\'\n"
"when 2 then \'ORDER BY BS_CHANGED DESC\'\n"
"when 3 then \'\'\n"
"when 4 then  \', BS_CHANGED\'\n"
"else \', BS_CHANGED DESC\'\n"
"end);\n"
"\n"
"\n"
"\n"
"if (length (names))\n"
"{\n"
"bk_arr := names;\n"
"st := 1;\n"
"criteria := criteria + 1;\n"
"}\n"
"if (length (cbag))\n"
"{\n"
"bk_arr := cbag;\n"
"st := 2;\n"
"criteria := criteria + 1;\n"
"}\n"
"if (length (tbag))\n"
"{\n"
"bk_arr := tbag;\n"
"st := 3;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (criteria <> 1)\n"
"signal (\'10030\', \'Too many options for find_business request\');\n"
"\n"
"if (not isarray(bk_arr))\n"
"signal (\'10050\', \'The search criteria not passed\');\n"
"\n"
"ix := 0; len := length (bk_arr); fnd := 0;\n"
"\n"
"http (sprintf (\'<serviceList generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"bs_key := cast (bs_key as varchar);\n"
"while (ix < len)\n"
"{\n"
"\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"\n"
"if (bk is null)\n"
"signal (\'10500\', \'The search name condition is not a string\');\n"
"\n"
"if (st = 1)\n"
"{\n"
"bk := cast (bk as varchar);\n"
"\n"
"qry := sprintf (\'select BS_SERVICE_KEY, BS_NAME, BS_BUSINESS_KEY\n"
"from UDDI..BUSINESS_SERVICE\n"
"where 1 = UDDI..QUAL_MATCH (BS_NAME, ?, ?, ?) and BS_BUSINESS_KEY = ? %s\', sorts);\n"
"exec (qry, null, null, vector (bk, exact, nocase, bs_key), 100, null, dta);\n"
"\n"
"}\n"
"else if (st = 2)\n"
"{\n"
"\n"
"declare ckey, cval varchar;\n"
"ckey := cast (xpath_eval (\'@keyName\',  bk, 1) as varchar);\n"
"cval := cast (xpath_eval (\'@keyValue\', bk, 1) as varchar);\n"
"qry := sprintf (\'select distinct BS_SERVICE_KEY, BS_NAME, BS_BUSINESS_KEY\n"
"from UDDI..CATEGORY_BAG, UDDI..BUSINESS_SERVICE\n"
"where CB_KEY_NAME = ? and CB_KEY_VALUE = ? and CB_PARENT_TYPE = \\\'businessService\\\'\n"
"and CB_PARENT_ID = BS_SERVICE_KEY and BS_BUSINESS_KEY = ? %s\', sorts);\n"
"exec (qry, null, null, vector (ckey, cval, bs_key), 100, null, dta);\n"
"\n"
"}\n"
"else if (st = 3)\n"
"{\n"
"\n"
"bk := cast (bk as varchar);\n"
"if (not exists (select 1 from TMODEL where TM_TMODEL_KEY = bk))\n"
"signal (\'10210\', \'The specified binding key cannot be found in any tModel\');\n"
"qry := sprintf (\'select distinct BS_SERVICE_KEY, BS_NAME, BS_BUSINESS_KEY\n"
"from UDDI..INSTANCE_DETAIL, UDDI..BINDING_TEMPLATE, UDDI..BUSINESS_SERVICE\n"
"where ID_TMODEL_KEY = ? and ID_BINDING_KEY = BT_BINDING_KEY\n"
"and BT_SERVICE_KEY = BS_SERVICE_KEY and BS_BUSINESS_KEY = ? %s \', sorts);\n"
"exec (qry, null, null, vector (bk, bs_key), 100, null, dta);\n"
"}\n"
"else\n"
"signal (\'10050\', \'The search condition is not supported\');\n"
"\n"
"rx := 0; rlen := length (dta);\n"
"while (rx < rlen)\n"
"{\n"
"elm := aref (dta, rx);\n"
"if (not fnd)\n"
"{\n"
"\n"
"http (\'<serviceInfos>\', ses);\n"
"fnd := 1;\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"http (sprintf (\'<serviceInfo serviceKey=\"%s\" businessKey=\"%s\">\', aref (elm, 0), aref (elm, 2)),ses);\n"
"http_value (aref (elm, 1), \'name\', ses);\n"
"http (\'</serviceInfo>\', ses);\n"
"\n"
"rx := rx + 1;\n"
"}\n"
"}\n"
"not_match:\n"
"if (fnd)\n"
"http (\'</serviceInfos>\', ses);\n"
"else\n"
"http (\'<serviceInfos/>\', ses);\n"
"http (\'</serviceList>\', ses);\n"
"ses :=  string_output_string (ses);\n"
"\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:2620\n"
;

static const char *proc63 = 
"#line 2818 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_FIND_TMODEL (in uddi_req any)\n"
"{\n"
"declare ret, ent, ses, bk_arr, names, cbag, ibag any;\n"
"declare bk, saved_bs, bs_key varchar;\n"
"declare ix, len, fnd, st integer;\n"
"declare max_rows integer;\n"
"declare ordering, saved_key varchar;\n"
"declare exact, nocase, sn_asc, sn_desc, sd_asc, sd_desc integer;\n"
"declare criteria integer;\n"
"declare dta, elm any;\n"
"declare qry varchar;\n"
"declare rx, rlen integer;\n"
"declare sorts varchar;\n"
"\n"
"ent := xml_tree_doc (uddi_req);\n"
"ses := string_output ();\n"
"\n"
"st := 1; saved_bs := \'\';\n"
"\n"
"\n"
"\n"
"names := xpath_eval (\'/find_tModel/name\', ent, 0);\n"
"cbag  := xpath_eval (\'/find_tModel/categoryBag/keyedReference\', ent, 0);\n"
"ibag  := xpath_eval (\'/find_tModel/identifierBag/keyedReference\', ent, 0);\n"
"\n"
"\n"
"\n"
"\n"
"ordering := xpath_eval (\'/find_service/findQualifiers/findQualifier\', ent, 0);\n"
"exact := 0; nocase := 1; sn_asc := 0; sn_desc := 0; sd_asc := 0; sd_desc := 0;\n"
"if (isarray (ordering))\n"
"{\n"
"declare sq varchar;\n"
"len := length (ordering); ix := 0;\n"
"while (ix < len)\n"
"{\n"
"sq := cast (aref (ordering, ix) as varchar);\n"
"if (sq = \'exactNameMatch\')\n"
"exact := 1;\n"
"else if (sq = \'caseSensitiveMatch\')\n"
"nocase := 0;\n"
"else if (sq = \'sortByNameAsc\')\n"
"sn_asc := 1;\n"
"else if (sq = \'sortByNameDesc\')\n"
"sn_desc := 1;\n"
"else if (sq = \'sortByDateAsc\')\n"
"sd_asc := 1;\n"
"else if (sq = \'sortByDateDesc\')\n"
"sd_desc := 1;\n"
"ix := ix + 1;\n"
"}\n"
"}\n"
"\n"
"if ((sd_asc and sd_desc) or (sn_desc and sn_asc))\n"
"signal (\'10030\', \'Mutual exclusive sort options supplied\');\n"
"\n"
"sorts := sprintf (\' %s %s \',\n"
"case sn_asc + (sn_desc * 2)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY TM_NAME\'\n"
"else \'ORDER BY TM_NAME DESC\' end,\n"
"case sd_asc + (sd_desc * 2) + ((sn_asc + sn_desc) * 3)\n"
"when 0 then \'\'\n"
"when 1 then \'ORDER BY TM_CHANGED\'\n"
"when 2 then \'ORDER BY TM_CHANGED DESC\'\n"
"when 3 then \'\'\n"
"when 4 then  \', TM_CHANGED\'\n"
"else \', TM_CHANGED DESC\'\n"
"end);\n"
"\n"
"\n"
"if (length (names))\n"
"{\n"
"bk_arr := names;\n"
"st := 1;\n"
"criteria := criteria + 1;\n"
"}\n"
"if (length (cbag))\n"
"{\n"
"bk_arr := cbag;\n"
"st := 2;\n"
"criteria := criteria + 1;\n"
"}\n"
"if (length (ibag))\n"
"{\n"
"bk_arr := ibag;\n"
"st := 3;\n"
"criteria := criteria + 1;\n"
"}\n"
"\n"
"if (criteria <> 1)\n"
"signal (\'10030\', \'Too many options for find_tModel request\');\n"
"\n"
"if (not isarray(bk_arr))\n"
"signal (\'10050\', \'The search criteria not passed\');\n"
"\n"
"ix := 0; len := length (bk_arr); fnd := 0;\n"
"\n"
"http (sprintf (\'<tModelList generic=\"1.0\" operator=\"%s\" truncated=\"false\" xmlns=\"urn:uddi-org:api\">\', registry_get (\'UDDI_operator\')), ses);\n"
"\n"
"while (ix < len)\n"
"{\n"
"\n"
"bk := aref (bk_arr, ix);\n"
"ix := ix + 1;\n"
"\n"
"if (bk is null)\n"
"signal (\'10500\', \'The search name condition is not a string value\');\n"
"\n"
"if (st = 1)\n"
"{\n"
"bk := cast (bk as varchar);\n"
"qry := sprintf (\'select TM_TMODEL_KEY, TM_NAME\n"
"from UDDI..TMODEL where UDDI..QUAL_MATCH (TM_NAME, ?, ?, ?) %s \', sorts);\n"
"exec (qry, null, null, vector (bk, exact, nocase), 100, null, dta);\n"
"}\n"
"else if (st = 2)\n"
"{\n"
"declare ikey, ival, tkid varchar;\n"
"ikey := upper (cast (xpath_eval (\'@keyName\',  bk, 1) as varchar));\n"
"ival := upper (cast (xpath_eval (\'@keyValue\', bk, 1) as varchar));\n"
"qry := sprintf (\'select distinct TM_TMODEL_KEY, TM_NAME from\n"
"UDDI..IDENTIFIER_BAG, UDDI..TMODEL where IB_KEY_NAME = ? and IB_KEY_VALUE = ?\n"
"and IB_TMODEL_KEY_ID = TM_TMODEL_KEY %s \', sorts);\n"
"exec (qry, null, null, vector (ikey, ival), 100, null, dta);\n"
"}\n"
"else if (st = 3)\n"
"{\n"
"declare ckey, cval varchar;\n"
"ckey := cast (xpath_eval (\'@keyName\',  bk, 1) as varchar);\n"
"cval := cast (xpath_eval (\'@keyValue\', bk, 1) as varchar);\n"
"qry := sprintf (\'select distinct TM_TMODEL_KEY, TM_NAME from\n"
"UDDI..CATEGORY_BAG, UDDI..TMODEL where CB_KEY_NAME = ? and CB_KEY_VALUE = ?\n"
"and CB_TMODEL_KEY_ID = TM_TMODEL_KEY %s\', sorts);\n"
"exec (qry, null, null, vector (ckey, cval), 100, null, dta);\n"
"}\n"
"else\n"
"signal (\'10050\', \'The search condition is not supported\');\n"
"\n"
"rx := 0; rlen := length (dta);\n"
"while (rx < rlen)\n"
"{\n"
"elm := aref (dta, rx);\n"
"if (not fnd)\n"
"{\n"
"\n"
"http (\'<tModelInfos>\', ses);\n"
"fnd := 1;\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"http (sprintf (\'<tModelInfo tModelKey=\"%s\">\', aref (elm, 0)), ses);\n"
"http_value (aref (elm, 1), \'name\', ses);\n"
"http (\'</tModelInfo>\', ses);\n"
"\n"
"rx := rx + 1;\n"
"}\n"
"}\n"
"not_match:\n"
"if (fnd)\n"
"http (\'</tModelInfos>\', ses);\n"
"else\n"
"http (\'<tModelInfos/>\', ses);\n"
"http (\'</tModelList>\', ses);\n"
"ses :=  string_output_string (ses);\n"
"\n"
"return (ses);\n"
"}\n"
"--src uddi.sql:2816\n"
;

static const char *proc64 = 
"#line 3001 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_STR_GET2 (in uri varchar, in req any)\n"
"{\n"
"return http_get(uri , NULL, \'POST\', \'Content-Type: text/xml\\r\\nSOAPAction: \"\"\', req);\n"
"}\n"
"--src uddi.sql:2999\n"
;

static const char *proc65 = 
"#line 3009 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_ADD_ENVELOPE (in str varchar)\n"
"{\n"
"return concat (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\r\\n<Envelope xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\">\\r\\n\\<Body>\', str, \'</Body>\\r\\n</Envelope>\');\n"
"}\n"
"--src uddi.sql:3007\n"
;

static const char *proc66 = 
"#line 3017 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_STR_GET (in uri varchar, in req any)\n"
"{\n"
"if (req is null)\n"
"signal (\'42000\', \'The UDDI_STR_GET needs a string as request not a null\');\n"
"return http_get(uri , NULL, \'POST\', \'Content-Type: text/xml\\r\\nSOAPAction: \"\"\', UDDI_ADD_ENVELOPE (req));\n"
"}\n"
"--src uddi.sql:3015\n"
;

static const char *proc67 = 
"#line 3027 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_REMOVE_ENVELOPE (in str varchar)\n"
"{\n"
"declare next varchar;\n"
"declare res any;\n"
"\n"
"res := xml_tree_doc (str);\n"
"next := cast (xpath_eval (\'local-name(/*/*/*[position()=1])\', res, 1) as varchar);\n"
"\n"
"res := xpath_eval (concat (\'/Envelope/Body/\', next), res, 1);\n"
"return res;\n"
"}\n"
"--src uddi.sql:3025\n"
;

static const char *proc68 = 
"#line 3042 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_GET (in uri varchar, in req any)\n"
"{\n"
"return UDDI_REMOVE_ENVELOPE (http_get (uri , NULL, \'POST\', \'Content-Type: text/xml\\r\\nSOAPAction: \"\"\',\n"
"UDDI_ADD_ENVELOPE (req)));\n"
"}\n"
"--src uddi.sql:3040\n"
;

static const char *proc69 = 
"#line 3051 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"UDDI_LOCAL (in req_l any)\n"
"{\n"
"declare req any;\n"
"declare action, state, msg, res varchar;\n"
"\n"
"if (isstring (req_l))\n"
"req := xml_tree_doc (req_l);\n"
"else if (__tag (req_l) = __tag of XML)\n"
"{\n"
"declare temp any;\n"
"req := req_l;\n"
"temp := string_output ();\n"
"http_value (req_l, NULL, temp);\n"
"req_l := string_output_string (temp);\n"
"}\n"
"\n"
"action := upper (cast (xpath_eval (\'local-name(/*[position()=1])\', req) as varchar));\n"
"\n"
"if (not action in (\'SAVE_BUSINESS\', \'SAVE_TMODEL\', \'SAVE_SERVICE\', \'SAVE_BINDING\',\n"
"\'DELETE_BUSINESS\', \'DELETE_SERVICE\', \'DELETE_BINDING\', \'DELETE_TMODEL\',\n"
"\'GET_AUTHTOKEN\', \'DISCARD_AUTHTOKEN\', \'GET_REGISTEREDINFO\', \'GET_BUSINESSDETAIL\',\n"
"\'GET_BUSINESSDETAILEXT\', \'GET_BINDINGDETAIL\', \'GET_TMODELDETAIL\', \'GET_SERVICEDETAIL\',\n"
"\'FIND_BUSINESS\', \'FIND_BINDING\', \'FIND_SERVICE\', \'FIND_TMODEL\'))\n"
"signal (\'10050\', sprintf (\'Invalid UDDI action %s\', action));\n"
"\n"
"if (exec (concat (\'select (UDDI.DBA.UDDI_\', action, \' (?))\'), state, msg, vector (req_l), 100, NULL, res) = 0)\n"
"return aref (aref (res, 0), 0);\n"
"\n"
"return msg;\n"
"}\n"
"--src uddi.sql:3049\n"
;

static const char *proc70 = 
"#line 3084 \"[executable]/uddi.sql\"\n"
"create procedure\n"
"kluc (in to_kluc any)\n"
"{\n"
"declare ses any;\n"
"\n"
"ses := string_output ();\n"
"http_value (to_kluc, NULL, ses);\n"
"\n"
"return (xml_tree_doc (string_output_string (ses)));\n"
"}\n"
"--src uddi.sql:3082\n"
;

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


#define EXEC_AND_LOG_TIME(fname, sno) \
  ddl_exec_init_stmt ("do this always", sno, #fname, #sno); 

void
sqls_define_uddi (void)
{
  caddr_t saved_qualifier = bootstrap_cli->cli_qualifier;

  /* uddi.sql */
  bootstrap_cli->cli_qualifier = box_string ("UDDI");

  ddl_ensure_table ("UDDI..BUSINESS_ENTITY", tbl0);
  ddl_ensure_table ("UDDI..BUSINESS_SERVICE", tbl1);
  ddl_ensure_table ("UDDI..BINDING_TEMPLATE", tbl2);
  ddl_ensure_table ("UDDI..TMODEL", tbl3);
  ddl_ensure_table ("UDDI..DESCRIPTION", tbl4);
  ddl_ensure_table ("UDDI..DISCOVERY_URL", tbl5);
  ddl_ensure_table ("UDDI..ADDRESS_LINE", tbl6);
  ddl_ensure_table ("UDDI..CONTACTS", tbl7);
  ddl_ensure_table ("UDDI..EMAIL", tbl8);
  ddl_ensure_table ("UDDI..PHONE", tbl9);
  ddl_ensure_table ("UDDI..IDENTIFIER_BAG", tbl10);
  ddl_ensure_table ("UDDI..CATEGORY_BAG", tbl11);
  ddl_ensure_table ("UDDI..OVERVIEW_DOC", tbl12);
  ddl_ensure_table ("UDDI..INSTANCE_DETAIL", tbl13);
  DEFINE_PROC ("LOAD_UDDI_TAXONOMY", proc0);
  DEFINE_PROC ("SAVE_BUSINESS_ENTITY", proc1);
  DEFINE_PROC ("UDDI_SAVE_BUSINESS", proc2);
  DEFINE_PROC ("SAVE_DESCRIPRIONS", proc3);
  DEFINE_PROC ("SAVE_BUSINESS_SERVICES", proc4);
  DEFINE_PROC ("SAVE_BUSINESS_SERVICE", proc5);
  DEFINE_PROC ("SAVE_BINDING_TEMPLATES", proc6);
  DEFINE_PROC ("SAVE_BINDING_TEMPLATE", proc7);
  DEFINE_PROC ("SAVE_TMODEL_INSTANCE_DETAILS", proc8);
  DEFINE_PROC ("SAVE_TMODEL_INSTANCE_INFOS_1", proc9);
  DEFINE_PROC ("SAVE_IDENTIFIER_BAG", proc10);
  DEFINE_PROC ("SAVE_CATEGORY_BAG", proc11);
  DEFINE_PROC ("SAVE_OVERVIEW_DOC", proc12);
  DEFINE_PROC ("UDDI_SAVE_TMODEL", proc13);
  DEFINE_PROC ("SAVE_DISCOVERY_URLS", proc14);
  DEFINE_PROC ("SAVE_CONTACTS", proc15);
  DEFINE_PROC ("SAVE_EMAILS", proc16);
  DEFINE_PROC ("SAVE_PHONES", proc17);
  DEFINE_PROC ("SAVE_ADDRESS", proc18);
  DEFINE_PROC ("DELETE_BUSINESS_BK", proc19);
  DEFINE_PROC ("UDDI_SAVE_SERVICE", proc20);
  DEFINE_PROC ("DELETE_SERVICE_SK", proc21);
  DEFINE_PROC ("DELETE_BINDING_BK", proc22);
  DEFINE_PROC ("DELETE_TMODEL_TK", proc23);
  DEFINE_PROC ("UDDI_SAVE_BINDING", proc24);
  DEFINE_PROC ("UDDI_DELETE_BUSINESS", proc25);
  DEFINE_PROC ("UDDI_DELETE_SERVICE", proc26);
  DEFINE_PROC ("UDDI_DELETE_BINDING", proc27);
  DEFINE_PROC ("UDDI_DELETE_TMODEL", proc28);
  DEFINE_PROC ("GET_FROM_UPLOAD_REGISTER", proc29);
  DEFINE_PROC ("SAVE_BUSINESS_FROM_FILE", proc30);
  DEFINE_PROC ("UDDI_GET_AUTHTOKEN", proc31);
  DEFINE_PROC ("UDDI_DISCARD_AUTHTOKEN", proc32);
  DEFINE_PROC ("OK_DISPOSITION_REPORT", proc33);
  DEFINE_PROC ("UDDI_GET_REGISTEREDINFO", proc34);
  DEFINE_PROC ("VERIFY_AUTH_INFO", proc35);
  DEFINE_PROC ("UDDI_GET_BUSINESSDETAILEXT", proc36);
  DEFINE_PROC ("UDDI_GET_BUSINESSDETAIL", proc37);
  DEFINE_PROC ("BUSINESS_DETAIL", proc38);
  DEFINE_PROC ("UDDI_GET_BINDINGDETAIL", proc39);
  DEFINE_PROC ("BINDING_DETAIL", proc40);
  DEFINE_PROC ("UDDI_GET_TMODELDETAIL", proc41);
  DEFINE_PROC ("TMODEL_DETAIL", proc42);
  DEFINE_PROC ("UDDI_GET_SERVICEDETAIL", proc43);
  DEFINE_PROC ("SERVICE_DETAIL", proc44);
  DEFINE_PROC ("TMODEL_INSTANCE_DETAILS", proc45);
  DEFINE_PROC ("OVERVIEW_DOC", proc46);
  DEFINE_PROC ("DISCOVERY_URLS", proc47);
  DEFINE_PROC ("BUSINESS_SERVICES", proc48);
  DEFINE_PROC ("BINDING_TEMPLATES", proc49);
  DEFINE_PROC ("CATEGORY_BAG", proc50);
  DEFINE_PROC ("IDENTIFIER_BAG", proc51);
  DEFINE_PROC ("DESCRIPTIONS", proc52);
  DEFINE_PROC ("CONTACTS", proc53);
  DEFINE_PROC ("PHONE", proc54);
  DEFINE_PROC ("EMAIL", proc55);
  DEFINE_PROC ("ADDRESS", proc56);
  DEFINE_PROC ("ADDRESS_2", proc57);
  DEFINE_PROC ("QUAL_MATCH", proc58);
  DEFINE_PROC ("UDDI_FIND_BUSINESS", proc59);
  DEFINE_PROC ("SERVICE_INFOS", proc60);
  DEFINE_PROC ("UDDI_FIND_BINDING", proc61);
  DEFINE_PROC ("UDDI_FIND_SERVICE", proc62);
  DEFINE_PROC ("UDDI_FIND_TMODEL", proc63);
  DEFINE_PROC ("UDDI_STR_GET2", proc64);
  DEFINE_PROC ("UDDI_ADD_ENVELOPE", proc65);
  DEFINE_PROC ("UDDI_STR_GET", proc66);
  DEFINE_PROC ("UDDI_REMOVE_ENVELOPE", proc67);
  DEFINE_PROC ("UDDI_GET", proc68);
  DEFINE_PROC ("UDDI_LOCAL", proc69);
  DEFINE_PROC ("kluc", proc70);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;
}


void
sqls_arfw_define_uddi (void)
{
  caddr_t saved_qualifier = bootstrap_cli->cli_qualifier;

  /* ./uddi.sql */
  bootstrap_cli->cli_qualifier = box_string ("UDDI");

  EXEC_AND_LOG_TIME(uddi.sql, other0);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;
}
