/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

#include "import_gate_virtuoso.h"

/* graphql.sql */

static const char *other0 = 
"DB.DBA.XML_SET_NS_DECL (\'gql\', \'http://www.openlinksw.com/schemas/graphql#\', 2)\n";
static const char *other1 = 
"DB.DBA.XML_SET_NS_DECL (\'gqi\', \'http://www.openlinksw.com/schemas/graphql/intro#\', 2)\n";
static const char *proc0 = 
"#line 12 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_GET_FRAGMENTS (inout tree any)\n"
"{\n"
"declare frag_dict, elm any;\n"
"declare i int;\n"
"\n"
"if (isvector (tree) and tree[0] = 199)\n"
"tree := tree[1];\n"
"\n"
"frag_dict := dict_new (length (tree));\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"if (gql_frag (elm))\n"
"{\n"
"dict_put (frag_dict, elm[1], vector (elm[2], elm[3]));\n"
"tree[i] := null;\n"
"}\n"
"}\n"
"return frag_dict;\n"
"}\n"
"--src graphql.sql:10\n"
;

static const char *proc1 = 
"#line 35 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXPAND_REFS (in tree any, inout variables any, inout frag_dict any, out frag_exists int)\n"
"{\n"
"declare elm, new_tree any;\n"
"declare i, j int;\n"
"\n"
"if (not isvector (tree))\n"
"return tree;\n"
"\n"
"if (frag_dict is null)\n"
"frag_dict := GQL_GET_FRAGMENTS (tree);\n"
"\n"
"vectorbld_init (new_tree);\n"
"\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"declare exp any;\n"
"elm := tree[i];\n"
"\n"
"\n"
"\n"
"if (not isvector (elm))\n"
"{\n"
"vectorbld_acc (new_tree, elm);\n"
"goto skip;\n"
"}\n"
"\n"
"if (gql_field (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[6], variables))\n"
"goto skip;\n"
"if (gql_frag_ref (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[2], variables))\n"
"goto skip;\n"
"if (gql_inline_frag (elm) and 0 = GQL_DIRECTIVES_CHECK (elm[2], variables))\n"
"goto skip;\n"
"\n"
"if (gql_frag_ref (elm))\n"
"{\n"
"declare fname, ftype varchar;\n"
"declare exps any;\n"
"fname := elm[1];\n"
"exps := dict_get (frag_dict, fname);\n"
"ftype := exps[0];\n"
"exp := exps[1];\n"
"foreach (any frag in exp) do\n"
"{\n"
"if (gql_field (frag))\n"
"frag [5] := ftype;\n"
"vectorbld_acc (new_tree, frag);\n"
"}\n"
"frag_exists := 1;\n"
"}\n"
"else if (gql_inline_frag (elm))\n"
"{\n"
"declare ftype varchar;\n"
"declare exps any;\n"
"exps := elm[3];\n"
"ftype := elm[1];\n"
"foreach (any frag in exps) do\n"
"{\n"
"frag [5] := ftype;\n"
"vectorbld_acc (new_tree, frag);\n"
"}\n"
"frag_exists := 1;\n"
"}\n"
"else\n"
"{\n"
"exp := GQL_EXPAND_REFS (elm, variables, frag_dict, frag_exists);\n"
"if (exp is not null)\n"
"{\n"
"vectorbld_acc (new_tree, exp);\n"
"}\n"
"}\n"
"skip:;\n"
"}\n"
"vectorbld_final (new_tree);\n"
"return new_tree;\n"
"}\n"
"--src graphql.sql:33\n"
;

static const char *proc2 = 
"#line 113 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_APPLY_VARS_DEFAULTS (inout variables any, inout defs any)\n"
"{\n"
"declare i int;\n"
"if (not gql_vars_defs (defs))\n"
"return;\n"
"defs := defs[1];\n"
"if (not isvector (variables))\n"
"variables := vector ();\n"
"for (i := 0; i < length (defs); i := i + 2)\n"
"{\n"
"declare var_name varchar;\n"
"declare pos int;\n"
"declare def_value any;\n"
"var_name := defs[i][1];\n"
"def_value := defs[i+1][2];\n"
"if (get_keyword (var_name, variables) is null)\n"
"variables := vector_concat (variables, vector (var_name, def_value));\n"
"}\n"
"}\n"
"--src graphql.sql:111\n"
;

static const char *proc3 = 
"#line 135 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_PARSE_REQUEST (in str any, inout variables any, inout g_iid any, inout tree any,\n"
"inout triples any, inout patterns any, inout vals any, inout clauses any, inout updates any, inout upd_params any,\n"
"inout dict any, in operation_name varchar)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare elm, elem_lst, frag_dict, parent, vars_defs any;\n"
"declare i, j, frag_exists, nth int;\n"
"declare defs, qry, operation varchar;\n"
"declare qry_idx int;\n"
"\n"
"tree := graphql_parse (str);\n"
"\n"
"if (gql_top (tree))\n"
"tree := tree[1];\n"
"else\n"
"signal (\'GQLRQ\', \'Unexpected GraphQL document\');\n"
"\n"
"qry_idx := 0;\n"
"\n"
"for (i := 0; i < length (tree); i := i + 1)\n"
"{\n"
"if (operation_name is not null and tree[i][1] = operation_name)\n"
"qry_idx := i;\n"
"if (gql_token (tree[i][0]) in (\'query\', \'mutation\'))\n"
"{\n"
"vars_defs := tree[i][3];\n"
"GQL_APPLY_VARS_DEFAULTS (variables, vars_defs);\n"
"}\n"
"}\n"
"\n"
"frag_dict := null;\n"
"frag_exists := 1;\n"
"nth := 0;\n"
"while (frag_exists)\n"
"{\n"
"frag_exists := 0;\n"
"tree := GQL_EXPAND_REFS (tree, variables, frag_dict, frag_exists);\n"
"nth := nth + 1;\n"
"if (nth > atoi (registry_get (\'graphql-max-depth\', \'15\')))\n"
"signal (\'GQLDX\', \'Maximum nesting level reached or infinite loop in fragments, optimise your query.\');\n"
"}\n"
"\n"
"\n"
"\n"
"operation := gql_token (tree[qry_idx][0]);\n"
"if (operation in (\'query\', \'mutation\'))\n"
"{\n"
"tree := tree[qry_idx][2];\n"
"}\n"
"else\n"
"{\n"
"signal (\'GQLNO\', sprintf (\'The `%s` operation is not supported.\', operation));\n"
"}\n"
"\n"
"triples := string_output ();\n"
"patterns := string_output ();\n"
"vals := string_output ();\n"
"clauses := string_output ();\n"
"updates := string_output ();\n"
"vectorbld_init (upd_params);\n"
"parent := null;\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"\n"
"if (i = 0 and gql_field (elm))\n"
"{\n"
"declare top_field_name varchar;\n"
"top_field_name := elm[1];\n"
"if (top_field_name in (\'__schema\',\'__type\'))\n"
"{\n"
"connection_set (\'__intro\', (case top_field_name when \'__schema\' then 1 when \'__type\' then 2 else 0 end));\n"
"g_iid := GQL_SCH_IID();\n"
"}\n"
"else\n"
"{\n"
"declare g_iid_sch, field_iid iri_id_8;\n"
"field_iid := GQL_IID (top_field_name);\n"
"g_iid_sch := (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?g where { graph ?g { gql:Map gql:schemaObjects ?:field_iid .  filter (?g != <urn:graphql:schema>)}});\n"
"g_iid := coalesce (g_iid_sch, g_iid);\n"
"}\n"
"}\n"
"if (operation = \'mutation\')\n"
"GQL_UPDATE (g_iid, elm, variables, parent, updates, upd_params, dict);\n"
"GQL_CONSTRUCT (g_iid, elm, variables, parent, triples, patterns, vals, clauses, dict);\n"
"}\n"
"vectorbld_final (upd_params);\n"
"return 1;\n"
"}\n"
"--src graphql.sql:133\n"
;

static const char *proc4 = 
"#line 228 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXEC_UPDATES (in qry_ses varchar, inout upd_params any)\n"
"{\n"
"declare qrs, params any;\n"
"declare state, message varchar;\n"
"declare maxrows, nth int;\n"
"\n"
"set_user_id (connection_get (\'SPARQLUserId\', \'GRAPHQL\'), 1);\n"
"qrs := string_output_string (qry_ses);\n"
"qrs := sql_split_text (qrs);\n"
"nth := 0;\n"
"foreach (varchar qry in qrs) do\n"
"{\n"
"maxrows := 0;\n"
"params := upd_params[nth];\n"
"state := \'00000\';\n"
"exec (qry, state, message, params, vector (\'max_rows\', maxrows, \'use_cache\', 1));\n"
"if (state <> \'00000\')\n"
"{\n"
"signal (state, message);\n"
"return NULL;\n"
"}\n"
"nth := nth + 1;\n"
"}\n"
"}\n"
"--src graphql.sql:226\n"
;

static const char *proc5 = 
"#line 256 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_EXEC (in tree any, in qry varchar, inout meta any, inout rset any, in timeout int)\n"
"{\n"
"declare ses, params any;\n"
"declare state, message, elm varchar;\n"
"declare maxrows, nesting, is_array int;\n"
"declare max_timeout int;\n"
"declare anytime_status integer;\n"
"\n"
"maxrows := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'ResultSetMaxRows\'), \'-1\'));\n"
"anytime_status := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'HTTPAnytimeStatus\'), \'206\'));\n"
"\n"
"if (connection_get (\'__intro\'))\n"
"{\n"
"maxrows := -1;\n"
"timeout := 0;\n"
"}\n"
"params := vector ();\n"
"state := \'00000\';\n"
"\n"
"max_timeout := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxQueryExecutionTime\'), \'0\')) * 1000;\n"
"if (max_timeout < 1000) max_timeout := 0;\n"
"if (timeout < 1000) timeout := 0;\n"
"if (max_timeout >= 1000 and (timeout > max_timeout))\n"
"{\n"
"timeout := max_timeout;\n"
"}\n"
"if (max_timeout and (timeout >= 1000))\n"
"{\n"
"set RESULT_TIMEOUT = timeout;\n"
"}\n"
"else if (max_timeout >= 1000)\n"
"{\n"
"set RESULT_TIMEOUT = max_timeout;\n"
"}\n"
"\n"
"qry := \'SPARQL \' || qry;\n"
"exec (qry, state, message, params, vector (\'max_rows\', maxrows, \'use_cache\', 1), meta, rset);\n"
"set RESULT_TIMEOUT = 0;\n"
"if (not isvector (rset))\n"
"rset := vector();\n"
"if (state = \'S1TAT\' and timeout >= 1000)\n"
"{\n"
"http_status_set (anytime_status);\n"
"http_header (concat (http_header_get(),\n"
"sprintf (\'Accept-Ranges: none\\r\\nX-SPARQL-Anytime: timeout=%d; max_timeout=%d\\r\\n\', timeout, max_timeout)));\n"
"}\n"
"else if (length (rset) = maxrows)\n"
"{\n"
"http_status_set (anytime_status);\n"
"http_header (concat (http_header_get(), sprintf (\'Accept-Ranges: none\\r\\nX-SPARQL-MaxRows: %d\\r\\n\', maxrows)));\n"
"}\n"
"else if (state <> \'00000\')\n"
"{\n"
"signal (state, message);\n"
"return NULL;\n"
"}\n"
"}\n"
"--src graphql.sql:254\n"
;

static const char *proc6 = 
"#line 316 \"[executable]/graphql.sql\"\n"
"create function GQL_IID (in var varchar) returns iri_id_8\n"
"{\n"
"return iri_to_id (concat (\'http://www.openlinksw.com/schemas/graphql#\', var));\n"
"}\n"
"--src graphql.sql:314\n"
;

static const char *proc7 = 
"#line 322 \"[executable]/graphql.sql\"\n"
"create function GQL_SCH_IID () returns iri_id_8\n"
"{\n"
"return iri_to_id (\'urn:graphql:schema\');\n"
"}\n"
"--src graphql.sql:320\n"
;

static const char *proc8 = 
"#line 328 \"[executable]/graphql.sql\"\n"
"create procedure GQL_VAL_PRINT (in val any, in xsd_type varchar := null)\n"
"{\n"
"declare ret varchar;\n"
"if (xsd_type in (GQL_XSD_IRI (\'date\'), GQL_XSD_IRI (\'dateTime\'), GQL_XSD_IRI (\'time\')))\n"
"{\n"
"declare parsed varchar;\n"
"parsed := __xqf_str_parse_to_rdf_box (val, xsd_type, 1);\n"
"if (parsed is null)\n"
"{\n"
"declare ses any;\n"
"if (xsd_type = GQL_XSD_IRI (\'dateTime\'))\n"
"parsed := cast (val as datetime);\n"
"else if (xsd_type = GQL_XSD_IRI (\'date\'))\n"
"parsed := cast (val as date);\n"
"else if (xsd_type = GQL_XSD_IRI (\'time\'))\n"
"parsed := cast (val as time);\n"
"else\n"
"signal (\'22023\', \'Invalid date/time value\');\n"
"ses := string_output ();\n"
"__rdf_long_to_ttl (parsed, ses);\n"
"val := string_output_string (ses);\n"
"}\n"
"ret := sprintf (\'%s^^<%s>\',  DB.DBA.SYS_SQL_VAL_PRINT (val), xsd_type);\n"
"}\n"
"else\n"
"ret := DB.DBA.SYS_SQL_VAL_PRINT (val);\n"
"return ret;\n"
"}\n"
"--src graphql.sql:326\n"
;

static const char *proc9 = 
"#line 358 \"[executable]/graphql.sql\"\n"
"create procedure GQL_SQL_ARRAY_STR (in var any, in xsd_type varchar)\n"
"{\n"
"declare i int;\n"
"declare res varchar;\n"
"res := \'(\';\n"
"for (i := 0; i < length (var); i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"res := concat (res, \',\');\n"
"res := concat (res, GQL_VAL_PRINT (var[i], xsd_type));\n"
"}\n"
"res := concat (res, \')\');\n"
"return res;\n"
"}\n"
"--src graphql.sql:356\n"
;

static const char *proc10 = 
"#line 374 \"[executable]/graphql.sql\"\n"
"create function GQL_OP (in tok varchar)\n"
"{\n"
"tok := lower (tok);\n"
"if (tok = \'gt\') return \'>\';\n"
"if (tok = \'gte\') return \'>=\';\n"
"if (tok = \'lt\') return \'<\';\n"
"if (tok = \'lte\') return \'<=\';\n"
"if (tok = \'neq\') return \'!=\';\n"
"if (tok = \'like\') return \'LIKE\';\n"
"if (tok = \'in\') return \'IN\';\n"
"if (tok = \'not_in\') return \'NOT IN\';\n"
"signal (\'GQLTO\', sprintf (\'Unrecognised expression operator %s\', tok));\n"
"}\n"
"--src graphql.sql:372\n"
;

static const char *proc11 = 
"#line 389 \"[executable]/graphql.sql\"\n"
"create procedure GQL_DEBUG (in line int, in text varchar)\n"
"{\n"
"if (registry_get (\'graphql-debug\') = \'1\')\n"
"dbg_obj_print (\'line:\', line, \' \',replace (text, \'\\n\', \'\'));\n"
"}\n"
"--src graphql.sql:387\n"
;

static const char *proc12 = 
"#line 396 \"[executable]/graphql.sql\"\n"
"create function\n"
"GQL_DIRECTIVES_CHECK (in directives_list any, inout variables any) returns int\n"
"{\n"
"declare inx int;\n"
"declare directive_name, directive, cond any;\n"
"if (not gql_directives (directives_list))\n"
"return 1;\n"
"directives_list := directives_list[1];\n"
"for (inx := 0; inx < length (directives_list); inx := inx + 2)\n"
"{\n"
"directive_name := directives_list[inx];\n"
"directive := directives_list[inx+1];\n"
"if (directive_name not in (\'skip\', \'include\'))\n"
"signal (\'GQLDN\', sprintf (\'Directive `%s` is not supported\', directive_name));\n"
"if (not gql_args (directive) or length (directive[1]) <> 2 or directive[1][0] <> \'if\')\n"
"signal (\'GQLDA\', sprintf (\'Directive `%s` must specify `if`\', directive_name));\n"
"cond := coalesce (GQL_VALUE (variables, directive[1][1], \'RAW\'), 0);\n"
"if (directive_name = \'skip\' and cond)\n"
"return 0;\n"
"if (directive_name = \'include\' and not cond)\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src graphql.sql:394\n"
;

static const char *proc13 = 
"#line 422 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_CONSTRUCT (in g_iid any, in tree any, in variables any, in parent any,\n"
"inout triples any, inout patterns any, inout vals any, inout clauses any, inout dict any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare i, j int;\n"
"declare elm, args any;\n"
"declare var_name, var_name_only varchar;\n"
"\n"
"if (not isvector (tree))\n"
"return;\n"
"if (gql_field (tree))\n"
"{\n"
"declare cls, cls_type, prop, tp, parent_name, parent_prop, parent_cls, prefix, field_type, local_filter varchar;\n"
"declare id_prop varchar;\n"
"declare has_filter int;\n"
"args := tree[2];\n"
"\n"
"parent_name := parent_cls := parent_prop := cls := cls_type := null; id_prop := null;\n"
"has_filter := 0;\n"
"if (isvector (parent))\n"
"{\n"
"parent_cls := parent[0];\n"
"parent_name := parent[1];\n"
"parent_prop := parent[2];\n"
"prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"prefix := \'\';\n"
"\n"
"field_type := tree[5];\n"
"var_name_only := var_name := tree[1];\n"
"var_name := concat (prefix, var_name);\n"
"local_filter := \'\';\n"
"tree := tree[3];\n"
"if ((isvector (tree) or parent_name is null) and var_name <> \'__typename\')\n"
"{\n"
"declare gcls_iid iri_id_8;\n"
"declare pos int;\n"
"gcls_iid := GQL_IID (var_name_only);\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { gql:Map gql:schemaObjects <%s> . <%s> gql:rdfClass ?class ; gql:type ?class_type . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(gcls_iid), id_to_iri(gcls_iid)));\n"
"\n"
"for select \"class\", \"class_type\" from (sparql select ?class ?class_type where\n"
"{ graph ?:g_iid { gql:Map gql:schemaObjects ?:gcls_iid .\n"
"?:gcls_iid gql:rdfClass ?class ; gql:type ?class_type . }}) dt0 do\n"
"{\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"}\n"
"\n"
"\n"
"if (cls is null and parent_name is not null)\n"
"{\n"
"for select \"class\", \"class_type\" from (sparql select ?class ?class_type where { graph ?:g_iid {\n"
"[] a owl:ObjectProperty ; gql:field ?:gcls_iid ; rdfs:range ?class .\n"
"gql:Map gql:schemaObjects [ gql:rdfClass ?class ; gql:type ?class_type ] .  }}) dt1 do\n"
"{\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"}\n"
"}\n"
"if (cls is null)\n"
"{\n"
"signal (\'GQL0X\', sprintf (\'Can not find class for field \"%s\"\', var_name_only));\n"
"}\n"
"cls_type := iri_split (cls_type, null, 0, 1);\n"
"\n"
"if (atoi (registry_get (\'graphql-top-object\', \'0\')) > 0 and\n"
"var_name <> \'__schema\' and cls_type <> \'Array\' and parent_cls is null and not isvector (args))\n"
"signal (\'GQLAR\', sprintf (\'The field `%s` is an Object and no parent field or arguments.\', var_name_only));\n"
"\n"
"dict_put (dict, var_name, cls_type);\n"
"parent := vector (iri_to_id (cls), var_name, null);\n"
"if (parent_cls is null and var_name <> \'__type\')\n"
"http (sprintf (\' ?%s a <%s> . \\n\', var_name, cls), patterns);\n"
"else if (parent_cls is null and var_name = \'__type\')\n"
"http (sprintf (\' ?%s a [] . \\n\', var_name), patterns);\n"
"\n"
"if (parent_name is null)\n"
"http (sprintf (\' :data :%s ?%s . \\n\', var_name_only, var_name_only), triples);\n"
"}\n"
"if (gql_args (args))\n"
"{\n"
"declare arg_name, arg_value any;\n"
"declare arg_iid, fld_iid iri_id_8;\n"
"fld_iid := GQL_IID (var_name_only);\n"
"args := args[1];\n"
"for (j := 0; j < length(args); j := j + 2)\n"
"{\n"
"arg_name := args[j];\n"
"arg_value := args[j + 1];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"arg_iid := GQL_IID (arg_name);\n"
"if (arg_name = \'first\')\n"
"http (sprintf (\' LIMIT %s \\n\', DB.DBA.SYS_SQL_VAL_PRINT (arg_value)), clauses);\n"
"else if (arg_name = \'offset\')\n"
"http (sprintf (\' OFFSET %s \\n\', DB.DBA.SYS_SQL_VAL_PRINT (arg_value)), clauses);\n"
"else if (arg_name = \'contains\')\n"
"{\n"
"declare ftx varchar;\n"
"ftx := DB.DBA.FTI_MAKE_SEARCH_STRING (arg_value);\n"
"if (ftx is null)\n"
"signal (\'GQLFX\', sprintf (\'Can not search \"%s\" with an empty pattern\', var_name));\n"
"http (sprintf (\' ?%s ?%s·search ?%s . \\n\', var_name, arg_name, arg_name), patterns);\n"
"http (sprintf (\' FILTER (bif:contains (?%s, \\\'%s\\\')) \\n\',  arg_name, ftx), vals);\n"
"}\n"
"else if (arg_name = \'iri\')\n"
"http (sprintf (\' FILTER (?%s = <%s>) \\n\',  var_name, arg_value), vals);\n"
"else if (arg_name = \'lang\')\n"
"local_filter := concat (local_filter, sprintf (\' FILTER (lang(?%s) = \\\'%s\\\') \\n\',  var_name, arg_value));\n"
"else\n"
"{\n"
"declare xsd_type varchar;\n"
"if (g_iid = GQL_SCH_IID())\n"
"{\n"
"\n"
"if (arg_name = \'includeDeprecated\' and arg_value)\n"
"goto skip_filter;\n"
"if (arg_name = \'includeDeprecated\')\n"
"{\n"
"arg_name := \'isDeprecated\';\n"
"arg_iid := GQL_IID (arg_name);\n"
"}\n"
"}\n"
"prop := null;\n"
"\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { ?prop0 rdfs:domain <%s> ; gql:type ?tp0 ; gql:field <%s> . \',\n"
"\'  optional {  [] rdfs:domain <%s>  ; rdfs:range ?range ; gql:field <%s> . \',\n"
"\'  ?prop1 rdfs:domain ?range ; gql:field <%s> . } }}\'),\n"
"id_to_iri (g_iid), id_to_iri (cls), id_to_iri(arg_iid), id_to_iri (cls), id_to_iri(fld_iid), id_to_iri(arg_iid) ));\n"
"\n"
"for select \"prop0\", \"prop1\", \"tp0\", \"range0\" from (sparql select ?prop0 ?prop1 ?tp0 ?range0 where { graph ?:g_iid {\n"
"?prop0 rdfs:domain `iri(?:cls)` ; gql:type ?tp0 ; rdfs:range ?range0 ; gql:field ?:arg_iid .\n"
"optional {  [] rdfs:domain `iri(?:cls)`  ; rdfs:range ?range ; gql:field ?:fld_iid .\n"
"?prop1 rdfs:domain ?range ; gql:field ?:arg_iid .\n"
"}\n"
"}}) dt0 do\n"
"{\n"
"prop := coalesce (\"prop1\", \"prop0\");\n"
"tp := iri_split (\"tp0\", null, 0, 1);\n"
"xsd_type := \"range0\";\n"
"}\n"
"if (prop is null)\n"
"signal (\'GQL1X\', sprintf (\'Can not find property for argument \"%s\"\', arg_name));\n"
"\n"
"if (tp = \'ID\')\n"
"id_prop := prop;\n"
"\n"
"arg_name := concat (prefix, var_name_only, \'·\', arg_name);\n"
"http (sprintf (\' ?%s <%s> ?%s . \\n\', var_name, prop, arg_name), patterns);\n"
"if (arg_value is null)\n"
"http (sprintf (\'FILTER (?%s = rdf:nil) \\n\',  arg_name), vals);\n"
"else if (gql_expression (arg_value))\n"
"{\n"
"declare op varchar;\n"
"arg_value := arg_value[1][0];\n"
"op := GQL_OP (arg_value[1]);\n"
"arg_value := arg_value[2];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"http (sprintf (\'FILTER (?%s %s %s) \\n\',  arg_name, op, GQL_VAL_PRINT (arg_value, xsd_type)), vals);\n"
"}\n"
"else if (gql_obj (arg_value))\n"
"{\n"
"signal (\'GQLV0\', \'Inlined objects not supported in args list\');\n"
"}\n"
"else if (isvector (arg_value) and length (arg_value) > 1 and __tag (arg_value[0]) = 255 and arg_value[1] = \'structure\')\n"
"{\n"
"signal (\'GQLV1\', \'JSON objects not supported as values\');\n"
"}\n"
"else if (isvector (arg_value))\n"
"{\n"
"declare vlist varchar;\n"
"vlist := GQL_SQL_ARRAY_STR (arg_value, xsd_type);\n"
"http (sprintf (\' FILTER (?%s IN %s) \\n\',  arg_name, vlist), vals);\n"
"}\n"
"else if (tp = \'IRI\' or tp = \'Object\' or tp = \'Array\')\n"
"http (sprintf (\' FILTER (?%s = <%s>) \\n\',  arg_name, arg_value), vals);\n"
"else\n"
"http (sprintf (\' FILTER (?%s = %s) \\n\',  arg_name, GQL_VAL_PRINT (arg_value, xsd_type)), vals);\n"
"has_filter := 1;\n"
"skip_filter:;\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (parent_cls is not null)\n"
"{\n"
"declare parent_type varchar;\n"
"declare fld_iid iri_id_8;\n"
"fld_iid := GQL_IID (var_name_only);\n"
"if (not isvector (parent))\n"
"signal (\'GQL2X\', \'Internal error, unexpected child\');\n"
"\n"
"parent_type := dict_get (dict, parent_name);\n"
"prop := tp := null;\n"
"if (parent_prop is not null and (parent_type = \'Object\' or parent_type = \'Array\'))\n"
"{\n"
"GQL_DEBUG (pldbg_last_line (),sprintf ( concat (\'sparql select * where { graph <%s> \',\n"
"\' { <%s> rdfs:range  ?range . ?prop0 rdfs:domain ?range ; gql:field <%s> ; gql:type ?tp0 . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(parent_prop), id_to_iri(fld_iid)));\n"
"for select \"prop0\", \"tp0\" from (sparql select ?prop0 ?tp0 where { graph ?:g_iid\n"
"{ ?:parent_prop rdfs:range  ?range . ?prop0 rdfs:domain ?range ; gql:field ?:fld_iid ; gql:type ?tp0 . }}) dt0 do\n"
"{\n"
"prop := \"prop0\";\n"
"tp := \"tp0\";\n"
"}\n"
"}\n"
"else\n"
"{\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { ?prop0 rdfs:domain <%s> ; gql:field <%s> ; gql:type ?tp0 . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(parent_cls), id_to_iri(fld_iid)));\n"
"for select \"prop0\", \"tp0\"  from (sparql select ?prop0 ?tp0 where { graph ?:g_iid\n"
"{ ?prop0 rdfs:domain ?:parent_cls ; gql:field ?:fld_iid ; gql:type ?tp0 . }}) dt0 do\n"
"{\n"
"prop := \"prop0\";\n"
"tp := \"tp0\";\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"if (prop is null and var_name_only not in (\'__typename\', \'iri\'))\n"
"{\n"
"signal (\'GQL3X\', sprintf (\'Can not find property for field \"%s\" of %s\', var_name_only, var_name));\n"
"}\n"
"\n"
"if (var_name_only not in (\'__typename\', \'iri\'))\n"
"{\n"
"tp := iri_split (tp, null, 0,1);\n"
"dict_put (dict, var_name, tp);\n"
"parent [2] := prop;\n"
"http (sprintf (\' ?%s :%s ?%s . \\n\', parent_name, var_name, var_name), triples);\n"
"if (not has_filter)\n"
"http (\' OPTIONAL\', patterns);\n"
"else\n"
"http (\'\\t\', patterns);\n"
"\n"
"if (connection_get (\'__intro\') = 1)\n"
"http (sprintf (\' {  ?%s <%s> ?%s option (table_option \"hash\") . \\n\', parent_name, prop, var_name), patterns);\n"
"else\n"
"http (sprintf (\' {  ?%s <%s> ?%s . \\n\', parent_name, prop, var_name), patterns);\n"
"\n"
"\n"
"if (atoi (registry_get (\'graphql-enable-non-object-fitering\', \'0\'))\n"
"and not(connection_get (\'__intro\')) and (tp = \'Object\' or tp = \'Array\'))\n"
"http (sprintf (\' FILTER (isIRI (?%s)) . \\n\', var_name), patterns);\n"
"}\n"
"else if (var_name_only = \'__typename\')\n"
"{\n"
"http (sprintf (\' ?%s :%s `bif:iri_split(?%s,0,0,1)` . \\n\', parent_name, var_name, var_name), triples);\n"
"http (sprintf (\' { ?%s rdf:type ?%s . \\n\', parent_name, var_name), patterns);\n"
"}\n"
"else\n"
"{\n"
"\n"
"http (sprintf (\' ?%s :%s ?%s . \\n\', parent_name, var_name, parent_name), triples);\n"
"\n"
"if (var_name_only = \'iri\' and strchr (parent_name, \'·\') is not null)\n"
"http (sprintf (\' FILTER (isIRI (?%s)) . \\n\', parent_name), patterns);\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"if (isvector (tree))\n"
"GQL_CONSTRUCT (g_iid, tree, variables, parent, triples, patterns, vals, clauses, dict);\n"
"\n"
"\n"
"if (parent_cls is not null and var_name_only <> \'iri\')\n"
"{\n"
"http (local_filter, patterns);\n"
"http (\' }\\n\', patterns);\n"
"}\n"
"\n"
"if (parent_cls is null and var_name = \'__typename\')\n"
"{\n"
"http (sprintf (\' :data :%s \"Query\" . \\n\', var_name), triples);\n"
"}\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"GQL_CONSTRUCT (g_iid, elm, variables, parent, triples, patterns, vals, clauses, dict);\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"--src graphql.sql:420\n"
;

static const char *proc14 = 
"#line 719 \"[executable]/graphql.sql\"\n"
"create procedure GQL_VALUE (in variables any, in arg_value any, in tp varchar)\n"
"{\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"if (tp = \'RAW\')\n"
"return arg_value;\n"
"if (arg_value is null)\n"
"return \'rdf:nil\';\n"
"if (gql_expression (arg_value) or isvector (arg_value))\n"
"signal (\'GQLVX\', \'Argument value type for mutation is not supported.\');\n"
"if (tp = \'IRI\')\n"
"return sprintf (\'<%s>\', arg_value);\n"
"return DB.DBA.SYS_SQL_VAL_PRINT (arg_value);\n"
"}\n"
"--src graphql.sql:717\n"
;

static const char *proc15 = 
"#line 735 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_UPDATE (in g_iid any, in tree any, in variables any, in parent any, inout triples any, inout upd_params any, inout dict any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare i, j int;\n"
"declare elm, args any;\n"
"declare var_name, var_name_only varchar;\n"
"\n"
"if (not isvector (tree))\n"
"return;\n"
"if (gql_field (tree))\n"
"{\n"
"declare cls, cls_type, prop, tp, parent_name, parent_prop, parent_cls, prefix varchar;\n"
"declare field_type, iri_format, data_graph, sparql_operation, update_qry varchar;\n"
"\n"
"parent_name := parent_cls := parent_prop := cls := cls_type := null; iri_format := null; update_qry := null;\n"
"if (isvector (parent))\n"
"{\n"
"parent_cls := parent[0]; parent_name := parent[1]; parent_prop := parent[2]; prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"{\n"
"prefix := \'\';\n"
"}\n"
"\n"
"field_type := tree[5];\n"
"var_name_only := var_name := tree[1];\n"
"var_name := concat (prefix, var_name);\n"
"args := tree[2];\n"
"tree := tree[3];\n"
"if (isvector (tree))\n"
"{\n"
"declare gcls_iid iri_id_8;\n"
"gcls_iid := GQL_IID (var_name_only);\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { gql:Map gql:schemaObjects <%s> . <%s> gql:rdfClass ?class ; gql:type ?class_type . }}\'),\n"
"id_to_iri (g_iid), id_to_iri(gcls_iid), id_to_iri(gcls_iid)));\n"
"\n"
"for select \"class\", \"class_type\", \"iri_pattern\", \"data_graph0\", \"sparql_op0\", \"qry0\" from (sparql select * where\n"
"{ graph ?:g_iid { gql:Map gql:schemaObjects ?gcls .\n"
"?gcls gql:rdfClass ?class ; gql:type ?class_type ; gql:mutationType ?sparql_op0 .\n"
"optional { ?gcls gql:sparqlQuery ?qry0 }\n"
"optional { ?class gql:iriPattern ?iri_pattern }\n"
"gql:Map gql:dataGraph ?data_graph0 .\n"
"filter (?gcls = ?:gcls_iid) }}) dt0 do\n"
"{\n"
"cls := \"class\";\n"
"cls_type := \"class_type\";\n"
"iri_format := \"iri_pattern\";\n"
"data_graph := \"data_graph0\";\n"
"sparql_operation := \"sparql_op0\";\n"
"update_qry := \"qry0\";\n"
"}\n"
"if (parent is not null and cls is null)\n"
"return;\n"
"if (cls is null)\n"
"signal (\'GQL0U\', sprintf (\'Can not find class for field \"%s\"\', var_name_only));\n"
"if (iri_format is null)\n"
"signal (\'GQL2U\', sprintf (\'Class for field \"%s\" do not support mutation\', var_name_only));\n"
"cls_type := iri_split (cls_type, null, 0, 1);\n"
"if (cls_type = \'Function\' and update_qry is null)\n"
"signal (\'GQL3U\', sprintf (\'SPARQL query for field \"%s\" is not specified\', var_name_only));\n"
"dict_put (dict, var_name, cls_type);\n"
"parent := vector (iri_to_id (cls), var_name, null);\n"
"}\n"
"if (gql_args (args))\n"
"{\n"
"declare pos int;\n"
"declare arg_name, arg_value, id_prop, id_field, id_iri, triples_vec, params any;\n"
"declare arg_iid, fld_iid iri_id_8;\n"
"vectorbld_init (params);\n"
"vectorbld_init (triples_vec);\n"
"fld_iid := GQL_IID (var_name_only);\n"
"id_prop := id_field := null;\n"
"for select \"prop0\", \"field0\" from (sparql select ?prop0 ?field0\n"
"where { graph ?:g_iid { ?prop0 rdfs:domain `iri(?:cls)` ; gql:type gql:ID ; gql:field ?field0 . }}) dt0 do\n"
"{\n"
"id_prop := \"prop0\";\n"
"id_field := iri_split (\"field0\", null, 0, 1);\n"
"}\n"
"if (id_prop is null)\n"
"signal (\'GQL3U\', sprintf (\'Can not find id property for field \"%s\"\', var_name_only));\n"
"args := args[1];\n"
"if (not (pos := position (id_field, args)))\n"
"signal (\'GQL3U\', sprintf (\'The ID agrument for field \"%s\" not given\', var_name_only));\n"
"\n"
"id_iri := sprintf (iri_format, GQL_VALUE (variables, args[pos], \'RAW\'));\n"
"for (j := 0; j < length(args); j := j + 2)\n"
"{\n"
"arg_name := args[j];\n"
"arg_value := args[j + 1];\n"
"if (gql_var (arg_value))\n"
"arg_value := get_keyword (arg_value[1], variables, NULL);\n"
"arg_iid := GQL_IID (arg_name);\n"
"prop := null;\n"
"\n"
"GQL_DEBUG (pldbg_last_line (),sprintf (concat (\'sparql select * where { graph <%s> \',\n"
"\' { ?prop0 rdfs:domain <%s> ; gql:type ?tp0 ; gql:field <%s> . \',\n"
"\'  optional {  [] rdfs:domain <%s>  ; rdfs:range ?range ; gql:field <%s> . \',\n"
"\'  ?prop1 rdfs:domain ?range ; gql:field <%s> . } }}\'),\n"
"id_to_iri (g_iid), id_to_iri (cls), id_to_iri(arg_iid), id_to_iri (cls), id_to_iri(fld_iid), id_to_iri(arg_iid) ));\n"
"\n"
"for select \"prop0\", \"prop1\", \"tp0\" from (sparql select ?prop0 ?prop1 ?tp0 where { graph ?:g_iid {\n"
"?prop0 rdfs:domain `iri(?:cls)` ; gql:type ?tp0 ; gql:field ?:arg_iid .\n"
"optional {  [] rdfs:domain `iri(?:cls)`  ; rdfs:range ?range ; gql:field ?:fld_iid .\n"
"?prop1 rdfs:domain ?range ; gql:field ?:arg_iid .\n"
"}\n"
"}}) dt0 do\n"
"{\n"
"prop := coalesce (\"prop1\", \"prop0\");\n"
"tp := iri_split (\"tp0\", null, 0, 1);\n"
"}\n"
"if (prop is null)\n"
"signal (\'GQL1U\', sprintf (\'Can not find property for argument \"%s\"\', arg_name));\n"
"if (cls_type = \'Function\')\n"
"vectorbld_concat_acc (params, vector (concat (\':\', arg_name), arg_value));\n"
"else\n"
"{\n"
"arg_name := concat (prefix, var_name_only, \'·\', arg_name);\n"
"vectorbld_acc (triples_vec, vector (id_iri, prop, GQL_VALUE (variables, arg_value, tp), arg_name));\n"
"}\n"
"}\n"
"if (cls_type = \'Function\')\n"
"{\n"
"declare meta any;\n"
"vectorbld_concat_acc (params, vector (\':ID\', id_iri));\n"
"if (__tag (update_qry) = __tag of rdf_box)\n"
"update_qry := rdf_box_data (update_qry);\n"
"update_qry := concat (\'SPARQL \', update_qry);\n"
"exec_metadata (update_qry, null, null, null, meta);\n"
"foreach (varchar parm in meta) do\n"
"{\n"
"if (1 > position (parm, params))\n"
"vectorbld_concat_acc (params, vector (parm, null));\n"
"}\n"
"http (update_qry, triples);\n"
"http (\';\', triples);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_final (triples_vec);\n"
"GQL_BUILD_SPARUL (data_graph, sparql_operation, triples_vec, triples);\n"
"if (sparql_operation = \'UPDATE\')\n"
"{\n"
"vectorbld_acc (upd_params, vector ());\n"
"}\n"
"}\n"
"vectorbld_final (params);\n"
"vectorbld_acc (upd_params, params);\n"
"}\n"
"if (isvector (tree))\n"
"GQL_UPDATE (g_iid, tree, variables, parent, triples, upd_params, dict);\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"GQL_UPDATE (g_iid, elm, variables, parent, triples, upd_params, dict);\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"--src graphql.sql:733\n"
;

static const char *proc16 = 
"#line 900 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_BUILD_SPARUL (inout data_graph varchar, in sparql_operation varchar, inout triples_vec any, inout ses any)\n"
"{\n"
"if (upper (sparql_operation) = \'UPDATE\')\n"
"{\n"
"http (sprintf (\'SPARQL WITH  <%s> DELETE { \\n\', data_graph), ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"http (sprintf (\' <%s> <%s> ?%s . \\n\', triple[0], triple[1], triple[3]), ses);\n"
"}\n"
"http (\'} \\n\', ses);\n"
"http (\' WHERE { \\n\', ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"http (sprintf (\' <%s> <%s> ?%s . \\n\', triple[0], triple[1], triple[3]), ses);\n"
"}\n"
"http (\'};\', ses);\n"
"sparql_operation := \'INSERT\';\n"
"}\n"
"http (sprintf (\'SPARQL WITH  <%s> %s { \\n\', data_graph, sparql_operation), ses);\n"
"foreach (any triple in triples_vec) do\n"
"{\n"
"http (sprintf (\' <%s> <%s> %s . \\n\', triple[0], triple[1], triple[2]), ses);\n"
"}\n"
"http (\'};\', ses);\n"
"\n"
"}\n"
"--src graphql.sql:898\n"
;

static const char *proc17 = 
"#line 929 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_ERROR (in ses any, in code varchar, in message varchar, in details varchar)\n"
"{\n"
"declare error, error_text varchar;\n"
"declare lines any;\n"
"declare line_no int;\n"
"error := regexp_match (\'GQL01: GRAPHQL parser failed:.* at line ([0-9]+)\', message);\n"
"error_text := regexp_match (\'[^\\\\n\\\\r]*\', message);\n"
"lines := sprintf_inverse (error, \'%s line %d\', 0);\n"
"if (isvector (lines))\n"
"line_no := lines[1];\n"
"http (\'{ \"errors\": [ { \\n\', ses);\n"
"http (\'\\t\\t \"message\":\"\', ses); http_escape (case when error is not null then error else error_text end, 11, ses); http (\'\", \\n\', ses);\n"
"if (line_no > 0)\n"
"http (sprintf (\'\\t\\t \"locations\": [ { \"line\": %d } ], \\n\', line_no), ses);\n"
"http (sprintf (\'\\t\\t \"extensions\": { \"code\":\"%s\", \"timestamp\":\"%s\"\', code, date_rfc1123(curdatetime())), ses);\n"
"if (details is not null)\n"
"{\n"
"http (sprintf (\', \"details\":\"%s\"\', details), ses);\n"
"}\n"
"if (sys_stat (\'callstack_on_exception\'))\n"
"{\n"
"http (\', \"callstack\":\"\', ses);\n"
"http_escape (message, 14, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'} \\n\', ses);\n"
"http (\'} ] }\\n\', ses);\n"
"}\n"
"--src graphql.sql:927\n"
;

static const char *proc18 = 
"#line 961 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_TRANSFORM (in str varchar, in g_iid varchar,\n"
"inout tree any, inout triples any, inout patterns any, inout vals any, inout clauses any, inout dict any)\n"
"{\n"
"#pragma prefix gql: <http://www.openlinksw.com/schemas/graphql#>\n"
"declare qry, inference_name, data_graph any;\n"
"qry := string_output ();\n"
"if (length (triples) < 1)\n"
"signal (\'GQLEX\', \'The query not generates any statements\');\n"
"\n"
"inference_name := (sparql select ?inference_name where { graph ?:g_iid { gql:Map gql:inferenceName ?inference_name }});\n"
"if (inference_name is not null)\n"
"http (sprintf (\'define input:inference \"%s\" \', inference_name), qry);\n"
"\n"
"data_graph := (sparql select ?data_graph where { graph ?:g_iid { gql:Map gql:dataGraph ?data_graph }});\n"
"if (data_graph is not null)\n"
"http (sprintf (\'define input:default-graph-uri \"%s\" \\n\', data_graph), qry);\n"
"http (\'define output:format \"_UDBC_\" \\n\', qry);\n"
"http (\'PREFIX : <#> \\n\', qry);\n"
"http (\'CONSTRUCT { \\n\', qry);\n"
"http (triples, qry);\n"
"http (\'} \\n\', qry);\n"
"http (sprintf (\'WHERE { \\n\'), qry);\n"
"http (patterns, qry);\n"
"http (vals, qry);\n"
"http (\'}\', qry);\n"
"http (\'\\n\', qry);\n"
"http (clauses, qry);\n"
"return string_output_string (qry);\n"
"}\n"
"--src graphql.sql:959\n"
;

static const char *proc19 = 
"#line 993 \"[executable]/graphql.sql\"\n"
"create function GQL_RDF_NIL() returns IRI_ID_8\n"
"{\n"
"return iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil\');\n"
"}\n"
"--src graphql.sql:991\n"
;

static const char *proc20 = 
"#line 1006 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PREPARE_JSON_TREE (inout tree any, inout dict any, inout rset any)\n"
"{\n"
"declare row_no, len, inx int;\n"
"declare vect any;\n"
"\n"
"if (not isvector(rset))\n"
"signal (\'GQLX9\', \'No results returned, report statement\');\n"
"\n"
"len := length (rset);\n"
"vectorbld_init (vect);\n"
"for (row_no := 0; row_no < len; row_no := row_no + 1)\n"
"{\n"
"declare s, p, o varchar;\n"
"declare sp, spo, rw any;\n"
"declare pos int;\n"
"rw := aref_set_0 (rset, row_no);\n"
"s := aref_set_0 (rw, 0);\n"
"s := iri_to_id (s);\n"
"p := aref_set_0 (rw, 1);\n"
"o := aref_set_0 (rw, 2);\n"
"if (1 = __box_flags (o))\n"
"o := iri_to_id (o);\n"
"if (o = GQL_RDF_NIL())\n"
"o := null;\n"
"sp := composite (s, iri_to_id (p));\n"
"if (0 = (pos := position (sp, vect)))\n"
"{\n"
"vectorbld_init (spo);\n"
"vectorbld_concat_acc (spo, vector (o));\n"
"vectorbld_concat_acc (vect, vector (sp, spo));\n"
"}\n"
"else\n"
"{\n"
"spo := aref_set_0 (vect, pos);\n"
"vectorbld_concat_acc (spo, vector (o));\n"
"aset_zap_arg (vect, pos, spo);\n"
"}\n"
"}\n"
"vectorbld_final (vect);\n"
"len := length (vect);\n"
"for (inx := 0; inx < len; inx := inx + 2)\n"
"{\n"
"declare spo any;\n"
"spo := aref_set_0 (vect, inx+1);\n"
"vectorbld_final (spo);\n"
"aset_zap_arg (vect, inx+1, spo);\n"
"}\n"
"return vect;\n"
"}\n"
"--src graphql.sql:1004\n"
;

static const char *proc21 = 
"#line 1057 \"[executable]/graphql.sql\"\n"
"create function GQL_PRINT_JSON_VAL (inout val any, inout ses any)\n"
"{\n"
"http (\'\"\', ses);\n"
"if (__tag of rdf_box = __tag (val))\n"
"{\n"
"__rdf_box_make_complete (val);\n"
"val := rdf_box_data (val);\n"
"}\n"
"if (isiri_id (val))\n"
"val := id_to_iri (val);\n"
"if (__tag of datetime = __tag (val))\n"
"__rdf_long_to_ttl (val, ses);\n"
"else\n"
"http_escape (val, 14, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"--src graphql.sql:1055\n"
;

static const char *proc22 = 
"#line 1075 \"[executable]/graphql.sql\"\n"
"create procedure GQL_SERIALIZE_TREE_INT (inout ses any, inout jt any, in tree any, inout dict any, in parent any, in pval any)\n"
"{\n"
"declare i int;\n"
"declare elm, args any;\n"
"declare var_name, var_name_only varchar;\n"
"\n"
"if (not isvector (tree))\n"
"{\n"
"signal (\'GQLE0\', \'Serialize called with scalar\');\n"
"return;\n"
"}\n"
"if (gql_field (tree))\n"
"{\n"
"declare is_array int;\n"
"declare cls, prop, tp, parent_name, parent_cls, prefix, value, alias varchar;\n"
"declare sp, spo any;\n"
"\n"
"parent_cls := cls := null;\n"
"is_array := 0;\n"
"\n"
"if (parent is not null)\n"
"{\n"
"parent_name := parent;\n"
"prefix := parent_name || \'·\';\n"
"}\n"
"else\n"
"prefix := \'#\';\n"
"\n"
"var_name_only := var_name := tree[1];\n"
"alias := tree[4];\n"
"if (isstring (alias))\n"
"var_name_only := alias;\n"
"tree := tree[3];\n"
"var_name := prefix || var_name;\n"
"if (isvector (tree))\n"
"{\n"
"tp := dict_get (dict, subseq (var_name, 1));\n"
"if (tp = \'Array\')\n"
"is_array := 1;\n"
"sp := composite (pval, iri_to_id (var_name));\n"
"spo := get_keyword (sp, jt);\n"
"parent := var_name;\n"
"}\n"
"else\n"
"{\n"
"declare val any;\n"
"sp := composite (pval, iri_to_id (var_name));\n"
"tp := dict_get (dict, subseq (var_name, 1));\n"
"spo := get_keyword (sp, jt);\n"
"if (spo is null)\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, (case when tp = \'Boolean\' then \'false\' else \'null\' end)), ses);\n"
"else if (isvector (spo) and tp = \'Array\')\n"
"{\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"http (\'[\', ses);\n"
"for (i := 0; i < length(spo); i := i + 1)\n"
"{\n"
"val := spo[i];\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"GQL_PRINT_JSON_VAL (val, ses);\n"
"}\n"
"http (\']\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare dt any;\n"
"val := spo[0];\n"
"if (__tag of rdf_box = __tag (val))\n"
"dt := rdf_cache_id_to_name (\'t\', rdf_box_type (val));\n"
"if (dt <> 0 and dt = \'http://www.w3.org/2001/XMLSchema#boolean\')\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, (case val when 0 then \'false\' else \'true\' end)), ses);\n"
"else if (val is null)\n"
"http (sprintf (\'\"%s\":null\', var_name_only), ses);\n"
"else if (isfinitenumeric (val))\n"
"http (sprintf (\'\"%s\":%s\', var_name_only, DB.DBA.SYS_SQL_VAL_PRINT (val)), ses);\n"
"else\n"
"{\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"GQL_PRINT_JSON_VAL (val, ses);\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (isvector (tree))\n"
"{\n"
"http (sprintf (\'\"%s\":\', var_name_only), ses);\n"
"if (length (spo) = 1 and isnull(spo[0]) or spo is null)\n"
"{\n"
"if (is_array)\n"
"http (\'[]\', ses);\n"
"else\n"
"http (\'null\', ses);\n"
"}\n"
"else\n"
"{\n"
"if (is_array) http (\'[\', ses);\n"
"for (i := 0; i < length(spo); i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"http (\'{\', ses);\n"
"GQL_SERIALIZE_TREE_INT (ses, jt, tree, dict, parent, spo[i]);\n"
"http (\'}\', ses);\n"
"}\n"
"if (is_array) http (\']\', ses);\n"
"}\n"
"}\n"
"}\n"
"else if (length (tree) and isvector (tree[0]))\n"
"{\n"
"for (i := 0; i < length(tree); i := i + 1)\n"
"{\n"
"elm := tree[i];\n"
"if (i > 0)\n"
"http (\',\', ses);\n"
"GQL_SERIALIZE_TREE_INT (ses, jt, elm, dict, parent, pval);\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"--src graphql.sql:1073\n"
;

static const char *proc23 = 
"#line 1198 \"[executable]/graphql.sql\"\n"
"create procedure GQL_JSON_SERIALIZE_TREE (inout jt any, inout tree any, inout dict any)\n"
"{\n"
"declare ses any;\n"
"declare parent varchar;\n"
"\n"
"parent := null;\n"
"ses := string_output ();\n"
"http (\'{\"data\":{\',ses);\n"
"GQL_SERIALIZE_TREE_INT (ses, jt, tree, dict, parent, iri_to_id (\'#data\'));\n"
"http (\'}}\',ses);\n"
"return ses;\n"
"}\n"
"--src graphql.sql:1196\n"
;

static const char *tbl0 = 
"create table DB.DBA.GQL_CACHE (GC_ID varchar primary key, GC_TS timestamp, GC_QUERY long varchar, GC_VARS any, GC_RESULT long varchar) if not exists\n";

static const char *proc24 = 
"#line 1215 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_CHECK (inout g_iid iri_id_8, inout qry varchar, inout variables any)\n"
"{\n"
"declare id varchar;\n"
"declare ses any;\n"
"if (g_iid <> GQL_SCH_IID ())\n"
"return NULL;\n"
"id := bin2hex (xenc_digest (concat (qry, serialize (variables)), \'sha256\'));\n"
"for select GC_RESULT from DB.DBA.GQL_CACHE where GC_ID = id do\n"
"{\n"
"ses := string_output ();\n"
"http (GC_RESULT, ses);\n"
"return ses;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src graphql.sql:1213\n"
;

static const char *proc25 = 
"#line 1232 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_STORE (inout g_iid iri_id_8, inout qry varchar, inout ses any, inout variables any)\n"
"{\n"
"declare id varchar;\n"
"if (g_iid <> GQL_SCH_IID ())\n"
"return;\n"
"id := bin2hex (xenc_digest (concat (qry, serialize (variables)), \'sha256\'));\n"
"insert into DB.DBA.GQL_CACHE (GC_ID, GC_QUERY, GC_RESULT, GC_VARS) values (id, qry, ses, variables);\n"
"commit work;\n"
"}\n"
"--src graphql.sql:1230\n"
;

static const char *proc26 = 
"#line 1243 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CACHE_ENABLE (in enable int)\n"
"{\n"
"if (enable)\n"
"{\n"
"registry_set (\'graphql-use-cache\',\'1\');\n"
"}\n"
"else\n"
"{\n"
"registry_set (\'graphql-use-cache\',\'0\');\n"
"delete from DB.DBA.GQL_CACHE;\n"
"commit work;\n"
"}\n"
"}\n"
"--src graphql.sql:1241\n"
;

static const char *proc27 = 
"#line 1258 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GQL_DISPATCH (in str varchar, in variables any, in g_iri varchar, in transform_only int := 0,\n"
"in use_cache int := 0, in timeout int := 0, in operation_name varchar := null)\n"
"{\n"
"declare qry, ses, tree, triples, patterns, vals, clauses, updates, g_iid any;\n"
"declare meta, rset, dict, upd_params any;\n"
"declare json_tree any;\n"
"\n"
"connection_set (\'__intro\', 0);\n"
"g_iid := iri_to_id (g_iri);\n"
"dict := dict_new (31);\n"
"GQL_PARSE_REQUEST (str, variables, g_iid, tree, triples, patterns, vals, clauses, updates, upd_params, dict, operation_name);\n"
"qry := GQL_TRANSFORM (str, g_iid, tree, triples, patterns, vals, clauses, dict);\n"
"if (transform_only = 2)\n"
"return updates;\n"
"if (transform_only)\n"
"return qry;\n"
"if (use_cache)\n"
"{\n"
"ses := GQL_CACHE_CHECK (g_iid, str, variables);\n"
"if (ses is not null)\n"
"return ses;\n"
"}\n"
"GQL_EXEC_UPDATES (updates, upd_params);\n"
"GQL_EXEC (tree, qry, meta, rset, timeout);\n"
"json_tree := GQL_PREPARE_JSON_TREE (tree, dict, rset);\n"
"ses := GQL_JSON_SERIALIZE_TREE (json_tree, tree, dict);\n"
"if (use_cache)\n"
"{\n"
"GQL_CACHE_STORE (g_iid, str, ses, variables);\n"
"}\n"
"return ses;\n"
"}\n"
"--src graphql.sql:1256\n"
;

static const char *proc28 = 
"#line 1293 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GRAPHQL.GRAPHQL.auth (in path any, in params any, in lines any) __SOAP_HTTP \'application/json\'\n"
"{\n"
"return \'{\"error\":\"Unauthorized\"}\';\n"
"}\n"
"--src graphql.sql:1291\n"
;

static const char *proc29 = 
"#line 1300 \"[executable]/graphql.sql\"\n"
"create procedure\n"
"GRAPHQL.GRAPHQL.query (in query varchar := NULL, in variables varchar := null, in timeout int := 0) __SOAP_HTTP \'application/json\'\n"
"{\n"
"declare content_type, g_iri varchar;\n"
"declare lines any;\n"
"declare error_details, operation_name varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"error_details := null;\n"
"if (__SQL_MESSAGE like \'%:SECURITY:%\' or __SQL_MESSAGE like \'RPERM:%\')\n"
"{\n"
"if (not (is_https_ctx()))\n"
"error_details := \'The connection is unsecure, please consider using HTTPS.\';\n"
"http_status_set (401);\n"
"}\n"
"else\n"
"http_status_set (400);\n"
"GQL_ERROR (null, __SQL_STATE, __SQL_MESSAGE, error_details);\n"
"return \'\';\n"
"};\n"
"if (http_request_get (\'REQUEST_METHOD\') = \'OPTIONS\')\n"
"{\n"
"http_status_set (200);\n"
"return \'\';\n"
"}\n"
"lines := http_request_header ();\n"
"content_type := http_request_header (lines, \'Content-Type\', null, \'application/octet-stream\');\n"
"operation_name := null;\n"
"if (query is null)\n"
"{\n"
"declare jt any;\n"
"query := string_output_string (http_body_read ());\n"
"if (not length (query))\n"
"signal (\'GQLIN\', \'POST body is missing\');\n"
"if (content_type <> \'application/json\')\n"
"{\n"
"http_status_set (400);\n"
"return \'Content-Type is not specified or query is not supplied\';\n"
"}\n"
"jt := json_parse (query);\n"
"query := get_keyword (\'query\', jt, NULL);\n"
"if (variables is null)\n"
"variables := get_keyword (\'variables\', jt, NULL);\n"
"operation_name := get_keyword (\'operationName\', jt, NULL);\n"
"}\n"
"if (not length (query))\n"
"signal (\'GQLIN\', \'Query is missing.\');\n"
"set_qualifier (\'DB\');\n"
"g_iri := registry_get (\'graphql-default-schema-uri\', \'urn:graphql:default\');\n"
"\n"
"http (GQL_DISPATCH (query, variables, g_iri, 0, atoi (registry_get (\'graphql-use-cache\', \'0\')), timeout, operation_name));\n"
"return \'\';\n"
"}\n"
"--src graphql.sql:1298\n"
;

static const char *proc30 = 
"#line 1355 \"[executable]/graphql.sql\"\n"
"create procedure DB.DBA.HP_AUTH_GRAPHQL_USER (in realm varchar)\n"
"{\n"
"declare val_serviceId, val_sid, val_realm, val_uname, val_webidGraph varchar;\n"
"declare val_isRealUser integer;\n"
"declare val_cert any;\n"
"val_realm := null;\n"
"if (VAD_CHECK_VERSION (\'VAL\') is not null)\n"
"{\n"
"val_webidGraph := concat (\'urn:gql:auth:\', uuid());\n"
"VAL.DBA.get_authentication_details_for_connection (\n"
"sid=>val_sid,\n"
"serviceId=>val_serviceId,\n"
"uname=>val_uname,\n"
"isRealUser=>val_isRealUser,\n"
"realm=>val_realm,\n"
"cert=>val_cert,\n"
"webidGraph=>val_webidGraph);\n"
"sparql clear graph ?:val_webidGraph;\n"
"if (not VAL.DBA.is_admin_user (val_uname) and sys_stat (\'enable_g_in_sec\') = 1)\n"
"{\n"
"connection_set (\'SPARQLUserId\', \'VAL_SPARQL_ADMIN_G_CTX\');\n"
"VAL.DBA.set_graph_context_query (serviceId=>val_serviceId, realm=>val_realm, certificate=>val_cert);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.HTTP_AUTH_CHECK_USER (realm, 1, 0);\n"
"}\n"
"return 1;\n"
"}\n"
"--src graphql.sql:1353\n"
;

static const char *other2 = 
"USER_CREATE (\'GRAPHQL\', sha1_digest (uuid ()), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'GRAPHQL\'))\n";
static const char *other3 = 
"GRANT EXECUTE ON GRAPHQL.GRAPHQL.query TO GRAPHQL\n";
static const char *other4 = 
"EXEC_STMT (\'GRANT SPARQL_SELECT to GRAPHQL\', 0)\n";
static const char *other5 = 
"DB.DBA.ADD_DEFAULT_VHOST (\n"
"lpath=>\'/graphql\',\n"
"ppath=>\'/SOAP/Http/query\',\n"
"soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\',\n"
"realm=>\'GraphQL\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\'),\n"
"overwrite=>1\n"
")\n";
static const char *other6 = 
"DB.DBA.VHOST_REMOVE (lpath=>\'/graphql\')\n";
static const char *other7 = 
"DB.DBA.VHOST_DEFINE (lpath=>\'/graphql\', ppath=>\'/SOAP/Http/query\', soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\', realm=>\'GraphQL\', sec=>\'basic\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\')\n"
")\n";
static const char *other8 = 
"DB.DBA.VHOST_REMOVE (vhost=>\'*sslini*\', lhost=>\'*sslini*\', lpath=>\'/graphql\')\n";
static const char *other9 = 
"DB.DBA.VHOST_DEFINE (vhost=>\'*sslini*\', lhost=>\'*sslini*\', lpath=>\'/graphql\', ppath=>\'/SOAP/Http/query\', soap_user=>\'GRAPHQL\',\n"
"auth_fn=>\'DB.DBA.HP_AUTH_GRAPHQL_USER\', realm=>\'GraphQL\', sec=>\'basic\',\n"
"opts=>vector (\'cors\',\'*\',\'cors_allow_headers\', \'*\')\n"
")\n";
static const char *proc31 = 
"#line 1425 \"[executable]/graphql.sql\"\n"
"create function GQL_XSD_IRI (in n varchar)\n"
"{\n"
"return concat (\'http://www.w3.org/2001/XMLSchema#\', n);\n"
"}\n"
"--src graphql.sql:1423\n"
;

static const char *proc32 = 
"#line 1431 \"[executable]/graphql.sql\"\n"
"create procedure GQL_GET_NS (inout ns_dict any, inout ns_uri any, inout ns_last int, inout ses any)\n"
"{\n"
"declare ns varchar;\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"if (ns is null)\n"
"{\n"
"ns := sprintf (\'ns%d\', ns_last);\n"
"dict_put (ns_dict, ns_uri, ns);\n"
"http (sprintf (\'@prefix %s: <%s> .\\n\', ns, ns_uri), ses);\n"
"ns_last := ns_last + 1;\n"
"}\n"
"return ns;\n"
"}\n"
"--src graphql.sql:1429\n"
;

static const char *proc33 = 
"#line 1446 \"[executable]/graphql.sql\"\n"
"create procedure GQL_CREATE_TYPE_SCHEMA (in g_iri varchar)\n"
"{\n"
"declare ses, out_ses, ns_dict, class_dict, owl_classes, objects, typed_fields, skip any;\n"
"declare ns_last int;\n"
"ns_dict := dict_new (11);\n"
"class_dict := dict_new (11);\n"
"skip := dict_new (11);\n"
"ses := string_output ();\n"
"out_ses := string_output ();\n"
"http (\'@prefix : <http://www.openlinksw.com/schemas/graphql/intro#> . \\n\', out_ses);\n"
"http (\'@prefix gql: <http://www.openlinksw.com/schemas/graphql#> . \\n\', out_ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> . \\n\', out_ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \\n\', out_ses);\n"
"http (\' \\n\', ses);\n"
"objects := dict_new (11);\n"
"ns_last := 0;\n"
"for select * from (sparql select distinct ?gObject ?owlClass ?gType where { graph `iri(?:g_iri)` {\n"
"?gObject gql:type ?gType ; gql:rdfClass ?owlClass .\n"
"filter (?gType in (gql:Object, gql:Array)) .\n"
"}}) dt0 do\n"
"{\n"
"declare class_name, type_class_name, owl_class_name, gql_type_name, parent_type_name, kind, ns_uri, ns, fns varchar;\n"
"declare any_field int;\n"
"class_name := iri_split (\"gObject\", 0, 0, 1);\n"
"owl_class_name := iri_split (\"owlClass\", 0, 0, 1);\n"
"dict_put (class_dict, iri_to_id (\"owlClass\"), 1);\n"
"ns_uri := iri_split (\"owlClass\", 0);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"gql_type_name := iri_split (\"gType\", 0, 0, 1);\n"
"if (gql_type_name = \'Object\')\n"
"kind := \'OBJECT\';\n"
"else\n"
"kind := \'LIST\';\n"
"type_class_name := concat (\'typeof_\', class_name);\n"
"http (sprintf (\'%s:%s rdf:type gql:%s ;\\n\', ns, class_name, gql_type_name) , ses);\n"
"http (sprintf (\'        :name \"%s\" ;\\n\', class_name), ses);\n"
"http (sprintf (\'        :kind \"OBJECT\" ;\\n\'), ses);\n"
"http (sprintf (\'        :type %s:%s ;\\n\', ns, type_class_name), ses);\n"
"http (sprintf (\'        :fields %s:iri ;\\n\', ns), ses);\n"
"http (sprintf (\'        :args %s:iri ;\\n\', ns), ses);\n"
"dict_put (objects, concat (ns, \':\', class_name), 1);\n"
"for select * from (sparql select ?prop ?rangeType ?pgType ?field where { graph `iri(?:g_iri)` {\n"
"?prop rdfs:domain ?:owlClass ; gql:field ?field  ; rdfs:range ?rangeType ; gql:type ?pgType . }}) dt0 do\n"
"{\n"
"declare field_name, type_class, range_class varchar;\n"
"field_name := iri_split (\"field\", 0, 0, 1);\n"
"type_class := iri_split (\"pgType\", 0, 0, 1);\n"
"range_class := \"rangeType\";\n"
"if (type_class = \'Scalar\' or type_class = \'ID\')\n"
"{\n"
"ns_uri := iri_split (\"prop\", 0);\n"
"fns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"http (sprintf (\'        :args %s:%s ; \\n\', fns, field_name), ses);\n"
"}\n"
"else\n"
"{\n"
"if ((sparql ask where { graph `iri(?:g_iri)` { gql:Map gql:schemaObjects ?cls . ?cls gql:rdfClass `iri(?:range_class)` . }}))\n"
"{\n"
"ns_uri := iri_split (\"rangeType\", 0);\n"
"fns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"}\n"
"else\n"
"{\n"
"sql_warning (\'01V01\', \'GQLW0\', sprintf (\'Ref. property %s to undefined class %s.\', \"prop\", \"rangeType\"));\n"
"dict_put (skip, \"prop\", 1);\n"
"goto skip_fld;\n"
"}\n"
"}\n"
"http (sprintf (\'        :fields %s:%s ; \\n\', fns, field_name), ses);\n"
"skip_fld:;\n"
"}\n"
"http (sprintf (\'        :isDeprecated \"false\"^^xsd:boolean . \\n\\n\'), ses);\n"
"parent_type_name := \'rdf:nil\';\n"
"if (kind = \'LIST\')\n"
"{\n"
"declare parent_class_iri varchar;\n"
"parent_class_iri := (sparql select ?parentClass where { graph `iri(?:g_iri)`\n"
"{ ?parentClass gql:type gql:Object ; gql:rdfClass `iri(?:owlClass)` . }});\n"
"parent_type_name := iri_split (parent_class_iri, 0, 0, 1);\n"
"parent_type_name := concat (ns, \':\', parent_type_name);\n"
"http (sprintf (\'%s:%s :kind \"OBJECT\"; :name \"%s\"; :type [ :kind \"LIST\"; :ofType %s ] . \\n\',\n"
"ns, type_class_name, class_name, parent_type_name), ses);\n"
"}\n"
"else\n"
"http (sprintf (\'%s:%s :kind \"OBJECT\" ; :name \"%s\" ; :ofType rdf:nil . \\n\', ns, type_class_name, class_name), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"}\n"
"\n"
"owl_classes := dict_list_keys (class_dict, 1);\n"
"foreach (iri_id_8 owlClass in owl_classes) do\n"
"{\n"
"declare field_name, ns_uri, ns, type_def, type_class varchar;\n"
"http (sprintf (\'\\n\\n\'), ses);\n"
"\n"
"ns_uri := iri_split (id_to_iri (owlClass), 0);\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"http (sprintf (\'%s:iri rdf:type gql:Scalar ;\\n\', ns), ses);\n"
"http (sprintf (\'      :name \"iri\" ;\\n\'), ses);\n"
"http (sprintf (\'      :description \"An IRI (Internationalized Resource Identifier) within an RDF graph representing the field\" ;\\n\'), ses);\n"
"http (sprintf (\'      :type  :IRI ;\\n\'), ses);\n"
"http (sprintf (\'      :isDeprecated \"false\"^^xsd:boolean . \\n\\n\'), ses);\n"
"for select * from (sparql select ?prop ?rangeType ?pgType ?field where { graph `iri(?:g_iri)` {\n"
"?prop rdfs:domain ?:owlClass ; gql:field ?field  ; rdfs:range ?rangeType ; gql:type ?pgType . }}) dt0 do\n"
"{\n"
"if (dict_get (skip, \"prop\"))\n"
"goto skip_prop;\n"
"field_name := iri_split (\"field\", 0, 0, 1);\n"
"type_class := iri_split (\"pgType\", 0, 0, 1);\n"
"ns_uri := iri_split (\"prop\", 0);\n"
"ns := dict_get (ns_dict, ns_uri);\n"
"ns := GQL_GET_NS (ns_dict, ns_uri, ns_last, out_ses);\n"
"\n"
"if (type_class = \'Scalar\' or type_class = \'ID\')\n"
"{\n"
"if (\"rangeType\" = GQL_XSD_IRI (\'string\'))\n"
"type_def := \':String\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'int\'))\n"
"type_def := \':Int\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'float\'))\n"
"type_def := \':Float\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'numeric\'))\n"
"type_def := \':Float\';\n"
"else if (\"rangeType\" = GQL_XSD_IRI (\'boolean\'))\n"
"type_def := \':Boolean\';\n"
"else if (\"rangeType\" in (GQL_XSD_IRI (\'date\'), GQL_XSD_IRI (\'dateTime\'), GQL_XSD_IRI (\'time\')))\n"
"type_def := \':DateTime\';\n"
"else\n"
"type_def := \':String\';\n"
"if (type_class = \'ID\')\n"
"type_def := sprintf (\'[ :kind \"NON_NULL\" ; :ofType %s ]\', type_def);\n"
"type_class := \'Scalar\';\n"
"http (sprintf (\'%s:%s rdf:type gql:%s ;\\n\', ns, field_name, type_class), ses);\n"
"http (sprintf (\'      :name \"%s\" ;\\n\', field_name), ses);\n"
"http (sprintf (\'      :type %s ;\\n\', type_def), ses);\n"
"http (sprintf (\'      :isDeprecated \"false\"^^xsd:boolean . \\n\\n\'), ses);\n"
"}\n"
"else\n"
"{\n"
"declare range_class_name varchar;\n"
"range_class_name := iri_split (\"rangeType\", 0, 0, 1);\n"
"http (sprintf (\'# Object Ref `%s` of `%s`\\n\\n\', field_name, \"rangeType\"), ses);\n"
"http (sprintf (\'%s:%s rdf:type gql:%s ;\\n\', ns, field_name, type_class), ses);\n"
"http (sprintf (\'      :name \"%s\" ;\\n\', field_name), ses);\n"
"http (sprintf (\'      :kind \"OBJECT\" ;\\n\'), ses);\n"
"http (sprintf (\'      :type %s:%s .\\n\\n\', ns, range_class_name), ses);\n"
"}\n"
"skip_prop:;\n"
"}\n"
"}\n"
"typed_fields := dict_list_keys (objects, 1);\n"
"if (length (typed_fields))\n"
"{\n"
"declare any_field int;\n"
"http (\':Query :fields \', ses);\n"
"any_field := 0;\n"
"foreach (varchar fld in typed_fields) do\n"
"{\n"
"any_field := any_field + 1;\n"
"if (any_field > 1)\n"
"http (\',\', ses);\n"
"http (sprintf (\' %s\', fld), ses);\n"
"}\n"
"http (\'.\\n\', ses);\n"
"http (\':__schema :types \', ses);\n"
"any_field := 0;\n"
"foreach (varchar fld in typed_fields) do\n"
"{\n"
"any_field := any_field + 1;\n"
"if (any_field > 1)\n"
"http (\',\', ses);\n"
"http (sprintf (\' %s\', fld), ses);\n"
"}\n"
"http (\'.\\n\', ses);\n"
"}\n"
"http (ses, out_ses);\n"
"return out_ses;\n"
"}\n"
"--src graphql.sql:1444\n"
;

static const char *other10 = 
"DB.DBA.RDF_GRAPH_GROUP_CREATE (\'urn:graphql:intro:group\', 1)\n";
static const char *proc34 = 
"#line 1629 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_LOAD (in src_iri varchar, in target_iri varchar, in force int := 0)\n"
"{\n"
"declare str varchar;\n"
"str := DB.DBA.XML_URI_GET (src_iri, \'\');\n"
"if (force)\n"
"{\n"
"GQL_INTRO_DEL (target_iri);\n"
"sparql clear graph ?:target_iri;\n"
"}\n"
"else if (exists (select 1 from DB.DBA.RDF_QUAD table option (index G) where G = iri_to_id (target_iri)))\n"
"signal (\'GQLIE\', \'The target graph is not empty, drop it first or use force=>1 to delete\');\n"
"DB.DBA.TTLP (str, \'\', target_iri);\n"
"GQL_INTRO_ADD (target_iri, \'urn:graphql:intro\');\n"
"}\n"
"--src graphql.sql:1627\n"
;

static const char *proc35 = 
"#line 1645 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_ADD (in g_iri varchar, in tgt_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare g_iids, tgt_iid any;\n"
"declare env, ses any;\n"
"\n"
"env := vector (0, 0, 0);\n"
"ses := string_output ();\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (\'urn:graphql:intro:group\', g_iri);\n"
"\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"\n"
"foreach (iri_id_8 g_iid in g_iids) do\n"
"{\n"
"for (select * from ( sparql define input:storage \"\" select ?s ?p ?o { graph ?:g_iid { ?s ?p ?o } } ) as sub option (loop)) do\n"
"{\n"
"http_nt_triple (env, \"s\", \"p\", \"o\", ses);\n"
"}\n"
"}\n"
"\n"
"tgt_iid := iri_to_id (tgt_iri);\n"
"delete from DB.DBA.RDF_QUAD where G = tgt_iid;\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_GS, index_only) where G = tgt_iid option (index_only, index RDF_QUAD_GS);\n"
"TTLP (ses, \'\', tgt_iri);\n"
"commit work;\n"
"}\n"
"--src graphql.sql:1643\n"
;

static const char *proc36 = 
"#line 1673 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INTRO_DEL (in g_iri varchar, in tgt_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare g_iids, tgt_iid any;\n"
"declare env, ses any;\n"
"\n"
"env := vector (0, 0, 0);\n"
"ses := string_output ();\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (\'urn:graphql:intro:group\', g_iri);\n"
"\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"\n"
"foreach (iri_id_8 g_iid in g_iids) do\n"
"{\n"
"for (select * from ( sparql define input:storage \"\" select ?s ?p ?o { graph ?:g_iid { ?s ?p ?o } } ) as sub option (loop)) do\n"
"{\n"
"http_nt_triple (env, \"s\", \"p\", \"o\", ses);\n"
"}\n"
"}\n"
"\n"
"tgt_iid := iri_to_id (tgt_iri);\n"
"delete from DB.DBA.RDF_QUAD where G = tgt_iid;\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_GS, index_only) where G = tgt_iid option (index_only, index RDF_QUAD_GS);\n"
"TTLP (ses, \'\', tgt_iri);\n"
"commit work;\n"
"}\n"
"--src graphql.sql:1671\n"
;

static const char *proc37 = 
"#line 1701 \"[executable]/graphql.sql\"\n"
"create procedure GQL_INIT_TYPE_SCHEMA (in force_clean int := 0)\n"
"{\n"
"declare version, latest_version varchar;\n"
"declare report varchar;\n"
"result_names (report);\n"
"\n"
"latest_version := \'0.9.1\';\n"
"if (force_clean = 2)\n"
"{\n"
"declare g_iids any;\n"
"g_iids := (select VECTOR_AGG (RGGM_MEMBER_IID)  from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'urn:graphql:intro:group\'));\n"
"foreach (any g_iid in g_iids) do\n"
"{\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (\'urn:graphql:intro:group\', id_to_iri (g_iid));\n"
"}\n"
"}\n"
"version := coalesce ((sparql select str(?version) from <urn:graphql:schema> { ?s a owl:Ontology ; virtrdf:version ?version }), \'0\');\n"
"if (lt (version, latest_version) or force_clean)\n"
"{\n"
"sparql clear graph <urn:graphql:schema>;\n"
"DB.DBA.TTLP (DB.DBA.XML_URI_GET (\'http://www.openlinksw.com/graphql/graphql-intro-schema.ttl\', \'\'), \'\', \'urn:graphql:schema\');\n"
"result (sprintf (\'Loaded GraphQL Type Schema, version %s\', latest_version));\n"
"}\n"
"else\n"
"{\n"
"result (sprintf (\'GraphQL Type Schema, version %s already loaded\', version));\n"
"}\n"
"version := coalesce ((sparql select str(?version) from <urn:graphql:intro> { ?s a void:Dataset ; virtrdf:version ?version }), \'0\');\n"
"if (lt (version, latest_version) or force_clean)\n"
"{\n"
"GQL_INTRO_DEL (\'urn:graphql:intro:core\');\n"
"sparql clear graph <urn:graphql:intro:core>;\n"
"DB.DBA.TTLP (DB.DBA.XML_URI_GET (\'http://www.openlinksw.com/graphql/graphql-intro.ttl\', \'\'), \'\', \'urn:graphql:intro:core\');\n"
"GQL_INTRO_ADD (\'urn:graphql:intro:core\');\n"
"result (sprintf (\'Loaded GraphQL Core Types Dataset, version %s\', latest_version));\n"
"}\n"
"else\n"
"{\n"
"result (sprintf (\'GraphQL Core Types Dataset, version %s already loaded\', version));\n"
"}\n"
"commit work;\n"
"}\n"
"--src graphql.sql:1699\n"
;

static const char *proc38 = 
"#line 1745 \"[executable]/graphql.sql\"\n"
"create procedure GQL_GENERATE_INTRO (in type_schema_doc varchar)\n"
"{\n"
"declare tree any;\n"
"declare i, len int;\n"
"declare ses, types any;\n"
"\n"
"tree := graphql_parse (type_schema_doc);\n"
"if (not isvector (tree) and tree[0] <> 512)\n"
"signal (\'GOWL0\', \'Not a GQL schema\');\n"
"\n"
"\n"
"tree := tree[1];\n"
"types := GQL_READ_TYPES (tree);\n"
"len := length (tree);\n"
"ses := string_output ();\n"
"http (\'@prefix : <http://www.openlinksw.com/schemas/graphql/intro#> . \\n\', ses);\n"
"http (\'@prefix gql: <http://www.openlinksw.com/schemas/graphql#> . \\n\', ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> . \\n\', ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \\n\', ses);\n"
"http (\' \\n\', ses);\n"
"\n"
"for (i := 0; i < len; i := i + 1)\n"
"{\n"
"GQL_TRAVERSE_NODE (aref (tree, i), ses, 0, types);\n"
"}\n"
"return ses;\n"
"}\n"
"--src graphql.sql:1743\n"
;

static const char *proc39 = 
"#line 1774 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PRINT_FIELD (inout ses any, in field_def any, inout types any)\n"
"{\n"
"declare type_def, name varchar;\n"
"declare description, args, op any;\n"
"op := aref (field_def, 0);\n"
"name := aref (field_def, 1);\n"
"if (op = 1007)\n"
"{\n"
"args := 0;\n"
"type_def := aref (field_def, 2);\n"
"description := aref (field_def, 5);\n"
"}\n"
"else if (op = 1006)\n"
"{\n"
"args := aref (field_def, 2);\n"
"description := aref (field_def, 5);\n"
"type_def := aref (field_def, 3);\n"
"}\n"
"else\n"
"signal (\'22023\', \'Invalid field type\');\n"
"http (sprintf (\'\\t [ :name \"%s\" \', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'; :description \', ses);\n"
"http_nt_object (description, ses);\n"
"}\n"
"http (\'; :type \', ses);\n"
"GQL_PRINT_TYPE (ses, type_def, op, types);\n"
"if (isvector (args) and length (args))\n"
"{\n"
"declare i int;\n"
"declare arg, arg_name, arg_type any;\n"
"http (\';\\n\', ses);\n"
"for (i := 0; i < length (args); i := i + 1)\n"
"{\n"
"arg := args[i];\n"
"arg_name := arg[1];\n"
"arg_type := arg[2];\n"
"if (i > 0)\n"
"http (\';\\n\', ses);\n"
"http (\'\\t\\t :args [ \', ses);\n"
"http (sprintf (\' :name \"%s\" ; :type \', arg_name), ses);\n"
"GQL_PRINT_TYPE (ses, arg_type, op, types);\n"
"http (\' ]\', ses);\n"
"}\n"
"}\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"--src graphql.sql:1772\n"
;

static const char *proc40 = 
"#line 1825 \"[executable]/graphql.sql\"\n"
"create procedure GQL_PRINT_TYPE (inout ses any, in type_def any, in kind int, inout types any)\n"
"{\n"
"declare not_null, list, type_name any;\n"
"list := (case type_def[0] when 212 then 1 else 0 end);\n"
"not_null := aref (type_def, 2);\n"
"if (not_null)\n"
"{\n"
"http (sprintf (\' [ :kind \"NON_NULL\"; :ofType \'), ses);\n"
"type_def[2] := 0;\n"
"GQL_PRINT_TYPE (ses, type_def, kind, types);\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"if (list)\n"
"{\n"
"http (sprintf (\' [ :kind \"LIST\"; :ofType \'), ses);\n"
"type_def := aref (type_def, 1);\n"
"GQL_PRINT_TYPE (ses, type_def, kind, types);\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"type_name := aref (type_def, 1);\n"
"if (dict_get (types, type_name) is null)\n"
"signal (\'22023\', sprintf (\'Undefined type %s.\', type_name));\n"
"http (sprintf (\':%s\' , type_name), ses);\n"
"return;\n"
"}\n"
"--src graphql.sql:1823\n"
;

static const char *proc41 = 
"#line 1854 \"[executable]/graphql.sql\"\n"
"create procedure GQL_READ_TYPES (in tree any, in schema_iri varchar := \'urn:graphql:intro\')\n"
"{\n"
"declare i, len int;\n"
"declare schema_iid iri_id_8;\n"
"declare types any;\n"
"\n"
"schema_iid := iri_to_id (schema_iri);\n"
"types := dict_new (31);\n"
"for select \"name\", \"kind\" from (sparql select str(?name) as ?name  str(?kind) as ?kind\n"
"{ graph ?:schema_iid { gqi:__schema gqi:types [ gqi:name ?name ; gqi:kind ?kind ] }}) dt do\n"
"{\n"
"if (subseq (\"name\", 0, 2) <> \'__\')\n"
"dict_put (types, \"name\", \"kind\");\n"
"}\n"
"len := length (tree);\n"
"for (i := 0; i < len; i := i + 1)\n"
"{\n"
"declare elm any;\n"
"declare op int;\n"
"elm := aref (tree, i);\n"
"op := aref (elm, 0);\n"
"if (op = 1001)\n"
"dict_put (types, elm[2], \'SCALAR\');\n"
"else if (op = 1002)\n"
"dict_put (types, elm[2], \'OBJECT\');\n"
"else if (op = 1012)\n"
"dict_put (types, elm[2], \'INPUT_OBJECT\');\n"
"}\n"
"return types;\n"
"}\n"
"--src graphql.sql:1852\n"
;

static const char *proc42 = 
"#line 1886 \"[executable]/graphql.sql\"\n"
"create procedure GQL_TRAVERSE_NODE (in tree any, inout ses any, in lev int, inout types any)\n"
"{\n"
"declare op int;\n"
"declare name, skip varchar;\n"
"declare description any;\n"
"declare dirs, ifaces, fields any;\n"
"\n"
"http (\'\\n###\\n\\n\', ses);\n"
"op := aref (tree, 0);\n"
"if (op = 1000)\n"
"{\n"
"signal (\'42000\', \'Can not re-define root schema.\');\n"
"}\n"
"else if (op = 1001)\n"
"{\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"dirs := aref (tree, 3);\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s rdf:type gql:%s_Class ;\\n\', name, name), ses);\n"
"http (sprintf (\'    :enumValues rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :fields rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :interfaces rdf:nil ;\\n\'), ses);\n"
"http (sprintf (\'    :kind \"SCALAR\" ;\\n\'), ses);\n"
"http (sprintf (\'    :possibleTypes rdf:nil ;\\n\'), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'    :name \"%s\" .\\n\', name), ses);\n"
"}\n"
"else if (op = 1002)\n"
"{\n"
"declare inx int;\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"if (name[0] = 95)\n"
"signal (\'42000\', \'(re)Definition of system types prohibited.\');\n"
"\n"
"\n"
"ifaces := aref (tree, 3);\n"
"dirs := aref (tree, 4);\n"
"fields := aref (tree, 5);\n"
"\n"
"if (name in (\'Query\', \'Mutation\'))\n"
"{\n"
"if (not fields or not length (fields))\n"
"goto no;\n"
"http (sprintf (\':%s \', name), ses);\n"
"goto fields_def;\n"
"}\n"
"\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s a gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'  :name \"%s\" ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'  :kind \"OBJECT\" ;\\n\'), ses);\n"
"fields_def:\n"
"http (\'  :fields \\n\', ses);\n"
"for (inx := 0; inx < length (fields); inx := inx + 1)\n"
"{\n"
"declare fld any;\n"
"fld := fields[inx];\n"
"if (inx > 0) http (\', \\n\', ses);\n"
"GQL_PRINT_FIELD (ses, fld, types);\n"
"}\n"
"if (not inx) http (\'rdf:nil\', ses);\n"
"http (\';\\n\', ses);\n"
"http (sprintf (\'  :isDeprecated false .\\n\'), ses);\n"
"\n"
"}\n"
"else if (op = 1012)\n"
"{\n"
"declare inx int;\n"
"description := aref (tree, 1);\n"
"name := aref (tree, 2);\n"
"\n"
"dirs := aref (tree, 3);\n"
"fields := aref (tree, 4);\n"
"\n"
"http (sprintf (\':__schema :types :%s . \\n\', name), ses);\n"
"\n"
"http (sprintf (\':%s a gql:Object ;\\n\', name), ses);\n"
"http (sprintf (\'  :name \"%s\" ;\\n\', name), ses);\n"
"if (description)\n"
"{\n"
"http (\'    :description \', ses);\n"
"http_nt_object (description, ses);\n"
"http (\';\\n\', ses);\n"
"}\n"
"http (sprintf (\'  :kind \"INPUT_OBJECT\" ;\\n\'), ses);\n"
"http (\'  :inputFields \\n\', ses);\n"
"for (inx := 0; inx < length (fields); inx := inx + 1)\n"
"{\n"
"declare fld any;\n"
"fld := fields[inx];\n"
"if (inx > 0) http (\', \\n\', ses);\n"
"GQL_PRINT_FIELD (ses, fld, types);\n"
"}\n"
"if (not inx)\n"
"signal (\'22023\', sprintf (\'Input `%s` must define fields.\', name));\n"
"http (\'.\\n\', ses);\n"
"}\n"
"else\n"
"{\n"
"signal (\'GQTNO\', sprintf (\'Not supported type ID: %d\', op));\n"
"}\n"
"no:\n"
"return;\n"
"}\n"
"--src graphql.sql:1884\n"
;

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


#define EXEC_AND_LOG_TIME(fname, sno) \
  ddl_exec_init_stmt ("do this always", sno, #fname, #sno); 

void
sqls_define_graphql (void)
{
  /* graphql.sql */

  EXEC_AND_LOG_TIME(graphql.sql, other0);
  EXEC_AND_LOG_TIME(graphql.sql, other1);
  DEFINE_PROC ("GQL_GET_FRAGMENTS", proc0);
  DEFINE_PROC ("GQL_EXPAND_REFS", proc1);
  DEFINE_PROC ("GQL_APPLY_VARS_DEFAULTS", proc2);
  DEFINE_PROC ("GQL_PARSE_REQUEST", proc3);
  DEFINE_PROC ("GQL_EXEC_UPDATES", proc4);
  DEFINE_PROC ("GQL_EXEC", proc5);
  DEFINE_PROC ("GQL_IID", proc6);
  DEFINE_PROC ("GQL_SCH_IID", proc7);
  DEFINE_PROC ("GQL_VAL_PRINT", proc8);
  DEFINE_PROC ("GQL_SQL_ARRAY_STR", proc9);
  DEFINE_PROC ("GQL_OP", proc10);
  DEFINE_PROC ("GQL_DEBUG", proc11);
  DEFINE_PROC ("GQL_DIRECTIVES_CHECK", proc12);
  DEFINE_PROC ("GQL_CONSTRUCT", proc13);
  DEFINE_PROC ("GQL_VALUE", proc14);
  DEFINE_PROC ("GQL_UPDATE", proc15);
  DEFINE_PROC ("GQL_BUILD_SPARUL", proc16);
  DEFINE_PROC ("GQL_ERROR", proc17);
  DEFINE_PROC ("GQL_TRANSFORM", proc18);
  DEFINE_PROC ("GQL_RDF_NIL", proc19);
  DEFINE_PROC ("GQL_PREPARE_JSON_TREE", proc20);
  DEFINE_PROC ("GQL_PRINT_JSON_VAL", proc21);
  DEFINE_PROC ("GQL_SERIALIZE_TREE_INT", proc22);
  DEFINE_PROC ("GQL_JSON_SERIALIZE_TREE", proc23);
  ddl_ensure_table ("DB.DBA.GQL_CACHE", tbl0);
  DEFINE_PROC ("GQL_CACHE_CHECK", proc24);
  DEFINE_PROC ("GQL_CACHE_STORE", proc25);
  DEFINE_PROC ("GQL_CACHE_ENABLE", proc26);
  DEFINE_PROC ("GQL_DISPATCH", proc27);
  DEFINE_PROC ("GRAPHQL.GRAPHQL.auth", proc28);
  DEFINE_PROC ("GRAPHQL.GRAPHQL.query", proc29);
  DEFINE_PROC ("DB.DBA.HP_AUTH_GRAPHQL_USER", proc30);
  EXEC_AND_LOG_TIME(graphql.sql, other2);
  EXEC_AND_LOG_TIME(graphql.sql, other3);
  EXEC_AND_LOG_TIME(graphql.sql, other4);
  EXEC_AND_LOG_TIME(graphql.sql, other5);
  EXEC_AND_LOG_TIME(graphql.sql, other6);
  EXEC_AND_LOG_TIME(graphql.sql, other7);
  EXEC_AND_LOG_TIME(graphql.sql, other8);
  EXEC_AND_LOG_TIME(graphql.sql, other9);
  DEFINE_PROC ("GQL_XSD_IRI", proc31);
  DEFINE_PROC ("GQL_GET_NS", proc32);
  DEFINE_PROC ("GQL_CREATE_TYPE_SCHEMA", proc33);
  EXEC_AND_LOG_TIME(graphql.sql, other10);
  DEFINE_PROC ("GQL_INTRO_LOAD", proc34);
  DEFINE_PROC ("GQL_INTRO_ADD", proc35);
  DEFINE_PROC ("GQL_INTRO_DEL", proc36);
  DEFINE_PROC ("GQL_INIT_TYPE_SCHEMA", proc37);
  DEFINE_PROC ("GQL_GENERATE_INTRO", proc38);
  DEFINE_PROC ("GQL_PRINT_FIELD", proc39);
  DEFINE_PROC ("GQL_PRINT_TYPE", proc40);
  DEFINE_PROC ("GQL_READ_TYPES", proc41);
  DEFINE_PROC ("GQL_TRAVERSE_NODE", proc42);
}


void
sqls_arfw_define_graphql (void)
{
}
