/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import virtuoso.jdbc4.Closeable;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.ResultSetWrapper;
import virtuoso.jdbc4.VirtuosoException;

public class StatementWrapper
implements Statement,
Closeable {
    protected Statement stmt;
    protected ConnectionWrapper wconn;
    protected HashMap<Object, Object> objsToClose = new HashMap();
    protected volatile boolean isClosed = false;

    protected StatementWrapper(ConnectionWrapper _wconn, Statement _stmt) {
        this.wconn = _wconn;
        this.stmt = _stmt;
        this.addLink();
    }

    protected void exceptionOccurred(SQLException sqlEx) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sqlEx);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    protected void addLink() {
        this.wconn.addObjToClose(this);
    }

    protected void removeLink() {
        this.wconn.removeObjFromClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        StatementWrapper statementWrapper = this;
        synchronized (statementWrapper) {
            try {
                this.removeLink();
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.wconn = null;
                if (this.objsToClose != null) {
                    this.objsToClose.clear();
                }
            }
            catch (SQLException ex) {
                this.exceptionOccurred(ex);
                throw ex;
            }
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.executeQuery(sql);
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxFieldSize();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.check_close();
        try {
            this.stmt.setMaxFieldSize(max);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxRows();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.check_close();
        try {
            this.stmt.setMaxRows(max);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.check_close();
        try {
            this.stmt.setEscapeProcessing(enable);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getQueryTimeout();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.check_close();
        try {
            this.stmt.setQueryTimeout(seconds);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.check_close();
        try {
            this.stmt.cancel();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.check_close();
        try {
            this.stmt.setCursorName(name);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.getResultSet();
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getUpdateCount();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.check_close();
        try {
            this.stmt.setFetchDirection(direction);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.check_close();
        try {
            this.stmt.setFetchSize(rows);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchSize();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetConcurrency();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetType();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.check_close();
        try {
            this.stmt.addBatch(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearBatch();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeBatch();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.check_close();
        return this.wconn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults(current);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.getGeneratedKeys();
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, columnNames);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetHoldability();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.check_close();
        try {
            return this.stmt.isClosed();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.check_close();
        try {
            this.stmt.setPoolable(poolable);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.check_close();
        try {
            return this.stmt.isPoolable();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.check_close();
        try {
            return this.stmt.unwrap(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.check_close();
        try {
            return this.stmt.isWrapperFor(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.check_close();
        try {
            this.stmt.closeOnCompletion();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.check_close();
        try {
            return this.stmt.isCloseOnCompletion();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    protected synchronized void check_close() throws SQLException {
        if (this.isClosed) {
            throw new VirtuosoException("The statement is closed.", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObjToClose(Object obj) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.put(obj, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObjFromClose(Object obj) {
        HashMap<Object, Object> hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.remove(obj);
        }
    }
}

