/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import openlink.util.OPLHeapBlob;
import openlink.util.OPLHeapClob;
import openlink.util.OPLHeapNClob;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;
import virtuoso.javax.OPLRowSetMetaData;

public class OPLCachedRowSet
extends BaseRowSet
implements RowSetInternal,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8262862611500365291L;
    private static final int BEFOREFIRST = 0;
    private static final int FIRSTROW = 1;
    private static final int BODYROW = 2;
    private static final int LASTROW = 3;
    private static final int AFTERLAST = 4;
    private static final int NOROWS = 5;
    private RowSetReader rowSetReader = new RowSetReader();
    private RowSetWriter rowSetWriter = new RowSetWriter();
    private transient Connection conn;
    private RowSetMetaData rowSMD;
    private int[] keyCols;
    private String tableName;
    private ArrayList<Object> rowsData = new ArrayList();
    private int curState = 5;
    private int curRow;
    private int absolutePos;
    private int countDeleted;
    private int countRows;
    private Row updateRow = null;
    private boolean onInsertRow = false;
    private boolean showDeleted;
    private InputStream objInputStream = null;
    private Reader objReader = null;
    private boolean _wasNull = false;

    public OPLCachedRowSet() throws SQLException {
        this.setType(1004);
        this.setConcurrency(1007);
        this.showDeleted = false;
        this.curRow = -1;
        this.absolutePos = 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void setCommand(String cmd) throws SQLException {
        this.tableName = null;
        this.keyCols = null;
        super.setCommand(cmd);
    }

    @Override
    public synchronized void setConcurrency(int concurrency) throws SQLException {
        if (this.tableName == null && concurrency == 1008) {
            throw OPLMessage_x.makeException(23);
        }
        super.setConcurrency(concurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acceptChanges() throws SQLException {
        this.check_InsertMode("'acceptChanges()'");
        if (this.rowSetWriter == null) {
            throw OPLMessage_x.makeException(24);
        }
        int _curRow = this.curRow;
        int _absolutePos = this.absolutePos;
        int _curState = this.curState;
        boolean success = true;
        SQLException ex = null;
        try {
            success = this.rowSetWriter.writeData(this);
        }
        catch (SQLException e) {
            ex = e;
        }
        finally {
            this.curRow = _curRow;
            this.absolutePos = _absolutePos;
            this.curState = _curState;
        }
        if (!success) {
            if (ex == null) {
                throw OPLMessage_x.makeException(25);
            }
            throw ex;
        }
        this.setOriginal();
    }

    public void acceptChanges(Connection _conn) throws SQLException {
        this.conn = _conn;
        this.acceptChanges();
    }

    @Override
    public synchronized void execute() throws SQLException {
        this.rowSetReader.readData(this);
        if (this.tableName == null) {
            Scanner scan = new Scanner(this.getCommand());
            this.tableName = scan.check_Select();
            if (this.tableName == null) {
                this.setConcurrency(1007);
            } else {
                this.setConcurrency(1008);
            }
        }
    }

    public void execute(Connection _conn) throws SQLException {
        this.conn = _conn;
        this.execute();
    }

    public synchronized void populate(ResultSet rs) throws SQLException {
        this.check_InsertMode("'populate((...)'");
        this.tableName = null;
        this.keyCols = null;
        Map<String, Class<?>> map = this.getTypeMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        int i = 0;
        while (rs.next()) {
            Row row = new Row(colCount);
            for (int j = 1; j <= colCount; ++j) {
                Object x = map == null ? rs.getObject(j) : rs.getObject(j, map);
                if (x instanceof Blob) {
                    x = new OPLHeapBlob(((Blob)x).getBytes(0L, (int)((Blob)x).length()));
                } else if (x instanceof Clob) {
                    x = new OPLHeapClob(((Clob)x).getSubString(0L, (int)((Clob)x).length()));
                } else if (x instanceof NClob) {
                    x = new OPLHeapNClob(((NClob)x).getSubString(0L, (int)((NClob)x).length()));
                }
                row.setOrigColData(j, x);
            }
            this.rowsData.add(row);
            ++i;
        }
        this.countRows = i;
        this.curState = this.countRows > 0 ? 0 : 5;
        this.curRow = -1;
        this.absolutePos = 0;
        this.rowSMD = new OPLRowSetMetaData(rsmd);
        this.notifyListener(3);
    }

    public synchronized void setShowDeleted(boolean value) throws SQLException {
        this.check_InsertMode("'setShowDeleted(...)'");
        if (this.showDeleted && !value && this.rowDeleted()) {
            this.showDeleted = value;
            switch (this.curState) {
                case 1: {
                    this._first();
                    this.notifyListener(2);
                    break;
                }
                case 2: {
                    int _absPos = this.absolutePos;
                    this._next();
                    this.absolutePos = _absPos;
                    this.notifyListener(2);
                    break;
                }
                case 3: {
                    this._last();
                    this.notifyListener(2);
                }
            }
        } else {
            this.showDeleted = value;
            switch (this.curState) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.curRow < this.countRows / 2) {
                        int _row = this.curRow;
                        this._beforeFirst();
                        while (this._next() && _row != this.curRow) {
                        }
                    } else {
                        int _row = this.curRow;
                        this._afterLast();
                        while (this._previous() && _row != this.curRow) {
                        }
                    }
                    break;
                }
                case 0: {
                    this._beforeFirst();
                    break;
                }
                case 4: {
                    this._afterLast();
                }
            }
        }
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public synchronized void setTableName(String _tableName) throws SQLException {
        this.tableName = _tableName;
    }

    public int[] getKeyCols() throws SQLException {
        return this.keyCols;
    }

    public void setKeyColumns(int[] keys) throws SQLException {
        int colsCount = this.rowSMD != null ? this.rowSMD.getColumnCount() : 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] >= 1 && keys[i] <= colsCount) continue;
            throw OPLMessage_x.makeException(9);
        }
        if (keys.length > colsCount) {
            throw OPLMessage_x.makeException(26);
        }
        this.keyCols = new int[keys.length];
        System.arraycopy(keys, 0, this.keyCols, 0, keys.length);
    }

    public synchronized void cancelRowDelete() throws SQLException {
        if (!this.showDeleted) {
            return;
        }
        this.check_pos("'cancelRowDelete()'");
        this.check_InsertMode("'cancelRowDelete()'");
        Row row = this.getCurRow();
        if (row.isDeleted) {
            row.isDeleted = false;
            --this.countDeleted;
            this.notifyListener(2);
        }
    }

    public synchronized void cancelRowInsert() throws SQLException {
        this.check_pos("'cancelRowInsert()'");
        this.check_InsertMode("'cancelRowInsert()'");
        Row row = this.getCurRow();
        if (row.isInserted) {
            this.rowsData.remove(this.curRow);
            this.notifyListener(2);
            --this.countRows;
            if (this.countRows == 0) {
                this.curState = 5;
                this.curRow = -1;
                this.absolutePos = 0;
            }
            switch (this.curState) {
                case 1: {
                    this._first();
                    break;
                }
                case 3: {
                    this._last();
                    break;
                }
                case 2: {
                    if (this.curRow == this.countRows - 1) {
                        this.curState = 3;
                        break;
                    }
                    boolean found = false;
                    int i = this.curRow;
                    while (!found && ++i < this.countRows) {
                        found = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)i)).isDeleted) continue;
                        found = false;
                    }
                    if (found) break;
                    this.curState = 3;
                }
            }
        } else {
            throw OPLMessage_x.makeException(27);
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_pos("'cancelRowUpdates()'");
        this.cancelUpdates();
        Row row = this.getCurRow();
        if (row.isUpdated) {
            row.clearUpdated();
            this.notifyListener(2);
        }
    }

    public synchronized boolean columnUpdated(int columnIndex) throws SQLException {
        this.check_pos("'columnUpdated(...)'");
        this.check_InsertMode("'columnUpdated(...)'");
        return this.getCurRow().isColUpdated(columnIndex);
    }

    public synchronized void setOriginal() throws SQLException {
        if (this.countRows == 0) {
            return;
        }
        Iterator<Object> i = this.rowsData.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            if (row.isDeleted) {
                i.remove();
                --this.countRows;
                continue;
            }
            row.moveCurToOrig();
        }
        this.countDeleted = 0;
        this.curState = 0;
        this.curRow = -1;
        this.absolutePos = 0;
        this._wasNull = false;
        this.notifyListener(3);
    }

    public synchronized void setOriginalRow() throws SQLException {
        if (this.countRows == 0) {
            return;
        }
        this.check_InsertMode("'setOriginalRow()'");
        this.check_pos("'setOriginalRow()'");
        Row row = this.getCurRow();
        if (row.isDeleted) {
            this.rowsData.remove(this.curRow);
            --this.countRows;
            --this.countDeleted;
            this._next();
        } else {
            row.moveCurToOrig();
        }
        this.notifyListener(2);
    }

    public synchronized void restoreOriginal() throws SQLException {
        this.closeInputStream();
        this.cancelUpdates();
        if (this.countRows == 0) {
            return;
        }
        Iterator<Object> i = this.rowsData.iterator();
        while (i.hasNext()) {
            Row row = (Row)i.next();
            if (row.isInserted) {
                i.remove();
                --this.countRows;
                continue;
            }
            if (row.isDeleted) {
                row.isDeleted = false;
            }
            if (!row.isUpdated) continue;
            row.clearUpdated();
        }
        this.curRow = -1;
        this.absolutePos = 0;
        this.curState = 0;
        this._wasNull = false;
        this.notifyListener(3);
    }

    public int size() {
        return this.countRows;
    }

    public synchronized Collection toCollection() throws SQLException {
        int count = this.countRows - this.countDeleted;
        if (count == 0) {
            return null;
        }
        ArrayList tmpRowset = new ArrayList(count);
        int colCount = this.rowSMD.getColumnCount();
        for (Row row : this.rowsData) {
            if (row.isDeleted) continue;
            ArrayList<Object> tmpCol = new ArrayList<Object>(colCount);
            for (int j = 1; j <= colCount; ++j) {
                tmpCol.add(row.getColData(j));
            }
            tmpRowset.add(tmpCol);
        }
        return tmpRowset;
    }

    public synchronized Collection toCollection(int col) throws SQLException {
        int count = this.countRows - this.countDeleted;
        if (count == 0) {
            return null;
        }
        ArrayList<Object> tmpRowset = new ArrayList<Object>(count);
        this.checkColumnIndex(col);
        for (Row row : this.rowsData) {
            if (row.isDeleted) continue;
            tmpRowset.add(row.getColData(col));
        }
        return tmpRowset;
    }

    public synchronized void release() throws SQLException {
        this.closeInputStream();
        this.cancelUpdates();
        this.rowsData.clear();
        this.curState = 5;
        this.onInsertRow = false;
        this.updateRow = null;
        this.showDeleted = false;
        this.curRow = -1;
        this.absolutePos = 0;
        this.countRows = 0;
        this.countDeleted = 0;
        this.notifyListener(3);
    }

    public RowSet createCopy() throws SQLException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream obj_os = new ObjectOutputStream(os);
            obj_os.writeObject(this);
            ObjectInputStream obj_in = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
            return (RowSet)obj_in.readObject();
        }
        catch (Exception e) {
            throw new SQLException("createCopy failed: " + e.getMessage());
        }
    }

    public RowSet createShared() throws SQLException {
        RowSet rowset;
        try {
            rowset = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw OPLMessage_x.makeException(e);
        }
        return rowset;
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
        this.rowSMD = md;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public synchronized ResultSet getOriginal() throws SQLException {
        OPLCachedRowSet crs = new OPLCachedRowSet();
        crs.rowSMD = this.rowSMD;
        crs.countRows = this.countRows;
        crs.curRow = -1;
        crs.rowSetReader = null;
        crs.rowSetWriter = null;
        crs.curState = 0;
        crs._wasNull = false;
        Iterator<Object> i = this.rowsData.iterator();
        while (i.hasNext()) {
            crs.rowsData.add(new Row(((Row)i.next()).getOrigData()));
        }
        return crs;
    }

    @Override
    public synchronized ResultSet getOriginalRow() throws SQLException {
        OPLCachedRowSet crs = new OPLCachedRowSet();
        crs.rowSMD = this.rowSMD;
        crs.countRows = 1;
        crs.rowSetReader = null;
        crs.rowSetWriter = null;
        crs.curState = 0;
        crs._wasNull = false;
        crs.rowsData.add(new Row(this.getCurRow().getOrigData()));
        return crs;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.release();
        super.close();
        this.conn = null;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.check_move("'next()'", true);
        this.closeInputStream();
        this.cancelUpdates();
        boolean ret = this._next();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.check_move("'previous()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean ret = this._previous();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.check_move("'first()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean ret = this._first();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.check_move("'last()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean ret = this._last();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.check_move("'absolute(...)'", false);
        this.closeInputStream();
        this.cancelUpdates();
        if (row == 0) {
            throw OPLMessage_x.makeExceptionV(28, "'absolute(...)'");
        }
        if (!this.showDeleted) {
            if (row > 0) {
                if (row == 1) {
                    this._first();
                } else {
                    boolean ret;
                    while (this.absolutePos != row && (ret = this.absolutePos >= row ? this._previous() : this._next())) {
                    }
                }
            } else {
                boolean ret = this._last();
                if (ret && row < -1) {
                    int pos = -1;
                    while (pos != row && ret) {
                        ret = this._previous();
                        if (!ret) continue;
                        --pos;
                    }
                }
            }
        } else if (row > 0) {
            if (row > this.countRows) {
                this._afterLast();
            } else {
                this.curRow = row - 1;
                this.absolutePos = row;
                this.curState = 2;
            }
        } else if (row * -1 > this.countRows) {
            this._beforeFirst();
        } else {
            this.curRow = this.countRows + row;
            this.absolutePos = this.curRow + 1;
            this.curState = 2;
        }
        this.notifyListener(1);
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.check_move("'relative(...)'", false);
        this.closeInputStream();
        this.cancelUpdates();
        if (rows == 0) {
            return true;
        }
        if (rows > 0) {
            if (this.curRow + rows >= this.countRows) {
                this._afterLast();
            } else {
                for (int i = 0; i < rows && this._next(); ++i) {
                }
            }
        } else if (this.curRow + rows < 0) {
            this.beforeFirst();
        } else {
            for (int i = rows; i < 0 && this._previous(); ++i) {
            }
        }
        this.notifyListener(1);
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.check_move("'beforeFirst()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        this._beforeFirst();
        this.notifyListener(1);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.check_move("'afterLast()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        this._afterLast();
        this.notifyListener(1);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.check_InsertMode("'isBeforeFirst()'");
        return this.curState == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.check_InsertMode("'isAfterLast()'");
        return this.curState == 4;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.check_InsertMode("'isFirst()'");
        if (this.curState == 1) {
            return true;
        }
        if (this.curState == 3) {
            int _curRow = this.curRow;
            int _absolutePos = this.absolutePos;
            boolean prev_exists = this._previous();
            this.curRow = _curRow;
            this.absolutePos = _absolutePos;
            this.curState = 3;
            if (!prev_exists) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.check_InsertMode("'isLast()'");
        if (this.curState == 3) {
            return true;
        }
        if (this.curState == 1) {
            int _curRow = this.curRow;
            int _absolutePos = this.absolutePos;
            boolean next_exists = this._next();
            this.curRow = _curRow;
            this.absolutePos = _absolutePos;
            this.curState = 1;
            if (!next_exists) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.check_InsertMode("'getRow()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return 0;
        }
        return this.absolutePos;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.check_InsertMode("'rowUpdated()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isUpdated;
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.check_InsertMode("'rowInserted()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isInserted;
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.check_InsertMode("'rowDeleted()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isDeleted;
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.check_move("'refreshRow()'", false);
        this.closeInputStream();
        this.cancelUpdates();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'insertRow()'");
        }
        this.check_Update("'insertRow()'");
        if (this.updateRow == null || !this.updateRow.isCompleted()) {
            throw OPLMessage_x.makeException(29);
        }
        Row row = new Row(this.updateRow.getCurData());
        row.isInserted = true;
        switch (this.curState) {
            case 1: 
            case 2: 
            case 3: {
                this.rowsData.add(this.curRow, row);
                break;
            }
            case 0: 
            case 5: {
                this.rowsData.add(0, row);
                this.curState = 0;
                break;
            }
            case 4: {
                this.rowsData.add(row);
            }
        }
        ++this.countRows;
        this.notifyListener(2);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'updateRow()'");
        }
        this.check_Update("'updateRow()'");
        this.check_pos("'updateRow()'");
        if (this.updateRow != null) {
            this.getCurRow().update(this.updateRow.getCurData(), this.updateRow.getListUpdatedCols());
            this.notifyListener(2);
            this.updateRow.clear();
            this.updateRow = null;
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'deleteRow()'");
        }
        this.check_Update("'deleteRow()'");
        this.check_pos("'deleteRow()'");
        Row row = this.getCurRow();
        if (!row.isDeleted) {
            row.isDeleted = true;
            ++this.countDeleted;
            if (!this.showDeleted) {
                int _absPos = this.absolutePos;
                this._next();
                this.absolutePos = _absPos;
            }
            this.notifyListener(2);
        }
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        int count;
        this.check_Update("'moveToInsertRow()'");
        if (this.updateRow != null) {
            this.updateRow.clear();
        }
        if ((count = this.rowSMD.getColumnCount()) > 0) {
            this.updateRow = new Row(count);
            this.onInsertRow = true;
        }
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.cancelUpdates();
            this.onInsertRow = false;
            if (this.curState == 4) {
                this._last();
            }
            return;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSMD;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.rowSMD == null) {
            throw OPLMessage_x.makeException(16);
        }
        int count = this.rowSMD.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = this.rowSMD.getColumnName(i);
            if (name == null || !name.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw OPLMessage_x.makeExceptionV(13, columnName);
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof byte[]) {
            return this.Bin2Hex((byte[])x);
        }
        if (x instanceof Blob) {
            return this.Bin2Hex(((Blob)x).getBytes(0L, (int)((Blob)x).length()));
        }
        if (x instanceof Clob) {
            return ((Clob)x).getSubString(0L, (int)((Clob)x).length());
        }
        if (x instanceof NClob) {
            return ((NClob)x).getSubString(0L, (int)((NClob)x).length());
        }
        return x.toString();
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return false;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof String) {
            char c = ((String)x).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (x instanceof byte[]) {
            return ((byte[])x)[0] != 0;
        }
        if (x instanceof Blob) {
            return ((Blob)x).getBytes(0L, 1)[0] != 0;
        }
        if (x instanceof Clob) {
            char c = ((Clob)x).getSubString(0L, 1).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (x instanceof NClob) {
            char c = ((NClob)x).getSubString(0L, 1).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (x instanceof Number) {
            return ((Number)x).intValue() != 0;
        }
        throw OPLMessage_x.makeExceptionV(15, "'boolean'");
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0;
        }
        if (x instanceof Number) {
            return ((Number)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (byte)((Boolean)x != false ? 1 : 0);
        }
        if (x instanceof String) {
            return new BigDecimal(((String)x).toString()).byteValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'byte'");
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0;
        }
        if (x instanceof Number) {
            return ((Number)x).shortValue();
        }
        if (x instanceof Boolean) {
            return (short)((Boolean)x != false ? 1 : 0);
        }
        if (x instanceof String) {
            return new BigDecimal(((String)x).toString()).shortValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'short'");
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0;
        }
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof String) {
            return new BigDecimal(((String)x).toString()).intValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'int'");
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0L;
        }
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1L : 0L;
        }
        if (x instanceof String) {
            return new BigDecimal(((String)x).toString()).longValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'long'");
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0.0f;
        }
        if (x instanceof Number) {
            return ((Number)x).floatValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof String) {
            return Float.parseFloat(((String)x).toString().trim());
        }
        throw OPLMessage_x.makeExceptionV(15, "'float'");
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return 0.0;
        }
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof String) {
            return Double.parseDouble(((String)x).toString().trim());
        }
        throw OPLMessage_x.makeExceptionV(15, "'double'");
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Boolean) {
            return new BigDecimal((Boolean)x != false ? 1L : 0L);
        }
        try {
            return new BigDecimal(x.toString().trim());
        }
        catch (NumberFormatException e) {
            throw OPLMessage_x.makeExceptionV(15, "'BigDecimal'");
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof Blob) {
            return ((Blob)x).getBytes(0L, (int)((Blob)x).length());
        }
        if (x instanceof Clob) {
            return ((Clob)x).getSubString(0L, (int)((Clob)x).length()).getBytes();
        }
        if (x instanceof NClob) {
            return ((NClob)x).getSubString(0L, (int)((NClob)x).length()).getBytes();
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        throw OPLMessage_x.makeExceptionV(15, "'byte[]'");
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Date) {
            return (Date)x;
        }
        if (x instanceof Timestamp) {
            return new Date(((Timestamp)x).getTime());
        }
        if (x instanceof String) {
            Date dt = this._getDate((String)x);
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return dt;
        }
        if (x instanceof Clob) {
            Date dt = this._getDate(((Clob)x).getSubString(0L, (int)((Clob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return dt;
        }
        if (x instanceof NClob) {
            Date dt = this._getDate(((NClob)x).getSubString(0L, (int)((NClob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return dt;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Date'");
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Time) {
            return (Time)x;
        }
        if (x instanceof Timestamp) {
            return new Time(((Timestamp)x).getTime());
        }
        if (x instanceof String) {
            Time dt = this._getTime((String)x);
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return dt;
        }
        if (x instanceof Clob) {
            Time dt = this._getTime(((Clob)x).getSubString(0L, (int)((Clob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return dt;
        }
        if (x instanceof NClob) {
            Time dt = this._getTime(((NClob)x).getSubString(0L, (int)((NClob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return dt;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Time'");
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Timestamp) {
            return (Timestamp)x;
        }
        if (x instanceof Time) {
            return new Timestamp(((Time)x).getTime());
        }
        if (x instanceof Date) {
            return new Timestamp(((Date)x).getTime());
        }
        if (x instanceof String) {
            Timestamp dt = this._getTimestamp((String)x);
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return dt;
        }
        if (x instanceof Clob) {
            Timestamp dt = this._getTimestamp(((Clob)x).getSubString(0L, (int)((Clob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return dt;
        }
        if (x instanceof NClob) {
            Timestamp dt = this._getTimestamp(((NClob)x).getSubString(0L, (int)((NClob)x).length()));
            if (dt == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return dt;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this.closeInputStream();
        this._wasNull = x == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (x instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)x).getBytes());
            return this.objInputStream;
        }
        if (x instanceof Clob) {
            this.objInputStream = ((Clob)x).getAsciiStream();
            return this.objInputStream;
        }
        if (x instanceof NClob) {
            this.objInputStream = ((NClob)x).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'AsciiStream'");
    }

    @Override
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this.closeInputStream();
        this._wasNull = x == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (x instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)x).getBytes());
            return this.objInputStream;
        }
        if (x instanceof Clob) {
            this.objInputStream = ((Clob)x).getAsciiStream();
            return this.objInputStream;
        }
        if (x instanceof NClob) {
            this.objInputStream = ((NClob)x).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'UnicodeStream'");
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this.closeInputStream();
        this._wasNull = x == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (x instanceof byte[]) {
            this.objInputStream = new ByteArrayInputStream((byte[])x);
            return this.objInputStream;
        }
        if (x instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)x).getBytes());
            return this.objInputStream;
        }
        if (x instanceof Blob) {
            this.objInputStream = ((Blob)x).getBinaryStream();
            return this.objInputStream;
        }
        if (x instanceof Clob) {
            this.objInputStream = ((Clob)x).getAsciiStream();
            return this.objInputStream;
        }
        if (x instanceof NClob) {
            this.objInputStream = ((NClob)x).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'BinaryStream'");
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        Object retVal = null;
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        return x;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this.closeInputStream();
        this._wasNull = x == null;
        if (this._wasNull) {
            this.objReader = null;
            return null;
        }
        if (x instanceof String) {
            this.objReader = new StringReader((String)x);
            return this.objReader;
        }
        if (x instanceof Clob) {
            this.objReader = ((Clob)x).getCharacterStream();
            return this.objReader;
        }
        if (x instanceof NClob) {
            this.objReader = ((NClob)x).getCharacterStream();
            return this.objReader;
        }
        throw OPLMessage_x.makeExceptionV(15, "'CharacterStream'");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateNull(...)'");
        r.setColData(columnIndex, null);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateBoolean(...)'");
        switch (this.rowSMD.getColumnType(columnIndex)) {
            case 16: {
                r.setColData(columnIndex, x);
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                r.setColData(columnIndex, x ? 1 : 0);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                r.setColData(columnIndex, String.valueOf(x));
                break;
            }
            default: {
                throw OPLMessage_x.makeExceptionV(17, "'boolean'");
            }
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateNumber(columnIndex, x, "'byte'", "'updateByte(...)'");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateNumber(columnIndex, x, "'short'", "'updateShort(...)'");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateNumber(columnIndex, x, "'int'", "'updateInt(...)'");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateNumber(columnIndex, x, "'long'", "'updateLong(...)'");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateNumber(columnIndex, Float.valueOf(x), "'float'", "'updateFloat(...)'");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateNumber(columnIndex, x, "'double'", "'updateDouble(...)'");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateNumber(columnIndex, x, "'BigDecimal'", "'updateBigDecimal(...)'");
        }
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateString(...)'");
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            switch (this.rowSMD.getColumnType(columnIndex)) {
                case 16: {
                    r.setColData(columnIndex, Boolean.parseBoolean(x));
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 70: 
                case 2004: 
                case 2005: 
                case 2011: {
                    r.setColData(columnIndex, x);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    r.setColData(columnIndex, this.HexString2Bin(x));
                    break;
                }
                case 92: {
                    Time val = this._getTime(x);
                    if (val == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    r.setColData(columnIndex, val);
                    break;
                }
                case 93: {
                    Timestamp val = this._getTimestamp(x);
                    if (val == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    r.setColData(columnIndex, val);
                    break;
                }
                case 91: {
                    Date val = this._getDate(x);
                    if (val == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    r.setColData(columnIndex, val);
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'String'");
                }
            }
        }
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateBytes(...)'");
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            switch (this.rowSMD.getColumnType(columnIndex)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    r.setColData(columnIndex, this.Bin2Hex(x));
                    break;
                }
                case 2004: {
                    r.setColData(columnIndex, x);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    r.setColData(columnIndex, x);
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'byte[]'");
                }
            }
        }
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateDate(...)'");
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            switch (this.rowSMD.getColumnType(columnIndex)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    r.setColData(columnIndex, x.toString());
                    break;
                }
                case 91: {
                    r.setColData(columnIndex, x);
                    break;
                }
                case 93: {
                    r.setColData(columnIndex, new Timestamp(x.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Date'");
                }
            }
        }
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateTime(...)'");
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            switch (this.rowSMD.getColumnType(columnIndex)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    r.setColData(columnIndex, x.toString());
                    break;
                }
                case 92: {
                    r.setColData(columnIndex, x);
                    break;
                }
                case 93: {
                    r.setColData(columnIndex, new Timestamp(x.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Time'");
                }
            }
        }
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, "'updateTimestamp(...)'");
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            switch (this.rowSMD.getColumnType(columnIndex)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    r.setColData(columnIndex, x.toString());
                    break;
                }
                case 93: {
                    r.setColData(columnIndex, x);
                    break;
                }
                case 91: {
                    r.setColData(columnIndex, new Date(x.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Timestamp'");
                }
            }
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            try {
                int n;
                byte[] buf = new byte[length];
                int count = 0;
                while ((n = x.read(buf, count, length - count)) > 0 && (count += n) < length) {
                }
                this.updateString(columnIndex, new String(buf, 0, count));
            }
            catch (IOException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            try {
                int n;
                byte[] buf = new byte[length];
                int count = 0;
                while ((n = x.read(buf, count, length - count)) > 0 && (count += n) < length) {
                }
                this.updateBytes(columnIndex, buf);
            }
            catch (IOException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            try {
                int n;
                char[] buf = new char[length];
                int count = 0;
                while ((n = x.read(buf, count, length - count)) > 0 && (count += n) < length) {
                }
                this.updateString(columnIndex, new String(buf, 0, count));
            }
            catch (IOException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            if (x instanceof BigDecimal) {
                ((BigDecimal)x).setScale(scale);
            }
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateObject(...)'");
                r.setColData(columnIndex, x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateObject(...)'");
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int colIndex, Map map) throws SQLException {
        return this.getObject(colIndex);
    }

    @Override
    public synchronized Ref getRef(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        Object x = this.getCurRow().getColData(colIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Ref) {
            return (Ref)x;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Ref'");
    }

    @Override
    public synchronized Blob getBlob(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        Object x = this.getCurRow().getColData(colIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Blob) {
            return (Blob)x;
        }
        if (x instanceof byte[]) {
            return new OPLHeapBlob((byte[])x);
        }
        if (x instanceof String) {
            return new OPLHeapBlob(((String)x).getBytes());
        }
        throw OPLMessage_x.makeExceptionV(15, "'Blob'");
    }

    @Override
    public synchronized Clob getClob(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        Object x = this.getCurRow().getColData(colIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Clob) {
            return (Clob)x;
        }
        if (x instanceof byte[]) {
            return new OPLHeapClob(this.Bin2Hex((byte[])x));
        }
        return new OPLHeapClob(x.toString());
    }

    @Override
    public synchronized Array getArray(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        Object x = this.getCurRow().getColData(colIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof Array) {
            return (Array)x;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Array'");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date dt = this.getDate(columnIndex);
        if (dt == null) {
            return null;
        }
        Calendar def_cal = Calendar.getInstance();
        def_cal.setTime(dt);
        cal.set(1, def_cal.get(1));
        cal.set(2, def_cal.get(2));
        cal.set(5, def_cal.get(5));
        return new Date(cal.getTime().getTime());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time dt = this.getTime(columnIndex);
        if (dt == null) {
            return null;
        }
        Calendar def_cal = Calendar.getInstance();
        def_cal.setTime(dt);
        cal.set(11, def_cal.get(11));
        cal.set(12, def_cal.get(12));
        cal.set(13, def_cal.get(13));
        return new Time(cal.getTime().getTime());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp dt = this.getTimestamp(columnIndex);
        if (dt == null) {
            return null;
        }
        Calendar def_cal = Calendar.getInstance();
        def_cal.setTime(dt);
        cal.set(1, def_cal.get(1));
        cal.set(2, def_cal.get(2));
        cal.set(5, def_cal.get(5));
        cal.set(11, def_cal.get(11));
        cal.set(12, def_cal.get(12));
        cal.set(13, def_cal.get(13));
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        ts.setNanos(dt.getNanos());
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof URL) {
            return (URL)x;
        }
        if (x instanceof String) {
            try {
                return new URL((String)x);
            }
            catch (MalformedURLException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
        throw OPLMessage_x.makeExceptionV(15, "'URL'");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateRef(...)'");
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateBlob(...)'");
                x = new OPLHeapBlob(x.getBytes(0L, (int)x.length()));
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateClob(...)'");
                x = new OPLHeapClob(x.getSubString(0L, (int)x.length()));
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateArray(...)'");
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public synchronized RowId getRowId(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof RowId) {
            return (RowId)x;
        }
        throw OPLMessage_x.makeExceptionV(15, "'RowId'");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateRowId(...)'");
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public synchronized void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateNClob(int columnIndex, NClob x) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateNClob(...)'");
                x = new OPLHeapNClob(x.getSubString(0L, (int)x.length()));
                r.setColData(columnIndex, x);
            }
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof NClob) {
            return (NClob)x;
        }
        if (x instanceof byte[]) {
            return new OPLHeapNClob(this.Bin2Hex((byte[])x));
        }
        return new OPLHeapNClob(x.toString());
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this._wasNull = x == null;
        if (this._wasNull) {
            return null;
        }
        if (x instanceof SQLXML) {
            return (SQLXML)x;
        }
        throw OPLMessage_x.makeExceptionV(15, "'SQLXML'");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.updateNull(columnIndex);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row r = this.getRowForUpdate(columnIndex, "'updateSQLXML(...)'");
                r.setColData(columnIndex, xmlObject);
            }
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public synchronized String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object x = this.getCurRow().getColData(columnIndex);
        this.closeInputStream();
        this._wasNull = x == null;
        if (this._wasNull) {
            this.objReader = null;
            return null;
        }
        if (x instanceof String) {
            this.objReader = new StringReader((String)x);
            return this.objReader;
        }
        if (x instanceof Clob) {
            this.objReader = ((Clob)x).getCharacterStream();
            return this.objReader;
        }
        if (x instanceof NClob) {
            this.objReader = ((NClob)x).getCharacterStream();
            return this.objReader;
        }
        throw OPLMessage_x.makeExceptionV(15, "'NCharacterStream'");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, (int)length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, (int)length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(columnIndex, reader, (long)((int)length));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNCharacterStream(columnIndex, x)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNCharacterStream(columnLabel, reader)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateAsciiStream(columnIndex, x)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBinaryStream(columnIndex, x)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateCharacterStream(columnIndex, x)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateAsciiStream(columnLabel, x)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBinaryStream(columnLabel, x)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateCharacterStream(columnLabel, reader)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBlob(columnIndex, inputStream)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBlob(columnLabel, inputStream)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateClob(columnIndex,  reader)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateClob(columnLabel,  reader)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNClob(columnIndex,  reader)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNClob(columnLabel,  reader)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw OPLMessage_x.makeExceptionV(36, iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Type parameter cannot be null", "S1009");
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        try {
            return (T)this.getObject(columnIndex);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Conversion not supported for type " + type.getName(), "S1009");
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    private Row getCurRow() {
        if (this.onInsertRow) {
            return this.updateRow;
        }
        return (Row)this.rowsData.get(this.curRow);
    }

    private void check_pos(String s) throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw OPLMessage_x.makeException(30);
        }
    }

    private void check_move(String s, boolean isNext) throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(18, s);
        }
        if (!isNext && this.getType() == 1003) {
            throw OPLMessage_x.makeExceptionV(19, s);
        }
    }

    private void check_InsertMode(String s) throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(18, s);
        }
    }

    private void closeInputStream() {
        if (this.objInputStream != null) {
            try {
                this.objInputStream.close();
            }
            catch (Exception _ex) {
                // empty catch block
            }
            this.objInputStream = null;
        }
        if (this.objReader != null) {
            try {
                this.objReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.objReader = null;
        }
    }

    private void check_Update(String s) throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw OPLMessage_x.makeExceptionV(20, s);
        }
    }

    private int checkColumnIndex(int columnIndex) throws SQLException {
        if (this.rowSMD == null || (this.curState == 5 || this.countRows == 0) && !this.onInsertRow) {
            throw OPLMessage_x.makeException(21);
        }
        if (!this.onInsertRow && (this.isAfterLast() || this.isBeforeFirst())) {
            throw OPLMessage_x.makeException(30);
        }
        if (columnIndex < 1 || columnIndex > this.rowSMD.getColumnCount()) {
            throw OPLMessage_x.makeException(9);
        }
        return columnIndex;
    }

    private void cancelUpdates() {
        if (this.updateRow != null) {
            this.updateRow.clear();
        }
        this.updateRow = null;
    }

    private Row getRowForUpdate(int columnIndex, String cmd) throws SQLException {
        this.check_Update(cmd);
        this.checkColumnIndex(columnIndex);
        if (this.updateRow == null) {
            this.updateRow = new Row(this.rowSMD.getColumnCount());
        }
        return this.updateRow;
    }

    private synchronized void updateNumber(int columnIndex, Number val, String typeName, String funcName) throws SQLException {
        Row r = this.getRowForUpdate(columnIndex, funcName);
        switch (this.rowSMD.getColumnType(columnIndex)) {
            case 16: {
                r.setColData(columnIndex, val.intValue() != 0);
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                r.setColData(columnIndex, val);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                r.setColData(columnIndex, val.toString());
                break;
            }
            default: {
                throw OPLMessage_x.makeExceptionV(17, typeName);
            }
        }
    }

    private boolean _next() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
            return false;
        }
        if (this.curRow >= this.countRows) {
            this.curState = 4;
            return false;
        }
        boolean ret = false;
        while (!ret) {
            ++this.curRow;
            if (this.curRow >= this.countRows) break;
            ret = true;
            if (this.showDeleted || !((Row)this.rowsData.get((int)this.curRow)).isDeleted) continue;
            ret = false;
        }
        if (ret) {
            ++this.absolutePos;
            if (this.curState == 0) {
                this.curState = 1;
            } else {
                this.curState = 2;
                if (this.curRow == this.countRows - 1) {
                    this.curState = 3;
                } else {
                    boolean found = false;
                    int i = this.curRow;
                    while (!found && ++i < this.countRows) {
                        found = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)i)).isDeleted) continue;
                        found = false;
                    }
                    if (!found) {
                        this.curState = 3;
                    }
                }
            }
        } else {
            if (this.curState == 3) {
                ++this.absolutePos;
            }
            this.curState = 4;
        }
        return ret;
    }

    private boolean _previous() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
            return false;
        }
        if (this.curRow < 0) {
            this.curState = 0;
            return false;
        }
        boolean ret = false;
        while (!ret) {
            --this.curRow;
            if (this.curRow < 0) break;
            ret = true;
            if (this.showDeleted || !((Row)this.rowsData.get((int)this.curRow)).isDeleted) continue;
            ret = false;
        }
        if (ret) {
            --this.absolutePos;
            if (this.curState == 4) {
                this.curState = 3;
            } else {
                this.curState = 2;
                if (this.curRow == 0) {
                    this.curState = 1;
                } else {
                    boolean found = false;
                    int i = this.curRow;
                    while (!found && --i >= 0) {
                        found = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)i)).isDeleted) continue;
                        found = false;
                    }
                    if (!found) {
                        this.curState = 1;
                    }
                }
            }
        } else {
            if (this.curState == 1) {
                --this.absolutePos;
            }
            this.curState = 0;
        }
        return ret;
    }

    private boolean _first() throws SQLException {
        this._beforeFirst();
        return this._next();
    }

    private boolean _last() throws SQLException {
        this._afterLast();
        return this._previous();
    }

    private void _afterLast() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
        } else {
            this.curRow = this.countRows;
            this.absolutePos = this.countRows - (this.showDeleted ? 0 : this.countDeleted) + 1;
            this.curState = 4;
        }
    }

    private void _beforeFirst() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
        } else {
            this.curRow = -1;
            this.absolutePos = 0;
            this.curState = 0;
        }
    }

    private byte[] HexString2Bin(String str) throws SQLException {
        if (str == null) {
            return null;
        }
        int slen = str.length() / 2 * 2;
        byte[] bdata = new byte[slen / 2];
        int i = 0;
        int j = 0;
        while (i < slen) {
            int c1 = Character.digit(str.charAt(i), 16);
            int c0 = Character.digit(str.charAt(i + 1), 16);
            if (c1 == -1 || c0 == -1) {
                throw OPLMessage_x.makeException(22);
            }
            bdata[j] = (byte)(c1 * 16 + c0);
            i += 2;
            ++j;
        }
        return bdata;
    }

    private String Bin2Hex(byte[] bdata) {
        if (bdata == null) {
            return null;
        }
        String hex = "0123456789ABCDEF";
        StringBuffer hstr = new StringBuffer(bdata.length * 2);
        for (int i = 0; i < bdata.length; ++i) {
            byte val = bdata[i];
            hstr.append(hex.charAt(val >>> 4 & 0xF));
            hstr.append(hex.charAt(val & 0xF));
        }
        return hstr.toString();
    }

    private Date _getDate(String s) {
        Date dt = null;
        if (s == null) {
            return null;
        }
        try {
            dt = Date.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dt == null) {
            try {
                DateFormat df = DateFormat.getDateInstance();
                java.util.Date juD = df.parse(s);
                dt = new Date(juD.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dt;
    }

    private Timestamp _getTimestamp(String s) {
        Timestamp ts = null;
        if (s == null) {
            return null;
        }
        try {
            ts = Timestamp.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ts == null) {
            try {
                DateFormat df = DateFormat.getDateInstance();
                java.util.Date juD = df.parse(s);
                ts = new Timestamp(juD.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ts;
    }

    private Time _getTime(String s) {
        Time tm = null;
        if (s == null) {
            return null;
        }
        try {
            tm = Time.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tm == null) {
            try {
                DateFormat df = DateFormat.getTimeInstance();
                java.util.Date juD = df.parse(s);
                tm = new Time(juD.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tm;
    }

    private class RowSetWriter
    implements Serializable,
    Cloneable {
        private transient Connection conn;
        private String updateSQL;
        private String deleteSQL;
        private String insertSQL;
        private int[] keyCols;
        private ResultSetMetaData rsmd;
        private int colCount;
        private LinkedList<Object> params = new LinkedList();

        private RowSetWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeData(RowSetInternal x) throws SQLException {
            OPLCachedRowSet crs = (OPLCachedRowSet)x;
            boolean showDel = false;
            boolean conflict = false;
            this.conn = crs.rowSetReader.connect(crs);
            if (this.conn == null) {
                throw OPLMessage_x.makeException(31);
            }
            if (this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(false);
            }
            this.conn.setTransactionIsolation(crs.getTransactionIsolation());
            this.initializeStmts(crs);
            showDel = crs.getShowDeleted();
            crs.setShowDeleted(true);
            try {
                crs.beforeFirst();
                while (!conflict && crs.next()) {
                    if (!crs.rowDeleted() || crs.rowInserted()) continue;
                    conflict = this.doDelete(crs);
                }
                crs.beforeFirst();
                while (!conflict && crs.next()) {
                    if (!crs.rowUpdated() || crs.rowDeleted() || crs.rowInserted()) continue;
                    conflict = this.doUpdate(crs);
                }
                PreparedStatement pstmtInsert = this.conn.prepareStatement(this.insertSQL);
                try {
                    pstmtInsert.setMaxFieldSize(crs.getMaxFieldSize());
                    pstmtInsert.setEscapeProcessing(crs.getEscapeProcessing());
                    pstmtInsert.setQueryTimeout(crs.getQueryTimeout());
                }
                catch (Exception e) {
                    // empty catch block
                }
                crs.beforeFirst();
                while (!conflict && crs.next()) {
                    if (!crs.rowInserted() || crs.rowDeleted()) continue;
                    conflict = this.doInsert(pstmtInsert, crs);
                }
                try {
                    pstmtInsert.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                crs.setShowDeleted(showDel);
            }
            try {
                if (conflict) {
                    this.conn.rollback();
                    boolean bl = false;
                    return bl;
                }
                this.conn.commit();
                boolean bl = true;
                return bl;
            }
            finally {
                crs.rowSetReader.close();
                this.conn = null;
                this.rsmd = null;
                this.params.clear();
            }
        }

        private boolean doUpdate(OPLCachedRowSet crs) throws SQLException {
            ResultSet rs_orig = crs.getOriginalRow();
            if (!rs_orig.next()) {
                return true;
            }
            StringBuffer tmpSQL = new StringBuffer(this.updateSQL);
            LinkedList<Integer> setData = new LinkedList<Integer>();
            boolean comma = false;
            for (int i = 1; i <= this.colCount; ++i) {
                if (!crs.columnUpdated(i)) continue;
                if (!comma) {
                    comma = true;
                } else {
                    tmpSQL.append(", ");
                }
                tmpSQL.append(this.rsmd.getColumnName(i));
                tmpSQL.append(" = ? ");
                setData.add(i);
            }
            tmpSQL.append(" WHERE ");
            tmpSQL.append(this.createWhere(this.keyCols, rs_orig));
            PreparedStatement pstmt = this.conn.prepareStatement(tmpSQL.toString());
            try {
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception e) {
                // empty catch block
            }
            int par = 0;
            Iterator i = setData.iterator();
            while (i.hasNext()) {
                int col = (Integer)i.next();
                Object x = crs.getObject(col);
                if (crs.wasNull()) {
                    pstmt.setNull(++par, this.rsmd.getColumnType(col));
                    continue;
                }
                pstmt.setObject(++par, x);
            }
            i = this.params.iterator();
            while (i.hasNext()) {
                pstmt.setObject(++par, i.next());
            }
            if (pstmt.executeUpdate() != 1) {
                return true;
            }
            pstmt.close();
            return false;
        }

        private boolean doInsert(PreparedStatement insertPStmt, OPLCachedRowSet crs) throws SQLException {
            for (int i = 1; i <= this.colCount; ++i) {
                Object x = crs.getObject(i);
                if (crs.wasNull()) {
                    insertPStmt.setNull(i, this.rsmd.getColumnType(i));
                    continue;
                }
                insertPStmt.setObject(i, x);
            }
            return insertPStmt.executeUpdate() != 1;
        }

        private boolean doDelete(OPLCachedRowSet crs) throws SQLException {
            ResultSet rs = crs.getOriginalRow();
            if (!rs.next()) {
                return true;
            }
            String delWhere = this.createWhere(this.keyCols, rs);
            PreparedStatement pstmt = this.conn.prepareStatement(this.deleteSQL + delWhere);
            try {
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception e) {
                // empty catch block
            }
            int par = 0;
            Iterator i = this.params.iterator();
            while (i.hasNext()) {
                pstmt.setObject(++par, i.next());
            }
            if (pstmt.executeUpdate() != 1) {
                return true;
            }
            pstmt.close();
            return false;
        }

        private String createWhere(int[] keys, ResultSet rs) throws SQLException {
            StringBuffer tmp = new StringBuffer();
            this.params.clear();
            for (int i = 0; i < keys.length; ++i) {
                if (i > 0) {
                    tmp.append("AND ");
                }
                tmp.append(this.rsmd.getColumnName(keys[i]));
                Object x = rs.getObject(keys[i]);
                if (rs.wasNull()) {
                    tmp.append(" IS NULL ");
                    continue;
                }
                tmp.append(" = ? ");
                this.params.add(x);
            }
            return tmp.toString();
        }

        private void initializeStmts(OPLCachedRowSet crs) throws SQLException {
            this.rsmd = crs.getMetaData();
            if (this.rsmd == null) {
                throw OPLMessage_x.makeException(32);
            }
            this.colCount = this.rsmd.getColumnCount();
            if (this.colCount < 1) {
                return;
            }
            DatabaseMetaData dbmd = this.conn.getMetaData();
            String tableName = crs.getTableName();
            if (tableName == null) {
                String tabName;
                String schName = this.rsmd.getSchemaName(1);
                if (schName != null && schName.length() == 0) {
                    schName = null;
                }
                if ((tabName = this.rsmd.getTableName(1)) == null || tabName != null && tabName.length() == 0) {
                    throw OPLMessage_x.makeExceptionV(33, "'RowSetWriter'");
                }
                tableName = schName + "." + tabName;
            }
            StringBuffer _updateSQL = new StringBuffer("UPDATE ");
            StringBuffer _insertSQL = new StringBuffer("INSERT INTO ");
            StringBuffer _deleteSQL = new StringBuffer("DELETE FROM ");
            StringBuffer listColName = new StringBuffer();
            StringBuffer fullListParm = new StringBuffer();
            for (int i = 1; i <= this.colCount; ++i) {
                if (i > 1) {
                    listColName.append(", ");
                    fullListParm.append(", ");
                } else {
                    listColName.append(" ");
                    fullListParm.append(" ");
                }
                listColName.append(this.rsmd.getColumnName(i));
                fullListParm.append('?');
            }
            _updateSQL.append(tableName);
            _updateSQL.append(" SET ");
            _deleteSQL.append(tableName);
            _deleteSQL.append(" WHERE ");
            _insertSQL.append(tableName);
            _insertSQL.append("(");
            _insertSQL.append(listColName.toString());
            _insertSQL.append(") VALUES ( ");
            _insertSQL.append(fullListParm.toString());
            _insertSQL.append(")");
            this.insertSQL = _insertSQL.toString();
            this.updateSQL = _updateSQL.toString();
            this.deleteSQL = _deleteSQL.toString();
            this.setKeyCols(crs);
        }

        private void setKeyCols(OPLCachedRowSet crs) throws SQLException {
            this.keyCols = crs.getKeyCols();
            if (this.keyCols == null || this.keyCols.length == 0) {
                int count = 0;
                int[] tmpCols = new int[this.colCount];
                for (int i = 1; i <= this.colCount; ++i) {
                    switch (this.rsmd.getColumnType(i)) {
                        case -15: 
                        case -9: 
                        case -8: 
                        case -7: 
                        case -6: 
                        case -5: 
                        case -3: 
                        case -2: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 16: 
                        case 70: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 2001: {
                            tmpCols[count++] = i;
                        }
                    }
                }
                if (count > 0) {
                    this.keyCols = new int[count];
                    System.arraycopy(tmpCols, 0, this.keyCols, 0, count);
                }
            }
            if (this.keyCols == null && this.keyCols.length == 0) {
                throw OPLMessage_x.makeExceptionV(34, "'RowSetWriter'");
            }
        }
    }

    private class RowSetReader
    implements Serializable,
    Cloneable {
        private transient Connection conn;

        private RowSetReader() {
        }

        protected Connection connect(RowSet rowSet) throws SQLException {
            String connName = rowSet.getDataSourceName();
            if (connName != null) {
                try {
                    InitialContext initialcontext = new InitialContext();
                    DataSource ds = (DataSource)initialcontext.lookup(connName);
                    return ds.getConnection(rowSet.getUsername(), rowSet.getPassword());
                }
                catch (NamingException e) {
                    throw OPLMessage_x.makeException(e);
                }
            }
            connName = rowSet.getUrl();
            if (connName != null) {
                return DriverManager.getConnection(connName, rowSet.getUsername(), rowSet.getPassword());
            }
            return null;
        }

        private void setParams(PreparedStatement pstmt, Object[] params) throws SQLException {
            if (params == null) {
                return;
            }
            block14: for (int i = 0; i < params.length; ++i) {
                BaseRowSet.Parameter par = (BaseRowSet.Parameter)params[i];
                switch (par.jType) {
                    case 0: {
                        pstmt.setObject(i + 1, par.value);
                        continue block14;
                    }
                    case 1: {
                        pstmt.setObject(i + 1, par.value, par.sqlType);
                        continue block14;
                    }
                    case 2: {
                        pstmt.setObject(i + 1, par.value, par.sqlType, par.scale);
                        continue block14;
                    }
                    case 3: {
                        pstmt.setAsciiStream(i + 1, (InputStream)par.value, par.length);
                        continue block14;
                    }
                    case 4: {
                        pstmt.setBinaryStream(i + 1, (InputStream)par.value, par.length);
                        continue block14;
                    }
                    case 5: {
                        pstmt.setUnicodeStream(i + 1, (InputStream)par.value, par.length);
                        continue block14;
                    }
                    case 6: {
                        pstmt.setCharacterStream(i + 1, (Reader)par.value, par.length);
                        continue block14;
                    }
                    case 7: {
                        pstmt.setDate(i + 1, (Date)par.value, par.cal);
                        continue block14;
                    }
                    case 8: {
                        pstmt.setTime(i + 1, (Time)par.value, par.cal);
                        continue block14;
                    }
                    case 9: {
                        pstmt.setTimestamp(i + 1, (Timestamp)par.value, par.cal);
                        continue block14;
                    }
                    case 10: {
                        pstmt.setNull(i + 1, par.sqlType);
                        continue block14;
                    }
                    case 11: {
                        pstmt.setNull(i + 1, par.sqlType, par.typeName);
                        continue block14;
                    }
                    default: {
                        throw OPLMessage_x.makeException(10);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readData(RowSetInternal x) throws SQLException {
            boolean doDisconnect = false;
            this.close();
            try {
                OPLCachedRowSet crs = (OPLCachedRowSet)x;
                crs.release();
                this.conn = x.getConnection();
                if (this.conn == null) {
                    this.conn = this.connect(crs);
                    doDisconnect = true;
                }
                if (this.conn == null || crs.getCommand() == null) {
                    throw OPLMessage_x.makeException(11);
                }
                try {
                    this.conn.setTransactionIsolation(crs.getTransactionIsolation());
                }
                catch (Exception e) {
                    // empty catch block
                }
                PreparedStatement pstmt = this.conn.prepareStatement(crs.getCommand(), crs.getType(), crs.getConcurrency());
                this.setParams(pstmt, x.getParams());
                try {
                    pstmt.setMaxRows(crs.getMaxRows());
                    pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                    pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                    pstmt.setQueryTimeout(crs.getQueryTimeout());
                }
                catch (Exception e) {
                    // empty catch block
                }
                ResultSet rs = pstmt.executeQuery();
                crs.populate(rs);
                rs.close();
                pstmt.close();
                try {
                    this.conn.commit();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                if (this.conn != null && doDisconnect) {
                    this.conn.close();
                } else {
                    this.conn = null;
                }
            }
        }

        private void close() throws SQLException {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
    }

    private class Scanner {
        int pos = 0;
        int end;
        char[] query;
        static final String blankChars = " \t\n\r\f";
        static final String symb = "_-$#";
        HashMap<String, Integer> keywords = new HashMap();
        Token tok = null;

        private Scanner(String sql) {
            this.query = sql.toCharArray();
            this.end = this.query.length - 1;
            this.keywords.put("SELECT", 6);
            this.keywords.put("FROM", 7);
            this.keywords.put("WHERE", 8);
            this.keywords.put("ORDER", 9);
            this.keywords.put("BY", 10);
            this.keywords.put("GROUP", 11);
            this.keywords.put("UNION", 12);
            this.keywords.put("HAVING", 13);
        }

        private String check_Select() {
            String tableName = null;
            this.tok = this.nextToken();
            if (this.tok == null || this.tok.type != 6) {
                return null;
            }
            while ((this.tok = this.nextToken()) != null && this.tok.type != 7) {
            }
            tableName = this.table_name();
            if (tableName == null) {
                return null;
            }
            if (this.tok == null) {
                return tableName;
            }
            if (this.tok.type == 5 && (this.tok = this.nextToken()) == null) {
                return tableName;
            }
            if (this.tok.type == 8) {
                while ((this.tok = this.nextToken()) != null && this.tok.type != 11 && this.tok.type != 13) {
                }
            } else {
                return null;
            }
            if (this.tok != null) {
                return null;
            }
            return tableName;
        }

        private String table_name() {
            int state = 0;
            StringBuffer table = new StringBuffer();
            block27: while ((this.tok = this.nextToken()) != null) {
                switch (state) {
                    case 0: {
                        if (this.tok.type == 5) {
                            state = 1;
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            continue block27;
                        }
                        return null;
                    }
                    case 1: {
                        switch (this.tok.type) {
                            case 1: {
                                table.append('.');
                                state = 2;
                                continue block27;
                            }
                            case 3: {
                                table.append('@');
                                state = 3;
                                continue block27;
                            }
                            case 2: {
                                table.append(':');
                                state = 4;
                                continue block27;
                            }
                        }
                        return table.toString();
                    }
                    case 2: {
                        switch (this.tok.type) {
                            case 5: {
                                table.append(new String(this.query, this.tok.start, this.tok.length));
                                state = 5;
                                continue block27;
                            }
                            case 1: {
                                table.append('.');
                                state = 6;
                                continue block27;
                            }
                        }
                        return null;
                    }
                    case 3: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 4: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 7;
                            continue block27;
                        }
                        return null;
                    }
                    case 5: {
                        switch (this.tok.type) {
                            case 1: {
                                table.append('.');
                                state = 8;
                                continue block27;
                            }
                            case 3: {
                                table.append('@');
                                state = 9;
                                continue block27;
                            }
                        }
                        return table.toString();
                    }
                    case 6: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 7: {
                        if (this.tok.type == 1) {
                            table.append('.');
                            state = 10;
                            continue block27;
                        }
                        return table.toString();
                    }
                    case 8: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 9: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 10: {
                        if (this.tok.type == 5) {
                            table.append(new String(this.query, this.tok.start, this.tok.length));
                            state = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 99: {
                        return table.toString();
                    }
                }
                return null;
            }
            if (state == 1 || state == 5 || state == 7 || state == 99) {
                return table.toString();
            }
            return null;
        }

        private Token nextToken() {
            if (this.pos <= this.end) {
                while (this.pos <= this.end && this.isBlank(this.query[this.pos])) {
                    ++this.pos;
                }
                if (this.pos > this.end) {
                    return null;
                }
                switch (this.query[this.pos++]) {
                    case '.': {
                        return new Token(1);
                    }
                    case ':': {
                        return new Token(2);
                    }
                    case '@': {
                        return new Token(3);
                    }
                    case ',': {
                        return new Token(4);
                    }
                    case '\"': 
                    case '\'': {
                        char ch = this.query[this.pos - 1];
                        int start = this.pos - 1;
                        if (this.pos <= this.end && (this.query[this.pos] == '_' || Character.isLetterOrDigit(this.query[this.pos]))) {
                            while (this.pos <= this.end && this.isLetterOrDigit(this.query[this.pos])) {
                                ++this.pos;
                            }
                            if (this.pos > this.end || this.pos <= this.end && this.query[this.pos] != ch) {
                                return new Token(-1);
                            }
                            ++this.pos;
                            return new Token(5, start, this.pos - 1, true);
                        }
                        return new Token(-1);
                    }
                }
                int start = this.pos - 1;
                if (this.pos <= this.end && (this.query[this.pos] == '_' || Character.isLetterOrDigit(this.query[this.pos]))) {
                    while (this.pos <= this.end && this.isLetterOrDigit(this.query[this.pos])) {
                        ++this.pos;
                    }
                    Integer tok_type = this.keywords.get(new String(this.query, start, this.pos - start).toUpperCase());
                    if (tok_type != null) {
                        return new Token((int)tok_type, start, this.pos - 1);
                    }
                    return new Token(5, start, this.pos - 1);
                }
                return new Token(this.query[start]);
            }
            return null;
        }

        private boolean isBlank(int ch) {
            return blankChars.indexOf(ch) != -1;
        }

        private boolean isLetterOrDigit(int ch) {
            return Character.isLetterOrDigit((char)ch) || symb.indexOf(ch) != -1;
        }

        private class Token {
            static final int T_ERROR = -1;
            static final int T_CHAR = 0;
            static final int T_DOT = 1;
            static final int T_COLON = 2;
            static final int T_DELIM = 3;
            static final int T_COMMA = 4;
            static final int T_STRING = 5;
            static final int T_SELECT = 6;
            static final int T_FROM = 7;
            static final int T_WHERE = 8;
            static final int T_ORDER = 9;
            static final int T_BY = 10;
            static final int T_GROUP = 11;
            static final int T_UNION = 12;
            static final int T_HAVING = 13;
            private int type;
            private int start;
            private int end;
            private int length;
            private boolean quoted;
            private char symbol;

            private Token(int _type, int _start, int _end) {
                this.type = _type;
                this.start = _start;
                this.end = _end;
                this.length = this.end - this.start + 1;
            }

            private Token(int _type, int _start, int _end, boolean _quoted) {
                this(_type, _start, _end);
                this.quoted = _quoted;
            }

            private Token(int _type) {
                this.type = _type;
            }

            private Token(char _symbol) {
                this.type = 0;
                this.symbol = _symbol;
            }
        }
    }

    protected class Row
    implements Serializable,
    Cloneable {
        private Object[] origData;
        private Object[] curData;
        private BitSet colUpdated;
        private int cols;
        protected boolean isDeleted;
        protected boolean isUpdated;
        protected boolean isInserted;

        private Row(int count) {
            this.origData = new Object[count];
            this.curData = new Object[count];
            this.colUpdated = new BitSet(count);
            this.cols = count;
        }

        private Row(Object[] data) {
            this.cols = data.length;
            this.origData = new Object[this.cols];
            this.curData = new Object[this.cols];
            this.colUpdated = new BitSet(this.cols);
            for (int i = 0; i < this.cols; ++i) {
                this.origData[i] = data[i];
            }
        }

        private void clear() {
            for (int i = 0; i < this.cols; ++i) {
                this.origData[i] = null;
                this.curData[i] = null;
                this.colUpdated.clear(i);
            }
            this.cols = 0;
        }

        private void setOrigColData(int col, Object data) {
            this.origData[col - 1] = data;
        }

        private boolean isColUpdated(int col) {
            return this.colUpdated.get(col - 1);
        }

        private Object getColData(int col) {
            if (this.colUpdated.get(--col)) {
                return this.curData[col];
            }
            return this.origData[col];
        }

        private void setColData(int col, Object data) {
            this.colUpdated.set(--col);
            this.curData[col] = data;
        }

        private Object[] getOrigData() {
            return this.origData;
        }

        private Object[] getCurData() {
            return this.curData;
        }

        private BitSet getListUpdatedCols() {
            return this.colUpdated;
        }

        private void update(Object[] data, BitSet changedCols) {
            if (data.length != this.cols) {
                throw new IllegalArgumentException();
            }
            this.isUpdated = true;
            for (int i = 0; i < this.cols; ++i) {
                if (!changedCols.get(i)) continue;
                this.colUpdated.set(i);
                this.curData[i] = data[i];
            }
        }

        private void clearUpdated() {
            this.isUpdated = false;
            for (int i = 0; i < this.cols; ++i) {
                this.curData[i] = null;
                this.colUpdated.clear(i);
            }
        }

        private boolean isCompleted() throws SQLException {
            if (OPLCachedRowSet.this.rowSMD == null) {
                return false;
            }
            for (int i = 0; i < this.cols; ++i) {
                if (this.colUpdated.get(i) || OPLCachedRowSet.this.rowSMD.isNullable(i + 1) != 0) continue;
                return false;
            }
            return true;
        }

        private void moveCurToOrig() {
            for (int i = 0; i < this.cols; ++i) {
                if (!this.colUpdated.get(i)) continue;
                this.origData[i] = this.curData[i];
                this.colUpdated.clear(i);
                this.curData[i] = null;
            }
            this.isUpdated = false;
            this.isInserted = false;
        }
    }
}

