/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import virtuoso.jena.driver.VirtGraph;

public class VirtPrefixMapping
extends PrefixMappingImpl {
    protected VirtGraph m_graph = null;

    public VirtPrefixMapping(VirtGraph graph) {
        this.m_graph = graph;
        String query = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        Statement stmt = null;
        try {
            stmt = this.m_graph.createStatement(false);
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String prefix = rs.getString(1);
                String uri = rs.getString(2);
                if (prefix == null || uri == null) continue;
                super.setNsPrefix(prefix, uri);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String query = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 2)";
        super.removeNsPrefix(prefix);
        PreparedStatement ps = null;
        try {
            ps = this.m_graph.prepareStatement(query, false);
            ps.setString(1, prefix);
            ps.execute();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        return this;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        super.setNsPrefix(prefix, uri);
        String query = "DB.DBA.XML_SET_NS_DECL(?, ?, 2)";
        PreparedStatement ps = null;
        try {
            ps = this.m_graph.prepareStatement(query, false);
            ps.setString(1, prefix);
            ps.setString(2, uri);
            ps.execute();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map other) {
        this.checkUnlocked();
        for (Map.Entry e : other.entrySet()) {
            this.setNsPrefix((String)e.getKey(), (String)e.getValue());
        }
        return this;
    }
}

