"""Test for compatibility with Mercurial API"""

import inspect

import pytest
from nose.tools import *

from tortoisehg.util import hglib, pipeui

def test_same_argspec(f, g):
    fa, ga = inspect.getargspec(f), inspect.getargspec(g)
    assert_equals(fa, ga,
                  '%s != %s' % (inspect.formatargspec(*fa),
                                inspect.formatargspec(*ga)))

def overridden_methods(cls):
    basemethods = inspect.getmembers(cls.__base__, inspect.ismethod)
    return [(basemeth, getattr(cls, name))
            for name, basemeth in basemethods
            if basemeth.__func__ is not getattr(cls, name).__func__]


def pytest_generate_tests(metafunc):
    ui = hglib.loadui()
    pipeui.uisetup(ui)
    if metafunc.function == test_same_argspec:
        metafunc.parametrize('f, g', overridden_methods(ui.__class__))
