# The PEP 484 type hints stub file for the QtGui module.
#
# Generated by SIP 4.19.19
#
# Copyright (c) 2019 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from typing import overload

from PyQt5 import QtCore
from PyQt5.QtWidgets import QAction

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[...], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_SHADER_ATTRIBUTE_ARRAY = typing.Union[typing.Sequence[QVector2D],
        typing.Sequence[QVector3D], typing.Sequence[QVector4D],
        typing.Sequence[typing.Sequence[float]]]
PYQT_SHADER_UNIFORM_VALUE_ARRAY = typing.Union[typing.Sequence[QVector2D],
        typing.Sequence[QVector3D], typing.Sequence[QVector4D],
        typing.Sequence[QMatrix2x2], typing.Sequence[QMatrix2x3],
        typing.Sequence[QMatrix2x4], typing.Sequence[QMatrix3x2],
        typing.Sequence[QMatrix3x3], typing.Sequence[QMatrix3x4],
        typing.Sequence[QMatrix4x2], typing.Sequence[QMatrix4x3],
        typing.Sequence[QMatrix4x4], typing.Sequence[typing.Sequence[float]]]


class QAbstractTextDocumentLayout(QtCore.QObject):

    documentSizeChanged: PYQT_SIGNAL
    pageCountChanged: PYQT_SIGNAL
    update: PYQT_SIGNAL
    updateBlock: PYQT_SIGNAL

    class Selection:

        cursor = ... # type: QTextCursor
        format = ... # type: QTextCharFormat

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QAbstractTextDocumentLayout.Selection) -> None: ...

    class PaintContext:

        clip = ... # type: QtCore.QRectF
        cursorPosition = ... # type: int
        palette = ... # type: QPalette
        selections = ... # type: typing.Iterable[QAbstractTextDocumentLayout.Selection]

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QAbstractTextDocumentLayout.PaintContext) -> None: ...

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def formatAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QTextFormat: ...
    def imageAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> str: ...
    def format(self, pos: int) -> QTextCharFormat: ...
    def drawInlineObject(self, painter: QPainter, rect: QtCore.QRectF, object: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def positionInlineObject(self, item: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def resizeInlineObject(self, item: QTextInlineObject, posInDocument: int, format: QTextFormat) -> None: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None: ...
    #def updateBlock(self, block: QTextBlock) -> None: ...
    #def pageCountChanged(self, newPages: int) -> None: ...
    #def documentSizeChanged(self, newSize: QtCore.QSizeF) -> None: ...
    #def update(self, rect: QtCore.QRectF = ...) -> None: ...
    def handlerForObject(self, objectType: int) -> QTextObjectInterface: ...
    def unregisterHandler(self, objectType: int, component: typing.Optional[QtCore.QObject] = ...) -> None: ...
    def registerHandler(self, objectType: int, component: QtCore.QObject) -> None: ...
    def document(self) -> QTextDocument: ...
    def paintDevice(self) -> QPaintDevice: ...
    def setPaintDevice(self, device: QPaintDevice) -> None: ...
    def blockBoundingRect(self, block: QTextBlock) -> QtCore.QRectF: ...
    def frameBoundingRect(self, frame: QTextFrame) -> QtCore.QRectF: ...
    def documentSize(self) -> QtCore.QSizeF: ...
    def pageCount(self) -> int: ...
    def anchorAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> str: ...
    def hitTest(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], accuracy: int) -> int: ...
    def draw(self, painter: QPainter, context: QAbstractTextDocumentLayout.PaintContext) -> None: ...


class QTextObjectInterface(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextObjectInterface) -> None: ...

    def drawObject(self, painter: QPainter, rect: QtCore.QRectF, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> None: ...
    def intrinsicSize(self, doc: QTextDocument, posInDocument: int, format: QTextFormat) -> QtCore.QSizeF: ...


class QBackingStore(sip.simplewrapper):

    def __init__(self, window: QWindow) -> None: ...

    def hasStaticContents(self) -> bool: ...
    def staticContents(self) -> QRegion: ...
    def setStaticContents(self, region: QRegion) -> None: ...
    def endPaint(self) -> None: ...
    def beginPaint(self, a0: QRegion) -> None: ...
    def scroll(self, area: QRegion, dx: int, dy: int) -> bool: ...
    def size(self) -> QtCore.QSize: ...
    def resize(self, size: QtCore.QSize) -> None: ...
    def flush(self, region: QRegion, window: typing.Optional[QWindow] = ..., offset: QtCore.QPoint = ...) -> None: ...
    def paintDevice(self) -> QPaintDevice: ...
    def window(self) -> QWindow: ...


class QPaintDevice(sip.simplewrapper):

    PaintDeviceMetric: typing.Type[int]
    #class PaintDeviceMetric(int): ...
    PdmWidth = ... # type: int
    PdmHeight = ... # type: int
    PdmWidthMM = ... # type: int
    PdmHeightMM = ... # type: int
    PdmNumColors = ... # type: int
    PdmDepth = ... # type: int
    PdmDpiX = ... # type: int
    PdmDpiY = ... # type: int
    PdmPhysicalDpiX = ... # type: int
    PdmPhysicalDpiY = ... # type: int
    PdmDevicePixelRatio = ... # type: int
    PdmDevicePixelRatioScaled = ... # type: int

    def __init__(self) -> None: ...

    @staticmethod
    def devicePixelRatioFScale() -> float: ...
    def devicePixelRatioF(self) -> float: ...
    def metric(self, metric: int) -> int: ...
    def devicePixelRatio(self) -> int: ...
    def colorCount(self) -> int: ...
    def paintingActive(self) -> bool: ...
    def depth(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def physicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def logicalDpiX(self) -> int: ...
    def heightMM(self) -> int: ...
    def widthMM(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...


class QPixmap(QPaintDevice):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, a0: QtCore.QSize) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def __init__(self, xpm: typing.List[str]) -> None: ...
    @overload
    def __init__(self, a0: QPixmap) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def swap(self, other: QPixmap) -> None: ...
    @overload
    def scroll(self, dx: int, dy: int, rect: QtCore.QRect) -> QRegion: ...
    @overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int) -> QRegion: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def trueMatrix(m: QTransform, w: int, h: int) -> QTransform: ...
    def transformed(self, transform: QTransform, mode: int = ...) -> QPixmap: ...
    def metric(self, a0: int) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def isQBitmap(self) -> bool: ...
    def detach(self) -> None: ...
    @overload
    def copy(self, rect: QtCore.QRect = ...) -> QPixmap: ...
    @overload
    def copy(self, ax: int, ay: int, awidth: int, aheight: int) -> QPixmap: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, device: QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def loadFromData(self, buf: bytes, format: typing.Optional[str] = ..., flags: typing.Union[int, int] = ...) -> bool: ...
    @overload
    def loadFromData(self, buf: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ..., flags: typing.Union[int, int] = ...) -> bool: ...
    def load(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[int, int] = ...) -> bool: ...
    def convertFromImage(self, img: QImage, flags: typing.Union[int, int] = ...) -> bool: ...
    @staticmethod
    def fromImageReader(imageReader: QImageReader, flags: typing.Union[int, int] = ...) -> QPixmap: ...
    @staticmethod
    def fromImage(image: QImage, flags: typing.Union[int, int] = ...) -> QPixmap: ...
    def toImage(self) -> QImage: ...
    def scaledToHeight(self, height: int, mode: int = ...) -> QPixmap: ...
    def scaledToWidth(self, width: int, mode: int = ...) -> QPixmap: ...
    @overload
    def scaled(self, width: int, height: int, aspectRatioMode: int = ..., transformMode: int = ...) -> QPixmap: ...
    @overload
    def scaled(self, size: QtCore.QSize, aspectRatioMode: int = ..., transformMode: int = ...) -> QPixmap: ...
    def createMaskFromColor(self, maskColor: typing.Union[QColor, int, QGradient], mode: int = ...) -> QBitmap: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> QBitmap: ...
    def hasAlphaChannel(self) -> bool: ...
    def hasAlpha(self) -> bool: ...
    def setMask(self, a0: QBitmap) -> None: ...
    def mask(self) -> QBitmap: ...
    def fill(self, color: typing.Union[QColor, int, QGradient] = ...) -> None: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def rect(self) -> QtCore.QRect: ...
    def size(self) -> QtCore.QSize: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QBitmap(QPixmap):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QBitmap) -> None: ...
    @overload
    def __init__(self, a0: QPixmap) -> None: ...
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, a0: QtCore.QSize) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: QBitmap) -> None: ...
    def transformed(self, matrix: QTransform) -> QBitmap: ...
    @staticmethod
    def fromData(size: QtCore.QSize, bits: bytes, format: int = ...) -> QBitmap: ...
    @staticmethod
    def fromImage(image: QImage, flags: typing.Union[int, int] = ...) -> QBitmap: ...
    def clear(self) -> None: ...


class QColor(sip.simplewrapper):

    NameFormat: typing.Type[int]
    #class NameFormat(int): ...
    HexRgb = ... # type: int
    HexArgb = ... # type: int

    Spec: typing.Type[int]
    #class Spec(int): ...
    Invalid = ... # type: int
    Rgb = ... # type: int
    Hsv = ... # type: int
    Cmyk = ... # type: int
    Hsl = ... # type: int

    @overload
    def __init__(self, color: int) -> None: ...
    @overload
    def __init__(self, rgb: int) -> None: ...
    @overload
    def __init__(self, rgba64: QRgba64) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int, alpha: int = ...) -> None: ...
    @overload
    def __init__(self, aname: str) -> None: ...
    @overload
    def __init__(self, acolor: typing.Union[QColor, int, QGradient]) -> None: ...

    @overload
    @staticmethod
    def fromRgba64(r: int, g: int, b: int, alpha: int = ...) -> QColor: ...
    @overload
    @staticmethod
    def fromRgba64(rgba: QRgba64) -> QColor: ...
    def setRgba64(self, rgba: QRgba64) -> None: ...
    def rgba64(self) -> QRgba64: ...
    @staticmethod
    def isValidColor(name: str) -> bool: ...
    @staticmethod
    def fromHslF(h: float, s: float, l: float, alpha: float = ...) -> QColor: ...
    @staticmethod
    def fromHsl(h: int, s: int, l: int, alpha: int = ...) -> QColor: ...
    def toHsl(self) -> QColor: ...
    def setHslF(self, h: float, s: float, l: float, alpha: float = ...) -> None: ...
    def getHslF(self) -> typing.Tuple[float, float, float, float]: ...
    def setHsl(self, h: int, s: int, l: int, alpha: int = ...) -> None: ...
    def getHsl(self) -> typing.Tuple[int, int, int, int]: ...
    def lightnessF(self) -> float: ...
    def hslSaturationF(self) -> float: ...
    def hslHueF(self) -> float: ...
    def lightness(self) -> int: ...
    def hslSaturation(self) -> int: ...
    def hslHue(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvHue(self) -> int: ...
    def darker(self, factor: int = ...) -> QColor: ...
    def lighter(self, factor: int = ...) -> QColor: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def fromCmykF(c: float, m: float, y: float, k: float, alpha: float = ...) -> QColor: ...
    @staticmethod
    def fromCmyk(c: int, m: int, y: int, k: int, alpha: int = ...) -> QColor: ...
    @staticmethod
    def fromHsvF(h: float, s: float, v: float, alpha: float = ...) -> QColor: ...
    @staticmethod
    def fromHsv(h: int, s: int, v: int, alpha: int = ...) -> QColor: ...
    @staticmethod
    def fromRgbF(r: float, g: float, b: float, alpha: float = ...) -> QColor: ...
    @staticmethod
    def fromRgba(rgba: int) -> QColor: ...
    @overload
    @staticmethod
    def fromRgb(rgb: int) -> QColor: ...
    @overload
    @staticmethod
    def fromRgb(r: int, g: int, b: int, alpha: int = ...) -> QColor: ...
    def convertTo(self, colorSpec: int) -> QColor: ...
    def toCmyk(self) -> QColor: ...
    def toHsv(self) -> QColor: ...
    def toRgb(self) -> QColor: ...
    def setCmykF(self, c: float, m: float, y: float, k: float, alpha: float = ...) -> None: ...
    def getCmykF(self) -> typing.Tuple[float, float, float, float, float]: ...
    def setCmyk(self, c: int, m: int, y: int, k: int, alpha: int = ...) -> None: ...
    def getCmyk(self) -> typing.Tuple[int, int, int, int, int]: ...
    def blackF(self) -> float: ...
    def yellowF(self) -> float: ...
    def magentaF(self) -> float: ...
    def cyanF(self) -> float: ...
    def black(self) -> int: ...
    def yellow(self) -> int: ...
    def magenta(self) -> int: ...
    def cyan(self) -> int: ...
    def setHsvF(self, h: float, s: float, v: float, alpha: float = ...) -> None: ...
    def getHsvF(self) -> typing.Tuple[float, float, float, float]: ...
    def setHsv(self, h: int, s: int, v: int, alpha: int = ...) -> None: ...
    def getHsv(self) -> typing.Tuple[int, int, int, int]: ...
    def valueF(self) -> float: ...
    def saturationF(self) -> float: ...
    def hueF(self) -> float: ...
    def value(self) -> int: ...
    def saturation(self) -> int: ...
    def hue(self) -> int: ...
    def rgb(self) -> int: ...
    def setRgba(self, rgba: int) -> None: ...
    def rgba(self) -> int: ...
    def setRgbF(self, r: float, g: float, b: float, alpha: float = ...) -> None: ...
    def getRgbF(self) -> typing.Tuple[float, float, float, float]: ...
    @overload
    def setRgb(self, r: int, g: int, b: int, alpha: int = ...) -> None: ...
    @overload
    def setRgb(self, rgb: int) -> None: ...
    def getRgb(self) -> typing.Tuple[int, int, int, int]: ...
    def setBlueF(self, blue: float) -> None: ...
    def setGreenF(self, green: float) -> None: ...
    def setRedF(self, red: float) -> None: ...
    def blueF(self) -> float: ...
    def greenF(self) -> float: ...
    def redF(self) -> float: ...
    def setBlue(self, blue: int) -> None: ...
    def setGreen(self, green: int) -> None: ...
    def setRed(self, red: int) -> None: ...
    def blue(self) -> int: ...
    def green(self) -> int: ...
    def red(self) -> int: ...
    def setAlphaF(self, alpha: float) -> None: ...
    def alphaF(self) -> float: ...
    def setAlpha(self, alpha: int) -> None: ...
    def alpha(self) -> int: ...
    def spec(self) -> int: ...
    @staticmethod
    def colorNames() -> typing.List[str]: ...
    def setNamedColor(self, name: str) -> None: ...
    @overload
    def name(self) -> str: ...
    @overload
    def name(self, format: int) -> str: ...


class QBrush(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bs: int) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor, int, QGradient], style: int = ...) -> None: ...
    @overload
    def __init__(self, color: typing.Union[QColor, int, QGradient], pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self, image: QImage) -> None: ...
    @overload
    def __init__(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: QBrush) -> None: ...
    def transform(self) -> QTransform: ...
    def setTransform(self, a0: QTransform) -> None: ...
    def textureImage(self) -> QImage: ...
    def setTextureImage(self, image: QImage) -> None: ...
    def color(self) -> QColor: ...
    def style(self) -> int: ...
    def isOpaque(self) -> bool: ...
    def gradient(self) -> QGradient: ...
    @overload
    def setColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setColor(self, acolor: int) -> None: ...
    def setTexture(self, pixmap: QPixmap) -> None: ...
    def texture(self) -> QPixmap: ...
    def setStyle(self, a0: int) -> None: ...


class QGradient(sip.simplewrapper):

    Preset: typing.Type[int]
    #class Preset(int): ...
    WarmFlame = ... # type: int
    NightFade = ... # type: int
    SpringWarmth = ... # type: int
    JuicyPeach = ... # type: int
    YoungPassion = ... # type: int
    LadyLips = ... # type: int
    SunnyMorning = ... # type: int
    RainyAshville = ... # type: int
    FrozenDreams = ... # type: int
    WinterNeva = ... # type: int
    DustyGrass = ... # type: int
    TemptingAzure = ... # type: int
    HeavyRain = ... # type: int
    AmyCrisp = ... # type: int
    MeanFruit = ... # type: int
    DeepBlue = ... # type: int
    RipeMalinka = ... # type: int
    CloudyKnoxville = ... # type: int
    MalibuBeach = ... # type: int
    NewLife = ... # type: int
    TrueSunset = ... # type: int
    MorpheusDen = ... # type: int
    RareWind = ... # type: int
    NearMoon = ... # type: int
    WildApple = ... # type: int
    SaintPetersburg = ... # type: int
    PlumPlate = ... # type: int
    EverlastingSky = ... # type: int
    HappyFisher = ... # type: int
    Blessing = ... # type: int
    SharpeyeEagle = ... # type: int
    LadogaBottom = ... # type: int
    LemonGate = ... # type: int
    ItmeoBranding = ... # type: int
    ZeusMiracle = ... # type: int
    OldHat = ... # type: int
    StarWine = ... # type: int
    HappyAcid = ... # type: int
    AwesomePine = ... # type: int
    NewYork = ... # type: int
    ShyRainbow = ... # type: int
    MixedHopes = ... # type: int
    FlyHigh = ... # type: int
    StrongBliss = ... # type: int
    FreshMilk = ... # type: int
    SnowAgain = ... # type: int
    FebruaryInk = ... # type: int
    KindSteel = ... # type: int
    SoftGrass = ... # type: int
    GrownEarly = ... # type: int
    SharpBlues = ... # type: int
    ShadyWater = ... # type: int
    DirtyBeauty = ... # type: int
    GreatWhale = ... # type: int
    TeenNotebook = ... # type: int
    PoliteRumors = ... # type: int
    SweetPeriod = ... # type: int
    WideMatrix = ... # type: int
    SoftCherish = ... # type: int
    RedSalvation = ... # type: int
    BurningSpring = ... # type: int
    NightParty = ... # type: int
    SkyGlider = ... # type: int
    HeavenPeach = ... # type: int
    PurpleDivision = ... # type: int
    AquaSplash = ... # type: int
    SpikyNaga = ... # type: int
    LoveKiss = ... # type: int
    CleanMirror = ... # type: int
    PremiumDark = ... # type: int
    ColdEvening = ... # type: int
    CochitiLake = ... # type: int
    SummerGames = ... # type: int
    PassionateBed = ... # type: int
    MountainRock = ... # type: int
    DesertHump = ... # type: int
    JungleDay = ... # type: int
    PhoenixStart = ... # type: int
    OctoberSilence = ... # type: int
    FarawayRiver = ... # type: int
    AlchemistLab = ... # type: int
    OverSun = ... # type: int
    PremiumWhite = ... # type: int
    MarsParty = ... # type: int
    EternalConstance = ... # type: int
    JapanBlush = ... # type: int
    SmilingRain = ... # type: int
    CloudyApple = ... # type: int
    BigMango = ... # type: int
    HealthyWater = ... # type: int
    AmourAmour = ... # type: int
    RiskyConcrete = ... # type: int
    StrongStick = ... # type: int
    ViciousStance = ... # type: int
    PaloAlto = ... # type: int
    HappyMemories = ... # type: int
    MidnightBloom = ... # type: int
    Crystalline = ... # type: int
    PartyBliss = ... # type: int
    ConfidentCloud = ... # type: int
    LeCocktail = ... # type: int
    RiverCity = ... # type: int
    FrozenBerry = ... # type: int
    ChildCare = ... # type: int
    FlyingLemon = ... # type: int
    NewRetrowave = ... # type: int
    HiddenJaguar = ... # type: int
    AboveTheSky = ... # type: int
    Nega = ... # type: int
    DenseWater = ... # type: int
    Seashore = ... # type: int
    MarbleWall = ... # type: int
    CheerfulCaramel = ... # type: int
    NightSky = ... # type: int
    MagicLake = ... # type: int
    YoungGrass = ... # type: int
    ColorfulPeach = ... # type: int
    GentleCare = ... # type: int
    PlumBath = ... # type: int
    HappyUnicorn = ... # type: int
    AfricanField = ... # type: int
    SolidStone = ... # type: int
    OrangeJuice = ... # type: int
    GlassWater = ... # type: int
    NorthMiracle = ... # type: int
    FruitBlend = ... # type: int
    MillenniumPine = ... # type: int
    HighFlight = ... # type: int
    MoleHall = ... # type: int
    SpaceShift = ... # type: int
    ForestInei = ... # type: int
    RoyalGarden = ... # type: int
    RichMetal = ... # type: int
    JuicyCake = ... # type: int
    SmartIndigo = ... # type: int
    SandStrike = ... # type: int
    NorseBeauty = ... # type: int
    AquaGuidance = ... # type: int
    SunVeggie = ... # type: int
    SeaLord = ... # type: int
    BlackSea = ... # type: int
    GrassShampoo = ... # type: int
    LandingAircraft = ... # type: int
    WitchDance = ... # type: int
    SleeplessNight = ... # type: int
    AngelCare = ... # type: int
    CrystalRiver = ... # type: int
    SoftLipstick = ... # type: int
    SaltMountain = ... # type: int
    PerfectWhite = ... # type: int
    FreshOasis = ... # type: int
    StrictNovember = ... # type: int
    MorningSalad = ... # type: int
    DeepRelief = ... # type: int
    SeaStrike = ... # type: int
    NightCall = ... # type: int
    SupremeSky = ... # type: int
    LightBlue = ... # type: int
    MindCrawl = ... # type: int
    LilyMeadow = ... # type: int
    SugarLollipop = ... # type: int
    SweetDessert = ... # type: int
    MagicRay = ... # type: int
    TeenParty = ... # type: int
    FrozenHeat = ... # type: int
    GagarinView = ... # type: int
    FabledSunset = ... # type: int
    PerfectBlue = ... # type: int

    Spread: typing.Type[int]
    #class Spread(int): ...
    PadSpread = ... # type: int
    ReflectSpread = ... # type: int
    RepeatSpread = ... # type: int

    Type: typing.Type[int]
    #class Type(int): ...
    LinearGradient = ... # type: int
    RadialGradient = ... # type: int
    ConicalGradient = ... # type: int
    NoGradient = ... # type: int

    CoordinateMode: typing.Type[int]
    #class CoordinateMode(int): ...
    LogicalMode = ... # type: int
    StretchToDeviceMode = ... # type: int
    ObjectBoundingMode = ... # type: int
    ObjectMode = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: int) -> None: ...
    @overload
    def __init__(self, a0: QGradient) -> None: ...

    def setCoordinateMode(self, mode: int) -> None: ...
    def coordinateMode(self) -> int: ...
    def setSpread(self, aspread: int) -> None: ...
    def stops(self) -> typing.List[typing.Tuple[float, QColor]]: ...
    def setStops(self, stops: typing.Iterable[typing.Tuple[float, typing.Union[QColor, int, QGradient]]]) -> None: ...
    def setColorAt(self, pos: float, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def spread(self) -> int: ...
    def type(self) -> int: ...


class QLinearGradient(QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint], finalStop: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...
    @overload
    def __init__(self, a0: QLinearGradient) -> None: ...

    @overload
    def setFinalStop(self, stop: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setFinalStop(self, x: float, y: float) -> None: ...
    @overload
    def setStart(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setStart(self, x: float, y: float) -> None: ...
    def finalStop(self) -> QtCore.QPointF: ...
    def start(self) -> QtCore.QPointF: ...


class QRadialGradient(QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], centerRadius: float, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint], focalRadius: float) -> None: ...
    @overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @overload
    def __init__(self, a0: QRadialGradient) -> None: ...

    def setFocalRadius(self, radius: float) -> None: ...
    def focalRadius(self) -> float: ...
    def setCenterRadius(self, radius: float) -> None: ...
    def centerRadius(self) -> float: ...
    def setRadius(self, radius: float) -> None: ...
    @overload
    def setFocalPoint(self, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setFocalPoint(self, x: float, y: float) -> None: ...
    @overload
    def setCenter(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...
    def radius(self) -> float: ...
    def focalPoint(self) -> QtCore.QPointF: ...
    def center(self) -> QtCore.QPointF: ...


class QConicalGradient(QGradient):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], startAngle: float) -> None: ...
    @overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...
    @overload
    def __init__(self, a0: QConicalGradient) -> None: ...

    def setAngle(self, angle: float) -> None: ...
    @overload
    def setCenter(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setCenter(self, x: float, y: float) -> None: ...
    def angle(self) -> float: ...
    def center(self) -> QtCore.QPointF: ...


class QClipboard(QtCore.QObject):

    changed: PYQT_SIGNAL
    dataChanged: PYQT_SIGNAL
    findBufferChanged: PYQT_SIGNAL
    selectionChanged: PYQT_SIGNAL

    Mode: typing.Type[int]
    #class Mode(int): ...
    Clipboard = ... # type: int
    Selection = ... # type: int
    FindBuffer = ... # type: int

    #def selectionChanged(self) -> None: ...
    #def findBufferChanged(self) -> None: ...
    #def dataChanged(self) -> None: ...
    #def changed(self, mode: int) -> None: ...
    def setPixmap(self, a0: QPixmap, mode: int = ...) -> None: ...
    def setImage(self, a0: QImage, mode: int = ...) -> None: ...
    def pixmap(self, mode: int = ...) -> QPixmap: ...
    def image(self, mode: int = ...) -> QImage: ...
    def setMimeData(self, data: QtCore.QMimeData, mode: int = ...) -> None: ...
    def mimeData(self, mode: int = ...) -> QtCore.QMimeData: ...
    def setText(self, a0: str, mode: int = ...) -> None: ...
    @overload
    def text(self, mode: int = ...) -> str: ...
    @overload
    def text(self, subtype: str, mode: int = ...) -> typing.Tuple[str, str]: ...
    def ownsSelection(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsClipboard(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    def supportsFindBuffer(self) -> bool: ...
    def clear(self, mode: int = ...) -> None: ...


class QCursor(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bitmap: QBitmap, mask: QBitmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @overload
    def __init__(self, cursor: typing.Union[QCursor, int]) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: typing.Union[QCursor, int]) -> None: ...
    @overload
    @staticmethod
    def setPos(x: int, y: int) -> None: ...
    @overload
    @staticmethod
    def setPos(p: QtCore.QPoint) -> None: ...
    @staticmethod
    def pos() -> QtCore.QPoint: ...
    def hotSpot(self) -> QtCore.QPoint: ...
    def pixmap(self) -> QPixmap: ...
    def mask(self) -> QBitmap: ...
    def bitmap(self) -> QBitmap: ...
    def setShape(self, newShape: int) -> None: ...
    def shape(self) -> int: ...


class QDesktopServices(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QDesktopServices) -> None: ...

    @staticmethod
    def unsetUrlHandler(scheme: str) -> None: ...
    @overload
    @staticmethod
    def setUrlHandler(scheme: str, receiver: QtCore.QObject, method: str) -> None: ...
    @overload
    @staticmethod
    def setUrlHandler(scheme: str, method: typing.Callable[[QtCore.QUrl], None]) -> None: ...
    @staticmethod
    def openUrl(url: QtCore.QUrl) -> bool: ...


class QDrag(QtCore.QObject):

    actionChanged: PYQT_SIGNAL
    targetChanged: PYQT_SIGNAL

    def __init__(self, dragSource: QtCore.QObject, **props) -> None: ...

    @staticmethod
    def cancel() -> None: ...
    def defaultAction(self) -> int: ...
    def supportedActions(self) -> int: ...
    def dragCursor(self, action: int) -> QPixmap: ...
    #def targetChanged(self, newTarget: QtCore.QObject) -> None: ...
    #def actionChanged(self, action: int) -> None: ...
    def setDragCursor(self, cursor: QPixmap, action: int) -> None: ...
    def target(self) -> QtCore.QObject: ...
    def source(self) -> QtCore.QObject: ...
    def hotSpot(self) -> QtCore.QPoint: ...
    def setHotSpot(self, hotspot: QtCore.QPoint) -> None: ...
    def pixmap(self) -> QPixmap: ...
    def setPixmap(self, a0: QPixmap) -> None: ...
    def mimeData(self) -> QtCore.QMimeData: ...
    def setMimeData(self, data: QtCore.QMimeData) -> None: ...
    @overload
    def exec(self, supportedActions: typing.Union[int, int] = ...) -> int: ...
    @overload
    def exec(self, supportedActions: typing.Union[int, int], defaultDropAction: int) -> int: ...
    @overload
    def exec_(self, supportedActions: typing.Union[int, int] = ...) -> int: ...
    @overload
    def exec_(self, supportedActions: typing.Union[int, int], defaultDropAction: int) -> int: ...


class QInputEvent(QtCore.QEvent):

    def setTimestamp(self, atimestamp: int) -> None: ...
    def timestamp(self) -> int: ...
    def modifiers(self) -> int: ...


class QMouseEvent(QInputEvent):

    @overload
    def __init__(self, type: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], button: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, type: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], button: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, type: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], button: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, type: int, localPos: typing.Union[QtCore.QPointF, QtCore.QPoint], windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint], screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint], button: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], source: int) -> None: ...
    @overload
    def __init__(self, a0: QMouseEvent) -> None: ...

    def flags(self) -> int: ...
    def source(self) -> int: ...
    def screenPos(self) -> QtCore.QPointF: ...
    def windowPos(self) -> QtCore.QPointF: ...
    def localPos(self) -> QtCore.QPointF: ...
    def buttons(self) -> int: ...
    def button(self) -> int: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QHoverEvent(QInputEvent):

    @overload
    def __init__(self, type: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], oldPos: typing.Union[QtCore.QPointF, QtCore.QPoint], modifiers: typing.Union[int, int] = ...) -> None: ...
    @overload
    def __init__(self, a0: QHoverEvent) -> None: ...

    def oldPosF(self) -> QtCore.QPointF: ...
    def posF(self) -> QtCore.QPointF: ...
    def oldPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QWheelEvent(QInputEvent):

    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], pixelDelta: QtCore.QPoint, angleDelta: QtCore.QPoint, qt4Delta: int, qt4Orientation: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], pixelDelta: QtCore.QPoint, angleDelta: QtCore.QPoint, qt4Delta: int, qt4Orientation: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], phase: int) -> None: ...
    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], pixelDelta: QtCore.QPoint, angleDelta: QtCore.QPoint, qt4Delta: int, qt4Orientation: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], phase: int, source: int) -> None: ...
    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], pixelDelta: QtCore.QPoint, angleDelta: QtCore.QPoint, qt4Delta: int, qt4Orientation: int, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], phase: int, source: int, inverted: bool) -> None: ...
    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], pixelDelta: QtCore.QPoint, angleDelta: QtCore.QPoint, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], phase: int, inverted: bool, source: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QWheelEvent) -> None: ...

    def inverted(self) -> bool: ...
    def source(self) -> int: ...
    def phase(self) -> int: ...
    def globalPosF(self) -> QtCore.QPointF: ...
    def posF(self) -> QtCore.QPointF: ...
    def angleDelta(self) -> QtCore.QPoint: ...
    def pixelDelta(self) -> QtCore.QPoint: ...
    def buttons(self) -> int: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QTabletEvent(QInputEvent):

    PointerType: typing.Type[int]
    #class PointerType(int): ...
    UnknownPointer = ... # type: int
    Pen = ... # type: int
    Cursor = ... # type: int
    Eraser = ... # type: int

    TabletDevice: typing.Type[int]
    #class TabletDevice(int): ...
    NoDevice = ... # type: int
    Puck = ... # type: int
    Stylus = ... # type: int
    Airbrush = ... # type: int
    FourDMouse = ... # type: int
    XFreeEraser = ... # type: int
    RotationStylus = ... # type: int

    @overload
    def __init__(self, t: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: typing.Union[int, int], uniqueID: int, button: int, buttons: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, t: int, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: typing.Union[int, int], uniqueID: int) -> None: ...
    @overload
    def __init__(self, a0: QTabletEvent) -> None: ...

    def buttons(self) -> int: ...
    def button(self) -> int: ...
    def globalPosF(self) -> QtCore.QPointF: ...
    def posF(self) -> QtCore.QPointF: ...
    def yTilt(self) -> int: ...
    def xTilt(self) -> int: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def z(self) -> int: ...
    def pressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def pointerType(self) -> int: ...
    def device(self) -> int: ...
    def hiResGlobalY(self) -> float: ...
    def hiResGlobalX(self) -> float: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QKeyEvent(QInputEvent):

    @overload
    def __init__(self, type: int, key: int, modifiers: typing.Union[int, int], nativeScanCode: int, nativeVirtualKey: int, nativeModifiers: int, text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @overload
    def __init__(self, type: int, key: int, modifiers: typing.Union[int, int], text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QKeyEvent) -> None: ...

    def nativeVirtualKey(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeModifiers(self) -> int: ...
    def matches(self, key: int) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def text(self) -> str: ...
    def modifiers(self) -> int: ...
    def key(self) -> int: ...


class QFocusEvent(QtCore.QEvent):

    @overload
    def __init__(self, type: int, reason: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QFocusEvent) -> None: ...

    def reason(self) -> int: ...
    def lostFocus(self) -> bool: ...
    def gotFocus(self) -> bool: ...


class QPaintEvent(QtCore.QEvent):

    @overload
    def __init__(self, paintRegion: QRegion) -> None: ...
    @overload
    def __init__(self, paintRect: QtCore.QRect) -> None: ...
    @overload
    def __init__(self, a0: QPaintEvent) -> None: ...

    def region(self) -> QRegion: ...
    def rect(self) -> QtCore.QRect: ...


class QMoveEvent(QtCore.QEvent):

    @overload
    def __init__(self, pos: QtCore.QPoint, oldPos: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, a0: QMoveEvent) -> None: ...

    def oldPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QResizeEvent(QtCore.QEvent):

    @overload
    def __init__(self, size: QtCore.QSize, oldSize: QtCore.QSize) -> None: ...
    @overload
    def __init__(self, a0: QResizeEvent) -> None: ...

    def oldSize(self) -> QtCore.QSize: ...
    def size(self) -> QtCore.QSize: ...


class QCloseEvent(QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QCloseEvent) -> None: ...


class QIconDragEvent(QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QIconDragEvent) -> None: ...


class QShowEvent(QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QShowEvent) -> None: ...


class QHideEvent(QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QHideEvent) -> None: ...


class QContextMenuEvent(QInputEvent):

    Reason: typing.Type[int]
    #class Reason(int): ...
    Mouse = ... # type: int
    Keyboard = ... # type: int
    Other = ... # type: int

    @overload
    def __init__(self, reason: int, pos: QtCore.QPoint, globalPos: QtCore.QPoint, modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, reason: int, pos: QtCore.QPoint, globalPos: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, reason: int, pos: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, a0: QContextMenuEvent) -> None: ...

    def reason(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...


class QInputMethodEvent(QtCore.QEvent):

    AttributeType: typing.Type[int]
    #class AttributeType(int): ...
    TextFormat = ... # type: int
    Cursor = ... # type: int
    Language = ... # type: int
    Ruby = ... # type: int
    Selection = ... # type: int

    class Attribute:

        length = ... # type: int
        start = ... # type: int
        type = ... # type: int
        value = ... # type: typing.Any

        @overload
        def __init__(self, t: int, s: int, l: int, val: typing.Any) -> None: ...
        @overload
        def __init__(self, typ: int, s: int, l: int) -> None: ...
        @overload
        def __init__(self, a0: QInputMethodEvent.Attribute) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, preeditText: str, attributes: typing.Iterable[QInputMethodEvent.Attribute]) -> None: ...
    @overload
    def __init__(self, other: QInputMethodEvent) -> None: ...

    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def attributes(self) -> typing.List[QInputMethodEvent.Attribute]: ...
    def setCommitString(self, commitString: str, from_: int = ..., length: int = ...) -> None: ...


class QInputMethodQueryEvent(QtCore.QEvent):

    @overload
    def __init__(self, queries: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, a0: QInputMethodQueryEvent) -> None: ...

    def value(self, query: int) -> typing.Any: ...
    def setValue(self, query: int, value: typing.Any) -> None: ...
    def queries(self) -> int: ...


class QDropEvent(QtCore.QEvent):

    @overload
    def __init__(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], actions: typing.Union[int, int], data: QtCore.QMimeData, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], type: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QDropEvent) -> None: ...

    def mimeData(self) -> QtCore.QMimeData: ...
    def source(self) -> QtCore.QObject: ...
    def setDropAction(self, action: int) -> None: ...
    def dropAction(self) -> int: ...
    def acceptProposedAction(self) -> None: ...
    def proposedAction(self) -> int: ...
    def possibleActions(self) -> int: ...
    def keyboardModifiers(self) -> int: ...
    def mouseButtons(self) -> int: ...
    def posF(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPoint: ...


class QDragMoveEvent(QDropEvent):

    @overload
    def __init__(self, pos: QtCore.QPoint, actions: typing.Union[int, int], data: QtCore.QMimeData, buttons: typing.Union[int, int], modifiers: typing.Union[int, int], type: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QDragMoveEvent) -> None: ...

    @overload
    def ignore(self) -> None: ...
    @overload
    def ignore(self, r: QtCore.QRect) -> None: ...
    @overload
    def accept(self) -> None: ...
    @overload
    def accept(self, r: QtCore.QRect) -> None: ...
    def answerRect(self) -> QtCore.QRect: ...


class QDragEnterEvent(QDragMoveEvent):

    @overload
    def __init__(self, pos: QtCore.QPoint, actions: typing.Union[int, int], data: QtCore.QMimeData, buttons: typing.Union[int, int], modifiers: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, a0: QDragEnterEvent) -> None: ...


class QDragLeaveEvent(QtCore.QEvent):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QDragLeaveEvent) -> None: ...


class QHelpEvent(QtCore.QEvent):

    @overload
    def __init__(self, type: int, pos: QtCore.QPoint, globalPos: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, a0: QHelpEvent) -> None: ...

    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...


class QStatusTipEvent(QtCore.QEvent):

    @overload
    def __init__(self, tip: str) -> None: ...
    @overload
    def __init__(self, a0: QStatusTipEvent) -> None: ...

    def tip(self) -> str: ...


class QWhatsThisClickedEvent(QtCore.QEvent):

    @overload
    def __init__(self, href: str) -> None: ...
    @overload
    def __init__(self, a0: QWhatsThisClickedEvent) -> None: ...

    def href(self) -> str: ...


class QActionEvent(QtCore.QEvent):

    @overload
    def __init__(self, type: int, action: QAction, before: typing.Optional[QAction] = ...) -> None: ...
    @overload
    def __init__(self, a0: QActionEvent) -> None: ...

    def before(self) -> QAction: ...
    def action(self) -> QAction: ...


class QFileOpenEvent(QtCore.QEvent):

    def openFile(self, file: QtCore.QFile, flags: typing.Union[int, int]) -> bool: ...
    def url(self) -> QtCore.QUrl: ...
    def file(self) -> str: ...


class QShortcutEvent(QtCore.QEvent):

    @overload
    def __init__(self, key: typing.Union[QKeySequence, int, str, int], id: int, ambiguous: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QShortcutEvent) -> None: ...

    def shortcutId(self) -> int: ...
    def key(self) -> QKeySequence: ...
    def isAmbiguous(self) -> bool: ...


class QWindowStateChangeEvent(QtCore.QEvent):

    def oldState(self) -> int: ...


class QTouchEvent(QInputEvent):

    class TouchPoint:

        InfoFlag: typing.Type[int]
        #class InfoFlag(int): ...
        Pen = ... # type: int
        Token = ... # type: int

        InfoFlags: typing.Type[int]
        #class InfoFlags(sip.simplewrapper):

            #@overload
            #def __init__(self) -> None: ...
            #@overload
            #def __init__(self, f: typing.Union[QTouchEvent.TouchPoint.InfoFlags, QTouchEvent.TouchPoint.InfoFlag]) -> None: ...
            #@overload
            #def __init__(self, a0: QTouchEvent.TouchPoint.InfoFlags) -> None: ...

            #def __hash__(self) -> int: ...
            #def __bool__(self) -> int: ...
            #def __invert__(self) -> QTouchEvent.TouchPoint.InfoFlags: ...
            #def __int__(self) -> int: ...

        def ellipseDiameters(self) -> QtCore.QSizeF: ...
        def rotation(self) -> float: ...
        def uniqueId(self) -> QPointingDeviceUniqueId: ...
        def rawScreenPositions(self) -> typing.List[QtCore.QPointF]: ...
        def flags(self) -> int: ...
        def velocity(self) -> QVector2D: ...
        def pressure(self) -> float: ...
        def screenRect(self) -> QtCore.QRectF: ...
        def sceneRect(self) -> QtCore.QRectF: ...
        def rect(self) -> QtCore.QRectF: ...
        def lastNormalizedPos(self) -> QtCore.QPointF: ...
        def startNormalizedPos(self) -> QtCore.QPointF: ...
        def normalizedPos(self) -> QtCore.QPointF: ...
        def lastScreenPos(self) -> QtCore.QPointF: ...
        def startScreenPos(self) -> QtCore.QPointF: ...
        def screenPos(self) -> QtCore.QPointF: ...
        def lastScenePos(self) -> QtCore.QPointF: ...
        def startScenePos(self) -> QtCore.QPointF: ...
        def scenePos(self) -> QtCore.QPointF: ...
        def lastPos(self) -> QtCore.QPointF: ...
        def startPos(self) -> QtCore.QPointF: ...
        def pos(self) -> QtCore.QPointF: ...
        def state(self) -> int: ...
        def id(self) -> int: ...

    @overload
    def __init__(self, eventType: int, device: typing.Optional[QTouchDevice] = ..., modifiers: typing.Union[int, int] = ..., touchPointStates: typing.Union[int, int] = ..., touchPoints: typing.Iterable[QTouchEvent.TouchPoint] = ...) -> None: ...
    @overload
    def __init__(self, a0: QTouchEvent) -> None: ...

    def setDevice(self, adevice: QTouchDevice) -> None: ...
    def device(self) -> QTouchDevice: ...
    def window(self) -> QWindow: ...
    def touchPoints(self) -> typing.List[QTouchEvent.TouchPoint]: ...
    def touchPointStates(self) -> int: ...
    def target(self) -> QtCore.QObject: ...


class QExposeEvent(QtCore.QEvent):

    @overload
    def __init__(self, rgn: QRegion) -> None: ...
    @overload
    def __init__(self, a0: QExposeEvent) -> None: ...

    def region(self) -> QRegion: ...


class QScrollPrepareEvent(QtCore.QEvent):

    @overload
    def __init__(self, startPos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, a0: QScrollPrepareEvent) -> None: ...

    def setContentPos(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setContentPosRange(self, rect: QtCore.QRectF) -> None: ...
    def setViewportSize(self, size: QtCore.QSizeF) -> None: ...
    def contentPos(self) -> QtCore.QPointF: ...
    def contentPosRange(self) -> QtCore.QRectF: ...
    def viewportSize(self) -> QtCore.QSizeF: ...
    def startPos(self) -> QtCore.QPointF: ...


class QScrollEvent(QtCore.QEvent):

    ScrollState: typing.Type[int]
    #class ScrollState(int): ...
    ScrollStarted = ... # type: int
    ScrollUpdated = ... # type: int
    ScrollFinished = ... # type: int

    @overload
    def __init__(self, contentPos: typing.Union[QtCore.QPointF, QtCore.QPoint], overshoot: typing.Union[QtCore.QPointF, QtCore.QPoint], scrollState: int) -> None: ...
    @overload
    def __init__(self, a0: QScrollEvent) -> None: ...

    def scrollState(self) -> int: ...
    def overshootDistance(self) -> QtCore.QPointF: ...
    def contentPos(self) -> QtCore.QPointF: ...


class QEnterEvent(QtCore.QEvent):

    @overload
    def __init__(self, localPos: typing.Union[QtCore.QPointF, QtCore.QPoint], windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint], screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, a0: QEnterEvent) -> None: ...

    def screenPos(self) -> QtCore.QPointF: ...
    def windowPos(self) -> QtCore.QPointF: ...
    def localPos(self) -> QtCore.QPointF: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QNativeGestureEvent(QInputEvent):

    @overload
    def __init__(self, type: int, localPos: typing.Union[QtCore.QPointF, QtCore.QPoint], windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint], screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint], value: float, sequenceId: int, intArgument: int) -> None: ...
    @overload
    def __init__(self, type: int, dev: QTouchDevice, localPos: typing.Union[QtCore.QPointF, QtCore.QPoint], windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint], screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint], value: float, sequenceId: int, intArgument: int) -> None: ...
    @overload
    def __init__(self, a0: QNativeGestureEvent) -> None: ...

    def device(self) -> QTouchDevice: ...
    def screenPos(self) -> QtCore.QPointF: ...
    def windowPos(self) -> QtCore.QPointF: ...
    def localPos(self) -> QtCore.QPointF: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def value(self) -> float: ...
    def gestureType(self) -> int: ...


class QPlatformSurfaceEvent(QtCore.QEvent):

    SurfaceEventType: typing.Type[int]
    #class SurfaceEventType(int): ...
    SurfaceCreated = ... # type: int
    SurfaceAboutToBeDestroyed = ... # type: int

    @overload
    def __init__(self, surfaceEventType: int) -> None: ...
    @overload
    def __init__(self, a0: QPlatformSurfaceEvent) -> None: ...

    def surfaceEventType(self) -> int: ...


class QPointingDeviceUniqueId(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QPointingDeviceUniqueId) -> None: ...

    def __hash__(self) -> int: ...
    def numericId(self) -> int: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def fromNumericId(id: int) -> QPointingDeviceUniqueId: ...


class QFont(sip.simplewrapper):

    HintingPreference: typing.Type[int]
    #class HintingPreference(int): ...
    PreferDefaultHinting = ... # type: int
    PreferNoHinting = ... # type: int
    PreferVerticalHinting = ... # type: int
    PreferFullHinting = ... # type: int

    SpacingType: typing.Type[int]
    #class SpacingType(int): ...
    PercentageSpacing = ... # type: int
    AbsoluteSpacing = ... # type: int

    Capitalization: typing.Type[int]
    #class Capitalization(int): ...
    MixedCase = ... # type: int
    AllUppercase = ... # type: int
    AllLowercase = ... # type: int
    SmallCaps = ... # type: int
    Capitalize = ... # type: int

    Stretch: typing.Type[int]
    #class Stretch(int): ...
    AnyStretch = ... # type: int
    UltraCondensed = ... # type: int
    ExtraCondensed = ... # type: int
    Condensed = ... # type: int
    SemiCondensed = ... # type: int
    Unstretched = ... # type: int
    SemiExpanded = ... # type: int
    Expanded = ... # type: int
    ExtraExpanded = ... # type: int
    UltraExpanded = ... # type: int

    Style: typing.Type[int]
    #class Style(int): ...
    StyleNormal = ... # type: int
    StyleItalic = ... # type: int
    StyleOblique = ... # type: int

    Weight: typing.Type[int]
    #class Weight(int): ...
    Thin = ... # type: int
    ExtraLight = ... # type: int
    Light = ... # type: int
    Normal = ... # type: int
    Medium = ... # type: int
    DemiBold = ... # type: int
    Bold = ... # type: int
    ExtraBold = ... # type: int
    Black = ... # type: int

    StyleStrategy: typing.Type[int]
    #class StyleStrategy(int): ...
    PreferDefault = ... # type: int
    PreferBitmap = ... # type: int
    PreferDevice = ... # type: int
    PreferOutline = ... # type: int
    ForceOutline = ... # type: int
    PreferMatch = ... # type: int
    PreferQuality = ... # type: int
    PreferAntialias = ... # type: int
    NoAntialias = ... # type: int
    NoSubpixelAntialias = ... # type: int
    OpenGLCompatible = ... # type: int
    NoFontMerging = ... # type: int
    ForceIntegerMetrics = ... # type: int
    PreferNoShaping = ... # type: int

    StyleHint: typing.Type[int]
    #class StyleHint(int): ...
    Helvetica = ... # type: int
    SansSerif = ... # type: int
    Times = ... # type: int
    Serif = ... # type: int
    Courier = ... # type: int
    TypeWriter = ... # type: int
    OldEnglish = ... # type: int
    Decorative = ... # type: int
    System = ... # type: int
    AnyStyle = ... # type: int
    Cursive = ... # type: int
    Monospace = ... # type: int
    Fantasy = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, a0: QFont) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def __hash__(self) -> int: ...
    def swap(self, other: QFont) -> None: ...
    def hintingPreference(self) -> int: ...
    def setHintingPreference(self, hintingPreference: int) -> None: ...
    def setStyleName(self, styleName: str) -> None: ...
    def styleName(self) -> str: ...
    def capitalization(self) -> int: ...
    def setCapitalization(self, a0: int) -> None: ...
    def setWordSpacing(self, spacing: float) -> None: ...
    def wordSpacing(self) -> float: ...
    def setLetterSpacing(self, type: int, spacing: float) -> None: ...
    def letterSpacingType(self) -> int: ...
    def letterSpacing(self) -> float: ...
    def setItalic(self, b: bool) -> None: ...
    def italic(self) -> bool: ...
    def setBold(self, enable: bool) -> None: ...
    def bold(self) -> bool: ...
    def resolve(self, a0: QFont) -> QFont: ...
    def lastResortFont(self) -> str: ...
    def lastResortFamily(self) -> str: ...
    def defaultFamily(self) -> str: ...
    @staticmethod
    def cacheStatistics() -> None: ...
    @staticmethod
    def cleanup() -> None: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def removeSubstitutions(a0: str) -> None: ...
    @staticmethod
    def insertSubstitutions(a0: str, a1: typing.Iterable[str]) -> None: ...
    @staticmethod
    def insertSubstitution(a0: str, a1: str) -> None: ...
    @staticmethod
    def substitutions() -> typing.List[str]: ...
    @staticmethod
    def substitutes(a0: str) -> typing.List[str]: ...
    @staticmethod
    def substitute(a0: str) -> str: ...
    def fromString(self, a0: str) -> bool: ...
    def toString(self) -> str: ...
    def key(self) -> str: ...
    def rawName(self) -> str: ...
    def setRawName(self, a0: str) -> None: ...
    def isCopyOf(self, a0: QFont) -> bool: ...
    def exactMatch(self) -> bool: ...
    def setRawMode(self, a0: bool) -> None: ...
    def rawMode(self) -> bool: ...
    def setStretch(self, a0: int) -> None: ...
    def stretch(self) -> int: ...
    def setStyleStrategy(self, s: int) -> None: ...
    def setStyleHint(self, hint: int, strategy: int = ...) -> None: ...
    def styleStrategy(self) -> int: ...
    def styleHint(self) -> int: ...
    def setKerning(self, a0: bool) -> None: ...
    def kerning(self) -> bool: ...
    def setFixedPitch(self, a0: bool) -> None: ...
    def fixedPitch(self) -> bool: ...
    def setStrikeOut(self, a0: bool) -> None: ...
    def strikeOut(self) -> bool: ...
    def setOverline(self, a0: bool) -> None: ...
    def overline(self) -> bool: ...
    def setUnderline(self, a0: bool) -> None: ...
    def underline(self) -> bool: ...
    def style(self) -> int: ...
    def setStyle(self, style: int) -> None: ...
    def setWeight(self, a0: int) -> None: ...
    def weight(self) -> int: ...
    def setPixelSize(self, a0: int) -> None: ...
    def pixelSize(self) -> int: ...
    def setPointSizeF(self, a0: float) -> None: ...
    def pointSizeF(self) -> float: ...
    def setPointSize(self, a0: int) -> None: ...
    def pointSize(self) -> int: ...
    def setFamily(self, a0: str) -> None: ...
    def family(self) -> str: ...


class QFontDatabase(sip.simplewrapper):

    SystemFont: typing.Type[int]
    #class SystemFont(int): ...
    GeneralFont = ... # type: int
    FixedFont = ... # type: int
    TitleFont = ... # type: int
    SmallestReadableFont = ... # type: int

    WritingSystem: typing.Type[int]
    #class WritingSystem(int): ...
    Any = ... # type: int
    Latin = ... # type: int
    Greek = ... # type: int
    Cyrillic = ... # type: int
    Armenian = ... # type: int
    Hebrew = ... # type: int
    Arabic = ... # type: int
    Syriac = ... # type: int
    Thaana = ... # type: int
    Devanagari = ... # type: int
    Bengali = ... # type: int
    Gurmukhi = ... # type: int
    Gujarati = ... # type: int
    Oriya = ... # type: int
    Tamil = ... # type: int
    Telugu = ... # type: int
    Kannada = ... # type: int
    Malayalam = ... # type: int
    Sinhala = ... # type: int
    Thai = ... # type: int
    Lao = ... # type: int
    Tibetan = ... # type: int
    Myanmar = ... # type: int
    Georgian = ... # type: int
    Khmer = ... # type: int
    SimplifiedChinese = ... # type: int
    TraditionalChinese = ... # type: int
    Japanese = ... # type: int
    Korean = ... # type: int
    Vietnamese = ... # type: int
    Other = ... # type: int
    Symbol = ... # type: int
    Ogham = ... # type: int
    Runic = ... # type: int
    Nko = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QFontDatabase) -> None: ...

    def isPrivateFamily(self, family: str) -> bool: ...
    @staticmethod
    def systemFont(type: int) -> QFont: ...
    @staticmethod
    def supportsThreadedFontRendering() -> bool: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id: int) -> bool: ...
    @staticmethod
    def applicationFontFamilies(id: int) -> typing.List[str]: ...
    @staticmethod
    def addApplicationFontFromData(fontData: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @staticmethod
    def addApplicationFont(fileName: str) -> int: ...
    @staticmethod
    def writingSystemSample(writingSystem: int) -> str: ...
    @staticmethod
    def writingSystemName(writingSystem: int) -> str: ...
    def weight(self, family: str, style: str) -> int: ...
    def bold(self, family: str, style: str) -> bool: ...
    def italic(self, family: str, style: str) -> bool: ...
    def isFixedPitch(self, family: str, style: str = ...) -> bool: ...
    def isScalable(self, family: str, style: str = ...) -> bool: ...
    def isSmoothlyScalable(self, family: str, style: str = ...) -> bool: ...
    def isBitmapScalable(self, family: str, style: str = ...) -> bool: ...
    def font(self, family: str, style: str, pointSize: int) -> QFont: ...
    @overload
    def styleString(self, font: QFont) -> str: ...
    @overload
    def styleString(self, fontInfo: QFontInfo) -> str: ...
    def smoothSizes(self, family: str, style: str) -> typing.List[int]: ...
    def pointSizes(self, family: str, style: str = ...) -> typing.List[int]: ...
    def styles(self, family: str) -> typing.List[str]: ...
    def families(self, writingSystem: int = ...) -> typing.List[str]: ...
    @overload
    def writingSystems(self) -> typing.List[int]: ...
    @overload
    def writingSystems(self, family: str) -> typing.List[int]: ...
    @staticmethod
    def standardSizes() -> typing.List[int]: ...


class QFontInfo(sip.simplewrapper):

    @overload
    def __init__(self, a0: QFont) -> None: ...
    @overload
    def __init__(self, a0: QFontInfo) -> None: ...

    def swap(self, other: QFontInfo) -> None: ...
    def styleName(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def rawMode(self) -> bool: ...
    def styleHint(self) -> int: ...
    def fixedPitch(self) -> bool: ...
    def bold(self) -> bool: ...
    def weight(self) -> int: ...
    def style(self) -> int: ...
    def italic(self) -> bool: ...
    def pointSizeF(self) -> float: ...
    def pointSize(self) -> int: ...
    def pixelSize(self) -> int: ...
    def family(self) -> str: ...


class QFontMetrics(sip.simplewrapper):

    @overload
    def __init__(self, a0: QFont) -> None: ...
    @overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, a0: QFontMetrics) -> None: ...

    def horizontalAdvance(self, a0: str, length: int = ...) -> int: ...
    def capHeight(self) -> int: ...
    def swap(self, other: QFontMetrics) -> None: ...
    def inFontUcs4(self, character: int) -> bool: ...
    def tightBoundingRect(self, text: str) -> QtCore.QRect: ...
    def elidedText(self, text: str, mode: int, width: int, flags: int = ...) -> str: ...
    def averageCharWidth(self) -> int: ...
    def lineWidth(self) -> int: ...
    def strikeOutPos(self) -> int: ...
    def overlinePos(self) -> int: ...
    def underlinePos(self) -> int: ...
    def size(self, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QSize: ...
    @overload
    def boundingRect(self, text: str) -> QtCore.QRect: ...
    @overload
    def boundingRect(self, rect: QtCore.QRect, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRect: ...
    @overload
    def boundingRect(self, x: int, y: int, width: int, height: int, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRect: ...
    def boundingRectChar(self, a0: str) -> QtCore.QRect: ...
    def width(self, text: str, length: int = ...) -> int: ...
    def widthChar(self, a0: str) -> int: ...
    def rightBearing(self, a0: str) -> int: ...
    def leftBearing(self, a0: str) -> int: ...
    def inFont(self, a0: str) -> bool: ...
    def xHeight(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def lineSpacing(self) -> int: ...
    def leading(self) -> int: ...
    def height(self) -> int: ...
    def descent(self) -> int: ...
    def ascent(self) -> int: ...


class QFontMetricsF(sip.simplewrapper):

    @overload
    def __init__(self, a0: QFont) -> None: ...
    @overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None: ...
    @overload
    def __init__(self, a0: QFontMetrics) -> None: ...
    @overload
    def __init__(self, a0: QFontMetricsF) -> None: ...

    def horizontalAdvance(self, string: str, length: int = ...) -> float: ...
    def capHeight(self) -> float: ...
    def swap(self, other: QFontMetricsF) -> None: ...
    def inFontUcs4(self, character: int) -> bool: ...
    def tightBoundingRect(self, text: str) -> QtCore.QRectF: ...
    def elidedText(self, text: str, mode: int, width: float, flags: int = ...) -> str: ...
    def averageCharWidth(self) -> float: ...
    def lineWidth(self) -> float: ...
    def strikeOutPos(self) -> float: ...
    def overlinePos(self) -> float: ...
    def underlinePos(self) -> float: ...
    def size(self, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QSizeF: ...
    @overload
    def boundingRect(self, string: str) -> QtCore.QRectF: ...
    @overload
    def boundingRect(self, rect: QtCore.QRectF, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRectF: ...
    def boundingRectChar(self, a0: str) -> QtCore.QRectF: ...
    def width(self, string: str) -> float: ...
    def widthChar(self, a0: str) -> float: ...
    def rightBearing(self, a0: str) -> float: ...
    def leftBearing(self, a0: str) -> float: ...
    def inFont(self, a0: str) -> bool: ...
    def xHeight(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def lineSpacing(self) -> float: ...
    def leading(self) -> float: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...


class QMatrix4x3(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix4x3) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix3x4: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix4x2(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix4x2) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix2x4: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x4(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix3x4) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix4x3: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x3(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix3x3) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix3x3: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x2(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix3x2) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix2x3: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x4(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix2x4) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix4x2: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x3(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix2x3) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix3x2: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x2(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QMatrix2x2) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix2x2: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QGlyphRun(sip.simplewrapper):

    GlyphRunFlag: typing.Type[int]
    #class GlyphRunFlag(int): ...
    Overline = ... # type: int
    Underline = ... # type: int
    StrikeOut = ... # type: int
    RightToLeft = ... # type: int
    SplitLigature = ... # type: int

    GlyphRunFlags: typing.Type[int]
    #class GlyphRunFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QGlyphRun.GlyphRunFlags, QGlyphRun.GlyphRunFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QGlyphRun.GlyphRunFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QGlyphRun.GlyphRunFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QGlyphRun) -> None: ...

    def swap(self, other: QGlyphRun) -> None: ...
    def isEmpty(self) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setBoundingRect(self, boundingRect: QtCore.QRectF) -> None: ...
    def flags(self) -> int: ...
    def setFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setFlag(self, flag: int, enabled: bool = ...) -> None: ...
    def isRightToLeft(self) -> bool: ...
    def setRightToLeft(self, on: bool) -> None: ...
    def strikeOut(self) -> bool: ...
    def setStrikeOut(self, strikeOut: bool) -> None: ...
    def underline(self) -> bool: ...
    def setUnderline(self, underline: bool) -> None: ...
    def overline(self) -> bool: ...
    def setOverline(self, overline: bool) -> None: ...
    def clear(self) -> None: ...
    def setPositions(self, positions: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    def positions(self) -> typing.List[QtCore.QPointF]: ...
    def setGlyphIndexes(self, glyphIndexes: typing.Iterable[int]) -> None: ...
    def glyphIndexes(self) -> typing.List[int]: ...
    def setRawFont(self, rawFont: QRawFont) -> None: ...
    def rawFont(self) -> QRawFont: ...


class QGuiApplication(QtCore.QCoreApplication):

    applicationDisplayNameChanged: PYQT_SIGNAL
    applicationStateChanged: PYQT_SIGNAL
    commitDataRequest: PYQT_SIGNAL
    focusObjectChanged: PYQT_SIGNAL
    focusWindowChanged: PYQT_SIGNAL
    fontChanged: PYQT_SIGNAL
    fontDatabaseChanged: PYQT_SIGNAL
    lastWindowClosed: PYQT_SIGNAL
    layoutDirectionChanged: PYQT_SIGNAL
    paletteChanged: PYQT_SIGNAL
    primaryScreenChanged: PYQT_SIGNAL
    saveStateRequest: PYQT_SIGNAL
    screenAdded: PYQT_SIGNAL
    screenRemoved: PYQT_SIGNAL

    def __init__(self, argv: typing.List[str], **props) -> None: ...

    #def fontChanged(self, font: QFont) -> None: ...
    @staticmethod
    def screenAt(point: QtCore.QPoint) -> QScreen: ...
    @staticmethod
    def desktopFileName() -> str: ...
    @staticmethod
    def setDesktopFileName(name: str) -> None: ...
    #def primaryScreenChanged(self, screen: QScreen) -> None: ...
    @staticmethod
    def setFallbackSessionManagementEnabled(a0: bool) -> None: ...
    @staticmethod
    def isFallbackSessionManagementEnabled() -> bool: ...
    #def paletteChanged(self, pal: QPalette) -> None: ...
    #def layoutDirectionChanged(self, direction: int) -> None: ...
    #def screenRemoved(self, screen: QScreen) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    @staticmethod
    def windowIcon() -> QIcon: ...
    @staticmethod
    def setWindowIcon(icon: QIcon) -> None: ...
    @staticmethod
    def sync() -> None: ...
    @staticmethod
    def applicationState() -> int: ...
    def isSavingSession(self) -> bool: ...
    def sessionKey(self) -> str: ...
    def sessionId(self) -> str: ...
    def isSessionRestored(self) -> bool: ...
    def devicePixelRatio(self) -> float: ...
    @staticmethod
    def inputMethod() -> QInputMethod: ...
    @staticmethod
    def styleHints() -> QStyleHints: ...
    @staticmethod
    def modalWindow() -> QWindow: ...
    @staticmethod
    def applicationDisplayName() -> str: ...
    @staticmethod
    def setApplicationDisplayName(name: str) -> None: ...
    #def applicationDisplayNameChanged(self) -> None: ...
    #def applicationStateChanged(self, state: int) -> None: ...
    #def focusWindowChanged(self, focusWindow: QWindow) -> None: ...
    #def saveStateRequest(self, sessionManager: QSessionManager) -> None: ...
    #def commitDataRequest(self, sessionManager: QSessionManager) -> None: ...
    #def focusObjectChanged(self, focusObject: QtCore.QObject) -> None: ...
    #def lastWindowClosed(self) -> None: ...
    #def screenAdded(self, screen: QScreen) -> None: ...
    #def fontDatabaseChanged(self) -> None: ...
    def notify(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool) -> None: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    @staticmethod
    def setDesktopSettingsAware(on: bool) -> None: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    @staticmethod
    def layoutDirection() -> int: ...
    @staticmethod
    def setLayoutDirection(direction: int) -> None: ...
    @staticmethod
    def mouseButtons() -> int: ...
    @staticmethod
    def queryKeyboardModifiers() -> int: ...
    @staticmethod
    def keyboardModifiers() -> int: ...
    @staticmethod
    def setPalette(pal: QPalette) -> None: ...
    @staticmethod
    def palette() -> QPalette: ...
    @staticmethod
    def clipboard() -> QClipboard: ...
    @staticmethod
    def setFont(a0: QFont) -> None: ...
    @staticmethod
    def font() -> QFont: ...
    @staticmethod
    def restoreOverrideCursor() -> None: ...
    @staticmethod
    def changeOverrideCursor(a0: typing.Union[QCursor, int]) -> None: ...
    @staticmethod
    def setOverrideCursor(a0: typing.Union[QCursor, int]) -> None: ...
    @staticmethod
    def overrideCursor() -> QCursor: ...
    @staticmethod
    def screens() -> typing.List[QScreen]: ...
    @staticmethod
    def primaryScreen() -> QScreen: ...
    @staticmethod
    def focusObject() -> QtCore.QObject: ...
    @staticmethod
    def focusWindow() -> QWindow: ...
    @staticmethod
    def platformName() -> str: ...
    @staticmethod
    def topLevelAt(pos: QtCore.QPoint) -> QWindow: ...
    @staticmethod
    def topLevelWindows() -> typing.List[QWindow]: ...
    @staticmethod
    def allWindows() -> typing.List[QWindow]: ...


class QIcon(sip.wrapper):

    State: typing.Type[int]
    #class State(int): ...
    On = ... # type: int
    Off = ... # type: int

    Mode: typing.Type[int]
    #class Mode(int): ...
    Normal = ... # type: int
    Disabled = ... # type: int
    Active = ... # type: int
    Selected = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @overload
    def __init__(self, other: QIcon) -> None: ...
    @overload
    def __init__(self, fileName: str) -> None: ...
    @overload
    def __init__(self, engine: QIconEngine) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    @staticmethod
    def setFallbackThemeName(name: str) -> None: ...
    @staticmethod
    def fallbackThemeName() -> str: ...
    @staticmethod
    def setFallbackSearchPaths(paths: typing.Iterable[str]) -> None: ...
    @staticmethod
    def fallbackSearchPaths() -> typing.List[str]: ...
    def isMask(self) -> bool: ...
    def setIsMask(self, isMask: bool) -> None: ...
    def swap(self, other: QIcon) -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def setThemeName(path: str) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def setThemeSearchPaths(searchpath: typing.Iterable[str]) -> None: ...
    @staticmethod
    def themeSearchPaths() -> typing.List[str]: ...
    @staticmethod
    def hasThemeIcon(name: str) -> bool: ...
    @overload
    @staticmethod
    def fromTheme(name: str) -> QIcon: ...
    @overload
    @staticmethod
    def fromTheme(name: str, fallback: QIcon) -> QIcon: ...
    def cacheKey(self) -> int: ...
    def addFile(self, fileName: str, size: QtCore.QSize = ..., mode: int = ..., state: int = ...) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: int = ..., state: int = ...) -> None: ...
    def isDetached(self) -> bool: ...
    def isNull(self) -> bool: ...
    @overload
    def paint(self, painter: QPainter, rect: QtCore.QRect, alignment: typing.Union[int, int] = ..., mode: int = ..., state: int = ...) -> None: ...
    @overload
    def paint(self, painter: QPainter, x: int, y: int, w: int, h: int, alignment: typing.Union[int, int] = ..., mode: int = ..., state: int = ...) -> None: ...
    def availableSizes(self, mode: int = ..., state: int = ...) -> typing.List[QtCore.QSize]: ...
    @overload
    def actualSize(self, size: QtCore.QSize, mode: int = ..., state: int = ...) -> QtCore.QSize: ...
    @overload
    def actualSize(self, window: QWindow, size: QtCore.QSize, mode: int = ..., state: int = ...) -> QtCore.QSize: ...
    @overload
    def pixmap(self, size: QtCore.QSize, mode: int = ..., state: int = ...) -> QPixmap: ...
    @overload
    def pixmap(self, w: int, h: int, mode: int = ..., state: int = ...) -> QPixmap: ...
    @overload
    def pixmap(self, extent: int, mode: int = ..., state: int = ...) -> QPixmap: ...
    @overload
    def pixmap(self, window: QWindow, size: QtCore.QSize, mode: int = ..., state: int = ...) -> QPixmap: ...


class QIconEngine(sip.wrapper):

    IconEngineHook: typing.Type[int]
    #class IconEngineHook(int): ...
    AvailableSizesHook = ... # type: int
    IconNameHook = ... # type: int
    IsNullHook = ... # type: int
    ScaledPixmapHook = ... # type: int

    class AvailableSizesArgument:

        mode = ... # type: int
        sizes = ... # type: typing.Iterable[QtCore.QSize]
        state = ... # type: int

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QIconEngine.AvailableSizesArgument) -> None: ...

    class ScaledPixmapArgument:

        mode = ... # type: int
        pixmap = ... # type: QPixmap
        scale = ... # type: float
        size = ... # type: QtCore.QSize
        state = ... # type: int

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QIconEngine.ScaledPixmapArgument) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QIconEngine) -> None: ...

    def scaledPixmap(self, size: QtCore.QSize, mode: int, state: int, scale: float) -> QPixmap: ...
    def isNull(self) -> bool: ...
    def iconName(self) -> str: ...
    def availableSizes(self, mode: int = ..., state: int = ...) -> typing.List[QtCore.QSize]: ...
    def write(self, out: QtCore.QDataStream) -> bool: ...
    def read(self, in_: QtCore.QDataStream) -> bool: ...
    def clone(self) -> QIconEngine: ...
    def key(self) -> str: ...
    def addFile(self, fileName: str, size: QtCore.QSize, mode: int, state: int) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: int, state: int) -> None: ...
    def pixmap(self, size: QtCore.QSize, mode: int, state: int) -> QPixmap: ...
    def actualSize(self, size: QtCore.QSize, mode: int, state: int) -> QtCore.QSize: ...
    def paint(self, painter: QPainter, rect: QtCore.QRect, mode: int, state: int) -> None: ...


class QImage(QPaintDevice):

    Format: typing.Type[int]
    #class Format(int): ...
    Format_Invalid = ... # type: int
    Format_Mono = ... # type: int
    Format_MonoLSB = ... # type: int
    Format_Indexed8 = ... # type: int
    Format_RGB32 = ... # type: int
    Format_ARGB32 = ... # type: int
    Format_ARGB32_Premultiplied = ... # type: int
    Format_RGB16 = ... # type: int
    Format_ARGB8565_Premultiplied = ... # type: int
    Format_RGB666 = ... # type: int
    Format_ARGB6666_Premultiplied = ... # type: int
    Format_RGB555 = ... # type: int
    Format_ARGB8555_Premultiplied = ... # type: int
    Format_RGB888 = ... # type: int
    Format_RGB444 = ... # type: int
    Format_ARGB4444_Premultiplied = ... # type: int
    Format_RGBX8888 = ... # type: int
    Format_RGBA8888 = ... # type: int
    Format_RGBA8888_Premultiplied = ... # type: int
    Format_BGR30 = ... # type: int
    Format_A2BGR30_Premultiplied = ... # type: int
    Format_RGB30 = ... # type: int
    Format_A2RGB30_Premultiplied = ... # type: int
    Format_Alpha8 = ... # type: int
    Format_Grayscale8 = ... # type: int
    Format_RGBX64 = ... # type: int
    Format_RGBA64 = ... # type: int
    Format_RGBA64_Premultiplied = ... # type: int

    InvertMode: typing.Type[int]
    #class InvertMode(int): ...
    InvertRgb = ... # type: int
    InvertRgba = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSize, format: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: int) -> None: ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, format: int) -> None: ...
    @overload
    def __init__(self, data: sip.voidptr, width: int, height: int, format: int) -> None: ...
    @overload
    def __init__(self, data: bytes, width: int, height: int, bytesPerLine: int, format: int) -> None: ...
    @overload
    def __init__(self, data: sip.voidptr, width: int, height: int, bytesPerLine: int, format: int) -> None: ...
    @overload
    def __init__(self, xpm: typing.List[str]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @overload
    def __init__(self, a0: QImage) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def sizeInBytes(self) -> int: ...
    def reinterpretAsFormat(self, f: int) -> bool: ...
    @overload
    def setPixelColor(self, x: int, y: int, c: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setPixelColor(self, pt: QtCore.QPoint, c: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def pixelColor(self, x: int, y: int) -> QColor: ...
    @overload
    def pixelColor(self, pt: QtCore.QPoint) -> QColor: ...
    @staticmethod
    def toImageFormat(format: QPixelFormat) -> int: ...
    @staticmethod
    def toPixelFormat(format: int) -> QPixelFormat: ...
    def pixelFormat(self) -> QPixelFormat: ...
    def setDevicePixelRatio(self, scaleFactor: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def swap(self, other: QImage) -> None: ...
    def bitPlaneCount(self) -> int: ...
    def byteCount(self) -> int: ...
    def setColorCount(self, a0: int) -> None: ...
    def colorCount(self) -> int: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def trueMatrix(a0: QTransform, w: int, h: int) -> QTransform: ...
    def transformed(self, matrix: QTransform, mode: int = ...) -> QImage: ...
    def createMaskFromColor(self, color: int, mode: int = ...) -> QImage: ...
    def smoothScaled(self, w: int, h: int) -> QImage: ...
    def metric(self, metric: int) -> int: ...
    def setText(self, key: str, value: str) -> None: ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    def setOffset(self, a0: QtCore.QPoint) -> None: ...
    def offset(self) -> QtCore.QPoint: ...
    def setDotsPerMeterY(self, a0: int) -> None: ...
    def setDotsPerMeterX(self, a0: int) -> None: ...
    def dotsPerMeterY(self) -> int: ...
    def dotsPerMeterX(self) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    @overload
    @staticmethod
    def fromData(data: bytes, format: typing.Optional[str] = ...) -> QImage: ...
    @overload
    @staticmethod
    def fromData(data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ...) -> QImage: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def save(self, device: QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @overload
    def loadFromData(self, data: bytes, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def loadFromData(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def load(self, device: QtCore.QIODevice, format: str) -> bool: ...
    @overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def invertPixels(self, mode: int = ...) -> None: ...
    def rgbSwapped(self) -> QImage: ...
    def mirrored(self, horizontal: bool = ..., vertical: bool = ...) -> QImage: ...
    def scaledToHeight(self, height: int, mode: int = ...) -> QImage: ...
    def scaledToWidth(self, width: int, mode: int = ...) -> QImage: ...
    @overload
    def scaled(self, width: int, height: int, aspectRatioMode: int = ..., transformMode: int = ...) -> QImage: ...
    @overload
    def scaled(self, size: QtCore.QSize, aspectRatioMode: int = ..., transformMode: int = ...) -> QImage: ...
    def createHeuristicMask(self, clipTight: bool = ...) -> QImage: ...
    def createAlphaMask(self, flags: typing.Union[int, int] = ...) -> QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    @overload
    def fill(self, color: int) -> None: ...
    @overload
    def fill(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def fill(self, pixel: int) -> None: ...
    def setColorTable(self, colors: typing.Iterable[int]) -> None: ...
    def colorTable(self) -> typing.List[int]: ...
    @overload
    def setPixel(self, pt: QtCore.QPoint, index_or_rgb: int) -> None: ...
    @overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None: ...
    @overload
    def pixel(self, pt: QtCore.QPoint) -> int: ...
    @overload
    def pixel(self, x: int, y: int) -> int: ...
    @overload
    def pixelIndex(self, pt: QtCore.QPoint) -> int: ...
    @overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    @overload
    def valid(self, pt: QtCore.QPoint) -> bool: ...
    @overload
    def valid(self, x: int, y: int) -> bool: ...
    def bytesPerLine(self) -> int: ...
    def constScanLine(self, a0: int) -> sip.voidptr: ...
    def scanLine(self, a0: int) -> sip.voidptr: ...
    def constBits(self) -> sip.voidptr: ...
    def bits(self) -> sip.voidptr: ...
    def isGrayscale(self) -> bool: ...
    def allGray(self) -> bool: ...
    def setColor(self, i: int, c: int) -> None: ...
    def color(self, i: int) -> int: ...
    def depth(self) -> int: ...
    def rect(self) -> QtCore.QRect: ...
    def size(self) -> QtCore.QSize: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    @overload
    def convertToFormat(self, format: int, flags: typing.Union[int, int] = ...) -> QImage: ...
    @overload
    def convertToFormat(self, format: int, colorTable: typing.Iterable[int], flags: typing.Union[int, int] = ...) -> QImage: ...
    def format(self) -> int: ...
    @overload
    def copy(self, rect: QtCore.QRect = ...) -> QImage: ...
    @overload
    def copy(self, x: int, y: int, w: int, h: int) -> QImage: ...
    def isDetached(self) -> bool: ...
    def detach(self) -> None: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QImageIOHandler(sip.simplewrapper):

    Transformation: typing.Type[int]
    #class Transformation(int): ...
    TransformationNone = ... # type: int
    TransformationMirror = ... # type: int
    TransformationFlip = ... # type: int
    TransformationRotate180 = ... # type: int
    TransformationRotate90 = ... # type: int
    TransformationMirrorAndRotate90 = ... # type: int
    TransformationFlipAndRotate90 = ... # type: int
    TransformationRotate270 = ... # type: int

    ImageOption: typing.Type[int]
    #class ImageOption(int): ...
    Size = ... # type: int
    ClipRect = ... # type: int
    Description = ... # type: int
    ScaledClipRect = ... # type: int
    ScaledSize = ... # type: int
    CompressionRatio = ... # type: int
    Gamma = ... # type: int
    Quality = ... # type: int
    Name = ... # type: int
    SubType = ... # type: int
    IncrementalReading = ... # type: int
    Endianness = ... # type: int
    Animation = ... # type: int
    BackgroundColor = ... # type: int
    SupportedSubTypes = ... # type: int
    OptimizedWrite = ... # type: int
    ProgressiveScanWrite = ... # type: int
    ImageTransformation = ... # type: int
    TransformedByDefault = ... # type: int

    Transformations: typing.Type[int]
    #class Transformations(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QImageIOHandler.Transformations, QImageIOHandler.Transformation]) -> None: ...
        #@overload
        #def __init__(self, a0: QImageIOHandler.Transformations) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QImageIOHandler.Transformations: ...
        #def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def currentImageRect(self) -> QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def imageCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def supportsOption(self, option: int) -> bool: ...
    def setOption(self, option: int, value: typing.Any) -> None: ...
    def option(self, option: int) -> typing.Any: ...
    def write(self, image: QImage) -> bool: ...
    def read(self, image: QImage) -> bool: ...
    def canRead(self) -> bool: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...


class QImageReader(sip.simplewrapper):

    ImageReaderError: typing.Type[int]
    #class ImageReaderError(int): ...
    UnknownError = ... # type: int
    FileNotFoundError = ... # type: int
    DeviceError = ... # type: int
    UnsupportedFormatError = ... # type: int
    InvalidDataError = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    @staticmethod
    def imageFormatsForMimeType(mimeType: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.List[QtCore.QByteArray]: ...
    def gamma(self) -> float: ...
    def setGamma(self, gamma: float) -> None: ...
    def autoTransform(self) -> bool: ...
    def setAutoTransform(self, enabled: bool) -> None: ...
    def transformation(self) -> int: ...
    def supportedSubTypes(self) -> typing.List[QtCore.QByteArray]: ...
    def subType(self) -> QtCore.QByteArray: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[QtCore.QByteArray]: ...
    def decideFormatFromContent(self) -> bool: ...
    def setDecideFormatFromContent(self, ignored: bool) -> None: ...
    def autoDetectImageFormat(self) -> bool: ...
    def setAutoDetectImageFormat(self, enabled: bool) -> None: ...
    def supportsOption(self, option: int) -> bool: ...
    def quality(self) -> int: ...
    def setQuality(self, quality: int) -> None: ...
    def supportsAnimation(self) -> bool: ...
    def backgroundColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[QtCore.QByteArray]: ...
    #@overload
    #@staticmethod
    #def imageFormat(fileName: str) -> QtCore.QByteArray: ...
    #@overload
    #@staticmethod
    #def imageFormat(device: QtCore.QIODevice) -> QtCore.QByteArray: ...
    @overload
    def imageFormat(self) -> int: ...
    def errorString(self) -> str: ...
    def error(self) -> int: ...
    def currentImageRect(self) -> QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def imageCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    @overload
    def read(self) -> QImage: ...
    @overload
    def read(self, image: QImage) -> bool: ...
    def canRead(self) -> bool: ...
    def scaledClipRect(self) -> QtCore.QRect: ...
    def setScaledClipRect(self, rect: QtCore.QRect) -> None: ...
    def scaledSize(self) -> QtCore.QSize: ...
    def setScaledSize(self, size: QtCore.QSize) -> None: ...
    def clipRect(self) -> QtCore.QRect: ...
    def setClipRect(self, rect: QtCore.QRect) -> None: ...
    def size(self) -> QtCore.QSize: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QImageWriter(sip.simplewrapper):

    ImageWriterError: typing.Type[int]
    #class ImageWriterError(int): ...
    UnknownError = ... # type: int
    DeviceError = ... # type: int
    UnsupportedFormatError = ... # type: int
    InvalidImageError = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    @staticmethod
    def imageFormatsForMimeType(mimeType: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.List[QtCore.QByteArray]: ...
    def setTransformation(self, orientation: typing.Union[int, int]) -> None: ...
    def transformation(self) -> int: ...
    def progressiveScanWrite(self) -> bool: ...
    def setProgressiveScanWrite(self, progressive: bool) -> None: ...
    def optimizedWrite(self) -> bool: ...
    def setOptimizedWrite(self, optimize: bool) -> None: ...
    def supportedSubTypes(self) -> typing.List[QtCore.QByteArray]: ...
    def subType(self) -> QtCore.QByteArray: ...
    def setSubType(self, type: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[QtCore.QByteArray]: ...
    def compression(self) -> int: ...
    def setCompression(self, compression: int) -> None: ...
    def supportsOption(self, option: int) -> bool: ...
    def setText(self, key: str, text: str) -> None: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[QtCore.QByteArray]: ...
    def errorString(self) -> str: ...
    def error(self) -> int: ...
    def write(self, image: QImage) -> bool: ...
    def canWrite(self) -> bool: ...
    def gamma(self) -> float: ...
    def setGamma(self, gamma: float) -> None: ...
    def quality(self) -> int: ...
    def setQuality(self, quality: int) -> None: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QInputMethod(QtCore.QObject):

    anchorRectangleChanged: PYQT_SIGNAL
    animatingChanged: PYQT_SIGNAL
    cursorRectangleChanged: PYQT_SIGNAL
    inputDirectionChanged: PYQT_SIGNAL
    inputItemClipRectangleChanged: PYQT_SIGNAL
    keyboardRectangleChanged: PYQT_SIGNAL
    localeChanged: PYQT_SIGNAL
    visibleChanged: PYQT_SIGNAL

    Action: typing.Type[int]
    #class Action(int): ...
    Click = ... # type: int
    ContextMenu = ... # type: int

    #def inputItemClipRectangleChanged(self) -> None: ...
    #def anchorRectangleChanged(self) -> None: ...
    def inputItemClipRectangle(self) -> QtCore.QRectF: ...
    def anchorRectangle(self) -> QtCore.QRectF: ...
    #def inputDirectionChanged(self, newDirection: int) -> None: ...
    #def localeChanged(self) -> None: ...
    #def animatingChanged(self) -> None: ...
    #def visibleChanged(self) -> None: ...
    #def keyboardRectangleChanged(self) -> None: ...
    #def cursorRectangleChanged(self) -> None: ...
    def invokeAction(self, a: int, cursorPosition: int) -> None: ...
    def commit(self) -> None: ...
    def reset(self) -> None: ...
    def update(self, queries: typing.Union[int, int]) -> None: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    @staticmethod
    def queryFocusObject(query: int, argument: typing.Any) -> typing.Any: ...
    def setInputItemRectangle(self, rect: QtCore.QRectF) -> None: ...
    def inputItemRectangle(self) -> QtCore.QRectF: ...
    def inputDirection(self) -> int: ...
    def locale(self) -> QtCore.QLocale: ...
    def isAnimating(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> QtCore.QRectF: ...
    def cursorRectangle(self) -> QtCore.QRectF: ...
    def setInputItemTransform(self, transform: QTransform) -> None: ...
    def inputItemTransform(self) -> QTransform: ...


class QKeySequence(sip.simplewrapper):

    StandardKey: typing.Type[int]
    #class StandardKey(int): ...
    UnknownKey = ... # type: int
    HelpContents = ... # type: int
    WhatsThis = ... # type: int
    Open = ... # type: int
    Close = ... # type: int
    Save = ... # type: int
    New = ... # type: int
    Delete = ... # type: int
    Cut = ... # type: int
    Copy = ... # type: int
    Paste = ... # type: int
    Undo = ... # type: int
    Redo = ... # type: int
    Back = ... # type: int
    Forward = ... # type: int
    Refresh = ... # type: int
    ZoomIn = ... # type: int
    ZoomOut = ... # type: int
    Print = ... # type: int
    AddTab = ... # type: int
    NextChild = ... # type: int
    PreviousChild = ... # type: int
    Find = ... # type: int
    FindNext = ... # type: int
    FindPrevious = ... # type: int
    Replace = ... # type: int
    SelectAll = ... # type: int
    Bold = ... # type: int
    Italic = ... # type: int
    Underline = ... # type: int
    MoveToNextChar = ... # type: int
    MoveToPreviousChar = ... # type: int
    MoveToNextWord = ... # type: int
    MoveToPreviousWord = ... # type: int
    MoveToNextLine = ... # type: int
    MoveToPreviousLine = ... # type: int
    MoveToNextPage = ... # type: int
    MoveToPreviousPage = ... # type: int
    MoveToStartOfLine = ... # type: int
    MoveToEndOfLine = ... # type: int
    MoveToStartOfBlock = ... # type: int
    MoveToEndOfBlock = ... # type: int
    MoveToStartOfDocument = ... # type: int
    MoveToEndOfDocument = ... # type: int
    SelectNextChar = ... # type: int
    SelectPreviousChar = ... # type: int
    SelectNextWord = ... # type: int
    SelectPreviousWord = ... # type: int
    SelectNextLine = ... # type: int
    SelectPreviousLine = ... # type: int
    SelectNextPage = ... # type: int
    SelectPreviousPage = ... # type: int
    SelectStartOfLine = ... # type: int
    SelectEndOfLine = ... # type: int
    SelectStartOfBlock = ... # type: int
    SelectEndOfBlock = ... # type: int
    SelectStartOfDocument = ... # type: int
    SelectEndOfDocument = ... # type: int
    DeleteStartOfWord = ... # type: int
    DeleteEndOfWord = ... # type: int
    DeleteEndOfLine = ... # type: int
    InsertParagraphSeparator = ... # type: int
    InsertLineSeparator = ... # type: int
    SaveAs = ... # type: int
    Preferences = ... # type: int
    Quit = ... # type: int
    FullScreen = ... # type: int
    Deselect = ... # type: int
    DeleteCompleteLine = ... # type: int
    Backspace = ... # type: int
    Cancel = ... # type: int

    SequenceMatch: typing.Type[int]
    #class SequenceMatch(int): ...
    NoMatch = ... # type: int
    PartialMatch = ... # type: int
    ExactMatch = ... # type: int

    SequenceFormat: typing.Type[int]
    #class SequenceFormat(int): ...
    NativeText = ... # type: int
    PortableText = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, ks: typing.Union[QKeySequence, int, str, int]) -> None: ...
    @overload
    def __init__(self, key: str, format: int = ...) -> None: ...
    @overload
    def __init__(self, k1: int, key2: int = ..., key3: int = ..., key4: int = ...) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def __hash__(self) -> int: ...
    @staticmethod
    def listToString(list: typing.Iterable[typing.Union[QKeySequence, int, str, int]], format: int = ...) -> str: ...
    @staticmethod
    def listFromString(str: str, format: int = ...) -> typing.List[QKeySequence]: ...
    @staticmethod
    def keyBindings(key: int) -> typing.List[QKeySequence]: ...
    @staticmethod
    def fromString(str: str, format: int = ...) -> QKeySequence: ...
    def toString(self, format: int = ...) -> str: ...
    def swap(self, other: QKeySequence) -> None: ...
    def isDetached(self) -> bool: ...
    def __getitem__(self, i: int) -> int: ...
    @staticmethod
    def mnemonic(text: str) -> QKeySequence: ...
    def matches(self, seq: typing.Union[QKeySequence, int, str, int]) -> int: ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...


class QMatrix4x4(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...
    @overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @overload
    def __init__(self, transform: QTransform) -> None: ...
    @overload
    def __init__(self, a0: QMatrix4x4) -> None: ...

    def __neg__(self) -> QMatrix4x4: ...
    def isAffine(self) -> bool: ...
    @overload
    def viewport(self, left: float, bottom: float, width: float, height: float, nearPlane: float = ..., farPlane: float = ...) -> None: ...
    @overload
    def viewport(self, rect: QtCore.QRectF) -> None: ...
    def mapVector(self, vector: QVector3D) -> QVector3D: ...
    @overload
    def map(self, point: QtCore.QPoint) -> QtCore.QPoint: ...
    @overload
    def map(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def map(self, point: QVector3D) -> QVector3D: ...
    @overload
    def map(self, point: QVector4D) -> QVector4D: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def setRow(self, index: int, value: QVector4D) -> None: ...
    def row(self, index: int) -> QVector4D: ...
    def setColumn(self, index: int, value: QVector4D) -> None: ...
    def column(self, index: int) -> QVector4D: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def optimize(self) -> None: ...
    def data(self) -> typing.List[float]: ...
    @overload
    def mapRect(self, rect: QtCore.QRect) -> QtCore.QRect: ...
    @overload
    def mapRect(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @overload
    def toTransform(self) -> QTransform: ...
    @overload
    def toTransform(self, distanceToPlane: float) -> QTransform: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def lookAt(self, eye: QVector3D, center: QVector3D, up: QVector3D) -> None: ...
    def perspective(self, angle: float, aspect: float, nearPlane: float, farPlane: float) -> None: ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @overload
    def ortho(self, rect: QtCore.QRect) -> None: ...
    @overload
    def ortho(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @overload
    def rotate(self, angle: float, vector: QVector3D) -> None: ...
    @overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None: ...
    @overload
    def rotate(self, quaternion: QQuaternion) -> None: ...
    @overload
    def translate(self, vector: QVector3D) -> None: ...
    @overload
    def translate(self, x: float, y: float) -> None: ...
    @overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    @overload
    def scale(self, vector: QVector3D) -> None: ...
    @overload
    def scale(self, x: float, y: float) -> None: ...
    @overload
    def scale(self, x: float, y: float, z: float) -> None: ...
    @overload
    def scale(self, factor: float) -> None: ...
    def normalMatrix(self) -> QMatrix3x3: ...
    def transposed(self) -> QMatrix4x4: ...
    def inverted(self) -> typing.Tuple[QMatrix4x4, bool]: ...
    def determinant(self) -> float: ...
    def __repr__(self) -> str: ...


class QMovie(QtCore.QObject):

    error: PYQT_SIGNAL
    finished: PYQT_SIGNAL
    frameChanged: PYQT_SIGNAL
    resized: PYQT_SIGNAL
    started: PYQT_SIGNAL
    stateChanged: PYQT_SIGNAL
    updated: PYQT_SIGNAL

    CacheMode: typing.Type[int]
    #class CacheMode(int): ...
    CacheNone = ... # type: int
    CacheAll = ... # type: int

    MovieState: typing.Type[int]
    #class MovieState(int): ...
    NotRunning = ... # type: int
    Paused = ... # type: int
    Running = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def lastErrorString(self) -> str: ...
    def lastError(self) -> int: ...
    def stop(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def jumpToNextFrame(self) -> bool: ...
    def start(self) -> None: ...
    #def frameChanged(self, frameNumber: int) -> None: ...
    #def finished(self) -> None: ...
    #def error(self, error: int) -> None: ...
    #def stateChanged(self, state: int) -> None: ...
    #def updated(self, rect: QtCore.QRect) -> None: ...
    #def resized(self, size: QtCore.QSize) -> None: ...
    #def started(self) -> None: ...
    def setCacheMode(self, mode: int) -> None: ...
    def cacheMode(self) -> int: ...
    def setScaledSize(self, size: QtCore.QSize) -> None: ...
    def scaledSize(self) -> QtCore.QSize: ...
    def speed(self) -> int: ...
    def setSpeed(self, percentSpeed: int) -> None: ...
    def currentFrameNumber(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def frameCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def isValid(self) -> bool: ...
    def currentPixmap(self) -> QPixmap: ...
    def currentImage(self) -> QImage: ...
    def frameRect(self) -> QtCore.QRect: ...
    def state(self) -> int: ...
    def backgroundColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    @staticmethod
    def supportedFormats() -> typing.List[QtCore.QByteArray]: ...


class QSurface(sip.simplewrapper):

    SurfaceType: typing.Type[int]
    #class SurfaceType(int): ...
    RasterSurface = ... # type: int
    OpenGLSurface = ... # type: int
    RasterGLSurface = ... # type: int
    OpenVGSurface = ... # type: int
    VulkanSurface = ... # type: int
    MetalSurface = ... # type: int

    SurfaceClass: typing.Type[int]
    #class SurfaceClass(int): ...
    Window = ... # type: int
    Offscreen = ... # type: int

    @overload
    def __init__(self, type: int) -> None: ...
    @overload
    def __init__(self, a0: QSurface) -> None: ...

    def supportsOpenGL(self) -> bool: ...
    def size(self) -> QtCore.QSize: ...
    def surfaceType(self) -> int: ...
    def format(self) -> QSurfaceFormat: ...
    def surfaceClass(self) -> int: ...


class QOffscreenSurface(QtCore.QObject, QSurface):

    screenChanged: PYQT_SIGNAL

    @overload
    def __init__(self, screen: typing.Optional[QScreen] = ..., **props) -> None: ...
    @overload
    def __init__(self, screen: QScreen, parent: QtCore.QObject, **props) -> None: ...

    def setNativeHandle(self, handle: sip.voidptr) -> None: ...
    def nativeHandle(self) -> sip.voidptr: ...
    #def screenChanged(self, screen: QScreen) -> None: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def screen(self) -> QScreen: ...
    def size(self) -> QtCore.QSize: ...
    def requestedFormat(self) -> QSurfaceFormat: ...
    def format(self) -> QSurfaceFormat: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...
    def isValid(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> None: ...
    def surfaceType(self) -> int: ...


class QOpenGLBuffer(sip.simplewrapper):

    RangeAccessFlag: typing.Type[int]
    #class RangeAccessFlag(int): ...
    RangeRead = ... # type: int
    RangeWrite = ... # type: int
    RangeInvalidate = ... # type: int
    RangeInvalidateBuffer = ... # type: int
    RangeFlushExplicit = ... # type: int
    RangeUnsynchronized = ... # type: int

    Access: typing.Type[int]
    #class Access(int): ...
    ReadOnly = ... # type: int
    WriteOnly = ... # type: int
    ReadWrite = ... # type: int

    UsagePattern: typing.Type[int]
    #class UsagePattern(int): ...
    StreamDraw = ... # type: int
    StreamRead = ... # type: int
    StreamCopy = ... # type: int
    StaticDraw = ... # type: int
    StaticRead = ... # type: int
    StaticCopy = ... # type: int
    DynamicDraw = ... # type: int
    DynamicRead = ... # type: int
    DynamicCopy = ... # type: int

    Type: typing.Type[int]
    #class Type(int): ...
    VertexBuffer = ... # type: int
    IndexBuffer = ... # type: int
    PixelPackBuffer = ... # type: int
    PixelUnpackBuffer = ... # type: int

    RangeAccessFlags: typing.Type[int]
    #class RangeAccessFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLBuffer.RangeAccessFlags, QOpenGLBuffer.RangeAccessFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLBuffer.RangeAccessFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLBuffer.RangeAccessFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: int) -> None: ...
    @overload
    def __init__(self, other: QOpenGLBuffer) -> None: ...

    def mapRange(self, offset: int, count: int, access: typing.Union[int, int]) -> sip.voidptr: ...
    def unmap(self) -> bool: ...
    def map(self, access: int) -> sip.voidptr: ...
    @overload
    def allocate(self, data: sip.voidptr, count: int) -> None: ...
    @overload
    def allocate(self, count: int) -> None: ...
    def write(self, offset: int, data: sip.voidptr, count: int) -> None: ...
    def read(self, offset: int, data: sip.voidptr, count: int) -> bool: ...
    def __len__(self) -> int: ...
    def size(self) -> int: ...
    def bufferId(self) -> int: ...
    @overload
    def release(self) -> None: ...
    #@overload
    #@staticmethod
    #def release(type: int) -> None: ...
    def bind(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def create(self) -> bool: ...
    def setUsagePattern(self, value: int) -> None: ...
    def usagePattern(self) -> int: ...
    def type(self) -> int: ...


class QOpenGLContextGroup(QtCore.QObject):

    @staticmethod
    def currentContextGroup() -> QOpenGLContextGroup: ...
    def shares(self) -> typing.List[QOpenGLContext]: ...


class QOpenGLContext(QtCore.QObject):

    aboutToBeDestroyed: PYQT_SIGNAL

    OpenGLModuleType: typing.Type[int]
    #class OpenGLModuleType(int): ...
    LibGL = ... # type: int
    LibGLES = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    @staticmethod
    def globalShareContext() -> QOpenGLContext: ...
    @staticmethod
    def supportsThreadedOpenGL() -> bool: ...
    def nativeHandle(self) -> typing.Any: ...
    def setNativeHandle(self, handle: typing.Any) -> None: ...
    def isOpenGLES(self) -> bool: ...
    @staticmethod
    def openGLModuleType() -> int: ...
    @staticmethod
    def openGLModuleHandle() -> sip.voidptr: ...
    def versionFunctions(self, versionProfile: typing.Optional[QOpenGLVersionProfile] = ...) -> typing.Any: ...
    #def aboutToBeDestroyed(self) -> None: ...
    def hasExtension(self, extension: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def extensions(self) -> typing.Set[QtCore.QByteArray]: ...
    @staticmethod
    def areSharing(first: QOpenGLContext, second: QOpenGLContext) -> bool: ...
    @staticmethod
    def currentContext() -> QOpenGLContext: ...
    def surface(self) -> QSurface: ...
    def getProcAddress(self, procName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> sip.voidptr: ...
    def swapBuffers(self, surface: QSurface) -> None: ...
    def doneCurrent(self) -> None: ...
    def makeCurrent(self, surface: QSurface) -> bool: ...
    def defaultFramebufferObject(self) -> int: ...
    def screen(self) -> QScreen: ...
    def shareGroup(self) -> QOpenGLContextGroup: ...
    def shareContext(self) -> QOpenGLContext: ...
    def format(self) -> QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def create(self) -> bool: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def setShareContext(self, shareContext: QOpenGLContext) -> None: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...


class QOpenGLVersionProfile(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, format: QSurfaceFormat) -> None: ...
    @overload
    def __init__(self, other: QOpenGLVersionProfile) -> None: ...

    def isValid(self) -> bool: ...
    def isLegacyVersion(self) -> bool: ...
    def hasProfiles(self) -> bool: ...
    def setProfile(self, profile: int) -> None: ...
    def profile(self) -> int: ...
    def setVersion(self, majorVersion: int, minorVersion: int) -> None: ...
    def version(self) -> typing.Tuple[int, int]: ...


class QOpenGLDebugMessage(sip.simplewrapper):

    Severity: typing.Type[int]
    #class Severity(int): ...
    InvalidSeverity = ... # type: int
    HighSeverity = ... # type: int
    MediumSeverity = ... # type: int
    LowSeverity = ... # type: int
    NotificationSeverity = ... # type: int
    AnySeverity = ... # type: int

    Type: typing.Type[int]
    #class Type(int): ...
    InvalidType = ... # type: int
    ErrorType = ... # type: int
    DeprecatedBehaviorType = ... # type: int
    UndefinedBehaviorType = ... # type: int
    PortabilityType = ... # type: int
    PerformanceType = ... # type: int
    OtherType = ... # type: int
    MarkerType = ... # type: int
    GroupPushType = ... # type: int
    GroupPopType = ... # type: int
    AnyType = ... # type: int

    Source: typing.Type[int]
    #class Source(int): ...
    InvalidSource = ... # type: int
    APISource = ... # type: int
    WindowSystemSource = ... # type: int
    ShaderCompilerSource = ... # type: int
    ThirdPartySource = ... # type: int
    ApplicationSource = ... # type: int
    OtherSource = ... # type: int
    AnySource = ... # type: int

    Sources: typing.Type[int]
    #class Sources(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLDebugMessage.Sources, QOpenGLDebugMessage.Source]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLDebugMessage.Sources) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLDebugMessage.Sources: ...
        #def __int__(self) -> int: ...

    Types: typing.Type[int]
    #class Types(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLDebugMessage.Types, int]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLDebugMessage.Types) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLDebugMessage.Types: ...
        #def __int__(self) -> int: ...

    Severities: typing.Type[int]
    #class Severities(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLDebugMessage.Severities, QOpenGLDebugMessage.Severity]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLDebugMessage.Severities) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLDebugMessage.Severities: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, debugMessage: QOpenGLDebugMessage) -> None: ...

    @staticmethod
    def createThirdPartyMessage(text: str, id: int = ..., severity: int = ..., type: int = ...) -> QOpenGLDebugMessage: ...
    @staticmethod
    def createApplicationMessage(text: str, id: int = ..., severity: int = ..., type: int = ...) -> QOpenGLDebugMessage: ...
    def message(self) -> str: ...
    def id(self) -> int: ...
    def severity(self) -> int: ...
    def type(self) -> int: ...
    def source(self) -> int: ...
    def swap(self, debugMessage: QOpenGLDebugMessage) -> None: ...


class QOpenGLDebugLogger(QtCore.QObject):

    messageLogged: PYQT_SIGNAL

    LoggingMode: typing.Type[int]
    #class LoggingMode(int): ...
    AsynchronousLogging = ... # type: int
    SynchronousLogging = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def messageLogged(self, debugMessage: QOpenGLDebugMessage) -> None: ...
    def stopLogging(self) -> None: ...
    def startLogging(self, loggingMode: int = ...) -> None: ...
    def logMessage(self, debugMessage: QOpenGLDebugMessage) -> None: ...
    def loggedMessages(self) -> typing.List[QOpenGLDebugMessage]: ...
    @overload
    def disableMessages(self, sources: typing.Union[int, int] = ..., types: typing.Union[int, int] = ..., severities: typing.Union[int, int] = ...) -> None: ...
    @overload
    def disableMessages(self, ids: typing.Iterable[int], sources: typing.Union[int, int] = ..., types: typing.Union[int, int] = ...) -> None: ...
    @overload
    def enableMessages(self, sources: typing.Union[int, int] = ..., types: typing.Union[int, int] = ..., severities: typing.Union[int, int] = ...) -> None: ...
    @overload
    def enableMessages(self, ids: typing.Iterable[int], sources: typing.Union[int, int] = ..., types: typing.Union[int, int] = ...) -> None: ...
    def popGroup(self) -> None: ...
    def pushGroup(self, name: str, id: int = ..., source: int = ...) -> None: ...
    def maximumMessageLength(self) -> int: ...
    def loggingMode(self) -> int: ...
    def isLogging(self) -> bool: ...
    def initialize(self) -> bool: ...


class QOpenGLFramebufferObject(sip.simplewrapper):

    FramebufferRestorePolicy: typing.Type[int]
    #class FramebufferRestorePolicy(int): ...
    DontRestoreFramebufferBinding = ... # type: int
    RestoreFramebufferBindingToDefault = ... # type: int
    RestoreFrameBufferBinding = ... # type: int

    Attachment: typing.Type[int]
    #class Attachment(int): ...
    NoAttachment = ... # type: int
    CombinedDepthStencil = ... # type: int
    Depth = ... # type: int

    @overload
    def __init__(self, size: QtCore.QSize, target: int = ...) -> None: ...
    @overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSize, attachment: int, target: int = ..., internal_format: int = ...) -> None: ...
    @overload
    def __init__(self, width: int, height: int, attachment: int, target: int = ..., internal_format: int = ...) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSize, format: QOpenGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: QOpenGLFramebufferObjectFormat) -> None: ...

    def sizes(self) -> typing.List[QtCore.QSize]: ...
    @overload
    def addColorAttachment(self, size: QtCore.QSize, internal_format: int = ...) -> None: ...
    @overload
    def addColorAttachment(self, width: int, height: int, internal_format: int = ...) -> None: ...
    @overload
    def takeTexture(self) -> int: ...
    @overload
    def takeTexture(self, colorAttachmentIndex: int) -> int: ...
    @overload
    @staticmethod
    def blitFramebuffer(target: QOpenGLFramebufferObject, targetRect: QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: QtCore.QRect, buffers: int = ..., filter: int = ...) -> None: ...
    @overload
    @staticmethod
    def blitFramebuffer(target: QOpenGLFramebufferObject, source: QOpenGLFramebufferObject, buffers: int = ..., filter: int = ...) -> None: ...
    @overload
    @staticmethod
    def blitFramebuffer(target: QOpenGLFramebufferObject, targetRect: QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int) -> None: ...
    @overload
    @staticmethod
    def blitFramebuffer(target: QOpenGLFramebufferObject, targetRect: QtCore.QRect, source: QOpenGLFramebufferObject, sourceRect: QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int, restorePolicy: int) -> None: ...
    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool: ...
    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool: ...
    @staticmethod
    def bindDefault() -> bool: ...
    def handle(self) -> int: ...
    def setAttachment(self, attachment: int) -> None: ...
    def attachment(self) -> int: ...
    @overload
    def toImage(self) -> QImage: ...
    @overload
    def toImage(self, flipped: bool) -> QImage: ...
    @overload
    def toImage(self, flipped: bool, colorAttachmentIndex: int) -> QImage: ...
    def size(self) -> QtCore.QSize: ...
    def textures(self) -> typing.List[int]: ...
    def texture(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def release(self) -> bool: ...
    def bind(self) -> bool: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def format(self) -> QOpenGLFramebufferObjectFormat: ...


class QOpenGLFramebufferObjectFormat(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QOpenGLFramebufferObjectFormat) -> None: ...

    def internalTextureFormat(self) -> int: ...
    def setInternalTextureFormat(self, internalTextureFormat: int) -> None: ...
    def textureTarget(self) -> int: ...
    def setTextureTarget(self, target: int) -> None: ...
    def attachment(self) -> int: ...
    def setAttachment(self, attachment: int) -> None: ...
    def mipmap(self) -> bool: ...
    def setMipmap(self, enabled: bool) -> None: ...
    def samples(self) -> int: ...
    def setSamples(self, samples: int) -> None: ...


class QOpenGLPaintDevice(QPaintDevice):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSize) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...

    def metric(self, metric: int) -> int: ...
    def setDevicePixelRatio(self, devicePixelRatio: float) -> None: ...
    def ensureActiveTarget(self) -> None: ...
    def paintFlipped(self) -> bool: ...
    def setPaintFlipped(self, flipped: bool) -> None: ...
    def setDotsPerMeterY(self, a0: float) -> None: ...
    def setDotsPerMeterX(self, a0: float) -> None: ...
    def dotsPerMeterY(self) -> float: ...
    def dotsPerMeterX(self) -> float: ...
    def setSize(self, size: QtCore.QSize) -> None: ...
    def size(self) -> QtCore.QSize: ...
    def context(self) -> QOpenGLContext: ...
    def paintEngine(self) -> QPaintEngine: ...


class QOpenGLPixelTransferOptions(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QOpenGLPixelTransferOptions) -> None: ...

    def isSwapBytesEnabled(self) -> bool: ...
    def setSwapBytesEnabled(self, swapBytes: bool) -> None: ...
    def isLeastSignificantBitFirst(self) -> bool: ...
    def setLeastSignificantByteFirst(self, lsbFirst: bool) -> None: ...
    def rowLength(self) -> int: ...
    def setRowLength(self, rowLength: int) -> None: ...
    def imageHeight(self) -> int: ...
    def setImageHeight(self, imageHeight: int) -> None: ...
    def skipPixels(self) -> int: ...
    def setSkipPixels(self, skipPixels: int) -> None: ...
    def skipRows(self) -> int: ...
    def setSkipRows(self, skipRows: int) -> None: ...
    def skipImages(self) -> int: ...
    def setSkipImages(self, skipImages: int) -> None: ...
    def alignment(self) -> int: ...
    def setAlignment(self, alignment: int) -> None: ...
    def swap(self, other: QOpenGLPixelTransferOptions) -> None: ...


class QOpenGLShader(QtCore.QObject):

    ShaderTypeBit: typing.Type[int]
    #class ShaderTypeBit(int): ...
    Vertex = ... # type: int
    Fragment = ... # type: int
    Geometry = ... # type: int
    TessellationControl = ... # type: int
    TessellationEvaluation = ... # type: int
    Compute = ... # type: int

    ShaderType: typing.Type[int]
    #class ShaderType(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLShader.ShaderType, QOpenGLShader.ShaderTypeBit]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLShader.ShaderType) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLShader.ShaderType: ...
        #def __int__(self) -> int: ...

    def __init__(self, type: typing.Union[int, int], parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    @staticmethod
    def hasOpenGLShaders(type: typing.Union[int, int], context: typing.Optional[QOpenGLContext] = ...) -> bool: ...
    def shaderId(self) -> int: ...
    def log(self) -> str: ...
    def isCompiled(self) -> bool: ...
    def sourceCode(self) -> QtCore.QByteArray: ...
    def compileSourceFile(self, fileName: str) -> bool: ...
    @overload
    def compileSourceCode(self, source: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    @overload
    def compileSourceCode(self, source: str) -> bool: ...
    def shaderType(self) -> int: ...


class QOpenGLShaderProgram(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def addCacheableShaderFromSourceFile(self, type: typing.Union[int, int], fileName: str) -> bool: ...
    @overload
    def addCacheableShaderFromSourceCode(self, type: typing.Union[int, int], source: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    @overload
    def addCacheableShaderFromSourceCode(self, type: typing.Union[int, int], source: str) -> bool: ...
    def create(self) -> bool: ...
    def defaultInnerTessellationLevels(self) -> typing.List[float]: ...
    def setDefaultInnerTessellationLevels(self, levels: typing.Iterable[float]) -> None: ...
    def defaultOuterTessellationLevels(self) -> typing.List[float]: ...
    def setDefaultOuterTessellationLevels(self, levels: typing.Iterable[float]) -> None: ...
    def patchVertexCount(self) -> int: ...
    def setPatchVertexCount(self, count: int) -> None: ...
    def maxGeometryOutputVertices(self) -> int: ...
    @staticmethod
    def hasOpenGLShaderPrograms(context: typing.Optional[QOpenGLContext] = ...) -> bool: ...
    @overload
    def setUniformValueArray(self, location: int, values: PYQT_SHADER_UNIFORM_VALUE_ARRAY) -> None: ...
    @overload
    def setUniformValueArray(self, name: str, values: PYQT_SHADER_UNIFORM_VALUE_ARRAY) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: int) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector2D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector3D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QVector4D) -> None: ...
    @overload
    def setUniformValue(self, location: int, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: QTransform) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: int) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: float) -> None: ...
    @overload
    def setUniformValue(self, name: str, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, name: str, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, name: str, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QVector2D) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QVector3D) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QVector4D) -> None: ...
    @overload
    def setUniformValue(self, name: str, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setUniformValue(self, name: str, point: QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, name: str, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setUniformValue(self, name: str, size: QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, name: str, size: QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, name: str, value: QTransform) -> None: ...
    @overload
    def uniformLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @overload
    def uniformLocation(self, name: str) -> int: ...
    @overload
    def disableAttributeArray(self, location: int) -> None: ...
    @overload
    def disableAttributeArray(self, name: str) -> None: ...
    @overload
    def enableAttributeArray(self, location: int) -> None: ...
    @overload
    def enableAttributeArray(self, name: str) -> None: ...
    @overload
    def setAttributeBuffer(self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeBuffer(self, name: str, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray(self, location: int, values: PYQT_SHADER_ATTRIBUTE_ARRAY) -> None: ...
    @overload
    def setAttributeArray(self, name: str, values: PYQT_SHADER_ATTRIBUTE_ARRAY) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: QVector4D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setAttributeValue(self, name: str, value: float) -> None: ...
    @overload
    def setAttributeValue(self, name: str, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, name: str, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, name: str, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, name: str, value: QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, name: str, value: QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, name: str, value: QVector4D) -> None: ...
    @overload
    def setAttributeValue(self, name: str, value: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def attributeLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @overload
    def attributeLocation(self, name: str) -> int: ...
    @overload
    def bindAttributeLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray], location: int) -> None: ...
    @overload
    def bindAttributeLocation(self, name: str, location: int) -> None: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def bind(self) -> bool: ...
    def log(self) -> str: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def removeAllShaders(self) -> None: ...
    def addShaderFromSourceFile(self, type: typing.Union[int, int], fileName: str) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[int, int], source: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[int, int], source: str) -> bool: ...
    def shaders(self) -> typing.List[QOpenGLShader]: ...
    def removeShader(self, shader: QOpenGLShader) -> None: ...
    def addShader(self, shader: QOpenGLShader) -> bool: ...


class QOpenGLTexture(sip.simplewrapper):

    ComparisonMode: typing.Type[int]
    #class ComparisonMode(int): ...
    CompareRefToTexture = ... # type: int
    CompareNone = ... # type: int

    ComparisonFunction: typing.Type[int]
    #class ComparisonFunction(int): ...
    CompareLessEqual = ... # type: int
    CompareGreaterEqual = ... # type: int
    CompareLess = ... # type: int
    CompareGreater = ... # type: int
    CompareEqual = ... # type: int
    CommpareNotEqual = ... # type: int
    CompareAlways = ... # type: int
    CompareNever = ... # type: int

    CoordinateDirection: typing.Type[int]
    #class CoordinateDirection(int): ...
    DirectionS = ... # type: int
    DirectionT = ... # type: int
    DirectionR = ... # type: int

    WrapMode: typing.Type[int]
    #class WrapMode(int): ...
    Repeat = ... # type: int
    MirroredRepeat = ... # type: int
    ClampToEdge = ... # type: int
    ClampToBorder = ... # type: int

    Filter: typing.Type[int]
    #class Filter(int): ...
    Nearest = ... # type: int
    Linear = ... # type: int
    NearestMipMapNearest = ... # type: int
    NearestMipMapLinear = ... # type: int
    LinearMipMapNearest = ... # type: int
    LinearMipMapLinear = ... # type: int

    DepthStencilMode: typing.Type[int]
    #class DepthStencilMode(int): ...
    DepthMode = ... # type: int
    StencilMode = ... # type: int

    SwizzleValue: typing.Type[int]
    #class SwizzleValue(int): ...
    RedValue = ... # type: int
    GreenValue = ... # type: int
    BlueValue = ... # type: int
    AlphaValue = ... # type: int
    ZeroValue = ... # type: int
    OneValue = ... # type: int

    SwizzleComponent: typing.Type[int]
    #class SwizzleComponent(int): ...
    SwizzleRed = ... # type: int
    SwizzleGreen = ... # type: int
    SwizzleBlue = ... # type: int
    SwizzleAlpha = ... # type: int

    Feature: typing.Type[int]
    #class Feature(int): ...
    ImmutableStorage = ... # type: int
    ImmutableMultisampleStorage = ... # type: int
    TextureRectangle = ... # type: int
    TextureArrays = ... # type: int
    Texture3D = ... # type: int
    TextureMultisample = ... # type: int
    TextureBuffer = ... # type: int
    TextureCubeMapArrays = ... # type: int
    Swizzle = ... # type: int
    StencilTexturing = ... # type: int
    AnisotropicFiltering = ... # type: int
    NPOTTextures = ... # type: int
    NPOTTextureRepeat = ... # type: int
    Texture1D = ... # type: int
    TextureComparisonOperators = ... # type: int
    TextureMipMapLevel = ... # type: int

    PixelType: typing.Type[int]
    #class PixelType(int): ...
    NoPixelType = ... # type: int
    Int8 = ... # type: int
    UInt8 = ... # type: int
    Int16 = ... # type: int
    UInt16 = ... # type: int
    Int32 = ... # type: int
    UInt32 = ... # type: int
    Float16 = ... # type: int
    Float16OES = ... # type: int
    Float32 = ... # type: int
    UInt32_RGB9_E5 = ... # type: int
    UInt32_RG11B10F = ... # type: int
    UInt8_RG3B2 = ... # type: int
    UInt8_RG3B2_Rev = ... # type: int
    UInt16_RGB5A1 = ... # type: int
    UInt16_RGB5A1_Rev = ... # type: int
    UInt16_R5G6B5 = ... # type: int
    UInt16_R5G6B5_Rev = ... # type: int
    UInt16_RGBA4 = ... # type: int
    UInt16_RGBA4_Rev = ... # type: int
    UInt32_RGB10A2 = ... # type: int
    UInt32_RGB10A2_Rev = ... # type: int
    UInt32_RGBA8 = ... # type: int
    UInt32_RGBA8_Rev = ... # type: int
    UInt32_D24S8 = ... # type: int
    Float32_D32_UInt32_S8_X24 = ... # type: int

    PixelFormat: typing.Type[int]
    #class PixelFormat(int): ...
    NoSourceFormat = ... # type: int
    Red = ... # type: int
    RG = ... # type: int
    RGB = ... # type: int
    BGR = ... # type: int
    RGBA = ... # type: int
    BGRA = ... # type: int
    Red_Integer = ... # type: int
    RG_Integer = ... # type: int
    RGB_Integer = ... # type: int
    BGR_Integer = ... # type: int
    RGBA_Integer = ... # type: int
    BGRA_Integer = ... # type: int
    Depth = ... # type: int
    DepthStencil = ... # type: int
    Alpha = ... # type: int
    Luminance = ... # type: int
    LuminanceAlpha = ... # type: int
    Stencil = ... # type: int

    CubeMapFace: typing.Type[int]
    #class CubeMapFace(int): ...
    CubeMapPositiveX = ... # type: int
    CubeMapNegativeX = ... # type: int
    CubeMapPositiveY = ... # type: int
    CubeMapNegativeY = ... # type: int
    CubeMapPositiveZ = ... # type: int
    CubeMapNegativeZ = ... # type: int

    TextureFormat: typing.Type[int]
    #class TextureFormat(int): ...
    NoFormat = ... # type: int
    R8_UNorm = ... # type: int
    RG8_UNorm = ... # type: int
    RGB8_UNorm = ... # type: int
    RGBA8_UNorm = ... # type: int
    R16_UNorm = ... # type: int
    RG16_UNorm = ... # type: int
    RGB16_UNorm = ... # type: int
    RGBA16_UNorm = ... # type: int
    R8_SNorm = ... # type: int
    RG8_SNorm = ... # type: int
    RGB8_SNorm = ... # type: int
    RGBA8_SNorm = ... # type: int
    R16_SNorm = ... # type: int
    RG16_SNorm = ... # type: int
    RGB16_SNorm = ... # type: int
    RGBA16_SNorm = ... # type: int
    R8U = ... # type: int
    RG8U = ... # type: int
    RGB8U = ... # type: int
    RGBA8U = ... # type: int
    R16U = ... # type: int
    RG16U = ... # type: int
    RGB16U = ... # type: int
    RGBA16U = ... # type: int
    R32U = ... # type: int
    RG32U = ... # type: int
    RGB32U = ... # type: int
    RGBA32U = ... # type: int
    R8I = ... # type: int
    RG8I = ... # type: int
    RGB8I = ... # type: int
    RGBA8I = ... # type: int
    R16I = ... # type: int
    RG16I = ... # type: int
    RGB16I = ... # type: int
    RGBA16I = ... # type: int
    R32I = ... # type: int
    RG32I = ... # type: int
    RGB32I = ... # type: int
    RGBA32I = ... # type: int
    R16F = ... # type: int
    RG16F = ... # type: int
    RGB16F = ... # type: int
    RGBA16F = ... # type: int
    R32F = ... # type: int
    RG32F = ... # type: int
    RGB32F = ... # type: int
    RGBA32F = ... # type: int
    RGB9E5 = ... # type: int
    RG11B10F = ... # type: int
    RG3B2 = ... # type: int
    R5G6B5 = ... # type: int
    RGB5A1 = ... # type: int
    RGBA4 = ... # type: int
    RGB10A2 = ... # type: int
    D16 = ... # type: int
    D24 = ... # type: int
    D24S8 = ... # type: int
    D32 = ... # type: int
    D32F = ... # type: int
    D32FS8X24 = ... # type: int
    RGB_DXT1 = ... # type: int
    RGBA_DXT1 = ... # type: int
    RGBA_DXT3 = ... # type: int
    RGBA_DXT5 = ... # type: int
    R_ATI1N_UNorm = ... # type: int
    R_ATI1N_SNorm = ... # type: int
    RG_ATI2N_UNorm = ... # type: int
    RG_ATI2N_SNorm = ... # type: int
    RGB_BP_UNSIGNED_FLOAT = ... # type: int
    RGB_BP_SIGNED_FLOAT = ... # type: int
    RGB_BP_UNorm = ... # type: int
    SRGB8 = ... # type: int
    SRGB8_Alpha8 = ... # type: int
    SRGB_DXT1 = ... # type: int
    SRGB_Alpha_DXT1 = ... # type: int
    SRGB_Alpha_DXT3 = ... # type: int
    SRGB_Alpha_DXT5 = ... # type: int
    SRGB_BP_UNorm = ... # type: int
    DepthFormat = ... # type: int
    AlphaFormat = ... # type: int
    RGBFormat = ... # type: int
    RGBAFormat = ... # type: int
    LuminanceFormat = ... # type: int
    LuminanceAlphaFormat = ... # type: int
    S8 = ... # type: int
    R11_EAC_UNorm = ... # type: int
    R11_EAC_SNorm = ... # type: int
    RG11_EAC_UNorm = ... # type: int
    RG11_EAC_SNorm = ... # type: int
    RGB8_ETC2 = ... # type: int
    SRGB8_ETC2 = ... # type: int
    RGB8_PunchThrough_Alpha1_ETC2 = ... # type: int
    SRGB8_PunchThrough_Alpha1_ETC2 = ... # type: int
    RGBA8_ETC2_EAC = ... # type: int
    SRGB8_Alpha8_ETC2_EAC = ... # type: int
    RGB8_ETC1 = ... # type: int
    RGBA_ASTC_4x4 = ... # type: int
    RGBA_ASTC_5x4 = ... # type: int
    RGBA_ASTC_5x5 = ... # type: int
    RGBA_ASTC_6x5 = ... # type: int
    RGBA_ASTC_6x6 = ... # type: int
    RGBA_ASTC_8x5 = ... # type: int
    RGBA_ASTC_8x6 = ... # type: int
    RGBA_ASTC_8x8 = ... # type: int
    RGBA_ASTC_10x5 = ... # type: int
    RGBA_ASTC_10x6 = ... # type: int
    RGBA_ASTC_10x8 = ... # type: int
    RGBA_ASTC_10x10 = ... # type: int
    RGBA_ASTC_12x10 = ... # type: int
    RGBA_ASTC_12x12 = ... # type: int
    SRGB8_Alpha8_ASTC_4x4 = ... # type: int
    SRGB8_Alpha8_ASTC_5x4 = ... # type: int
    SRGB8_Alpha8_ASTC_5x5 = ... # type: int
    SRGB8_Alpha8_ASTC_6x5 = ... # type: int
    SRGB8_Alpha8_ASTC_6x6 = ... # type: int
    SRGB8_Alpha8_ASTC_8x5 = ... # type: int
    SRGB8_Alpha8_ASTC_8x6 = ... # type: int
    SRGB8_Alpha8_ASTC_8x8 = ... # type: int
    SRGB8_Alpha8_ASTC_10x5 = ... # type: int
    SRGB8_Alpha8_ASTC_10x6 = ... # type: int
    SRGB8_Alpha8_ASTC_10x8 = ... # type: int
    SRGB8_Alpha8_ASTC_10x10 = ... # type: int
    SRGB8_Alpha8_ASTC_12x10 = ... # type: int
    SRGB8_Alpha8_ASTC_12x12 = ... # type: int

    TextureUnitReset: typing.Type[int]
    #class TextureUnitReset(int): ...
    ResetTextureUnit = ... # type: int
    DontResetTextureUnit = ... # type: int

    MipMapGeneration: typing.Type[int]
    #class MipMapGeneration(int): ...
    GenerateMipMaps = ... # type: int
    DontGenerateMipMaps = ... # type: int

    BindingTarget: typing.Type[int]
    #class BindingTarget(int): ...
    BindingTarget1D = ... # type: int
    BindingTarget1DArray = ... # type: int
    BindingTarget2D = ... # type: int
    BindingTarget2DArray = ... # type: int
    BindingTarget3D = ... # type: int
    BindingTargetCubeMap = ... # type: int
    BindingTargetCubeMapArray = ... # type: int
    BindingTarget2DMultisample = ... # type: int
    BindingTarget2DMultisampleArray = ... # type: int
    BindingTargetRectangle = ... # type: int
    BindingTargetBuffer = ... # type: int

    Target: typing.Type[int]
    #class Target(int): ...
    Target1D = ... # type: int
    Target1DArray = ... # type: int
    Target2D = ... # type: int
    Target2DArray = ... # type: int
    Target3D = ... # type: int
    TargetCubeMap = ... # type: int
    TargetCubeMapArray = ... # type: int
    Target2DMultisample = ... # type: int
    Target2DMultisampleArray = ... # type: int
    TargetRectangle = ... # type: int
    TargetBuffer = ... # type: int

    Features: typing.Type[int]
    #class Features(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QOpenGLTexture.Features, QOpenGLTexture.Feature]) -> None: ...
        #@overload
        #def __init__(self, a0: QOpenGLTexture.Features) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QOpenGLTexture.Features: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, target: int) -> None: ...
    @overload
    def __init__(self, image: QImage, genMipMaps: int = ...) -> None: ...

    def comparisonMode(self) -> int: ...
    def setComparisonMode(self, mode: int) -> None: ...
    def comparisonFunction(self) -> int: ...
    def setComparisonFunction(self, function: int) -> None: ...
    def isFixedSamplePositions(self) -> bool: ...
    def setFixedSamplePositions(self, fixed: bool) -> None: ...
    def samples(self) -> int: ...
    def setSamples(self, samples: int) -> None: ...
    def target(self) -> int: ...
    def levelofDetailBias(self) -> float: ...
    def setLevelofDetailBias(self, bias: float) -> None: ...
    def levelOfDetailRange(self) -> typing.Tuple[float, float]: ...
    def setLevelOfDetailRange(self, min: float, max: float) -> None: ...
    def maximumLevelOfDetail(self) -> float: ...
    def setMaximumLevelOfDetail(self, value: float) -> None: ...
    def minimumLevelOfDetail(self) -> float: ...
    def setMinimumLevelOfDetail(self, value: float) -> None: ...
    def borderColor(self) -> QColor: ...
    def setBorderColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def wrapMode(self, direction: int) -> int: ...
    @overload
    def setWrapMode(self, mode: int) -> None: ...
    @overload
    def setWrapMode(self, direction: int, mode: int) -> None: ...
    def maximumAnisotropy(self) -> float: ...
    def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
    def minMagFilters(self) -> typing.Tuple[int, int]: ...
    def setMinMagFilters(self, minificationFilter: int, magnificationFilter: int) -> None: ...
    def magnificationFilter(self) -> int: ...
    def setMagnificationFilter(self, filter: int) -> None: ...
    def minificationFilter(self) -> int: ...
    def setMinificationFilter(self, filter: int) -> None: ...
    def depthStencilMode(self) -> int: ...
    def setDepthStencilMode(self, mode: int) -> None: ...
    def swizzleMask(self, component: int) -> int: ...
    @overload
    def setSwizzleMask(self, component: int, value: int) -> None: ...
    @overload
    def setSwizzleMask(self, r: int, g: int, b: int, a: int) -> None: ...
    @overload
    def generateMipMaps(self) -> None: ...
    @overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...) -> None: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    def setAutoMipMapGenerationEnabled(self, enabled: bool) -> None: ...
    def mipLevelRange(self) -> typing.Tuple[int, int]: ...
    def setMipLevelRange(self, baseLevel: int, maxLevel: int) -> None: ...
    def mipMaxLevel(self) -> int: ...
    def setMipMaxLevel(self, maxLevel: int) -> None: ...
    def mipBaseLevel(self) -> int: ...
    def setMipBaseLevel(self, baseLevel: int) -> None: ...
    @staticmethod
    def hasFeature(feature: int) -> bool: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, cubeFace: int, dataSize: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, dataSize: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, dataSize: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setCompressedData(self, dataSize: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setCompressedData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: int, dataSize: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, cubeFace: int, sourceFormat: int, sourceType: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, sourceFormat: int, sourceType: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, sourceFormat: int, sourceType: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setData(self, sourceFormat: int, sourceType: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @overload
    def setData(self, image: QImage, genMipMaps: int = ...) -> None: ...
    @overload
    def setData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: int, sourceFormat: int, sourceType: int, data: sip.voidptr, options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    def isTextureView(self) -> bool: ...
    def createTextureView(self, target: int, viewFormat: int, minimumMipmapLevel: int, maximumMipmapLevel: int, minimumLayer: int, maximumLayer: int) -> QOpenGLTexture: ...
    def isStorageAllocated(self) -> bool: ...
    @overload
    def allocateStorage(self) -> None: ...
    @overload
    def allocateStorage(self, pixelFormat: int, pixelType: int) -> None: ...
    def faces(self) -> int: ...
    def layers(self) -> int: ...
    def setLayers(self, layers: int) -> None: ...
    def maximumMipLevels(self) -> int: ...
    def mipLevels(self) -> int: ...
    def setMipLevels(self, levels: int) -> None: ...
    def depth(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
    def format(self) -> int: ...
    def setFormat(self, format: int) -> None: ...
    @overload
    @staticmethod
    def boundTextureId(target: int) -> int: ...
    @overload
    @staticmethod
    def boundTextureId(unit: int, target: int) -> int: ...
    @overload
    def isBound(self) -> bool: ...
    @overload
    def isBound(self, unit: int) -> bool: ...
    @overload
    def release(self) -> None: ...
    @overload
    def release(self, unit: int, reset: int = ...) -> None: ...
    @overload
    def bind(self) -> None: ...
    @overload
    def bind(self, unit: int, reset: int = ...) -> None: ...
    def textureId(self) -> int: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...


class QOpenGLTextureBlitter(sip.simplewrapper):

    Origin: typing.Type[int]
    #class Origin(int): ...
    OriginBottomLeft = ... # type: int
    OriginTopLeft = ... # type: int

    def __init__(self) -> None: ...

    @staticmethod
    def sourceTransform(subTexture: QtCore.QRectF, textureSize: QtCore.QSize, origin: int) -> QMatrix3x3: ...
    @staticmethod
    def targetTransform(target: QtCore.QRectF, viewport: QtCore.QRect) -> QMatrix4x4: ...
    @overload
    def blit(self, texture: int, targetTransform: QMatrix4x4, sourceOrigin: int) -> None: ...
    @overload
    def blit(self, texture: int, targetTransform: QMatrix4x4, sourceTransform: QMatrix3x3) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setRedBlueSwizzle(self, swizzle: bool) -> None: ...
    def release(self) -> None: ...
    def bind(self, target: int = ...) -> None: ...
    def supportsExternalOESTarget(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def create(self) -> bool: ...


class QOpenGLTimerQuery(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def waitForResult(self) -> int: ...
    def isResultAvailable(self) -> bool: ...
    def recordTimestamp(self) -> None: ...
    def waitForTimestamp(self) -> int: ...
    def end(self) -> None: ...
    def begin(self) -> None: ...
    def objectId(self) -> int: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...


class QOpenGLTimeMonitor(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def reset(self) -> None: ...
    def waitForIntervals(self) -> typing.List[int]: ...
    def waitForSamples(self) -> typing.List[int]: ...
    def isResultAvailable(self) -> bool: ...
    def recordSample(self) -> int: ...
    def objectIds(self) -> typing.List[int]: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...
    def sampleCount(self) -> int: ...
    def setSampleCount(self, sampleCount: int) -> None: ...


class QAbstractOpenGLFunctions(sip.wrapper): ...


class QOpenGLVertexArrayObject(QtCore.QObject):

    class Binder:

        def __init__(self, v: QOpenGLVertexArrayObject) -> None: ...

        def __exit__(self, type: typing.Any, value: typing.Any, traceback: typing.Any) -> None: ...
        def __enter__(self) -> typing.Any: ...
        def rebind(self) -> None: ...
        def release(self) -> None: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def release(self) -> None: ...
    def bind(self) -> None: ...
    def objectId(self) -> int: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...


class QWindow(QtCore.QObject, QSurface):

    activeChanged: PYQT_SIGNAL
    contentOrientationChanged: PYQT_SIGNAL
    focusObjectChanged: PYQT_SIGNAL
    heightChanged: PYQT_SIGNAL
    maximumHeightChanged: PYQT_SIGNAL
    maximumWidthChanged: PYQT_SIGNAL
    minimumHeightChanged: PYQT_SIGNAL
    minimumWidthChanged: PYQT_SIGNAL
    modalityChanged: PYQT_SIGNAL
    opacityChanged: PYQT_SIGNAL
    screenChanged: PYQT_SIGNAL
    visibilityChanged: PYQT_SIGNAL
    visibleChanged: PYQT_SIGNAL
    widthChanged: PYQT_SIGNAL
    windowStateChanged: PYQT_SIGNAL
    windowTitleChanged: PYQT_SIGNAL
    xChanged: PYQT_SIGNAL
    yChanged: PYQT_SIGNAL

    Visibility: typing.Type[int]
    #class Visibility(int): ...
    Hidden = ... # type: int
    AutomaticVisibility = ... # type: int
    Windowed = ... # type: int
    Minimized = ... # type: int
    Maximized = ... # type: int
    FullScreen = ... # type: int

    AncestorMode: typing.Type[int]
    #class AncestorMode(int): ...
    ExcludeTransients = ... # type: int
    IncludeTransients = ... # type: int

    @overload
    def __init__(self, screen: typing.Optional[QScreen] = ..., **props) -> None: ...
    @overload
    def __init__(self, parent: QWindow, **props) -> None: ...

    def setWindowStates(self, states: typing.Union[int, int]) -> None: ...
    def windowStates(self) -> int: ...
    def setFlag(self, a0: int, on: bool = ...) -> None: ...
    #def opacityChanged(self, opacity: float) -> None: ...
    #def activeChanged(self) -> None: ...
    #def visibilityChanged(self, visibility: int) -> None: ...
    @staticmethod
    def fromWinId(id: sip.voidptr) -> QWindow: ...
    def mask(self) -> QRegion: ...
    def setMask(self, region: QRegion) -> None: ...
    def opacity(self) -> float: ...
    def setVisibility(self, v: int) -> None: ...
    def visibility(self) -> int: ...
    def tabletEvent(self, a0: QTabletEvent) -> None: ...
    def touchEvent(self, a0: QTouchEvent) -> None: ...
    def wheelEvent(self, a0: QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def keyReleaseEvent(self, a0: QKeyEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def hideEvent(self, a0: QHideEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def focusOutEvent(self, a0: QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QFocusEvent) -> None: ...
    def moveEvent(self, a0: QMoveEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def exposeEvent(self, a0: QExposeEvent) -> None: ...
    #def windowTitleChanged(self, title: str) -> None: ...
    #def focusObjectChanged(self, object: QtCore.QObject) -> None: ...
    #def contentOrientationChanged(self, orientation: int) -> None: ...
    #def visibleChanged(self, arg: bool) -> None: ...
    #def maximumHeightChanged(self, arg: int) -> None: ...
    #def maximumWidthChanged(self, arg: int) -> None: ...
    #def minimumHeightChanged(self, arg: int) -> None: ...
    #def minimumWidthChanged(self, arg: int) -> None: ...
    #def heightChanged(self, arg: int) -> None: ...
    #def widthChanged(self, arg: int) -> None: ...
    #def yChanged(self, arg: int) -> None: ...
    #def xChanged(self, arg: int) -> None: ...
    #def windowStateChanged(self, windowState: int) -> None: ...
    #def modalityChanged(self, modality: int) -> None: ...
    #def screenChanged(self, screen: QScreen) -> None: ...
    def requestUpdate(self) -> None: ...
    def alert(self, msec: int) -> None: ...
    def setMaximumHeight(self, h: int) -> None: ...
    def setMaximumWidth(self, w: int) -> None: ...
    def setMinimumHeight(self, h: int) -> None: ...
    def setMinimumWidth(self, w: int) -> None: ...
    def setHeight(self, arg: int) -> None: ...
    def setWidth(self, arg: int) -> None: ...
    def setY(self, arg: int) -> None: ...
    def setX(self, arg: int) -> None: ...
    def setTitle(self, a0: str) -> None: ...
    def lower(self) -> None: ...
    def raise_(self) -> None: ...
    def close(self) -> bool: ...
    def showNormal(self) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def unsetCursor(self) -> None: ...
    def setCursor(self, a0: typing.Union[QCursor, int]) -> None: ...
    def cursor(self) -> QCursor: ...
    def mapFromGlobal(self, pos: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapToGlobal(self, pos: QtCore.QPoint) -> QtCore.QPoint: ...
    def focusObject(self) -> QtCore.QObject: ...
    def setScreen(self, screen: QScreen) -> None: ...
    def screen(self) -> QScreen: ...
    def setMouseGrabEnabled(self, grab: bool) -> bool: ...
    def setKeyboardGrabEnabled(self, grab: bool) -> bool: ...
    def destroy(self) -> None: ...
    def icon(self) -> QIcon: ...
    def setIcon(self, icon: QIcon) -> None: ...
    def filePath(self) -> str: ...
    def setFilePath(self, filePath: str) -> None: ...
    @overload
    def resize(self, newSize: QtCore.QSize) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    @overload
    def setPosition(self, pt: QtCore.QPoint) -> None: ...
    @overload
    def setPosition(self, posx: int, posy: int) -> None: ...
    def position(self) -> QtCore.QPoint: ...
    def size(self) -> QtCore.QSize: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def setFramePosition(self, point: QtCore.QPoint) -> None: ...
    def framePosition(self) -> QtCore.QPoint: ...
    def frameGeometry(self) -> QtCore.QRect: ...
    def frameMargins(self) -> QtCore.QMargins: ...
    def geometry(self) -> QtCore.QRect: ...
    @overload
    def setGeometry(self, posx: int, posy: int, w: int, h: int) -> None: ...
    @overload
    def setGeometry(self, rect: QtCore.QRect) -> None: ...
    def setSizeIncrement(self, size: QtCore.QSize) -> None: ...
    def setBaseSize(self, size: QtCore.QSize) -> None: ...
    def setMaximumSize(self, size: QtCore.QSize) -> None: ...
    def setMinimumSize(self, size: QtCore.QSize) -> None: ...
    def sizeIncrement(self) -> QtCore.QSize: ...
    def baseSize(self) -> QtCore.QSize: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def maximumHeight(self) -> int: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumWidth(self) -> int: ...
    def isExposed(self) -> bool: ...
    def isAncestorOf(self, child: QWindow, mode: int = ...) -> bool: ...
    def transientParent(self) -> QWindow: ...
    def setTransientParent(self, parent: QWindow) -> None: ...
    def setWindowState(self, state: int) -> None: ...
    def windowState(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def contentOrientation(self) -> int: ...
    def reportContentOrientationChange(self, orientation: int) -> None: ...
    def isActive(self) -> bool: ...
    def requestActivate(self) -> None: ...
    def setOpacity(self, level: float) -> None: ...
    def title(self) -> str: ...
    def type(self) -> int: ...
    def flags(self) -> int: ...
    def setFlags(self, flags: typing.Union[int, int]) -> None: ...
    def requestedFormat(self) -> QSurfaceFormat: ...
    def format(self) -> QSurfaceFormat: ...
    def setFormat(self, format: QSurfaceFormat) -> None: ...
    def setModality(self, modality: int) -> None: ...
    def modality(self) -> int: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def setParent(self, parent: QWindow) -> None: ...
    @overload
    def parent(self) -> QWindow: ...
    @overload
    def parent(self, mode: int) -> QWindow: ...
    def winId(self) -> sip.voidptr: ...
    def create(self) -> None: ...
    def isVisible(self) -> bool: ...
    def surfaceType(self) -> int: ...
    def setSurfaceType(self, surfaceType: int) -> None: ...


class QPaintDeviceWindow(QWindow, QPaintDevice):

    def event(self, event: QtCore.QEvent) -> bool: ...
    def exposeEvent(self, a0: QExposeEvent) -> None: ...
    def metric(self, metric: int) -> int: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    @overload
    def update(self, rect: QtCore.QRect) -> None: ...
    @overload
    def update(self, region: QRegion) -> None: ...
    @overload
    def update(self) -> None: ...


class QOpenGLWindow(QPaintDeviceWindow):

    frameSwapped: PYQT_SIGNAL

    UpdateBehavior: typing.Type[int]
    #class UpdateBehavior(int): ...
    NoPartialUpdate = ... # type: int
    PartialUpdateBlit = ... # type: int
    PartialUpdateBlend = ... # type: int

    @overload
    def __init__(self, updateBehavior: int = ..., parent: typing.Optional[QWindow] = ..., **props) -> None: ...
    @overload
    def __init__(self, shareContext: QOpenGLContext, updateBehavior: int = ..., parent: typing.Optional[QWindow] = ..., **props) -> None: ...

    def metric(self, metric: int) -> int: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def paintOverGL(self) -> None: ...
    def paintUnderGL(self) -> None: ...
    def paintGL(self) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def initializeGL(self) -> None: ...
    #def frameSwapped(self) -> None: ...
    def shareContext(self) -> QOpenGLContext: ...
    def grabFramebuffer(self) -> QImage: ...
    def defaultFramebufferObject(self) -> int: ...
    def context(self) -> QOpenGLContext: ...
    def doneCurrent(self) -> None: ...
    def makeCurrent(self) -> None: ...
    def isValid(self) -> bool: ...
    def updateBehavior(self) -> int: ...


class QPagedPaintDevice(QPaintDevice):

    PdfVersion: typing.Type[int]
    #class PdfVersion(int): ...
    PdfVersion_1_4 = ... # type: int
    PdfVersion_A1b = ... # type: int
    PdfVersion_1_6 = ... # type: int

    PageSize: typing.Type[int]
    #class PageSize(int): ...
    A4 = ... # type: int
    B5 = ... # type: int
    Letter = ... # type: int
    Legal = ... # type: int
    Executive = ... # type: int
    A0 = ... # type: int
    A1 = ... # type: int
    A2 = ... # type: int
    A3 = ... # type: int
    A5 = ... # type: int
    A6 = ... # type: int
    A7 = ... # type: int
    A8 = ... # type: int
    A9 = ... # type: int
    B0 = ... # type: int
    B1 = ... # type: int
    B10 = ... # type: int
    B2 = ... # type: int
    B3 = ... # type: int
    B4 = ... # type: int
    B6 = ... # type: int
    B7 = ... # type: int
    B8 = ... # type: int
    B9 = ... # type: int
    C5E = ... # type: int
    Comm10E = ... # type: int
    DLE = ... # type: int
    Folio = ... # type: int
    Ledger = ... # type: int
    Tabloid = ... # type: int
    Custom = ... # type: int
    A10 = ... # type: int
    A3Extra = ... # type: int
    A4Extra = ... # type: int
    A4Plus = ... # type: int
    A4Small = ... # type: int
    A5Extra = ... # type: int
    B5Extra = ... # type: int
    JisB0 = ... # type: int
    JisB1 = ... # type: int
    JisB2 = ... # type: int
    JisB3 = ... # type: int
    JisB4 = ... # type: int
    JisB5 = ... # type: int
    JisB6 = ... # type: int
    JisB7 = ... # type: int
    JisB8 = ... # type: int
    JisB9 = ... # type: int
    JisB10 = ... # type: int
    AnsiC = ... # type: int
    AnsiD = ... # type: int
    AnsiE = ... # type: int
    LegalExtra = ... # type: int
    LetterExtra = ... # type: int
    LetterPlus = ... # type: int
    LetterSmall = ... # type: int
    TabloidExtra = ... # type: int
    ArchA = ... # type: int
    ArchB = ... # type: int
    ArchC = ... # type: int
    ArchD = ... # type: int
    ArchE = ... # type: int
    Imperial7x9 = ... # type: int
    Imperial8x10 = ... # type: int
    Imperial9x11 = ... # type: int
    Imperial9x12 = ... # type: int
    Imperial10x11 = ... # type: int
    Imperial10x13 = ... # type: int
    Imperial10x14 = ... # type: int
    Imperial12x11 = ... # type: int
    Imperial15x11 = ... # type: int
    ExecutiveStandard = ... # type: int
    Note = ... # type: int
    Quarto = ... # type: int
    Statement = ... # type: int
    SuperA = ... # type: int
    SuperB = ... # type: int
    Postcard = ... # type: int
    DoublePostcard = ... # type: int
    Prc16K = ... # type: int
    Prc32K = ... # type: int
    Prc32KBig = ... # type: int
    FanFoldUS = ... # type: int
    FanFoldGerman = ... # type: int
    FanFoldGermanLegal = ... # type: int
    EnvelopeB4 = ... # type: int
    EnvelopeB5 = ... # type: int
    EnvelopeB6 = ... # type: int
    EnvelopeC0 = ... # type: int
    EnvelopeC1 = ... # type: int
    EnvelopeC2 = ... # type: int
    EnvelopeC3 = ... # type: int
    EnvelopeC4 = ... # type: int
    EnvelopeC6 = ... # type: int
    EnvelopeC65 = ... # type: int
    EnvelopeC7 = ... # type: int
    Envelope9 = ... # type: int
    Envelope11 = ... # type: int
    Envelope12 = ... # type: int
    Envelope14 = ... # type: int
    EnvelopeMonarch = ... # type: int
    EnvelopePersonal = ... # type: int
    EnvelopeChou3 = ... # type: int
    EnvelopeChou4 = ... # type: int
    EnvelopeInvite = ... # type: int
    EnvelopeItalian = ... # type: int
    EnvelopeKaku2 = ... # type: int
    EnvelopeKaku3 = ... # type: int
    EnvelopePrc1 = ... # type: int
    EnvelopePrc2 = ... # type: int
    EnvelopePrc3 = ... # type: int
    EnvelopePrc4 = ... # type: int
    EnvelopePrc5 = ... # type: int
    EnvelopePrc6 = ... # type: int
    EnvelopePrc7 = ... # type: int
    EnvelopePrc8 = ... # type: int
    EnvelopePrc9 = ... # type: int
    EnvelopePrc10 = ... # type: int
    EnvelopeYou4 = ... # type: int
    NPaperSize = ... # type: int
    AnsiA = ... # type: int
    AnsiB = ... # type: int
    EnvelopeC5 = ... # type: int
    EnvelopeDL = ... # type: int
    Envelope10 = ... # type: int
    LastPageSize = ... # type: int

    class Margins:

        bottom = ... # type: float
        left = ... # type: float
        right = ... # type: float
        top = ... # type: float

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QPagedPaintDevice.Margins) -> None: ...

    def __init__(self) -> None: ...

    def pageLayout(self) -> QPageLayout: ...
    @overload
    def setPageMargins(self, margins: QtCore.QMarginsF) -> bool: ...
    @overload
    def setPageMargins(self, margins: QtCore.QMarginsF, units: int) -> bool: ...
    def setPageOrientation(self, orientation: int) -> bool: ...
    def setPageLayout(self, pageLayout: QPageLayout) -> bool: ...
    def margins(self) -> QPagedPaintDevice.Margins: ...
    def setMargins(self, margins: QPagedPaintDevice.Margins) -> None: ...
    def pageSizeMM(self) -> QtCore.QSizeF: ...
    def setPageSizeMM(self, size: QtCore.QSizeF) -> None: ...
    def pageSize(self) -> int: ...
    @overload
    def setPageSize(self, size: int) -> None: ...
    @overload
    def setPageSize(self, pageSize: QPageSize) -> bool: ...
    def newPage(self) -> bool: ...


class QPageLayout(sip.simplewrapper):

    Mode: typing.Type[int]
    #class Mode(int): ...
    StandardMode = ... # type: int
    FullPageMode = ... # type: int

    Orientation: typing.Type[int]
    #class Orientation(int): ...
    Portrait = ... # type: int
    Landscape = ... # type: int

    Unit: typing.Type[int]
    #class Unit(int): ...
    Millimeter = ... # type: int
    Point = ... # type: int
    Inch = ... # type: int
    Pica = ... # type: int
    Didot = ... # type: int
    Cicero = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pageSize: QPageSize, orientation: int, margins: QtCore.QMarginsF, units: int = ..., minMargins: QtCore.QMarginsF = ...) -> None: ...
    @overload
    def __init__(self, other: QPageLayout) -> None: ...

    def paintRectPixels(self, resolution: int) -> QtCore.QRect: ...
    def paintRectPoints(self) -> QtCore.QRect: ...
    @overload
    def paintRect(self) -> QtCore.QRectF: ...
    @overload
    def paintRect(self, units: int) -> QtCore.QRectF: ...
    def fullRectPixels(self, resolution: int) -> QtCore.QRect: ...
    def fullRectPoints(self) -> QtCore.QRect: ...
    @overload
    def fullRect(self) -> QtCore.QRectF: ...
    @overload
    def fullRect(self, units: int) -> QtCore.QRectF: ...
    def maximumMargins(self) -> QtCore.QMarginsF: ...
    def minimumMargins(self) -> QtCore.QMarginsF: ...
    def setMinimumMargins(self, minMargins: QtCore.QMarginsF) -> None: ...
    def marginsPixels(self, resolution: int) -> QtCore.QMargins: ...
    def marginsPoints(self) -> QtCore.QMargins: ...
    @overload
    def margins(self) -> QtCore.QMarginsF: ...
    @overload
    def margins(self, units: int) -> QtCore.QMarginsF: ...
    def setBottomMargin(self, bottomMargin: float) -> bool: ...
    def setTopMargin(self, topMargin: float) -> bool: ...
    def setRightMargin(self, rightMargin: float) -> bool: ...
    def setLeftMargin(self, leftMargin: float) -> bool: ...
    def setMargins(self, margins: QtCore.QMarginsF) -> bool: ...
    def units(self) -> int: ...
    def setUnits(self, units: int) -> None: ...
    def orientation(self) -> int: ...
    def setOrientation(self, orientation: int) -> None: ...
    def pageSize(self) -> QPageSize: ...
    def setPageSize(self, pageSize: QPageSize, minMargins: QtCore.QMarginsF = ...) -> None: ...
    def mode(self) -> int: ...
    def setMode(self, mode: int) -> None: ...
    def isValid(self) -> bool: ...
    def isEquivalentTo(self, other: QPageLayout) -> bool: ...
    def swap(self, other: QPageLayout) -> None: ...


class QPageSize(sip.simplewrapper):

    SizeMatchPolicy: typing.Type[int]
    #class SizeMatchPolicy(int): ...
    FuzzyMatch = ... # type: int
    FuzzyOrientationMatch = ... # type: int
    ExactMatch = ... # type: int

    Unit: typing.Type[int]
    #class Unit(int): ...
    Millimeter = ... # type: int
    Point = ... # type: int
    Inch = ... # type: int
    Pica = ... # type: int
    Didot = ... # type: int
    Cicero = ... # type: int

    PageSizeId: typing.Type[int]
    #class PageSizeId(int): ...
    A4 = ... # type: int
    B5 = ... # type: int
    Letter = ... # type: int
    Legal = ... # type: int
    Executive = ... # type: int
    A0 = ... # type: int
    A1 = ... # type: int
    A2 = ... # type: int
    A3 = ... # type: int
    A5 = ... # type: int
    A6 = ... # type: int
    A7 = ... # type: int
    A8 = ... # type: int
    A9 = ... # type: int
    B0 = ... # type: int
    B1 = ... # type: int
    B10 = ... # type: int
    B2 = ... # type: int
    B3 = ... # type: int
    B4 = ... # type: int
    B6 = ... # type: int
    B7 = ... # type: int
    B8 = ... # type: int
    B9 = ... # type: int
    C5E = ... # type: int
    Comm10E = ... # type: int
    DLE = ... # type: int
    Folio = ... # type: int
    Ledger = ... # type: int
    Tabloid = ... # type: int
    Custom = ... # type: int
    A10 = ... # type: int
    A3Extra = ... # type: int
    A4Extra = ... # type: int
    A4Plus = ... # type: int
    A4Small = ... # type: int
    A5Extra = ... # type: int
    B5Extra = ... # type: int
    JisB0 = ... # type: int
    JisB1 = ... # type: int
    JisB2 = ... # type: int
    JisB3 = ... # type: int
    JisB4 = ... # type: int
    JisB5 = ... # type: int
    JisB6 = ... # type: int
    JisB7 = ... # type: int
    JisB8 = ... # type: int
    JisB9 = ... # type: int
    JisB10 = ... # type: int
    AnsiC = ... # type: int
    AnsiD = ... # type: int
    AnsiE = ... # type: int
    LegalExtra = ... # type: int
    LetterExtra = ... # type: int
    LetterPlus = ... # type: int
    LetterSmall = ... # type: int
    TabloidExtra = ... # type: int
    ArchA = ... # type: int
    ArchB = ... # type: int
    ArchC = ... # type: int
    ArchD = ... # type: int
    ArchE = ... # type: int
    Imperial7x9 = ... # type: int
    Imperial8x10 = ... # type: int
    Imperial9x11 = ... # type: int
    Imperial9x12 = ... # type: int
    Imperial10x11 = ... # type: int
    Imperial10x13 = ... # type: int
    Imperial10x14 = ... # type: int
    Imperial12x11 = ... # type: int
    Imperial15x11 = ... # type: int
    ExecutiveStandard = ... # type: int
    Note = ... # type: int
    Quarto = ... # type: int
    Statement = ... # type: int
    SuperA = ... # type: int
    SuperB = ... # type: int
    Postcard = ... # type: int
    DoublePostcard = ... # type: int
    Prc16K = ... # type: int
    Prc32K = ... # type: int
    Prc32KBig = ... # type: int
    FanFoldUS = ... # type: int
    FanFoldGerman = ... # type: int
    FanFoldGermanLegal = ... # type: int
    EnvelopeB4 = ... # type: int
    EnvelopeB5 = ... # type: int
    EnvelopeB6 = ... # type: int
    EnvelopeC0 = ... # type: int
    EnvelopeC1 = ... # type: int
    EnvelopeC2 = ... # type: int
    EnvelopeC3 = ... # type: int
    EnvelopeC4 = ... # type: int
    EnvelopeC6 = ... # type: int
    EnvelopeC65 = ... # type: int
    EnvelopeC7 = ... # type: int
    Envelope9 = ... # type: int
    Envelope11 = ... # type: int
    Envelope12 = ... # type: int
    Envelope14 = ... # type: int
    EnvelopeMonarch = ... # type: int
    EnvelopePersonal = ... # type: int
    EnvelopeChou3 = ... # type: int
    EnvelopeChou4 = ... # type: int
    EnvelopeInvite = ... # type: int
    EnvelopeItalian = ... # type: int
    EnvelopeKaku2 = ... # type: int
    EnvelopeKaku3 = ... # type: int
    EnvelopePrc1 = ... # type: int
    EnvelopePrc2 = ... # type: int
    EnvelopePrc3 = ... # type: int
    EnvelopePrc4 = ... # type: int
    EnvelopePrc5 = ... # type: int
    EnvelopePrc6 = ... # type: int
    EnvelopePrc7 = ... # type: int
    EnvelopePrc8 = ... # type: int
    EnvelopePrc9 = ... # type: int
    EnvelopePrc10 = ... # type: int
    EnvelopeYou4 = ... # type: int
    NPageSize = ... # type: int
    NPaperSize = ... # type: int
    AnsiA = ... # type: int
    AnsiB = ... # type: int
    EnvelopeC5 = ... # type: int
    EnvelopeDL = ... # type: int
    Envelope10 = ... # type: int
    LastPageSize = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pageSizeId: int) -> None: ...
    @overload
    def __init__(self, pointSize: QtCore.QSize, name: str = ..., matchPolicy: int = ...) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSizeF, units: int, name: str = ..., matchPolicy: int = ...) -> None: ...
    @overload
    def __init__(self, other: QPageSize) -> None: ...

    def rectPixels(self, resolution: int) -> QtCore.QRect: ...
    def rectPoints(self) -> QtCore.QRect: ...
    def rect(self, units: int) -> QtCore.QRectF: ...
    @overload
    def sizePixels(self, resolution: int) -> QtCore.QSize: ...
    #@overload
    #@staticmethod
    #def sizePixels(pageSizeId: int, resolution: int) -> QtCore.QSize: ...
    @overload
    def sizePoints(self) -> QtCore.QSize: ...
    #@overload
    #@staticmethod
    #def sizePoints(pageSizeId: int) -> QtCore.QSize: ...
    @overload
    def size(self, units: int) -> QtCore.QSizeF: ...
    #@overload
    #@staticmethod
    #def size(pageSizeId: int, units: int) -> QtCore.QSizeF: ...
    @overload
    def definitionUnits(self) -> int: ...
    #@overload
    #@staticmethod
    #def definitionUnits(pageSizeId: int) -> int: ...
    @overload
    def definitionSize(self) -> QtCore.QSizeF: ...
    #@overload
    #@staticmethod
    #def definitionSize(pageSizeId: int) -> QtCore.QSizeF: ...
    @overload
    def windowsId(self) -> int: ...
    #@overload
    #@staticmethod
    #def windowsId(pageSizeId: int) -> int: ...
    @overload
    def id(self) -> int: ...
    #@overload
    #@staticmethod
    #def id(pointSize: QtCore.QSize, matchPolicy: int = ...) -> int: ...
    #@overload
    #@staticmethod
    #def id(size: QtCore.QSizeF, units: int, matchPolicy: int = ...) -> int: ...
    #@overload
    #@staticmethod
    #def id(windowsId: int) -> int: ...
    @overload
    def name(self) -> str: ...
    #@overload
    #@staticmethod
    #def name(pageSizeId: int) -> str: ...
    @overload
    def key(self) -> str: ...
    #@overload
    #@staticmethod
    #def key(pageSizeId: int) -> str: ...
    def isValid(self) -> bool: ...
    def isEquivalentTo(self, other: QPageSize) -> bool: ...
    def swap(self, other: QPageSize) -> None: ...


class QPainter(sip.simplewrapper):

    PixmapFragmentHint: typing.Type[int]
    #class PixmapFragmentHint(int): ...
    OpaqueHint = ... # type: int

    CompositionMode: typing.Type[int]
    #class CompositionMode(int): ...
    CompositionMode_SourceOver = ... # type: int
    CompositionMode_DestinationOver = ... # type: int
    CompositionMode_Clear = ... # type: int
    CompositionMode_Source = ... # type: int
    CompositionMode_Destination = ... # type: int
    CompositionMode_SourceIn = ... # type: int
    CompositionMode_DestinationIn = ... # type: int
    CompositionMode_SourceOut = ... # type: int
    CompositionMode_DestinationOut = ... # type: int
    CompositionMode_SourceAtop = ... # type: int
    CompositionMode_DestinationAtop = ... # type: int
    CompositionMode_Xor = ... # type: int
    CompositionMode_Plus = ... # type: int
    CompositionMode_Multiply = ... # type: int
    CompositionMode_Screen = ... # type: int
    CompositionMode_Overlay = ... # type: int
    CompositionMode_Darken = ... # type: int
    CompositionMode_Lighten = ... # type: int
    CompositionMode_ColorDodge = ... # type: int
    CompositionMode_ColorBurn = ... # type: int
    CompositionMode_HardLight = ... # type: int
    CompositionMode_SoftLight = ... # type: int
    CompositionMode_Difference = ... # type: int
    CompositionMode_Exclusion = ... # type: int
    RasterOp_SourceOrDestination = ... # type: int
    RasterOp_SourceAndDestination = ... # type: int
    RasterOp_SourceXorDestination = ... # type: int
    RasterOp_NotSourceAndNotDestination = ... # type: int
    RasterOp_NotSourceOrNotDestination = ... # type: int
    RasterOp_NotSourceXorDestination = ... # type: int
    RasterOp_NotSource = ... # type: int
    RasterOp_NotSourceAndDestination = ... # type: int
    RasterOp_SourceAndNotDestination = ... # type: int
    RasterOp_NotSourceOrDestination = ... # type: int
    RasterOp_SourceOrNotDestination = ... # type: int
    RasterOp_ClearDestination = ... # type: int
    RasterOp_SetDestination = ... # type: int
    RasterOp_NotDestination = ... # type: int

    RenderHint: typing.Type[int]
    #class RenderHint(int): ...
    Antialiasing = ... # type: int
    TextAntialiasing = ... # type: int
    SmoothPixmapTransform = ... # type: int
    HighQualityAntialiasing = ... # type: int
    NonCosmeticDefaultPen = ... # type: int
    Qt4CompatiblePainting = ... # type: int

    RenderHints: typing.Type[int]
    #class RenderHints(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QPainter.RenderHints, QPainter.RenderHint]) -> None: ...
        #@overload
        #def __init__(self, a0: QPainter.RenderHints) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QPainter.RenderHints: ...
        #def __int__(self) -> int: ...

    class PixmapFragment:

        height = ... # type: float
        opacity = ... # type: float
        rotation = ... # type: float
        scaleX = ... # type: float
        scaleY = ... # type: float
        sourceLeft = ... # type: float
        sourceTop = ... # type: float
        width = ... # type: float
        x = ... # type: float
        y = ... # type: float

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QPainter.PixmapFragment) -> None: ...

        @staticmethod
        def create(pos: typing.Union[QtCore.QPointF, QtCore.QPoint], sourceRect: QtCore.QRectF, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> QPainter.PixmapFragment: ...

    PixmapFragmentHints: typing.Type[int]
    #class PixmapFragmentHints(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QPainter.PixmapFragmentHints, QPainter.PixmapFragmentHint]) -> None: ...
        #@overload
        #def __init__(self, a0: QPainter.PixmapFragmentHints) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QPainter.PixmapFragmentHints: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QPaintDevice) -> None: ...

    def drawGlyphRun(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], glyphRun: QGlyphRun) -> None: ...
    def clipBoundingRect(self) -> QtCore.QRectF: ...
    @overload
    def drawStaticText(self, topLeftPosition: typing.Union[QtCore.QPointF, QtCore.QPoint], staticText: QStaticText) -> None: ...
    @overload
    def drawStaticText(self, p: QtCore.QPoint, staticText: QStaticText) -> None: ...
    @overload
    def drawStaticText(self, x: int, y: int, staticText: QStaticText) -> None: ...
    def drawPixmapFragments(self, fragments: typing.List[QPainter.PixmapFragment], pixmap: QPixmap, hints: int = ...) -> None: ...
    def endNativePainting(self) -> None: ...
    def beginNativePainting(self) -> None: ...
    @overload
    def drawRoundedRect(self, rect: QtCore.QRectF, xRadius: float, yRadius: float, mode: int = ...) -> None: ...
    @overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: int = ...) -> None: ...
    @overload
    def drawRoundedRect(self, rect: QtCore.QRect, xRadius: float, yRadius: float, mode: int = ...) -> None: ...
    def testRenderHint(self, hint: int) -> bool: ...
    def combinedTransform(self) -> QTransform: ...
    def worldTransform(self) -> QTransform: ...
    def setWorldTransform(self, matrix: QTransform, combine: bool = ...) -> None: ...
    def resetTransform(self) -> None: ...
    def deviceTransform(self) -> QTransform: ...
    def transform(self) -> QTransform: ...
    def setTransform(self, transform: QTransform, combine: bool = ...) -> None: ...
    def setWorldMatrixEnabled(self, enabled: bool) -> None: ...
    def worldMatrixEnabled(self) -> bool: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...
    @overload
    def drawImage(self, targetRect: QtCore.QRectF, image: QImage, sourceRect: QtCore.QRectF, flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def drawImage(self, targetRect: QtCore.QRect, image: QImage, sourceRect: QtCore.QRect, flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def drawImage(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], image: QImage, sr: QtCore.QRectF, flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def drawImage(self, p: QtCore.QPoint, image: QImage, sr: QtCore.QRect, flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def drawImage(self, r: QtCore.QRectF, image: QImage) -> None: ...
    @overload
    def drawImage(self, r: QtCore.QRect, image: QImage) -> None: ...
    @overload
    def drawImage(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], image: QImage) -> None: ...
    @overload
    def drawImage(self, p: QtCore.QPoint, image: QImage) -> None: ...
    @overload
    def drawImage(self, x: int, y: int, image: QImage, sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: typing.Union[int, int] = ...) -> None: ...
    @overload
    def drawPoint(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def drawPoint(self, x: int, y: int) -> None: ...
    @overload
    def drawPoint(self, p: QtCore.QPoint) -> None: ...
    @overload
    def drawRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def drawRect(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def drawRect(self, r: QtCore.QRect) -> None: ...
    @overload
    def drawLine(self, l: QtCore.QLineF) -> None: ...
    @overload
    def drawLine(self, line: QtCore.QLine) -> None: ...
    @overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @overload
    def drawLine(self, p1: QtCore.QPoint, p2: QtCore.QPoint) -> None: ...
    @overload
    def drawLine(self, p1: typing.Union[QtCore.QPointF, QtCore.QPoint], p2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def paintEngine(self) -> QPaintEngine: ...
    def setRenderHints(self, hints: typing.Union[int, int], on: bool = ...) -> None: ...
    def renderHints(self) -> int: ...
    def setRenderHint(self, hint: int, on: bool = ...) -> None: ...
    @overload
    def eraseRect(self, a0: QtCore.QRectF) -> None: ...
    @overload
    def eraseRect(self, rect: QtCore.QRect) -> None: ...
    @overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def fillRect(self, a0: QtCore.QRectF, a1: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, a0: QtCore.QRect, a1: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, b: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, a0: QtCore.QRectF, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, a0: QtCore.QRect, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, b: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRect, c: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRectF, c: int) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRect, style: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRectF, style: int) -> None: ...
    @overload
    def fillRect(self, x: int, y: int, w: int, h: int, preset: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRect, preset: int) -> None: ...
    @overload
    def fillRect(self, r: QtCore.QRectF, preset: int) -> None: ...
    @overload
    def boundingRect(self, rect: QtCore.QRectF, flags: int, text: str) -> QtCore.QRectF: ...
    @overload
    def boundingRect(self, rect: QtCore.QRect, flags: int, text: str) -> QtCore.QRect: ...
    @overload
    def boundingRect(self, rectangle: QtCore.QRectF, text: str, option: QTextOption = ...) -> QtCore.QRectF: ...
    @overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> QtCore.QRect: ...
    @overload
    def drawText(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], s: str) -> None: ...
    @overload
    def drawText(self, rectangle: QtCore.QRectF, flags: int, text: str) -> QtCore.QRectF: ...
    @overload
    def drawText(self, rectangle: QtCore.QRect, flags: int, text: str) -> QtCore.QRect: ...
    @overload
    def drawText(self, rectangle: QtCore.QRectF, text: str, option: QTextOption = ...) -> None: ...
    @overload
    def drawText(self, p: QtCore.QPoint, s: str) -> None: ...
    @overload
    def drawText(self, x: int, y: int, width: int, height: int, flags: int, text: str) -> QtCore.QRect: ...
    @overload
    def drawText(self, x: int, y: int, s: str) -> None: ...
    def layoutDirection(self) -> int: ...
    def setLayoutDirection(self, direction: int) -> None: ...
    @overload
    def drawPixmap(self, targetRect: QtCore.QRectF, pixmap: QPixmap, sourceRect: QtCore.QRectF) -> None: ...
    @overload
    def drawPixmap(self, targetRect: QtCore.QRect, pixmap: QPixmap, sourceRect: QtCore.QRect) -> None: ...
    @overload
    def drawPixmap(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, r: QtCore.QRect, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @overload
    def drawPixmap(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], pm: QPixmap, sr: QtCore.QRectF) -> None: ...
    @overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap, sr: QtCore.QRect) -> None: ...
    @overload
    def drawPicture(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], picture: QPicture) -> None: ...
    @overload
    def drawPicture(self, x: int, y: int, p: QPicture) -> None: ...
    @overload
    def drawPicture(self, pt: QtCore.QPoint, p: QPicture) -> None: ...
    @overload
    def drawTiledPixmap(self, rectangle: QtCore.QRectF, pixmap: QPixmap, pos: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, rectangle: QtCore.QRect, pixmap: QPixmap, pos: QtCore.QPoint = ...) -> None: ...
    @overload
    def drawTiledPixmap(self, x: int, y: int, width: int, height: int, pixmap: QPixmap, sx: int = ..., sy: int = ...) -> None: ...
    @overload
    def drawChord(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, rect: QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, rect: QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, r: QtCore.QRect, a: int, alen: int) -> None: ...
    @overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @overload
    def drawConvexPolygon(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @overload
    def drawConvexPolygon(self, poly: QPolygonF) -> None: ...
    @overload
    def drawConvexPolygon(self, point: QtCore.QPoint, *a1) -> None: ...
    @overload
    def drawConvexPolygon(self, poly: QPolygon) -> None: ...
    @overload
    def drawPolygon(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @overload
    def drawPolygon(self, points: QPolygonF, fillRule: int = ...) -> None: ...
    @overload
    def drawPolygon(self, point: QtCore.QPoint, *a1) -> None: ...
    @overload
    def drawPolygon(self, points: QPolygon, fillRule: int = ...) -> None: ...
    @overload
    def drawPolyline(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @overload
    def drawPolyline(self, polyline: QPolygonF) -> None: ...
    @overload
    def drawPolyline(self, point: QtCore.QPoint, *a1) -> None: ...
    @overload
    def drawPolyline(self, polyline: QPolygon) -> None: ...
    @overload
    def drawEllipse(self, r: QtCore.QRectF) -> None: ...
    @overload
    def drawEllipse(self, r: QtCore.QRect) -> None: ...
    @overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def drawEllipse(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], rx: float, ry: float) -> None: ...
    @overload
    def drawEllipse(self, center: QtCore.QPoint, rx: int, ry: int) -> None: ...
    @overload
    def drawRects(self, rect: QtCore.QRectF, *a1) -> None: ...
    @overload
    def drawRects(self, rects: typing.Iterable[QtCore.QRectF]) -> None: ...
    @overload
    def drawRects(self, rect: QtCore.QRect, *a1) -> None: ...
    @overload
    def drawRects(self, rects: typing.Iterable[QtCore.QRect]) -> None: ...
    @overload
    def drawLines(self, line: QtCore.QLineF, *a1) -> None: ...
    @overload
    def drawLines(self, lines: typing.Iterable[QtCore.QLineF]) -> None: ...
    @overload
    def drawLines(self, pointPair: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @overload
    def drawLines(self, pointPairs: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @overload
    def drawLines(self, line: QtCore.QLine, *a1) -> None: ...
    @overload
    def drawLines(self, lines: typing.Iterable[QtCore.QLine]) -> None: ...
    @overload
    def drawLines(self, pointPair: QtCore.QPoint, *a1) -> None: ...
    @overload
    def drawLines(self, pointPairs: typing.Iterable[QtCore.QPoint]) -> None: ...
    @overload
    def drawPoints(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @overload
    def drawPoints(self, points: QPolygonF) -> None: ...
    @overload
    def drawPoints(self, point: QtCore.QPoint, *a1) -> None: ...
    @overload
    def drawPoints(self, points: QPolygon) -> None: ...
    def drawPath(self, path: QPainterPath) -> None: ...
    def fillPath(self, path: QPainterPath, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def strokePath(self, path: QPainterPath, pen: typing.Union[QPen, QColor, int, QGradient]) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def setViewTransformEnabled(self, enable: bool) -> None: ...
    @overload
    def setViewport(self, viewport: QtCore.QRect) -> None: ...
    @overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None: ...
    def viewport(self) -> QtCore.QRect: ...
    @overload
    def setWindow(self, window: QtCore.QRect) -> None: ...
    @overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None: ...
    def window(self) -> QtCore.QRect: ...
    @overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: QtCore.QPoint) -> None: ...
    def rotate(self, a: float) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def restore(self) -> None: ...
    def save(self) -> None: ...
    def hasClipping(self) -> bool: ...
    def setClipping(self, enable: bool) -> None: ...
    def setClipPath(self, path: QPainterPath, operation: int = ...) -> None: ...
    def setClipRegion(self, region: QRegion, operation: int = ...) -> None: ...
    @overload
    def setClipRect(self, rectangle: QtCore.QRectF, operation: int = ...) -> None: ...
    @overload
    def setClipRect(self, x: int, y: int, width: int, height: int, operation: int = ...) -> None: ...
    @overload
    def setClipRect(self, rectangle: QtCore.QRect, operation: int = ...) -> None: ...
    def clipPath(self) -> QPainterPath: ...
    def clipRegion(self) -> QRegion: ...
    def background(self) -> QBrush: ...
    def setBackground(self, bg: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def setBrushOrigin(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setBrushOrigin(self, x: int, y: int) -> None: ...
    @overload
    def setBrushOrigin(self, p: QtCore.QPoint) -> None: ...
    def brushOrigin(self) -> QtCore.QPoint: ...
    def backgroundMode(self) -> int: ...
    def setBackgroundMode(self, mode: int) -> None: ...
    def brush(self) -> QBrush: ...
    @overload
    def setBrush(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def setBrush(self, style: int) -> None: ...
    def pen(self) -> QPen: ...
    @overload
    def setPen(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setPen(self, pen: typing.Union[QPen, QColor, int, QGradient]) -> None: ...
    @overload
    def setPen(self, style: int) -> None: ...
    def fontInfo(self) -> QFontInfo: ...
    def fontMetrics(self) -> QFontMetrics: ...
    def setFont(self, f: QFont) -> None: ...
    def font(self) -> QFont: ...
    def compositionMode(self) -> int: ...
    def setCompositionMode(self, mode: int) -> None: ...
    def isActive(self) -> bool: ...
    def end(self) -> bool: ...
    def begin(self, a0: QPaintDevice) -> bool: ...
    def device(self) -> QPaintDevice: ...
    def __exit__(self, type: typing.Any, value: typing.Any, traceback: typing.Any) -> None: ...
    def __enter__(self) -> typing.Any: ...


class QTextItem(sip.simplewrapper):

    RenderFlag: typing.Type[int]
    #class RenderFlag(int): ...
    RightToLeft = ... # type: int
    Overline = ... # type: int
    Underline = ... # type: int
    StrikeOut = ... # type: int

    RenderFlags: typing.Type[int]
    #class RenderFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTextItem.RenderFlags, QTextItem.RenderFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTextItem.RenderFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTextItem.RenderFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextItem) -> None: ...

    def font(self) -> QFont: ...
    def text(self) -> str: ...
    def renderFlags(self) -> int: ...
    def width(self) -> float: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...


class QPaintEngine(sip.simplewrapper):

    Type: typing.Type[int]
    #class Type(int): ...
    X11 = ... # type: int
    Windows = ... # type: int
    QuickDraw = ... # type: int
    CoreGraphics = ... # type: int
    MacPrinter = ... # type: int
    QWindowSystem = ... # type: int
    PostScript = ... # type: int
    OpenGL = ... # type: int
    Picture = ... # type: int
    SVG = ... # type: int
    Raster = ... # type: int
    Direct3D = ... # type: int
    Pdf = ... # type: int
    OpenVG = ... # type: int
    OpenGL2 = ... # type: int
    PaintBuffer = ... # type: int
    Blitter = ... # type: int
    Direct2D = ... # type: int
    User = ... # type: int
    MaxUser = ... # type: int

    PolygonDrawMode: typing.Type[int]
    #class PolygonDrawMode(int): ...
    OddEvenMode = ... # type: int
    WindingMode = ... # type: int
    ConvexMode = ... # type: int
    PolylineMode = ... # type: int

    DirtyFlag: typing.Type[int]
    #class DirtyFlag(int): ...
    DirtyPen = ... # type: int
    DirtyBrush = ... # type: int
    DirtyBrushOrigin = ... # type: int
    DirtyFont = ... # type: int
    DirtyBackground = ... # type: int
    DirtyBackgroundMode = ... # type: int
    DirtyTransform = ... # type: int
    DirtyClipRegion = ... # type: int
    DirtyClipPath = ... # type: int
    DirtyHints = ... # type: int
    DirtyCompositionMode = ... # type: int
    DirtyClipEnabled = ... # type: int
    DirtyOpacity = ... # type: int
    AllDirty = ... # type: int

    PaintEngineFeature: typing.Type[int]
    #class PaintEngineFeature(int): ...
    PrimitiveTransform = ... # type: int
    PatternTransform = ... # type: int
    PixmapTransform = ... # type: int
    PatternBrush = ... # type: int
    LinearGradientFill = ... # type: int
    RadialGradientFill = ... # type: int
    ConicalGradientFill = ... # type: int
    AlphaBlend = ... # type: int
    PorterDuff = ... # type: int
    PainterPaths = ... # type: int
    Antialiasing = ... # type: int
    BrushStroke = ... # type: int
    ConstantOpacity = ... # type: int
    MaskedBrush = ... # type: int
    PaintOutsidePaintEvent = ... # type: int
    PerspectiveTransform = ... # type: int
    BlendModes = ... # type: int
    ObjectBoundingModeGradients = ... # type: int
    RasterOpModes = ... # type: int
    AllFeatures = ... # type: int

    PaintEngineFeatures: typing.Type[int]
    #class PaintEngineFeatures(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QPaintEngine.PaintEngineFeatures, QPaintEngine.PaintEngineFeature]) -> None: ...
        #@overload
        #def __init__(self, a0: QPaintEngine.PaintEngineFeatures) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QPaintEngine.PaintEngineFeatures: ...
        #def __int__(self) -> int: ...

    DirtyFlags: typing.Type[int]
    #class DirtyFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QPaintEngine.DirtyFlags, QPaintEngine.DirtyFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QPaintEngine.DirtyFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QPaintEngine.DirtyFlags: ...
        #def __int__(self) -> int: ...

    def __init__(self, features: typing.Union[int, int] = ...) -> None: ...

    def hasFeature(self, feature: typing.Union[int, int]) -> bool: ...
    def painter(self) -> QPainter: ...
    def type(self) -> int: ...
    def paintDevice(self) -> QPaintDevice: ...
    def setPaintDevice(self, device: QPaintDevice) -> None: ...
    def drawImage(self, r: QtCore.QRectF, pm: QImage, sr: QtCore.QRectF, flags: typing.Union[int, int] = ...) -> None: ...
    def drawTiledPixmap(self, r: QtCore.QRectF, pixmap: QPixmap, s: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def drawTextItem(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], textItem: QTextItem) -> None: ...
    def drawPixmap(self, r: QtCore.QRectF, pm: QPixmap, sr: QtCore.QRectF) -> None: ...
    @overload
    def drawPolygon(self, points: typing.Union[QtCore.QPointF, QtCore.QPoint], mode: int) -> None: ...
    @overload
    def drawPolygon(self, points: QtCore.QPoint, mode: int) -> None: ...
    @overload
    def drawPoints(self, points: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def drawPoints(self, points: QtCore.QPoint) -> None: ...
    def drawPath(self, path: QPainterPath) -> None: ...
    @overload
    def drawEllipse(self, r: QtCore.QRectF) -> None: ...
    @overload
    def drawEllipse(self, r: QtCore.QRect) -> None: ...
    @overload
    def drawLines(self, lines: QtCore.QLine) -> None: ...
    @overload
    def drawLines(self, lines: QtCore.QLineF) -> None: ...
    @overload
    def drawRects(self, rects: QtCore.QRect) -> None: ...
    @overload
    def drawRects(self, rects: QtCore.QRectF) -> None: ...
    def updateState(self, state: QPaintEngineState) -> None: ...
    def end(self) -> bool: ...
    def begin(self, pdev: QPaintDevice) -> bool: ...
    def setActive(self, newState: bool) -> None: ...
    def isActive(self) -> bool: ...


class QPaintEngineState(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QPaintEngineState) -> None: ...

    def penNeedsResolving(self) -> bool: ...
    def brushNeedsResolving(self) -> bool: ...
    def transform(self) -> QTransform: ...
    def painter(self) -> QPainter: ...
    def compositionMode(self) -> int: ...
    def renderHints(self) -> int: ...
    def isClipEnabled(self) -> bool: ...
    def clipPath(self) -> QPainterPath: ...
    def clipRegion(self) -> QRegion: ...
    def clipOperation(self) -> int: ...
    def opacity(self) -> float: ...
    def font(self) -> QFont: ...
    def backgroundMode(self) -> int: ...
    def backgroundBrush(self) -> QBrush: ...
    def brushOrigin(self) -> QtCore.QPointF: ...
    def brush(self) -> QBrush: ...
    def pen(self) -> QPen: ...
    def state(self) -> int: ...


class QPainterPath(sip.simplewrapper):

    ElementType: typing.Type[int]
    #class ElementType(int): ...
    MoveToElement = ... # type: int
    LineToElement = ... # type: int
    CurveToElement = ... # type: int
    CurveToDataElement = ... # type: int

    class Element:

        type = ... # type: int
        x = ... # type: float
        y = ... # type: float

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QPainterPath.Element) -> None: ...

        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, startPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, other: QPainterPath) -> None: ...

    def swap(self, other: QPainterPath) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> QPainterPath: ...
    @overload
    def translated(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QPainterPath: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def simplified(self) -> QPainterPath: ...
    @overload
    def addRoundedRect(self, rect: QtCore.QRectF, xRadius: float, yRadius: float, mode: int = ...) -> None: ...
    @overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: int = ...) -> None: ...
    def subtracted(self, r: QPainterPath) -> QPainterPath: ...
    def intersected(self, r: QPainterPath) -> QPainterPath: ...
    def united(self, r: QPainterPath) -> QPainterPath: ...
    def slopeAtPercent(self, t: float) -> float: ...
    def angleAtPercent(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> QtCore.QPointF: ...
    def percentAtLength(self, t: float) -> float: ...
    def length(self) -> float: ...
    def setElementPositionAt(self, i: int, x: float, y: float) -> None: ...
    def elementAt(self, i: int) -> QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def arcMoveTo(self, rect: QtCore.QRectF, angle: float) -> None: ...
    @overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None: ...
    @overload
    def toFillPolygon(self) -> QPolygonF: ...
    @overload
    def toFillPolygon(self, matrix: QTransform) -> QPolygonF: ...
    @overload
    def toFillPolygons(self) -> typing.List[QPolygonF]: ...
    @overload
    def toFillPolygons(self, matrix: QTransform) -> typing.List[QPolygonF]: ...
    @overload
    def toSubpathPolygons(self) -> typing.List[QPolygonF]: ...
    @overload
    def toSubpathPolygons(self, matrix: QTransform) -> typing.List[QPolygonF]: ...
    def toReversed(self) -> QPainterPath: ...
    def setFillRule(self, fillRule: int) -> None: ...
    def fillRule(self) -> int: ...
    def controlPointRect(self) -> QtCore.QRectF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @overload
    def intersects(self, rect: QtCore.QRectF) -> bool: ...
    @overload
    def intersects(self, p: QPainterPath) -> bool: ...
    @overload
    def contains(self, pt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @overload
    def contains(self, rect: QtCore.QRectF) -> bool: ...
    @overload
    def contains(self, p: QPainterPath) -> bool: ...
    def connectPath(self, path: QPainterPath) -> None: ...
    def addRegion(self, region: QRegion) -> None: ...
    def addPath(self, path: QPainterPath) -> None: ...
    @overload
    def addText(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], f: QFont, text: str) -> None: ...
    @overload
    def addText(self, x: float, y: float, f: QFont, text: str) -> None: ...
    def addPolygon(self, polygon: QPolygonF) -> None: ...
    @overload
    def addEllipse(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def addEllipse(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], rx: float, ry: float) -> None: ...
    @overload
    def addRect(self, rect: QtCore.QRectF) -> None: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def currentPosition(self) -> QtCore.QPointF: ...
    @overload
    def quadTo(self, ctrlPt: typing.Union[QtCore.QPointF, QtCore.QPoint], endPt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float) -> None: ...
    @overload
    def cubicTo(self, ctrlPt1: typing.Union[QtCore.QPointF, QtCore.QPoint], ctrlPt2: typing.Union[QtCore.QPointF, QtCore.QPoint], endPt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float) -> None: ...
    @overload
    def arcTo(self, rect: QtCore.QRectF, startAngle: float, arcLength: float) -> None: ...
    @overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLenght: float) -> None: ...
    @overload
    def lineTo(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def lineTo(self, x: float, y: float) -> None: ...
    @overload
    def moveTo(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def moveTo(self, x: float, y: float) -> None: ...
    def closeSubpath(self) -> None: ...


class QPainterPathStroker(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pen: typing.Union[QPen, QColor, int, QGradient]) -> None: ...

    def dashOffset(self) -> float: ...
    def setDashOffset(self, offset: float) -> None: ...
    def createStroke(self, path: QPainterPath) -> QPainterPath: ...
    def dashPattern(self) -> typing.List[float]: ...
    @overload
    def setDashPattern(self, a0: int) -> None: ...
    @overload
    def setDashPattern(self, dashPattern: typing.Iterable[float]) -> None: ...
    def curveThreshold(self) -> float: ...
    def setCurveThreshold(self, threshold: float) -> None: ...
    def miterLimit(self) -> float: ...
    def setMiterLimit(self, length: float) -> None: ...
    def joinStyle(self) -> int: ...
    def setJoinStyle(self, style: int) -> None: ...
    def capStyle(self) -> int: ...
    def setCapStyle(self, style: int) -> None: ...
    def width(self) -> float: ...
    def setWidth(self, width: float) -> None: ...


class QPalette(sip.simplewrapper):

    ColorRole: typing.Type[int]
    #class ColorRole(int): ...
    WindowText = ... # type: int
    Foreground = ... # type: int
    Button = ... # type: int
    Light = ... # type: int
    Midlight = ... # type: int
    Dark = ... # type: int
    Mid = ... # type: int
    Text = ... # type: int
    BrightText = ... # type: int
    ButtonText = ... # type: int
    Base = ... # type: int
    Window = ... # type: int
    Background = ... # type: int
    Shadow = ... # type: int
    Highlight = ... # type: int
    HighlightedText = ... # type: int
    Link = ... # type: int
    LinkVisited = ... # type: int
    AlternateBase = ... # type: int
    ToolTipBase = ... # type: int
    ToolTipText = ... # type: int
    PlaceholderText = ... # type: int
    NoRole = ... # type: int
    NColorRoles = ... # type: int

    ColorGroup: typing.Type[int]
    #class ColorGroup(int): ...
    Active = ... # type: int
    Disabled = ... # type: int
    Inactive = ... # type: int
    NColorGroups = ... # type: int
    Current = ... # type: int
    All = ... # type: int
    Normal = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, button: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def __init__(self, button: int) -> None: ...
    @overload
    def __init__(self, button: typing.Union[QColor, int, QGradient], background: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def __init__(self, foreground: typing.Union[QBrush, QColor, int, QGradient], button: typing.Union[QBrush, QColor, int, QGradient], light: typing.Union[QBrush, QColor, int, QGradient], dark: typing.Union[QBrush, QColor, int, QGradient], mid: typing.Union[QBrush, QColor, int, QGradient], text: typing.Union[QBrush, QColor, int, QGradient], bright_text: typing.Union[QBrush, QColor, int, QGradient], base: typing.Union[QBrush, QColor, int, QGradient], background: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def __init__(self, palette: QPalette) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: QPalette) -> None: ...
    def cacheKey(self) -> int: ...
    def isBrushSet(self, cg: int, cr: int) -> bool: ...
    @overload
    def setColor(self, acg: int, acr: int, acolor: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setColor(self, acr: int, acolor: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def resolve(self, a0: QPalette) -> QPalette: ...
    @overload
    def resolve(self) -> int: ...
    @overload
    def resolve(self, mask: int) -> None: ...
    def isCopyOf(self, p: QPalette) -> bool: ...
    def placeholderText(self) -> QBrush: ...
    def toolTipText(self) -> QBrush: ...
    def toolTipBase(self) -> QBrush: ...
    def linkVisited(self) -> QBrush: ...
    def link(self) -> QBrush: ...
    def highlightedText(self) -> QBrush: ...
    def highlight(self) -> QBrush: ...
    def shadow(self) -> QBrush: ...
    def buttonText(self) -> QBrush: ...
    def brightText(self) -> QBrush: ...
    def midlight(self) -> QBrush: ...
    def window(self) -> QBrush: ...
    def alternateBase(self) -> QBrush: ...
    def base(self) -> QBrush: ...
    def text(self) -> QBrush: ...
    def mid(self) -> QBrush: ...
    def dark(self) -> QBrush: ...
    def light(self) -> QBrush: ...
    def button(self) -> QBrush: ...
    def windowText(self) -> QBrush: ...
    def isEqual(self, cr1: int, cr2: int) -> bool: ...
    def setColorGroup(self, cr: int, foreground: typing.Union[QBrush, QColor, int, QGradient], button: typing.Union[QBrush, QColor, int, QGradient], light: typing.Union[QBrush, QColor, int, QGradient], dark: typing.Union[QBrush, QColor, int, QGradient], mid: typing.Union[QBrush, QColor, int, QGradient], text: typing.Union[QBrush, QColor, int, QGradient], bright_text: typing.Union[QBrush, QColor, int, QGradient], base: typing.Union[QBrush, QColor, int, QGradient], background: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def setBrush(self, cg: int, cr: int, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def setBrush(self, acr: int, abrush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    @overload
    def brush(self, cg: int, cr: int) -> QBrush: ...
    @overload
    def brush(self, cr: int) -> QBrush: ...
    @overload
    def color(self, cg: int, cr: int) -> QColor: ...
    @overload
    def color(self, cr: int) -> QColor: ...
    def setCurrentColorGroup(self, cg: int) -> None: ...
    def currentColorGroup(self) -> int: ...


class QPdfWriter(QtCore.QObject, QPagedPaintDevice):

    @overload
    def __init__(self, filename: str, **props) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, **props) -> None: ...

    def pdfVersion(self) -> int: ...
    def setPdfVersion(self, version: int) -> None: ...
    def resolution(self) -> int: ...
    def setResolution(self, resolution: int) -> None: ...
    def metric(self, id: int) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def setMargins(self, m: QPagedPaintDevice.Margins) -> None: ...
    def setPageSizeMM(self, size: QtCore.QSizeF) -> None: ...
    def setPageSize(self, size: int) -> None: ...
    def newPage(self) -> bool: ...
    def setCreator(self, creator: str) -> None: ...
    def creator(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...


class QPen(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: int) -> None: ...
    @overload
    def __init__(self, brush: typing.Union[QBrush, QColor, int, QGradient], width: float, style: int = ..., cap: int = ..., join: int = ...) -> None: ...
    @overload
    def __init__(self, pen: typing.Union[QPen, QColor, int, QGradient]) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: QPen) -> None: ...
    def setCosmetic(self, cosmetic: bool) -> None: ...
    def isCosmetic(self) -> bool: ...
    def setDashOffset(self, doffset: float) -> None: ...
    def dashOffset(self) -> float: ...
    def setMiterLimit(self, limit: float) -> None: ...
    def miterLimit(self) -> float: ...
    def setDashPattern(self, pattern: typing.Iterable[float]) -> None: ...
    def dashPattern(self) -> typing.List[float]: ...
    def setJoinStyle(self, pcs: int) -> None: ...
    def joinStyle(self) -> int: ...
    def setCapStyle(self, pcs: int) -> None: ...
    def capStyle(self) -> int: ...
    def isSolid(self) -> bool: ...
    def setBrush(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def brush(self) -> QBrush: ...
    def setColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def color(self) -> QColor: ...
    def setWidth(self, width: int) -> None: ...
    def width(self) -> int: ...
    def setWidthF(self, width: float) -> None: ...
    def widthF(self) -> float: ...
    def setStyle(self, a0: int) -> None: ...
    def style(self) -> int: ...


class QPicture(QPaintDevice):

    @overload
    def __init__(self, formatVersion: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QPicture) -> None: ...

    def swap(self, other: QPicture) -> None: ...
    def metric(self, m: int) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    def isDetached(self) -> bool: ...
    def detach(self) -> None: ...
    def setBoundingRect(self, r: QtCore.QRect) -> None: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @overload
    def save(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def save(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def load(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def play(self, p: QPainter) -> bool: ...
    def setData(self, data: bytes) -> None: ...
    def data(self) -> str: ...
    def size(self) -> int: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QPictureIO(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, ioDevice: QtCore.QIODevice, format: str) -> None: ...
    @overload
    def __init__(self, fileName: str, format: str) -> None: ...

    @staticmethod
    def defineIOHandler(format: str, header: str, flags: str, read_picture: typing.Optional[typing.Callable[[QPictureIO], None]], write_picture: typing.Optional[typing.Callable[[QPictureIO], None]]) -> None: ...
    @staticmethod
    def outputFormats() -> typing.List[QtCore.QByteArray]: ...
    @staticmethod
    def inputFormats() -> typing.List[QtCore.QByteArray]: ...
    @overload
    @staticmethod
    def pictureFormat(fileName: str) -> QtCore.QByteArray: ...
    @overload
    @staticmethod
    def pictureFormat(a0: QtCore.QIODevice) -> QtCore.QByteArray: ...
    def write(self) -> bool: ...
    def read(self) -> bool: ...
    def setGamma(self, a0: float) -> None: ...
    def setParameters(self, a0: str) -> None: ...
    def setDescription(self, a0: str) -> None: ...
    def setQuality(self, a0: int) -> None: ...
    def setFileName(self, a0: str) -> None: ...
    def setIODevice(self, a0: QtCore.QIODevice) -> None: ...
    def setFormat(self, a0: str) -> None: ...
    def setStatus(self, a0: int) -> None: ...
    def setPicture(self, a0: QPicture) -> None: ...
    def gamma(self) -> float: ...
    def parameters(self) -> str: ...
    def description(self) -> str: ...
    def quality(self) -> int: ...
    def fileName(self) -> str: ...
    def ioDevice(self) -> QtCore.QIODevice: ...
    def format(self) -> str: ...
    def status(self) -> int: ...
    def picture(self) -> QPicture: ...


class QPixelFormat(sip.simplewrapper):

    ByteOrder: typing.Type[int]
    #class ByteOrder(int): ...
    LittleEndian = ... # type: int
    BigEndian = ... # type: int
    CurrentSystemEndian = ... # type: int

    YUVLayout: typing.Type[int]
    #class YUVLayout(int): ...
    YUV444 = ... # type: int
    YUV422 = ... # type: int
    YUV411 = ... # type: int
    YUV420P = ... # type: int
    YUV420SP = ... # type: int
    YV12 = ... # type: int
    UYVY = ... # type: int
    YUYV = ... # type: int
    NV12 = ... # type: int
    NV21 = ... # type: int
    IMC1 = ... # type: int
    IMC2 = ... # type: int
    IMC3 = ... # type: int
    IMC4 = ... # type: int
    Y8 = ... # type: int
    Y16 = ... # type: int

    TypeInterpretation: typing.Type[int]
    #class TypeInterpretation(int): ...
    UnsignedInteger = ... # type: int
    UnsignedShort = ... # type: int
    UnsignedByte = ... # type: int
    FloatingPoint = ... # type: int

    AlphaPremultiplied: typing.Type[int]
    #class AlphaPremultiplied(int): ...
    NotPremultiplied = ... # type: int
    Premultiplied = ... # type: int

    AlphaPosition: typing.Type[int]
    #class AlphaPosition(int): ...
    AtBeginning = ... # type: int
    AtEnd = ... # type: int

    AlphaUsage: typing.Type[int]
    #class AlphaUsage(int): ...
    UsesAlpha = ... # type: int
    IgnoresAlpha = ... # type: int

    ColorModel: typing.Type[int]
    #class ColorModel(int): ...
    RGB = ... # type: int
    BGR = ... # type: int
    Indexed = ... # type: int
    Grayscale = ... # type: int
    CMYK = ... # type: int
    HSL = ... # type: int
    HSV = ... # type: int
    YUV = ... # type: int
    Alpha = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, mdl: int, firstSize: int, secondSize: int, thirdSize: int, fourthSize: int, fifthSize: int, alfa: int, usage: int, position: int, premult: int, typeInterp: int, byteOrder: int = ..., subEnum: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QPixelFormat) -> None: ...

    def subEnum(self) -> int: ...
    def yuvLayout(self) -> int: ...
    def byteOrder(self) -> int: ...
    def typeInterpretation(self) -> int: ...
    def premultiplied(self) -> int: ...
    def alphaPosition(self) -> int: ...
    def alphaUsage(self) -> int: ...
    def bitsPerPixel(self) -> int: ...
    def alphaSize(self) -> int: ...
    def brightnessSize(self) -> int: ...
    def lightnessSize(self) -> int: ...
    def saturationSize(self) -> int: ...
    def hueSize(self) -> int: ...
    def blackSize(self) -> int: ...
    def yellowSize(self) -> int: ...
    def magentaSize(self) -> int: ...
    def cyanSize(self) -> int: ...
    def blueSize(self) -> int: ...
    def greenSize(self) -> int: ...
    def redSize(self) -> int: ...
    def channelCount(self) -> int: ...
    def colorModel(self) -> int: ...


class QPixmapCache(sip.simplewrapper):

    class Key:

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, other: QPixmapCache.Key) -> None: ...

        def isValid(self) -> bool: ...
        def swap(self, other: QPixmapCache.Key) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QPixmapCache) -> None: ...

    @staticmethod
    def setCacheLimit(a0: int) -> None: ...
    @staticmethod
    def replace(key: QPixmapCache.Key, pixmap: QPixmap) -> bool: ...
    @overload
    @staticmethod
    def remove(key: str) -> None: ...
    @overload
    @staticmethod
    def remove(key: QPixmapCache.Key) -> None: ...
    @overload
    @staticmethod
    def insert(key: str, a1: QPixmap) -> bool: ...
    @overload
    @staticmethod
    def insert(pixmap: QPixmap) -> QPixmapCache.Key: ...
    @overload
    @staticmethod
    def find(key: str) -> QPixmap: ...
    @overload
    @staticmethod
    def find(key: QPixmapCache.Key) -> QPixmap: ...
    @staticmethod
    def clear() -> None: ...
    @staticmethod
    def cacheLimit() -> int: ...


class QPolygon(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a: QPolygon) -> None: ...
    @overload
    def __init__(self, points: typing.List[int]) -> None: ...
    @overload
    def __init__(self, v: typing.Iterable[QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, rectangle: QtCore.QRect, closed: bool = ...) -> None: ...
    @overload
    def __init__(self, asize: int) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def intersects(self, r: QPolygon) -> bool: ...
    def swap(self, other: QPolygon) -> None: ...
    def __contains__(self, value: QtCore.QPoint) -> int: ...
    @overload
    def __delitem__(self, i: int) -> None: ...
    @overload
    def __delitem__(self, slice: slice) -> None: ...
    @overload
    def __setitem__(self, i: int, value: QtCore.QPoint) -> None: ...
    @overload
    def __setitem__(self, slice: slice, list: QPolygon) -> None: ...
    @overload
    def __getitem__(self, i: int) -> QtCore.QPoint: ...
    @overload
    def __getitem__(self, slice: slice) -> QPolygon: ...
    @overload
    def value(self, i: int) -> QtCore.QPoint: ...
    @overload
    def value(self, i: int, defaultValue: QtCore.QPoint) -> QtCore.QPoint: ...
    def size(self) -> int: ...
    def replace(self, i: int, value: QtCore.QPoint) -> None: ...
    @overload
    def remove(self, i: int) -> None: ...
    @overload
    def remove(self, i: int, count: int) -> None: ...
    def prepend(self, value: QtCore.QPoint) -> None: ...
    def mid(self, pos: int, length: int = ...) -> QPolygon: ...
    def lastIndexOf(self, value: QtCore.QPoint, from_: int = ...) -> int: ...
    def last(self) -> QtCore.QPoint: ...
    def isEmpty(self) -> bool: ...
    def insert(self, i: int, value: QtCore.QPoint) -> None: ...
    def indexOf(self, value: QtCore.QPoint, from_: int = ...) -> int: ...
    def first(self) -> QtCore.QPoint: ...
    def fill(self, value: QtCore.QPoint, size: int = ...) -> None: ...
    def data(self) -> sip.voidptr: ...
    def __len__(self) -> int: ...
    @overload
    def count(self, value: QtCore.QPoint) -> int: ...
    @overload
    def count(self) -> int: ...
    def contains(self, value: QtCore.QPoint) -> bool: ...
    def clear(self) -> None: ...
    def at(self, i: int) -> QtCore.QPoint: ...
    def append(self, value: QtCore.QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> QPolygon: ...
    @overload
    def translated(self, offset: QtCore.QPoint) -> QPolygon: ...
    def subtracted(self, r: QPolygon) -> QPolygon: ...
    def intersected(self, r: QPolygon) -> QPolygon: ...
    def united(self, r: QPolygon) -> QPolygon: ...
    def containsPoint(self, pt: QtCore.QPoint, fillRule: int) -> bool: ...
    @overload
    def setPoint(self, index: int, pt: QtCore.QPoint) -> None: ...
    @overload
    def setPoint(self, index: int, x: int, y: int) -> None: ...
    @overload
    def putPoints(self, index: int, firstx: int, firsty: int, *a3) -> None: ...
    @overload
    def putPoints(self, index: int, nPoints: int, fromPolygon: QPolygon, from_: int = ...) -> None: ...
    @overload
    def setPoints(self, points: typing.List[int]) -> None: ...
    @overload
    def setPoints(self, firstx: int, firsty: int, *a2) -> None: ...
    def point(self, index: int) -> QtCore.QPoint: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, offset: QtCore.QPoint) -> None: ...


class QPolygonF(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a: QPolygonF) -> None: ...
    @overload
    def __init__(self, v: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @overload
    def __init__(self, r: QtCore.QRectF) -> None: ...
    @overload
    def __init__(self, a: QPolygon) -> None: ...
    @overload
    def __init__(self, asize: int) -> None: ...

    def intersects(self, r: QPolygonF) -> bool: ...
    def swap(self, other: QPolygonF) -> None: ...
    def __contains__(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    @overload
    def __delitem__(self, i: int) -> None: ...
    @overload
    def __delitem__(self, slice: slice) -> None: ...
    @overload
    def __setitem__(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __setitem__(self, slice: slice, list: QPolygonF) -> None: ...
    @overload
    def __getitem__(self, i: int) -> QtCore.QPointF: ...
    @overload
    def __getitem__(self, slice: slice) -> QPolygonF: ...
    @overload
    def value(self, i: int) -> QtCore.QPointF: ...
    @overload
    def value(self, i: int, defaultValue: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def size(self) -> int: ...
    def replace(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def remove(self, i: int) -> None: ...
    @overload
    def remove(self, i: int, count: int) -> None: ...
    def prepend(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def mid(self, pos: int, length: int = ...) -> QPolygonF: ...
    def lastIndexOf(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...) -> int: ...
    def last(self) -> QtCore.QPointF: ...
    def isEmpty(self) -> bool: ...
    def insert(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def indexOf(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...) -> int: ...
    def first(self) -> QtCore.QPointF: ...
    def fill(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], size: int = ...) -> None: ...
    def data(self) -> sip.voidptr: ...
    def __len__(self) -> int: ...
    @overload
    def count(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    @overload
    def count(self) -> int: ...
    def contains(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def clear(self) -> None: ...
    def at(self, i: int) -> QtCore.QPointF: ...
    def append(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def translated(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QPolygonF: ...
    @overload
    def translated(self, dx: float, dy: float) -> QPolygonF: ...
    def subtracted(self, r: QPolygonF) -> QPolygonF: ...
    def intersected(self, r: QPolygonF) -> QPolygonF: ...
    def united(self, r: QPolygonF) -> QPolygonF: ...
    def containsPoint(self, pt: typing.Union[QtCore.QPointF, QtCore.QPoint], fillRule: int) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def isClosed(self) -> bool: ...
    def toPolygon(self) -> QPolygon: ...
    @overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...


class QQuaternion(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, aScalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @overload
    def __init__(self, aScalar: float, aVector: QVector3D) -> None: ...
    @overload
    def __init__(self, aVector: QVector4D) -> None: ...
    @overload
    def __init__(self, a0: QQuaternion) -> None: ...

    def __neg__(self) -> QQuaternion: ...
    def toEulerAngles(self) -> QVector3D: ...
    def conjugated(self) -> QQuaternion: ...
    def inverted(self) -> QQuaternion: ...
    @staticmethod
    def dotProduct(q1: QQuaternion, q2: QQuaternion) -> float: ...
    @staticmethod
    def rotationTo(from_: QVector3D, to: QVector3D) -> QQuaternion: ...
    @staticmethod
    def fromDirection(direction: QVector3D, up: QVector3D) -> QQuaternion: ...
    @staticmethod
    def fromAxes(xAxis: QVector3D, yAxis: QVector3D, zAxis: QVector3D) -> QQuaternion: ...
    def getAxes(self) -> typing.Tuple[QVector3D, QVector3D, QVector3D]: ...
    @staticmethod
    def fromRotationMatrix(rot3x3: QMatrix3x3) -> QQuaternion: ...
    def toRotationMatrix(self) -> QMatrix3x3: ...
    @overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> QQuaternion: ...
    @overload
    @staticmethod
    def fromEulerAngles(eulerAngles: QVector3D) -> QQuaternion: ...
    def getEulerAngles(self) -> typing.Tuple[float, float, float]: ...
    def getAxisAndAngle(self) -> typing.Tuple[QVector3D, float]: ...
    def toVector4D(self) -> QVector4D: ...
    def vector(self) -> QVector3D: ...
    @overload
    def setVector(self, aVector: QVector3D) -> None: ...
    @overload
    def setVector(self, aX: float, aY: float, aZ: float) -> None: ...
    def conjugate(self) -> QQuaternion: ...
    def setScalar(self, aScalar: float) -> None: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def scalar(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    @staticmethod
    def nlerp(q1: QQuaternion, q2: QQuaternion, t: float) -> QQuaternion: ...
    @staticmethod
    def slerp(q1: QQuaternion, q2: QQuaternion, t: float) -> QQuaternion: ...
    @overload
    @staticmethod
    def fromAxisAndAngle(axis: QVector3D, angle: float) -> QQuaternion: ...
    @overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> QQuaternion: ...
    def rotatedVector(self, vector: QVector3D) -> QVector3D: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QQuaternion: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QRasterWindow(QPaintDeviceWindow):

    def __init__(self, parent: typing.Optional[QWindow] = ..., **props) -> None: ...

    def metric(self, metric: int) -> int: ...


class QRawFont(sip.simplewrapper):

    LayoutFlag: typing.Type[int]
    #class LayoutFlag(int): ...
    SeparateAdvances = ... # type: int
    KernedAdvances = ... # type: int
    UseDesignMetrics = ... # type: int

    AntialiasingType: typing.Type[int]
    #class AntialiasingType(int): ...
    PixelAntialiasing = ... # type: int
    SubPixelAntialiasing = ... # type: int

    LayoutFlags: typing.Type[int]
    #class LayoutFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QRawFont.LayoutFlags, QRawFont.LayoutFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QRawFont.LayoutFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QRawFont.LayoutFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: int = ...) -> None: ...
    @overload
    def __init__(self, fontData: typing.Union[QtCore.QByteArray, bytes, bytearray], pixelSize: float, hintingPreference: int = ...) -> None: ...
    @overload
    def __init__(self, other: QRawFont) -> None: ...

    def __hash__(self) -> int: ...
    def capHeight(self) -> float: ...
    def swap(self, other: QRawFont) -> None: ...
    def underlinePosition(self) -> float: ...
    def lineThickness(self) -> float: ...
    def boundingRect(self, glyphIndex: int) -> QtCore.QRectF: ...
    @staticmethod
    def fromFont(font: QFont, writingSystem: int = ...) -> QRawFont: ...
    def fontTable(self, tagName: str) -> QtCore.QByteArray: ...
    def supportedWritingSystems(self) -> typing.List[int]: ...
    @overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    @overload
    def supportsCharacter(self, character: str) -> bool: ...
    def loadFromData(self, fontData: typing.Union[QtCore.QByteArray, bytes, bytearray], pixelSize: float, hintingPreference: int) -> None: ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: int) -> None: ...
    def unitsPerEm(self) -> float: ...
    def maxCharWidth(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def xHeight(self) -> float: ...
    def leading(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def hintingPreference(self) -> int: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float) -> None: ...
    def pathForGlyph(self, glyphIndex: int) -> QPainterPath: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: int = ..., transform: QTransform = ...) -> QImage: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.Iterable[int]) -> typing.List[QtCore.QPointF]: ...
    @overload
    def advancesForGlyphIndexes(self, glyphIndexes: typing.Iterable[int], layoutFlags: typing.Union[int, int]) -> typing.List[QtCore.QPointF]: ...
    def glyphIndexesForString(self, text: str) -> typing.List[int]: ...
    def weight(self) -> int: ...
    def style(self) -> int: ...
    def styleName(self) -> str: ...
    def familyName(self) -> str: ...
    def isValid(self) -> bool: ...


class QRegion(sip.simplewrapper):

    RegionType: typing.Type[int]
    #class RegionType(int): ...
    Rectangle = ... # type: int
    Ellipse = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: int, y: int, w: int, h: int, type: int = ...) -> None: ...
    @overload
    def __init__(self, r: QtCore.QRect, type: int = ...) -> None: ...
    @overload
    def __init__(self, a: QPolygon, fillRule: int = ...) -> None: ...
    @overload
    def __init__(self, bitmap: QBitmap) -> None: ...
    @overload
    def __init__(self, region: QRegion) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def isNull(self) -> bool: ...
    def swap(self, other: QRegion) -> None: ...
    def rectCount(self) -> int: ...
    @overload
    def intersects(self, r: QRegion) -> bool: ...
    @overload
    def intersects(self, r: QtCore.QRect) -> bool: ...
    def xored(self, r: QRegion) -> QRegion: ...
    def subtracted(self, r: QRegion) -> QRegion: ...
    @overload
    def intersected(self, r: QRegion) -> QRegion: ...
    @overload
    def intersected(self, r: QtCore.QRect) -> QRegion: ...
    def setRects(self, a0: typing.Iterable[QtCore.QRect]) -> None: ...
    def rects(self) -> typing.List[QtCore.QRect]: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @overload
    def united(self, r: QRegion) -> QRegion: ...
    @overload
    def united(self, r: QtCore.QRect) -> QRegion: ...
    @overload
    def translated(self, dx: int, dy: int) -> QRegion: ...
    @overload
    def translated(self, p: QtCore.QPoint) -> QRegion: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, p: QtCore.QPoint) -> None: ...
    @overload
    def __contains__(self, p: QtCore.QPoint) -> int: ...
    @overload
    def __contains__(self, r: QtCore.QRect) -> int: ...
    @overload
    def contains(self, p: QtCore.QPoint) -> bool: ...
    @overload
    def contains(self, r: QtCore.QRect) -> bool: ...
    def __bool__(self) -> int: ...
    def isEmpty(self) -> bool: ...


class QRgba64(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QRgba64) -> None: ...

    def __long__(self) -> int: ...
    def unpremultiplied(self) -> QRgba64: ...
    def premultiplied(self) -> QRgba64: ...
    def toRgb16(self) -> int: ...
    def toArgb32(self) -> int: ...
    def alpha8(self) -> int: ...
    def blue8(self) -> int: ...
    def green8(self) -> int: ...
    def red8(self) -> int: ...
    def setAlpha(self, _alpha: int) -> None: ...
    def setBlue(self, _blue: int) -> None: ...
    def setGreen(self, _green: int) -> None: ...
    def setRed(self, _red: int) -> None: ...
    def alpha(self) -> int: ...
    def blue(self) -> int: ...
    def green(self) -> int: ...
    def red(self) -> int: ...
    def isTransparent(self) -> bool: ...
    def isOpaque(self) -> bool: ...
    @staticmethod
    def fromArgb32(rgb: int) -> QRgba64: ...
    @staticmethod
    def fromRgba(red: int, green: int, blue: int, alpha: int) -> QRgba64: ...
    @overload
    @staticmethod
    def fromRgba64(c: int) -> QRgba64: ...
    @overload
    @staticmethod
    def fromRgba64(red: int, green: int, blue: int, alpha: int) -> QRgba64: ...


class QScreen(QtCore.QObject):

    availableGeometryChanged: PYQT_SIGNAL
    geometryChanged: PYQT_SIGNAL
    logicalDotsPerInchChanged: PYQT_SIGNAL
    orientationChanged: PYQT_SIGNAL
    physicalDotsPerInchChanged: PYQT_SIGNAL
    physicalSizeChanged: PYQT_SIGNAL
    primaryOrientationChanged: PYQT_SIGNAL
    refreshRateChanged: PYQT_SIGNAL
    virtualGeometryChanged: PYQT_SIGNAL

    def serialNumber(self) -> str: ...
    def model(self) -> str: ...
    def manufacturer(self) -> str: ...
    #def availableGeometryChanged(self, geometry: QtCore.QRect) -> None: ...
    #def virtualGeometryChanged(self, rect: QtCore.QRect) -> None: ...
    #def physicalSizeChanged(self, size: QtCore.QSizeF) -> None: ...
    #def refreshRateChanged(self, refreshRate: float) -> None: ...
    #def orientationChanged(self, orientation: int) -> None: ...
    #def primaryOrientationChanged(self, orientation: int) -> None: ...
    #def logicalDotsPerInchChanged(self, dpi: float) -> None: ...
    #def physicalDotsPerInchChanged(self, dpi: float) -> None: ...
    #def geometryChanged(self, geometry: QtCore.QRect) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def refreshRate(self) -> float: ...
    def grabWindow(self, window: sip.voidptr, x: int = ..., y: int = ..., width: int = ..., height: int = ...) -> QPixmap: ...
    def isLandscape(self, orientation: int) -> bool: ...
    def isPortrait(self, orientation: int) -> bool: ...
    def mapBetween(self, a: int, b: int, rect: QtCore.QRect) -> QtCore.QRect: ...
    def transformBetween(self, a: int, b: int, target: QtCore.QRect) -> QTransform: ...
    def angleBetween(self, a: int, b: int) -> int: ...
    def setOrientationUpdateMask(self, mask: typing.Union[int, int]) -> None: ...
    def orientationUpdateMask(self) -> int: ...
    def orientation(self) -> int: ...
    def primaryOrientation(self) -> int: ...
    def nativeOrientation(self) -> int: ...
    def availableVirtualGeometry(self) -> QtCore.QRect: ...
    def availableVirtualSize(self) -> QtCore.QSize: ...
    def virtualGeometry(self) -> QtCore.QRect: ...
    def virtualSize(self) -> QtCore.QSize: ...
    def virtualSiblings(self) -> typing.List[QScreen]: ...
    def availableGeometry(self) -> QtCore.QRect: ...
    def availableSize(self) -> QtCore.QSize: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalSize(self) -> QtCore.QSizeF: ...
    def geometry(self) -> QtCore.QRect: ...
    def size(self) -> QtCore.QSize: ...
    def depth(self) -> int: ...
    def name(self) -> str: ...


class QSessionManager(QtCore.QObject):

    RestartHint: typing.Type[int]
    #class RestartHint(int): ...
    RestartIfRunning = ... # type: int
    RestartAnyway = ... # type: int
    RestartImmediately = ... # type: int
    RestartNever = ... # type: int

    def requestPhase2(self) -> None: ...
    def isPhase2(self) -> bool: ...
    @overload
    def setManagerProperty(self, name: str, value: str) -> None: ...
    @overload
    def setManagerProperty(self, name: str, value: typing.Iterable[str]) -> None: ...
    def discardCommand(self) -> typing.List[str]: ...
    def setDiscardCommand(self, a0: typing.Iterable[str]) -> None: ...
    def restartCommand(self) -> typing.List[str]: ...
    def setRestartCommand(self, a0: typing.Iterable[str]) -> None: ...
    def restartHint(self) -> int: ...
    def setRestartHint(self, a0: int) -> None: ...
    def cancel(self) -> None: ...
    def release(self) -> None: ...
    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def sessionKey(self) -> str: ...
    def sessionId(self) -> str: ...


class QStandardItemModel(QtCore.QAbstractItemModel):

    itemChanged: PYQT_SIGNAL

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def clearItemData(self, index: QtCore.QModelIndex) -> bool: ...
    #def itemChanged(self, item: QStandardItem) -> None: ...
    def setItemRoleNames(self, roleNames: typing.Dict[int, typing.Union[QtCore.QByteArray, bytes, bytearray]]) -> None: ...
    def sibling(self, row: int, column: int, idx: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: int, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def setSortRole(self, role: int) -> None: ...
    def sortRole(self) -> int: ...
    def findItems(self, text: str, flags: typing.Union[int, int] = ..., column: int = ...) -> typing.List[QStandardItem]: ...
    def setItemPrototype(self, item: QStandardItem) -> None: ...
    def itemPrototype(self) -> QStandardItem: ...
    def takeVerticalHeaderItem(self, row: int) -> QStandardItem: ...
    def takeHorizontalHeaderItem(self, column: int) -> QStandardItem: ...
    def takeColumn(self, column: int) -> typing.List[QStandardItem]: ...
    def takeRow(self, row: int) -> typing.List[QStandardItem]: ...
    def takeItem(self, row: int, column: int = ...) -> QStandardItem: ...
    @overload
    def insertColumn(self, column: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertColumn(self, column: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    @overload
    def insertRow(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRow(self, arow: int, aitem: QStandardItem) -> None: ...
    @overload
    def insertRow(self, row: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def appendColumn(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, aitem: QStandardItem) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def setHorizontalHeaderLabels(self, labels: typing.Iterable[str]) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: QStandardItem) -> None: ...
    def verticalHeaderItem(self, row: int) -> QStandardItem: ...
    def setHorizontalHeaderItem(self, column: int, item: QStandardItem) -> None: ...
    def horizontalHeaderItem(self, column: int) -> QStandardItem: ...
    def invisibleRootItem(self) -> QStandardItem: ...
    @overload
    def setItem(self, row: int, column: int, item: QStandardItem) -> None: ...
    @overload
    def setItem(self, arow: int, aitem: QStandardItem) -> None: ...
    def item(self, row: int, column: int = ...) -> QStandardItem: ...
    def indexFromItem(self, item: QStandardItem) -> QtCore.QModelIndex: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QStandardItem: ...
    def sort(self, column: int, order: int = ...) -> None: ...
    def setItemData(self, index: QtCore.QModelIndex, roles: typing.Dict[int, typing.Any]) -> bool: ...
    def itemData(self, index: QtCore.QModelIndex) -> typing.Dict[int, typing.Any]: ...
    def supportedDropActions(self) -> int: ...
    def clear(self) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> int: ...
    def removeColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: int, value: typing.Any, role: int = ...) -> bool: ...
    def headerData(self, section: int, orientation: int, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @overload
    def parent(self) -> QtCore.QObject: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...


class QStandardItem(sip.wrapper):

    ItemType: typing.Type[int]
    #class ItemType(int): ...
    Type = ... # type: int
    UserType = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self, icon: QIcon, text: str) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @overload
    def __init__(self, other: QStandardItem) -> None: ...

    def clearData(self) -> None: ...
    def setUserTristate(self, tristate: bool) -> None: ...
    def isUserTristate(self) -> bool: ...
    def setAutoTristate(self, tristate: bool) -> None: ...
    def isAutoTristate(self) -> bool: ...
    def emitDataChanged(self) -> None: ...
    def appendRows(self, items: typing.Iterable[QStandardItem]) -> None: ...
    def appendColumn(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def appendRow(self, aitem: QStandardItem) -> None: ...
    def setAccessibleDescription(self, aaccessibleDescription: str) -> None: ...
    def setAccessibleText(self, aaccessibleText: str) -> None: ...
    def setCheckState(self, acheckState: int) -> None: ...
    def setForeground(self, abrush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def setBackground(self, abrush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def setTextAlignment(self, atextAlignment: typing.Union[int, int]) -> None: ...
    def setFont(self, afont: QFont) -> None: ...
    def setSizeHint(self, asizeHint: QtCore.QSize) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setIcon(self, aicon: QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def type(self) -> int: ...
    def clone(self) -> QStandardItem: ...
    def sortChildren(self, column: int, order: int = ...) -> None: ...
    def takeColumn(self, column: int) -> typing.List[QStandardItem]: ...
    def takeRow(self, row: int) -> typing.List[QStandardItem]: ...
    def takeChild(self, row: int, column: int = ...) -> QStandardItem: ...
    def removeColumns(self, column: int, count: int) -> None: ...
    def removeRows(self, row: int, count: int) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def insertColumns(self, column: int, count: int) -> None: ...
    def insertColumn(self, column: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRows(self, row: int, count: int) -> None: ...
    @overload
    def insertRows(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRow(self, row: int, items: typing.Iterable[QStandardItem]) -> None: ...
    @overload
    def insertRow(self, arow: int, aitem: QStandardItem) -> None: ...
    @overload
    def setChild(self, row: int, column: int, item: QStandardItem) -> None: ...
    @overload
    def setChild(self, arow: int, aitem: QStandardItem) -> None: ...
    def child(self, row: int, column: int = ...) -> QStandardItem: ...
    def hasChildren(self) -> bool: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def setRowCount(self, rows: int) -> None: ...
    def rowCount(self) -> int: ...
    def model(self) -> QStandardItemModel: ...
    def index(self) -> QtCore.QModelIndex: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def parent(self) -> QStandardItem: ...
    def setDropEnabled(self, dropEnabled: bool) -> None: ...
    def isDropEnabled(self) -> bool: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def isDragEnabled(self) -> bool: ...
    def setTristate(self, tristate: bool) -> None: ...
    def isTristate(self) -> bool: ...
    def setCheckable(self, checkable: bool) -> None: ...
    def isCheckable(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def isSelectable(self) -> bool: ...
    def setEditable(self, editable: bool) -> None: ...
    def isEditable(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def setFlags(self, flags: typing.Union[int, int]) -> None: ...
    def flags(self) -> int: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def checkState(self) -> int: ...
    def foreground(self) -> QBrush: ...
    def background(self) -> QBrush: ...
    def textAlignment(self) -> int: ...
    def font(self) -> QFont: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def whatsThis(self) -> str: ...
    def statusTip(self) -> str: ...
    def toolTip(self) -> str: ...
    def icon(self) -> QIcon: ...
    def text(self) -> str: ...
    def setData(self, value: typing.Any, role: int = ...) -> None: ...
    def data(self, role: int = ...) -> typing.Any: ...


class QStaticText(sip.simplewrapper):

    PerformanceHint: typing.Type[int]
    #class PerformanceHint(int): ...
    ModerateCaching = ... # type: int
    AggressiveCaching = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self, other: QStaticText) -> None: ...

    def swap(self, other: QStaticText) -> None: ...
    def performanceHint(self) -> int: ...
    def setPerformanceHint(self, performanceHint: int) -> None: ...
    def prepare(self, matrix: QTransform = ..., font: QFont = ...) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    def textOption(self) -> QTextOption: ...
    def setTextOption(self, textOption: QTextOption) -> None: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, textWidth: float) -> None: ...
    def textFormat(self) -> int: ...
    def setTextFormat(self, textFormat: int) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...


class QStyleHints(QtCore.QObject):

    cursorFlashTimeChanged: PYQT_SIGNAL
    keyboardInputIntervalChanged: PYQT_SIGNAL
    mouseDoubleClickIntervalChanged: PYQT_SIGNAL
    mousePressAndHoldIntervalChanged: PYQT_SIGNAL
    mouseQuickSelectionThresholdChanged: PYQT_SIGNAL
    startDragDistanceChanged: PYQT_SIGNAL
    startDragTimeChanged: PYQT_SIGNAL
    tabFocusBehaviorChanged: PYQT_SIGNAL
    useHoverEffectsChanged: PYQT_SIGNAL
    wheelScrollLinesChanged: PYQT_SIGNAL

    #def mouseQuickSelectionThresholdChanged(self, threshold: int) -> None: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    #def wheelScrollLinesChanged(self, scrollLines: int) -> None: ...
    def wheelScrollLines(self) -> int: ...
    #def useHoverEffectsChanged(self, useHoverEffects: bool) -> None: ...
    def setUseHoverEffects(self, useHoverEffects: bool) -> None: ...
    def useHoverEffects(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    #def tabFocusBehaviorChanged(self, tabFocusBehavior: int) -> None: ...
    #def mousePressAndHoldIntervalChanged(self, mousePressAndHoldInterval: int) -> None: ...
    #def startDragTimeChanged(self, startDragTime: int) -> None: ...
    #def startDragDistanceChanged(self, startDragDistance: int) -> None: ...
    #def mouseDoubleClickIntervalChanged(self, mouseDoubleClickInterval: int) -> None: ...
    #def keyboardInputIntervalChanged(self, keyboardInputInterval: int) -> None: ...
    #def cursorFlashTimeChanged(self, cursorFlashTime: int) -> None: ...
    def singleClickActivation(self) -> bool: ...
    def tabFocusBehavior(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def passwordMaskCharacter(self) -> str: ...
    def useRtlExtensions(self) -> bool: ...
    def fontSmoothingGamma(self) -> float: ...
    def passwordMaskDelay(self) -> int: ...
    def showIsFullScreen(self) -> bool: ...
    def cursorFlashTime(self) -> int: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardInputInterval(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragDistance(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...


class QSurfaceFormat(sip.simplewrapper):

    ColorSpace: typing.Type[int]
    #class ColorSpace(int): ...
    DefaultColorSpace = ... # type: int
    sRGBColorSpace = ... # type: int

    OpenGLContextProfile: typing.Type[int]
    #class OpenGLContextProfile(int): ...
    NoProfile = ... # type: int
    CoreProfile = ... # type: int
    CompatibilityProfile = ... # type: int

    RenderableType: typing.Type[int]
    #class RenderableType(int): ...
    DefaultRenderableType = ... # type: int
    OpenGL = ... # type: int
    OpenGLES = ... # type: int
    OpenVG = ... # type: int

    SwapBehavior: typing.Type[int]
    #class SwapBehavior(int): ...
    DefaultSwapBehavior = ... # type: int
    SingleBuffer = ... # type: int
    DoubleBuffer = ... # type: int
    TripleBuffer = ... # type: int

    FormatOption: typing.Type[int]
    #class FormatOption(int): ...
    StereoBuffers = ... # type: int
    DebugContext = ... # type: int
    DeprecatedFunctions = ... # type: int
    ResetNotification = ... # type: int

    FormatOptions: typing.Type[int]
    #class FormatOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QSurfaceFormat.FormatOptions, QSurfaceFormat.FormatOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QSurfaceFormat.FormatOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QSurfaceFormat.FormatOptions: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, options: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, other: QSurfaceFormat) -> None: ...

    def setColorSpace(self, colorSpace: int) -> None: ...
    def colorSpace(self) -> int: ...
    @staticmethod
    def defaultFormat() -> QSurfaceFormat: ...
    @staticmethod
    def setDefaultFormat(format: QSurfaceFormat) -> None: ...
    def setSwapInterval(self, interval: int) -> None: ...
    def swapInterval(self) -> int: ...
    def options(self) -> int: ...
    def setOptions(self, options: typing.Union[int, int]) -> None: ...
    def setVersion(self, major: int, minor: int) -> None: ...
    def version(self) -> typing.Tuple[int, int]: ...
    def stereo(self) -> bool: ...
    @overload
    def testOption(self, opt: typing.Union[int, int]) -> bool: ...
    @overload
    def testOption(self, option: int) -> bool: ...
    @overload
    def setOption(self, opt: typing.Union[int, int]) -> None: ...
    @overload
    def setOption(self, option: int, on: bool = ...) -> None: ...
    def setStereo(self, enable: bool) -> None: ...
    def minorVersion(self) -> int: ...
    def setMinorVersion(self, minorVersion: int) -> None: ...
    def majorVersion(self) -> int: ...
    def setMajorVersion(self, majorVersion: int) -> None: ...
    def renderableType(self) -> int: ...
    def setRenderableType(self, type: int) -> None: ...
    def profile(self) -> int: ...
    def setProfile(self, profile: int) -> None: ...
    def hasAlpha(self) -> bool: ...
    def swapBehavior(self) -> int: ...
    def setSwapBehavior(self, behavior: int) -> None: ...
    def samples(self) -> int: ...
    def setSamples(self, numSamples: int) -> None: ...
    def alphaBufferSize(self) -> int: ...
    def setAlphaBufferSize(self, size: int) -> None: ...
    def blueBufferSize(self) -> int: ...
    def setBlueBufferSize(self, size: int) -> None: ...
    def greenBufferSize(self) -> int: ...
    def setGreenBufferSize(self, size: int) -> None: ...
    def redBufferSize(self) -> int: ...
    def setRedBufferSize(self, size: int) -> None: ...
    def stencilBufferSize(self) -> int: ...
    def setStencilBufferSize(self, size: int) -> None: ...
    def depthBufferSize(self) -> int: ...
    def setDepthBufferSize(self, size: int) -> None: ...


class QSyntaxHighlighter(QtCore.QObject):

    @overload
    def __init__(self, parent: QTextDocument, **props) -> None: ...
    @overload
    def __init__(self, parent: QtCore.QObject, **props) -> None: ...

    def currentBlock(self) -> QTextBlock: ...
    def currentBlockUserData(self) -> QTextBlockUserData: ...
    def setCurrentBlockUserData(self, data: QTextBlockUserData) -> None: ...
    def setCurrentBlockState(self, newState: int) -> None: ...
    def currentBlockState(self) -> int: ...
    def previousBlockState(self) -> int: ...
    def format(self, pos: int) -> QTextCharFormat: ...
    @overload
    def setFormat(self, start: int, count: int, format: QTextCharFormat) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, color: typing.Union[QColor, int, QGradient]) -> None: ...
    @overload
    def setFormat(self, start: int, count: int, font: QFont) -> None: ...
    def highlightBlock(self, text: str) -> None: ...
    def rehighlightBlock(self, block: QTextBlock) -> None: ...
    def rehighlight(self) -> None: ...
    def document(self) -> QTextDocument: ...
    def setDocument(self, doc: QTextDocument) -> None: ...


class QTextCursor(sip.simplewrapper):

    SelectionType: typing.Type[int]
    #class SelectionType(int): ...
    WordUnderCursor = ... # type: int
    LineUnderCursor = ... # type: int
    BlockUnderCursor = ... # type: int
    Document = ... # type: int

    MoveOperation: typing.Type[int]
    #class MoveOperation(int): ...
    NoMove = ... # type: int
    Start = ... # type: int
    Up = ... # type: int
    StartOfLine = ... # type: int
    StartOfBlock = ... # type: int
    StartOfWord = ... # type: int
    PreviousBlock = ... # type: int
    PreviousCharacter = ... # type: int
    PreviousWord = ... # type: int
    Left = ... # type: int
    WordLeft = ... # type: int
    End = ... # type: int
    Down = ... # type: int
    EndOfLine = ... # type: int
    EndOfWord = ... # type: int
    EndOfBlock = ... # type: int
    NextBlock = ... # type: int
    NextCharacter = ... # type: int
    NextWord = ... # type: int
    Right = ... # type: int
    WordRight = ... # type: int
    NextCell = ... # type: int
    PreviousCell = ... # type: int
    NextRow = ... # type: int
    PreviousRow = ... # type: int

    MoveMode: typing.Type[int]
    #class MoveMode(int): ...
    MoveAnchor = ... # type: int
    KeepAnchor = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, document: QTextDocument) -> None: ...
    @overload
    def __init__(self, frame: QTextFrame) -> None: ...
    @overload
    def __init__(self, block: QTextBlock) -> None: ...
    @overload
    def __init__(self, cursor: QTextCursor) -> None: ...

    def swap(self, other: QTextCursor) -> None: ...
    def keepPositionOnInsert(self) -> bool: ...
    def setKeepPositionOnInsert(self, b: bool) -> None: ...
    def verticalMovementX(self) -> int: ...
    def setVerticalMovementX(self, x: int) -> None: ...
    def positionInBlock(self) -> int: ...
    def document(self) -> QTextDocument: ...
    def setVisualNavigation(self, b: bool) -> None: ...
    def visualNavigation(self) -> bool: ...
    def isCopyOf(self, other: QTextCursor) -> bool: ...
    def columnNumber(self) -> int: ...
    def blockNumber(self) -> int: ...
    def endEditBlock(self) -> None: ...
    def joinPreviousEditBlock(self) -> None: ...
    def beginEditBlock(self) -> None: ...
    @overload
    def insertImage(self, format: QTextImageFormat) -> None: ...
    @overload
    def insertImage(self, format: QTextImageFormat, alignment: int) -> None: ...
    @overload
    def insertImage(self, name: str) -> None: ...
    @overload
    def insertImage(self, image: QImage, name: str = ...) -> None: ...
    def insertHtml(self, html: str) -> None: ...
    def insertFragment(self, fragment: QTextDocumentFragment) -> None: ...
    def currentFrame(self) -> QTextFrame: ...
    def insertFrame(self, format: QTextFrameFormat) -> QTextFrame: ...
    def currentTable(self) -> QTextTable: ...
    @overload
    def insertTable(self, rows: int, cols: int, format: QTextTableFormat) -> QTextTable: ...
    @overload
    def insertTable(self, rows: int, cols: int) -> QTextTable: ...
    def currentList(self) -> QTextList: ...
    @overload
    def createList(self, format: QTextListFormat) -> QTextList: ...
    @overload
    def createList(self, style: int) -> QTextList: ...
    @overload
    def insertList(self, format: QTextListFormat) -> QTextList: ...
    @overload
    def insertList(self, style: int) -> QTextList: ...
    @overload
    def insertBlock(self) -> None: ...
    @overload
    def insertBlock(self, format: QTextBlockFormat) -> None: ...
    @overload
    def insertBlock(self, format: QTextBlockFormat, charFormat: QTextCharFormat) -> None: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: QTextCharFormat) -> None: ...
    def setBlockCharFormat(self, format: QTextCharFormat) -> None: ...
    def blockCharFormat(self) -> QTextCharFormat: ...
    def mergeBlockFormat(self, modifier: QTextBlockFormat) -> None: ...
    def setBlockFormat(self, format: QTextBlockFormat) -> None: ...
    def blockFormat(self) -> QTextBlockFormat: ...
    def mergeCharFormat(self, modifier: QTextCharFormat) -> None: ...
    def setCharFormat(self, format: QTextCharFormat) -> None: ...
    def charFormat(self) -> QTextCharFormat: ...
    def block(self) -> QTextBlock: ...
    def selectedTableCells(self) -> typing.Tuple[int, int, int, int]: ...
    def selection(self) -> QTextDocumentFragment: ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def clearSelection(self) -> None: ...
    def removeSelectedText(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    def select(self, selection: int) -> None: ...
    def deletePreviousChar(self) -> None: ...
    def deleteChar(self) -> None: ...
    def movePosition(self, op: int, mode: int = ..., n: int = ...) -> bool: ...
    @overload
    def insertText(self, text: str) -> None: ...
    @overload
    def insertText(self, text: str, format: QTextCharFormat) -> None: ...
    def anchor(self) -> int: ...
    def position(self) -> int: ...
    def setPosition(self, pos: int, mode: int = ...) -> None: ...
    def isNull(self) -> bool: ...


class Qt(sip.simplewrapper):

    def convertFromPlainText(self, plain: str, mode: int = ...) -> str: ...
    def mightBeRichText(self, a0: str) -> bool: ...


class QTextDocument(QtCore.QObject):

    baseUrlChanged: PYQT_SIGNAL
    blockCountChanged: PYQT_SIGNAL
    contentsChange: PYQT_SIGNAL
    contentsChanged: PYQT_SIGNAL
    cursorPositionChanged: PYQT_SIGNAL
    documentLayoutChanged: PYQT_SIGNAL
    modificationChanged: PYQT_SIGNAL
    redoAvailable: PYQT_SIGNAL
    undoAvailable: PYQT_SIGNAL
    undoCommandAdded: PYQT_SIGNAL

    Stacks: typing.Type[int]
    #class Stacks(int): ...
    UndoStack = ... # type: int
    RedoStack = ... # type: int
    UndoAndRedoStacks = ... # type: int

    ResourceType: typing.Type[int]
    #class ResourceType(int): ...
    HtmlResource = ... # type: int
    ImageResource = ... # type: int
    StyleSheetResource = ... # type: int
    UserResource = ... # type: int

    FindFlag: typing.Type[int]
    #class FindFlag(int): ...
    FindBackward = ... # type: int
    FindCaseSensitively = ... # type: int
    FindWholeWords = ... # type: int

    MetaInformation: typing.Type[int]
    #class MetaInformation(int): ...
    DocumentTitle = ... # type: int
    DocumentUrl = ... # type: int

    FindFlags: typing.Type[int]
    #class FindFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTextDocument.FindFlags, QTextDocument.FindFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTextDocument.FindFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTextDocument.FindFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, text: str, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def toRawText(self) -> str: ...
    #def baseUrlChanged(self, url: QtCore.QUrl) -> None: ...
    def setBaseUrl(self, url: QtCore.QUrl) -> None: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def setDefaultCursorMoveStyle(self, style: int) -> None: ...
    def defaultCursorMoveStyle(self) -> int: ...
    def clearUndoRedoStacks(self, stacks: int = ...) -> None: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def characterCount(self) -> int: ...
    def lineCount(self) -> int: ...
    def setDocumentMargin(self, margin: float) -> None: ...
    def documentMargin(self) -> float: ...
    def characterAt(self, pos: int) -> str: ...
    #def documentLayoutChanged(self) -> None: ...
    #def undoCommandAdded(self) -> None: ...
    def setIndentWidth(self, width: float) -> None: ...
    def indentWidth(self) -> float: ...
    def lastBlock(self) -> QTextBlock: ...
    def firstBlock(self) -> QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber: int) -> QTextBlock: ...
    def findBlockByNumber(self, blockNumber: int) -> QTextBlock: ...
    def revision(self) -> int: ...
    def setDefaultTextOption(self, option: QTextOption) -> None: ...
    def defaultTextOption(self) -> QTextOption: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def defaultStyleSheet(self) -> str: ...
    def setDefaultStyleSheet(self, sheet: str) -> None: ...
    def blockCount(self) -> int: ...
    def size(self) -> QtCore.QSizeF: ...
    def adjustSize(self) -> None: ...
    def idealWidth(self) -> float: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, width: float) -> None: ...
    def drawContents(self, p: QPainter, rect: QtCore.QRectF = ...) -> None: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def createObject(self, f: QTextFormat) -> QTextObject: ...
    def setModified(self, on: bool = ...) -> None: ...
    @overload
    def redo(self) -> None: ...
    @overload
    def redo(self, cursor: QTextCursor) -> None: ...
    @overload
    def undo(self) -> None: ...
    @overload
    def undo(self, cursor: QTextCursor) -> None: ...
    #def undoAvailable(self, a0: bool) -> None: ...
    #def redoAvailable(self, a0: bool) -> None: ...
    #def modificationChanged(self, m: bool) -> None: ...
    #def cursorPositionChanged(self, cursor: QTextCursor) -> None: ...
    #def contentsChanged(self) -> None: ...
    #def contentsChange(self, from_: int, charsRemoves: int, charsAdded: int) -> None: ...
    #def blockCountChanged(self, newBlockCount: int) -> None: ...
    def useDesignMetrics(self) -> bool: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def markContentsDirty(self, from_: int, length: int) -> None: ...
    def allFormats(self) -> typing.List[QTextFormat]: ...
    def addResource(self, type: int, name: QtCore.QUrl, resource: typing.Any) -> None: ...
    def resource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def print(self, printer: QPagedPaintDevice) -> None: ...
    def print_(self, printer: QPagedPaintDevice) -> None: ...
    def isModified(self) -> bool: ...
    def pageCount(self) -> int: ...
    def defaultFont(self) -> QFont: ...
    def setDefaultFont(self, font: QFont) -> None: ...
    def pageSize(self) -> QtCore.QSizeF: ...
    def setPageSize(self, size: QtCore.QSizeF) -> None: ...
    def end(self) -> QTextBlock: ...
    def begin(self) -> QTextBlock: ...
    def findBlock(self, pos: int) -> QTextBlock: ...
    def objectForFormat(self, a0: QTextFormat) -> QTextObject: ...
    def object(self, objectIndex: int) -> QTextObject: ...
    def rootFrame(self) -> QTextFrame: ...
    @overload
    def find(self, subString: str, position: int = ..., options: int = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: QtCore.QRegExp, position: int = ..., options: int = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: QtCore.QRegularExpression, position: int = ..., options: int = ...) -> QTextCursor: ...
    @overload
    def find(self, subString: str, cursor: QTextCursor, options: int = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: QtCore.QRegExp, cursor: QTextCursor, options: int = ...) -> QTextCursor: ...
    @overload
    def find(self, expr: QtCore.QRegularExpression, cursor: QTextCursor, options: int = ...) -> QTextCursor: ...
    def setPlainText(self, text: str) -> None: ...
    def toPlainText(self) -> str: ...
    def setHtml(self, html: str) -> None: ...
    def toHtml(self, encoding: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> str: ...
    def metaInformation(self, info: int) -> str: ...
    def setMetaInformation(self, info: int, a1: str) -> None: ...
    def documentLayout(self) -> QAbstractTextDocumentLayout: ...
    def setDocumentLayout(self, layout: QAbstractTextDocumentLayout) -> None: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def clear(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def clone(self, parent: typing.Optional[QtCore.QObject] = ...) -> QTextDocument: ...


class QTextDocumentFragment(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, document: QTextDocument) -> None: ...
    @overload
    def __init__(self, range: QTextCursor) -> None: ...
    @overload
    def __init__(self, rhs: QTextDocumentFragment) -> None: ...

    @overload
    @staticmethod
    def fromHtml(html: str) -> QTextDocumentFragment: ...
    @overload
    @staticmethod
    def fromHtml(html: str, resourceProvider: QTextDocument) -> QTextDocumentFragment: ...
    @staticmethod
    def fromPlainText(plainText: str) -> QTextDocumentFragment: ...
    def toHtml(self, encoding: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def isEmpty(self) -> bool: ...


class QTextDocumentWriter(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    @staticmethod
    def supportedDocumentFormats() -> typing.List[QtCore.QByteArray]: ...
    def codec(self) -> QtCore.QTextCodec: ...
    def setCodec(self, codec: QtCore.QTextCodec) -> None: ...
    @overload
    def write(self, document: QTextDocument) -> bool: ...
    @overload
    def write(self, fragment: QTextDocumentFragment) -> bool: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QTextLength(sip.simplewrapper):

    Type: typing.Type[int]
    #class Type(int): ...
    VariableLength = ... # type: int
    FixedLength = ... # type: int
    PercentageLength = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, atype: int, avalue: float) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...
    @overload
    def __init__(self, a0: QTextLength) -> None: ...

    def rawValue(self) -> float: ...
    def value(self, maximumLength: float) -> float: ...
    def type(self) -> int: ...


class QTextFormat(sip.simplewrapper):

    Property: typing.Type[int]
    #class Property(int): ...
    ObjectIndex = ... # type: int
    CssFloat = ... # type: int
    LayoutDirection = ... # type: int
    OutlinePen = ... # type: int
    BackgroundBrush = ... # type: int
    ForegroundBrush = ... # type: int
    BlockAlignment = ... # type: int
    BlockTopMargin = ... # type: int
    BlockBottomMargin = ... # type: int
    BlockLeftMargin = ... # type: int
    BlockRightMargin = ... # type: int
    TextIndent = ... # type: int
    BlockIndent = ... # type: int
    BlockNonBreakableLines = ... # type: int
    BlockTrailingHorizontalRulerWidth = ... # type: int
    FontFamily = ... # type: int
    FontPointSize = ... # type: int
    FontSizeAdjustment = ... # type: int
    FontSizeIncrement = ... # type: int
    FontWeight = ... # type: int
    FontItalic = ... # type: int
    FontUnderline = ... # type: int
    FontOverline = ... # type: int
    FontStrikeOut = ... # type: int
    FontFixedPitch = ... # type: int
    FontPixelSize = ... # type: int
    TextUnderlineColor = ... # type: int
    TextVerticalAlignment = ... # type: int
    TextOutline = ... # type: int
    IsAnchor = ... # type: int
    AnchorHref = ... # type: int
    AnchorName = ... # type: int
    ObjectType = ... # type: int
    ListStyle = ... # type: int
    ListIndent = ... # type: int
    FrameBorder = ... # type: int
    FrameMargin = ... # type: int
    FramePadding = ... # type: int
    FrameWidth = ... # type: int
    FrameHeight = ... # type: int
    TableColumns = ... # type: int
    TableColumnWidthConstraints = ... # type: int
    TableCellSpacing = ... # type: int
    TableCellPadding = ... # type: int
    TableCellRowSpan = ... # type: int
    TableCellColumnSpan = ... # type: int
    ImageName = ... # type: int
    ImageWidth = ... # type: int
    ImageHeight = ... # type: int
    TextUnderlineStyle = ... # type: int
    TableHeaderRowCount = ... # type: int
    FullWidthSelection = ... # type: int
    PageBreakPolicy = ... # type: int
    TextToolTip = ... # type: int
    FrameTopMargin = ... # type: int
    FrameBottomMargin = ... # type: int
    FrameLeftMargin = ... # type: int
    FrameRightMargin = ... # type: int
    FrameBorderBrush = ... # type: int
    FrameBorderStyle = ... # type: int
    BackgroundImageUrl = ... # type: int
    TabPositions = ... # type: int
    FirstFontProperty = ... # type: int
    FontCapitalization = ... # type: int
    FontLetterSpacing = ... # type: int
    FontWordSpacing = ... # type: int
    LastFontProperty = ... # type: int
    TableCellTopPadding = ... # type: int
    TableCellBottomPadding = ... # type: int
    TableCellLeftPadding = ... # type: int
    TableCellRightPadding = ... # type: int
    FontStyleHint = ... # type: int
    FontStyleStrategy = ... # type: int
    FontKerning = ... # type: int
    LineHeight = ... # type: int
    LineHeightType = ... # type: int
    FontHintingPreference = ... # type: int
    ListNumberPrefix = ... # type: int
    ListNumberSuffix = ... # type: int
    FontStretch = ... # type: int
    FontLetterSpacingType = ... # type: int
    HeadingLevel = ... # type: int
    ImageQuality = ... # type: int
    UserProperty = ... # type: int

    PageBreakFlag: typing.Type[int]
    #class PageBreakFlag(int): ...
    PageBreak_Auto = ... # type: int
    PageBreak_AlwaysBefore = ... # type: int
    PageBreak_AlwaysAfter = ... # type: int

    ObjectTypes: typing.Type[int]
    #class ObjectTypes(int): ...
    NoObject = ... # type: int
    ImageObject = ... # type: int
    TableObject = ... # type: int
    TableCellObject = ... # type: int
    UserObject = ... # type: int

    FormatType: typing.Type[int]
    #class FormatType(int): ...
    InvalidFormat = ... # type: int
    BlockFormat = ... # type: int
    CharFormat = ... # type: int
    ListFormat = ... # type: int
    TableFormat = ... # type: int
    FrameFormat = ... # type: int
    UserFormat = ... # type: int

    PageBreakFlags: typing.Type[int]
    #class PageBreakFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTextFormat.PageBreakFlags, QTextFormat.PageBreakFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTextFormat.PageBreakFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTextFormat.PageBreakFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: int) -> None: ...
    @overload
    def __init__(self, rhs: QTextFormat) -> None: ...
    @overload
    def __init__(self, variant: typing.Any) -> None: ...

    def isEmpty(self) -> bool: ...
    def swap(self, other: QTextFormat) -> None: ...
    def toTableCellFormat(self) -> QTextTableCellFormat: ...
    def isTableCellFormat(self) -> bool: ...
    def propertyCount(self) -> int: ...
    def setObjectType(self, atype: int) -> None: ...
    def clearForeground(self) -> None: ...
    def foreground(self) -> QBrush: ...
    def setForeground(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def clearBackground(self) -> None: ...
    def background(self) -> QBrush: ...
    def setBackground(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def layoutDirection(self) -> int: ...
    def setLayoutDirection(self, direction: int) -> None: ...
    def toImageFormat(self) -> QTextImageFormat: ...
    def toFrameFormat(self) -> QTextFrameFormat: ...
    def toTableFormat(self) -> QTextTableFormat: ...
    def toListFormat(self) -> QTextListFormat: ...
    def toCharFormat(self) -> QTextCharFormat: ...
    def toBlockFormat(self) -> QTextBlockFormat: ...
    def isTableFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def objectType(self) -> int: ...
    def properties(self) -> typing.Dict[int, typing.Any]: ...
    def lengthVectorProperty(self, propertyId: int) -> typing.List[QTextLength]: ...
    def lengthProperty(self, propertyId: int) -> QTextLength: ...
    def brushProperty(self, propertyId: int) -> QBrush: ...
    def penProperty(self, propertyId: int) -> QPen: ...
    def colorProperty(self, propertyId: int) -> QColor: ...
    def stringProperty(self, propertyId: int) -> str: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def intProperty(self, propertyId: int) -> int: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def clearProperty(self, propertyId: int) -> None: ...
    @overload
    def setProperty(self, propertyId: int, value: typing.Any) -> None: ...
    @overload
    def setProperty(self, propertyId: int, lengths: typing.Iterable[QTextLength]) -> None: ...
    def property(self, propertyId: int) -> typing.Any: ...
    def setObjectIndex(self, object: int) -> None: ...
    def objectIndex(self) -> int: ...
    def type(self) -> int: ...
    def isValid(self) -> bool: ...
    def merge(self, other: QTextFormat) -> None: ...


class QTextCharFormat(QTextFormat):

    FontPropertiesInheritanceBehavior: typing.Type[int]
    #class FontPropertiesInheritanceBehavior(int): ...
    FontPropertiesSpecifiedOnly = ... # type: int
    FontPropertiesAll = ... # type: int

    UnderlineStyle: typing.Type[int]
    #class UnderlineStyle(int): ...
    NoUnderline = ... # type: int
    SingleUnderline = ... # type: int
    DashUnderline = ... # type: int
    DotLine = ... # type: int
    DashDotLine = ... # type: int
    DashDotDotLine = ... # type: int
    WaveUnderline = ... # type: int
    SpellCheckUnderline = ... # type: int

    VerticalAlignment: typing.Type[int]
    #class VerticalAlignment(int): ...
    AlignNormal = ... # type: int
    AlignSuperScript = ... # type: int
    AlignSubScript = ... # type: int
    AlignMiddle = ... # type: int
    AlignTop = ... # type: int
    AlignBottom = ... # type: int
    AlignBaseline = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextCharFormat) -> None: ...

    def fontLetterSpacingType(self) -> int: ...
    def setFontLetterSpacingType(self, letterSpacingType: int) -> None: ...
    def setFontStretch(self, factor: int) -> None: ...
    def fontStretch(self) -> int: ...
    def fontHintingPreference(self) -> int: ...
    def setFontHintingPreference(self, hintingPreference: int) -> None: ...
    def fontKerning(self) -> bool: ...
    def setFontKerning(self, enable: bool) -> None: ...
    def fontStyleStrategy(self) -> int: ...
    def fontStyleHint(self) -> int: ...
    def setFontStyleStrategy(self, strategy: int) -> None: ...
    def setFontStyleHint(self, hint: int, strategy: int = ...) -> None: ...
    def fontWordSpacing(self) -> float: ...
    def setFontWordSpacing(self, spacing: float) -> None: ...
    def fontLetterSpacing(self) -> float: ...
    def setFontLetterSpacing(self, spacing: float) -> None: ...
    def fontCapitalization(self) -> int: ...
    def setFontCapitalization(self, capitalization: int) -> None: ...
    def anchorNames(self) -> typing.List[str]: ...
    def setAnchorNames(self, names: typing.Iterable[str]) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, tip: str) -> None: ...
    def underlineStyle(self) -> int: ...
    def setUnderlineStyle(self, style: int) -> None: ...
    def textOutline(self) -> QPen: ...
    def setTextOutline(self, pen: typing.Union[QPen, QColor, int, QGradient]) -> None: ...
    def setTableCellColumnSpan(self, atableCellColumnSpan: int) -> None: ...
    def setTableCellRowSpan(self, atableCellRowSpan: int) -> None: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def anchorHref(self) -> str: ...
    def setAnchorHref(self, value: str) -> None: ...
    def isAnchor(self) -> bool: ...
    def setAnchor(self, anchor: bool) -> None: ...
    def verticalAlignment(self) -> int: ...
    def setVerticalAlignment(self, alignment: int) -> None: ...
    def fontFixedPitch(self) -> bool: ...
    def setFontFixedPitch(self, fixedPitch: bool) -> None: ...
    def underlineColor(self) -> QColor: ...
    def setUnderlineColor(self, color: typing.Union[QColor, int, QGradient]) -> None: ...
    def fontStrikeOut(self) -> bool: ...
    def setFontStrikeOut(self, strikeOut: bool) -> None: ...
    def fontOverline(self) -> bool: ...
    def setFontOverline(self, overline: bool) -> None: ...
    def fontUnderline(self) -> bool: ...
    def setFontUnderline(self, underline: bool) -> None: ...
    def fontItalic(self) -> bool: ...
    def setFontItalic(self, italic: bool) -> None: ...
    def fontWeight(self) -> int: ...
    def setFontWeight(self, weight: int) -> None: ...
    def fontPointSize(self) -> float: ...
    def setFontPointSize(self, size: float) -> None: ...
    def fontFamily(self) -> str: ...
    def setFontFamily(self, family: str) -> None: ...
    def font(self) -> QFont: ...
    @overload
    def setFont(self, font: QFont) -> None: ...
    @overload
    def setFont(self, font: QFont, behavior: int) -> None: ...
    def isValid(self) -> bool: ...


class QTextBlockFormat(QTextFormat):

    LineHeightTypes: typing.Type[int]
    #class LineHeightTypes(int): ...
    SingleHeight = ... # type: int
    ProportionalHeight = ... # type: int
    FixedHeight = ... # type: int
    MinimumHeight = ... # type: int
    LineDistanceHeight = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextBlockFormat) -> None: ...

    def headingLevel(self) -> int: ...
    def setHeadingLevel(self, alevel: int) -> None: ...
    def lineHeightType(self) -> int: ...
    @overload
    def lineHeight(self) -> float: ...
    @overload
    def lineHeight(self, scriptLineHeight: float, scaling: float = ...) -> float: ...
    def setLineHeight(self, height: float, heightType: int) -> None: ...
    def tabPositions(self) -> typing.List[QTextOption.Tab]: ...
    def setTabPositions(self, tabs: typing.Iterable[QTextOption.Tab]) -> None: ...
    def pageBreakPolicy(self) -> int: ...
    def setPageBreakPolicy(self, flags: typing.Union[int, int]) -> None: ...
    def setIndent(self, aindent: int) -> None: ...
    def setAlignment(self, aalignment: typing.Union[int, int]) -> None: ...
    def nonBreakableLines(self) -> bool: ...
    def setNonBreakableLines(self, b: bool) -> None: ...
    def indent(self) -> int: ...
    def textIndent(self) -> float: ...
    def setTextIndent(self, margin: float) -> None: ...
    def rightMargin(self) -> float: ...
    def setRightMargin(self, margin: float) -> None: ...
    def leftMargin(self) -> float: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def bottomMargin(self) -> float: ...
    def setBottomMargin(self, margin: float) -> None: ...
    def topMargin(self) -> float: ...
    def setTopMargin(self, margin: float) -> None: ...
    def alignment(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextListFormat(QTextFormat):

    Style: typing.Type[int]
    #class Style(int): ...
    ListDisc = ... # type: int
    ListCircle = ... # type: int
    ListSquare = ... # type: int
    ListDecimal = ... # type: int
    ListLowerAlpha = ... # type: int
    ListUpperAlpha = ... # type: int
    ListLowerRoman = ... # type: int
    ListUpperRoman = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextListFormat) -> None: ...

    def setNumberSuffix(self, ns: str) -> None: ...
    def setNumberPrefix(self, np: str) -> None: ...
    def numberSuffix(self) -> str: ...
    def numberPrefix(self) -> str: ...
    def setIndent(self, aindent: int) -> None: ...
    def setStyle(self, astyle: int) -> None: ...
    def indent(self) -> int: ...
    def style(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextImageFormat(QTextCharFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextImageFormat) -> None: ...

    def setQuality(self, quality: int = ...) -> None: ...
    def setHeight(self, aheight: float) -> None: ...
    def setWidth(self, awidth: float) -> None: ...
    def setName(self, aname: str) -> None: ...
    def quality(self) -> int: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QTextFrameFormat(QTextFormat):

    BorderStyle: typing.Type[int]
    #class BorderStyle(int): ...
    BorderStyle_None = ... # type: int
    BorderStyle_Dotted = ... # type: int
    BorderStyle_Dashed = ... # type: int
    BorderStyle_Solid = ... # type: int
    BorderStyle_Double = ... # type: int
    BorderStyle_DotDash = ... # type: int
    BorderStyle_DotDotDash = ... # type: int
    BorderStyle_Groove = ... # type: int
    BorderStyle_Ridge = ... # type: int
    BorderStyle_Inset = ... # type: int
    BorderStyle_Outset = ... # type: int

    Position: typing.Type[int]
    #class Position(int): ...
    InFlow = ... # type: int
    FloatLeft = ... # type: int
    FloatRight = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextFrameFormat) -> None: ...

    def setRightMargin(self, amargin: float) -> None: ...
    def setLeftMargin(self, amargin: float) -> None: ...
    def setBottomMargin(self, amargin: float) -> None: ...
    def setTopMargin(self, amargin: float) -> None: ...
    def rightMargin(self) -> float: ...
    def leftMargin(self) -> float: ...
    def bottomMargin(self) -> float: ...
    def topMargin(self) -> float: ...
    def borderStyle(self) -> int: ...
    def setBorderStyle(self, style: int) -> None: ...
    def borderBrush(self) -> QBrush: ...
    def setBorderBrush(self, brush: typing.Union[QBrush, QColor, int, QGradient]) -> None: ...
    def pageBreakPolicy(self) -> int: ...
    def setPageBreakPolicy(self, flags: typing.Union[int, int]) -> None: ...
    @overload
    def setHeight(self, aheight: float) -> None: ...
    @overload
    def setHeight(self, aheight: QTextLength) -> None: ...
    def setPadding(self, apadding: float) -> None: ...
    def setMargin(self, amargin: float) -> None: ...
    def setBorder(self, aborder: float) -> None: ...
    def height(self) -> QTextLength: ...
    def width(self) -> QTextLength: ...
    @overload
    def setWidth(self, length: QTextLength) -> None: ...
    @overload
    def setWidth(self, awidth: float) -> None: ...
    def padding(self) -> float: ...
    def margin(self) -> float: ...
    def border(self) -> float: ...
    def position(self) -> int: ...
    def setPosition(self, f: int) -> None: ...
    def isValid(self) -> bool: ...


class QTextTableFormat(QTextFrameFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextTableFormat) -> None: ...

    def headerRowCount(self) -> int: ...
    def setHeaderRowCount(self, count: int) -> None: ...
    def setAlignment(self, aalignment: typing.Union[int, int]) -> None: ...
    def setCellPadding(self, apadding: float) -> None: ...
    def setColumns(self, acolumns: int) -> None: ...
    def alignment(self) -> int: ...
    def cellPadding(self) -> float: ...
    def setCellSpacing(self, spacing: float) -> None: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> typing.List[QTextLength]: ...
    def setColumnWidthConstraints(self, constraints: typing.Iterable[QTextLength]) -> None: ...
    def columns(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextTableCellFormat(QTextCharFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextTableCellFormat) -> None: ...

    def setPadding(self, padding: float) -> None: ...
    def rightPadding(self) -> float: ...
    def setRightPadding(self, padding: float) -> None: ...
    def leftPadding(self) -> float: ...
    def setLeftPadding(self, padding: float) -> None: ...
    def bottomPadding(self) -> float: ...
    def setBottomPadding(self, padding: float) -> None: ...
    def topPadding(self) -> float: ...
    def setTopPadding(self, padding: float) -> None: ...
    def isValid(self) -> bool: ...


class QTextInlineObject(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextInlineObject) -> None: ...

    def format(self) -> QTextFormat: ...
    def formatIndex(self) -> int: ...
    def textPosition(self) -> int: ...
    def setDescent(self, d: float) -> None: ...
    def setAscent(self, a: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def textDirection(self) -> int: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def width(self) -> float: ...
    def rect(self) -> QtCore.QRectF: ...
    def isValid(self) -> bool: ...


class QTextLayout(sip.simplewrapper):

    CursorMode: typing.Type[int]
    #class CursorMode(int): ...
    SkipCharacters = ... # type: int
    SkipWords = ... # type: int

    class FormatRange:

        format = ... # type: QTextCharFormat
        length = ... # type: int
        start = ... # type: int

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QTextLayout.FormatRange) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self, text: str, font: QFont, paintDevice: typing.Optional[QPaintDevice] = ...) -> None: ...
    @overload
    def __init__(self, b: QTextBlock) -> None: ...

    def clearFormats(self) -> None: ...
    def formats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def setFormats(self, overrides: typing.Iterable[QTextLayout.FormatRange]) -> None: ...
    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[QGlyphRun]: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def cursorMoveStyle(self) -> int: ...
    def setCursorMoveStyle(self, style: int) -> None: ...
    def clearLayout(self) -> None: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setPosition(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    @overload
    def drawCursor(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cursorPosition: int) -> None: ...
    @overload
    def drawCursor(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cursorPosition: int, width: int) -> None: ...
    def draw(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], selections: typing.Iterable[QTextLayout.FormatRange] = ..., clip: QtCore.QRectF = ...) -> None: ...
    def previousCursorPosition(self, oldPos: int, mode: int = ...) -> int: ...
    def nextCursorPosition(self, oldPos: int, mode: int = ...) -> int: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def lineForTextPosition(self, pos: int) -> QTextLine: ...
    def lineAt(self, i: int) -> QTextLine: ...
    def lineCount(self) -> int: ...
    def createLine(self) -> QTextLine: ...
    def endLayout(self) -> None: ...
    def beginLayout(self) -> None: ...
    def cacheEnabled(self) -> bool: ...
    def setCacheEnabled(self, enable: bool) -> None: ...
    def clearAdditionalFormats(self) -> None: ...
    def additionalFormats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def setAdditionalFormats(self, overrides: typing.Iterable[QTextLayout.FormatRange]) -> None: ...
    def preeditAreaText(self) -> str: ...
    def preeditAreaPosition(self) -> int: ...
    def setPreeditArea(self, position: int, text: str) -> None: ...
    def textOption(self) -> QTextOption: ...
    def setTextOption(self, option: QTextOption) -> None: ...
    def text(self) -> str: ...
    def setText(self, string: str) -> None: ...
    def font(self) -> QFont: ...
    def setFont(self, f: QFont) -> None: ...


class QTextLine(sip.simplewrapper):

    CursorPosition: typing.Type[int]
    #class CursorPosition(int): ...
    CursorBetweenCharacters = ... # type: int
    CursorOnCharacter = ... # type: int

    Edge: typing.Type[int]
    #class Edge(int): ...
    Leading = ... # type: int
    Trailing = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextLine) -> None: ...

    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[QGlyphRun]: ...
    def horizontalAdvance(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def setLeadingIncluded(self, included: bool) -> None: ...
    def leading(self) -> float: ...
    def position(self) -> QtCore.QPointF: ...
    def draw(self, painter: QPainter, position: typing.Union[QtCore.QPointF, QtCore.QPoint], selection: typing.Optional[QTextLayout.FormatRange] = ...) -> None: ...
    def lineNumber(self) -> int: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def setNumColumns(self, columns: int) -> None: ...
    @overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    def xToCursor(self, x: float, edge: int = ...) -> int: ...
    def cursorToX(self, cursorPos: int, edge: int = ...) -> typing.Tuple[float, int]: ...
    def naturalTextRect(self) -> QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def width(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def rect(self) -> QtCore.QRectF: ...
    def isValid(self) -> bool: ...


class QTextObject(QtCore.QObject):

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def objectIndex(self) -> int: ...
    def document(self) -> QTextDocument: ...
    def formatIndex(self) -> int: ...
    def format(self) -> QTextFormat: ...
    def setFormat(self, format: QTextFormat) -> None: ...


class QTextBlockGroup(QTextObject):

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def blockList(self) -> typing.List[QTextBlock]: ...
    def blockFormatChanged(self, block: QTextBlock) -> None: ...
    def blockRemoved(self, block: QTextBlock) -> None: ...
    def blockInserted(self, block: QTextBlock) -> None: ...


class QTextList(QTextBlockGroup):

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def setFormat(self, aformat: QTextListFormat) -> None: ...
    def format(self) -> QTextListFormat: ...
    def add(self, block: QTextBlock) -> None: ...
    def remove(self, a0: QTextBlock) -> None: ...
    def removeItem(self, i: int) -> None: ...
    def itemText(self, a0: QTextBlock) -> str: ...
    def itemNumber(self, a0: QTextBlock) -> int: ...
    def item(self, i: int) -> QTextBlock: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...


class QTextFrame(QTextObject):

    class iterator:

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, o: QTextFrame.iterator) -> None: ...

        def atEnd(self) -> bool: ...
        def currentBlock(self) -> QTextBlock: ...
        def currentFrame(self) -> QTextFrame: ...
        def parentFrame(self) -> QTextFrame: ...

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def setFrameFormat(self, aformat: QTextFrameFormat) -> None: ...
    def end(self) -> QTextFrame.iterator: ...
    def begin(self) -> QTextFrame.iterator: ...
    def parentFrame(self) -> QTextFrame: ...
    def childFrames(self) -> typing.List[QTextFrame]: ...
    def lastPosition(self) -> int: ...
    def firstPosition(self) -> int: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def frameFormat(self) -> QTextFrameFormat: ...


class QTextBlock(sip.wrapper):

    class iterator:

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, o: QTextBlock.iterator) -> None: ...

        def atEnd(self) -> bool: ...
        def fragment(self) -> QTextFragment: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: QTextBlock) -> None: ...

    def textFormats(self) -> typing.List[QTextLayout.FormatRange]: ...
    def textDirection(self) -> int: ...
    def lineCount(self) -> int: ...
    def setLineCount(self, count: int) -> None: ...
    def firstLineNumber(self) -> int: ...
    def blockNumber(self) -> int: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setRevision(self, rev: int) -> None: ...
    def revision(self) -> int: ...
    def clearLayout(self) -> None: ...
    def setUserState(self, state: int) -> None: ...
    def userState(self) -> int: ...
    def setUserData(self, data: QTextBlockUserData) -> None: ...
    def userData(self) -> QTextBlockUserData: ...
    def previous(self) -> QTextBlock: ...
    def next(self) -> QTextBlock: ...
    def end(self) -> QTextBlock.iterator: ...
    def begin(self) -> QTextBlock.iterator: ...
    def textList(self) -> QTextList: ...
    def document(self) -> QTextDocument: ...
    def text(self) -> str: ...
    def charFormatIndex(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockFormat(self) -> QTextBlockFormat: ...
    def layout(self) -> QTextLayout: ...
    def contains(self, position: int) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextFragment(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: QTextFragment) -> None: ...

    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[QGlyphRun]: ...
    def text(self) -> str: ...
    def charFormatIndex(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def contains(self, position: int) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextBlockUserData(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTextBlockUserData) -> None: ...


class QTextOption(sip.simplewrapper):

    TabType: typing.Type[int]
    #class TabType(int): ...
    LeftTab = ... # type: int
    RightTab = ... # type: int
    CenterTab = ... # type: int
    DelimiterTab = ... # type: int

    Flag: typing.Type[int]
    #class Flag(int): ...
    IncludeTrailingSpaces = ... # type: int
    ShowTabsAndSpaces = ... # type: int
    ShowLineAndParagraphSeparators = ... # type: int
    AddSpaceForLineAndParagraphSeparators = ... # type: int
    SuppressColors = ... # type: int
    ShowDocumentTerminator = ... # type: int

    WrapMode: typing.Type[int]
    #class WrapMode(int): ...
    NoWrap = ... # type: int
    WordWrap = ... # type: int
    ManualWrap = ... # type: int
    WrapAnywhere = ... # type: int
    WrapAtWordBoundaryOrAnywhere = ... # type: int

    Flags: typing.Type[int]
    #class Flags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTextOption.Flags, QTextOption.Flag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTextOption.Flags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTextOption.Flags: ...
        #def __int__(self) -> int: ...

    class Tab:

        delimiter = ... # type: str
        position = ... # type: float
        type = ... # type: int

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, pos: float, tabType: int, delim: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QTextOption.Tab) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alignment: typing.Union[int, int]) -> None: ...
    @overload
    def __init__(self, o: QTextOption) -> None: ...

    def tabStopDistance(self) -> float: ...
    def setTabStopDistance(self, tabStopDistance: float) -> None: ...
    def tabs(self) -> typing.List[QTextOption.Tab]: ...
    def setTabs(self, tabStops: typing.Iterable[QTextOption.Tab]) -> None: ...
    def setTabStop(self, atabStop: float) -> None: ...
    def setFlags(self, flags: typing.Union[int, int]) -> None: ...
    def setAlignment(self, aalignment: typing.Union[int, int]) -> None: ...
    def useDesignMetrics(self) -> bool: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def tabArray(self) -> typing.List[float]: ...
    def setTabArray(self, tabStops: typing.Iterable[float]) -> None: ...
    def tabStop(self) -> float: ...
    def flags(self) -> int: ...
    def wrapMode(self) -> int: ...
    def setWrapMode(self, wrap: int) -> None: ...
    def textDirection(self) -> int: ...
    def setTextDirection(self, aDirection: int) -> None: ...
    def alignment(self) -> int: ...


class QTextTableCell(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: QTextTableCell) -> None: ...

    def tableCellFormatIndex(self) -> int: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def isValid(self) -> bool: ...
    def columnSpan(self) -> int: ...
    def rowSpan(self) -> int: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def setFormat(self, format: QTextCharFormat) -> None: ...
    def format(self) -> QTextCharFormat: ...


class QTextTable(QTextFrame):

    def __init__(self, doc: QTextDocument, **props) -> None: ...

    def appendColumns(self, count: int) -> None: ...
    def appendRows(self, count: int) -> None: ...
    def setFormat(self, aformat: QTextTableFormat) -> None: ...
    def format(self) -> QTextTableFormat: ...
    def rowEnd(self, c: QTextCursor) -> QTextCursor: ...
    def rowStart(self, c: QTextCursor) -> QTextCursor: ...
    @overload
    def cellAt(self, row: int, col: int) -> QTextTableCell: ...
    @overload
    def cellAt(self, position: int) -> QTextTableCell: ...
    @overload
    def cellAt(self, c: QTextCursor) -> QTextTableCell: ...
    def columns(self) -> int: ...
    def rows(self) -> int: ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @overload
    def mergeCells(self, cursor: QTextCursor) -> None: ...
    def removeColumns(self, pos: int, num: int) -> None: ...
    def removeRows(self, pos: int, num: int) -> None: ...
    def insertColumns(self, pos: int, num: int) -> None: ...
    def insertRows(self, pos: int, num: int) -> None: ...
    def resize(self, rows: int, cols: int) -> None: ...


class QTouchDevice(sip.simplewrapper):

    CapabilityFlag: typing.Type[int]
    #class CapabilityFlag(int): ...
    Position = ... # type: int
    Area = ... # type: int
    Pressure = ... # type: int
    Velocity = ... # type: int
    RawPositions = ... # type: int
    NormalizedPosition = ... # type: int
    MouseEmulation = ... # type: int

    DeviceType: typing.Type[int]
    #class DeviceType(int): ...
    TouchScreen = ... # type: int
    TouchPad = ... # type: int

    Capabilities: typing.Type[int]
    #class Capabilities(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QTouchDevice.Capabilities, QTouchDevice.CapabilityFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QTouchDevice.Capabilities) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QTouchDevice.Capabilities: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QTouchDevice) -> None: ...

    def setMaximumTouchPoints(self, max: int) -> None: ...
    def maximumTouchPoints(self) -> int: ...
    def setCapabilities(self, caps: typing.Union[int, int]) -> None: ...
    def setType(self, devType: int) -> None: ...
    def setName(self, name: str) -> None: ...
    def capabilities(self) -> int: ...
    def type(self) -> int: ...
    def name(self) -> str: ...
    @staticmethod
    def devices() -> typing.List[QTouchDevice]: ...


class QTransform(sip.simplewrapper):

    TransformationType: typing.Type[int]
    #class TransformationType(int): ...
    TxNone = ... # type: int
    TxTranslate = ... # type: int
    TxScale = ... # type: int
    TxRotate = ... # type: int
    TxShear = ... # type: int
    TxProject = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float = ...) -> None: ...
    @overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float) -> None: ...
    @overload
    def __init__(self, other: QTransform) -> None: ...

    def __hash__(self) -> int: ...
    @staticmethod
    def fromScale(dx: float, dy: float) -> QTransform: ...
    @staticmethod
    def fromTranslate(dx: float, dy: float) -> QTransform: ...
    def dy(self) -> float: ...
    def dx(self) -> float: ...
    def m33(self) -> float: ...
    def m32(self) -> float: ...
    def m31(self) -> float: ...
    def m23(self) -> float: ...
    def m22(self) -> float: ...
    def m21(self) -> float: ...
    def m13(self) -> float: ...
    def m12(self) -> float: ...
    def m11(self) -> float: ...
    def determinant(self) -> float: ...
    def isTranslating(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isAffine(self) -> bool: ...
    @overload
    def mapRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    @overload
    def mapRect(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapToPolygon(self, r: QtCore.QRect) -> QPolygon: ...
    @overload
    def map(self, x: int, y: int) -> typing.Tuple[int, int]: ...
    @overload
    def map(self, x: float, y: float) -> typing.Tuple[float, float]: ...
    @overload
    def map(self, p: QtCore.QPoint) -> QtCore.QPoint: ...
    @overload
    def map(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @overload
    def map(self, l: QtCore.QLine) -> QtCore.QLine: ...
    @overload
    def map(self, l: QtCore.QLineF) -> QtCore.QLineF: ...
    @overload
    def map(self, a: QPolygonF) -> QPolygonF: ...
    @overload
    def map(self, a: QPolygon) -> QPolygon: ...
    @overload
    def map(self, r: QRegion) -> QRegion: ...
    @overload
    def map(self, p: QPainterPath) -> QPainterPath: ...
    def reset(self) -> None: ...
    @staticmethod
    def quadToQuad(one: QPolygonF, two: QPolygonF, result: QTransform) -> bool: ...
    @staticmethod
    def quadToSquare(quad: QPolygonF, result: QTransform) -> bool: ...
    @staticmethod
    def squareToQuad(square: QPolygonF, result: QTransform) -> bool: ...
    def rotateRadians(self, angle: float, axis: int = ...) -> QTransform: ...
    def rotate(self, angle: float, axis: int = ...) -> QTransform: ...
    def shear(self, sh: float, sv: float) -> QTransform: ...
    def scale(self, sx: float, sy: float) -> QTransform: ...
    def translate(self, dx: float, dy: float) -> QTransform: ...
    def transposed(self) -> QTransform: ...
    def adjoint(self) -> QTransform: ...
    def inverted(self) -> typing.Tuple[QTransform, bool]: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float) -> None: ...
    def type(self) -> int: ...


class QValidator(QtCore.QObject):

    changed: PYQT_SIGNAL

    State: typing.Type[int]
    #class State(int): ...
    Invalid = ... # type: int
    Intermediate = ... # type: int
    Acceptable = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def changed(self) -> None: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def fixup(self, a0: str) -> str: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple[int, str, int]: ...


class QIntValidator(QValidator):

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, bottom: int, top: int, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def top(self) -> int: ...
    def bottom(self) -> int: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, a0: int) -> None: ...
    def setBottom(self, a0: int) -> None: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple[int, str, int]: ...


class QDoubleValidator(QValidator):

    Notation: typing.Type[int]
    #class Notation(int): ...
    StandardNotation = ... # type: int
    ScientificNotation = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def notation(self) -> int: ...
    def setNotation(self, a0: int) -> None: ...
    def decimals(self) -> int: ...
    def top(self) -> float: ...
    def bottom(self) -> float: ...
    def setDecimals(self, a0: int) -> None: ...
    def setTop(self, a0: float) -> None: ...
    def setBottom(self, a0: float) -> None: ...
    def setRange(self, minimum: float, maximum: float, decimals: int = ...) -> None: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple[int, str, int]: ...


class QRegExpValidator(QValidator):

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, rx: QtCore.QRegExp, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def regExp(self) -> QtCore.QRegExp: ...
    def setRegExp(self, rx: QtCore.QRegExp) -> None: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...


class QRegularExpressionValidator(QValidator):

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, re: QtCore.QRegularExpression, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setRegularExpression(self, re: QtCore.QRegularExpression) -> None: ...
    def regularExpression(self) -> QtCore.QRegularExpression: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[int, str, int]: ...


class QVector2D(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float) -> None: ...
    @overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, vector: QVector3D) -> None: ...
    @overload
    def __init__(self, vector: QVector4D) -> None: ...
    @overload
    def __init__(self, a0: QVector2D) -> None: ...

    def __neg__(self) -> QVector2D: ...
    def __getitem__(self, i: int) -> float: ...
    def distanceToLine(self, point: QVector2D, direction: QVector2D) -> float: ...
    def distanceToPoint(self, point: QVector2D) -> float: ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector4D(self) -> QVector4D: ...
    def toVector3D(self) -> QVector3D: ...
    @staticmethod
    def dotProduct(v1: QVector2D, v2: QVector2D) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector2D: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QVector3D(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...
    @overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, vector: QVector2D) -> None: ...
    @overload
    def __init__(self, vector: QVector2D, zpos: float) -> None: ...
    @overload
    def __init__(self, vector: QVector4D) -> None: ...
    @overload
    def __init__(self, a0: QVector3D) -> None: ...

    def __neg__(self) -> QVector3D: ...
    def unproject(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QtCore.QRect) -> QVector3D: ...
    def project(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QtCore.QRect) -> QVector3D: ...
    def __getitem__(self, i: int) -> float: ...
    def distanceToPoint(self, point: QVector3D) -> float: ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector4D(self) -> QVector4D: ...
    def toVector2D(self) -> QVector2D: ...
    def distanceToLine(self, point: QVector3D, direction: QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane: QVector3D, normal: QVector3D) -> float: ...
    @overload
    def distanceToPlane(self, plane1: QVector3D, plane2: QVector3D, plane3: QVector3D) -> float: ...
    @overload
    @staticmethod
    def normal(v1: QVector3D, v2: QVector3D) -> QVector3D: ...
    @overload
    @staticmethod
    def normal(v1: QVector3D, v2: QVector3D, v3: QVector3D) -> QVector3D: ...
    @staticmethod
    def crossProduct(v1: QVector3D, v2: QVector3D) -> QVector3D: ...
    @staticmethod
    def dotProduct(v1: QVector3D, v2: QVector3D) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector3D: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QVector4D(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...
    @overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @overload
    def __init__(self, vector: QVector2D) -> None: ...
    @overload
    def __init__(self, vector: QVector2D, zpos: float, wpos: float) -> None: ...
    @overload
    def __init__(self, vector: QVector3D) -> None: ...
    @overload
    def __init__(self, vector: QVector3D, wpos: float) -> None: ...
    @overload
    def __init__(self, a0: QVector4D) -> None: ...

    def __neg__(self) -> QVector4D: ...
    def __getitem__(self, i: int) -> float: ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setW(self, aW: float) -> None: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def w(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector3DAffine(self) -> QVector3D: ...
    def toVector3D(self) -> QVector3D: ...
    def toVector2DAffine(self) -> QVector2D: ...
    def toVector2D(self) -> QVector2D: ...
    @staticmethod
    def dotProduct(v1: QVector4D, v2: QVector4D) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> QVector4D: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


def qIsGray(rgb: int) -> bool: ...
@overload
def qGray(r: int, g: int, b: int) -> int: ...
@overload
def qGray(rgb: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
@overload
def qAlpha(rgb: QRgba64) -> int: ...
@overload
def qAlpha(rgb: int) -> int: ...
@overload
def qBlue(rgb: QRgba64) -> int: ...
@overload
def qBlue(rgb: int) -> int: ...
@overload
def qGreen(rgb: QRgba64) -> int: ...
@overload
def qGreen(rgb: int) -> int: ...
@overload
def qRed(rgb: QRgba64) -> int: ...
@overload
def qRed(rgb: int) -> int: ...
@overload
def qUnpremultiply(c: QRgba64) -> QRgba64: ...
@overload
def qUnpremultiply(p: int) -> int: ...
@overload
def qPremultiply(c: QRgba64) -> QRgba64: ...
@overload
def qPremultiply(x: int) -> int: ...
@overload
def qRgba64(r: int, g: int, b: int, a: int) -> QRgba64: ...
@overload
def qRgba64(c: int) -> QRgba64: ...
def qPixelFormatAlpha(channelSize: int, typeInterpretation: int = ...) -> QPixelFormat: ...
def qPixelFormatYuv(layout: int, alphaSize: int = ..., alphaUsage: int = ..., alphaPosition: int = ..., premultiplied: int = ..., typeInterpretation: int = ..., byteOrder: int = ...) -> QPixelFormat: ...
def qPixelFormatHsv(channelSize: int, alphaSize: int = ..., alphaUsage: int = ..., alphaPosition: int = ..., typeInterpretation: int = ...) -> QPixelFormat: ...
def qPixelFormatHsl(channelSize: int, alphaSize: int = ..., alphaUsage: int = ..., alphaPosition: int = ..., typeInterpretation: int = ...) -> QPixelFormat: ...
def qPixelFormatCmyk(channelSize: int, alphaSize: int = ..., alphaUsage: int = ..., alphaPosition: int = ..., typeInterpretation: int = ...) -> QPixelFormat: ...
def qPixelFormatGrayscale(channelSize: int, typeInterpretation: int = ...) -> QPixelFormat: ...
def qPixelFormatRgba(red: int, green: int, blue: int, alfa: int, usage: int, position: int, premultiplied: int = ..., typeInterpretation: int = ...) -> QPixelFormat: ...
@overload
def qFuzzyCompare(m1: QMatrix4x4, m2: QMatrix4x4) -> bool: ...
@overload
def qFuzzyCompare(q1: QQuaternion, q2: QQuaternion) -> bool: ...
@overload
def qFuzzyCompare(t1: QTransform, t2: QTransform) -> bool: ...
@overload
def qFuzzyCompare(v1: QVector2D, v2: QVector2D) -> bool: ...
@overload
def qFuzzyCompare(v1: QVector3D, v2: QVector3D) -> bool: ...
@overload
def qFuzzyCompare(v1: QVector4D, v2: QVector4D) -> bool: ...
def qt_set_sequence_auto_mnemonic(b: bool) -> None: ...
