# bwa

> Burrows-Wheeler 정렬 도구.
> 짧고 낮은 발산율의 DNA 서열을 인간 유전체와 같은 대형 참조 유전체에 매핑합니다.
> 더 많은 정보: <https://manned.org/bwa>.

- 참조 유전체 색인 생성:

`bwa index {{경로/대상/참조.fa}}`

- 단일 엔드 읽기(서열)를 색인된 유전체에 32 [t]스레드를 사용하여 매핑하고 결과를 압축하여 공간 절약:

`bwa mem -t 32 {{경로/대상/참조.fa}} {{경로/대상/단일_엔드_읽기.fq.gz}} | gzip > {{경로/대상/정렬_단일_엔드.sam.gz}}`

- 쌍 엔드 읽기(서열)를 색인된 유전체에 32 [t]스레드를 사용하여 매핑하고 결과를 압축하여 공간 절약:

`bwa mem -t 32 {{경로/대상/참조.fa}} {{경로/대상/쌍_엔드_읽기_1.fq.gz}} {{경로/대상/쌍_엔드_읽기_2.fq.gz}} | gzip > {{경로/대상/정렬_쌍_엔드.sam.gz}}`

- Picard 소프트웨어의 출력 SAM 파일 호환성을 위해 짧은 분할 히트를 보조로 [M]표시하여 쌍 엔드 읽기(서열)를 색인된 유전체에 32 [t]스레드를 사용하여 매핑하고 결과를 압축:

`bwa mem -M -t 32 {{경로/대상/참조.fa}} {{경로/대상/쌍_엔드_읽기_1.fq.gz}} {{경로/대상/쌍_엔드_읽기_2.fq.gz}} | gzip > {{경로/대상/정렬_쌍_엔드.sam.gz}}`

- FASTA/Q [C]주석(예: BC:Z:CGTAC)을 압축된 결과에 추가하여 쌍 엔드 읽기(서열)를 색인된 유전체에 32 [t]스레드를 사용하여 매핑:

`bwa mem -C -t 32 {{경로/대상/참조.fa}} {{경로/대상/쌍_엔드_읽기_1.fq.gz}} {{경로/대상/쌍_엔드_읽기_2.fq.gz}} | gzip > {{경로/대상/정렬_쌍_엔드.sam.gz}}`
