<?php
/**
 * File containing the ezcWebdavPropFindResponse class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Webdav
 * @version //autogentag//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 */
/**
 * Class generated by the backend to respond to MKCOL requests.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavPropFindRequest} it might react with an instance of {@link
 * ezcWebdavPropFindResponse} or with producing an error.
 *
 * @property ezcWebdavResource|ezcWebdavCollection $node
 *           Contains the resource affected by the response.
 * @property array(ezcWebdavPropStatResponse)      $responses
 *           Contains a list of propstat responses for the node.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavPropFindResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     *
     * The response is constructed from either a {@link ezcWebdavCollection} or
     * a {@link ezcWebdavResource} as the first parameter and a finite amount
     * of {@link ezcWebdavPropStatResponse}s as additional parameters.
     * 
     * @param ezcWebdavResource|ezcWebdavCollection $node
     * @return void
     */
    public function __construct( $node )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );
        $this->node = $node;

        // Add all ezcWebdavPropStatResponse
        $params = func_get_args();
        $responses = array();

        foreach ( $params as $nr => $param )
        {
            // Flatten array structure, if given
            if ( is_array( $param ) )
            {
                foreach ( $param as $value )
                {
                    if ( $value instanceof ezcWebdavPropStatResponse )
                    {
                        $responses[] = $value;
                    }
                }

                continue;
            }

            // Also add plain params
            if ( $param instanceof ezcWebdavPropStatResponse )
            {
                $responses[] = $param;
            }
        }

        // If it actually consists of multiple sub responses be of type 207.
        if ( count( $responses ) > 0 )
        {
            $this->status = ezcWebdavResponse::STATUS_207;
        }

        $this->responses = $responses;
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'node':
                if ( ( ! $propertyValue instanceof ezcWebdavResource ) &&
                     ( ! $propertyValue instanceof ezcWebdavCollection ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavResource or ezcWebdavCollection' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            case 'responses':
                if ( !is_array( $propertyValue ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'array(ezcWebdavPropStatResponse)' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
