<?php
/**
 * File containing the ezcWebdavGetCollectionResponse class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Webdav
 * @version //autogentag//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 */
/**
 * Class generated by the backend to respond to GET requests on collection resources.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavGetRequest} it might react with an instance of {@link
 * ezcWebdavGetResourceResponse} for non-collection resources or {@link
 * ezcWebdavGetCollectionResponse} for collection resources or by producing an
 * error.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavGetCollectionResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     * 
     * Creates a new repsonse object for the given $collection resource.
     * 
     * @param ezcWebdavCollection $collection 
     * @return void
     */
    public function __construct( ezcWebdavCollection $collection )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );

        $this->collection = $collection;
        $this->setHeader( 'Content-Length', '4096' );
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'collection':
                if ( ! $propertyValue instanceof ezcWebdavCollection )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavCollection' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
