<?php
/**
 * File containing the ezcWebdavLockResponse class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Webdav
 * @version //autogentag//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 *
 * @access private
 */
/**
 * Class generated by the lock plugin to respond to LOCK requests.
 *
 * If a {@link ezcWebdavLockPlugin} receives an instance of {@link
 * ezcWebdavLockRequest} it might react with an instance of {@link
 * ezcWebdavLockResponse} or with producing an error.
 *
 * @property ezcWebdavLockDiscoveryProperty $lockDiscovery
 *           Lock discovery property to the ressource targeted by the LOCK
 *           request, including the newly created or updated active lock part.
 *
 * @version //autogentag//
 * @package Webdav
 *
 * @access private
 */
class ezcWebdavLockResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     *
     * Creates a new LOCK response object using the given $lockDiscovery
     * property. If the $lockToken parameter is not null, the response will
     * have the Lock-Token header set, which must not occur for refreshing of
     * locks, but must occur for new locks.
     * 
     * @param ezcWebdavLockDiscoveryProperty $lockDiscovery 
     * @param int $status Constant ezcWebdavResponse::STATUS_*
     * @param string $lockToken
     */
    public function __construct(
        ezcWebdavLockDiscoveryProperty $lockDiscovery,
        $status = ezcWebdavResponse::STATUS_200,
        $lockToken = null
    )
    {
        parent::__construct( $status );
        $this->lockDiscovery = $lockDiscovery;
        
        if ( $lockToken !== null )
        {
            $this->setHeader( 'Lock-Token', $lockToken );
        }
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'lockDiscovery':
                if ( ( ! $propertyValue instanceof ezcWebdavLockDiscoveryProperty ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavLockDiscoveryProperty' );
                }
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }

        $this->properties[$propertyName] = $propertyValue;
    }
}

?>
