<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: tiki-error_simple.php 67689 2018-09-26 17:04:15Z jonnybradley $

require_once 'tiki-filter-base.php';
$filter = \TikiFilter::get('xss');

if (! empty($_REQUEST['error'])) {
	$error = $filter->filter(substr($_REQUEST["error"], 0, 256));
} else {
	$error = 'There was an unspecified error.  Please go back and try again.';
}
if (! empty($_REQUEST['title'])) {
	$title = $filter->filter($_REQUEST['title']);
} else {
	$title = 'Maintenance';
}

session_start();
$ticket = strtr(str_replace('=', '', base64_encode(\phpseclib\Crypt\Random::string(32))), '+/', '-_');
$_SESSION['tickets'][$ticket] = time();

$login = '<form name="loginbox" action="tiki-login.php?page=tikiIndex" method="post"><table><tr><td>' .
	'User:</td><td><input type="text" name="user"  size="20" /></td></tr><tr><td>' .
	'Pass:</td><td><input type="password" name="pass" size="20" /></td></tr><tr><td style="text-align: center;" colspan="2">'.
	'<input type="hidden" class="ticket" name="ticket" value="' . $ticket . '" /><input type="hidden" name="confirmForm" value="y" />'.
	'<input type="submit" name="login" value="login" class="btn btn-default" /></td></tr></table></form>';

$back = '<p><a href="javascript:history.back()">Go back</a></p>';

if (file_exists('themes/base_files/other/site_closed_local.html')) {
	$html = file_get_contents('themes/base_files/other/site_closed_local.html');
} else {
	$html = file_get_contents('themes/base_files/other/site_closed.html');
}

$html = str_replace('{error}', $error, $html);
$html = str_replace('{title}', $title, $html);
$html = str_replace('{login}', $login, $html);
$html = str_replace('{back}', $back, $html);

header("HTTP/1.0 503 Service Unavailable");

echo $html;
