<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: mod-func-last_image_galleries.php 66101 2018-04-19 18:03:14Z luciash $

//this script may only be included - so its better to die if called directly.
if (strpos($_SERVER["SCRIPT_NAME"], basename(__FILE__)) !== false) {
	header("location: index.php");
	exit;
}

/**
 * @return array
 */
function module_last_image_galleries_info()
{
	return [
		'name' => tra('Last-Modified Image Galleries'),
		'description' => tra('Displays the specified number of image galleries, starting from the most recently modified.'),
		'prefs' => ["feature_galleries"],
		'params' => [],
		'common_params' => ['nonums', 'rows']
	];
}

/**
 * @param $mod_reference
 * @param $module_params
 */
function module_last_image_galleries($mod_reference, $module_params)
{
	global $user;
	$smarty = TikiLib::lib('smarty');
	$imagegallib = TikiLib::lib('imagegal');
	$ranking = $imagegallib->list_visible_galleries(0, $mod_reference["rows"], 'lastModif_desc', $user, '');

	$smarty->assign('modLastGalleries', $ranking["data"]);
}
