<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: wikiplugin_list.php 67481 2018-09-15 18:19:59Z jonnybradley $

require_once 'lib/wiki/pluginslib.php';

function wikiplugin_list_info()
{
	return [
		'name' => tra('List'),
		'documentation' => 'PluginList',
		'description' => tra('Search for, list, and filter all types of items and display custom-formatted results.'),
		'prefs' => ['wikiplugin_list', 'feature_search'],
		'body' => tra('List configuration information'),
		'filter' => 'wikicontent',
		'profile_reference' => 'search_plugin_content',
		'iconname' => 'list',
		'introduced' => 7,
		'tags' => [ 'basic' ],
		'params' => [
			'searchable_only' => [
				'required' => false,
				'name' => tra('Searchable Only Results'),
				'description' => tra('Only include results marked as searchable in the index.'),
				'filter' => 'digits',
				'default' => '1',
				'options' => [
					['text' => tra(''), 'value' => ''],
					['text' => tra('Yes'), 'value' => '1'],
					['text' => tra('No'), 'value' => '0'],
				],
			],
			'gui' => [
				'required' => false,
				'name' => tra('Use List GUI'),
				'description' => tra('Use the graphical user interface for editing this list plugin.'),
				'filter' => 'digits',
				'default' => '1',
				'options' => [
					['text' => tra(''), 'value' => ''],
					['text' => tra('Yes'), 'value' => '1'],
					['text' => tra('No'), 'value' => '0'],
				],
			],
		],
	];
}

function wikiplugin_list($data, $params)
{
	global $prefs;

	static $i;
	$i++;

	if (! isset($params['gui'])) {
		$params['gui'] = 1;
	}

	if ($prefs['wikiplugin_list_gui'] === 'y' && $params['gui']) {
		TikiLib::lib('header')
			->add_jsfile('lib/jquery_tiki/pluginedit_list.js')
			->add_jsfile('vendor_bundled/vendor/jquery/plugins/nestedsortable/jquery.ui.nestedSortable.js');
	}

	$unifiedsearchlib = TikiLib::lib('unifiedsearch');

	$query = new Search_Query;
	if (! isset($params['searchable_only']) || $params['searchable_only'] == 1) {
		$query->filterIdentifier('y', 'searchable');
	}
	$unifiedsearchlib->initQuery($query);

	$matches = WikiParser_PluginMatcher::match($data);

	$builder = new Search_Query_WikiBuilder($query);
	$builder->enableAggregate();
	$builder->apply($matches);
	$tsret = $builder->applyTablesorter($matches);
	if (! empty($tsret['max']) || ! empty($_GET['numrows'])) {
		$max = ! empty($_GET['numrows']) ? $_GET['numrows'] : $tsret['max'];
		$builder->wpquery_pagination_max($query, $max);
	}
	$paginationArguments = $builder->getPaginationArguments();

	if (! empty($_REQUEST[$paginationArguments['sort_arg']])) {
		$query->setOrder($_REQUEST[$paginationArguments['sort_arg']]);
	}

	if (! $index = $unifiedsearchlib->getIndex()) {
		return '';
	}

	PluginsLibUtil::handleDownload($query, $index, $matches);

	$result = $query->search($index);

	$result->setId('wplist-' . $i);

	$resultBuilder = new Search_ResultSet_WikiBuilder($result);
	$resultBuilder->setPaginationArguments($paginationArguments);
	$resultBuilder->apply($matches);

	$builder = new Search_Formatter_Builder;
	$builder->setPaginationArguments($paginationArguments);
	$builder->setId('wplist-' . $i);
	$builder->setCount($result->count());
	$builder->setTsOn($tsret['tsOn']);
	$builder->apply($matches);

	$result->setTsSettings($builder->getTsSettings());

	$formatter = $builder->getFormatter();

	$result->setTsOn($tsret['tsOn']);
	$out = $formatter->format($result);

	return $out;
}
