<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: function.module.php 66113 2018-04-19 18:52:11Z luciash $

function smarty_function_module($params, $smarty)
{
	static $instance = 0;

	$instance++;
	if (empty($params['moduleId'])) {
		$moduleId = 'wikiplugin_' . $instance;
	} else {
		$moduleId = $params['moduleId'];
	}

	if (empty($params['module'])) {
		return tr("Missing %0 parameter", 'module');
	}

	$module_reference = [
		'moduleId' => $moduleId,
		'name' => $params['module'],
		'params' => $params,
		'rows' => 10,
		'position' => null,
		'ord' => null,
		'cache_time' => 0,
	];

	foreach (['module_style', 'rows'] as $key) {
		if (! empty($params[$key])) {
			$module_reference[$key] = $params[$key];
		}
	}

	$modlib = TikiLib::lib('mod');
	return $modlib->execute_module($module_reference);
}
