<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: Exception.php 66108 2018-04-19 18:17:22Z luciash $

class TikiDb_Exception extends Exception
{
	public static function classify($error)
	{
		if (preg_match('/^Duplicate entry \'(?P<entry>.*)\' for key \'(?P<key>.*)\'$/', $error, $parts)) {
			throw new TikiDb_Exception_DuplicateEntry($parts['key'], $parts['entry']);
		} else {
			throw new self($error);
		}
	}
}
