/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.ArraySize;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;
import org.mvel2.util.ReflectionUtil;

public class TypeDescriptor
implements Serializable {
    private String className;
    private char[] expr;
    private int start;
    private int offset;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    int endRange;

    public TypeDescriptor(char[] name, int start, int offset, int fields2) {
        this.expr = name;
        this.start = start;
        this.offset = offset;
        this.updateClassName(name, this.start, this.offset, fields2);
    }

    public void updateClassName(char[] name, int start, int offset, int fields2) {
        this.expr = name;
        if (offset == 0 || !ParseTools.isIdentifierPart(name[start]) || Character.isDigit(name[start])) {
            return;
        }
        this.endRange = ArrayTools.findFirst('(', start, offset, name);
        if (this.endRange == -1) {
            this.endRange = ArrayTools.findFirst('[', start, offset, name);
            if (this.endRange != -1) {
                int i;
                this.className = new String(name, start, this.endRange - start).trim();
                LinkedList<char[]> sizes = new LinkedList<char[]>();
                int end = start + offset;
                while (this.endRange < end) {
                    while (this.endRange < end && ParseTools.isWhitespace(name[this.endRange])) {
                        ++this.endRange;
                    }
                    if (this.endRange == end || name[this.endRange] == '{') break;
                    if (name[this.endRange] != '[') {
                        throw new CompileException("unexpected token in constructor", name, this.endRange);
                    }
                    int to = ParseTools.balancedCapture(name, this.endRange, start + offset, '[');
                    sizes.add(ParseTools.subset(name, ++this.endRange, to - this.endRange));
                    this.endRange = to + 1;
                }
                Iterator iter = sizes.iterator();
                this.arraySize = new ArraySize[sizes.size()];
                for (i = 0; i < this.arraySize.length; ++i) {
                    this.arraySize[i] = new ArraySize((char[])iter.next());
                }
                if ((fields2 & 0x10) != 0) {
                    this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                    for (i = 0; i < this.compiledArraySize.length; ++i) {
                        this.compiledArraySize[i] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[i].value);
                    }
                }
                return;
            }
            this.className = new String(name, start, offset).trim();
        } else {
            this.className = new String(name, start, this.endRange - start).trim();
        }
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public int getArrayLength() {
        return this.arraySize.length;
    }

    public ArraySize[] getArraySize() {
        return this.arraySize;
    }

    public ExecutableStatement[] getCompiledArraySize() {
        return this.compiledArraySize;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClass() {
        return this.className != null && this.className.length() != 0;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int endRange) {
        this.endRange = endRange;
    }

    public Class<?> getClassReference() throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(null, this);
    }

    public Class<?> getClassReference(ParserContext ctx) throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(ctx, this);
    }

    public static Class getClassReference(Class baseType, TypeDescriptor tDescr, VariableResolverFactory factory, ParserContext ctx) throws ClassNotFoundException {
        return ParseTools.findClass(factory, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + baseType.getName() + ";", ctx);
    }

    public static Class getClassReference(ParserContext ctx, Class cls, TypeDescriptor tDescr) throws ClassNotFoundException {
        if (tDescr.isArray()) {
            cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
        }
        return cls;
    }

    public static Class getClassReference(ParserContext ctx, TypeDescriptor tDescr) throws ClassNotFoundException {
        Class cls;
        if (ctx != null && ctx.hasImport(tDescr.className)) {
            cls = ctx.getImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else if (ctx == null && TypeDescriptor.hasContextFreeImport(tDescr.className)) {
            cls = TypeDescriptor.getContextFreeImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else {
            cls = ParseTools.createClass(tDescr.getClassName(), ctx);
            if (tDescr.isArray()) {
                cls = cls.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(cls) : ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        }
        return cls;
    }

    public boolean isUndimensionedArray() {
        if (this.arraySize != null) {
            for (ArraySize anArraySize : this.arraySize) {
                if (anArraySize.value.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasContextFreeImport(String name) {
        return AbstractParser.LITERALS.containsKey(name) && AbstractParser.LITERALS.get(name) instanceof Class;
    }

    public static Class getContextFreeImport(String name) {
        return (Class)AbstractParser.LITERALS.get(name);
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.offset;
    }
}

