/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.configuration;

import com.charleskorn.kaml.Yaml;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.configuration.ConfigurationUtils;
import org.islandoftex.arara.configuration.LocalConfiguration;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.model.FileType;
import org.islandoftex.arara.utils.CommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0 R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/islandoftex/arara/configuration/ConfigurationUtils;", "", "()V", "applicationPath", "Ljava/nio/file/Path;", "getApplicationPath", "()Ljava/nio/file/Path;", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "defaultFileTypePatterns", "", "", "getDefaultFileTypePatterns", "()Ljava/util/Map;", "defaultFileTypes", "", "Lorg/islandoftex/arara/model/FileType;", "getDefaultFileTypes", "()Ljava/util/Set;", "defaultFileTypes$delegate", "Lkotlin/Lazy;", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "cleanFileName", "name", "loadLocalConfiguration", "Lorg/islandoftex/arara/configuration/LocalConfiguration;", "file", "normalizeFileTypes", "types", "", "normalizePaths", "paths", "application"})
public final class ConfigurationUtils {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final LanguageController messages;
    @NotNull
    private static final Map<String, String> defaultFileTypePatterns;
    @NotNull
    private static final Lazy defaultFileTypes$delegate;
    public static final ConfigurationUtils INSTANCE;

    static {
        ConfigurationUtils configurationUtils;
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(ConfigurationUtils.class), "defaultFileTypes", "getDefaultFileTypes()Ljava/util/Set;"))};
        INSTANCE = configurationUtils = new ConfigurationUtils();
        messages = LanguageController.INSTANCE;
        defaultFileTypePatterns = MapsKt.mapOf(TuplesKt.to("tex", "^\\s*%\\s+"), TuplesKt.to("dtx", "^\\s*%\\s+"), TuplesKt.to("ltx", "^\\s*%\\s+"), TuplesKt.to("drv", "^\\s*%\\s+"), TuplesKt.to("ins", "^\\s*%\\s+"));
        defaultFileTypes$delegate = LazyKt.lazy(defaultFileTypes.2.INSTANCE);
    }

    @NotNull
    public final Map<String, String> getDefaultFileTypePatterns() {
        return defaultFileTypePatterns;
    }

    @NotNull
    public final Set<FileType> getDefaultFileTypes() {
        Lazy lazy2 = defaultFileTypes$delegate;
        ConfigurationUtils configurationUtils = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Set)lazy2.getValue();
    }

    @Nullable
    public final File getConfigFile() {
        Object v0;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        File file2;
        String it;
        Collection collection;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        boolean bl;
        boolean bl2;
        Object object;
        List<String> names;
        block6: {
            names = CollectionsKt.listOf(".araraconfig.yaml", "araraconfig.yaml", ".arararc.yaml", "arararc.yaml");
            object = Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getWorkingDirectory());
            bl2 = false;
            bl = false;
            Path workingDir = (Path)object;
            boolean bl3 = false;
            $this$map$iv = names;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                file2 = workingDir.resolve(it).toFile();
                collection.add(file2);
            }
            $this$firstOrNull$iv = (List)destination$iv$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it2 = (File)element$iv;
                boolean bl5 = false;
                if (!it2.exists()) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        File first2 = v0;
        if (first2 != null) {
            return first2;
        }
        String string = CommonUtils.INSTANCE.getSystemPropertyOrNull("user.home");
        if (string != null) {
            Object v2;
            block7: {
                object = string;
                bl2 = false;
                bl = false;
                Object userHome = object;
                boolean bl6 = false;
                $this$map$iv = names;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator bl5 = $this$mapTo$iv$iv.iterator();
                while (bl5.hasNext()) {
                    item$iv$iv = bl5.next();
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    file2 = FilesKt.resolve(new File((String)userHome), it);
                    collection.add(file2);
                }
                $this$firstOrNull$iv = (List)destination$iv$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it3 = (File)element$iv;
                    boolean bl8 = false;
                    if (!it3.exists()) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            return v2;
        }
        return null;
    }

    @NotNull
    public final Path getApplicationPath() throws AraraException {
        try {
            ProtectionDomain protectionDomain = Arara.class.getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull(protectionDomain, "Arara::class.java.protectionDomain");
            CodeSource codeSource = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull(codeSource, "Arara::class.java.protectionDomain.codeSource");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull(uRL, "Arara::class.java.protec\u2026                .location");
            String path = uRL.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            Path path2 = Paths.get(new File(path).toURI());
            Intrinsics.checkExpressionValueIsNotNull(path2, "Paths.get(File(path).toURI())");
            Path path3 = path2.getParent().toAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(path3, "Paths.get(File(path).toU\u2026).parent.toAbsolutePath()");
            return path3;
        }
        catch (UnsupportedEncodingException exception) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_GETAPPLICATIONPATH_ENCODING_EXCEPTION), exception);
        }
    }

    @NotNull
    public final LocalConfiguration loadLocalConfiguration(@NotNull File file2) throws AraraException {
        Object object;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Object object2 = file2;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = object2;
            boolean bl2 = false;
            String text2 = FilesKt.readText$default((File)$this$runCatching, null, 1, null);
            if (!StringsKt.startsWith$default(text2, "!config", false, 2, null)) {
                throw (Throwable)new Exception("Configuration should start with !config");
            }
            $this$runCatching = (LocalConfiguration)Yaml.Companion.getDefault().parse(LocalConfiguration.Companion.serializer(), text2);
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_CONFIGURATION_GENERIC_ERROR), it);
        }
        return (LocalConfiguration)object2;
    }

    @NotNull
    public final Set<String> normalizePaths(@NotNull Iterable<String> paths2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(paths2, "paths");
        return CollectionsKt.union(paths2, (Iterable)AraraSpec.Execution.INSTANCE.getRulePaths().getDefault());
    }

    @NotNull
    public final Set<FileType> normalizeFileTypes(@NotNull Iterable<FileType> types) throws AraraException {
        Intrinsics.checkParameterIsNotNull(types, "types");
        return CollectionsKt.union(types, (Iterable)this.getDefaultFileTypes());
    }

    @NotNull
    public final String cleanFileName(@NotNull String name) {
        String string;
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string2 = new File(name).getName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "File(name).name");
        CharSequence charSequence = string2;
        boolean bl = false;
        String string3 = charSequence;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String result2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = result2;
        bl = false;
        if (charSequence.length() == 0) {
            string = "arara";
        } else {
            charSequence = result2;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim(charSequence2)).toString();
        }
        return string;
    }

    private ConfigurationUtils() {
    }
}

