/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ExceptionsConstuctorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007\u001a9\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\u0006\u0010\r\u001a\u0002H\n2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u000f2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u001a1\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u00192\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u001a+\u0010\u001f\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u001d\u001a\u0002H\n2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u00a2\u0006\u0002\u0010 \u001a\u001f\u0010!\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u001d\u001a\u0002H\nH\u0000\u00a2\u0006\u0002\u0010\"\u001a+\u0010!\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u001d\u001a\u0002H\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030#H\u0000\u00a2\u0006\u0002\u0010$\u001a\u001f\u0010%\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u001d\u001a\u0002H\nH\u0000\u00a2\u0006\u0002\u0010\"\u001a1\u0010&\u001a\u0018\u0012\u0004\u0012\u0002H\n\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u00190'\"\b\b\u0000\u0010\n*\u00020\u000b*\u0002H\nH\u0002\u00a2\u0006\u0002\u0010(\u001a\u001c\u0010)\u001a\u00020**\u00060\u0007j\u0002`\u00102\n\u0010+\u001a\u00060\u0007j\u0002`\u0010H\u0002\u001a#\u0010,\u001a\u00020-*\f\u0012\b\u0012\u00060\u0007j\u0002`\u00100\u00192\u0006\u0010.\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010/\u001a\u0014\u00100\u001a\u00020\u0017*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0010\u00101\u001a\u00020**\u00060\u0007j\u0002`\u0010H\u0000\u001a\u001b\u00102\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b*\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\"\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0003*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0003*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u00103\"\u00020\u00142\u00020\u0014*\f\b\u0000\u00104\"\u00020\u00072\u00020\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"baseContinuationImplClass", "", "baseContinuationImplClassName", "kotlin.jvm.PlatformType", "stackTraceRecoveryClass", "stackTraceRecoveryClassName", "artificialFrame", "Ljava/lang/StackTraceElement;", "message", "createFinalException", "E", "", "cause", "result", "resultStackTrace", "Ljava/util/ArrayDeque;", "Lkotlinx/coroutines/internal/StackTraceElement;", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/util/ArrayDeque;)Ljava/lang/Throwable;", "createStackTrace", "continuation", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/internal/CoroutineStackFrame;", "mergeRecoveredTraces", "", "recoveredStacktrace", "", "([Ljava/lang/StackTraceElement;Ljava/util/ArrayDeque;)V", "recoverAndThrow", "", "exception", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recoverFromStackFrame", "(Ljava/lang/Throwable;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/lang/Throwable;", "recoverStackTrace", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Throwable;", "unwrap", "causeAndStacktrace", "Lkotlin/Pair;", "(Ljava/lang/Throwable;)Lkotlin/Pair;", "elementWiseEquals", "", "e", "frameIndex", "", "methodName", "([Ljava/lang/StackTraceElement;Ljava/lang/String;)I", "initCause", "isArtificial", "sanitizeStackTrace", "CoroutineStackFrame", "StackTraceElement", "kotlinx-coroutines-core"})
public final class StackTraceRecoveryKt {
    private static final String baseContinuationImplClass = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
    private static final String stackTraceRecoveryClass = "kotlinx.coroutines.internal.StackTraceRecoveryKt";
    private static final String baseContinuationImplClassName;
    private static final String stackTraceRecoveryClassName;

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            return exception;
        }
        E e = ExceptionsConstuctorKt.tryCopyException(exception);
        if (e == null) {
            return exception;
        }
        E copy2 = e;
        return StackTraceRecoveryKt.sanitizeStackTrace(copy2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E sanitizeStackTrace(@NotNull E $this$sanitizeStackTrace) {
        StackTraceElement[] stackTrace = $this$sanitizeStackTrace.getStackTrace();
        int size = stackTrace.length;
        Intrinsics.checkExpressionValueIsNotNull(stackTrace, "stackTrace");
        String string = stackTraceRecoveryClassName;
        Intrinsics.checkExpressionValueIsNotNull(string, "stackTraceRecoveryClassName");
        int lastIntrinsic = StackTraceRecoveryKt.frameIndex(stackTrace, string);
        int startIndex = lastIntrinsic + 1;
        String string2 = baseContinuationImplClassName;
        Intrinsics.checkExpressionValueIsNotNull(string2, "baseContinuationImplClassName");
        int endIndex = StackTraceRecoveryKt.frameIndex(stackTrace, string2);
        int adjustment = endIndex == -1 ? 0 : size - endIndex;
        int n = size - lastIntrinsic - adjustment;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n];
        for (int i = 0; i < n; ++i) {
            void it;
            StackTraceElement stackTraceElement;
            int n2 = i;
            int n3 = i;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            boolean bl = false;
            stackTraceElementArray2[n3] = stackTraceElement = it == false ? StackTraceRecoveryKt.artificialFrame("Coroutine boundary") : stackTrace[startIndex + it - 1];
        }
        StackTraceElement[] trace = stackTraceElementArray;
        $this$sanitizeStackTrace.setStackTrace(trace);
        return $this$sanitizeStackTrace;
    }

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception, @NotNull Continuation<?> continuation2) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        if (!DebugKt.getRECOVER_STACK_TRACES() || !(continuation2 instanceof CoroutineStackFrame)) {
            return exception;
        }
        return StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)continuation2));
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E recoverFromStackFrame(E exception, CoroutineStackFrame continuation2) {
        void cause;
        Pair<E, StackTraceElement[]> pair2 = StackTraceRecoveryKt.causeAndStacktrace(exception);
        E e = pair2.component1();
        StackTraceElement[] recoveredStacktrace = pair2.component2();
        void v0 = ExceptionsConstuctorKt.tryCopyException(cause);
        if (v0 == null) {
            return exception;
        }
        void newException = v0;
        if (Intrinsics.areEqual(newException.getMessage(), cause.getMessage()) ^ true) {
            return exception;
        }
        ArrayDeque<StackTraceElement> stacktrace = StackTraceRecoveryKt.createStackTrace(continuation2);
        if (stacktrace.isEmpty()) {
            return exception;
        }
        if (cause != exception) {
            StackTraceRecoveryKt.mergeRecoveredTraces(recoveredStacktrace, stacktrace);
        }
        return StackTraceRecoveryKt.createFinalException(cause, newException, stacktrace);
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends Throwable> E createFinalException(E cause, E result2, ArrayDeque<StackTraceElement> resultStackTrace) {
        int i;
        resultStackTrace.addFirst(StackTraceRecoveryKt.artificialFrame("Coroutine boundary"));
        StackTraceElement[] causeTrace = cause.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(causeTrace, "causeTrace");
        String string = baseContinuationImplClassName;
        Intrinsics.checkExpressionValueIsNotNull(string, "baseContinuationImplClassName");
        int size = StackTraceRecoveryKt.frameIndex(causeTrace, string);
        if (size == -1) {
            void $this$toTypedArray$iv;
            Collection collection = resultStackTrace;
            E e = result2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
            if (stackTraceElementArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            e.setStackTrace(stackTraceElementArray2);
            return result2;
        }
        StackTraceElement[] mergedStackTrace = new StackTraceElement[resultStackTrace.size() + size];
        int $i$f$toTypedArray = 0;
        int thisCollection$iv = size;
        while ($i$f$toTypedArray < thisCollection$iv) {
            mergedStackTrace[i] = causeTrace[i];
            ++i;
        }
        i = 0;
        Iterator iterator2 = ((Iterable)resultStackTrace).iterator();
        while (iterator2.hasNext()) {
            void index;
            StackTraceElement element;
            mergedStackTrace[size + index] = element = (StackTraceElement)iterator2.next();
            ++index;
        }
        result2.setStackTrace(mergedStackTrace);
        return result2;
    }

    private static final <E extends Throwable> Pair<E, StackTraceElement[]> causeAndStacktrace(@NotNull E $this$causeAndStacktrace) {
        Pair<Object, StackTraceElement[]> pair2;
        Throwable cause = $this$causeAndStacktrace.getCause();
        if (cause != null && Intrinsics.areEqual(cause.getClass(), $this$causeAndStacktrace.getClass())) {
            boolean bl;
            StackTraceElement[] currentTrace;
            block5: {
                currentTrace = $this$causeAndStacktrace.getStackTrace();
                Intrinsics.checkExpressionValueIsNotNull(currentTrace, "currentTrace");
                StackTraceElement[] $this$any$iv = currentTrace;
                boolean $i$f$any = false;
                StackTraceElement[] stackTraceElementArray = $this$any$iv;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = stackTraceElementArray[i];
                    boolean bl2 = false;
                    StackTraceElement stackTraceElement = it;
                    Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "it");
                    if (!StackTraceRecoveryKt.isArtificial(stackTraceElement)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                pair2 = TuplesKt.to(cause, currentTrace);
            } else {
                E e = $this$causeAndStacktrace;
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
                pair2 = TuplesKt.to(e, stackTraceElementArray);
            }
        } else {
            E e = $this$causeAndStacktrace;
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
            pair2 = TuplesKt.to(e, stackTraceElementArray);
        }
        return pair2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeRecoveredTraces(StackTraceElement[] recoveredStacktrace, ArrayDeque<StackTraceElement> result2) {
        int lastFrameIndex;
        int n;
        int n2;
        int $i$f$indexOfFirst;
        block5: {
            StackTraceElement[] $this$indexOfFirst$iv = recoveredStacktrace;
            $i$f$indexOfFirst = 0;
            n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (StackTraceRecoveryKt.isArtificial(it)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int startIndex = n + 1;
        $i$f$indexOfFirst = lastFrameIndex = recoveredStacktrace.length - 1;
        n2 = startIndex;
        if ($i$f$indexOfFirst >= n2) {
            while (true) {
                void i;
                StackTraceElement element = recoveredStacktrace[i];
                StackTraceElement stackTraceElement = result2.getLast();
                Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "result.last");
                if (StackTraceRecoveryKt.elementWiseEquals(element, stackTraceElement)) {
                    result2.removeLast();
                }
                result2.addFirst(recoveredStacktrace[i]);
                if (i == n2) break;
                --i;
            }
        }
    }

    @Nullable
    public static final Object recoverAndThrow(@NotNull Throwable exception, @NotNull Continuation<?> $completion) {
        int $i$f$recoverAndThrow = 0;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    @Nullable
    private static final Object recoverAndThrow$$forInline(@NotNull Throwable exception, @NotNull Continuation continuation2) {
        int $i$f$recoverAndThrow = 0;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        InlineMarker.mark(0);
        Continuation it = continuation2;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    @NotNull
    public static final <E extends Throwable> E unwrap(@NotNull E exception) {
        boolean bl;
        Throwable cause;
        block4: {
            Intrinsics.checkParameterIsNotNull(exception, "exception");
            if (!DebugKt.getRECOVER_STACK_TRACES()) {
                return exception;
            }
            cause = exception.getCause();
            if (cause == null || Intrinsics.areEqual(cause.getClass(), exception.getClass()) ^ true) {
                return exception;
            }
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "exception.stackTrace");
            StackTraceElement[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            StackTraceElement[] stackTraceElementArray2 = $this$any$iv;
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = stackTraceElementArray2[i];
                boolean bl2 = false;
                StackTraceElement stackTraceElement = it;
                Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "it");
                if (!StackTraceRecoveryKt.isArtificial(stackTraceElement)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return (E)cause;
        }
        return exception;
    }

    private static final ArrayDeque<StackTraceElement> createStackTrace(CoroutineStackFrame continuation2) {
        boolean bl;
        ArrayDeque<StackTraceElement> stack = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = continuation2.getStackTraceElement();
        if (stackTraceElement != null) {
            StackTraceElement stackTraceElement2 = stackTraceElement;
            boolean bl2 = false;
            bl = false;
            StackTraceElement it = stackTraceElement2;
            boolean bl3 = false;
            stack.add(it);
        }
        CoroutineStackFrame last2 = continuation2;
        while (true) {
            StackTraceElement stackTraceElement3;
            CoroutineStackFrame coroutineStackFrame;
            CoroutineStackFrame coroutineStackFrame2;
            if (!((coroutineStackFrame2 = last2) instanceof CoroutineStackFrame)) {
                coroutineStackFrame2 = coroutineStackFrame = null;
            }
            if (coroutineStackFrame2 == null || (coroutineStackFrame = coroutineStackFrame.getCallerFrame()) == null) {
                break;
            }
            last2 = coroutineStackFrame;
            if (last2.getStackTraceElement() == null) continue;
            bl = false;
            boolean bl4 = false;
            StackTraceElement it = stackTraceElement3;
            boolean bl5 = false;
            stack.add(it);
        }
        return stack;
    }

    @InternalCoroutinesApi
    @NotNull
    public static final StackTraceElement artificialFrame(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        return new StackTraceElement("\b\b\b(" + message, "\b", "\b", -1);
    }

    public static final boolean isArtificial(@NotNull StackTraceElement $this$isArtificial) {
        Intrinsics.checkParameterIsNotNull($this$isArtificial, "$this$isArtificial");
        String string = $this$isArtificial.getClassName();
        Intrinsics.checkExpressionValueIsNotNull(string, "className");
        return StringsKt.startsWith$default(string, "\b\b\b", false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final int frameIndex(@NotNull StackTraceElement[] $this$frameIndex, String methodName) {
        int n;
        block2: {
            StackTraceElement[] $this$indexOfFirst$iv = $this$frameIndex;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (Intrinsics.areEqual(methodName, it.getClassName())) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final boolean elementWiseEquals(@NotNull StackTraceElement $this$elementWiseEquals, StackTraceElement e) {
        return $this$elementWiseEquals.getLineNumber() == e.getLineNumber() && Intrinsics.areEqual($this$elementWiseEquals.getMethodName(), e.getMethodName()) && Intrinsics.areEqual($this$elementWiseEquals.getFileName(), e.getFileName()) && Intrinsics.areEqual($this$elementWiseEquals.getClassName(), e.getClassName());
    }

    public static /* synthetic */ void CoroutineStackFrame$annotations() {
    }

    public static /* synthetic */ void StackTraceElement$annotations() {
    }

    public static final void initCause(@NotNull Throwable $this$initCause, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull($this$initCause, "$this$initCause");
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        $this$initCause.initCause(cause);
    }

    static {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        boolean bl2 = false;
        try {
            object4 = Result.Companion;
            boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = false;
            Class<?> clazz = Class.forName(baseContinuationImplClass);
            Intrinsics.checkExpressionValueIsNotNull(clazz, "Class.forName(baseContinuationImplClass)");
            String $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = clazz.getCanonicalName();
            boolean bl3 = false;
            object4 = Result.constructor-impl($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322);
        }
        catch (Throwable $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object4 = Result.constructor-impl(ResultKt.createFailure($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322));
        }
        Object object5 = object4;
        boolean bl5 = false;
        boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = false;
        Throwable $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = Result.exceptionOrNull-impl(object5);
        if ($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 == null) {
            object3 = object5;
        } else {
            Throwable it = $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322;
            bl = false;
            object3 = baseContinuationImplClass;
        }
        baseContinuationImplClassName = (String)object3;
        boolean bl6 = false;
        try {
            object2 = Result.Companion;
            boolean bl7 = false;
            Class<?> clazz = Class.forName(stackTraceRecoveryClass);
            Intrinsics.checkExpressionValueIsNotNull(clazz, "Class.forName(stackTraceRecoveryClass)");
            String string = clazz.getCanonicalName();
            boolean it = false;
            object2 = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            Result.Companion it = Result.Companion;
            bl = false;
            object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object6 = object2;
        boolean bl8 = false;
        boolean bl9 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object6);
        if (throwable == null) {
            object = object6;
        } else {
            Throwable it = throwable;
            boolean bl10 = false;
            object = stackTraceRecoveryClass;
        }
        stackTraceRecoveryClassName = (String)object;
    }
}

