/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.directive.BlockMacro;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.RuntimeMacro;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.NodeUtils;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class ASTDirective
extends SimpleNode {
    private Directive directive = null;
    private String directiveName = "";
    private boolean isDirective;
    private boolean isInitialized;
    private String prefix = "";
    private String postfix = "";
    private String morePrefix = "";

    public ASTDirective(int id) {
        super(id);
    }

    public ASTDirective(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public synchronized Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        if (!this.isInitialized) {
            super.init(context, data);
            Token t = this.getFirstToken();
            int pos = -1;
            while (t != null && (pos = t.image.lastIndexOf(35)) == -1) {
                t = t.next;
            }
            if (t != null && pos > 0) {
                this.morePrefix = t.image.substring(0, pos);
            }
            if (this.parser.isDirective(this.directiveName)) {
                this.isDirective = true;
                try {
                    this.directive = (Directive)this.parser.getDirective(this.directiveName).getClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new VelocityException("Couldn't initialize directive of class " + this.parser.getDirective(this.directiveName).getClass().getName(), e);
                }
                t = this.getFirstToken();
                if (t.kind == 32) {
                    t = t.next;
                }
                this.directive.setLocation(t.beginLine, t.beginColumn, this.getTemplate());
                this.directive.init(this.rsvc, context, this);
            } else if (this.directiveName.startsWith("@")) {
                if (this.jjtGetNumChildren() > 0) {
                    this.directiveName = this.directiveName.substring(1);
                    this.directive = new BlockMacro();
                    this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                    try {
                        ((BlockMacro)this.directive).init(this.rsvc, this.directiveName, context, this);
                    }
                    catch (TemplateInitException die) {
                        throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                    }
                    this.isDirective = true;
                } else {
                    this.isDirective = false;
                }
            } else {
                this.directive = new RuntimeMacro();
                this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                try {
                    ((RuntimeMacro)this.directive).init(this.rsvc, this.directiveName, context, this);
                }
                catch (TemplateInitException die) {
                    throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                }
                this.isDirective = true;
            }
            this.isInitialized = true;
            this.saveTokenImages();
            this.cleanupParserAndTokens();
        }
        if (this.morePrefix.length() == 0 && this.rsvc.getSpaceGobbling() == RuntimeConstants.SpaceGobbling.STRUCTURED && this.isInitialized && this.isDirective && this.directive.getType() == 1) {
            NodeUtils.fixIndentation(this, this.prefix);
        }
        return data;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getMorePrefix() {
        return this.morePrefix;
    }

    public int getDirectiveType() {
        return this.directive.getType();
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        if (this.isDirective) {
            if (this.morePrefix.length() > 0 || spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) < 0) {
                writer.write(this.prefix);
            }
            writer.write(this.morePrefix);
            this.directive.render(context, writer, this);
            if (this.morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) {
                writer.write(this.postfix);
            }
        } else {
            writer.write(this.prefix);
            writer.write(this.morePrefix);
            writer.write("#");
            writer.write(this.directiveName);
            writer.write(this.postfix);
        }
        return true;
    }

    public void setDirectiveName(String str) {
        this.directiveName = str;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    @Override
    public String toString() {
        return "ASTDirective [" + super.toString() + ", directiveName=" + this.directiveName + "]";
    }
}

