/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPathIterator;
import com.sun.webkit.graphics.WCRectangle;

final class WCPathImpl
extends WCPath<Path2D> {
    private final Path2D path;
    private boolean hasCP = false;
    private static final PlatformLogger log = PlatformLogger.getLogger(WCPathImpl.class.getName());

    WCPathImpl() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Create empty WCPathImpl({0})", this.getID());
        }
        this.path = new Path2D();
    }

    WCPathImpl(WCPathImpl wCPathImpl) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Create WCPathImpl({0}) from WCPathImpl({1})", this.getID(), wCPathImpl.getID());
        }
        this.path = new Path2D(wCPathImpl.path);
        this.hasCP = wCPathImpl.hasCP;
    }

    @Override
    public void addRect(double d, double d2, double d3, double d4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addRect({1},{2},{3},{4})", this.getID(), d, d2, d3, d4);
        }
        this.hasCP = true;
        this.path.append(new RoundRectangle2D((float)d, (float)d2, (float)d3, (int)d4, 0.0f, 0.0f), false);
    }

    @Override
    public void addEllipse(double d, double d2, double d3, double d4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addEllipse({1},{2},{3},{4})", this.getID(), d, d2, d3, d4);
        }
        this.hasCP = true;
        this.path.append(new Ellipse2D((float)d, (float)d2, (float)d3, (float)d4), false);
    }

    @Override
    public void addArcTo(double d, double d2, double d3, double d4, double d5) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addArcTo({1},{2},{3},{4})", this.getID(), d, d2, d3, d4);
        }
        Arc2D arc2D = new Arc2D();
        arc2D.setArcByTangent(this.path.getCurrentPoint(), new Point2D((float)d, (float)d2), new Point2D((float)d3, (float)d4), (float)d5);
        this.hasCP = true;
        this.path.append(arc2D, true);
    }

    @Override
    public void addArc(double d, double d2, double d3, double d4, double d5, boolean bl) {
        float f = (float)d4;
        float f2 = (float)d5;
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addArc(x={1},y={2},r={3},sa=|{4}|,ea=|{5}|,aclock={6})", this.getID(), d, d2, d3, Float.valueOf(f), Float.valueOf(f2), bl);
        }
        this.hasCP = true;
        float f3 = f2;
        if (!bl && f > f2) {
            f3 = f + ((float)Math.PI * 2 - (f - f2) % ((float)Math.PI * 2));
        } else if (bl && f < f2) {
            f3 = f - ((float)Math.PI * 2 - (f2 - f) % ((float)Math.PI * 2));
        }
        this.path.append(new Arc2D((float)(d - d3), (float)(d2 - d3), (float)(2.0 * d3), (float)(2.0 * d3), (float)Math.toDegrees(-f), (float)Math.toDegrees(f - f3), 0), true);
    }

    @Override
    public boolean contains(int n, double d, double d2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).contains({1},{2},{3})", this.getID(), n, d, d2);
        }
        int n2 = this.path.getWindingRule();
        this.path.setWindingRule(n);
        boolean bl = this.path.contains((float)d, (float)d2);
        this.path.setWindingRule(n2);
        return bl;
    }

    @Override
    public WCRectangle getBounds() {
        RectBounds rectBounds = this.path.getBounds();
        return new WCRectangle(rectBounds.getMinX(), rectBounds.getMinY(), rectBounds.getWidth(), rectBounds.getHeight());
    }

    @Override
    public void clear() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).clear()", this.getID());
        }
        this.hasCP = false;
        this.path.reset();
    }

    @Override
    public void moveTo(double d, double d2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).moveTo({1},{2})", this.getID(), d, d2);
        }
        this.hasCP = true;
        this.path.moveTo((float)d, (float)d2);
    }

    @Override
    public void addLineTo(double d, double d2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addLineTo({1},{2})", this.getID(), d, d2);
        }
        this.hasCP = true;
        this.path.lineTo((float)d, (float)d2);
    }

    @Override
    public void addQuadCurveTo(double d, double d2, double d3, double d4) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addQuadCurveTo({1},{2},{3},{4})", this.getID(), d, d2, d3, d4);
        }
        this.hasCP = true;
        this.path.quadTo((float)d, (float)d2, (float)d3, (float)d4);
    }

    @Override
    public void addBezierCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addBezierCurveTo({1},{2},{3},{4},{5},{6})", this.getID(), d, d2, d3, d4, d5, d6);
        }
        this.hasCP = true;
        this.path.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    @Override
    public void addPath(WCPath wCPath) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).addPath({1})", this.getID(), wCPath.getID());
        }
        this.hasCP = this.hasCP || ((WCPathImpl)wCPath).hasCP;
        this.path.append(((WCPathImpl)wCPath).path, false);
    }

    @Override
    public void closeSubpath() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).closeSubpath()", this.getID());
        }
        this.path.closePath();
    }

    @Override
    public boolean hasCurrentPoint() {
        return this.hasCP;
    }

    @Override
    public boolean isEmpty() {
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
            }
            pathIterator.next();
        }
        return true;
    }

    @Override
    public int getWindingRule() {
        return 1 - this.path.getWindingRule();
    }

    @Override
    public void setWindingRule(int n) {
        this.path.setWindingRule(1 - n);
    }

    @Override
    public Path2D getPlatformPath() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).getPath() BEGIN=====", this.getID());
            PathIterator pathIterator = this.path.getPathIterator(null);
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        log.fine("SEG_MOVETO ({0},{1})", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]));
                        break;
                    }
                    case 1: {
                        log.fine("SEG_LINETO ({0},{1})", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]));
                        break;
                    }
                    case 2: {
                        log.fine("SEG_QUADTO ({0},{1},{2},{3})", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
                        break;
                    }
                    case 3: {
                        log.fine("SEG_CUBICTO ({0},{1},{2},{3},{4},{5})", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]), Float.valueOf(fArray[4]), Float.valueOf(fArray[5]));
                        break;
                    }
                    case 4: {
                        log.fine("SEG_CLOSE");
                    }
                }
                pathIterator.next();
            }
            log.fine("========getPath() END=====");
        }
        return this.path;
    }

    @Override
    public WCPathIterator getPathIterator() {
        final PathIterator pathIterator = this.path.getPathIterator(null);
        return new WCPathIterator(){

            @Override
            public int getWindingRule() {
                return pathIterator.getWindingRule();
            }

            @Override
            public boolean isDone() {
                return pathIterator.isDone();
            }

            @Override
            public void next() {
                pathIterator.next();
            }

            @Override
            public int currentSegment(double[] dArray) {
                float[] fArray = new float[6];
                int n = pathIterator.currentSegment(fArray);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = fArray[i];
                }
                return n;
            }
        };
    }

    @Override
    public void translate(double d, double d2) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).translate({1}, {2})", this.getID(), d, d2);
        }
        this.path.transform(BaseTransform.getTranslateInstance(d, d2));
    }

    @Override
    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("WCPathImpl({0}).transform({1},{2},{3},{4},{5},{6})", this.getID(), d, d2, d3, d4, d5, d6);
        }
        this.path.transform(BaseTransform.getInstance(d, d2, d3, d4, d5, d6));
    }
}

