// Code generated by protoc-gen-go. DO NOT EDIT.
// source: enums.proto

package enums

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum indicating builders used
type BuilderType int32

const (
	// Could not determine builder type
	BuilderType_UNKNOWN_BUILDER_TYPE BuilderType = 0
	// JIB Builder
	BuilderType_JIB BuilderType = 1
	// Bazel Builder
	BuilderType_BAZEL BuilderType = 2
	// Buildpacks Builder
	BuilderType_BUILDPACKS BuilderType = 3
	// Custom Builder
	BuilderType_CUSTOM BuilderType = 4
	// Kaniko Builder
	BuilderType_KANIKO BuilderType = 5
	// Docker Builder
	BuilderType_DOCKER BuilderType = 6
)

var BuilderType_name = map[int32]string{
	0: "UNKNOWN_BUILDER_TYPE",
	1: "JIB",
	2: "BAZEL",
	3: "BUILDPACKS",
	4: "CUSTOM",
	5: "KANIKO",
	6: "DOCKER",
}

var BuilderType_value = map[string]int32{
	"UNKNOWN_BUILDER_TYPE": 0,
	"JIB":                  1,
	"BAZEL":                2,
	"BUILDPACKS":           3,
	"CUSTOM":               4,
	"KANIKO":               5,
	"DOCKER":               6,
}

func (x BuilderType) String() string {
	return proto.EnumName(BuilderType_name, int32(x))
}

func (BuilderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{0}
}

// Enum indicating build type i.e. local, cluster vs GCB
type BuildType int32

const (
	// Could not determine Build Type
	BuildType_UNKNOWN_BUILD_TYPE BuildType = 0
	// Cluster Build
	BuildType_CLUSTER BuildType = 1
	// GCB Build
	BuildType_GCB BuildType = 2
	// Local Build
	BuildType_LOCAL BuildType = 3
)

var BuildType_name = map[int32]string{
	0: "UNKNOWN_BUILD_TYPE",
	1: "CLUSTER",
	2: "GCB",
	3: "LOCAL",
}

var BuildType_value = map[string]int32{
	"UNKNOWN_BUILD_TYPE": 0,
	"CLUSTER":            1,
	"GCB":                2,
	"LOCAL":              3,
}

func (x BuildType) String() string {
	return proto.EnumName(BuildType_name, int32(x))
}

func (BuildType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{1}
}

// Enum indicating test tools used
type TesterType int32

const (
	// Could not determine Test Type
	TesterType_UNKNOWN_TEST_TYPE TesterType = 0
	// Unit tests
	TesterType_UNIT TesterType = 1
	// Container Structure tests
	TesterType_CONTAINER_STRUCTURE_TEST TesterType = 2
)

var TesterType_name = map[int32]string{
	0: "UNKNOWN_TEST_TYPE",
	1: "UNIT",
	2: "CONTAINER_STRUCTURE_TEST",
}

var TesterType_value = map[string]int32{
	"UNKNOWN_TEST_TYPE":        0,
	"UNIT":                     1,
	"CONTAINER_STRUCTURE_TEST": 2,
}

func (x TesterType) String() string {
	return proto.EnumName(TesterType_name, int32(x))
}

func (TesterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{2}
}

// Enum indicating deploy tools used
type DeployerType int32

const (
	// Could not determine Deployer Type
	DeployerType_UNKNOWN_DEPLOYER_TYPE DeployerType = 0
	// Helm Deployer
	DeployerType_HELM DeployerType = 1
	// Kustomize Deployer
	DeployerType_KUSTOMIZE DeployerType = 2
	// Kubectl Deployer
	DeployerType_KUBECTL DeployerType = 3
	// kpt Deployer
	DeployerType_KPT DeployerType = 4
)

var DeployerType_name = map[int32]string{
	0: "UNKNOWN_DEPLOYER_TYPE",
	1: "HELM",
	2: "KUSTOMIZE",
	3: "KUBECTL",
	4: "KPT",
}

var DeployerType_value = map[string]int32{
	"UNKNOWN_DEPLOYER_TYPE": 0,
	"HELM":                  1,
	"KUSTOMIZE":             2,
	"KUBECTL":               3,
	"KPT":                   4,
}

func (x DeployerType) String() string {
	return proto.EnumName(DeployerType_name, int32(x))
}

func (DeployerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{3}
}

// Enum indicating cluster type the application is deployed to
type ClusterType int32

const (
	// Could not determine Cluster Type
	ClusterType_UNKNOWN_CLUSTER_TYPE ClusterType = 0
	// Minikube Cluster
	ClusterType_MINIKUBE ClusterType = 1
	// GKE cluster
	ClusterType_GKE ClusterType = 2
	// All Cluster except Minikube and GKE
	ClusterType_OTHER ClusterType = 3
)

var ClusterType_name = map[int32]string{
	0: "UNKNOWN_CLUSTER_TYPE",
	1: "MINIKUBE",
	2: "GKE",
	3: "OTHER",
}

var ClusterType_value = map[string]int32{
	"UNKNOWN_CLUSTER_TYPE": 0,
	"MINIKUBE":             1,
	"GKE":                  2,
	"OTHER":                3,
}

func (x ClusterType) String() string {
	return proto.EnumName(ClusterType_name, int32(x))
}

func (ClusterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{4}
}

// Enum indicating the log level of a line of output
type LogLevel int32

const (
	// Debug Level
	LogLevel_DEBUG LogLevel = 0
	// Info Level
	LogLevel_INFO LogLevel = 1
	// Warn Level
	LogLevel_WARN LogLevel = 2
	// Error Level
	LogLevel_ERROR LogLevel = 3
	// Fatal Level
	LogLevel_FATAL LogLevel = 4
	// Panic Level
	LogLevel_PANIC LogLevel = 5
)

var LogLevel_name = map[int32]string{
	0: "DEBUG",
	1: "INFO",
	2: "WARN",
	3: "ERROR",
	4: "FATAL",
	5: "PANIC",
}

var LogLevel_value = map[string]int32{
	"DEBUG": 0,
	"INFO":  1,
	"WARN":  2,
	"ERROR": 3,
	"FATAL": 4,
	"PANIC": 5,
}

func (x LogLevel) String() string {
	return proto.EnumName(LogLevel_name, int32(x))
}

func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{5}
}

// Enum for Status codes<br>
// These error codes are prepended by Phase Name e.g.
// INIT, BUILD, TEST, DEPLOY, STATUSCHECK, DEVINIT<br>
// For Success Error codes, use range 200 to 250.<br>
// For Unknown error codes, use range 500 to 600.<br>
// For Cancelled Error code, use range 800 to 850.<br>
type StatusCode int32

const (
	// A default status code for events that do not have an associated phase.
	// Typically seen with the DevEndEvent event on success.
	StatusCode_OK StatusCode = 0
	// Status Check Success
	StatusCode_STATUSCHECK_SUCCESS StatusCode = 200
	// Build Success
	StatusCode_BUILD_SUCCESS StatusCode = 201
	// Render Success
	StatusCode_RENDER_SUCCESS StatusCode = 204
	// Deploy Success
	StatusCode_DEPLOY_SUCCESS StatusCode = 202
	// Test Success
	StatusCode_TEST_SUCCESS StatusCode = 203
	// Build error due to push access denied
	StatusCode_BUILD_PUSH_ACCESS_DENIED StatusCode = 101
	// Build error due to GCP project not found.
	StatusCode_BUILD_PROJECT_NOT_FOUND StatusCode = 102
	// Docker build error due to docker daemon not running
	StatusCode_BUILD_DOCKER_DAEMON_NOT_RUNNING StatusCode = 103
	// Build error due to user application code, e.g. compilation error, dockerfile error etc
	StatusCode_BUILD_USER_ERROR StatusCode = 104
	// Build error due to docker not available
	StatusCode_BUILD_DOCKER_UNAVAILABLE StatusCode = 105
	// Docker build error due to user not authorized to perform the action
	StatusCode_BUILD_DOCKER_UNAUTHORIZED StatusCode = 106
	// Docker system build error
	StatusCode_BUILD_DOCKER_SYSTEM_ERR StatusCode = 107
	// Docker build error due to Docker build container is already in the desired state
	StatusCode_BUILD_DOCKER_NOT_MODIFIED_ERR StatusCode = 108
	// Docker build error indicating a feature not supported
	StatusCode_BUILD_DOCKER_NOT_IMPLEMENTED_ERR StatusCode = 109
	// Docker build error indicates that for given build, data was lost or there is data corruption
	StatusCode_BUILD_DOCKER_DATA_LOSS_ERR StatusCode = 110
	// Docker build error indicates user is forbidden to perform the build or step/action.
	StatusCode_BUILD_DOCKER_FORBIDDEN_ERR StatusCode = 111
	// Docker build error due to some internal error and docker container state conflicts with the requested action and can't be performed
	StatusCode_BUILD_DOCKER_CONFLICT_ERR StatusCode = 112
	// Docker build error indicates the requested object does not exist
	StatusCode_BUILD_DOCKER_ERROR_NOT_FOUND StatusCode = 113
	// Docker build error indication invalid parameter sent to docker command
	StatusCode_BUILD_DOCKER_INVALID_PARAM_ERR StatusCode = 114
	// Docker build failed due to dockerfile not found
	StatusCode_BUILD_DOCKERFILE_NOT_FOUND StatusCode = 115
	// Docker build failed due `cacheFrom` user config error
	StatusCode_BUILD_DOCKER_CACHE_FROM_PULL_ERR StatusCode = 116
	// Build error due to digest for built artifact could not be retrieved from docker daemon.
	StatusCode_BUILD_DOCKER_GET_DIGEST_ERR StatusCode = 117
	// Build error due no space left in docker.
	StatusCode_BUILD_DOCKER_NO_SPACE_ERR StatusCode = 127
	// Build error due to digest for built artifact could not be retrieved from registry.
	StatusCode_BUILD_REGISTRY_GET_DIGEST_ERR StatusCode = 118
	// Build error indicating unknown Jib plugin type. Should be one of [maven, gradle]
	StatusCode_BUILD_UNKNOWN_JIB_PLUGIN_TYPE StatusCode = 119
	// Build error determining dependency for jib gradle project.
	StatusCode_BUILD_JIB_GRADLE_DEP_ERR StatusCode = 120
	// Build error determining dependency for jib gradle project.
	StatusCode_BUILD_JIB_MAVEN_DEP_ERR StatusCode = 121
	// Docker build error when listing containers.
	StatusCode_INIT_DOCKER_NETWORK_LISTING_CONTAINERS StatusCode = 122
	// Docker build error indicating an invalid container name (or id).
	StatusCode_INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME StatusCode = 123
	// Docker build error indicating the container referenced does not exists in the docker context used.
	StatusCode_INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST StatusCode = 124
	// Docker Network invalid mode
	StatusCode_INIT_DOCKER_NETWORK_INVALID_MODE StatusCode = 125
	// Error parsing Docker Network mode
	StatusCode_INIT_DOCKER_NETWORK_PARSE_ERR StatusCode = 126
	// Container image pull error
	StatusCode_STATUSCHECK_IMAGE_PULL_ERR StatusCode = 300
	// Container creating error
	StatusCode_STATUSCHECK_CONTAINER_CREATING StatusCode = 301
	// Container run error
	StatusCode_STATUSCHECK_RUN_CONTAINER_ERR StatusCode = 302
	// Container is already terminated
	StatusCode_STATUSCHECK_CONTAINER_TERMINATED StatusCode = 303
	// Deployment waiting for rollout
	StatusCode_STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING StatusCode = 304
	// Container restarting error
	StatusCode_STATUSCHECK_CONTAINER_RESTARTING StatusCode = 356
	// Readiness probe failed
	StatusCode_STATUSCHECK_UNHEALTHY StatusCode = 357
	// Executable binary format error
	StatusCode_STATUSCHECK_CONTAINER_EXEC_ERROR StatusCode = 358
	// Node memory pressure error
	StatusCode_STATUSCHECK_NODE_MEMORY_PRESSURE StatusCode = 400
	// Node disk pressure error
	StatusCode_STATUSCHECK_NODE_DISK_PRESSURE StatusCode = 401
	// Node network unavailable error
	StatusCode_STATUSCHECK_NODE_NETWORK_UNAVAILABLE StatusCode = 402
	// Node PID pressure error
	StatusCode_STATUSCHECK_NODE_PID_PRESSURE StatusCode = 403
	// Node unschedulable error
	StatusCode_STATUSCHECK_NODE_UNSCHEDULABLE StatusCode = 404
	// Node unreachable error
	StatusCode_STATUSCHECK_NODE_UNREACHABLE StatusCode = 405
	// Node not ready error
	StatusCode_STATUSCHECK_NODE_NOT_READY StatusCode = 406
	// Scheduler failure error
	StatusCode_STATUSCHECK_FAILED_SCHEDULING StatusCode = 407
	// Kubectl connection error
	StatusCode_STATUSCHECK_KUBECTL_CONNECTION_ERR StatusCode = 409
	// Kubectl process killed error
	StatusCode_STATUSCHECK_KUBECTL_PID_KILLED StatusCode = 410
	// Kubectl client fetch err
	StatusCode_STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR StatusCode = 411
	StatusCode_STATUSCHECK_DEPLOYMENT_FETCH_ERR     StatusCode = 412
	// Pod Initializing
	StatusCode_STATUSCHECK_POD_INITIALIZING StatusCode = 451
	// Could not determine error and phase
	StatusCode_UNKNOWN_ERROR StatusCode = 500
	// Status Check error unknown
	StatusCode_STATUSCHECK_UNKNOWN StatusCode = 501
	// Container is unschedulable due to unknown reasons
	StatusCode_STATUSCHECK_UNKNOWN_UNSCHEDULABLE StatusCode = 502
	// Container is waiting due to unknown reason
	StatusCode_STATUSCHECK_CONTAINER_WAITING_UNKNOWN StatusCode = 503
	// Container event reason unknown
	StatusCode_STATUSCHECK_UNKNOWN_EVENT StatusCode = 509
	// Deploy failed due to unknown reason
	StatusCode_DEPLOY_UNKNOWN StatusCode = 504
	// SYNC failed due to known reason
	StatusCode_SYNC_UNKNOWN StatusCode = 505
	// Build failed due to unknown reason
	StatusCode_BUILD_UNKNOWN StatusCode = 506
	// Dev Init failed due to unknown reason
	StatusCode_DEVINIT_UNKNOWN StatusCode = 507
	// Cleanup failed due to unknown reason
	StatusCode_CLEANUP_UNKNOWN StatusCode = 508
	// Initialization of the Skaffold session failed due to unknown reason(s)
	StatusCode_INIT_UNKNOWN StatusCode = 510
	// Build failed due to docker unknown error
	StatusCode_BUILD_DOCKER_UNKNOWN StatusCode = 511
	// Test failed due to unknown reason
	StatusCode_TEST_UNKNOWN StatusCode = 512
	// File Sync Initialize failure
	StatusCode_SYNC_INIT_ERROR StatusCode = 601
	// Failed to configure watcher for build dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_BUILD_DEPS StatusCode = 701
	// Failed to configure watcher for test dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_TEST_DEPS StatusCode = 702
	// Failed to configure watcher for deploy dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_DEPLOY_DEPS StatusCode = 703
	// Failed to configure watcher for Skaffold configuration file.
	StatusCode_DEVINIT_REGISTER_CONFIG_DEP StatusCode = 704
	// Failed to configure watcher for build dependencies for a base image with v1 manifest.
	StatusCode_DEVINIT_UNSUPPORTED_V1_MANIFEST StatusCode = 705
	// User cancelled the skaffold dev run
	StatusCode_STATUSCHECK_USER_CANCELLED StatusCode = 800
	// Deadline for status check exceeded
	StatusCode_STATUSCHECK_DEADLINE_EXCEEDED StatusCode = 801
	// Build Cancelled
	StatusCode_BUILD_CANCELLED StatusCode = 802
	// Deploy cancelled due to user cancellation or one or more deployers failed.
	StatusCode_DEPLOY_CANCELLED StatusCode = 803
	// Docker build cancelled.
	StatusCode_BUILD_DOCKER_CANCELLED StatusCode = 804
	// Build error due to docker deadline was reached before the docker action completed
	StatusCode_BUILD_DOCKER_DEADLINE StatusCode = 805
	// Skaffold was unable to create the configured tagger
	StatusCode_INIT_CREATE_TAGGER_ERROR StatusCode = 901
	// Skaffold was unable to start as Minikube appears to be paused
	StatusCode_INIT_MINIKUBE_PAUSED_ERROR StatusCode = 902
	// Skaffold was unable to start as Minikube appears to be stopped
	StatusCode_INIT_MINIKUBE_NOT_RUNNING_ERROR StatusCode = 903
	// Skaffold was unable to create a configured image builder
	StatusCode_INIT_CREATE_BUILDER_ERROR StatusCode = 904
	// Skaffold was unable to create a configured deployer
	StatusCode_INIT_CREATE_DEPLOYER_ERROR StatusCode = 905
	// Skaffold was unable to create a configured test
	StatusCode_INIT_CREATE_TEST_DEP_ERROR StatusCode = 906
	// Skaffold encountered an error validating the artifact cache
	StatusCode_INIT_CACHE_ERROR StatusCode = 907
	// Skaffold encountered an error when configuring file watching
	StatusCode_INIT_CREATE_WATCH_TRIGGER_ERROR StatusCode = 908
	// Skaffold encountered an error when evaluating artifact dependencies
	StatusCode_INIT_CREATE_ARTIFACT_DEP_ERROR StatusCode = 909
	// Unable to connect to cluster
	StatusCode_DEPLOY_CLUSTER_CONNECTION_ERR StatusCode = 1001
	// Could not retrieve debug helpers.
	StatusCode_DEPLOY_DEBUG_HELPER_RETRIEVE_ERR StatusCode = 1002
	// Deploy clean up error
	StatusCode_DEPLOY_CLEANUP_ERR StatusCode = 1003
	// Unable to apply helm labels.
	StatusCode_DEPLOY_HELM_APPLY_LABELS StatusCode = 1004
	// Deploy error due to user deploy config for helm deployer
	StatusCode_DEPLOY_HELM_USER_ERR StatusCode = 1005
	// Helm error when no build result is found of value  specified in helm `artifactOverrides`
	StatusCode_DEPLOY_NO_MATCHING_BUILD StatusCode = 1006
	// Unable to get helm client version
	StatusCode_DEPLOY_HELM_VERSION_ERR StatusCode = 1007
	// Helm version not supported.
	StatusCode_DEPLOY_HELM_MIN_VERSION_ERR StatusCode = 1008
	// Unable to retrieve kubectl version
	StatusCode_DEPLOY_KUBECTL_VERSION_ERR StatusCode = 1109
	// User specified offline mode for rendering but remote manifests presents.
	StatusCode_DEPLOY_KUBECTL_OFFLINE_MODE_ERR StatusCode = 1010
	// Error waiting for previous version deletion before next version is active.
	StatusCode_DEPLOY_ERR_WAITING_FOR_DELETION StatusCode = 1011
	// Error reading manifests
	StatusCode_DEPLOY_READ_MANIFEST_ERR StatusCode = 1012
	// Error reading remote manifests
	StatusCode_DEPLOY_READ_REMOTE_MANIFEST_ERR StatusCode = 1013
	// Errors listing manifests
	StatusCode_DEPLOY_LIST_MANIFEST_ERR StatusCode = 1014
	// Deploy error due to user deploy config for kubectl deployer
	StatusCode_DEPLOY_KUBECTL_USER_ERR StatusCode = 1015
	// Deploy error due to user deploy config for kustomize deployer
	StatusCode_DEPLOY_KUSTOMIZE_USER_ERR StatusCode = 1016
	// Error replacing a built artifact in the manifests
	StatusCode_DEPLOY_REPLACE_IMAGE_ERR StatusCode = 1017
	// Error transforming a manifest during skaffold debug
	StatusCode_DEPLOY_TRANSFORM_MANIFEST_ERR StatusCode = 1018
	// Error setting user specified additional labels.
	StatusCode_DEPLOY_SET_LABEL_ERR StatusCode = 1019
	// Error writing hydrated kubernetes manifests.
	StatusCode_DEPLOY_MANIFEST_WRITE_ERR StatusCode = 1020
	// Error getting images from a kubernetes manifest.
	StatusCode_DEPLOY_PARSE_MANIFEST_IMAGES_ERR StatusCode = 1021
	// Helm config `createNamespace` not available
	StatusCode_DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE StatusCode = 1022
	// Kubernetes cluster reported an internal system error
	StatusCode_DEPLOY_CLUSTER_INTERNAL_SYSTEM_ERR StatusCode = 1023
	// The Kptfile cannot be created via `kpt live init`.
	StatusCode_DEPLOY_KPTFILE_INIT_ERR StatusCode = 1024
	// Error expanding paths
	StatusCode_TEST_USER_CONFIG_ERR StatusCode = 1101
	// Error running container-structure-test
	StatusCode_TEST_CST_USER_ERR StatusCode = 1102
	// Unable to docker pull image
	StatusCode_TEST_IMG_PULL_ERR StatusCode = 1103
	// Unable to parse test command
	StatusCode_TEST_CUSTOM_CMD_PARSE_ERR StatusCode = 1104
	// Command returned non-zero exit code
	StatusCode_TEST_CUSTOM_CMD_RUN_NON_ZERO_EXIT_ERR StatusCode = 1105
	// command cancelled or timed out
	StatusCode_TEST_CUSTOM_CMD_RUN_TIMEDOUT_ERR StatusCode = 1106
	// command cancelled or timed out
	StatusCode_TEST_CUSTOM_CMD_RUN_CANCELLED_ERR StatusCode = 1107
	// command context error
	StatusCode_TEST_CUSTOM_CMD_RUN_EXECUTION_ERR StatusCode = 1108
	// command exited
	StatusCode_TEST_CUSTOM_CMD_RUN_EXITED_ERR StatusCode = 1110
	// error running cmd
	StatusCode_TEST_CUSTOM_CMD_RUN_ERR StatusCode = 1111
	// Error getting dependencies from command
	StatusCode_TEST_CUSTOM_DEPENDENCIES_CMD_ERR StatusCode = 1112
	// Unmarshalling dependency output error
	StatusCode_TEST_CUSTOM_DEPENDENCIES_UNMARSHALL_ERR StatusCode = 1113
	// Error retrieving the command
	StatusCode_TEST_CUSTOM_CMD_RETRIEVE_ERR StatusCode = 1114
	// Render errors
	// The Kptfile cannot be created via `kpt pkg init`.
	StatusCode_RENDER_KPTFILE_INIT_ERR StatusCode = 1501
	// The Kptfile is not a valid yaml file
	StatusCode_RENDER_KPTFILE_INVALID_YAML_ERR StatusCode = 1401
	// The Kptfile is not a valid API schema
	StatusCode_RENDER_KPTFILE_INVALID_SCHEMA_ERR StatusCode = 1402
	// Catch-all configuration file parsing error
	StatusCode_CONFIG_FILE_PARSING_ERR StatusCode = 1201
	// Main configuration file not found
	StatusCode_CONFIG_FILE_NOT_FOUND_ERR StatusCode = 1202
	// Dependency configuration file not found
	StatusCode_CONFIG_DEPENDENCY_NOT_FOUND_ERR StatusCode = 1203
	// Duplicate config names in the same configuration file
	StatusCode_CONFIG_DUPLICATE_NAMES_SAME_FILE_ERR StatusCode = 1204
	// Duplicate config names in two configuration files
	StatusCode_CONFIG_DUPLICATE_NAMES_ACROSS_FILES_ERR StatusCode = 1205
	// No configs matching configs filter
	StatusCode_CONFIG_BAD_FILTER_ERR StatusCode = 1206
	// No configs parsed from current file
	StatusCode_CONFIG_ZERO_FOUND_ERR StatusCode = 1207
	// Failed to apply profiles to config
	StatusCode_CONFIG_APPLY_PROFILES_ERR StatusCode = 1208
	// Failed to set default config values
	StatusCode_CONFIG_DEFAULT_VALUES_ERR StatusCode = 1209
	// Failed to substitute absolute file paths in config
	StatusCode_CONFIG_FILE_PATHS_SUBSTITUTION_ERR StatusCode = 1210
	// Same config imported at least twice with different set of profiles
	StatusCode_CONFIG_MULTI_IMPORT_PROFILE_CONFLICT_ERR StatusCode = 1211
	// Profile selection did not match known profile names
	StatusCode_CONFIG_PROFILES_NOT_FOUND_ERR StatusCode = 1212
	// Config API version not found
	StatusCode_CONFIG_UNKNOWN_API_VERSION_ERR StatusCode = 1213
	// The validator is not allowed in skaffold-managed mode.
	StatusCode_CONFIG_UNKNOWN_VALIDATOR StatusCode = 1214
	// The transformer is not allowed in skaffold-managed mode.
	StatusCode_CONFIG_UNKNOWN_TRANSFORMER StatusCode = 1215
	// Manifest file not found
	StatusCode_CONFIG_MISSING_MANIFEST_FILE_ERR StatusCode = 1216
	// Catch-all `skaffold inspect` command error
	StatusCode_INSPECT_UNKNOWN_ERR StatusCode = 1301
	// Trying to add new build environment that already exists
	StatusCode_INSPECT_BUILD_ENV_ALREADY_EXISTS_ERR StatusCode = 1302
	// Trying to modify build environment that doesn't exist
	StatusCode_INSPECT_BUILD_ENV_INCORRECT_TYPE_ERR StatusCode = 1303
	// Trying to modify a profile that doesn't exist
	StatusCode_INSPECT_PROFILE_NOT_FOUND_ERR StatusCode = 1304
)

var StatusCode_name = map[int32]string{
	0:    "OK",
	200:  "STATUSCHECK_SUCCESS",
	201:  "BUILD_SUCCESS",
	204:  "RENDER_SUCCESS",
	202:  "DEPLOY_SUCCESS",
	203:  "TEST_SUCCESS",
	101:  "BUILD_PUSH_ACCESS_DENIED",
	102:  "BUILD_PROJECT_NOT_FOUND",
	103:  "BUILD_DOCKER_DAEMON_NOT_RUNNING",
	104:  "BUILD_USER_ERROR",
	105:  "BUILD_DOCKER_UNAVAILABLE",
	106:  "BUILD_DOCKER_UNAUTHORIZED",
	107:  "BUILD_DOCKER_SYSTEM_ERR",
	108:  "BUILD_DOCKER_NOT_MODIFIED_ERR",
	109:  "BUILD_DOCKER_NOT_IMPLEMENTED_ERR",
	110:  "BUILD_DOCKER_DATA_LOSS_ERR",
	111:  "BUILD_DOCKER_FORBIDDEN_ERR",
	112:  "BUILD_DOCKER_CONFLICT_ERR",
	113:  "BUILD_DOCKER_ERROR_NOT_FOUND",
	114:  "BUILD_DOCKER_INVALID_PARAM_ERR",
	115:  "BUILD_DOCKERFILE_NOT_FOUND",
	116:  "BUILD_DOCKER_CACHE_FROM_PULL_ERR",
	117:  "BUILD_DOCKER_GET_DIGEST_ERR",
	127:  "BUILD_DOCKER_NO_SPACE_ERR",
	118:  "BUILD_REGISTRY_GET_DIGEST_ERR",
	119:  "BUILD_UNKNOWN_JIB_PLUGIN_TYPE",
	120:  "BUILD_JIB_GRADLE_DEP_ERR",
	121:  "BUILD_JIB_MAVEN_DEP_ERR",
	122:  "INIT_DOCKER_NETWORK_LISTING_CONTAINERS",
	123:  "INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME",
	124:  "INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST",
	125:  "INIT_DOCKER_NETWORK_INVALID_MODE",
	126:  "INIT_DOCKER_NETWORK_PARSE_ERR",
	300:  "STATUSCHECK_IMAGE_PULL_ERR",
	301:  "STATUSCHECK_CONTAINER_CREATING",
	302:  "STATUSCHECK_RUN_CONTAINER_ERR",
	303:  "STATUSCHECK_CONTAINER_TERMINATED",
	304:  "STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING",
	356:  "STATUSCHECK_CONTAINER_RESTARTING",
	357:  "STATUSCHECK_UNHEALTHY",
	358:  "STATUSCHECK_CONTAINER_EXEC_ERROR",
	400:  "STATUSCHECK_NODE_MEMORY_PRESSURE",
	401:  "STATUSCHECK_NODE_DISK_PRESSURE",
	402:  "STATUSCHECK_NODE_NETWORK_UNAVAILABLE",
	403:  "STATUSCHECK_NODE_PID_PRESSURE",
	404:  "STATUSCHECK_NODE_UNSCHEDULABLE",
	405:  "STATUSCHECK_NODE_UNREACHABLE",
	406:  "STATUSCHECK_NODE_NOT_READY",
	407:  "STATUSCHECK_FAILED_SCHEDULING",
	409:  "STATUSCHECK_KUBECTL_CONNECTION_ERR",
	410:  "STATUSCHECK_KUBECTL_PID_KILLED",
	411:  "STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR",
	412:  "STATUSCHECK_DEPLOYMENT_FETCH_ERR",
	451:  "STATUSCHECK_POD_INITIALIZING",
	500:  "UNKNOWN_ERROR",
	501:  "STATUSCHECK_UNKNOWN",
	502:  "STATUSCHECK_UNKNOWN_UNSCHEDULABLE",
	503:  "STATUSCHECK_CONTAINER_WAITING_UNKNOWN",
	509:  "STATUSCHECK_UNKNOWN_EVENT",
	504:  "DEPLOY_UNKNOWN",
	505:  "SYNC_UNKNOWN",
	506:  "BUILD_UNKNOWN",
	507:  "DEVINIT_UNKNOWN",
	508:  "CLEANUP_UNKNOWN",
	510:  "INIT_UNKNOWN",
	511:  "BUILD_DOCKER_UNKNOWN",
	512:  "TEST_UNKNOWN",
	601:  "SYNC_INIT_ERROR",
	701:  "DEVINIT_REGISTER_BUILD_DEPS",
	702:  "DEVINIT_REGISTER_TEST_DEPS",
	703:  "DEVINIT_REGISTER_DEPLOY_DEPS",
	704:  "DEVINIT_REGISTER_CONFIG_DEP",
	705:  "DEVINIT_UNSUPPORTED_V1_MANIFEST",
	800:  "STATUSCHECK_USER_CANCELLED",
	801:  "STATUSCHECK_DEADLINE_EXCEEDED",
	802:  "BUILD_CANCELLED",
	803:  "DEPLOY_CANCELLED",
	804:  "BUILD_DOCKER_CANCELLED",
	805:  "BUILD_DOCKER_DEADLINE",
	901:  "INIT_CREATE_TAGGER_ERROR",
	902:  "INIT_MINIKUBE_PAUSED_ERROR",
	903:  "INIT_MINIKUBE_NOT_RUNNING_ERROR",
	904:  "INIT_CREATE_BUILDER_ERROR",
	905:  "INIT_CREATE_DEPLOYER_ERROR",
	906:  "INIT_CREATE_TEST_DEP_ERROR",
	907:  "INIT_CACHE_ERROR",
	908:  "INIT_CREATE_WATCH_TRIGGER_ERROR",
	909:  "INIT_CREATE_ARTIFACT_DEP_ERROR",
	1001: "DEPLOY_CLUSTER_CONNECTION_ERR",
	1002: "DEPLOY_DEBUG_HELPER_RETRIEVE_ERR",
	1003: "DEPLOY_CLEANUP_ERR",
	1004: "DEPLOY_HELM_APPLY_LABELS",
	1005: "DEPLOY_HELM_USER_ERR",
	1006: "DEPLOY_NO_MATCHING_BUILD",
	1007: "DEPLOY_HELM_VERSION_ERR",
	1008: "DEPLOY_HELM_MIN_VERSION_ERR",
	1109: "DEPLOY_KUBECTL_VERSION_ERR",
	1010: "DEPLOY_KUBECTL_OFFLINE_MODE_ERR",
	1011: "DEPLOY_ERR_WAITING_FOR_DELETION",
	1012: "DEPLOY_READ_MANIFEST_ERR",
	1013: "DEPLOY_READ_REMOTE_MANIFEST_ERR",
	1014: "DEPLOY_LIST_MANIFEST_ERR",
	1015: "DEPLOY_KUBECTL_USER_ERR",
	1016: "DEPLOY_KUSTOMIZE_USER_ERR",
	1017: "DEPLOY_REPLACE_IMAGE_ERR",
	1018: "DEPLOY_TRANSFORM_MANIFEST_ERR",
	1019: "DEPLOY_SET_LABEL_ERR",
	1020: "DEPLOY_MANIFEST_WRITE_ERR",
	1021: "DEPLOY_PARSE_MANIFEST_IMAGES_ERR",
	1022: "DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE",
	1023: "DEPLOY_CLUSTER_INTERNAL_SYSTEM_ERR",
	1024: "DEPLOY_KPTFILE_INIT_ERR",
	1101: "TEST_USER_CONFIG_ERR",
	1102: "TEST_CST_USER_ERR",
	1103: "TEST_IMG_PULL_ERR",
	1104: "TEST_CUSTOM_CMD_PARSE_ERR",
	1105: "TEST_CUSTOM_CMD_RUN_NON_ZERO_EXIT_ERR",
	1106: "TEST_CUSTOM_CMD_RUN_TIMEDOUT_ERR",
	1107: "TEST_CUSTOM_CMD_RUN_CANCELLED_ERR",
	1108: "TEST_CUSTOM_CMD_RUN_EXECUTION_ERR",
	1110: "TEST_CUSTOM_CMD_RUN_EXITED_ERR",
	1111: "TEST_CUSTOM_CMD_RUN_ERR",
	1112: "TEST_CUSTOM_DEPENDENCIES_CMD_ERR",
	1113: "TEST_CUSTOM_DEPENDENCIES_UNMARSHALL_ERR",
	1114: "TEST_CUSTOM_CMD_RETRIEVE_ERR",
	1501: "RENDER_KPTFILE_INIT_ERR",
	1401: "RENDER_KPTFILE_INVALID_YAML_ERR",
	1402: "RENDER_KPTFILE_INVALID_SCHEMA_ERR",
	1201: "CONFIG_FILE_PARSING_ERR",
	1202: "CONFIG_FILE_NOT_FOUND_ERR",
	1203: "CONFIG_DEPENDENCY_NOT_FOUND_ERR",
	1204: "CONFIG_DUPLICATE_NAMES_SAME_FILE_ERR",
	1205: "CONFIG_DUPLICATE_NAMES_ACROSS_FILES_ERR",
	1206: "CONFIG_BAD_FILTER_ERR",
	1207: "CONFIG_ZERO_FOUND_ERR",
	1208: "CONFIG_APPLY_PROFILES_ERR",
	1209: "CONFIG_DEFAULT_VALUES_ERR",
	1210: "CONFIG_FILE_PATHS_SUBSTITUTION_ERR",
	1211: "CONFIG_MULTI_IMPORT_PROFILE_CONFLICT_ERR",
	1212: "CONFIG_PROFILES_NOT_FOUND_ERR",
	1213: "CONFIG_UNKNOWN_API_VERSION_ERR",
	1214: "CONFIG_UNKNOWN_VALIDATOR",
	1215: "CONFIG_UNKNOWN_TRANSFORMER",
	1216: "CONFIG_MISSING_MANIFEST_FILE_ERR",
	1301: "INSPECT_UNKNOWN_ERR",
	1302: "INSPECT_BUILD_ENV_ALREADY_EXISTS_ERR",
	1303: "INSPECT_BUILD_ENV_INCORRECT_TYPE_ERR",
	1304: "INSPECT_PROFILE_NOT_FOUND_ERR",
}

var StatusCode_value = map[string]int32{
	"OK":                                           0,
	"STATUSCHECK_SUCCESS":                          200,
	"BUILD_SUCCESS":                                201,
	"RENDER_SUCCESS":                               204,
	"DEPLOY_SUCCESS":                               202,
	"TEST_SUCCESS":                                 203,
	"BUILD_PUSH_ACCESS_DENIED":                     101,
	"BUILD_PROJECT_NOT_FOUND":                      102,
	"BUILD_DOCKER_DAEMON_NOT_RUNNING":              103,
	"BUILD_USER_ERROR":                             104,
	"BUILD_DOCKER_UNAVAILABLE":                     105,
	"BUILD_DOCKER_UNAUTHORIZED":                    106,
	"BUILD_DOCKER_SYSTEM_ERR":                      107,
	"BUILD_DOCKER_NOT_MODIFIED_ERR":                108,
	"BUILD_DOCKER_NOT_IMPLEMENTED_ERR":             109,
	"BUILD_DOCKER_DATA_LOSS_ERR":                   110,
	"BUILD_DOCKER_FORBIDDEN_ERR":                   111,
	"BUILD_DOCKER_CONFLICT_ERR":                    112,
	"BUILD_DOCKER_ERROR_NOT_FOUND":                 113,
	"BUILD_DOCKER_INVALID_PARAM_ERR":               114,
	"BUILD_DOCKERFILE_NOT_FOUND":                   115,
	"BUILD_DOCKER_CACHE_FROM_PULL_ERR":             116,
	"BUILD_DOCKER_GET_DIGEST_ERR":                  117,
	"BUILD_DOCKER_NO_SPACE_ERR":                    127,
	"BUILD_REGISTRY_GET_DIGEST_ERR":                118,
	"BUILD_UNKNOWN_JIB_PLUGIN_TYPE":                119,
	"BUILD_JIB_GRADLE_DEP_ERR":                     120,
	"BUILD_JIB_MAVEN_DEP_ERR":                      121,
	"INIT_DOCKER_NETWORK_LISTING_CONTAINERS":       122,
	"INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME":   123,
	"INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST": 124,
	"INIT_DOCKER_NETWORK_INVALID_MODE":             125,
	"INIT_DOCKER_NETWORK_PARSE_ERR":                126,
	"STATUSCHECK_IMAGE_PULL_ERR":                   300,
	"STATUSCHECK_CONTAINER_CREATING":               301,
	"STATUSCHECK_RUN_CONTAINER_ERR":                302,
	"STATUSCHECK_CONTAINER_TERMINATED":             303,
	"STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING":       304,
	"STATUSCHECK_CONTAINER_RESTARTING":             356,
	"STATUSCHECK_UNHEALTHY":                        357,
	"STATUSCHECK_CONTAINER_EXEC_ERROR":             358,
	"STATUSCHECK_NODE_MEMORY_PRESSURE":             400,
	"STATUSCHECK_NODE_DISK_PRESSURE":               401,
	"STATUSCHECK_NODE_NETWORK_UNAVAILABLE":         402,
	"STATUSCHECK_NODE_PID_PRESSURE":                403,
	"STATUSCHECK_NODE_UNSCHEDULABLE":               404,
	"STATUSCHECK_NODE_UNREACHABLE":                 405,
	"STATUSCHECK_NODE_NOT_READY":                   406,
	"STATUSCHECK_FAILED_SCHEDULING":                407,
	"STATUSCHECK_KUBECTL_CONNECTION_ERR":           409,
	"STATUSCHECK_KUBECTL_PID_KILLED":               410,
	"STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR":         411,
	"STATUSCHECK_DEPLOYMENT_FETCH_ERR":             412,
	"STATUSCHECK_POD_INITIALIZING":                 451,
	"UNKNOWN_ERROR":                                500,
	"STATUSCHECK_UNKNOWN":                          501,
	"STATUSCHECK_UNKNOWN_UNSCHEDULABLE":            502,
	"STATUSCHECK_CONTAINER_WAITING_UNKNOWN":        503,
	"STATUSCHECK_UNKNOWN_EVENT":                    509,
	"DEPLOY_UNKNOWN":                               504,
	"SYNC_UNKNOWN":                                 505,
	"BUILD_UNKNOWN":                                506,
	"DEVINIT_UNKNOWN":                              507,
	"CLEANUP_UNKNOWN":                              508,
	"INIT_UNKNOWN":                                 510,
	"BUILD_DOCKER_UNKNOWN":                         511,
	"TEST_UNKNOWN":                                 512,
	"SYNC_INIT_ERROR":                              601,
	"DEVINIT_REGISTER_BUILD_DEPS":                  701,
	"DEVINIT_REGISTER_TEST_DEPS":                   702,
	"DEVINIT_REGISTER_DEPLOY_DEPS":                 703,
	"DEVINIT_REGISTER_CONFIG_DEP":                  704,
	"DEVINIT_UNSUPPORTED_V1_MANIFEST":              705,
	"STATUSCHECK_USER_CANCELLED":                   800,
	"STATUSCHECK_DEADLINE_EXCEEDED":                801,
	"BUILD_CANCELLED":                              802,
	"DEPLOY_CANCELLED":                             803,
	"BUILD_DOCKER_CANCELLED":                       804,
	"BUILD_DOCKER_DEADLINE":                        805,
	"INIT_CREATE_TAGGER_ERROR":                     901,
	"INIT_MINIKUBE_PAUSED_ERROR":                   902,
	"INIT_MINIKUBE_NOT_RUNNING_ERROR":              903,
	"INIT_CREATE_BUILDER_ERROR":                    904,
	"INIT_CREATE_DEPLOYER_ERROR":                   905,
	"INIT_CREATE_TEST_DEP_ERROR":                   906,
	"INIT_CACHE_ERROR":                             907,
	"INIT_CREATE_WATCH_TRIGGER_ERROR":              908,
	"INIT_CREATE_ARTIFACT_DEP_ERROR":               909,
	"DEPLOY_CLUSTER_CONNECTION_ERR":                1001,
	"DEPLOY_DEBUG_HELPER_RETRIEVE_ERR":             1002,
	"DEPLOY_CLEANUP_ERR":                           1003,
	"DEPLOY_HELM_APPLY_LABELS":                     1004,
	"DEPLOY_HELM_USER_ERR":                         1005,
	"DEPLOY_NO_MATCHING_BUILD":                     1006,
	"DEPLOY_HELM_VERSION_ERR":                      1007,
	"DEPLOY_HELM_MIN_VERSION_ERR":                  1008,
	"DEPLOY_KUBECTL_VERSION_ERR":                   1109,
	"DEPLOY_KUBECTL_OFFLINE_MODE_ERR":              1010,
	"DEPLOY_ERR_WAITING_FOR_DELETION":              1011,
	"DEPLOY_READ_MANIFEST_ERR":                     1012,
	"DEPLOY_READ_REMOTE_MANIFEST_ERR":              1013,
	"DEPLOY_LIST_MANIFEST_ERR":                     1014,
	"DEPLOY_KUBECTL_USER_ERR":                      1015,
	"DEPLOY_KUSTOMIZE_USER_ERR":                    1016,
	"DEPLOY_REPLACE_IMAGE_ERR":                     1017,
	"DEPLOY_TRANSFORM_MANIFEST_ERR":                1018,
	"DEPLOY_SET_LABEL_ERR":                         1019,
	"DEPLOY_MANIFEST_WRITE_ERR":                    1020,
	"DEPLOY_PARSE_MANIFEST_IMAGES_ERR":             1021,
	"DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE":          1022,
	"DEPLOY_CLUSTER_INTERNAL_SYSTEM_ERR":           1023,
	"DEPLOY_KPTFILE_INIT_ERR":                      1024,
	"TEST_USER_CONFIG_ERR":                         1101,
	"TEST_CST_USER_ERR":                            1102,
	"TEST_IMG_PULL_ERR":                            1103,
	"TEST_CUSTOM_CMD_PARSE_ERR":                    1104,
	"TEST_CUSTOM_CMD_RUN_NON_ZERO_EXIT_ERR":        1105,
	"TEST_CUSTOM_CMD_RUN_TIMEDOUT_ERR":             1106,
	"TEST_CUSTOM_CMD_RUN_CANCELLED_ERR":            1107,
	"TEST_CUSTOM_CMD_RUN_EXECUTION_ERR":            1108,
	"TEST_CUSTOM_CMD_RUN_EXITED_ERR":               1110,
	"TEST_CUSTOM_CMD_RUN_ERR":                      1111,
	"TEST_CUSTOM_DEPENDENCIES_CMD_ERR":             1112,
	"TEST_CUSTOM_DEPENDENCIES_UNMARSHALL_ERR":      1113,
	"TEST_CUSTOM_CMD_RETRIEVE_ERR":                 1114,
	"RENDER_KPTFILE_INIT_ERR":                      1501,
	"RENDER_KPTFILE_INVALID_YAML_ERR":              1401,
	"RENDER_KPTFILE_INVALID_SCHEMA_ERR":            1402,
	"CONFIG_FILE_PARSING_ERR":                      1201,
	"CONFIG_FILE_NOT_FOUND_ERR":                    1202,
	"CONFIG_DEPENDENCY_NOT_FOUND_ERR":              1203,
	"CONFIG_DUPLICATE_NAMES_SAME_FILE_ERR":         1204,
	"CONFIG_DUPLICATE_NAMES_ACROSS_FILES_ERR":      1205,
	"CONFIG_BAD_FILTER_ERR":                        1206,
	"CONFIG_ZERO_FOUND_ERR":                        1207,
	"CONFIG_APPLY_PROFILES_ERR":                    1208,
	"CONFIG_DEFAULT_VALUES_ERR":                    1209,
	"CONFIG_FILE_PATHS_SUBSTITUTION_ERR":           1210,
	"CONFIG_MULTI_IMPORT_PROFILE_CONFLICT_ERR":     1211,
	"CONFIG_PROFILES_NOT_FOUND_ERR":                1212,
	"CONFIG_UNKNOWN_API_VERSION_ERR":               1213,
	"CONFIG_UNKNOWN_VALIDATOR":                     1214,
	"CONFIG_UNKNOWN_TRANSFORMER":                   1215,
	"CONFIG_MISSING_MANIFEST_FILE_ERR":             1216,
	"INSPECT_UNKNOWN_ERR":                          1301,
	"INSPECT_BUILD_ENV_ALREADY_EXISTS_ERR":         1302,
	"INSPECT_BUILD_ENV_INCORRECT_TYPE_ERR":         1303,
	"INSPECT_PROFILE_NOT_FOUND_ERR":                1304,
}

func (x StatusCode) String() string {
	return proto.EnumName(StatusCode_name, int32(x))
}

func (StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{6}
}

// Enum for Suggestion codes
type SuggestionCode int32

const (
	// default nil suggestion.
	// This is usually set when no error happens.
	SuggestionCode_NIL SuggestionCode = 0
	// Add Default Repo
	SuggestionCode_ADD_DEFAULT_REPO SuggestionCode = 100
	// Verify Default Repo
	SuggestionCode_CHECK_DEFAULT_REPO SuggestionCode = 101
	// Verify default repo in the global config
	SuggestionCode_CHECK_DEFAULT_REPO_GLOBAL_CONFIG SuggestionCode = 102
	// run gcloud docker auth configure
	SuggestionCode_GCLOUD_DOCKER_AUTH_CONFIGURE SuggestionCode = 103
	// Run docker auth configure
	SuggestionCode_DOCKER_AUTH_CONFIGURE SuggestionCode = 104
	// Verify Gcloud Project
	SuggestionCode_CHECK_GCLOUD_PROJECT SuggestionCode = 105
	// Check if docker is running
	SuggestionCode_CHECK_DOCKER_RUNNING SuggestionCode = 106
	// Fix User Build Error
	SuggestionCode_FIX_USER_BUILD_ERR SuggestionCode = 107
	// Docker build internal error, try again
	SuggestionCode_DOCKER_BUILD_RETRY SuggestionCode = 108
	// Fix `cacheFrom` config for given artifact and try again
	SuggestionCode_FIX_CACHE_FROM_ARTIFACT_CONFIG SuggestionCode = 109
	// Fix `dockerfile` config for a given artifact and try again.
	SuggestionCode_FIX_SKAFFOLD_CONFIG_DOCKERFILE SuggestionCode = 110
	// Use a supported Jib plugin type
	SuggestionCode_FIX_JIB_PLUGIN_CONFIGURATION SuggestionCode = 111
	// Docker build network invalid docker container name (or id).
	SuggestionCode_FIX_DOCKER_NETWORK_CONTAINER_NAME SuggestionCode = 112
	// Docker build network container not existing in the current context.
	SuggestionCode_CHECK_DOCKER_NETWORK_CONTAINER_RUNNING SuggestionCode = 113
	// Executing extractContainerNameFromNetworkMode with a non valid mode (only container mode allowed)
	SuggestionCode_FIX_DOCKER_NETWORK_MODE_WHEN_EXTRACTING_CONTAINER_NAME SuggestionCode = 114
	// Prune Docker image
	SuggestionCode_RUN_DOCKER_PRUNE SuggestionCode = 115
	// Set Cleanup flag for skaffold command.
	SuggestionCode_SET_CLEANUP_FLAG SuggestionCode = 116
	// Check cluster connection
	SuggestionCode_CHECK_CLUSTER_CONNECTION SuggestionCode = 201
	// Check minikube status
	SuggestionCode_CHECK_MINIKUBE_STATUS SuggestionCode = 202
	// Install helm tool
	SuggestionCode_INSTALL_HELM SuggestionCode = 203
	// Upgrade helm tool
	SuggestionCode_UPGRADE_HELM SuggestionCode = 204
	// Fix helm `releases.artifactOverrides` config to match with `build.artiofacts`
	SuggestionCode_FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES SuggestionCode = 205
	// Upgrade helm version to v3.2.0 and higher.
	SuggestionCode_UPGRADE_HELM32 SuggestionCode = 206
	// Set `releases.createNamespace` to false.
	SuggestionCode_FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE SuggestionCode = 207
	// Install kubectl tool
	SuggestionCode_INSTALL_KUBECTL SuggestionCode = 220
	// Container run error
	SuggestionCode_CHECK_CONTAINER_LOGS SuggestionCode = 301
	// Pod Health check error
	SuggestionCode_CHECK_READINESS_PROBE SuggestionCode = 302
	// Check Container image
	SuggestionCode_CHECK_CONTAINER_IMAGE SuggestionCode = 303
	// Node pressure error
	SuggestionCode_ADDRESS_NODE_MEMORY_PRESSURE SuggestionCode = 400
	// Node disk pressure error
	SuggestionCode_ADDRESS_NODE_DISK_PRESSURE SuggestionCode = 401
	// Node network unavailable error
	SuggestionCode_ADDRESS_NODE_NETWORK_UNAVAILABLE SuggestionCode = 402
	// Node PID pressure error
	SuggestionCode_ADDRESS_NODE_PID_PRESSURE SuggestionCode = 403
	// Node unschedulable error
	SuggestionCode_ADDRESS_NODE_UNSCHEDULABLE SuggestionCode = 404
	// Node unreachable error
	SuggestionCode_ADDRESS_NODE_UNREACHABLE SuggestionCode = 405
	// Node not ready error
	SuggestionCode_ADDRESS_NODE_NOT_READY SuggestionCode = 406
	// Scheduler failure error
	SuggestionCode_ADDRESS_FAILED_SCHEDULING SuggestionCode = 407
	// Cluster Connectivity error
	SuggestionCode_CHECK_HOST_CONNECTION SuggestionCode = 408
	// Minikube is stopped: use `minikube start`
	SuggestionCode_START_MINIKUBE SuggestionCode = 501
	// Minikube is paused: use `minikube unpause`
	SuggestionCode_UNPAUSE_MINIKUBE SuggestionCode = 502
	// Run Docker pull for the image with v1 manifest and try again.
	SuggestionCode_RUN_DOCKER_PULL SuggestionCode = 551
	// Rerun with correct offline flag value.
	SuggestionCode_SET_RENDER_FLAG_OFFLINE_FALSE SuggestionCode = 600
	// Manually run `kpt pkg init` or `kpt live init`
	SuggestionCode_KPTFILE_MANUAL_INIT SuggestionCode = 601
	// Check if the Kptfile is correct.
	SuggestionCode_KPTFILE_CHECK_YAML SuggestionCode = 602
	// Check configuration file path
	SuggestionCode_CONFIG_CHECK_FILE_PATH SuggestionCode = 700
	// Check dependency config definition
	SuggestionCode_CONFIG_CHECK_DEPENDENCY_DEFINITION SuggestionCode = 701
	// Change config name to avoid duplicates
	SuggestionCode_CONFIG_CHANGE_NAMES SuggestionCode = 702
	// Check config filter
	SuggestionCode_CONFIG_CHECK_FILTER SuggestionCode = 703
	// Check profile definition in current config
	SuggestionCode_CONFIG_CHECK_PROFILE_DEFINITION SuggestionCode = 704
	// Check active profile selection for dependency config
	SuggestionCode_CONFIG_CHECK_DEPENDENCY_PROFILES_SELECTION SuggestionCode = 705
	// Check profile selection flag
	SuggestionCode_CONFIG_CHECK_PROFILE_SELECTION SuggestionCode = 706
	// Fix config API version or upgrade the skaffold binary
	SuggestionCode_CONFIG_FIX_API_VERSION SuggestionCode = 707
	// Only the allow listed validators are acceptable in skaffold-managed mode.
	SuggestionCode_CONFIG_ALLOWLIST_VALIDATORS SuggestionCode = 708
	// Only the allow listed transformers are acceptable in skaffold-managed mode.
	SuggestionCode_CONFIG_ALLOWLIST_transformers SuggestionCode = 709
	// Check mising manifest file section of config and fix as needed.
	SuggestionCode_CONFIG_FIX_MISSING_MANIFEST_FILE SuggestionCode = 710
	// Create new build env in a profile instead, or use the 'modify' command
	SuggestionCode_INSPECT_USE_MODIFY_OR_NEW_PROFILE SuggestionCode = 800
	// Check profile selection, or use the 'add' command instead
	SuggestionCode_INSPECT_USE_ADD_BUILD_ENV SuggestionCode = 801
	// Check profile flag value
	SuggestionCode_INSPECT_CHECK_INPUT_PROFILE SuggestionCode = 802
	// Open an issue so this situation can be diagnosed
	SuggestionCode_OPEN_ISSUE SuggestionCode = 900
	// Test error suggestion codes
	SuggestionCode_CHECK_CUSTOM_COMMAND                    SuggestionCode = 1000
	SuggestionCode_FIX_CUSTOM_COMMAND_TIMEOUT              SuggestionCode = 1001
	SuggestionCode_CHECK_CUSTOM_COMMAND_DEPENDENCIES_CMD   SuggestionCode = 1002
	SuggestionCode_CHECK_CUSTOM_COMMAND_DEPENDENCIES_PATHS SuggestionCode = 1003
	SuggestionCode_CHECK_TEST_COMMAND_AND_IMAGE_NAME       SuggestionCode = 1004
)

var SuggestionCode_name = map[int32]string{
	0:    "NIL",
	100:  "ADD_DEFAULT_REPO",
	101:  "CHECK_DEFAULT_REPO",
	102:  "CHECK_DEFAULT_REPO_GLOBAL_CONFIG",
	103:  "GCLOUD_DOCKER_AUTH_CONFIGURE",
	104:  "DOCKER_AUTH_CONFIGURE",
	105:  "CHECK_GCLOUD_PROJECT",
	106:  "CHECK_DOCKER_RUNNING",
	107:  "FIX_USER_BUILD_ERR",
	108:  "DOCKER_BUILD_RETRY",
	109:  "FIX_CACHE_FROM_ARTIFACT_CONFIG",
	110:  "FIX_SKAFFOLD_CONFIG_DOCKERFILE",
	111:  "FIX_JIB_PLUGIN_CONFIGURATION",
	112:  "FIX_DOCKER_NETWORK_CONTAINER_NAME",
	113:  "CHECK_DOCKER_NETWORK_CONTAINER_RUNNING",
	114:  "FIX_DOCKER_NETWORK_MODE_WHEN_EXTRACTING_CONTAINER_NAME",
	115:  "RUN_DOCKER_PRUNE",
	116:  "SET_CLEANUP_FLAG",
	201:  "CHECK_CLUSTER_CONNECTION",
	202:  "CHECK_MINIKUBE_STATUS",
	203:  "INSTALL_HELM",
	204:  "UPGRADE_HELM",
	205:  "FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES",
	206:  "UPGRADE_HELM32",
	207:  "FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE",
	220:  "INSTALL_KUBECTL",
	301:  "CHECK_CONTAINER_LOGS",
	302:  "CHECK_READINESS_PROBE",
	303:  "CHECK_CONTAINER_IMAGE",
	400:  "ADDRESS_NODE_MEMORY_PRESSURE",
	401:  "ADDRESS_NODE_DISK_PRESSURE",
	402:  "ADDRESS_NODE_NETWORK_UNAVAILABLE",
	403:  "ADDRESS_NODE_PID_PRESSURE",
	404:  "ADDRESS_NODE_UNSCHEDULABLE",
	405:  "ADDRESS_NODE_UNREACHABLE",
	406:  "ADDRESS_NODE_NOT_READY",
	407:  "ADDRESS_FAILED_SCHEDULING",
	408:  "CHECK_HOST_CONNECTION",
	501:  "START_MINIKUBE",
	502:  "UNPAUSE_MINIKUBE",
	551:  "RUN_DOCKER_PULL",
	600:  "SET_RENDER_FLAG_OFFLINE_FALSE",
	601:  "KPTFILE_MANUAL_INIT",
	602:  "KPTFILE_CHECK_YAML",
	700:  "CONFIG_CHECK_FILE_PATH",
	701:  "CONFIG_CHECK_DEPENDENCY_DEFINITION",
	702:  "CONFIG_CHANGE_NAMES",
	703:  "CONFIG_CHECK_FILTER",
	704:  "CONFIG_CHECK_PROFILE_DEFINITION",
	705:  "CONFIG_CHECK_DEPENDENCY_PROFILES_SELECTION",
	706:  "CONFIG_CHECK_PROFILE_SELECTION",
	707:  "CONFIG_FIX_API_VERSION",
	708:  "CONFIG_ALLOWLIST_VALIDATORS",
	709:  "CONFIG_ALLOWLIST_transformers",
	710:  "CONFIG_FIX_MISSING_MANIFEST_FILE",
	800:  "INSPECT_USE_MODIFY_OR_NEW_PROFILE",
	801:  "INSPECT_USE_ADD_BUILD_ENV",
	802:  "INSPECT_CHECK_INPUT_PROFILE",
	900:  "OPEN_ISSUE",
	1000: "CHECK_CUSTOM_COMMAND",
	1001: "FIX_CUSTOM_COMMAND_TIMEOUT",
	1002: "CHECK_CUSTOM_COMMAND_DEPENDENCIES_CMD",
	1003: "CHECK_CUSTOM_COMMAND_DEPENDENCIES_PATHS",
	1004: "CHECK_TEST_COMMAND_AND_IMAGE_NAME",
}

var SuggestionCode_value = map[string]int32{
	"NIL":                                                    0,
	"ADD_DEFAULT_REPO":                                       100,
	"CHECK_DEFAULT_REPO":                                     101,
	"CHECK_DEFAULT_REPO_GLOBAL_CONFIG":                       102,
	"GCLOUD_DOCKER_AUTH_CONFIGURE":                           103,
	"DOCKER_AUTH_CONFIGURE":                                  104,
	"CHECK_GCLOUD_PROJECT":                                   105,
	"CHECK_DOCKER_RUNNING":                                   106,
	"FIX_USER_BUILD_ERR":                                     107,
	"DOCKER_BUILD_RETRY":                                     108,
	"FIX_CACHE_FROM_ARTIFACT_CONFIG":                         109,
	"FIX_SKAFFOLD_CONFIG_DOCKERFILE":                         110,
	"FIX_JIB_PLUGIN_CONFIGURATION":                           111,
	"FIX_DOCKER_NETWORK_CONTAINER_NAME":                      112,
	"CHECK_DOCKER_NETWORK_CONTAINER_RUNNING":                 113,
	"FIX_DOCKER_NETWORK_MODE_WHEN_EXTRACTING_CONTAINER_NAME": 114,
	"RUN_DOCKER_PRUNE":                                       115,
	"SET_CLEANUP_FLAG":                                       116,
	"CHECK_CLUSTER_CONNECTION":                               201,
	"CHECK_MINIKUBE_STATUS":                                  202,
	"INSTALL_HELM":                                           203,
	"UPGRADE_HELM":                                           204,
	"FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES":            205,
	"UPGRADE_HELM32":                                         206,
	"FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE":              207,
	"INSTALL_KUBECTL":                                        220,
	"CHECK_CONTAINER_LOGS":                                   301,
	"CHECK_READINESS_PROBE":                                  302,
	"CHECK_CONTAINER_IMAGE":                                  303,
	"ADDRESS_NODE_MEMORY_PRESSURE":                           400,
	"ADDRESS_NODE_DISK_PRESSURE":                             401,
	"ADDRESS_NODE_NETWORK_UNAVAILABLE":                       402,
	"ADDRESS_NODE_PID_PRESSURE":                              403,
	"ADDRESS_NODE_UNSCHEDULABLE":                             404,
	"ADDRESS_NODE_UNREACHABLE":                               405,
	"ADDRESS_NODE_NOT_READY":                                 406,
	"ADDRESS_FAILED_SCHEDULING":                              407,
	"CHECK_HOST_CONNECTION":                                  408,
	"START_MINIKUBE":                                         501,
	"UNPAUSE_MINIKUBE":                                       502,
	"RUN_DOCKER_PULL":                                        551,
	"SET_RENDER_FLAG_OFFLINE_FALSE":                          600,
	"KPTFILE_MANUAL_INIT":                                    601,
	"KPTFILE_CHECK_YAML":                                     602,
	"CONFIG_CHECK_FILE_PATH":                                 700,
	"CONFIG_CHECK_DEPENDENCY_DEFINITION":                     701,
	"CONFIG_CHANGE_NAMES":                                    702,
	"CONFIG_CHECK_FILTER":                                    703,
	"CONFIG_CHECK_PROFILE_DEFINITION":                        704,
	"CONFIG_CHECK_DEPENDENCY_PROFILES_SELECTION":             705,
	"CONFIG_CHECK_PROFILE_SELECTION":                         706,
	"CONFIG_FIX_API_VERSION":                                 707,
	"CONFIG_ALLOWLIST_VALIDATORS":                            708,
	"CONFIG_ALLOWLIST_transformers":                          709,
	"CONFIG_FIX_MISSING_MANIFEST_FILE":                       710,
	"INSPECT_USE_MODIFY_OR_NEW_PROFILE":                      800,
	"INSPECT_USE_ADD_BUILD_ENV":                              801,
	"INSPECT_CHECK_INPUT_PROFILE":                            802,
	"OPEN_ISSUE":                                             900,
	"CHECK_CUSTOM_COMMAND":                                   1000,
	"FIX_CUSTOM_COMMAND_TIMEOUT":                             1001,
	"CHECK_CUSTOM_COMMAND_DEPENDENCIES_CMD":                  1002,
	"CHECK_CUSTOM_COMMAND_DEPENDENCIES_PATHS":                1003,
	"CHECK_TEST_COMMAND_AND_IMAGE_NAME":                      1004,
}

func (x SuggestionCode) String() string {
	return proto.EnumName(SuggestionCode_name, int32(x))
}

func (SuggestionCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_888b6bd9597961ff, []int{7}
}

func init() {
	proto.RegisterEnum("proto.enums.BuilderType", BuilderType_name, BuilderType_value)
	proto.RegisterEnum("proto.enums.BuildType", BuildType_name, BuildType_value)
	proto.RegisterEnum("proto.enums.TesterType", TesterType_name, TesterType_value)
	proto.RegisterEnum("proto.enums.DeployerType", DeployerType_name, DeployerType_value)
	proto.RegisterEnum("proto.enums.ClusterType", ClusterType_name, ClusterType_value)
	proto.RegisterEnum("proto.enums.LogLevel", LogLevel_name, LogLevel_value)
	proto.RegisterEnum("proto.enums.StatusCode", StatusCode_name, StatusCode_value)
	proto.RegisterEnum("proto.enums.SuggestionCode", SuggestionCode_name, SuggestionCode_value)
}

func init() { proto.RegisterFile("enums.proto", fileDescriptor_888b6bd9597961ff) }

var fileDescriptor_888b6bd9597961ff = []byte{
	// 3070 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x59, 0x69, 0x90, 0x1c, 0xc5,
	0x95, 0x66, 0xa6, 0xa7, 0xa7, 0xbb, 0x53, 0x1c, 0x49, 0xa2, 0xfb, 0x96, 0x40, 0x02, 0x06, 0x56,
	0x62, 0x97, 0x0d, 0x7e, 0xec, 0xbf, 0xec, 0xaa, 0xec, 0xee, 0x54, 0x57, 0x65, 0x55, 0x64, 0x66,
	0xcd, 0x68, 0xf4, 0xa7, 0x42, 0xac, 0x46, 0x42, 0x30, 0x52, 0x8b, 0x99, 0x11, 0xbb, 0xec, 0xfa,
	0xe0, 0x87, 0xef, 0x23, 0xc2, 0x17, 0x87, 0x8f, 0x1f, 0x80, 0xed, 0xf0, 0x1f, 0x03, 0xbe, 0x0f,
	0xcc, 0x69, 0x6c, 0x87, 0x31, 0x97, 0x6f, 0x03, 0x61, 0xff, 0xb3, 0x1d, 0x36, 0xc6, 0x47, 0xd8,
	0xdc, 0xa7, 0xe3, 0x65, 0xd6, 0x91, 0xd5, 0xdd, 0x83, 0x7f, 0x10, 0xb4, 0xf2, 0x7d, 0xf5, 0xf2,
	0xe5, 0xcb, 0x97, 0xef, 0x7d, 0xef, 0x0d, 0x5a, 0xb3, 0x70, 0xf2, 0xf4, 0x89, 0xe5, 0x7d, 0xa7,
	0x96, 0x06, 0x2b, 0x03, 0xb2, 0xc6, 0xfc, 0x6f, 0x9f, 0x59, 0x9a, 0x19, 0xa0, 0x35, 0xed, 0xd3,
	0xc7, 0x17, 0x8f, 0x2c, 0x2c, 0xe9, 0xeb, 0x4f, 0x2d, 0x90, 0x8d, 0x68, 0x6d, 0x22, 0xfa, 0x22,
	0x9a, 0x13, 0x69, 0x3b, 0xe1, 0x81, 0xcf, 0x64, 0xaa, 0xe7, 0x63, 0x86, 0xcf, 0x20, 0x0d, 0x54,
	0x3b, 0xc0, 0xdb, 0x78, 0x82, 0xb4, 0x50, 0xbd, 0x4d, 0x0f, 0xb1, 0x00, 0x4f, 0x92, 0xb3, 0x11,
	0x32, 0xa8, 0x98, 0x7a, 0x7d, 0x85, 0x6b, 0x04, 0xa1, 0x69, 0x2f, 0x51, 0x3a, 0x0a, 0xf1, 0x14,
	0xfc, 0xee, 0x53, 0xc1, 0xfb, 0x11, 0xae, 0xc3, 0x6f, 0x3f, 0xf2, 0xfa, 0x4c, 0xe2, 0xe9, 0x19,
	0x1f, 0xb5, 0xcc, 0x86, 0x66, 0xbb, 0xf5, 0x88, 0x54, 0xb6, 0xcb, 0x37, 0x5b, 0x83, 0x1a, 0x5e,
	0x90, 0x28, 0xcd, 0x24, 0x9e, 0x80, 0x9d, 0xbb, 0x5e, 0x1b, 0x4f, 0xc2, 0xce, 0x41, 0xe4, 0xd1,
	0x00, 0xd7, 0x66, 0xfa, 0x08, 0xe9, 0x85, 0xe5, 0x95, 0xcc, 0xea, 0x75, 0xe8, 0xdc, 0x5c, 0x8d,
	0x66, 0x4a, 0xe7, 0x5a, 0x9a, 0x68, 0x2a, 0x11, 0x5c, 0xe3, 0x09, 0xb2, 0x15, 0x6d, 0xf4, 0x22,
	0xa1, 0x29, 0x17, 0x4c, 0xa6, 0x4a, 0xcb, 0xc4, 0xd3, 0x89, 0x64, 0x06, 0x8c, 0x27, 0x67, 0x0e,
	0xa2, 0x33, 0xfd, 0x85, 0x53, 0x8b, 0x83, 0xeb, 0x33, 0x75, 0x9b, 0xd0, 0xba, 0x5c, 0x9d, 0xcf,
	0xe2, 0x20, 0x9a, 0x2f, 0xbd, 0xd0, 0x44, 0x53, 0x3d, 0x16, 0x84, 0x78, 0x82, 0x9c, 0x85, 0x5a,
	0x7d, 0x73, 0x56, 0x7e, 0x88, 0xe1, 0x49, 0xb0, 0xb8, 0x9f, 0xb4, 0x99, 0xa7, 0x03, 0x5c, 0x03,
	0x8b, 0xfb, 0xb1, 0xc6, 0x53, 0x33, 0x1c, 0xad, 0xf1, 0x16, 0x4f, 0x17, 0x76, 0x3a, 0xde, 0xcd,
	0x8e, 0x97, 0xeb, 0x3d, 0x13, 0x35, 0x43, 0x2e, 0x38, 0xa8, 0xc8, 0x4e, 0xdc, 0x67, 0xf6, 0xc4,
	0x91, 0xee, 0x31, 0x89, 0x6b, 0x33, 0x07, 0x50, 0x33, 0x18, 0x1c, 0x0b, 0x16, 0xae, 0x5b, 0x58,
	0x84, 0x65, 0x9f, 0xb5, 0x93, 0xae, 0x35, 0x88, 0x8b, 0x4e, 0x84, 0x27, 0xe0, 0xd7, 0x1c, 0x95,
	0xc2, 0x7e, 0xc5, 0xa4, 0x8c, 0x24, 0xae, 0xc1, 0xcf, 0x0e, 0xd5, 0x34, 0xc0, 0x53, 0xf0, 0x33,
	0xa6, 0x82, 0x7b, 0xb8, 0x3e, 0x73, 0xf7, 0x5e, 0x84, 0xd4, 0xca, 0xe1, 0x95, 0xd3, 0xcb, 0xde,
	0xe0, 0xc8, 0x02, 0x99, 0x46, 0x93, 0x51, 0x1f, 0x9f, 0x41, 0x36, 0xa2, 0xf3, 0x94, 0xa6, 0x3a,
	0x51, 0x5e, 0x8f, 0x79, 0xfd, 0x54, 0x25, 0x9e, 0xc7, 0x94, 0xc2, 0x3f, 0x9c, 0x20, 0x04, 0x9d,
	0x65, 0xef, 0x27, 0x5f, 0x7b, 0x78, 0x82, 0x9c, 0x87, 0xce, 0x96, 0x4c, 0x40, 0x84, 0xe4, 0x8b,
	0x8f, 0x9a, 0x45, 0xeb, 0xb2, 0x62, 0xf1, 0x47, 0x13, 0xe4, 0x5c, 0x74, 0xa6, 0xb9, 0x96, 0x7c,
	0xe9, 0x11, 0x73, 0x21, 0x56, 0x61, 0x9c, 0xa8, 0x5e, 0x4a, 0xcd, 0x7a, 0xea, 0x33, 0xc1, 0x99,
	0x8f, 0x17, 0xc8, 0x16, 0xb4, 0x21, 0x93, 0xca, 0xe8, 0x00, 0xf3, 0x74, 0x2a, 0x22, 0x9d, 0x76,
	0xa2, 0x44, 0xf8, 0xf8, 0x28, 0x39, 0x1f, 0xed, 0xb0, 0x42, 0x1b, 0x52, 0xa9, 0x4f, 0x59, 0x18,
	0x09, 0x03, 0x91, 0x89, 0x10, 0x5c, 0x74, 0xf1, 0x31, 0xb2, 0x16, 0x61, 0x0b, 0x4a, 0x14, 0x93,
	0xa9, 0xf5, 0xc6, 0x55, 0xe5, 0xae, 0xd9, 0xa7, 0x89, 0xa0, 0xb3, 0x94, 0x07, 0xb4, 0x1d, 0x30,
	0x7c, 0x9c, 0x6c, 0x43, 0x9b, 0x86, 0xa5, 0x89, 0xee, 0x45, 0x92, 0x1f, 0x62, 0x3e, 0xbe, 0xba,
	0x34, 0x2a, 0x13, 0xab, 0x79, 0xa5, 0x59, 0x08, 0xba, 0xf1, 0x35, 0x64, 0x17, 0xda, 0x56, 0x11,
	0x82, 0x35, 0x61, 0xe4, 0xf3, 0x0e, 0x67, 0xbe, 0x81, 0x2c, 0x92, 0x0b, 0xd0, 0xce, 0x11, 0x08,
	0x0f, 0xe3, 0x80, 0x85, 0x4c, 0xe8, 0x0c, 0x75, 0x82, 0x6c, 0x47, 0x9b, 0x87, 0x4e, 0xa7, 0x69,
	0x1a, 0x44, 0x4a, 0x19, 0xf9, 0xc9, 0x11, 0x79, 0x27, 0x92, 0x6d, 0xee, 0xfb, 0x4c, 0x18, 0xf9,
	0x60, 0xe4, 0x10, 0x5e, 0x24, 0x3a, 0x01, 0xf7, 0xb4, 0x11, 0x9f, 0x22, 0x3b, 0xd1, 0xd6, 0x8a,
	0xd8, 0x78, 0xc6, 0x71, 0xef, 0xb5, 0x64, 0x37, 0xda, 0x5e, 0x41, 0x70, 0x31, 0x4b, 0x03, 0xee,
	0xa7, 0x31, 0x95, 0xd4, 0x9e, 0x76, 0x69, 0xd8, 0x88, 0x0e, 0x0f, 0x98, 0xa3, 0x63, 0x79, 0xe4,
	0xa8, 0x1e, 0xf5, 0x7a, 0x2c, 0xed, 0xc8, 0x28, 0x4c, 0xe3, 0x24, 0x08, 0x8c, 0x96, 0x15, 0xb2,
	0x03, 0x6d, 0xa9, 0xa0, 0xba, 0x4c, 0xa7, 0x3e, 0xef, 0x42, 0xa4, 0x00, 0xe0, 0xf4, 0xc8, 0x59,
	0x44, 0x94, 0xaa, 0x98, 0x7a, 0xcc, 0x88, 0xdf, 0x59, 0xfa, 0x5c, 0xb2, 0x2e, 0x57, 0x5a, 0xce,
	0x0f, 0x6b, 0xb8, 0xae, 0x84, 0xe4, 0xcf, 0xee, 0x00, 0x6f, 0xa7, 0x71, 0x90, 0x74, 0xb9, 0xb0,
	0x2f, 0xef, 0x7f, 0xca, 0x98, 0x00, 0x51, 0x57, 0x52, 0x3f, 0x60, 0xf0, 0xea, 0x8d, 0x82, 0xff,
	0x2d, 0x2f, 0x1d, 0xa4, 0x21, 0x9d, 0x65, 0xa2, 0x10, 0x5e, 0x4f, 0x66, 0xd0, 0x5e, 0x2e, 0xb8,
	0x2e, 0xcc, 0x63, 0x7a, 0x2e, 0x92, 0xfd, 0x34, 0xe0, 0x4a, 0x73, 0xd1, 0x4d, 0x8b, 0x8c, 0xa3,
	0xf0, 0xff, 0x91, 0x7d, 0x68, 0x66, 0x1c, 0x36, 0xf7, 0x6e, 0x99, 0x9d, 0x04, 0x0d, 0x19, 0xfe,
	0x7f, 0x72, 0x19, 0xba, 0x74, 0x1c, 0xbe, 0xc4, 0xf9, 0x11, 0x53, 0xc6, 0xe9, 0xec, 0x20, 0x57,
	0x1a, 0xbf, 0x0d, 0x9c, 0xfe, 0x56, 0x3b, 0x84, 0x91, 0xcf, 0xf0, 0xdb, 0xc1, 0x23, 0xe3, 0x50,
	0x31, 0x95, 0xca, 0xfa, 0xf5, 0x1d, 0x64, 0x07, 0xda, 0xec, 0xa6, 0x01, 0x1e, 0xd2, 0x2e, 0x2b,
	0xef, 0xed, 0x8b, 0x93, 0xe4, 0x7c, 0xb4, 0xdd, 0x05, 0x94, 0x36, 0x79, 0x92, 0x51, 0x38, 0x3a,
	0xbe, 0x63, 0x92, 0xec, 0x46, 0xdb, 0x5c, 0x90, 0x4c, 0x84, 0x03, 0x04, 0x45, 0x77, 0x4e, 0x92,
	0x3d, 0x68, 0xe7, 0x78, 0x45, 0x9a, 0xc9, 0x90, 0x0b, 0xaa, 0x99, 0x8f, 0xef, 0x9a, 0x24, 0x97,
	0xa0, 0xbd, 0x2e, 0xcc, 0x26, 0x18, 0x78, 0x35, 0xa9, 0x8c, 0x82, 0x20, 0x4a, 0x74, 0x1a, 0x33,
	0xe1, 0xc3, 0xbe, 0x5f, 0x7a, 0x0b, 0x9d, 0x92, 0x29, 0x4d, 0xa5, 0x31, 0xef, 0xb7, 0x93, 0x64,
	0x33, 0x5a, 0xe7, 0xc2, 0x12, 0xd1, 0x63, 0x34, 0xd0, 0xbd, 0x79, 0xfc, 0xbb, 0xb7, 0x50, 0xc1,
	0x0e, 0x32, 0x2f, 0x4b, 0x26, 0xbf, 0x1f, 0x81, 0x89, 0xc8, 0x67, 0x69, 0xc8, 0xc2, 0x48, 0xce,
	0xa7, 0xb1, 0x64, 0x4a, 0x25, 0x92, 0xe1, 0x8f, 0xd4, 0x86, 0xbd, 0x65, 0x60, 0x3e, 0x57, 0xfd,
	0x12, 0xf4, 0xd1, 0x1a, 0xb9, 0x18, 0x5d, 0x30, 0x02, 0xca, 0xef, 0xc6, 0xcd, 0x52, 0x1f, 0xab,
	0x0d, 0x3b, 0xd6, 0x40, 0x63, 0x78, 0xa0, 0xb9, 0xba, 0x8f, 0x8f, 0xdf, 0x33, 0x11, 0xf0, 0x2f,
	0x3f, 0xb1, 0x8a, 0x3e, 0x51, 0x23, 0xbb, 0xd0, 0xd6, 0x31, 0x20, 0xc9, 0xa8, 0xd7, 0x33, 0x90,
	0x1b, 0x6b, 0xc3, 0xa1, 0x60, 0xcd, 0x82, 0x44, 0xcb, 0xa8, 0x3f, 0x8f, 0x6f, 0x1a, 0x31, 0xa6,
	0x43, 0x79, 0xc0, 0xfc, 0x34, 0xdb, 0x08, 0x5c, 0x7d, 0x73, 0x8d, 0x5c, 0x88, 0x76, 0xbb, 0x98,
	0xac, 0x4c, 0x82, 0x5b, 0x05, 0xf3, 0x34, 0x8f, 0x6c, 0xea, 0xfa, 0xe4, 0x88, 0xd5, 0x39, 0x10,
	0x0e, 0xd7, 0xe7, 0x41, 0xc0, 0x7c, 0xfc, 0xa9, 0x11, 0x4f, 0x15, 0xda, 0x02, 0x0e, 0x01, 0xd1,
	0x61, 0xda, 0xeb, 0x19, 0x7d, 0x9f, 0xae, 0x0d, 0x5f, 0x90, 0x13, 0x37, 0x25, 0xec, 0x33, 0x23,
	0x7e, 0x88, 0x23, 0x3f, 0x85, 0x27, 0xc2, 0x69, 0xc0, 0x0f, 0xc1, 0x11, 0x1e, 0xaa, 0x41, 0xfd,
	0xcb, 0x33, 0x88, 0xbd, 0xfe, 0xe7, 0x6a, 0xc3, 0xd5, 0x32, 0x93, 0xe3, 0xe7, 0x6b, 0x64, 0x2f,
	0xda, 0x35, 0x46, 0x32, 0x74, 0x01, 0x2f, 0xd4, 0xc8, 0x0c, 0xda, 0x33, 0x3e, 0xce, 0xe6, 0x28,
	0x37, 0x19, 0x24, 0xd7, 0xf9, 0x62, 0x8d, 0x6c, 0x47, 0x9b, 0xc6, 0xe9, 0x64, 0xb3, 0x4c, 0x68,
	0xfc, 0x7a, 0xcd, 0x29, 0xbc, 0xf9, 0x47, 0x2f, 0xd5, 0xa0, 0xf0, 0xaa, 0x79, 0xe1, 0x15, 0x4b,
	0x2f, 0xd7, 0xca, 0x4a, 0x9e, 0xaf, 0xbd, 0x52, 0x23, 0x6b, 0xd1, 0x39, 0x3e, 0x9b, 0x35, 0x69,
	0x21, 0x5f, 0x7d, 0xd5, 0xac, 0x7a, 0x01, 0xa3, 0x22, 0x89, 0x8b, 0xd5, 0xd7, 0x8c, 0xca, 0x0a,
	0xf0, 0x8d, 0x1a, 0xd9, 0x84, 0xd6, 0x0e, 0xd5, 0x4d, 0x2b, 0x7a, 0xb3, 0x56, 0x54, 0xfe, 0x7c,
	0xe9, 0x86, 0x29, 0x50, 0x6b, 0x6c, 0x32, 0x5a, 0xac, 0x33, 0x9f, 0x9a, 0x22, 0x3b, 0xd1, 0x96,
	0xdc, 0x04, 0x9b, 0xcd, 0x99, 0xcc, 0x18, 0xa1, 0xcf, 0x62, 0x85, 0xef, 0xad, 0x43, 0x28, 0x8e,
	0x20, 0x8c, 0x6e, 0x03, 0xb8, 0xaf, 0x0e, 0xd7, 0x38, 0x02, 0xc8, 0x5c, 0x62, 0x20, 0xf7, 0xd7,
	0xc7, 0xee, 0x02, 0x05, 0x92, 0x77, 0x01, 0x82, 0x1f, 0xa8, 0x93, 0x0b, 0xd0, 0x8e, 0xd2, 0x15,
	0x2a, 0x89, 0xe3, 0x48, 0x42, 0x6d, 0x9e, 0xfd, 0xf7, 0x34, 0xa4, 0x82, 0x77, 0x80, 0x2f, 0x3e,
	0x58, 0x1f, 0x7e, 0x16, 0x86, 0x63, 0x78, 0x54, 0x78, 0xcc, 0x04, 0xe9, 0xad, 0xd3, 0xc3, 0xcf,
	0xc2, 0x67, 0xd4, 0x0f, 0xb8, 0x60, 0x29, 0x3b, 0xe8, 0x31, 0xe6, 0x33, 0x1f, 0xdf, 0x36, 0x0d,
	0x8e, 0xb0, 0x27, 0x2c, 0xbf, 0xbc, 0x7d, 0x9a, 0xac, 0x43, 0x38, 0x33, 0xba, 0x5c, 0xfe, 0xec,
	0x34, 0xd9, 0x82, 0xd6, 0x0f, 0x55, 0xd4, 0x5c, 0xf8, 0xb9, 0x69, 0xc8, 0x65, 0x55, 0xce, 0x90,
	0x6d, 0x87, 0x3f, 0x3f, 0x4d, 0xb6, 0xa1, 0x8d, 0xe6, 0x34, 0x26, 0x35, 0xb3, 0x54, 0xd3, 0x6e,
	0xb7, 0x20, 0x44, 0xef, 0x6e, 0xc0, 0x49, 0x8c, 0x38, 0x27, 0x9f, 0x69, 0x4c, 0x13, 0x65, 0xc9,
	0x48, 0x24, 0xf1, 0x7b, 0x1a, 0xe0, 0x90, 0x2a, 0xc0, 0xe1, 0x59, 0x19, 0xea, 0xbd, 0x0d, 0x88,
	0x4e, 0x77, 0x97, 0xbc, 0x75, 0xb0, 0xf2, 0xf7, 0x95, 0xdb, 0x64, 0xf2, 0x82, 0x55, 0x5b, 0xc0,
	0xfb, 0x47, 0x00, 0xf9, 0xc5, 0x66, 0x80, 0x0f, 0x34, 0xc0, 0x2f, 0x16, 0x60, 0xa8, 0x84, 0x5d,
	0xfe, 0x60, 0x69, 0x5e, 0xf6, 0xdd, 0x1c, 0x85, 0x77, 0xad, 0x25, 0x77, 0x4e, 0xf9, 0xa1, 0x06,
	0x24, 0x16, 0x17, 0x05, 0x55, 0xa0, 0x43, 0x3d, 0x77, 0x87, 0x0f, 0x37, 0xe0, 0xce, 0x72, 0xcf,
	0x67, 0xdc, 0x7c, 0x28, 0x43, 0xfd, 0xb1, 0x01, 0x19, 0xa5, 0x08, 0xa9, 0x76, 0xd2, 0x4d, 0x7b,
	0x2c, 0x88, 0x4d, 0x69, 0xd1, 0x92, 0xb3, 0x59, 0x5b, 0x40, 0x9f, 0x69, 0x90, 0x0d, 0x88, 0x14,
	0xaa, 0xec, 0x0b, 0x02, 0xc1, 0x9f, 0x1a, 0x70, 0x1b, 0x99, 0x00, 0xba, 0x88, 0x94, 0xc6, 0x71,
	0x30, 0x9f, 0x06, 0xb4, 0xcd, 0x02, 0x85, 0x9f, 0x6d, 0xc0, 0x4b, 0x72, 0xc5, 0x39, 0x77, 0xc5,
	0x7f, 0x76, 0xbf, 0x14, 0x51, 0x1a, 0xc2, 0x31, 0xe1, 0x02, 0x8c, 0xa3, 0xf1, 0x5f, 0x1a, 0x64,
	0x2b, 0xda, 0xe0, 0x7e, 0x39, 0xcb, 0xa4, 0xca, 0xcd, 0xfe, 0x6b, 0xc3, 0xc6, 0x7d, 0x29, 0x0d,
	0xb9, 0xa8, 0x20, 0xfe, 0xd6, 0xb0, 0xaf, 0xcb, 0x20, 0xf2, 0x84, 0xea, 0x02, 0x7e, 0xd1, 0xb4,
	0x0f, 0xa3, 0x02, 0x88, 0x3a, 0x1d, 0x13, 0xd3, 0x40, 0x2c, 0x0c, 0xea, 0xef, 0x0d, 0x07, 0xc5,
	0x64, 0x99, 0xc6, 0x3a, 0x11, 0xc4, 0x64, 0xc0, 0xc0, 0x93, 0xf8, 0x1f, 0xee, 0x59, 0xa0, 0x8e,
	0x14, 0x2f, 0xcb, 0x28, 0x79, 0xce, 0x55, 0x62, 0xc4, 0x92, 0x85, 0x91, 0x66, 0x55, 0xd4, 0xf3,
	0xae, 0x12, 0xe0, 0x5b, 0x55, 0xf1, 0x0b, 0xae, 0x43, 0x72, 0x7b, 0x0b, 0x6f, 0xbe, 0x68, 0xe2,
	0xb5, 0x90, 0x66, 0x3d, 0x5c, 0x29, 0x7f, 0xa9, 0x6a, 0x61, 0x1c, 0x00, 0xe5, 0xb4, 0x2c, 0x08,
	0xc4, 0x2f, 0xbb, 0xa1, 0xa2, 0x25, 0x15, 0xaa, 0x13, 0xc9, 0xb0, 0x6a, 0xc0, 0x2b, 0xee, 0x5d,
	0x2a, 0xa6, 0xed, 0x1d, 0x1b, 0xd1, 0xab, 0xee, 0xee, 0xc5, 0x47, 0x73, 0x92, 0x6b, 0xab, 0xfe,
	0x35, 0x37, 0xca, 0x2c, 0x2d, 0x2b, 0x50, 0xc6, 0x08, 0xdb, 0x09, 0xbc, 0xde, 0x20, 0x17, 0xa1,
	0xf3, 0xdd, 0x5b, 0xcd, 0x82, 0x5b, 0x58, 0x56, 0x58, 0x52, 0x86, 0x37, 0x1a, 0x50, 0x81, 0x87,
	0x42, 0x9b, 0x0b, 0xcd, 0xa4, 0xa0, 0x81, 0xdb, 0xc5, 0xbc, 0x59, 0xf1, 0x5a, 0xac, 0x0d, 0xad,
	0xcf, 0xd3, 0x34, 0xbe, 0xa1, 0x09, 0x47, 0xb2, 0xd9, 0x5c, 0x95, 0x79, 0x13, 0x44, 0x8f, 0x35,
	0xc9, 0x7a, 0x74, 0xae, 0x11, 0x79, 0xb9, 0x18, 0xd6, 0x1f, 0x2f, 0xd7, 0x79, 0xd8, 0x2d, 0x29,
	0xe4, 0x13, 0x4d, 0x70, 0x81, 0xc5, 0x1b, 0xf7, 0xa7, 0x5e, 0xe8, 0x3b, 0x14, 0xf4, 0xc7, 0x4d,
	0x28, 0x8d, 0xc3, 0x72, 0x60, 0x90, 0x22, 0x12, 0xe9, 0x21, 0x26, 0x23, 0x20, 0xbd, 0xd6, 0xac,
	0x9f, 0x34, 0xc1, 0x5d, 0xe3, 0xb0, 0x9a, 0x87, 0xcc, 0x07, 0x72, 0x08, 0xb0, 0x9f, 0x36, 0xa1,
	0x2a, 0x8f, 0x83, 0x15, 0x99, 0xd4, 0xe0, 0x7e, 0xb6, 0x2a, 0x0e, 0xb8, 0x5f, 0x52, 0xe4, 0x82,
	0x9f, 0x37, 0x21, 0xa9, 0x8c, 0xc7, 0xf1, 0xbc, 0x9b, 0xfb, 0x65, 0x13, 0x1c, 0x3a, 0x16, 0x24,
	0x25, 0xfe, 0xd5, 0x88, 0xe5, 0x3e, 0x03, 0x1e, 0xcb, 0x84, 0xc7, 0x99, 0x32, 0x50, 0x80, 0x3d,
	0xd9, 0x24, 0x97, 0xa2, 0x0b, 0x57, 0x85, 0x25, 0x22, 0xa4, 0x52, 0xf5, 0x68, 0xe6, 0xda, 0xa7,
	0x9a, 0x50, 0x07, 0x47, 0xb6, 0x74, 0xf3, 0xd3, 0xd3, 0xc6, 0xaa, 0xac, 0x75, 0x1f, 0xb9, 0xe6,
	0xdf, 0xac, 0x81, 0xf7, 0x37, 0x22, 0xb5, 0x3d, 0xc4, 0x3c, 0x0d, 0xed, 0x36, 0x2f, 0x23, 0x70,
	0xd3, 0x2a, 0x28, 0x28, 0x7a, 0x21, 0xb5, 0xef, 0x00, 0xc1, 0x5e, 0x59, 0xa8, 0x18, 0x10, 0xdc,
	0x72, 0x56, 0x3a, 0xf0, 0x97, 0x5b, 0x10, 0x07, 0xae, 0xb4, 0x68, 0x22, 0x8d, 0xfc, 0x2b, 0x2d,
	0xb0, 0xa5, 0x2c, 0xd0, 0xf6, 0xd4, 0xf3, 0x43, 0xa8, 0xaf, 0xb6, 0x80, 0x13, 0xe6, 0xa8, 0x24,
	0x0e, 0xb8, 0x67, 0xde, 0x01, 0x0d, 0x99, 0x4a, 0x15, 0x0d, 0x99, 0x55, 0x0d, 0xd0, 0xaf, 0xb5,
	0xc0, 0x97, 0xab, 0x40, 0xa9, 0x27, 0xa1, 0xcd, 0x06, 0xb0, 0x7d, 0x62, 0x5f, 0x6f, 0x41, 0x65,
	0xcd, 0xd0, 0x6d, 0xea, 0x83, 0x48, 0x67, 0xa1, 0xfd, 0x0d, 0x57, 0x66, 0x22, 0xb2, 0x34, 0xe8,
	0x9b, 0xee, 0xb1, 0x6c, 0x8a, 0x8f, 0x65, 0x54, 0xea, 0xfd, 0x96, 0x2b, 0xf7, 0x59, 0x87, 0x26,
	0x81, 0x4e, 0x67, 0x69, 0x90, 0x64, 0xf2, 0x6f, 0xb7, 0xe0, 0xc1, 0x56, 0x9d, 0xa6, 0x7b, 0x2a,
	0x55, 0x49, 0x5b, 0x69, 0xae, 0xcb, 0x20, 0xbc, 0xbb, 0x45, 0xfe, 0x0d, 0x5d, 0x94, 0x01, 0xc3,
	0x24, 0xd0, 0x3c, 0xe5, 0x21, 0x30, 0x96, 0x7c, 0xbf, 0x6a, 0xf7, 0xff, 0x9d, 0x16, 0x24, 0xae,
	0x0c, 0x5e, 0x58, 0x54, 0x75, 0xe6, 0x3d, 0x2d, 0x88, 0xeb, 0x0c, 0x93, 0x93, 0x4c, 0x1a, 0xf3,
	0x4a, 0x39, 0xb8, 0xb7, 0x05, 0x09, 0x72, 0x08, 0x64, 0xee, 0x9e, 0xea, 0x48, 0xe2, 0xfb, 0x5a,
	0x50, 0x4e, 0x86, 0xc4, 0x45, 0xa2, 0x64, 0x12, 0xdf, 0xdf, 0x82, 0xc8, 0xcf, 0xed, 0xe6, 0xca,
	0x04, 0x44, 0x91, 0xe4, 0x8a, 0xdb, 0x7a, 0xa0, 0x05, 0x1c, 0x9b, 0x0b, 0x15, 0x33, 0x4f, 0xa7,
	0x0e, 0xff, 0xc6, 0x37, 0x22, 0xb8, 0xf2, 0x5c, 0x62, 0xb9, 0x0f, 0x13, 0xb3, 0x29, 0x0d, 0x4c,
	0x63, 0x62, 0x5b, 0x62, 0xeb, 0xcc, 0x9b, 0x56, 0x81, 0x72, 0xe1, 0x45, 0x52, 0xc2, 0x9a, 0x9e,
	0x8f, 0xed, 0x7e, 0x37, 0x23, 0xf0, 0x4f, 0x0e, 0xcd, 0x5d, 0x58, 0xf5, 0xcf, 0x2d, 0x68, 0xe6,
	0x99, 0x73, 0xd0, 0xd9, 0xea, 0xf4, 0xb1, 0x63, 0x0b, 0xcb, 0x2b, 0xc7, 0x07, 0x27, 0xcd, 0x00,
	0xad, 0x81, 0x6a, 0x82, 0x07, 0xf8, 0x0c, 0xb2, 0x16, 0x61, 0xea, 0xfb, 0xc5, 0xa5, 0x4a, 0x16,
	0x47, 0xf8, 0x08, 0x59, 0x8f, 0x48, 0xce, 0x03, 0x9d, 0xf5, 0x05, 0xe8, 0xd8, 0x47, 0xd7, 0xd3,
	0x6e, 0x10, 0xb5, 0x69, 0x90, 0xe5, 0x57, 0x7c, 0x94, 0xec, 0x44, 0x5b, 0xbb, 0x5e, 0x10, 0x25,
	0x05, 0xbd, 0xa3, 0x89, 0xee, 0x65, 0x62, 0x68, 0xf7, 0x8e, 0x91, 0x4d, 0x68, 0xdd, 0x78, 0xd1,
	0x55, 0x64, 0x23, 0x5a, 0x6b, 0xb7, 0xc8, 0x54, 0x64, 0x03, 0x35, 0x7c, 0xbc, 0x94, 0x64, 0x9f,
	0xe6, 0xb3, 0xb3, 0xab, 0xc1, 0xdc, 0x0e, 0x3f, 0x68, 0xd3, 0x78, 0xe6, 0x30, 0x33, 0xe3, 0x5a,
	0x8f, 0x48, 0x86, 0xcd, 0xc7, 0x2e, 0x5a, 0xce, 0xe3, 0x45, 0xb2, 0x1b, 0x6d, 0x07, 0xbc, 0x33,
	0xe4, 0x29, 0x08, 0x56, 0x76, 0x88, 0x13, 0x39, 0x46, 0xf5, 0x69, 0xa7, 0x13, 0x05, 0x7e, 0xc1,
	0xba, 0x8b, 0xf9, 0x11, 0x3e, 0x09, 0x07, 0x05, 0x8c, 0x33, 0xa2, 0xc9, 0x4f, 0x42, 0x0d, 0x73,
	0x18, 0x90, 0x3d, 0x68, 0x17, 0x20, 0x56, 0x9d, 0x89, 0x98, 0xd9, 0xc9, 0x29, 0x32, 0x83, 0xf6,
	0x56, 0x8e, 0x36, 0x0a, 0xcc, 0x0f, 0x7b, 0x2d, 0xf9, 0x2f, 0x74, 0xc5, 0x18, 0x95, 0x86, 0xd3,
	0xcc, 0xf5, 0x18, 0xa4, 0x73, 0x2d, 0xa9, 0x57, 0x9d, 0xe7, 0xd8, 0x7d, 0x96, 0xe0, 0xb6, 0x21,
	0x99, 0x67, 0xdf, 0xc6, 0x32, 0x11, 0x0c, 0x2f, 0xc3, 0x2a, 0x54, 0xfc, 0x9c, 0xf9, 0x75, 0x02,
	0xda, 0xc5, 0x2b, 0xe6, 0xc1, 0xd8, 0x2e, 0x6f, 0x84, 0x5c, 0xe2, 0x87, 0x27, 0x4c, 0x32, 0x31,
	0xe2, 0x82, 0x67, 0xdb, 0xfe, 0x21, 0x1b, 0x9f, 0x72, 0xa1, 0x34, 0xa4, 0x78, 0x33, 0x7b, 0x7e,
	0xc4, 0x2c, 0x25, 0x71, 0x57, 0x52, 0x9f, 0xd9, 0xa5, 0x47, 0x27, 0xc8, 0x65, 0xe8, 0x92, 0x71,
	0x1e, 0xb6, 0x3c, 0x33, 0xbf, 0x8f, 0x68, 0x96, 0x49, 0xc9, 0x7d, 0xa6, 0xf0, 0x63, 0x66, 0x56,
	0xeb, 0x2a, 0xb9, 0xfc, 0x3f, 0xf0, 0xe3, 0x13, 0x64, 0x1f, 0xba, 0x78, 0x55, 0x35, 0x39, 0xc3,
	0x80, 0x74, 0x19, 0x53, 0x8f, 0xe1, 0x27, 0x26, 0xa0, 0x8b, 0xc9, 0x8d, 0xcb, 0xe7, 0xdf, 0xbf,
	0x9e, 0x00, 0xa6, 0x30, 0xdc, 0xd3, 0x06, 0x51, 0x57, 0xe1, 0x3b, 0x26, 0xcb, 0x93, 0xc2, 0x53,
	0xe5, 0x82, 0x29, 0x05, 0x41, 0xd9, 0x66, 0xf8, 0x4e, 0x47, 0x56, 0x7e, 0x66, 0x28, 0x0f, 0xbe,
	0x6b, 0x12, 0xca, 0x1a, 0xf5, 0x7d, 0x09, 0xf8, 0xd5, 0x26, 0x2d, 0x3b, 0xd0, 0xe6, 0x0a, 0x64,
	0x64, 0xca, 0xb2, 0x07, 0xed, 0xac, 0x00, 0x56, 0x99, 0xb0, 0x6c, 0x47, 0x9b, 0x2a, 0xb0, 0xe1,
	0xe9, 0xca, 0xf0, 0x3e, 0x23, 0x93, 0x95, 0x6d, 0x68, 0xe3, 0x10, 0xa0, 0x32, 0x55, 0xd9, 0x82,
	0xd6, 0x57, 0xcd, 0x70, 0x27, 0x2a, 0xce, 0xe6, 0x63, 0xa7, 0x29, 0x85, 0x8f, 0x7a, 0x91, 0xd2,
	0x6e, 0x14, 0xdd, 0x62, 0x86, 0x00, 0x66, 0xc6, 0x55, 0x44, 0x11, 0x7e, 0xbe, 0x06, 0x9d, 0x53,
	0x22, 0x4c, 0x5b, 0x57, 0x2e, 0xbf, 0x60, 0xda, 0x7b, 0x37, 0x78, 0x93, 0x20, 0xc0, 0x5f, 0x98,
	0x32, 0x8d, 0x2b, 0x03, 0x6b, 0x4c, 0x65, 0x87, 0xd8, 0x2d, 0x78, 0x7e, 0x87, 0x06, 0x8a, 0xe1,
	0x27, 0xa7, 0x20, 0x29, 0xe7, 0x25, 0x3f, 0xa4, 0x22, 0xa1, 0x81, 0x61, 0x0f, 0xd0, 0xc5, 0x6f,
	0x40, 0x24, 0x97, 0x58, 0x1b, 0x81, 0x30, 0xe0, 0xa7, 0xa7, 0xe0, 0xc4, 0x59, 0x20, 0x65, 0x73,
	0xa2, 0xbc, 0xaa, 0xe1, 0x7b, 0xea, 0x4e, 0xb1, 0x2b, 0xe6, 0x34, 0x79, 0xa5, 0xf7, 0x59, 0xc7,
	0x8c, 0x62, 0x22, 0x81, 0xef, 0xad, 0xc3, 0xc6, 0x05, 0x90, 0x8a, 0x6e, 0x16, 0x89, 0xd0, 0xfb,
	0xbb, 0x92, 0x4c, 0xbf, 0x86, 0x42, 0x53, 0x77, 0x08, 0x44, 0x36, 0xdd, 0xc9, 0xd2, 0xba, 0xa3,
	0xf9, 0x81, 0x3a, 0xd9, 0x8f, 0x66, 0x56, 0x33, 0xa1, 0x28, 0x94, 0x8a, 0x05, 0x99, 0xa7, 0x1f,
	0xac, 0x3b, 0x45, 0xb2, 0xaa, 0xb6, 0x04, 0x7d, 0xb7, 0xee, 0x9c, 0x1a, 0x9e, 0x94, 0x53, 0x45,
	0xf1, 0x43, 0x66, 0x16, 0x91, 0x53, 0x84, 0x20, 0x88, 0xe6, 0x4c, 0x13, 0x53, 0xd4, 0x50, 0x85,
	0xbf, 0x57, 0x77, 0x8a, 0x75, 0x89, 0x58, 0x59, 0x3a, 0x7c, 0x72, 0xf9, 0xe8, 0x60, 0xe9, 0xc4,
	0xc2, 0xd2, 0x32, 0xfe, 0x7e, 0xdd, 0xa9, 0xa3, 0xb0, 0xc5, 0xd8, 0x5a, 0x8a, 0x7f, 0x50, 0x07,
	0xb2, 0x56, 0xd4, 0x51, 0xc5, 0xec, 0x5f, 0x26, 0xe6, 0xd3, 0x08, 0x12, 0xde, 0x5c, 0x6e, 0x3b,
	0xbe, 0x75, 0xda, 0xf6, 0xf1, 0x25, 0x0e, 0x6a, 0x59, 0x51, 0x32, 0xf1, 0x6d, 0xd3, 0x60, 0x74,
	0x2e, 0xcf, 0x86, 0xc3, 0x22, 0x4e, 0x8a, 0x5a, 0x89, 0x6f, 0x9f, 0x26, 0xe7, 0x20, 0x14, 0xc5,
	0x4c, 0xa4, 0x5c, 0xa9, 0x84, 0xe1, 0x77, 0x35, 0x9c, 0x54, 0x90, 0xf1, 0xd1, 0x28, 0x0c, 0xa9,
	0xf0, 0xf1, 0x1f, 0x4c, 0xd3, 0x69, 0x0a, 0x47, 0x45, 0x60, 0x78, 0x7b, 0x94, 0x68, 0x68, 0xb7,
	0x67, 0xd0, 0x9e, 0x71, 0xdf, 0x8e, 0x10, 0x65, 0xe8, 0xb9, 0x81, 0xd8, 0xfd, 0x4b, 0xac, 0x21,
	0x52, 0xd0, 0x88, 0xef, 0x45, 0xbb, 0x2c, 0xda, 0x52, 0xe5, 0x0c, 0x0b, 0xff, 0xd9, 0x46, 0xcf,
	0x64, 0xf8, 0x67, 0x1b, 0xed, 0x2b, 0x0e, 0xfd, 0xe7, 0xb1, 0xe3, 0x2b, 0x57, 0x9d, 0xbe, 0x72,
	0xdf, 0x7f, 0x0f, 0x4e, 0xec, 0xef, 0x0e, 0x06, 0xc7, 0x16, 0x17, 0xbc, 0xc1, 0xc9, 0x95, 0xc3,
	0xc7, 0x4f, 0x2e, 0x2c, 0xe9, 0xc1, 0x60, 0x71, 0x79, 0xff, 0xf2, 0x35, 0x87, 0x8f, 0x1e, 0x1d,
	0x2c, 0x1e, 0xd9, 0x6f, 0xfe, 0xac, 0xba, 0xdf, 0xfc, 0x59, 0xf5, 0xca, 0x69, 0xf3, 0x8f, 0xcb,
	0xff, 0x19, 0x00, 0x00, 0xff, 0xff, 0x8f, 0xef, 0xd2, 0x57, 0x79, 0x1d, 0x00, 0x00,
}
