/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.thirdParty.ruler.PjAxes;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PsAboutDialog;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay_IP;
import jv.viewer.PvGeometry;
import jv.viewer.PvGrid;
import jv.viewer.PvModelCamera;
import jv.viewer.PvScene;

public final class PvDisplay
extends Canvas
implements PvDisplayIf,
Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
ActionListener,
Serializable {
    private static final int MOUSE_PICKED = 101;
    private static final int MOUSE_DRAGGED = 102;
    private static final int MOUSE_RELEASED = 103;
    protected static final int KEY_0 = 48;
    protected static final int KEY_1 = 49;
    protected static final int KEY_2 = 50;
    protected static final int KEY_3 = 51;
    protected static final int KEY_4 = 52;
    protected static final int KEY_5 = 53;
    protected static final int KEY_6 = 54;
    protected static final int KEY_7 = 55;
    protected static final int KEY_8 = 56;
    protected static final int KEY_9 = 57;
    protected static final int KEY_A = 65;
    protected static final int KEY_B = 66;
    protected static final int KEY_C = 67;
    protected static final int KEY_D = 68;
    protected static final int KEY_E = 69;
    protected static final int KEY_F = 70;
    protected static final int KEY_G = 71;
    protected static final int KEY_H = 72;
    protected static final int KEY_I = 73;
    protected static final int KEY_J = 74;
    protected static final int KEY_K = 75;
    protected static final int KEY_L = 76;
    protected static final int KEY_M = 77;
    protected static final int KEY_N = 78;
    protected static final int KEY_O = 79;
    protected static final int KEY_P = 80;
    protected static final int KEY_Q = 81;
    protected static final int KEY_R = 82;
    protected static final int KEY_S = 83;
    protected static final int KEY_T = 84;
    protected static final int KEY_U = 85;
    protected static final int KEY_V = 86;
    protected static final int KEY_W = 87;
    protected static final int KEY_X = 88;
    protected static final int KEY_Y = 89;
    protected static final int KEY_Z = 90;
    public static final int M_MODE_ORBIT = 0;
    public static final int M_MODE_SCALE = 1;
    public static final int M_MODE_SCALE_RECT = 2;
    public static final int M_MODE_TRANS = 3;
    public static final int M_MODE_TRANS_Z = 4;
    public static final int M_MODE_PICK = 5;
    public static final int M_MODE_INITIAL_PICK = 6;
    public static final int M_MODE_HIGHLIGHT = 7;
    public static final int M_MODE_DISPLAY_PICK = 8;
    public static final int M_MODE_MARK = 9;
    public static final int M_MODE_MARK_ELEMENTS = 10;
    public static final int M_MODE_UNMARK = 11;
    public static final int M_MODE_ADD = 12;
    public static final int M_MODE_DELETE = 13;
    public static final int M_MODE_DUPLICATE = 14;
    protected static final int M_MODE_ADD_ELEMENT = 15;
    public String m_defBackgroundImage;
    public String m_backgroundImage;
    protected static final String[] m_majorModeMessage = new String[]{PsConfig.getMessage("MODE_ORBIT"), PsConfig.getMessage("MODE_SCALE"), PsConfig.getMessage("MODE_SCALE_RECT"), PsConfig.getMessage("MODE_TRANS"), PsConfig.getMessage("MODE_TRANS_Z"), PsConfig.getMessage("MODE_PICK"), PsConfig.getMessage("MODE_INITIAL_PICK"), PsConfig.getMessage("MODE_HIGHLIGHT"), PsConfig.getMessage("MODE_DISPLAY_PICK"), PsConfig.getMessage("MODE_MARK"), PsConfig.getMessage("MODE_MARK_ELEMENTS"), PsConfig.getMessage("MODE_UNMARK"), PsConfig.getMessage("MODE_ADD"), PsConfig.getMessage("MODE_DELETE"), PsConfig.getMessage("MODE_DUPLICATE"), PsConfig.getMessage("MODE_ADD_ELEMENT")};
    protected static final int M_MODE_RESET = 0;
    protected static final int M_MODE_CENTER = 1;
    protected static final int M_MODE_FOCUS = 2;
    protected static final int M_MODE_START = 3;
    protected static final int M_MODE_STOP = 4;
    protected static final String[] m_minorModeMessage = new String[]{PsConfig.getMessage("MODE_RESET"), PsConfig.getMessage("MODE_CENTER"), PsConfig.getMessage("MODE_FOCUS"), PsConfig.getMessage("MODE_START"), PsConfig.getMessage("MODE_STOP")};
    protected static final boolean M_SWITCH_GRID = true;
    protected static final boolean M_SWITCH_DCUE = false;
    protected static final boolean M_SWITCH_HIDD = false;
    protected boolean m_bMouseInside;
    protected boolean m_bMouseDown;
    protected String m_name;
    protected boolean m_bIsEnabledUpdate;
    private transient Applet m_applet;
    protected transient Frame m_frame;
    protected transient PsUpdateIf m_parent;
    protected transient PvViewerIf m_viewer;
    protected Hashtable m_camera;
    protected PvCamera m_currentCamera;
    protected transient PsPanel m_cameraPanel;
    protected transient PsPanel m_infoPanel;
    protected PvScene m_scene;
    protected PvGeometry m_currentGeom;
    private String m_currentFrameName;
    protected PgGeometryIf m_geomIf;
    protected boolean m_bCentered;
    protected static final String GEOM_AXES = "axes frame";
    protected static final String GEOM_AXES_0 = "x-axis";
    protected static final String GEOM_AXES_1 = "y-axis";
    protected static final String GEOM_AXES_2 = "z-axis";
    protected static final String GEOM_BNDBOX = "bndbox";
    protected static final String GEOM_FRAME = "frame";
    protected static final String GEOM_XY_GRID = "xy-grid";
    protected Hashtable m_specialGeom;
    protected int m_mode;
    protected int m_modeMajor;
    protected int m_defModeMajor;
    protected boolean m_bLocalTransform;
    protected PvModelCamera m_modelCamera;
    protected int m_transformationMode;
    protected int m_ambientDim;
    protected int m_ambientSpace;
    protected int m_ambientProj;
    protected transient Vector m_cameraListener;
    protected transient Vector m_pickListener;
    protected transient PvPickListenerIf m_pickFocus;
    protected int m_pickedVertex;
    protected PiVector m_pick;
    protected PiVector m_markBox;
    protected PdVector worldPick;
    protected Dimension m_currLoc;
    protected double[] m_currNormLoc;
    protected int m_imageFitMode;
    protected transient Image m_backImage;
    private transient Image m_image;
    private transient int[][] m_zBuffer;
    protected int m_nHeight;
    protected int m_nWidth;
    protected static Dimension m_defSize = new Dimension(300, 300);
    protected PuInteger m_height;
    protected PuInteger m_width;
    private transient Graphics m_g;
    protected int m_sceneFlags;
    protected static float PS_ZOOM = 1000.0f;
    protected PdColor m_foregroundColor;
    protected PdColor m_backgroundColor;
    protected boolean m_bShowBackface;
    protected boolean m_bShowBackImage;
    protected boolean m_bShowCopyright;
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgesOnce;
    protected boolean m_bShowEdgeAura;
    protected boolean m_bShowGrid;
    protected boolean m_bEnableSorting;
    protected boolean m_bEnableTag;
    protected boolean m_bEnableZBuffer;
    private boolean m_bSaveEnableZBuffer;
    protected boolean m_bEnableNewZBuffer;
    protected boolean m_bEnableFastZBuffer;
    protected transient Thread m_thread;
    protected boolean m_bEnableAnimation;
    protected boolean m_bDrawing;
    private static final int MOUSE_X_CONSTRAINT = 1;
    private static final int MOUSE_Y_CONSTRAINT = 2;
    private int m_mouseShiftConstraint;
    protected boolean m_bMouseShiftConstraint;
    private int xUp;
    private int yUp;
    private int xDown;
    private int yDown;
    private boolean bDrag;
    protected PuInteger m_sleep;
    protected boolean m_bFpsEnabled;
    private long m_period;
    private int m_pCount;
    protected transient PopupMenu m_popup;
    protected transient MenuItem[] m_menuItem;
    private int m_prevKey;
    private String m_copyright;
    private int m_copyrightLength;
    protected PgJvxSrc m_coordFrame;
    protected PgAxes m_axes;
    private boolean m_bFirstAfterPick;
    private boolean m_bSaveShowingVertices;
    private boolean m_bSaveShowingBndbox;
    private boolean m_bIsGlowingBndbox;
    private PiVector m_newElement;

    public boolean isShowingBackImage() {
        return this.m_bShowBackImage;
    }

    public void showBackImage(boolean aFlag) {
        this.m_bShowBackImage = aFlag;
    }

    public Image getBackgroundImage() {
        return this.m_backImage;
    }

    public boolean isEnabledClip() {
        return this.m_currentCamera.m_bEnableClip;
    }

    public boolean isClip() {
        return this.isEnabledClip();
    }

    public void fit() {
        if (this.m_scene == null) {
            PsDebug.notify("missing geometry");
            return;
        }
        if (this.m_nHeight <= 0) {
            PsDebug.notify("display has no height = " + this.m_nHeight);
            return;
        }
        PdVector[] bndBox = this.m_scene.getBounds();
        if (bndBox == null) {
            PsDebug.notify("missing bndBox");
            return;
        }
        this.m_currentCamera.fit(PdVector.dist(bndBox[0], bndBox[1]));
        PdVector center = new PdVector(3);
        center.blend(0.5, bndBox[0], 0.5, bndBox[1]);
        this.m_currentCamera.setInterest(center);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public boolean isShowingDepthcue() {
        if (this.m_currentCamera.getProjectionMode() == 0) {
            return this.m_bShowDepthcue;
        }
        return false;
    }

    public void showDepthcue(boolean aFlag) {
        this.m_bShowDepthcue = aFlag;
    }

    public void setBackgroundImage(Image anImage) {
        if (anImage == null) {
            this.m_backImage = null;
            this.showBackImage(false);
            return;
        }
        this.m_backImage = anImage;
        this.showBackImage(true);
    }

    public void setBackgroundImage(String fileName) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(PsConfig.getApplet().getCodeBase(), fileName) : Toolkit.getDefaultToolkit().getImage(fileName);
        if (image == null) {
            if (!PsConfig.isApplication()) {
                fileName = PsConfig.getApplet().getCodeBase() + fileName;
            }
            PsDebug.warning("failed loading image = " + fileName);
            return;
        }
        this.setBackgroundImage(image);
        this.m_backgroundImage = fileName;
    }

    protected void setEnabledModelOfSpecials(boolean state) {
        if (this.isShowingFrame()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME), state);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.m_bEnableFastZBuffer && this.m_bEnableZBuffer != this.m_bSaveEnableZBuffer) {
            this.m_bEnableZBuffer = this.m_bSaveEnableZBuffer;
            this.repaint();
        }
        if (event.isPopupTrigger()) {
            PsDebug.notify("event is popup trigger.");
            return;
        }
        int x = event.getX();
        int y = event.getY();
        this.m_markBox.m_data[2] = x;
        this.m_markBox.m_data[3] = y;
        this.m_currLoc.width = x;
        this.m_currLoc.height = this.m_nHeight - 1 - y;
        if (Math.abs(this.xUp - this.xDown) <= 2 || Math.abs(this.yUp - this.yDown) <= 2) {
            this.bDrag = false;
        }
        this.xUp = x;
        this.yUp = y;
        this.m_bMouseDown = false;
        if (this.m_mode == 6) {
            this.bDrag = false;
        } else if (this.m_mode == 8) {
            this.bDrag = false;
        } else if (this.m_mode == 5) {
            if (this.m_currentGeom != null && !this.isEnabledTags()) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex);
                if (this.m_geomIf != null) {
                    this.m_geomIf.update(this.m_geomIf);
                }
            }
            this.bDrag = false;
        } else if (this.m_mode == 13) {
            PvPickEvent pick = this.getPickEvent(x, y);
            if (pick == null) {
                return;
            }
            PgGeometryIf geom = pick.getGeometry();
            if (geom == null) {
                return;
            }
            this.removeGeometry(geom);
            this.update(this);
        } else if (this.m_mode == 9) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    this.m_currentGeom.pickVertex(x, y);
                } else {
                    this.m_currentGeom.tagVertices(Math.min(this.m_markBox.m_data[0], x), Math.min(this.m_markBox.m_data[1], y), Math.abs(x - this.m_markBox.m_data[0]), Math.abs(y - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent markBox = new PvPickEvent(3);
            markBox.setGeometry(this.m_geomIf);
            markBox.setMarkBox(this.m_markBox);
            markBox.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.markVertices(markBox);
            } else if (this.m_pickListener != null) {
                Enumeration e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).markVertices(markBox);
                }
            }
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 10) {
            this.bDrag = false;
        } else if (this.m_mode == 2) {
            this.bDrag = false;
            PdVector[] worldBox = this.markBox2World(this.m_markBox);
            PdVector center = PdVector.blendNew(0.5, worldBox[0], 0.5, worldBox[2]);
            this.m_currentCamera.setInterest(center);
            double dist = PdVector.dist(worldBox[0], worldBox[2]);
            if (dist < 1.0E-4) {
                PsDebug.warning("mark box too small, no zoom");
                return;
            }
            this.m_currentCamera.fit(dist);
            if (this.getTransformationMode() != 0) {
                this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            }
            this.updateCameraListener(103);
            this.repaint();
            this.m_markBox.setConstant(0);
        } else if (this.m_mode == 11) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    int pickedVertex = this.m_currentGeom.pickVertex(x, y);
                    if (pickedVertex != -1) {
                        this.m_currentGeom.releaseVertex(pickedVertex);
                    }
                } else {
                    this.m_currentGeom.untagVertices(Math.min(this.m_markBox.m_data[0], x), Math.min(this.m_markBox.m_data[1], y), Math.abs(x - this.m_markBox.m_data[0]), Math.abs(y - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent markBox = new PvPickEvent(3);
            markBox.setGeometry(this.m_geomIf);
            markBox.setMarkBox(this.m_markBox);
            markBox.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.unmarkVertices(markBox);
            } else if (this.m_pickListener != null) {
                Enumeration e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).unmarkVertices(markBox);
                }
            }
            this.m_markBox.setConstant(0);
        }
    }

    private void drawPickBox(Graphics g) {
        if (this.m_markBox == null || this.m_markBox.getSize() < 4) {
            PsDebug.warning("missing mark box.");
            return;
        }
        if (this.m_markBox.getSize() < 4) {
            PsDebug.warning("mark box too small, size = " + this.m_markBox.getSize());
            return;
        }
        int[] data = this.m_markBox.m_data;
        g.drawLine(data[0], data[1], data[2], data[1]);
        g.drawLine(data[2], data[1], data[2], data[3]);
        g.drawLine(data[2], data[3], data[0], data[3]);
        g.drawLine(data[0], data[3], data[0], data[1]);
    }

    public void setSizeWithinFrame(int width, int height) {
        int hMargin;
        int wMargin;
        if (height < 0 || width < 0) {
            PsDebug.warning("value <= 0");
            return;
        }
        Frame parentFrame = this.hasParentFrame();
        if (parentFrame == null) {
            return;
        }
        Dimension parentDim = parentFrame.getSize();
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            Insets insets = parentFrame.getInsets();
            wMargin = insets.left + insets.right;
            hMargin = insets.top + insets.bottom;
        } else {
            wMargin = parentDim.width - this.m_nWidth;
            hMargin = parentDim.height - this.m_nHeight;
        }
        ((Component)parentFrame).setSize(wMargin + width, hMargin + height);
        this.resizeImage();
        parentFrame.validate();
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor.getColor();
    }

    public void setBackgroundColor(Color aColor) {
        this.m_backgroundColor.setColor(aColor);
        super.setBackground(this.m_backgroundColor.getColor());
    }

    public boolean hasPaintTag(int flags) {
        return (this.m_sceneFlags & flags) != 0;
    }

    protected void paintGeom(Graphics g) {
        ++this.m_pCount;
        if (!this.hasPaintTag(1)) {
            return;
        }
        boolean bPSExport = this.hasPaintTag(8);
        int currPsZoom = 1;
        if (bPSExport) {
            currPsZoom = (int)PS_ZOOM;
        }
        if (this.hasPaintTag(8192)) {
            if (this.hasPaintTag(2) && !bPSExport) {
                g.setColor(this.m_backgroundColor.getColor());
                g.fillRect(0, 0, this.m_nWidth, this.m_nHeight);
                g.setColor(this.m_foregroundColor.getColor());
            }
            if (this.m_bShowBackImage && this.m_backImage != null) {
                int backWidth = this.m_backImage.getWidth(this);
                int backHeight = this.m_backImage.getHeight(this);
                switch (this.m_imageFitMode) {
                    case 0: {
                        g.drawImage(this.m_backImage, (this.m_nWidth - backWidth) / 2, (this.m_nHeight - backHeight) / 2, backWidth, backHeight, null, this);
                        break;
                    }
                    case 1: {
                        int numHor = 1 + this.m_nWidth / backWidth;
                        int numVer = 1 + this.m_nHeight / backHeight;
                        int j = 0;
                        while (j < numVer) {
                            int i = 0;
                            while (i < numHor) {
                                g.drawImage(this.m_backImage, i * backWidth, j * backHeight, backWidth, backHeight, null, this);
                                ++i;
                            }
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        g.drawImage(this.m_backImage, 0, 0, this.m_nWidth, this.m_nHeight, this);
                        break;
                    }
                }
            }
        }
        Cursor savedCursor = null;
        if (this.isEnabledZBuffer() && !this.isEnabledNewZBuffer()) {
            savedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this.isEnabledZBuffer() || this.m_bEnableFastZBuffer && this.m_bSaveEnableZBuffer) {
            this.resetZBuffer();
        }
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            block24: {
                if (this.m_scene == null || this.m_currentGeom == null) break block24;
                this.m_scene.paint(g, this);
            }
            Object var11_12 = null;
        }
        if (this.m_bIsGlowingBndbox) {
            this.glowBndbox(false);
        }
        if (this.isShowingCopyright()) {
            g.setFont(PsConfig.getFont(0));
            g.setColor(Color.black);
            g.drawString(this.m_copyright, currPsZoom * (this.m_width.getValue() - this.m_copyrightLength) / 2, currPsZoom * (this.m_height.getValue() - 10));
        }
        if (this.hasPaintTag(4) && !bPSExport) {
            PsPanel.drawBorder(this, g, 2);
        }
        if (this.hasPaintTag(256) && !bPSExport) {
            this.drawInfo(g);
        }
        if (this.hasPaintTag(16) && !bPSExport) {
            this.drawCross(g, 2, currPsZoom * this.m_currLoc.width, currPsZoom * (this.m_nHeight - 1 - this.m_currLoc.height));
        }
        if ((this.m_mode == 9 || this.m_mode == 11 || this.m_mode == 2) && this.m_bMouseDown) {
            this.drawPickBox(g);
        }
        if (this.isEnabledZBuffer() && !this.isEnabledNewZBuffer()) {
            this.setCursor(savedCursor);
        }
    }

    public boolean isShowingAxes() {
        return this.hasPaintTag(1024);
    }

    public void showAxes(boolean aFlag) {
        if (aFlag) {
            if (!this.hasAxes()) {
                this.getAxes();
            }
            PgGeometry[] axis = this.m_axes.getAxes();
            int i = 0;
            while (i < axis.length) {
                this.addGeometry(axis[i], 1);
                this.m_specialGeom.put(GEOM_AXES + "_" + String.valueOf(i), axis[i]);
                ++i;
            }
            this.addGeometry(this.m_axes, 1);
            this.m_specialGeom.put(GEOM_AXES, this.m_axes);
            this.updateCameraListener(101);
        } else if (this.m_specialGeom.containsKey(GEOM_AXES)) {
            PgGeometry[] axis = this.m_axes.getAxes();
            if (axis != null) {
                int i = 0;
                while (i < axis.length) {
                    String specialName = GEOM_AXES + "_" + String.valueOf(i);
                    this.removeGeometry(axis[i]);
                    this.m_specialGeom.remove(specialName);
                    ++i;
                }
            }
            this.removeGeometry(this.m_axes);
            this.m_specialGeom.remove(GEOM_AXES);
        }
        this.setPaintTag(1024, aFlag);
        this.update(this);
    }

    public PgAxes getAxes() {
        block1: {
            if (this.m_axes != null) break block1;
            PjAxes pjAxes = null;
            if (!this.m_specialGeom.containsKey(GEOM_AXES)) {
                pjAxes = new PjAxes(3);
                this.m_axes = pjAxes.getAxes();
                this.m_axes.showTitles(true);
                this.m_axes.setName(PsConfig.getMessage("Axes"));
                pjAxes.setScene(this.m_scene);
                this.addCameraListener(pjAxes);
                pjAxes.update(this.m_scene);
            }
        }
        return this.m_axes;
    }

    public void setAxes(PgAxes axes) {
        if (this.m_axes != null) {
            this.showAxes(false);
        }
        this.m_axes = axes;
    }

    public int getAmbientSpace() {
        if (this.m_currentGeom != null && this.m_ambientSpace != this.m_currentGeom.getAmbientSpace()) {
            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
        }
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int mode) {
        if (this.m_currentGeom != null && this.m_currentGeom.getAmbientSpace() != mode) {
            this.m_currentGeom.setAmbientSpace(mode);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientSpace(mode);
            }
        }
        switch (mode) {
            default: {
                this.m_ambientDim = 3;
                break;
            }
            case 0: {
                this.m_ambientDim = 1;
                break;
            }
            case 1: 
            case 2: {
                this.m_ambientDim = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_ambientDim = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.m_ambientDim = 5;
                break;
            }
        }
        this.m_ambientSpace = mode;
    }

    public void setEnabledUpdate(boolean flag) {
        this.m_bIsEnabledUpdate = flag;
    }

    public boolean isEnabledLocalTransform() {
        return this.m_bLocalTransform;
    }

    private void getModelFromWorld(PvGeometry geom, PdVector base, PdVector dir) {
        if (geom == null) {
            return;
        }
        this.getModelFromWorld(geom.getGeometry(), base, dir);
    }

    private void getModelFromWorld(PgGeometryIf geom, PdVector base, PdVector dir) {
        if (geom == null) {
            return;
        }
        if (geom.hasModelMatrix()) {
            PdMatrix modelInv = new PdMatrix(4);
            modelInv.invert34(geom.getModelMatrix());
            if (base != null) {
                base.leftMultMatrix(modelInv);
            }
            if (dir != null) {
                dir.leftMultMatrix(modelInv);
            }
        }
        if (geom.getDimOfVertices() == 2 && base != null && dir != null) {
            double fac = 0.0;
            if (Math.abs(dir.getEntry(2)) > 1.0E-9) {
                fac = -base.getEntry(2) / dir.getEntry(2);
            } else {
                PsDebug.warning("horizontal pick direction");
            }
            base.blendBase(base, fac, dir);
        }
    }

    private int[] getPixelFromWorld(PdVector vertex) {
        PdVector base = PdVector.copyNew(vertex);
        int len = base.getSize();
        if (len != 4) {
            base.setSize(4);
            int i = len;
            while (i < 4) {
                base.setEntry(i, 0.0);
                ++i;
            }
            base.setEntry(3, 1.0);
        }
        base.leftMultMatrix(this.m_currentCamera.m_trans);
        int[] proj = new int[]{(int)base.getEntry(0), (int)base.getEntry(1), (int)base.getEntry(2)};
        return proj;
    }

    public PgGeometryIf[] getGeometries() {
        PvGeometry[] geomList = this.getGeometryContainers();
        if (geomList == null || geomList.length == 0) {
            return null;
        }
        PgGeometryIf[] ifList = new PgGeometryIf[geomList.length];
        if (ifList == null || ifList.length == 0) {
            return null;
        }
        int ind = 0;
        PgGeometryIf sg = this.getSelectedGeometry();
        if (sg != null && !this.m_specialGeom.contains(sg) && ind < ifList.length) {
            ifList[ind++] = this.getSelectedGeometry();
        }
        int i = 0;
        while (i < geomList.length) {
            PgGeometryIf geom = geomList[i].getGeometry();
            if (geom != ifList[0] && ind < ifList.length) {
                ifList[ind++] = geom;
            }
            ++i;
        }
        return ifList;
    }

    public boolean isShowingFrame() {
        return this.hasPaintTag(512);
    }

    public void showFrame(boolean aFlag) {
        if (aFlag) {
            if (!this.m_specialGeom.containsKey(GEOM_FRAME)) {
                this.m_coordFrame = new PgJvxSrc();
                this.m_coordFrame.setName(PsConfig.getMessage("CoordinateFrame"));
                this.m_coordFrame.showVertices(true);
                this.m_coordFrame.showPolygons(true);
                this.m_coordFrame.showPolygonEndArrow(true);
                this.m_coordFrame.setDefaultLabelEnabled(false);
                this.m_coordFrame.showIndices(true);
                this.m_coordFrame.setGlobalPolygonSize(1.0);
                this.m_coordFrame.setGlobalPolygonColor(Color.black);
                this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.addGeometry(this.m_coordFrame, 1);
                this.m_specialGeom.put(GEOM_FRAME, this.m_coordFrame);
                PvGeometry geom = this.m_scene.getGeometry(this.m_coordFrame);
                geom.setPosition(100, 100);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_FRAME)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME));
            this.m_specialGeom.remove(GEOM_FRAME);
        }
        this.setPaintTag(512, aFlag);
        this.update(this);
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void addPickListener(PvPickListenerIf listener) {
        if (this.m_pickListener == null) {
            this.m_pickListener = new Vector();
        } else if (this.hasPickListener(listener)) {
            PsDebug.warning("listener = " + listener.getName() + " of listener already used.");
            return;
        }
        this.m_pickListener.addElement(listener);
    }

    public boolean isShowingCopyright() {
        return this.m_bShowCopyright;
    }

    public void showCopyright(boolean aFlag) {
        this.m_bShowCopyright = aFlag;
    }

    public void init() {
        this.stop();
        this.m_bLocalTransform = false;
        this.m_bMouseShiftConstraint = false;
        this.setEnabledUpdate(true);
        this.setTransformationMode(0);
        this.m_pickedVertex = -1;
        this.m_pick.set(0, 0, 0);
        this.setForegroundColor(Color.black);
        if (!PsConfig.isApplication() && PsConfig.getApplet() != null && PsConfig.getApplet().getBackground() != null) {
            this.setBackgroundColor(PsConfig.getApplet().getBackground());
        } else {
            this.setBackgroundColor(Color.lightGray);
        }
        this.selectCamera(0);
        this.m_sceneFlags = 0;
        this.setPaintTag(8199, true);
        this.setEnabledFastZBuffer(true);
        this.setEnabledZBuffer(false);
        this.setEnabledNewZBuffer(false);
        this.setEnabledAnimation(false);
        this.setImageFitMode(1);
        this.showBackImage(false);
        this.showBndBox(false);
        this.showDepthcue(true);
        this.showEdgeAura(false);
        this.showEdgesOnce(true);
        this.showFrame(false);
        this.showAxes(false);
        this.showGrid(false);
        this.setEnabledPainters(true);
        this.setEnabledClip(false);
        this.m_sleep.setDefBounds(0, 100, 1, 5);
        this.m_sleep.setDefValue(40);
        this.m_sleep.setEnabled(false);
        this.m_sleep.init();
        this.setCurrentMajorMode(this.m_defModeMajor);
        this.m_specialGeom.clear();
        if (this.m_currentGeom != null) {
            this.m_currentCamera.init();
            this.fit();
            this.repaint();
        }
    }

    public boolean removeGeometry(PgGeometryIf aGeom) {
        if (aGeom == null) {
            return true;
        }
        PsDebug.notify("called, geometry name = " + aGeom.getName());
        if (!this.containsGeometry(aGeom)) {
            if (aGeom != null) {
                PsDebug.message("geometry=" + aGeom.getName() + " not registered in listener");
            }
            return false;
        }
        aGeom.removeDisplay(this);
        PvGeometry geom = this.m_scene.getGeometry(aGeom);
        PvGeometry newCurrentGeom = this.m_scene.removeGeometry(geom);
        if (this.m_currentGeom != newCurrentGeom) {
            if (newCurrentGeom != null && newCurrentGeom.getGeometry() != null) {
                this.selectGeometry(newCurrentGeom.getGeometry());
            } else {
                this.selectGeometry(null);
            }
        }
        return true;
    }

    public PgGeometryIf getSelectedGeometry() {
        if (this.m_currentGeom == null) {
            return null;
        }
        return this.m_currentGeom.getGeometry();
    }

    public PsPanel getCameraPanel() {
        if (!(this.m_cameraPanel != null && this.m_cameraPanel.getLanguage().equals(PsConfig.getLanguage()) || this.m_currentCamera == null)) {
            this.m_cameraPanel = this.m_currentCamera.getInfoPanel();
        }
        return this.m_cameraPanel;
    }

    public void run() {
        double initTime = 0.0;
        double fps = 0.0;
        if (this.m_bFpsEnabled) {
            this.m_pCount = 0;
            initTime = new Date().getTime();
        }
        while (this.m_thread != null) {
            double currTime;
            if (!this.m_bDrawing) {
                if (this.getTransformationMode() == 0) {
                    this.m_currentCamera.mouseAnimate();
                } else {
                    this.m_modelCamera.mouseAnimate();
                }
                boolean bPaintAll = this.hasPaintTag(1);
                this.setPaintTag(1, false);
                this.updateCameraListener(101);
                this.setPaintTag(1, bPaintAll);
            }
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.m_bFpsEnabled || !((currTime = (double)new Date().getTime()) - initTime > (double)(this.m_period * 1000L))) continue;
            fps = (fps + (double)this.m_pCount / ((currTime - initTime) / 1000.0)) / 2.0;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(String.valueOf((double)((int)(fps * 100.0)) / 100.0));
            }
            initTime = currTime;
            this.m_pCount = 0;
        }
    }

    public boolean isEnabledClearScreen() {
        return this.hasPaintTag(8192);
    }

    public void resetTransformModel() {
        PdMatrix idMat = new PdMatrix(4);
        idMat.setIdentity();
        if (this.m_modelCamera != null) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            this.m_modelCamera.setModelMatrix(idMat);
            this.m_modelCamera.getAmbientMatrix().setIdentity();
            this.m_modelCamera.getAmbientInvMatrix().setIdentity();
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasModelMatrix()) {
            this.m_currentGeom.setModelMatrix(idMat);
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasAmbientMatrix()) {
            this.m_currentGeom.getAmbientMatrix().setIdentity();
            this.m_currentGeom.getAmbientInvMatrix().setIdentity();
        }
        this.setEnabledLocalTransform(false);
    }

    public void setEnabledTags(boolean aFlag) {
        this.m_bEnableTag = aFlag;
    }

    private void drawCross(Graphics g, int size, int xPos, int yPos) {
        g.drawLine(xPos - size, yPos, xPos + size, yPos);
        g.drawLine(xPos, yPos - size, xPos, yPos + size);
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
        }
        if (this.m_bFpsEnabled) {
            this.m_bFpsEnabled = false;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_cFps.setState(this.m_bFpsEnabled);
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(PsConfig.getMessage("lFps"));
                this.m_sleep.setEnabled(false);
            }
        }
    }

    protected boolean isEnabledNewZBuffer() {
        return this.m_bEnableNewZBuffer;
    }

    public boolean isEnabledPainters() {
        return this.m_bEnableSorting;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    protected int getCurrentCameraType() {
        if (this.m_currentCamera == null) {
            PsDebug.warning("current camera missing.");
            return 0;
        }
        return this.m_currentCamera.getProjectionMode();
    }

    public void mouseEntered(MouseEvent event) {
        this.m_bMouseInside = true;
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_menuItem[0]) {
            this.setCurrentMajorMode(0);
        } else if (source == this.m_menuItem[1]) {
            this.setCurrentMajorMode(1);
        } else if (source == this.m_menuItem[2]) {
            this.setCurrentMajorMode(3);
        } else if (source == this.m_menuItem[3]) {
            this.setCurrentMajorMode(6);
        } else if (source == this.m_menuItem[4]) {
            if (this.m_viewer != null) {
                this.m_viewer.newDisplay();
            } else {
                PvDisplay disp = new PvDisplay(this.m_applet, this.m_frame);
                PsMainFrame frame = new PsMainFrame(disp, "JavaView", null);
                disp.setFrame(frame);
                PgGeometryIf[] geom = this.getGeometries();
                if (geom != null) {
                    int i = 0;
                    while (i < geom.length) {
                        disp.addGeometry(geom[i]);
                        ++i;
                    }
                    PgGeometryIf currGeom = this.getSelectedGeometry();
                    if (currGeom != null && disp.containsGeometry(currGeom)) {
                        disp.selectGeometry(currGeom);
                    }
                }
                disp.selectCamera(this.getCurrentCameraType());
                disp.showGrid(this.isShowingGrid());
                disp.showBndBox(this.isShowingBndBox());
                disp.showFrame(this.isShowingFrame());
                disp.showAxes(this.isShowingAxes());
                frame.setBounds(new Rectangle(50, 50, 400, 300));
                ((Component)frame).setVisible(true);
            }
        } else if (source == this.m_menuItem[5]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(46);
            }
        } else if (source == this.m_menuItem[6]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(25);
            }
        } else if (source == this.m_menuItem[7]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(24);
            }
        } else if (source == this.m_menuItem[8]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(26);
            } else {
                Applet applet = PsConfig.getApplet();
                if (!PsConfig.isApplication() && applet != null) {
                    URL viewerHelp;
                    boolean bFoundHelp = false;
                    try {
                        viewerHelp = new URL(PsConfig.getCodeBase() + "jars/help.html");
                        viewerHelp.openConnection();
                        viewerHelp.openStream();
                        applet.getAppletContext().showDocument(viewerHelp, "Help on Viewer");
                        bFoundHelp = true;
                    }
                    catch (MalformedURLException exc) {
                        PsDebug.warning("MalformedURLException when accessing viewer help");
                    }
                    catch (IOException exc) {
                        PsDebug.warning("IOException, could not open connection");
                    }
                    catch (Exception exc) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                    }
                    if (!bFoundHelp) {
                        try {
                            viewerHelp = new URL(PsConfig.getCodeBase() + "help.html");
                            viewerHelp.openConnection();
                            viewerHelp.openStream();
                            applet.getAppletContext().showDocument(viewerHelp, "Help on Viewer");
                        }
                        catch (MalformedURLException exc) {
                            PsDebug.warning("MalformedURLException when accessing viewer help");
                        }
                        catch (IOException exc) {
                            PsDebug.warning("IOException, could not open connection");
                        }
                        catch (Exception exc) {
                            PsDebug.warning("file not found = " + "jars/help.html");
                        }
                    }
                }
            }
        } else if (source == this.m_menuItem[9]) {
            PsAboutDialog about = new PsAboutDialog(PsConfig.getFrame());
            int[] m_aboutSize = new int[]{10, 10, 400, 450};
            ((Component)about).setLocation(m_aboutSize[0], m_aboutSize[1]);
            ((Component)about).setSize(m_aboutSize[2], m_aboutSize[3]);
            about.validate();
            about.setModal(true);
            ((Component)about).setVisible(true);
        } else if (source == this.m_menuItem[10]) {
            if (this.m_viewer != null) {
                this.m_viewer.removeDisplay(this);
            } else {
                Frame frame = this.hasParentFrame();
                if (frame != null) {
                    frame.dispose();
                }
            }
        } else if (source == this.m_menuItem[11]) {
            if (this.m_viewer != null) {
                this.m_viewer.destroy();
            } else {
                System.exit(0);
            }
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Auto-Rotation");
            this.m_thread.setPriority(5);
            this.m_thread.start();
        }
    }

    private PdVector[] markBox2World(PiVector markBox) {
        PdVector[] worldBox = PdVector.realloc(null, 5, 4);
        worldBox[0].set(Math.min(markBox.m_data[0], markBox.m_data[2]), Math.min(markBox.m_data[1], markBox.m_data[3]), 0.0, 1.0);
        worldBox[1].set(Math.max(markBox.m_data[0], markBox.m_data[2]), Math.min(markBox.m_data[1], markBox.m_data[3]), 0.0, 1.0);
        worldBox[2].set(Math.max(markBox.m_data[0], markBox.m_data[2]), Math.max(markBox.m_data[1], markBox.m_data[3]), 0.0, 1.0);
        worldBox[3].set(Math.min(markBox.m_data[0], markBox.m_data[2]), Math.max(markBox.m_data[1], markBox.m_data[3]), 0.0, 1.0);
        worldBox[4].set(0.0, 0.0, -1000.0, 0.0);
        int i = 0;
        while (i < worldBox.length) {
            worldBox[i].leftMultMatrix(this.m_currentCamera.m_transInv);
            worldBox[i].setSize(3);
            ++i;
        }
        return worldBox;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String aName) {
        this.m_name = aName;
    }

    public Image getImage() {
        return this.m_image;
    }

    private boolean resizeImage() {
        Dimension dim = this.getSize();
        if (dim.width == 0 || dim.height == 0) {
            return false;
        }
        if (this.m_image != null && dim.width == this.m_nWidth && dim.height == this.m_nHeight) {
            return true;
        }
        if (this.m_nHeight == -1) {
            m_defSize = dim;
        }
        this.m_nHeight = dim.height;
        this.m_height.setValue(dim.height);
        this.m_nWidth = dim.width;
        this.m_width.setValue(dim.width);
        boolean bHasParent = this.hasParentFrame() != null;
        this.m_height.setEnabled(bHasParent);
        this.m_width.setEnabled(bHasParent);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        }
        this.m_image = this.createImage(this.m_nWidth, this.m_nHeight);
        if (this.isEnabledZBuffer()) {
            this.assureZBuffer(this.m_nWidth, this.m_nHeight);
        }
        if (this.m_image == null) {
            return false;
        }
        this.m_g = this.m_image.getGraphics();
        if (this.m_currentGeom != null) {
            this.setFrameTitle(this.m_currentGeom.getGeometry().getName());
            if (!this.m_bCentered) {
                this.m_bCentered = true;
                this.fit();
                this.center();
            }
        }
        this.m_bDrawing = true;
        this.paintGeom(this.m_g);
        this.m_bDrawing = false;
        return true;
    }

    public void setEnabledClip(boolean aFlag) {
        this.m_currentCamera.m_bEnableClip = aFlag;
    }

    public void enableClip(boolean aFlag) {
        this.setEnabledClip(aFlag);
    }

    public double getNearClip() {
        return this.m_currentCamera.m_nearClip.getValue();
    }

    public void setNearClip(double dist) {
        this.m_currentCamera.m_nearClip.setValue(dist);
    }

    public void releasePickFocus() {
        this.m_pickFocus = null;
    }

    public boolean hasCamera(int type) {
        if (type < 0 || PvDisplayIf.CAMERA_NAME.length <= type) {
            PsDebug.warning("camera type out of range = " + type);
            return false;
        }
        return this.m_camera.get(PvDisplayIf.CAMERA_NAME[type]) != null;
    }

    public boolean removeCamera(int type) {
        if (type < 0 || PvDisplayIf.CAMERA_NAME.length <= type) {
            return false;
        }
        return this.m_camera.remove(PvDisplayIf.CAMERA_NAME[type]) != null;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor.getColor();
    }

    public void setForegroundColor(Color aColor) {
        this.m_foregroundColor.setColor(aColor);
        super.setForeground(this.m_foregroundColor.getColor());
    }

    public void setPaintTag(int flags, boolean val) {
        if (val) {
            this.m_sceneFlags |= flags;
            if ((flags & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = (int)PS_ZOOM;
            } else if ((flags & 1) != 0) {
                this.repaint();
            } else if ((flags & 0x800) != 0) {
                PvGeometry[] geom = this.getGeometryContainers();
                if (geom == null) {
                    PsDebug.notify("empty geometry list in display");
                    return;
                }
                int i = 0;
                while (i < geom.length) {
                    if (geom[i].isVisible()) {
                        PgGeometryIf g = geom[i].getGeometry();
                        if (geom[i] != this.m_currentGeom && !this.m_specialGeom.contains(g)) {
                            geom[i].setVisible(false);
                            g.setVisible(false);
                        }
                    }
                    ++i;
                }
            }
        } else {
            if (this.hasPaintTag(8) && (flags & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(1.0 / (double)PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = 1;
            }
            this.m_sceneFlags &= ~flags;
        }
    }

    public void setParent(PsUpdateIf father) {
        this.m_parent = father;
    }

    public PvDisplay() {
        this(null, null);
    }

    public PvDisplay(PvViewerIf viewer) {
        this(viewer.getApplet(), viewer.getFrame());
        this.m_viewer = viewer;
    }

    public PvDisplay(Applet applet, Frame frame) {
        this.m_backgroundImage = this.m_defBackgroundImage = "images/JavaViewLogo.gif";
        this.m_bMouseInside = false;
        this.m_bMouseDown = false;
        this.m_bIsEnabledUpdate = true;
        this.m_cameraPanel = null;
        this.m_infoPanel = null;
        this.m_mode = 0;
        this.m_modeMajor = 0;
        this.m_defModeMajor = 0;
        this.m_ambientSpace = 3;
        this.m_ambientProj = 0;
        this.m_pick = new PiVector(3);
        this.m_markBox = new PiVector(4);
        this.worldPick = new PdVector(4);
        this.m_currLoc = new Dimension();
        this.m_currNormLoc = new double[2];
        this.m_nHeight = -1;
        this.m_nWidth = -1;
        this.m_bShowGrid = false;
        this.m_bDrawing = false;
        this.m_bMouseShiftConstraint = false;
        this.bDrag = false;
        this.m_bFpsEnabled = false;
        this.m_period = 2L;
        this.m_prevKey = -1;
        this.m_bFirstAfterPick = true;
        this.m_bSaveShowingBndbox = false;
        this.m_bIsGlowingBndbox = false;
        this.m_frame = frame;
        this.m_applet = applet;
        this.m_specialGeom = new Hashtable(3);
        this.m_camera = new Hashtable(4);
        this.addCamera("Perspective", new PvCamera(this, 0));
        this.m_foregroundColor = new PdColor(PsConfig.getMessage("foregroundColor"), this);
        this.m_backgroundColor = new PdColor(PsConfig.getMessage("backgroundColor"), this);
        this.m_copyright = PsConfig.getCopyright() + ", " + PsConfig.getProgram() + " v." + PsConfig.getVersion();
        Font copyrightFont = PsConfig.getFont(0);
        FontMetrics fontMetrics = this.getFontMetrics(copyrightFont);
        this.m_copyrightLength = fontMetrics.stringWidth(this.m_copyright);
        this.m_scene = new PvScene();
        this.m_sleep = new PuInteger(PsConfig.getMessage("sleep"), this);
        this.m_height = new PuInteger(PsConfig.getMessage("height"), this);
        this.m_height.setDefBounds(0, 1024, 1, 10);
        this.m_height.setDefValue(PvDisplay.m_defSize.height);
        this.m_height.init();
        this.m_width = new PuInteger(PsConfig.getMessage("width"), this);
        this.m_width.setDefBounds(0, 1280, 1, 10);
        this.m_width.setDefValue(PvDisplay.m_defSize.width);
        this.m_width.init();
        this.setAmbientSpace(this.m_ambientSpace);
        this.enableEvents(48L);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
    }

    public void paint(Graphics g) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage() && this.m_image != null) {
            g.drawImage(this.m_image, 0, 0, this);
        }
        this.m_bDrawing = false;
    }

    public void processMouseEvent(MouseEvent event) {
        if (event.isPopupTrigger()) {
            if (this.m_popup == null) {
                this.m_popup = new PopupMenu(PsConfig.getMessage("pTitle"));
                this.m_menuItem = new MenuItem[20];
                this.m_menuItem[0] = new MenuItem(PsConfig.getMessage("pOrbit"));
                this.m_menuItem[1] = new MenuItem(PsConfig.getMessage("pScale"));
                this.m_menuItem[2] = new MenuItem(PsConfig.getMessage("pTranslate"));
                this.m_menuItem[3] = new MenuItem(PsConfig.getMessage("pPick"));
                this.m_menuItem[4] = new MenuItem(PsConfig.getMessage("pDisplay"));
                this.m_menuItem[5] = new MenuItem(PsConfig.getMessage("pEPS"));
                this.m_menuItem[6] = new MenuItem(PsConfig.getMessage("pConsole"));
                this.m_menuItem[7] = new MenuItem(PsConfig.getMessage("pControl"));
                this.m_menuItem[8] = new MenuItem(PsConfig.getMessage("pHelp"));
                this.m_menuItem[9] = new MenuItem(PsConfig.getMessage("pAbout"));
                this.m_menuItem[10] = new MenuItem(PsConfig.getMessage("pClose"));
                this.m_menuItem[11] = new MenuItem(PsConfig.getMessage("pExit"));
                int i = 0;
                while (i < this.m_menuItem.length) {
                    if (this.m_menuItem[i] != null) {
                        this.m_menuItem[i].addActionListener(this);
                    }
                    ++i;
                }
                this.m_popup.add(this.m_menuItem[0]);
                this.m_popup.add(this.m_menuItem[1]);
                this.m_popup.add(this.m_menuItem[2]);
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[4]);
                if (this.m_viewer != null) {
                    this.m_popup.add(this.m_menuItem[5]);
                    this.m_popup.add(this.m_menuItem[6]);
                    this.m_popup.add(this.m_menuItem[7]);
                }
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[8]);
                if (this.m_viewer != null) {
                    this.m_popup.add(this.m_menuItem[9]);
                }
                if (this.hasParentFrame() != null) {
                    this.m_popup.add(this.m_menuItem[10]);
                }
                if (PsConfig.isApplication()) {
                    this.m_popup.add(this.m_menuItem[11]);
                }
                this.add(this.m_popup);
            }
            this.m_popup.show(this, event.getX(), event.getY());
            this.m_popup = null;
        }
        super.processMouseEvent(event);
    }

    public PvPickEvent getPickEvent(int x, int y) {
        PdVector[] worldData = this.getWorldFromPixel(x, y, 10000);
        PdVector base = (PdVector)worldData[0].clone();
        PdVector dir = (PdVector)worldData[1].clone();
        PdVector base3 = new PdVector(3);
        PdVector dir3 = new PdVector(3);
        PvPickEvent pickPos = null;
        if (this.m_mode != 8) {
            PgGeometryIf[] geom;
            if (this.m_geomIf != null && this.m_geomIf.isVisible()) {
                this.getModelFromWorld(this.m_geomIf, base, dir);
                base3.copyArray(base);
                dir3.copyArray(dir);
                dir3.normalize();
                pickPos = this.m_geomIf.intersectionWithLine(base3, dir3);
                if (pickPos != null) {
                    pickPos.setGeometry(this.m_geomIf);
                }
            }
            if (pickPos == null && (geom = this.getGeometries()) != null) {
                int i = 0;
                while (i < geom.length) {
                    if (geom[i] != this.m_geomIf && geom[i].isVisible()) {
                        base.copyArray(worldData[0]);
                        dir.copyArray(worldData[1]);
                        this.getModelFromWorld(geom[i], base, dir);
                        base3.copyArray(base);
                        dir3.copyArray(dir);
                        dir3.normalize();
                        pickPos = geom[i].intersectionWithLine(base3, dir3);
                        if (pickPos != null) {
                            pickPos.setGeometry(geom[i]);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        if (pickPos == null) {
            PsDebug.notify("no geometry hit, use backplane");
            worldData[0].setSize(3);
            worldData[1].setSize(3);
            worldData[1].normalize();
            pickPos = new PvPickEvent(3);
            pickPos.setVertex(worldData[0]);
            pickPos.setDistance(0.0);
            pickPos.setViewBase(worldData[0]);
            pickPos.setViewDir(worldData[1]);
        }
        pickPos.setLocation(new Point(x, y));
        return pickPos;
    }

    protected void setCurrentMajorMode(int mode) {
        this.m_modeMajor = mode;
        this.setMinorMode(mode);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_modeMajor);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_modeMajor);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_modeMajor]);
    }

    private PdVector[] getWorldFromPixel(int x, int y, int z) {
        PdVector base = new PdVector(x, y, z, 1.0);
        PdVector dir = new PdVector(0.0, 0.0, -1000.0, 0.0);
        if (this.m_currentCamera != null) {
            base.leftMultMatrix(this.m_currentCamera.m_transInv);
            dir.leftMultMatrix(this.m_currentCamera.m_transInv);
        }
        return new PdVector[]{base, dir};
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_scene.getGeometries();
    }

    private void drawInfo(Graphics g) {
        int x = this.m_currLoc.width;
        int y = this.m_nHeight - 1 - this.m_currLoc.height;
        String info = "";
        PdVector vert = null;
        PgGeometryIf geom = null;
        PvPickEvent pickPos = this.getPickEvent(x, y);
        geom = pickPos.getGeometry();
        vert = pickPos.getVertex();
        info = info + "Nearest Position = ";
        if (vert != null) {
            int i = 0;
            while (i < vert.getSize()) {
                info = info + "\n  " + (float)vert.getEntry(i);
                ++i;
            }
        } else {
            info = info + "null";
        }
        info = info + "\nDistance = " + pickPos.getDistance();
        if (geom != null) {
            info = info + "\nGeometry = " + geom.getName();
            if (pickPos.getElementInd() != -1) {
                info = info + "\nElement  = " + pickPos.getElementInd();
            }
            if (pickPos.getVertexInd() != -1) {
                info = info + "\nClose to Vertex = " + pickPos.getVertexInd();
            }
        }
        String[] infoArr = PuString.splitString(info, '\n');
        g.setFont(PsConfig.getFont(1));
        FontMetrics fm = g.getFontMetrics();
        int height = fm.getHeight();
        int width = 20 * fm.charWidth('0');
        int i = 0;
        while (i < infoArr.length) {
            width = Math.max(width, fm.stringWidth(infoArr[i]));
            ++i;
        }
        int xOff = 7;
        int yOff = 7;
        int indent = 3;
        int xPos = Math.min(x, this.m_nWidth - width - 2 * indent - xOff - 5);
        int yPos = Math.min(y, this.m_nHeight - infoArr.length * height - 2 * indent - yOff - 5);
        g.setColor(Color.white);
        g.fillRect(xPos + xOff, yPos + yOff, width + 2 * indent, infoArr.length * height + 2 * indent);
        g.setColor(Color.black);
        int i2 = 0;
        while (i2 < infoArr.length) {
            g.drawString(infoArr[i2], xPos + xOff + indent, yPos + yOff + indent + (i2 + 1) * height);
            ++i2;
        }
        if (vert != null) {
            if (geom != null && geom.hasModelMatrix()) {
                PdMatrix model = geom.getModelMatrix();
                vert.setSize(4);
                vert.setEntry(3, 1.0);
                vert.leftMultMatrix(model);
            }
            int[] proj = this.getPixelFromWorld(vert);
            g.setColor(Color.red);
            g.drawOval(proj[0] - 5, proj[1] - 5, 10, 10);
            this.drawCross(g, 5, proj[0], proj[1]);
        }
    }

    protected static void normalizedCoordsFromViewport(double[] norm, int x, int y, int width, int height) {
        double xPos = (double)x + 0.5;
        double yPos = (double)height - 1.0 - (double)y - 0.5;
        double min = Math.min(width, height);
        if (min < 1.0E-10) {
            norm[1] = 0.0;
            norm[0] = 0.0;
        } else {
            norm[0] = 2.0 / (min - 1.0) * xPos - ((double)width - 1.0) / min;
            norm[1] = 2.0 / (min - 1.0) * yPos - ((double)height - 1.0) / min;
        }
    }

    public void showEdgesOnce(boolean aFlag) {
        this.m_bShowEdgesOnce = aFlag;
    }

    public boolean isShowingEdgesOnce() {
        return this.m_bShowEdgesOnce;
    }

    public void setAutoCenter(boolean flag) {
        this.m_bCentered = !flag;
    }

    public void addCameraListener(PvCameraListenerIf listener) {
        if (this.m_cameraListener == null) {
            this.m_cameraListener = new Vector();
        } else if (this.hasCameraListener(listener)) {
            PsDebug.warning("listener = " + listener.getName() + " of listener already used.");
            return;
        }
        this.m_cameraListener.addElement(listener);
    }

    public int getNumGeometries() {
        PgGeometryIf[] geom = this.getGeometries();
        if (geom == null) {
            return 0;
        }
        return geom.length;
    }

    protected PgGeometryIf[] getAllGeometries() {
        PvGeometry[] geomList = this.getAllGeometryContainers();
        if (geomList == null) {
            return null;
        }
        PgGeometryIf[] ifList = new PgGeometryIf[geomList.length];
        int i = 0;
        while (i < geomList.length) {
            ifList[i] = geomList[i].getGeometry();
            ++i;
        }
        return ifList;
    }

    public void setEnabledLocalTransform(boolean flag) {
        this.m_bLocalTransform = flag;
    }

    protected Frame hasParentFrame() {
        Container parentFrame = this.getParent();
        while (parentFrame != null) {
            if (parentFrame instanceof PsMainFrame) {
                return (Frame)parentFrame;
            }
            if (parentFrame instanceof Frame) {
                return null;
            }
            parentFrame = parentFrame.getParent();
        }
        return (Frame)parentFrame;
    }

    protected void updateCameraListener(int state) {
        if (this.m_currentCamera == null) {
            return;
        }
        if (this.m_cameraListener != null) {
            PvCameraEvent cameraEvent = new PvCameraEvent(this, 3);
            cameraEvent.setCamera(this.m_currentCamera);
            cameraEvent.setLocation(new Point(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height));
            PdVector[] worldData = this.getWorldFromPixel(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height, 10000);
            worldData[0].setSize(3);
            cameraEvent.setVertex(worldData[0]);
            Enumeration e = this.m_cameraListener.elements();
            while (e.hasMoreElements()) {
                if (state == 101) {
                    ((PvCameraListenerIf)e.nextElement()).pickCamera(cameraEvent);
                    continue;
                }
                if (state == 102) {
                    ((PvCameraListenerIf)e.nextElement()).dragCamera(cameraEvent);
                    continue;
                }
                if (state == 103) {
                    return;
                }
                PsDebug.warning("unknown state = " + state);
                return;
            }
        }
    }

    public boolean isShowingBndBox() {
        return this.hasPaintTag(128);
    }

    public void showBndBox(boolean aFlag) {
        if (aFlag) {
            if (!this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
                PgJvxSrc bndbox = new PgJvxSrc();
                bndbox.setDimOfVertices(3);
                bndbox.setName(PsConfig.getMessage("BoundingBox"));
                bndbox.showElements(false);
                bndbox.showEdges(true);
                bndbox.setGlobalEdgeSize(1.0);
                bndbox.setGlobalEdgeColor(Color.blue);
                bndbox.setDimOfVertices(3);
                bndbox.setNumVertices(8);
                bndbox.setDimOfElements(3);
                bndbox.setNumElements(6);
                bndbox.getElement(0).set(0, 3, 2, 1);
                bndbox.getElement(1).set(0, 1, 5, 4);
                bndbox.getElement(2).set(1, 2, 6, 5);
                bndbox.getElement(3).set(2, 3, 7, 6);
                bndbox.getElement(4).set(3, 0, 4, 7);
                bndbox.getElement(5).set(4, 5, 6, 7);
                this.addGeometry(bndbox, 1);
                this.m_specialGeom.put(GEOM_BNDBOX, bndbox);
            }
            this.recomputeBndBox();
        } else if (this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX));
            this.m_specialGeom.remove(GEOM_BNDBOX);
        }
        this.setPaintTag(128, aFlag);
        this.update(this);
    }

    public PsPanel getInfoPanel() {
        if (this.m_infoPanel == null || !this.m_infoPanel.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_infoPanel = new PvDisplay_IP();
            this.m_infoPanel.setParent(this);
            this.m_infoPanel.update(this);
        }
        return this.m_infoPanel;
    }

    public boolean containsGeometry(PgGeometryIf aGeom) {
        if (aGeom == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.m_scene.containsGeometry(aGeom);
    }

    public void keyPressed(KeyEvent event) {
        int key;
        if (event.isControlDown()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            int key2 = event.getKeyCode();
            switch (key2) {
                case 9: {
                    PgGeometryIf g;
                    PgGeometryIf geom = this.getSelectedGeometry();
                    PvGeometry[] geomList = this.getGeometryContainers();
                    if (geomList == null) {
                        return;
                    }
                    int ind = -1;
                    int i = 0;
                    while (i < geomList.length) {
                        if (geom == geomList[i].getGeometry()) {
                            ind = i;
                            break;
                        }
                        ++i;
                    }
                    if (ind != -1) {
                        int j = 0;
                        while (j < geomList.length) {
                            PgGeometryIf g2 = geomList[(ind + j + 1) % geomList.length].getGeometry();
                            if (g2 != geom && !this.m_specialGeom.contains(g2)) {
                                this.selectGeometry(g2);
                                this.update(this);
                                return;
                            }
                            ++j;
                        }
                    }
                    if (geomList.length <= 0 || geomList[0] == null || (g = geomList[0].getGeometry()) == geom) break;
                    this.selectGeometry(g);
                    this.update(this);
                    return;
                }
            }
            return;
        }
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        }
        if ((key = event.getKeyCode()) == this.m_prevKey) {
            return;
        }
        this.m_prevKey = key;
        if (event.isShiftDown()) {
            switch (key) {
                case 65: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 66: {
                    this.showBndBox(!this.isShowingBndBox());
                    break;
                }
                case 67: {
                    this.setPaintTag(16, !this.hasPaintTag(16));
                    break;
                }
                case 68: {
                    this.showDepthcue(!this.isShowingDepthcue());
                    break;
                }
                case 69: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 70: {
                    this.showFrame(!this.isShowingFrame());
                    break;
                }
                case 71: {
                    this.showGrid(!this.isShowingGrid());
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.showBackImage(!this.isShowingBackImage());
                    break;
                }
                case 76: {
                    this.setPaintTag(4, !this.hasPaintTag(4));
                    break;
                }
                case 77: {
                    this.showMagnet(!this.isShowingMagnet());
                    break;
                }
                case 80: {
                    this.setEnabledPainters(!this.isEnabledPainters());
                    break;
                }
                case 82: {
                    this.showCopyright(!this.isShowingCopyright());
                    break;
                }
                case 84: {
                    this.setEnabledTags(!this.isEnabledTags());
                    PsDebug.showStatus("tag mode = " + this.isEnabledTags());
                    break;
                }
                case 88: {
                    this.showAxes(!this.isShowingAxes());
                    break;
                }
                case 89: {
                    this.setEnabledFastZBuffer(!this.isEnabledFastZBuffer());
                    break;
                }
                case 90: {
                    this.setEnabledZBuffer(!this.isEnabledZBuffer());
                    break;
                }
                default: {
                    return;
                }
            }
            this.update(this);
        } else {
            switch (key) {
                case 127: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 8: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 65: {
                    this.setMinorMode(12);
                    this.glowVertices(true);
                    this.showMagnet(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 67: {
                    PsDebug.showStatus(m_minorModeMessage[1]);
                    this.center();
                    this.repaint();
                    break;
                }
                case 68: {
                    PvGeometry[] container;
                    this.setMinorMode(14);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    PiVector pickedVertexInd = this.m_currentGeom.getTaggedVertices();
                    if (pickedVertexInd == null || pickedVertexInd.getSize() == 0) {
                        PsDebug.warning("missing selected vertices");
                        break;
                    }
                    int size = pickedVertexInd.getSize();
                    PdVector[] tagVertex = new PdVector[size];
                    int i = 0;
                    while (i < size) {
                        tagVertex[i] = this.m_currentGeom.getVertex(pickedVertexInd.getEntry(i));
                        ++i;
                    }
                    this.m_currentGeom.untagAllVertices();
                    PdMatrix mat = null;
                    boolean bOrient = true;
                    switch (size) {
                        case 1: {
                            mat = PuReflect.pointReflect(tagVertex[0]);
                            bOrient = true;
                            break;
                        }
                        case 2: {
                            PdVector dir = PdVector.subNew(tagVertex[1], tagVertex[0]);
                            mat = PuReflect.rotateLine(tagVertex[0], dir);
                            bOrient = false;
                            break;
                        }
                        case 3: {
                            mat = PuReflect.planeReflect(tagVertex[0], tagVertex[1], tagVertex[2]);
                            bOrient = false;
                            break;
                        }
                        default: {
                            PsDebug.warning("too many selected vertices");
                        }
                    }
                    if (mat == null || (container = this.getGeometryContainers()) == null) break;
                    int i2 = 0;
                    while (i2 < container.length) {
                        if (container[i2].isVisible()) {
                            PgGeometryIf geom = container[i2].getGeometry();
                            boolean bVector = mat.det33() < 0.0;
                            PgGeometry newGeom = geom.reflect(mat, bOrient, bVector);
                            this.addGeometry(newGeom);
                        }
                        ++i2;
                    }
                    this.update(this);
                    break;
                }
                case 69: {
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    this.setMinorMode(15);
                    this.m_newElement = new PiVector();
                    this.glowVertices(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 70: {
                    PsDebug.showStatus(m_minorModeMessage[2]);
                    this.fit();
                    this.repaint();
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.setMinorMode(6);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 77: {
                    this.setMinorMode(9);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 79: {
                    this.setMinorMode(0);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 80: {
                    this.setMinorMode(5);
                    this.showMagnet(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 81: {
                    PsDebug.showStatus(m_minorModeMessage[4]);
                    this.setEnabledAnimation(false);
                    this.stop();
                    this.update(this);
                    break;
                }
                case 82: {
                    this.init();
                    PsDebug.showStatus(m_minorModeMessage[0]);
                    break;
                }
                case 83: {
                    this.setMinorMode(1);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 84: {
                    this.setMinorMode(3);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 85: {
                    this.setMinorMode(11);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 87: {
                    PsDebug.showStatus(m_minorModeMessage[3]);
                    this.setEnabledAnimation(true);
                    this.start();
                    this.update(this);
                    break;
                }
                case 88: {
                    this.setMinorMode(2);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 89: {
                    this.setEnabledNewZBuffer(!this.isEnabledNewZBuffer());
                    PsDebug.showStatus("new z-buffered rendering = " + this.isEnabledNewZBuffer());
                    break;
                }
                case 90: {
                    this.setMinorMode(4);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        PsDebug.notify("Pressed key = " + key);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        this.bDrag = false;
        this.repaint();
    }

    private synchronized void setCurrentGeometry(PvGeometry geom) {
        if (geom == null) {
            this.m_currentGeom = null;
            this.m_geomIf = null;
        } else {
            PgGeometryIf g;
            if (this.hasPaintTag(2048) && this.m_currentGeom != null && this.m_currentGeom != geom && !this.m_specialGeom.contains(g = this.m_currentGeom.getGeometry())) {
                if (g.isVisible()) {
                    g.setVisible(false);
                }
                if (this.m_currentGeom.isVisible()) {
                    this.m_currentGeom.setVisible(false);
                }
            }
            this.m_currentGeom = geom;
            if (!this.m_currentGeom.isVisible()) {
                this.m_currentGeom.setVisible(true);
            }
            this.m_geomIf = geom.getGeometry();
        }
        if (this.m_currentGeom != null && this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        if (geom == null) {
            this.setFrameTitle(null);
        } else {
            this.setFrameTitle(this.m_geomIf.getName());
        }
    }

    public void requestPickFocus(PvPickListenerIf listener) {
        this.m_pickFocus = listener;
    }

    public void setEnabledAnimation(boolean aFlag) {
        this.m_bEnableAnimation = aFlag;
        if (!this.m_bEnableAnimation) {
            this.stop();
        }
    }

    public boolean incrementAutoRotation() {
        this.m_currentCamera.mouseAnimateGeometry();
        this.updateCameraListener(101);
        return true;
    }

    public PvCameraIf[] getCameras() {
        PvCameraIf[] camera = new PvCameraIf[this.m_camera.size()];
        int ind = 0;
        Enumeration enumeration = this.m_camera.elements();
        while (enumeration.hasMoreElements()) {
            camera[ind++] = (PvCameraIf)enumeration.nextElement();
        }
        return camera;
    }

    public int getAmbientProjection() {
        if (this.m_currentGeom != null) {
            this.m_ambientProj = this.m_currentGeom.getAmbientProjection();
        }
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int mode) {
        if (this.m_currentGeom != null) {
            this.m_currentGeom.setAmbientProjection(mode);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientProjection(mode);
            }
        }
        this.m_ambientProj = mode;
    }

    private void scaleBackgroundImage(int width, int height) {
        int newImageHeight;
        int newImageWidth;
        double imageHeight;
        if (this.m_backImage == null) {
            return;
        }
        double dispAspect = (0.5 + (double)width) / (double)height;
        double imageWidth = this.m_backImage.getWidth(null);
        double imageAspect = (0.5 + imageWidth) / (imageHeight = (double)this.m_backImage.getHeight(null));
        if (dispAspect < imageAspect) {
            newImageWidth = -1;
            newImageHeight = height;
        } else {
            newImageWidth = width;
            newImageHeight = -1;
        }
        this.m_backImage = this.m_backImage.getScaledInstance(newImageWidth, newImageHeight, 2);
    }

    public void setEnabledClearScreen(boolean aFlag) {
        this.setPaintTag(8192, aFlag);
        this.update(this);
    }

    public void mouseExited(MouseEvent event) {
        this.m_bMouseInside = false;
    }

    public boolean isShowingEdgeAura() {
        return this.m_bShowEdgeAura;
    }

    public void showEdgeAura(boolean aFlag) {
        this.m_bShowEdgeAura = aFlag;
    }

    public Dimension getSize() {
        Dimension size = super.getSize();
        return size;
    }

    public boolean isEnabledZBuffer() {
        return this.m_bEnableZBuffer;
    }

    public boolean isEnabledFastZBuffer() {
        return this.m_bEnableFastZBuffer;
    }

    protected void setEnabledNewZBuffer(boolean aFlag) {
        this.m_bEnableNewZBuffer = aFlag;
    }

    public static void setDefaultSize(Dimension size) {
        PvDisplay.m_defSize.height = size.height;
        PvDisplay.m_defSize.width = size.width;
    }

    public void setEnabledPainters(boolean aFlag) {
        this.m_bEnableSorting = aFlag;
    }

    private void setMinorMode(int mode) {
        this.m_mode = mode;
        switch (this.m_mode) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public boolean isShowingGrid() {
        return this.m_bShowGrid;
    }

    public void showGrid(boolean aFlag) {
        this.m_bShowGrid = aFlag;
        if (this.m_bShowGrid) {
            if (!this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
                PvGrid grid = new PvGrid(3);
                grid.setName(PsConfig.getMessage(GEOM_XY_GRID));
                this.addGeometry(grid, -1);
                this.m_specialGeom.put(GEOM_XY_GRID, grid);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_XY_GRID));
            this.m_specialGeom.remove(GEOM_XY_GRID);
        }
        this.update(this);
    }

    public void keyTyped(KeyEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
        int y;
        int x = event.getX();
        if (!this.updatePosition(x, y = event.getY())) {
            return;
        }
        this.m_currLoc.width = x;
        this.m_currLoc.height = this.m_nHeight - 1 - y;
        if (this.bDrag) {
            if ((Math.abs(this.xUp - x) > 0 || Math.abs(this.yUp - y) > 0) && this.isEnabledAnimation()) {
                this.start();
            }
            this.bDrag = false;
        }
        if (this.hasPaintTag(256)) {
            this.repaint();
        }
        if (this.m_currentGeom != null && this.hasPaintTag(4096)) {
            boolean bRepaint = false;
            if (this.m_pickedVertex != -1) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex);
                bRepaint = true;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(x, y);
            PsDebug.notify("magnet mode, vertex = " + this.m_pickedVertex);
            if (this.m_pickedVertex != -1) {
                bRepaint = true;
            }
            if (bRepaint) {
                this.repaint();
            }
        }
    }

    public boolean hasPickListener(PvPickListenerIf listener) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.contains(listener);
    }

    public boolean removePickListener(PvPickListenerIf listener) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.removeElement(listener);
    }

    public void center() {
        if (this.m_scene == null) {
            PsDebug.notify("missing m_scene");
            return;
        }
        PdVector[] bndBox = this.m_scene.getBounds();
        if (bndBox == null) {
            PsDebug.notify("missing bndBox");
            return;
        }
        PdVector center = new PdVector(3);
        center.blend(0.5, bndBox[0], 0.5, bndBox[1]);
        this.m_currentCamera.setInterest(center);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 16) {
            return;
        }
        this.m_prevKey = -1;
        this.setMinorMode(this.m_modeMajor);
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
        this.bDrag = false;
        if (!event.isShiftDown()) {
            switch (event.getKeyCode()) {
                case 65: {
                    this.glowVertices(false);
                    this.showMagnet(false);
                    break;
                }
                case 69: {
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    if (this.m_newElement != null && this.m_newElement.getSize() > 0) {
                        this.m_currentGeom.addGeometryElement(this.m_newElement);
                        this.m_currentGeom.untagAllVertices();
                        this.m_geomIf.update(this.m_geomIf);
                    }
                    this.m_newElement = null;
                    this.glowVertices(false);
                    break;
                }
                case 80: {
                    this.showMagnet(false);
                    break;
                }
                case 77: 
                case 85: 
                case 88: {
                    this.repaint();
                    break;
                }
            }
        }
    }

    public double getFarClip() {
        return this.m_currentCamera.m_farClip.getValue();
    }

    public void setFarClip(double dist) {
        this.m_currentCamera.m_farClip.setValue(dist);
    }

    public boolean selectGeometry(PgGeometryIf aGeom) {
        if (aGeom != null && !this.containsGeometry(aGeom)) {
            return false;
        }
        this.setCurrentGeometry(this.m_scene.getGeometry(aGeom));
        if (this.m_currentGeom != null) {
            if (this.getTransformationMode() == 1) {
                if (this.m_currentGeom.hasModelMatrix()) {
                    this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
                } else {
                    this.setTransformationMode(0);
                }
            } else if (this.getTransformationMode() == 2) {
                if (this.m_currentGeom.hasAmbientMatrix()) {
                    this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
                } else {
                    this.setTransformationMode(0);
                }
            }
            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
            this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
            if (this.isShowingFrame() && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
                this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.update(this.m_coordFrame);
            }
        }
        if (this.m_viewer != null) {
            this.m_viewer.setGeometry(aGeom);
        }
        this.m_scene.selectGeometry(this.m_currentGeom);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        return true;
    }

    public void removeGeometries() {
        PsDebug.notify("called.");
        PvGeometry[] geomList = this.getGeometryContainers();
        if (geomList == null) {
            return;
        }
        int i = 0;
        while (i < geomList.length) {
            PgGeometryIf geom = geomList[i].getGeometry();
            geom.removeDisplay(this);
            this.m_scene.removeGeometry(geomList[i]);
            ++i;
        }
        this.m_currentGeom = null;
    }

    public boolean isEnabledAnimation() {
        return this.m_bEnableAnimation;
    }

    public Point getPosition(int xPos, int yPos) {
        Frame parentFrame = this.hasParentFrame();
        if (parentFrame == null) {
            return new Point(0, 0);
        }
        return parentFrame.getLocation();
    }

    public void setDrawingOrder(int order, PgGeometryIf aGeom) {
        PsDebug.notify("called, geometry name = " + aGeom.getName());
        if (!this.containsGeometry(aGeom)) {
            if (aGeom != null) {
                PsDebug.warning("geometry=" + aGeom.getName() + " not registered in listener");
            }
            return;
        }
        PvGeometry geom = this.m_scene.getGeometry(aGeom);
        this.m_scene.removeGeometry(geom);
        geom.setDrawingOrder(order);
        this.m_scene.addGeometry(geom);
    }

    public void setPosition(int xPos, int yPos) {
        Frame parentFrame = this.hasParentFrame();
        if (parentFrame == null) {
            return;
        }
        ((Component)parentFrame).setLocation(xPos, yPos);
    }

    public PvCameraIf getCamera() {
        return this.m_currentCamera;
    }

    public PvCameraIf getCamera(int type) {
        if (type < 0 || PvDisplayIf.CAMERA_NAME.length <= type) {
            PsDebug.warning("camera type out of range = " + type);
            return this.m_currentCamera;
        }
        return (PvCamera)this.m_camera.get(PvDisplayIf.CAMERA_NAME[type]);
    }

    public boolean selectCamera(int type) {
        if (type < 0 || PvDisplayIf.CAMERA_NAME.length <= type) {
            return false;
        }
        if (this.getCamera(type) == null) {
            this.addCamera(PvDisplayIf.CAMERA_NAME[type], new PvCamera(this, type));
        }
        this.m_currentCamera = (PvCamera)this.getCamera(type);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        this.m_currentCamera.setMode(this.m_mode);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        if (this.m_cameraPanel != null) {
            if (!this.m_currentCamera.hasInspector("Info")) {
                this.m_currentCamera.addInspector("Info", this.m_cameraPanel);
            } else {
                this.m_cameraPanel.setParent(this.m_currentCamera);
                this.m_cameraPanel.update(this.m_currentCamera);
            }
        }
        this.updateCameraListener(101);
        return true;
    }

    public boolean hasAxes() {
        return this.m_axes != null;
    }

    protected int getAmbientDim() {
        return this.m_ambientDim;
    }

    public int getImageFitMode() {
        return this.m_imageFitMode;
    }

    public void setImageFitMode(int mode) {
        this.m_imageFitMode = mode;
    }

    private void glowVertices(boolean state) {
        if (this.m_currentGeom == null) {
            return;
        }
        if (state) {
            this.m_bSaveShowingVertices = this.m_currentGeom.getState(50);
        }
        if (this.m_bSaveShowingVertices) {
            return;
        }
        this.m_currentGeom.setStateFromDisplay(50, state);
        this.m_geomIf.update(null);
        this.repaint();
    }

    public boolean update(Object event) {
        block28: {
            PsDebug.notify("called");
            if (!this.isEnabledUpdate()) {
                return true;
            }
            if (event == this.m_sleep) {
                return true;
            }
            PvGeometry[] geom = this.getAllGeometryContainers();
            if (geom == null || geom.length <= 0) break block28;
            int i = 0;
            while (i < geom.length) {
                block29: {
                    if (geom[i].getGeometry() != event) break block29;
                    PsDebug.notify("event==geometry: updating PvGeometry+repaint");
                    if (!geom[i].getName().startsWith(geom[i].getGeometry().getName()) && this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                        this.m_infoPanel.update(this);
                    }
                    PvScene pvScene = this.m_scene;
                    synchronized (pvScene) {
                        geom[i].update(event);
                        if (this.m_currentGeom == geom[i]) {
                            if (this.isShowingBndBox()) {
                                this.recomputeBndBox();
                            }
                            if (this.m_geomIf == null) {
                                this.setFrameTitle(null);
                            } else {
                                this.setFrameTitle(this.m_geomIf.getName());
                            }
                            if (this.m_currentGeom.getAmbientSpace() != this.m_ambientSpace) {
                                this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
                            }
                            if (this.m_currentGeom.getAmbientProjection() != this.m_ambientProj) {
                                this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
                            }
                            if (this.m_cameraPanel != null && this.m_cameraPanel.isShowing()) {
                                this.m_cameraPanel.update(this.m_currentCamera);
                            }
                        }
                        this.m_scene.update(geom[i]);
                        Object var5_5 = null;
                    }
                    this.repaint();
                    return true;
                }
                ++i;
            }
        }
        if (event == this) {
            PsDebug.notify("update forward to IP");
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                this.m_infoPanel.update(this);
            }
        } else if (event == this.m_infoPanel) {
            PsDebug.notify("event=infoPanel: repaint");
        } else if (event == this.m_currentCamera) {
            PsDebug.notify("event=camera: repaint");
            this.updateCameraListener(101);
        } else if (event == this.m_backgroundColor) {
            PsDebug.notify("event=m_backgroundColor: repaint");
        } else if (event == this.m_foregroundColor) {
            PsDebug.notify("event=m_foregroundColor: repaint");
        } else if (event == this.m_height || event == this.m_width) {
            PsDebug.notify("change size");
            this.setSizeWithinFrame(this.m_width.getValue(), this.m_height.getValue());
        } else if (event != null) {
            PsDebug.warning("could not handle event = ???\n\tmissing implementation of update(Object)");
            return false;
        }
        this.repaint();
        return true;
    }

    public boolean isEnabledUpdate() {
        return this.m_bIsEnabledUpdate;
    }

    public void update(Graphics g) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage()) {
            this.paintGeom(this.m_g);
            if (this.m_image != null) {
                g.drawImage(this.m_image, 0, 0, this);
            }
        }
        this.m_bDrawing = false;
    }

    public PdMatrix getTransMatrix(int type) {
        boolean bIsCameraTransform;
        boolean bl = bIsCameraTransform = this.getTransformationMode() == 0;
        if (!bIsCameraTransform && this.m_currentGeom != null) {
            this.m_currentGeom.setModelMatrix(this.m_modelCamera.getModelMatrix());
            if (this.getTransformationMode() == 2) {
                this.m_currentGeom.setAmbientMatrix(this.m_modelCamera.getAmbientMatrix(), this.m_modelCamera.getAmbientInvMatrix());
                this.m_currentGeom.setAmbientProjection(this.m_ambientProj);
            }
        }
        this.setEnabledModelOfSpecials(!bIsCameraTransform);
        boolean state = true;
        if (this.isShowingBndBox()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX), state);
        }
        if (this.isShowingAxes()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES), state);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_0"), state);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_1"), state);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_2"), state);
        }
        switch (type) {
            case 0: {
                return this.m_currentCamera.m_trans;
            }
            case 16: {
                return this.m_currentCamera.m_transInv;
            }
            case 1: {
                return this.m_currentCamera.m_trans;
            }
            case 32: {
                return this.m_currentCamera.m_transInv;
            }
            case 2: {
                return this.m_currentCamera.m_proj;
            }
            case 64: {
                return this.m_currentCamera.m_projInv;
            }
            case 4: {
                return this.m_currentCamera.m_view;
            }
            case 128: {
                return this.m_currentCamera.m_viewInv;
            }
            case 8: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelMatrix();
                }
                return null;
            }
            case 256: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelInvMatrix();
                }
                return null;
            }
            case 512: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getAmbientMatrix();
                }
                return null;
            }
            case 1024: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getAmbientInvMatrix();
                }
                return null;
            }
        }
        PsDebug.warning("unknown matrix type.");
        return null;
    }

    public void setTransMatrix(int type, PdMatrix mat) {
        switch (type) {
            case 0: {
                this.m_currentCamera.m_trans.copy(mat);
                break;
            }
            case 16: {
                this.m_currentCamera.m_transInv.copy(mat);
                break;
            }
            case 1: {
                this.m_currentCamera.m_trans.copy(mat);
                break;
            }
            case 32: {
                this.m_currentCamera.m_transInv.copy(mat);
                break;
            }
            case 2: {
                this.m_currentCamera.m_proj.copy(mat);
                break;
            }
            case 64: {
                this.m_currentCamera.m_projInv.copy(mat);
                break;
            }
            case 4: {
                this.m_currentCamera.m_view.copy(mat);
                break;
            }
            case 128: {
                this.m_currentCamera.m_viewInv.copy(mat);
                break;
            }
            default: {
                PsDebug.warning("unknown matrix type.");
            }
        }
        this.updateCameraListener(101);
    }

    private void setFrameTitle(String title) {
        if (title != null && this.m_currentFrameName != null && this.m_currentFrameName.equals(title)) {
            return;
        }
        this.m_currentFrameName = title;
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        if (this.m_currentFrameName != null) {
            frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentFrameName);
        } else {
            frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": ");
        }
    }

    public String getBackgroundImageFile() {
        return this.m_backgroundImage;
    }

    private void updateCoordFrame(int ambientDim, int ambientSpace, int ambientProj) {
        if (this.m_coordFrame == null) {
            PsDebug.warning("missing coordinate frame, must call showFrame(true) before.");
            return;
        }
        this.m_coordFrame.setAmbientSpace(ambientSpace);
        this.m_coordFrame.setAmbientProjection(ambientProj);
        this.m_coordFrame.setDimOfVertices(ambientDim);
        this.m_coordFrame.setNumVertices(ambientDim + 1);
        this.m_coordFrame.setDimOfPolygons(2);
        this.m_coordFrame.setNumPolygons(ambientDim);
        String[] label = new String[]{"X", "Y", "Z", "T", "U", "V", "W"};
        int i = 0;
        while (i < ambientDim) {
            PdVector v = this.m_coordFrame.getVertex(i + 1);
            v.setEntry(i, 1.0);
            v.setName(label[i]);
            this.m_coordFrame.getPolygon(i).set(0, i + 1);
            ++i;
        }
    }

    public boolean hasCameraListener(PvCameraListenerIf listener) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.contains(listener);
    }

    public boolean removeCameraListener(PvCameraListenerIf listener) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.removeElement(listener);
    }

    private void recomputeBndBox() {
        PvGeometry bnd;
        PgJvxSrc bndbox = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (this.m_currentGeom == null || this.m_currentGeom.getGeometry() == bndbox) {
            return;
        }
        PdVector[] box = this.m_currentGeom.getBounds();
        if (box == null) {
            return;
        }
        if (bndbox.isShowingBackface()) {
            bndbox.showBackface(false);
        }
        bndbox.setVertex(0, box[0]);
        bndbox.setVertex(1, new PdVector(box[1].m_data[0], box[0].m_data[1], box[0].m_data[2]));
        bndbox.setVertex(2, new PdVector(box[1].m_data[0], box[1].m_data[1], box[0].m_data[2]));
        bndbox.setVertex(3, new PdVector(box[0].m_data[0], box[1].m_data[1], box[0].m_data[2]));
        bndbox.setVertex(4, new PdVector(box[0].m_data[0], box[0].m_data[1], box[1].m_data[2]));
        bndbox.setVertex(5, new PdVector(box[1].m_data[0], box[0].m_data[1], box[1].m_data[2]));
        bndbox.setVertex(6, box[1]);
        bndbox.setVertex(7, new PdVector(box[0].m_data[0], box[1].m_data[1], box[1].m_data[2]));
        bndbox.makeElementNormals();
        if (this.m_scene != null && (bnd = this.m_scene.getGeometry(bndbox)) != null) {
            bnd.update(bndbox);
        }
    }

    private void setEnabledModelOfSpecial(PgGeometryIf specialGeom, boolean state) {
        PdMatrix modMat;
        if (specialGeom == null) {
            return;
        }
        PvGeometry specialContainer = this.m_scene.getGeometry(specialGeom);
        if (specialContainer == null) {
            return;
        }
        if (!state) {
            specialContainer.setModelMatrix(null);
            specialContainer.setAmbientMatrix(null, null);
            return;
        }
        PdMatrix ambMat = null;
        PdMatrix ambInvMat = null;
        if (this.m_currentGeom != null) {
            if (this.getTransformationMode() == 2) {
                ambMat = this.m_currentGeom.getAmbientMatrix();
                ambInvMat = this.m_currentGeom.getAmbientInvMatrix();
            }
            modMat = this.m_currentGeom.getModelMatrix();
        } else if (this.m_modelCamera != null) {
            if (this.getTransformationMode() == 2) {
                ambMat = this.m_modelCamera.getAmbientMatrix();
                ambInvMat = this.m_modelCamera.getAmbientInvMatrix();
            }
            modMat = this.m_modelCamera.getModelMatrix();
        } else {
            return;
        }
        specialContainer.setModelMatrix(modMat);
        if (this.getTransformationMode() == 2) {
            specialContainer.setAmbientMatrix(ambMat, ambInvMat);
            specialContainer.setAmbientProjection(this.m_ambientProj);
        } else {
            specialContainer.setAmbientMatrix(null, null);
        }
        PgGeometryIf geomIf = specialContainer.getGeometry();
        if (geomIf == null) {
            return;
        }
        geomIf.setModelMatrix(modMat);
        if (this.getTransformationMode() == 2) {
            geomIf.setAmbientMatrix(ambMat, ambInvMat);
            geomIf.setAmbientProjection(this.m_ambientProj);
        } else {
            geomIf.setAmbientMatrix(null, null);
        }
    }

    public boolean addGeometry(PgGeometryIf aGeom) {
        return this.addGeometry(aGeom, 0);
    }

    private boolean addGeometry(PgGeometryIf aGeom, int drawingOrder) {
        if (aGeom == null) {
            PsDebug.warning("missing geometry.");
            return false;
        }
        PsDebug.notify("called, geometry = " + aGeom.getName());
        if (this.containsGeometry(aGeom)) {
            PsDebug.notify("geometry already registered in display.");
            return true;
        }
        aGeom.addDisplay(this);
        PvGeometry geom = new PvGeometry(aGeom.getDimOfVertices());
        geom.setDrawingOrder(drawingOrder);
        geom.setDisplay(this);
        geom.setGeometry(aGeom);
        this.m_scene.addGeometry(geom);
        if (this.m_scene.m_numGeometries == 0 && drawingOrder != 0) {
            this.setCurrentGeometry(geom);
        }
        if (this.m_scene.m_numGeometries == 1 && drawingOrder == 0) {
            this.setCurrentGeometry(geom);
            if (!this.m_bCentered) {
                this.fit();
            }
        }
        return true;
    }

    public boolean isEnabledTags() {
        return this.m_bEnableTag;
    }

    public void setAutoRotation(PdVector axis, double angle) {
        if (!PuReflect.makeRotation(this.m_currentCamera.m_incrView, axis, angle)) {
            return;
        }
        if (this.getTransformationMode() == 0) {
            this.m_currentCamera.m_incrViewInv.transpose(this.m_currentCamera.m_incrView);
        } else {
            this.m_modelCamera.m_incrModelInv.transpose(this.m_currentCamera.m_incrView);
        }
    }

    protected boolean updatePosition(int x, int y) {
        if (this.m_nWidth == 0 || this.m_nHeight == 0) {
            return false;
        }
        return this.m_currLoc.width != x || this.m_currLoc.height != this.m_nHeight - 1 - y;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        Enumeration e;
        PvPickEvent pickPos;
        if (this.m_bEnableFastZBuffer && this.m_bEnableZBuffer) {
            this.m_bSaveEnableZBuffer = this.m_bEnableZBuffer;
            this.m_bEnableZBuffer = false;
        }
        this.m_bFirstAfterPick = true;
        this.m_bMouseShiftConstraint = false;
        if (event.isPopupTrigger()) {
            return;
        }
        this.m_pickedVertex = -1;
        this.bDrag = false;
        if (this.m_viewer != null) {
            this.m_viewer.selectDisplay(this);
        }
        int x = event.getX();
        int y = event.getY();
        if (!this.m_bMouseInside || this.m_nWidth == 0 || this.m_nHeight == 0 || x < 0 || y < 0 || this.m_nWidth <= x || this.m_nHeight <= y) {
            return;
        }
        this.m_currLoc.width = x;
        this.m_currLoc.height = this.m_nHeight - 1 - y;
        this.m_bMouseDown = true;
        this.xDown = x;
        this.yDown = y;
        this.m_markBox.m_data[0] = x;
        this.m_markBox.m_data[1] = y;
        this.m_markBox.m_data[2] = x;
        this.m_markBox.m_data[3] = y;
        if (this.m_thread != null) {
            this.stop();
        }
        this.m_currentCamera.mousePressed(x, y);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.mousePressed(x, y);
        }
        this.updateCameraListener(101);
        if (event != null && event.isControlDown()) {
            PvGeometry[] geom = this.getAllGeometryContainers();
            if (geom == null || geom.length == 0) {
                return;
            }
            PdVector dist = new PdVector(geom.length);
            int i = 0;
            while (i < geom.length) {
                if (geom[i].isVisible()) {
                    PdVector[] worldData = this.getWorldFromPixel(x, y, 10000);
                    this.getModelFromWorld(geom[i], worldData[0], worldData[1]);
                    worldData[0].setSize(3);
                    worldData[1].setSize(3);
                    worldData[1].normalize();
                    PvPickEvent pickPos2 = geom[i].getGeometry().intersectionWithLine(worldData[0], worldData[1]);
                    if (pickPos2 == null) {
                        dist.setEntry(i, Double.MAX_VALUE);
                    } else {
                        dist.setEntry(i, pickPos2.getDistance());
                    }
                }
                ++i;
            }
            int minInd = dist.indexOfMin();
            if (dist.getEntry(minInd) != Double.MAX_VALUE) {
                this.selectGeometry(geom[minInd].getGeometry());
                this.update(this);
                return;
            }
        }
        if (this.m_mode == 12 || this.m_mode == 15) {
            if (this.m_currentGeom == null) {
                return;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(x, y);
            if (this.m_pickedVertex == -1) {
                PdVector[] worldData = this.getWorldFromPixel(x, y, 0);
                this.getModelFromWorld(this.m_currentGeom, worldData[0], worldData[1]);
                this.m_pickedVertex = this.m_currentGeom.addGeometryVertex(worldData[0]);
                PsDebug.showStatus("new vertex[" + this.m_pickedVertex + "] = (" + worldData[0].m_data[0] + "," + worldData[0].m_data[1] + "," + worldData[0].m_data[2] + "," + worldData[0].m_data[3]);
            } else {
                this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
            }
            if (this.m_newElement != null) {
                this.m_newElement.addEntry(this.m_pickedVertex);
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.repaint();
        } else if (this.m_mode == 6) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            pickPos = this.getPickEvent(x, y);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickInitial(pickPos);
            } else if (this.m_pickListener != null) {
                e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).pickInitial(pickPos);
                }
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            pickPos = this.getPickEvent(x, y);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickDisplay(pickPos);
            } else if (this.m_pickListener != null) {
                e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).pickDisplay(pickPos);
                }
            }
        } else if (this.m_mode == 10) {
            if (this.m_currentGeom == null) {
                return;
            }
            pickPos = this.getPickEvent(x, y);
            int elemInd = pickPos.getElementInd();
            if (elemInd == -1) {
                return;
            }
            PiVector elem = this.m_geomIf.getElement(elemInd);
            if (elem == null) {
                return;
            }
            if (elem.hasTag(1)) {
                elem.clearTag(1);
            } else {
                elem.setTag(1);
            }
            this.m_geomIf.update(this.m_geomIf);
            this.bDrag = false;
            this.repaint();
        } else if (this.m_mode == 5) {
            if (this.m_currentGeom == null) {
                return;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(x, y);
            PsDebug.notify("pick mode, vertex = " + this.m_pickedVertex);
            if (this.m_pickedVertex == -1) {
                return;
            }
            this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
            PdVector vert = this.m_currentGeom.getVertex(this.m_pickedVertex);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickVertex(this.m_geomIf, this.m_pickedVertex, vert);
            } else if (this.m_pickListener != null) {
                e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).pickVertex(this.m_geomIf, this.m_pickedVertex, vert);
                }
            }
            this.repaint();
        } else if (this.m_mode == 9 || this.m_mode == 2 || this.m_mode == 11) {
            // empty if block
        }
    }

    public void mouseDragged(MouseEvent event) {
        int y;
        if (this.m_bFirstAfterPick) {
            this.m_bFirstAfterPick = false;
            PsDebug.notify("event skipped since first after pick.");
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return;
        }
        if (event.isPopupTrigger()) {
            PsDebug.notify("event is popup trigger.");
            return;
        }
        int x = event.getX();
        if (!this.updatePosition(x, y = event.getY())) {
            PsDebug.notify("failed to update position: (" + x + "," + y + ")");
            return;
        }
        if (event.isShiftDown()) {
            if (!this.m_bMouseShiftConstraint) {
                this.m_mouseShiftConstraint = Math.abs(x - this.xDown) >= Math.abs(y - this.yDown) ? 2 : 1;
                this.m_bMouseShiftConstraint = true;
            }
            if (this.m_bMouseShiftConstraint && this.m_mode != 9 && this.m_mode != 11 && this.m_mode != 10 && this.m_mode != 2) {
                if (this.m_mouseShiftConstraint == 2) {
                    y = this.yDown;
                } else {
                    x = this.xDown;
                }
            }
        }
        this.m_markBox.m_data[2] = x;
        this.m_markBox.m_data[3] = y;
        this.m_currLoc.width = x;
        this.m_currLoc.height = this.m_nHeight - 1 - y;
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, x, y, this.m_nWidth, this.m_nHeight);
        if (this.m_mode == 12 || this.m_mode == 15) {
            if (this.m_pickedVertex == -1 || this.m_currentGeom == null) {
                return;
            }
            PdVector[] worldData = this.getWorldFromPixel(x, y, this.m_pick.getEntry(2));
            this.getModelFromWorld(this.m_currentGeom, worldData[0], worldData[1]);
            this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, worldData[0]);
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            PsDebug.showStatus("move vertex[" + this.m_pickedVertex + "] = (" + worldData[0].m_data[0] + "," + worldData[0].m_data[1] + "," + worldData[0].m_data[2] + "," + worldData[0].m_data[3]);
            this.repaint();
        } else if (this.m_mode == 6) {
            if (this.m_bDrawing) {
                return;
            }
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pickPos = this.getPickEvent(x, y);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragInitial(pickPos);
                } else if (this.m_pickListener != null) {
                    Enumeration e = this.m_pickListener.elements();
                    while (e.hasMoreElements()) {
                        ((PvPickListenerIf)e.nextElement()).dragInitial(pickPos);
                    }
                }
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pickPos = this.getPickEvent(x, y);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragDisplay(pickPos);
                } else if (this.m_pickListener != null) {
                    Enumeration e = this.m_pickListener.elements();
                    while (e.hasMoreElements()) {
                        ((PvPickListenerIf)e.nextElement()).dragDisplay(pickPos);
                    }
                }
            }
        } else if (this.m_mode == 5) {
            if (this.m_pickedVertex == -1 || this.m_currentGeom == null) {
                return;
            }
            if (!this.m_currentGeom.isVisible()) {
                return;
            }
            PdVector[] worldData = this.getWorldFromPixel(x, y, this.m_pick.getEntry(2));
            this.getModelFromWorld(this.m_currentGeom, worldData[0], worldData[1]);
            PiVector pickedVertexInd = null;
            if (!this.isEnabledTags() || (pickedVertexInd = this.m_currentGeom.getTaggedVertices()) == null || pickedVertexInd.getSize() == 0) {
                this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, worldData[0]);
            } else {
                PdVector offset = PdVector.copyNew(worldData[0]);
                offset.setSize(this.m_currentGeom.getDimOfVertices());
                offset.sub(this.m_currentGeom.getVertex(this.m_pickedVertex));
                int size = pickedVertexInd.getSize();
                int i = 0;
                while (i < size) {
                    int vertInd = pickedVertexInd.getEntry(i);
                    PdVector v = this.m_currentGeom.getVertex(vertInd);
                    v.add(offset);
                    this.m_currentGeom.setGeometryVertex(vertInd, v);
                    ++i;
                }
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.dragVertex(this.m_geomIf, this.m_pickedVertex, worldData[0]);
            } else if (this.m_pickListener != null) {
                Enumeration e = this.m_pickListener.elements();
                while (e.hasMoreElements()) {
                    ((PvPickListenerIf)e.nextElement()).dragVertex(this.m_geomIf, this.m_pickedVertex, worldData[0]);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
        } else if (this.m_mode != 9 && this.m_mode != 10 && this.m_mode != 2 && this.m_mode != 11) {
            if (this.getTransformationMode() == 0) {
                this.m_currentCamera.mouseDragged(x, y, this.m_bMouseShiftConstraint);
                this.m_currentCamera.updatePanels(this.m_currentCamera);
            } else {
                this.m_modelCamera.mouseDragged(x, y, this.m_bMouseShiftConstraint);
                this.m_modelCamera.updatePanels(this.m_modelCamera);
            }
            this.updateCameraListener(102);
            this.bDrag = true;
        }
        this.repaint();
    }

    public boolean isShowingMagnet() {
        return this.hasPaintTag(4096);
    }

    public void showMagnet(boolean aFlag) {
        if (!aFlag && this.m_pickedVertex != -1 && this.m_currentGeom != null) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex);
        }
        this.m_pickedVertex = -1;
        this.setPaintTag(4096, aFlag);
    }

    public int addCamera(String aName, PvCamera aCamera) {
        if (aName == null || aCamera == null) {
            PsDebug.warning("missing arguments", this);
            return -1;
        }
        int key = -1;
        int i = 0;
        while (i < PvDisplayIf.CAMERA_NAME.length) {
            if (PvDisplayIf.CAMERA_NAME[i].equals(aName)) {
                key = i;
                break;
            }
            ++i;
        }
        if (key == -1) {
            return -1;
        }
        this.m_camera.put(aName, aCamera);
        aCamera.setParent(this);
        aCamera.setName(aName);
        return key;
    }

    private void glowBndbox(boolean state) {
        if (this.m_bIsGlowingBndbox == state) {
            return;
        }
        if (state) {
            this.m_bSaveShowingBndbox = this.isShowingBndBox();
        }
        this.m_bIsGlowingBndbox = state;
        if (this.m_bSaveShowingBndbox) {
            return;
        }
        this.showBndBox(state);
        this.repaint();
    }

    public void setMajorMode(int mode) {
        this.m_defModeMajor = mode;
        this.setCurrentMajorMode(this.m_defModeMajor);
    }

    public int getMajorMode() {
        return this.m_mode;
    }

    protected int getTransformationMode() {
        return this.m_transformationMode;
    }

    protected void setTransformationMode(int mode) {
        this.m_transformationMode = mode;
        if (this.m_transformationMode == 0) {
            this.m_modelCamera = null;
            return;
        }
        if (this.m_modelCamera == null) {
            this.m_modelCamera = new PvModelCamera(this);
        }
        this.m_modelCamera.setTransformationMode(this.m_transformationMode);
        this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        if (this.m_currentGeom == null) {
            return;
        }
        if (this.m_transformationMode != 0) {
            this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
        }
        if (this.m_transformationMode == 2) {
            this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
        }
        if (this.isShowingFrame() && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
            this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
            this.update(this.m_coordFrame);
        }
    }

    public void setEnabledZBuffer(boolean aFlag) {
        this.m_bEnableZBuffer = aFlag;
        this.m_bSaveEnableZBuffer = aFlag;
        if (aFlag) {
            this.assureZBuffer(this.m_nWidth, this.m_nHeight);
        } else {
            this.m_zBuffer = null;
        }
    }

    protected int[][] getZBuffer() {
        return this.m_zBuffer;
    }

    protected void resetZBuffer() {
        this.assureZBuffer(this.m_nWidth, this.m_nHeight);
        int i = 0;
        while (i < this.m_nHeight) {
            System.arraycopy(this.m_zBuffer[this.m_nHeight], 0, this.m_zBuffer[i], 0, this.m_nWidth);
            ++i;
        }
    }

    public void setEnabledFastZBuffer(boolean aFlag) {
        this.m_bEnableFastZBuffer = aFlag;
    }

    private void assureZBuffer(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.m_zBuffer != null && this.m_zBuffer.length == height + 1 && this.m_zBuffer[0].length == width) {
            return;
        }
        this.m_zBuffer = new int[height + 1][width];
        int i = 0;
        while (i < width) {
            this.m_zBuffer[height][i] = Integer.MIN_VALUE;
            ++i;
        }
    }

    public Dimension getMinimumSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 350;
        dim.height = 350;
        return dim;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 350;
        dim.height = 350;
        return dim;
    }

    protected PvGeometry[] getGeometryContainers() {
        PvGeometry[] geomList = this.getAllGeometryContainers();
        if (geomList == null) {
            return null;
        }
        int num = geomList.length - this.m_specialGeom.size();
        if (num == 0) {
            return null;
        }
        if (num < 0) {
            PsDebug.warning("special geometries not unregistered.");
            return null;
        }
        PvGeometry[] regGeom = new PvGeometry[num];
        int ind = 0;
        int i = 0;
        while (i < geomList.length) {
            if (!this.m_specialGeom.contains(geomList[i].getGeometry())) {
                regGeom[ind++] = geomList[i];
            }
            ++i;
        }
        return regGeom;
    }
}

